<?php
/**
 * Aliases for Special:CategoryTree
 *
 * @addtogroup Extensions
 * @author Daniel Kinzler, brightbyte.de
 * @copyright © 2006-2008 Daniel Kinzler and others
 * @license GNU General Public Licence 2.0 or later
 */

$aliases = array();

/** English
 * @author Daniel Kinzler, brightbyte.de
 */
$aliases['en'] = array(
	'CategoryTree' => array( 'CategoryTree' ),
);

/** Aragonese (Aragonés) */
$aliases['an'] = array(
	'CategoryTree' => array( 'Árbol de categorías' ),
);

/** Arabic (العربية)
 * @author Meno25
 */
$aliases['ar'] = array(
	'CategoryTree' => array( 'شجرة_تصنيف' ),
);

/** Egyptian Spoken Arabic (مصرى)
 * @author Meno25
 */
$aliases['arz'] = array(
	'CategoryTree' => array( 'شجرة_تصنيف' ),
);

/** Bikol Central (Bikol Central) */
$aliases['bcl'] = array(
	'CategoryTree' => array( 'KahoyNinKategorya' ),
);

/** Belarusian (Taraškievica orthography) (Беларуская (тарашкевіца)) */
$aliases['be-tarask'] = array(
	'CategoryTree' => array( 'Дрэва_катэгорыяў' ),
);

/** Bulgarian (Български) */
$aliases['bg'] = array(
	'CategoryTree' => array( 'Дърво на категориите' ),
);

/** Bosnian (Bosanski) */
$aliases['bs'] = array(
	'CategoryTree' => array( 'StabloKategorija' ),
);

/** Catalan (Català) */
$aliases['ca'] = array(
	'CategoryTree' => array( 'Categories en arbre', 'Arbre de categories' ),
);

/** Danish (Dansk) */
$aliases['da'] = array(
	'CategoryTree' => array( 'Kategoritræ' ),
);

/** German (Deutsch)
 * @author Daniel Kinzler, brightbyte.de
 */
$aliases['de'] = array(
	'CategoryTree' => array( 'Kategorienbaum', 'Kategoriebaum' ),
);

/** Lower Sorbian (Dolnoserbski) */
$aliases['dsb'] = array(
	'CategoryTree' => array( 'Kategorijow bom' ),
);

/** Greek (Ελληνικά) */
$aliases['el'] = array(
	'CategoryTree' => array( 'ΔέντροΚατηγορίας' ),
);

/** Spanish (Español) */
$aliases['es'] = array(
	'CategoryTree' => array( 'ÁrbolDeCategorías', 'Árbol de categorías' ),
);

/** Basque (Euskara) */
$aliases['eu'] = array(
	'CategoryTree' => array( 'KategoriaZuhaitza' ),
);

/** Persian (فارسی) */
$aliases['fa'] = array(
	'CategoryTree' => array( 'درخت_رده' ),
);

/** Finnish (Suomi) */
$aliases['fi'] = array(
	'CategoryTree' => array( 'Luokkapuu' ),
);

/** French (Français) */
$aliases['fr'] = array(
	'CategoryTree' => array( 'ArbreCatégorie', 'ArbreCategorie', 'Arbre catégorie' ),
);

/** Galician (Galego) */
$aliases['gl'] = array(
	'CategoryTree' => array( 'Árbore de categorías' ),
);

/** Swiss German (Alemannisch) */
$aliases['gsw'] = array(
	'CategoryTree' => array( 'Kategoriebaum' ),
);

/** Hebrew (עברית)
 * @author Rotem Liss
 */
$aliases['he'] = array(
	'CategoryTree' => array( 'עץ_קטגוריות' ),
);

/** Upper Sorbian (Hornjoserbsce) */
$aliases['hsb'] = array(
	'CategoryTree' => array( 'Kategorijowy štom' ),
);

/** Haitian (Kreyòl ayisyen) */
$aliases['ht'] = array(
	'CategoryTree' => array( 'KategoriPlant' ),
);

/** Hungarian (Magyar) */
$aliases['hu'] = array(
	'CategoryTree' => array( 'Kategóriafa' ),
);

/** Interlingua (Interlingua) */
$aliases['ia'] = array(
	'CategoryTree' => array( 'Arbore de categorias' ),
);

/** Indonesian (Bahasa Indonesia) */
$aliases['id'] = array(
	'CategoryTree' => array( 'Pohon kategori' ),
);

/** Japanese (日本語) */
$aliases['ja'] = array(
	'CategoryTree' => array( 'カテゴリツリー' ),
);

/** Khmer (ភាសាខ្មែរ) */
$aliases['km'] = array(
	'CategoryTree' => array( 'មែកធាងចំណាត់ថ្នាក់ក្រុម' ),
);

/** Korean (한국어) */
$aliases['ko'] = array(
	'CategoryTree' => array( '분류트리' ),
);

/** Ripoarisch (Ripoarisch) */
$aliases['ksh'] = array(
	'CategoryTree' => array( 'Saachjruppeboum' ),
);

/** Latin (Latina) */
$aliases['la'] = array(
	'CategoryTree' => array( 'Categoriarum arbor' ),
);

/** Luxembourgish (Lëtzebuergesch) */
$aliases['lb'] = array(
	'CategoryTree' => array( 'Struktur vun de Kategorien' ),
);

/** Macedonian (Македонски) */
$aliases['mk'] = array(
	'CategoryTree' => array( 'ДрвоНаКатегории' ),
);

/** Malay (Bahasa Melayu) */
$aliases['ms'] = array(
	'CategoryTree' => array( 'Salasilah kategori' ),
);

/** Maltese (Malti) */
$aliases['mt'] = array(
	'CategoryTree' => array( 'SiġraKategorika' ),
);

/** Erzya (Эрзянь) */
$aliases['myv'] = array(
	'CategoryTree' => array( 'КатегорияньЧувто' ),
);

/** Low German (Plattdüütsch) */
$aliases['nds'] = array(
	'CategoryTree' => array( 'Kategorieboom' ),
);

/** Nedersaksisch (Nedersaksisch) */
$aliases['nds-nl'] = array(
	'CategoryTree' => array( 'Kattegerieboom' ),
);

/** Dutch (Nederlands) */
$aliases['nl'] = array(
	'CategoryTree' => array( 'Categorieboom' ),
);

/** Norwegian Nynorsk (‪Norsk (nynorsk)‬) */
$aliases['nn'] = array(
	'CategoryTree' => array( 'Kategoritre' ),
);

/** Norwegian (bokmål)‬ (‪Norsk (bokmål)‬) */
$aliases['no'] = array(
	'CategoryTree' => array( 'Kategoritre' ),
);

/** Occitan (Occitan) */
$aliases['oc'] = array(
	'CategoryTree' => array( 'ArbreCategoria', 'Arbre categoria' ),
);

/** Polish (Polski) */
$aliases['pl'] = array(
	'CategoryTree' => array( 'Drzewo kategorii' ),
);

/** Pashto (پښتو) */
$aliases['ps'] = array(
	'CategoryTree' => array( 'د وېشنيزو ونه' ),
);

/** Portuguese (Português) */
$aliases['pt'] = array(
	'CategoryTree' => array( 'Árvore de categorias', 'Árvore de categoria' ),
);

/** Brazilian Portuguese (Português do Brasil) */
$aliases['pt-br'] = array(
	'CategoryTree' => array( 'Árvore de categorias', 'Árvore de categoria' ),
);

/** Romanian (Română) */
$aliases['ro'] = array(
	'CategoryTree' => array( 'Arborele categoriilor' ),
);

/** Sanskrit (संस्कृत) */
$aliases['sa'] = array(
	'CategoryTree' => array( 'वर्गवृक्ष:' ),
);

/** Swedish (Svenska) */
$aliases['sv'] = array(
	'CategoryTree' => array( 'Kategoriträd' ),
);

/** Swahili (Kiswahili) */
$aliases['sw'] = array(
	'CategoryTree' => array( 'SafuyaJamii' ),
);

/** Tagalog (Tagalog) */
$aliases['tl'] = array(
	'CategoryTree' => array( 'Puno ng kaurian' ),
);

/** Turkish (Türkçe) */
$aliases['tr'] = array(
	'CategoryTree' => array( 'KategoriHiyerarşisi' ),
);

/** Vèneto (Vèneto) */
$aliases['vec'] = array(
	'CategoryTree' => array( 'ÀlbaroCategorie' ),
);

/** Yiddish (ייִדיש) */
$aliases['yi'] = array(
	'CategoryTree' => array( 'קאטעגאריע בוים' ),
);

