/*
 * JavaScript for Special:JavaScriptTest
 */
jQuery( document ).ready( function( $ ) {

	// Create useskin dropdown menu and reload onchange to the selected skin
	// (only if a framework was found, not on error pages).
	$( '#mw-javascripttest-summary.mw-javascripttest-frameworkfound' ).append( function() {

		var	$html = $( '<p><label for="useskin">'
				+ mw.message( 'javascripttest-pagetext-skins' ).escaped()
				+ ' '
				+ '</label></p>' ),
			select = '<select name="useskin" id="useskin">';

		// Build <select> further
		$.each( mw.config.get( 'wgAvailableSkins' ), function( id ) {
			select += '<option value="' + id + '"'
				+ ( mw.config.get( 'skin' ) === id ? ' selected="selected"' : '' )
				+ '>' + mw.message( 'skinname-' + id ).escaped() + '</option>';
		} );
		select += '</select>';

		// Bind onchange event handler and append to form
		$html.append(
			$( select ).change( function() {
				window.location = QUnit.url( { useskin: $(this).val() } );
			} )
		);

		return $html;
	} );
} );
