/*!
 * VisualEditor DataModel FakeCommentNode class.
 *
 * @copyright 2011-2020 VisualEditor Team and others; see http://ve.mit-license.org
 */

/**
 * Fake comments generated by the converter for the clipboard
 *
 * `<span rel="ve:Comment">` is used to to preserve
 * comments in the clipboard
 *
 * @class
 * @extends ve.dm.CommentNode
 *
 * @constructor
 * @param {Object} element Reference to element in meta-linmod
 */
ve.dm.FakeCommentNode = function VeDmFakeCommentNode() {
	ve.dm.FakeCommentNode.super.apply( this, arguments );
};

/* Inheritance */

OO.inheritClass( ve.dm.FakeCommentNode, ve.dm.CommentNode );

/* Static Properties */

ve.dm.FakeCommentNode.static.name = 'fakeComment';

ve.dm.FakeCommentNode.static.matchRdfaTypes = [ 've:Comment' ];

/* Registration */

ve.dm.modelRegistry.register( ve.dm.FakeCommentNode );
