/* This file is autogenerated from gtktextregion.h */
#line 1 "/home/muntyan/projects/moo/moo/mooedit/gtksourceview/upstream/gtktextregion.h"
/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*-
 *
 * gtktextregion.h - GtkTextMark based region utility functions
 *
 * This file is part of the MooGtkSourceView widget
 *
 * Copyright (C) 2002 Gustavo Girldez <gustavo.giraldez@gmx.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __GTK_TEXT_REGION_H__
#define __GTK_TEXT_REGION_H__

#include <gtk/gtktextbuffer.h>

G_BEGIN_DECLS

typedef struct _MooGtkTextRegion		MooGtkTextRegion;
typedef struct _MooGtkTextRegionIterator	MooGtkTextRegionIterator;

struct _MooGtkTextRegionIterator {
	/* MooGtkTextRegionIterator is an opaque datatype; ignore all these fields.
	 * Initialize the iter with _moo_gtk_text_region_get_iterator
	 * function
	 */
	/*< private >*/
	gpointer dummy1;
	guint32  dummy2;
	gpointer dummy3;
};

MooGtkTextRegion *_moo_gtk_text_region_new                          (GtkTextBuffer *buffer);
void           _moo_gtk_text_region_destroy                      (MooGtkTextRegion *region,
							     gboolean       delete_marks);

GtkTextBuffer *_moo_gtk_text_region_get_buffer                   (MooGtkTextRegion *region);

void           _moo_gtk_text_region_add                          (MooGtkTextRegion     *region,
							     const GtkTextIter *_start,
							     const GtkTextIter *_end);

void           _moo_gtk_text_region_subtract                     (MooGtkTextRegion     *region,
							     const GtkTextIter *_start,
							     const GtkTextIter *_end);

gint           _moo_gtk_text_region_subregions                   (MooGtkTextRegion *region);

gboolean       _moo_gtk_text_region_nth_subregion                (MooGtkTextRegion *region,
							     guint          subregion,
							     GtkTextIter   *start,
							     GtkTextIter   *end);

MooGtkTextRegion *_moo_gtk_text_region_intersect                    (MooGtkTextRegion     *region,
							     const GtkTextIter *_start,
							     const GtkTextIter *_end);

void           _moo_gtk_text_region_get_iterator                 (MooGtkTextRegion         *region,
                                                             MooGtkTextRegionIterator *iter,
                                                             guint                  start);

gboolean       _moo_gtk_text_region_iterator_is_end              (MooGtkTextRegionIterator *iter);

/* Returns FALSE if iterator is the end iterator */
gboolean       _moo_gtk_text_region_iterator_next	            (MooGtkTextRegionIterator *iter);

void           _moo_gtk_text_region_iterator_get_subregion       (MooGtkTextRegionIterator *iter,
							     GtkTextIter           *start,
							     GtkTextIter           *end);

void           _moo_gtk_text_region_debug_print                  (MooGtkTextRegion *region);

G_END_DECLS

#endif /* __GTK_TEXT_REGION_H__ */
