#ifndef _MDFN_MEMORY_H
void *MDFN_malloc(uint32 size);
void *MDFN_gmalloc(uint32 size);
void MDFN_gfree(void *ptr);
void MDFN_free(void *ptr);

#define MDFN_dwmemset(d,c,n) {int _x; int _tc = c | (c<<8) | (c<<16) | (c<<24); for(_x=(n)-4;_x>=0;_x-=4) *(uint32 *)&(d)[_x]=_tc;}

static INLINE void MDFN_FastU32MemsetM8(uint32 *array, uint32 value_32, unsigned int u32len)
{
 // gcc's optimizer is smart enough to use the floating-point unit to do this memset
 // on non-64-bit processors, at least on x86.
 uint64 value = (uint64)value_32 | ((uint64)value_32 << 32);
 uint64 *newarray = (uint64 *)array;

 u32len >>= 1;
 for(unsigned int i = 0; i < u32len; i++)
  *newarray++ = value;
}
#define _MDFN_MEMORY_H
#endif
