#ifndef _PCE_DEBUG_H
#define _PCE_DEBUG_H

void PCEDBG_SetCPUCallback(void (*callb)(uint32 PC));
void PCEDBG_SetBPCallback(void (*callb)(uint32 PC));

void PCEDBG_FlushBreakPoints(int type);
void PCEDBG_AddBreakPoint(int type, unsigned int A1, unsigned int A2, bool logical);

uint32 PCEDBG_MemPeek(uint32 A, unsigned int bsize, bool hl, bool logical);
void PCEDBG_MemPoke(uint32 A, uint32 V, unsigned int bsize, bool, bool logical);
void PCEDBG_IRQ(int level);
uint32 PCEDBG_GetVector(int level);
std::string PCEDBG_Disassemble(uint32 &a, uint32 SpecialA);
uint32 PCEDBG_GetRegister(std::string name);
void PCEDBG_SetRegister(std::string name, uint32 value);

void PCEDBG_TestFoundBPoint(void);
void PCEDBG_AddBranchTrace(uint32 PC);
std::vector<uint32> PCEDBG_GetBranchTrace(void);

#endif
