#ifdef SMPCORE_CPP

// perl -p -i -e "s/op\[(.{4})\] = \&SMP::([^;]*);/case \1: \2(); break;/" table.cpp

void SMP::do_op(uint8 opv)
{
 switch(opv)
 {
  case 0x00: op_nop(); break;
  case 0x01: op_tcall<0>(); break;
  case 0x02: op_setbit_dp<1, 0x01>(); break;
  case 0x03: op_bitbranch<0x01, true>(); break;
  case 0x04: op_read_reg_dp<&SMP::op_or, A>(); break;
  case 0x05: op_read_reg_addr<&SMP::op_or, A>(); break;
  case 0x06: op_read_a_ix<&SMP::op_or>(); break;
  case 0x07: op_read_a_idpx<&SMP::op_or>(); break;
  case 0x08: op_read_reg_const<&SMP::op_or, A>(); break;
  case 0x09: op_read_dp_dp<&SMP::op_or>(); break;
  case 0x0a: op_or1_bit<0>(); break;
  case 0x0b: op_adjust_dp<&SMP::op_asl>(); break;
  case 0x0c: op_adjust_addr<&SMP::op_asl>(); break;
  case 0x0d: op_push_p(); break;
  case 0x0e: op_adjust_addr_a<1>(); break;
  case 0x0f: op_brk(); break;
  case 0x10: op_branch<0x80, false>(); break;
  case 0x11: op_tcall<1>(); break;
  case 0x12: op_setbit_dp<0, 0x01>(); break;
  case 0x13: op_bitbranch<0x01, false>(); break;
  case 0x14: op_read_a_dpx<&SMP::op_or>(); break;
  case 0x15: op_read_a_addrr<&SMP::op_or, X>(); break;
  case 0x16: op_read_a_addrr<&SMP::op_or, Y>(); break;
  case 0x17: op_read_a_idpy<&SMP::op_or>(); break;
  case 0x18: op_read_dp_const<&SMP::op_or>(); break;
  case 0x19: op_read_ix_iy<&SMP::op_or>(); break;
  case 0x1a: op_adjustw_dp<-1>(); break;
  case 0x1b: op_adjust_dpx<&SMP::op_asl>(); break;
  case 0x1c: op_adjust_reg<&SMP::op_asl, A>(); break;
  case 0x1d: op_adjust_reg<&SMP::op_dec, X>(); break;
  case 0x1e: op_read_reg_addr<&SMP::op_cmp, X>(); break;
  case 0x1f: op_jmp_iaddrx(); break;
  case 0x20: op_setbit<0x20, 0x00>(); break;
  case 0x21: op_tcall<2>(); break;
  case 0x22: op_setbit_dp<1, 0x02>(); break;
  case 0x23: op_bitbranch<0x02, true>(); break;
  case 0x24: op_read_reg_dp<&SMP::op_and, A>(); break;
  case 0x25: op_read_reg_addr<&SMP::op_and, A>(); break;
  case 0x26: op_read_a_ix<&SMP::op_and>(); break;
  case 0x27: op_read_a_idpx<&SMP::op_and>(); break;
  case 0x28: op_read_reg_const<&SMP::op_and, A>(); break;
  case 0x29: op_read_dp_dp<&SMP::op_and>(); break;
  case 0x2a: op_or1_bit<1>(); break;
  case 0x2b: op_adjust_dp<&SMP::op_rol>(); break;
  case 0x2c: op_adjust_addr<&SMP::op_rol>(); break;
  case 0x2d: op_push_reg<A>(); break;
  case 0x2e: op_cbne_dp(); break;
  case 0x2f: op_bra(); break;
  case 0x30: op_branch<0x80, true>(); break;
  case 0x31: op_tcall<3>(); break;
  case 0x32: op_setbit_dp<0, 0x02>(); break;
  case 0x33: op_bitbranch<0x02, false>(); break;
  case 0x34: op_read_a_dpx<&SMP::op_and>(); break;
  case 0x35: op_read_a_addrr<&SMP::op_and, X>(); break;
  case 0x36: op_read_a_addrr<&SMP::op_and, Y>(); break;
  case 0x37: op_read_a_idpy<&SMP::op_and>(); break;
  case 0x38: op_read_dp_const<&SMP::op_and>(); break;
  case 0x39: op_read_ix_iy<&SMP::op_and>(); break;
  case 0x3a: op_adjustw_dp<+1>(); break;
  case 0x3b: op_adjust_dpx<&SMP::op_rol>(); break;
  case 0x3c: op_adjust_reg<&SMP::op_rol, A>(); break;
  case 0x3d: op_adjust_reg<&SMP::op_inc, X>(); break;
  case 0x3e: op_read_reg_dp<&SMP::op_cmp, X>(); break;
  case 0x3f: op_call(); break;
  case 0x40: op_setbit<0x20, 0x20>(); break;
  case 0x41: op_tcall<4>(); break;
  case 0x42: op_setbit_dp<1, 0x04>(); break;
  case 0x43: op_bitbranch<0x04, true>(); break;
  case 0x44: op_read_reg_dp<&SMP::op_eor, A>(); break;
  case 0x45: op_read_reg_addr<&SMP::op_eor, A>(); break;
  case 0x46: op_read_a_ix<&SMP::op_eor>(); break;
  case 0x47: op_read_a_idpx<&SMP::op_eor>(); break;
  case 0x48: op_read_reg_const<&SMP::op_eor, A>(); break;
  case 0x49: op_read_dp_dp<&SMP::op_eor>(); break;
  case 0x4a: op_and1_bit<0>(); break;
  case 0x4b: op_adjust_dp<&SMP::op_lsr>(); break;
  case 0x4c: op_adjust_addr<&SMP::op_lsr>(); break;
  case 0x4d: op_push_reg<X>(); break;
  case 0x4e: op_adjust_addr_a<0>(); break;
  case 0x4f: op_pcall(); break;
  case 0x50: op_branch<0x40, false>(); break;
  case 0x51: op_tcall<5>(); break;
  case 0x52: op_setbit_dp<0, 0x04>(); break;
  case 0x53: op_bitbranch<0x04, false>(); break;
  case 0x54: op_read_a_dpx<&SMP::op_eor>(); break;
  case 0x55: op_read_a_addrr<&SMP::op_eor, X>(); break;
  case 0x56: op_read_a_addrr<&SMP::op_eor, Y>(); break;
  case 0x57: op_read_a_idpy<&SMP::op_eor>(); break;
  case 0x58: op_read_dp_const<&SMP::op_eor>(); break;
  case 0x59: op_read_ix_iy<&SMP::op_eor>(); break;
  case 0x5a: op_cmpw_ya_dp(); break;
  case 0x5b: op_adjust_dpx<&SMP::op_lsr>(); break;
  case 0x5c: op_adjust_reg<&SMP::op_lsr, A>(); break;
  case 0x5d: op_mov_reg_reg<X, A>(); break;
  case 0x5e: op_read_reg_addr<&SMP::op_cmp, Y>(); break;
  case 0x5f: op_jmp_addr(); break;
  case 0x60: op_setbit<0x01, 0x00>(); break;
  case 0x61: op_tcall<6>(); break;
  case 0x62: op_setbit_dp<1, 0x08>(); break;
  case 0x63: op_bitbranch<0x08, true>(); break;
  case 0x64: op_read_reg_dp<&SMP::op_cmp, A>(); break;
  case 0x65: op_read_reg_addr<&SMP::op_cmp, A>(); break;
  case 0x66: op_read_a_ix<&SMP::op_cmp>(); break;
  case 0x67: op_read_a_idpx<&SMP::op_cmp>(); break;
  case 0x68: op_read_reg_const<&SMP::op_cmp, A>(); break;
  case 0x69: op_read_dp_dp<&SMP::op_cmp>(); break;
  case 0x6a: op_and1_bit<1>(); break;
  case 0x6b: op_adjust_dp<&SMP::op_ror>(); break;
  case 0x6c: op_adjust_addr<&SMP::op_ror>(); break;
  case 0x6d: op_push_reg<Y>(); break;
  case 0x6e: op_dbnz_dp(); break;
  case 0x6f: op_ret(); break;
  case 0x70: op_branch<0x40, true>(); break;
  case 0x71: op_tcall<7>(); break;
  case 0x72: op_setbit_dp<0, 0x08>(); break;
  case 0x73: op_bitbranch<0x08, false>(); break;
  case 0x74: op_read_a_dpx<&SMP::op_cmp>(); break;
  case 0x75: op_read_a_addrr<&SMP::op_cmp, X>(); break;
  case 0x76: op_read_a_addrr<&SMP::op_cmp, Y>(); break;
  case 0x77: op_read_a_idpy<&SMP::op_cmp>(); break;
  case 0x78: op_read_dp_const<&SMP::op_cmp>(); break;
  case 0x79: op_read_ix_iy<&SMP::op_cmp>(); break;
  case 0x7a: op_read_ya_dp<&SMP::op_addw>(); break;
  case 0x7b: op_adjust_dpx<&SMP::op_ror>(); break;
  case 0x7c: op_adjust_reg<&SMP::op_ror, A>(); break;
  case 0x7d: op_mov_reg_reg<A, X>(); break;
  case 0x7e: op_read_reg_dp<&SMP::op_cmp, Y>(); break;
  case 0x7f: op_reti(); break;
  case 0x80: op_setbit<0x01, 0x01>(); break;
  case 0x81: op_tcall<8>(); break;
  case 0x82: op_setbit_dp<1, 0x10>(); break;
  case 0x83: op_bitbranch<0x10, true>(); break;
  case 0x84: op_read_reg_dp<&SMP::op_adc, A>(); break;
  case 0x85: op_read_reg_addr<&SMP::op_adc, A>(); break;
  case 0x86: op_read_a_ix<&SMP::op_adc>(); break;
  case 0x87: op_read_a_idpx<&SMP::op_adc>(); break;
  case 0x88: op_read_reg_const<&SMP::op_adc, A>(); break;
  case 0x89: op_read_dp_dp<&SMP::op_adc>(); break;
  case 0x8a: op_eor1_bit(); break;
  case 0x8b: op_adjust_dp<&SMP::op_dec>(); break;
  case 0x8c: op_adjust_addr<&SMP::op_dec>(); break;
  case 0x8d: op_mov_reg_const<Y>(); break;
  case 0x8e: op_pop_p(); break;
  case 0x8f: op_mov_dp_const(); break;
  case 0x90: op_branch<0x01, false>(); break;
  case 0x91: op_tcall<9>(); break;
  case 0x92: op_setbit_dp<0, 0x10>(); break;
  case 0x93: op_bitbranch<0x10, false>(); break;
  case 0x94: op_read_a_dpx<&SMP::op_adc>(); break;
  case 0x95: op_read_a_addrr<&SMP::op_adc, X>(); break;
  case 0x96: op_read_a_addrr<&SMP::op_adc, Y>(); break;
  case 0x97: op_read_a_idpy<&SMP::op_adc>(); break;
  case 0x98: op_read_dp_const<&SMP::op_adc>(); break;
  case 0x99: op_read_ix_iy<&SMP::op_adc>(); break;
  case 0x9a: op_read_ya_dp<&SMP::op_subw>(); break;
  case 0x9b: op_adjust_dpx<&SMP::op_dec>(); break;
  case 0x9c: op_adjust_reg<&SMP::op_dec, A>(); break;
  case 0x9d: op_mov_reg_reg<X, SP>(); break;
  case 0x9e: op_div_ya_x(); break;
  case 0x9f: op_xcn(); break;
  case 0xa0: op_seti<1>(); break;
  case 0xa1: op_tcall<10>(); break;
  case 0xa2: op_setbit_dp<1, 0x20>(); break;
  case 0xa3: op_bitbranch<0x20, true>(); break;
  case 0xa4: op_read_reg_dp<&SMP::op_sbc, A>(); break;
  case 0xa5: op_read_reg_addr<&SMP::op_sbc, A>(); break;
  case 0xa6: op_read_a_ix<&SMP::op_sbc>(); break;
  case 0xa7: op_read_a_idpx<&SMP::op_sbc>(); break;
  case 0xa8: op_read_reg_const<&SMP::op_sbc, A>(); break;
  case 0xa9: op_read_dp_dp<&SMP::op_sbc>(); break;
  case 0xaa: op_mov1_c_bit(); break;
  case 0xab: op_adjust_dp<&SMP::op_inc>(); break;
  case 0xac: op_adjust_addr<&SMP::op_inc>(); break;
  case 0xad: op_read_reg_const<&SMP::op_cmp, Y>(); break;
  case 0xae: op_pop_reg<A>(); break;
  case 0xaf: op_mov_ixinc_a(); break;
  case 0xb0: op_branch<0x01, true>(); break;
  case 0xb1: op_tcall<11>(); break;
  case 0xb2: op_setbit_dp<0, 0x20>(); break;
  case 0xb3: op_bitbranch<0x20, false>(); break;
  case 0xb4: op_read_a_dpx<&SMP::op_sbc>(); break;
  case 0xb5: op_read_a_addrr<&SMP::op_sbc, X>(); break;
  case 0xb6: op_read_a_addrr<&SMP::op_sbc, Y>(); break;
  case 0xb7: op_read_a_idpy<&SMP::op_sbc>(); break;
  case 0xb8: op_read_dp_const<&SMP::op_sbc>(); break;
  case 0xb9: op_read_ix_iy<&SMP::op_sbc>(); break;
  case 0xba: op_movw_ya_dp(); break;
  case 0xbb: op_adjust_dpx<&SMP::op_inc>(); break;
  case 0xbc: op_adjust_reg<&SMP::op_inc, A>(); break;
  case 0xbd: op_mov_sp_x(); break;
  case 0xbe: op_das(); break;
  case 0xbf: op_mov_a_ixinc(); break;
  case 0xc0: op_seti<0>(); break;
  case 0xc1: op_tcall<12>(); break;
  case 0xc2: op_setbit_dp<1, 0x40>(); break;
  case 0xc3: op_bitbranch<0x40, true>(); break;
  case 0xc4: op_mov_dp_reg<A>(); break;
  case 0xc5: op_mov_addr_reg<A>(); break;
  case 0xc6: op_mov_ix_a(); break;
  case 0xc7: op_mov_idpx_a(); break;
  case 0xc8: op_read_reg_const<&SMP::op_cmp, X>(); break;
  case 0xc9: op_mov_addr_reg<X>(); break;
  case 0xca: op_mov1_bit_c(); break;
  case 0xcb: op_mov_dp_reg<Y>(); break;
  case 0xcc: op_mov_addr_reg<Y>(); break;
  case 0xcd: op_mov_reg_const<X>(); break;
  case 0xce: op_pop_reg<X>(); break;
  case 0xcf: op_mul_ya(); break;
  case 0xd0: op_branch<0x02, false>(); break;
  case 0xd1: op_tcall<13>(); break;
  case 0xd2: op_setbit_dp<0, 0x40>(); break;
  case 0xd3: op_bitbranch<0x40, false>(); break;
  case 0xd4: op_mov_dpr_reg<A, X>(); break;
  case 0xd5: op_mov_addrr_a<X>(); break;
  case 0xd6: op_mov_addrr_a<Y>(); break;
  case 0xd7: op_mov_idpy_a(); break;
  case 0xd8: op_mov_dp_reg<X>(); break;
  case 0xd9: op_mov_dpr_reg<X, Y>(); break;
  case 0xda: op_movw_dp_ya(); break;
  case 0xdb: op_mov_dpr_reg<Y, X>(); break;
  case 0xdc: op_adjust_reg<&SMP::op_dec, Y>(); break;
  case 0xdd: op_mov_reg_reg<A, Y>(); break;
  case 0xde: op_cbne_dpx(); break;
  case 0xdf: op_daa(); break;
  case 0xe0: op_setbit<0x48, 0x00>(); break;
  case 0xe1: op_tcall<14>(); break;
  case 0xe2: op_setbit_dp<1, 0x80>(); break;
  case 0xe3: op_bitbranch<0x80, true>(); break;
  case 0xe4: op_mov_reg_dp<A>(); break;
  case 0xe5: op_mov_reg_addr<A>(); break;
  case 0xe6: op_mov_a_ix(); break;
  case 0xe7: op_mov_a_idpx(); break;
  case 0xe8: op_mov_reg_const<A>(); break;
  case 0xe9: op_mov_reg_addr<X>(); break;
  case 0xea: op_not1_bit(); break;
  case 0xeb: op_mov_reg_dp<Y>(); break;
  case 0xec: op_mov_reg_addr<Y>(); break;
  case 0xed: op_notc(); break;
  case 0xee: op_pop_reg<Y>(); break;
  case 0xef: op_wait(); break;
  case 0xf0: op_branch<0x02, true>(); break;
  case 0xf1: op_tcall<15>(); break;
  case 0xf2: op_setbit_dp<0, 0x80>(); break;
  case 0xf3: op_bitbranch<0x80, false>(); break;
  case 0xf4: op_mov_reg_dpr<A, X>(); break;
  case 0xf5: op_mov_a_addrr<X>(); break;
  case 0xf6: op_mov_a_addrr<Y>(); break;
  case 0xf7: op_mov_a_idpy(); break;
  case 0xf8: op_mov_reg_dp<X>(); break;
  case 0xf9: op_mov_reg_dpr<X, Y>(); break;
  case 0xfa: op_mov_dp_dp(); break;
  case 0xfb: op_mov_reg_dpr<Y, X>(); break;
  case 0xfc: op_adjust_reg<&SMP::op_inc, Y>(); break;
  case 0xfd: op_mov_reg_reg<Y, A>(); break;
  case 0xfe: op_dbnz_y(); break;
  case 0xff: op_wait(); break;
 }
}

#endif
