/*
 * mednaffe_glade.h
 * 
 * Copyright 2013-2015 AmatCoder
 * 
 * This file is part of Mednaffe.
 * 
 * Mednaffe is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * Mednaffe is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with Mednaffe; if not, see <http://www.gnu.org/licenses/>.
 * 
 */
 
#ifndef MEDNAFFE_GLADE_H
#define MEDNAFFE_GLADE_H

static const char *mednaffe_glade =
"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"
"<interface>\n"
"<requires lib=\"gtk+\" version=\"2.18\"/>\n"
"<!-- interface-naming-policy toplevel-contextual -->\n"
"<object class=\"GtkImage\" id=\"add_image\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"stock\">gtk-add</property>\n"
"</object>\n"
"<object class=\"GtkAdjustment\" id=\"adjautofire\">\n"
"<property name=\"upper\">1000</property>\n"
"<property name=\"value\">3</property>\n"
"<property name=\"step_increment\">1</property>\n"
"<property name=\"page_increment\">10</property>\n"
"</object>\n"
"<object class=\"GtkAdjustment\" id=\"adjaxis\">\n"
"<property name=\"upper\">100</property>\n"
"<property name=\"value\">75</property>\n"
"<property name=\"step_increment\">0.01</property>\n"
"<property name=\"page_increment\">1</property>\n"
"</object>\n"
"<object class=\"GtkAdjustment\" id=\"adjckdelay\">\n"
"<property name=\"upper\">99999</property>\n"
"<property name=\"step_increment\">1</property>\n"
"<property name=\"page_increment\">100</property>\n"
"</object>\n"
"<object class=\"GtkAdjustment\" id=\"adjffspeed\">\n"
"<property name=\"lower\">1</property>\n"
"<property name=\"upper\">15</property>\n"
"<property name=\"value\">4</property>\n"
"<property name=\"step_increment\">0.01</property>\n"
"<property name=\"page_increment\">1</property>\n"
"</object>\n"
"<object class=\"GtkAdjustment\" id=\"adjnetplayers\">\n"
"<property name=\"upper\">16</property>\n"
"<property name=\"value\">1</property>\n"
"<property name=\"step_increment\">1</property>\n"
"<property name=\"page_increment\">1</property>\n"
"</object>\n"
"<object class=\"GtkAdjustment\" id=\"adjnetport\">\n"
"<property name=\"lower\">1</property>\n"
"<property name=\"upper\">65535</property>\n"
"<property name=\"value\">4046</property>\n"
"<property name=\"step_increment\">1</property>\n"
"<property name=\"page_increment\">10</property>\n"
"</object>\n"
"<object class=\"GtkAdjustment\" id=\"adjntscbright\">\n"
"<property name=\"lower\">-1</property>\n"
"<property name=\"upper\">1</property>\n"
"<property name=\"step_increment\">0.01</property>\n"
"<property name=\"page_increment\">0.10000000000000001</property>\n"
"</object>\n"
"<object class=\"GtkAdjustment\" id=\"adjntsccon\">\n"
"<property name=\"lower\">-1</property>\n"
"<property name=\"upper\">1</property>\n"
"<property name=\"step_increment\">0.01</property>\n"
"<property name=\"page_increment\">0.10000000000000001</property>\n"
"</object>\n"
"<object class=\"GtkAdjustment\" id=\"adjntschue\">\n"
"<property name=\"lower\">-1</property>\n"
"<property name=\"upper\">1</property>\n"
"<property name=\"step_increment\">0.01</property>\n"
"<property name=\"page_increment\">0.10000000000000001</property>\n"
"</object>\n"
"<object class=\"GtkAdjustment\" id=\"adjntscmatrix0\">\n"
"<property name=\"lower\">-2</property>\n"
"<property name=\"upper\">2</property>\n"
"<property name=\"value\">1.5389999999999999</property>\n"
"<property name=\"step_increment\">0.001</property>\n"
"<property name=\"page_increment\">0.10000000000000001</property>\n"
"</object>\n"
"<object class=\"GtkAdjustment\" id=\"adjntscmatrix1\">\n"
"<property name=\"lower\">-2</property>\n"
"<property name=\"upper\">2</property>\n"
"<property name=\"value\">-0.622</property>\n"
"<property name=\"step_increment\">0.001</property>\n"
"<property name=\"page_increment\">0.10000000000000001</property>\n"
"</object>\n"
"<object class=\"GtkAdjustment\" id=\"adjntscmatrix2\">\n"
"<property name=\"lower\">-2</property>\n"
"<property name=\"upper\">2</property>\n"
"<property name=\"value\">-0.57099999999999995</property>\n"
"<property name=\"step_increment\">0.001</property>\n"
"<property name=\"page_increment\">0.10000000000000001</property>\n"
"</object>\n"
"<object class=\"GtkAdjustment\" id=\"adjntscmatrix3\">\n"
"<property name=\"lower\">-2</property>\n"
"<property name=\"upper\">2</property>\n"
"<property name=\"value\">-0.185</property>\n"
"<property name=\"step_increment\">0.001</property>\n"
"<property name=\"page_increment\">0.10000000000000001</property>\n"
"</object>\n"
"<object class=\"GtkAdjustment\" id=\"adjntscmatrix4\">\n"
"<property name=\"lower\">-2</property>\n"
"<property name=\"upper\">2</property>\n"
"<property name=\"step_increment\">0.001</property>\n"
"<property name=\"page_increment\">0.10000000000000001</property>\n"
"</object>\n"
"<object class=\"GtkAdjustment\" id=\"adjntscmatrix5\">\n"
"<property name=\"lower\">-2</property>\n"
"<property name=\"upper\">2</property>\n"
"<property name=\"value\">2</property>\n"
"<property name=\"step_increment\">0.001</property>\n"
"<property name=\"page_increment\">0.10000000000000001</property>\n"
"</object>\n"
"<object class=\"GtkAdjustment\" id=\"adjntscsat\">\n"
"<property name=\"lower\">-1</property>\n"
"<property name=\"upper\">1</property>\n"
"<property name=\"step_increment\">0.01</property>\n"
"<property name=\"page_increment\">0.10000000000000001</property>\n"
"</object>\n"
"<object class=\"GtkAdjustment\" id=\"adjntscsharp\">\n"
"<property name=\"lower\">-1</property>\n"
"<property name=\"upper\">1</property>\n"
"<property name=\"step_increment\">0.01</property>\n"
"<property name=\"page_increment\">0.10000000000000001</property>\n"
"</object>\n"
"<object class=\"GtkAdjustment\" id=\"adjosdtime\">\n"
"<property name=\"upper\">15000</property>\n"
"<property name=\"value\">2000</property>\n"
"<property name=\"step_increment\">1</property>\n"
"<property name=\"page_increment\">100</property>\n"
"</object>\n"
"<object class=\"GtkAdjustment\" id=\"adjsfspeed\">\n"
"<property name=\"lower\">0.25</property>\n"
"<property name=\"upper\">1</property>\n"
"<property name=\"value\">0.75</property>\n"
"<property name=\"step_increment\">0.01</property>\n"
"<property name=\"page_increment\">0.10000000000000001</property>\n"
"</object>\n"
"<object class=\"GtkAdjustment\" id=\"adjsoundperiod\">\n"
"<property name=\"upper\">100000</property>\n"
"<property name=\"step_increment\">1</property>\n"
"<property name=\"page_increment\">100</property>\n"
"</object>\n"
"<object class=\"GtkAdjustment\" id=\"adjsrwframes\">\n"
"<property name=\"lower\">10</property>\n"
"<property name=\"upper\">99999</property>\n"
"<property name=\"value\">600</property>\n"
"<property name=\"step_increment\">1</property>\n"
"<property name=\"page_increment\">100</property>\n"
"</object>\n"
"<object class=\"GtkAdjustment\" id=\"adjustblur\">\n"
"<property name=\"upper\">100</property>\n"
"<property name=\"value\">50</property>\n"
"<property name=\"step_increment\">1</property>\n"
"<property name=\"page_increment\">10</property>\n"
"</object>\n"
"<object class=\"GtkAdjustment\" id=\"adjustbuffsize\">\n"
"<property name=\"upper\">1000</property>\n"
"<property name=\"step_increment\">1</property>\n"
"<property name=\"page_increment\">10</property>\n"
"</object>\n"
"<object class=\"GtkAdjustment\" id=\"adjustplayrate\">\n"
"<property name=\"lower\">22050</property>\n"
"<property name=\"upper\">192000</property>\n"
"<property name=\"value\">48000</property>\n"
"<property name=\"step_increment\">1</property>\n"
"<property name=\"page_increment\">10</property>\n"
"</object>\n"
"<object class=\"GtkAdjustment\" id=\"adjustvolume\">\n"
"<property name=\"upper\">150</property>\n"
"<property name=\"value\">100</property>\n"
"<property name=\"step_increment\">1</property>\n"
"<property name=\"page_increment\">10</property>\n"
"</object>\n"
"<object class=\"GtkAdjustment\" id=\"adjxres\">\n"
"<property name=\"upper\">65536</property>\n"
"<property name=\"step_increment\">1</property>\n"
"<property name=\"page_increment\">160</property>\n"
"</object>\n"
"<object class=\"GtkAdjustment\" id=\"adjxscale\">\n"
"<property name=\"lower\">0.01</property>\n"
"<property name=\"upper\">256</property>\n"
"<property name=\"value\">0.01</property>\n"
"<property name=\"step_increment\">0.01</property>\n"
"<property name=\"page_increment\">1</property>\n"
"</object>\n"
"<object class=\"GtkAdjustment\" id=\"adjxscalefs\">\n"
"<property name=\"lower\">0.01</property>\n"
"<property name=\"upper\">256</property>\n"
"<property name=\"value\">1</property>\n"
"<property name=\"step_increment\">0.01</property>\n"
"<property name=\"page_increment\">1</property>\n"
"</object>\n"
"<object class=\"GtkAdjustment\" id=\"adjyscale\">\n"
"<property name=\"lower\">0.01</property>\n"
"<property name=\"upper\">256</property>\n"
"<property name=\"value\">0.0099999997764825821</property>\n"
"<property name=\"step_increment\">0.01</property>\n"
"<property name=\"page_increment\">1</property>\n"
"</object>\n"
"<object class=\"GtkAdjustment\" id=\"adjyscalefs\">\n"
"<property name=\"lower\">0.01</property>\n"
"<property name=\"upper\">256</property>\n"
"<property name=\"value\">1</property>\n"
"<property name=\"step_increment\">0.01</property>\n"
"<property name=\"page_increment\">1</property>\n"
"</object>\n"
"<object class=\"GtkAdjustment\" id=\"adscanlines\">\n"
"<property name=\"lower\">-100</property>\n"
"<property name=\"upper\">100</property>\n"
"<property name=\"step_increment\">1</property>\n"
"<property name=\"page_increment\">10</property>\n"
"</object>\n"
"<object class=\"GtkAdjustment\" id=\"adyres\">\n"
"<property name=\"upper\">65536</property>\n"
"<property name=\"step_increment\">1</property>\n"
"<property name=\"page_increment\">160</property>\n"
"</object>\n"
"<object class=\"GtkListStore\" id=\"cbpathstore\">\n"
"<columns>\n"
"<!-- column-name paths -->\n"
"<column type=\"gchararray\"/>\n"
"</columns>\n"
"</object>\n"
"<object class=\"GtkListStore\" id=\"cbstore_stretch\">\n"
"<columns>\n"
"<!-- column-name stretches -->\n"
"<column type=\"gchararray\"/>\n"
"</columns>\n"
"<data>\n"
"<row>\n"
"<col id=\"0\">0</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">full</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">aspect</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">aspect_int</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">aspect_mult2</col>\n"
"</row>\n"
"</data>\n"
"</object>\n"
"<object class=\"GtkListStore\" id=\"cbstorepix\">\n"
"<columns>\n"
"<!-- column-name shaders -->\n"
"<column type=\"gchararray\"/>\n"
"</columns>\n"
"<data>\n"
"<row>\n"
"<col id=\"0\">none</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">autoip</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">autoipsharper</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">scale2x</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">sabr</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">ipsharper</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">ipxnoty</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">ipynotx</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">ipxnotysharper</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">ipynotxsharper</col>\n"
"</row>\n"
"</data>\n"
"</object>\n"
"<object class=\"GtkListStore\" id=\"cbstorespecial\">\n"
"<columns>\n"
"<!-- column-name specials -->\n"
"<column type=\"gchararray\"/>\n"
"</columns>\n"
"<data>\n"
"<row>\n"
"<col id=\"0\">none</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">hq2x</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">hq3x</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">hq4x</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">scale2x</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">scale3x</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">scale4x</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">2xsai</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">super2xsai</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">supereagle</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">nn2x</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">nn3x</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">nn4x</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">nny2x</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">nny3x</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">nny4x</col>\n"
"</row>\n"
"</data>\n"
"</object>\n"
"<object class=\"GtkListStore\" id=\"cbstorevideoip\">\n"
"<columns>\n"
"<!-- column-name bilinear -->\n"
"<column type=\"gchararray\"/>\n"
"</columns>\n"
"<data>\n"
"<row>\n"
"<col id=\"0\">0</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">1</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">x</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">y</col>\n"
"</row>\n"
"</data>\n"
"</object>\n"
"<object class=\"GtkImage\" id=\"image1\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"stock\">gtk-add</property>\n"
"<property name=\"icon-size\">1</property>\n"
"</object>\n"
"<object class=\"GtkImage\" id=\"image10\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"stock\">gtk-connect</property>\n"
"</object>\n"
"<object class=\"GtkImage\" id=\"image11\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"stock\">gtk-connect</property>\n"
"</object>\n"
"<object class=\"GtkImage\" id=\"image12\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"stock\">gtk-connect</property>\n"
"</object>\n"
"<object class=\"GtkImage\" id=\"image13\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"stock\">gtk-connect</property>\n"
"</object>\n"
"<object class=\"GtkImage\" id=\"image14\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"stock\">gtk-connect</property>\n"
"</object>\n"
"<object class=\"GtkImage\" id=\"image15\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"stock\">gtk-connect</property>\n"
"</object>\n"
"<object class=\"GtkImage\" id=\"image16\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"stock\">gtk-connect</property>\n"
"</object>\n"
"<object class=\"GtkImage\" id=\"image17\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"stock\">gtk-connect</property>\n"
"</object>\n"
"<object class=\"GtkImage\" id=\"image18\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"stock\">gtk-connect</property>\n"
"</object>\n"
"<object class=\"GtkImage\" id=\"image19\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"stock\">gtk-connect</property>\n"
"</object>\n"
"<object class=\"GtkImage\" id=\"image2\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"stock\">gtk-media-play</property>\n"
"</object>\n"
"<object class=\"GtkImage\" id=\"image20\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"stock\">gtk-connect</property>\n"
"</object>\n"
"<object class=\"GtkImage\" id=\"image21\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"stock\">gtk-connect</property>\n"
"</object>\n"
"<object class=\"GtkImage\" id=\"image22\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"stock\">gtk-connect</property>\n"
"</object>\n"
"<object class=\"GtkImage\" id=\"image23\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"stock\">gtk-connect</property>\n"
"</object>\n"
"<object class=\"GtkImage\" id=\"image3\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"stock\">gtk-remove</property>\n"
"<property name=\"icon-size\">1</property>\n"
"</object>\n"
"<object class=\"GtkImage\" id=\"image4\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"stock\">gtk-open</property>\n"
"<property name=\"icon-size\">1</property>\n"
"</object>\n"
"<object class=\"GtkImage\" id=\"image5\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"stock\">gtk-connect</property>\n"
"</object>\n"
"<object class=\"GtkImage\" id=\"image6\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"stock\">gtk-connect</property>\n"
"</object>\n"
"<object class=\"GtkImage\" id=\"image7\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"stock\">gtk-connect</property>\n"
"</object>\n"
"<object class=\"GtkImage\" id=\"image8\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"stock\">gtk-connect</property>\n"
"</object>\n"
"<object class=\"GtkImage\" id=\"image9\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"stock\">gtk-connect</property>\n"
"</object>\n"
"<object class=\"GtkListStore\" id=\"keys\">\n"
"<columns>\n"
"<!-- column-name key_label -->\n"
"<column type=\"gchararray\"/>\n"
"<!-- column-name key_command -->\n"
"<column type=\"gchararray\"/>\n"
"<!-- column-name key -->\n"
"<column type=\"gchararray\"/>\n"
"<!-- column-name device -->\n"
"<column type=\"gchararray\"/>\n"
"</columns>\n"
"<data>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Toggle in-game quick help screen</col>\n"
"<col id=\"1\">toggle_help</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Save state</col>\n"
"<col id=\"1\">save_state</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Load state</col>\n"
"<col id=\"1\">load_state</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Decrement selected save state slot</col>\n"
"<col id=\"1\">state_slot_dec</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Increment selected save state slot</col>\n"
"<col id=\"1\">state_slot_inc</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Toggle save-state rewinding functionality</col>\n"
"<col id=\"1\">toggle_state_rewind</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Toggle cheat console</col>\n"
"<col id=\"1\">togglecheatview</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Toggle cheats active</col>\n"
"<col id=\"1\">togglecheatactive</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Enable network play console input</col>\n"
"<col id=\"1\">togglenetview</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Toggle debugger</col>\n"
"<col id=\"1\">toggle_debugger</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Enter frame advance mode</col>\n"
"<col id=\"1\">advance_frame</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Exit frame advance mode</col>\n"
"<col id=\"1\">run_normal</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Toggle frames-per-second display</col>\n"
"<col id=\"1\">toggle_fps_view</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Rewind emulation</col>\n"
"<col id=\"1\">state_rewind</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Save raw screen snapshot</col>\n"
"<col id=\"1\">take_snapshot</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Save screen snapshot</col>\n"
"<col id=\"1\">take_scaled_snapshot</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Rotate the screen</col>\n"
"<col id=\"1\">rotate_screen</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Toggle fullscreen mode</col>\n"
"<col id=\"1\">toggle_fs</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Fast-forward</col>\n"
"<col id=\"1\">fast_forward</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Slow-forward</col>\n"
"<col id=\"1\">slow_forward</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Detect analog buttons on physical joysticks/gamepads</col>\n"
"<col id=\"1\">input_config_abd</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Configure buttons for emulated device on input port 1</col>\n"
"<col id=\"1\">input_config1</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Configure buttons for emulated device on input port 2</col>\n"
"<col id=\"1\">input_config2</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Activate in-game input configuration process for a command key</col>\n"
"<col id=\"1\">input_configc</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Reset</col>\n"
"<col id=\"1\">reset</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Hard reset</col>\n"
"<col id=\"1\">power</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Exit the emulator (or netplay chat mode)</col>\n"
"<col id=\"1\">exit</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"</data>\n"
"</object>\n"
"<object class=\"GtkListStore\" id=\"liststore1\"/>\n"
"<object class=\"GtkListStore\" id=\"liststore2\">\n"
"<columns>\n"
"<!-- column-name gchararray1 -->\n"
"<column type=\"gchararray\"/>\n"
"</columns>\n"
"<data>\n"
"<row>\n"
"<col id=\"0\">opengl</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">sdl</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">overlay</col>\n"
"</row>\n"
"</data>\n"
"</object>\n"
"<object class=\"GtkListStore\" id=\"liststore3\">\n"
"<columns>\n"
"<!-- column-name systems -->\n"
"<column type=\"gchararray\"/>\n"
"<!-- column-name sys -->\n"
"<column type=\"gchararray\"/>\n"
"<!-- column-name gint1 -->\n"
"<column type=\"gint\"/>\n"
"<!-- column-name visible -->\n"
"<column type=\"gboolean\"/>\n"
"</columns>\n"
"<data>\n"
"<row>\n"
"<col id=\"0\">Atari Lynx</col>\n"
"<col id=\"1\">-lynx</col>\n"
"<col id=\"2\">0</col>\n"
"<col id=\"3\">True</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">GameBoy (Color)</col>\n"
"<col id=\"1\">-gb</col>\n"
"<col id=\"2\">1</col>\n"
"<col id=\"3\">True</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">GameBoy Advance</col>\n"
"<col id=\"1\">-gba</col>\n"
"<col id=\"2\">2</col>\n"
"<col id=\"3\">True</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">Neo Geo Pocket (Color)</col>\n"
"<col id=\"1\">-ngp</col>\n"
"<col id=\"2\">3</col>\n"
"<col id=\"3\">True</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">Nintendo Entertainment System/Famicom</col>\n"
"<col id=\"1\">-nes</col>\n"
"<col id=\"2\">4</col>\n"
"<col id=\"3\">True</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">PC Engine (CD)/TurboGrafx 16 (CD)/SuperGrafx</col>\n"
"<col id=\"1\">-pce</col>\n"
"<col id=\"2\">5</col>\n"
"<col id=\"3\">True</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">PC-FX</col>\n"
"<col id=\"1\">-pcfx</col>\n"
"<col id=\"2\">6</col>\n"
"<col id=\"3\">True</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">Sega Game Gear</col>\n"
"<col id=\"1\">-gg</col>\n"
"<col id=\"2\">7</col>\n"
"<col id=\"3\">True</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">Sega Genesis/MegaDrive</col>\n"
"<col id=\"1\">-md</col>\n"
"<col id=\"2\">8</col>\n"
"<col id=\"3\">True</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">Sega Master System</col>\n"
"<col id=\"1\">-sms</col>\n"
"<col id=\"2\">9</col>\n"
"<col id=\"3\">True</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">Sony PlayStation</col>\n"
"<col id=\"1\">-psx</col>\n"
"<col id=\"2\">10</col>\n"
"<col id=\"3\">True</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">Super Nintendo Entertainment System/Super Famicom</col>\n"
"<col id=\"1\">-snes</col>\n"
"<col id=\"2\">11</col>\n"
"<col id=\"3\">True</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">Virtual Boy</col>\n"
"<col id=\"1\">-vb</col>\n"
"<col id=\"2\">12</col>\n"
"<col id=\"3\">True</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">WonderSwan (Color)</col>\n"
"<col id=\"1\">-wswan</col>\n"
"<col id=\"2\">13</col>\n"
"<col id=\"3\">True</col>\n"
"</row>\n"
"</data>\n"
"</object>\n"
"<object class=\"GtkListStore\" id=\"liststore4\">\n"
"<columns>\n"
"<!-- column-name sounddrivers -->\n"
"<column type=\"gchararray\"/>\n"
"</columns>\n"
"<data>\n"
"<row>\n"
"<col id=\"0\">default</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">alsa</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">oss</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">wasapish</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">dsound</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">wasapi</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">sdl</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">jack</col>\n"
"</row>\n"
"</data>\n"
"</object>\n"
"<object class=\"GtkListStore\" id=\"liststore5\">\n"
"<columns>\n"
"<!-- column-name gchararray1 -->\n"
"<column type=\"gchararray\"/>\n"
"<!-- column-name gint1 -->\n"
"<column type=\"gint\"/>\n"
"</columns>\n"
"<data>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Video</col>\n"
"<col id=\"1\">0</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Audio</col>\n"
"<col id=\"1\">1</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Miscellaneous</col>\n"
"<col id=\"1\">2</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Key Assignments</col>\n"
"<col id=\"1\">3</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Input</col>\n"
"<col id=\"1\">4</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Netplay</col>\n"
"<col id=\"1\">5</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">State Rewinding</col>\n"
"<col id=\"1\">6</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Slow-Forwarding</col>\n"
"<col id=\"1\">7</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Fast-Forwarding</col>\n"
"<col id=\"1\">8</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">OSD</col>\n"
"<col id=\"1\">9</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Paths</col>\n"
"<col id=\"1\">10</col>\n"
"</row>\n"
"</data>\n"
"</object>\n"
"<object class=\"GtkListStore\" id=\"liststore6\">\n"
"<columns>\n"
"<!-- column-name gchararray1 -->\n"
"<column type=\"gchararray\"/>\n"
"</columns>\n"
"<data>\n"
"<row>\n"
"<col id=\"0\">minilzo</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">quicklz</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">blz</col>\n"
"</row>\n"
"</data>\n"
"</object>\n"
"<object class=\"GtkListStore\" id=\"liststore7\">\n"
"<columns>\n"
"<!-- column-name gchararray1 -->\n"
"<column type=\"gchararray\"/>\n"
"</columns>\n"
"<data>\n"
"<row>\n"
"<col id=\"0\">weave</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">bob</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">bob_offset</col>\n"
"</row>\n"
"</data>\n"
"</object>\n"
"<object class=\"GtkListStore\" id=\"ntscstore\">\n"
"<columns>\n"
"<!-- column-name gchararray1 -->\n"
"<column type=\"gchararray\"/>\n"
"</columns>\n"
"<data>\n"
"<row>\n"
"<col id=\"0\">none</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">composite</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">svideo</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">rgb</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">monochrome</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">disabled</col>\n"
"</row>\n"
"</data>\n"
"</object>\n"
"<object class=\"GtkTextBuffer\" id=\"textbufferfe\"/>\n"
"<object class=\"GtkTextBuffer\" id=\"textbufferout\"/>\n"
"<object class=\"GtkTreeModelFilter\" id=\"treemodelfilter1\">\n"
"<property name=\"child_model\">liststore3</property>\n"
"</object>\n"
"<object class=\"GtkWindow\" id=\"topwindow\">\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"title\">Mednaffe</property>\n"
"<property name=\"default_width\">1024</property>\n"
"<property name=\"default_height\">768</property>\n"
"<signal name=\"delete-event\" handler=\"delete\" swapped=\"no\"/>\n"
"<child>\n"
"<object class=\"GtkVBox\" id=\"vbox1\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<object class=\"GtkMenuBar\" id=\"menubar1\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<object class=\"GtkMenuItem\" id=\"menuitem1\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">_File</property>\n"
"<property name=\"use_underline\">True</property>\n"
"<child type=\"submenu\">\n"
"<object class=\"GtkMenu\" id=\"menu1\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<object class=\"GtkImageMenuItem\" id=\"imagemenuitem2\">\n"
"<property name=\"label\" translatable=\"yes\">Open ROM...</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"image\">image4</property>\n"
"<property name=\"use_stock\">False</property>\n"
"<accelerator key=\"o\" signal=\"activate\" modifiers=\"GDK_CONTROL_MASK\"/>\n"
"<signal name=\"activate\" handler=\"open_rom\" swapped=\"no\"/>\n"
"</object>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkSeparatorMenuItem\" id=\"separatormenuitem2\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"</object>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkImageMenuItem\" id=\"imagemenuitem4\">\n"
"<property name=\"label\">Add Folder...</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"image\">image1</property>\n"
"<property name=\"use_stock\">False</property>\n"
"<accelerator key=\"a\" signal=\"activate\" modifiers=\"GDK_CONTROL_MASK\"/>\n"
"<signal name=\"activate\" handler=\"open_folder\" swapped=\"no\"/>\n"
"</object>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkImageMenuItem\" id=\"imagemenuitem1\">\n"
"<property name=\"label\" translatable=\"yes\">Remove Folder</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"image\">image3</property>\n"
"<property name=\"use_stock\">False</property>\n"
"<signal name=\"activate\" handler=\"remove_folder\" swapped=\"no\"/>\n"
"</object>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkSeparatorMenuItem\" id=\"separatormenuitem1\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"</object>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkImageMenuItem\" id=\"imagemenuitem5\">\n"
"<property name=\"label\">gtk-quit</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"use_underline\">True</property>\n"
"<property name=\"use_stock\">True</property>\n"
"<accelerator key=\"q\" signal=\"activate\" modifiers=\"GDK_CONTROL_MASK\"/>\n"
"<signal name=\"activate\" handler=\"quit\" swapped=\"no\"/>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkMenuItem\" id=\"menuitem5\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">_Edit</property>\n"
"<property name=\"use_underline\">True</property>\n"
"<child type=\"submenu\">\n"
"<object class=\"GtkMenu\" id=\"menu6\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<object class=\"GtkImageMenuItem\" id=\"Preferences\">\n"
"<property name=\"label\">gtk-preferences</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"use_underline\">True</property>\n"
"<property name=\"use_stock\">True</property>\n"
"<accelerator key=\"p\" signal=\"activate\" modifiers=\"GDK_CONTROL_MASK\"/>\n"
"<signal name=\"activate\" handler=\"on_preferences_activate\" swapped=\"no\"/>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkMenuItem\" id=\"menuitem3\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">_View</property>\n"
"<property name=\"use_underline\">True</property>\n"
"<child type=\"submenu\">\n"
"<object class=\"GtkMenu\" id=\"menu2\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<object class=\"GtkMenuItem\" id=\"menuitem2\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">List</property>\n"
"<property name=\"use_underline\">True</property>\n"
"<child type=\"submenu\">\n"
"<object class=\"GtkMenu\" id=\"menu7\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<object class=\"GtkMenuItem\" id=\"menuitemfilter\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">Show</property>\n"
"<property name=\"use_underline\">True</property>\n"
"<child type=\"submenu\">\n"
"<object class=\"GtkMenu\" id=\"menu4\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<object class=\"GtkRadioMenuItem\" id=\"radiomenuall\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">All Files</property>\n"
"<property name=\"use_underline\">True</property>\n"
"<property name=\"active\">True</property>\n"
"<property name=\"draw_as_radio\">True</property>\n"
"<accelerator key=\"a\" signal=\"activate\" modifiers=\"GDK_SHIFT_MASK\"/>\n"
"<signal name=\"activate\" handler=\"on_radiomenuall_activate\" swapped=\"no\"/>\n"
"</object>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkRadioMenuItem\" id=\"radiomenuzip\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">Only zips</property>\n"
"<property name=\"use_underline\">True</property>\n"
"<property name=\"draw_as_radio\">True</property>\n"
"<property name=\"group\">radiomenuall</property>\n"
"<accelerator key=\"z\" signal=\"activate\" modifiers=\"GDK_SHIFT_MASK\"/>\n"
"<signal name=\"activate\" handler=\"on_radiomenuzip_activate\" swapped=\"no\"/>\n"
"</object>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkRadioMenuItem\" id=\"radiomenucue\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">Only cue/toc/ccd/m3u</property>\n"
"<property name=\"use_underline\">True</property>\n"
"<property name=\"draw_as_radio\">True</property>\n"
"<property name=\"group\">radiomenuzip</property>\n"
"<accelerator key=\"x\" signal=\"activate\" modifiers=\"GDK_SHIFT_MASK\"/>\n"
"<signal name=\"activate\" handler=\"on_radiomenucue_activate\" swapped=\"no\"/>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkMenuItem\" id=\"menuitemscan\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">Scan Mode</property>\n"
"<property name=\"use_underline\">True</property>\n"
"<child type=\"submenu\">\n"
"<object class=\"GtkMenu\" id=\"menu5\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<object class=\"GtkRadioMenuItem\" id=\"normalmenu\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">Normal</property>\n"
"<property name=\"use_underline\">True</property>\n"
"<property name=\"active\">True</property>\n"
"<property name=\"draw_as_radio\">True</property>\n"
"<accelerator key=\"n\" signal=\"activate\" modifiers=\"GDK_SHIFT_MASK\"/>\n"
"<signal name=\"activate\" handler=\"on_normalmenu_activate\" swapped=\"no\"/>\n"
"</object>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkRadioMenuItem\" id=\"recursivemenu\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">Recursive</property>\n"
"<property name=\"use_underline\">True</property>\n"
"<property name=\"draw_as_radio\">True</property>\n"
"<property name=\"group\">normalmenu</property>\n"
"<accelerator key=\"r\" signal=\"activate\" modifiers=\"GDK_SHIFT_MASK\"/>\n"
"<signal name=\"activate\" handler=\"on_recursivemenu_activate\" swapped=\"no\"/>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkMenuItem\" id=\"menuitem4\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">_Help</property>\n"
"<property name=\"use_underline\">True</property>\n"
"<child type=\"submenu\">\n"
"<object class=\"GtkMenu\" id=\"menu3\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<object class=\"GtkImageMenuItem\" id=\"imagemenuitem10\">\n"
"<property name=\"label\">gtk-about</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"use_underline\">True</property>\n"
"<property name=\"use_stock\">True</property>\n"
"<signal name=\"activate\" handler=\"show_about\" swapped=\"no\"/>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkNotebook\" id=\"notebook1\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<child>\n"
"<object class=\"GtkVBox\" id=\"vbox2\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<object class=\"GtkHBox\" id=\"hbox1\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"border_width\">4</property>\n"
"<property name=\"spacing\">8</property>\n"
"<child>\n"
"<object class=\"GtkComboBox\" id=\"cbpath\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"model\">cbpathstore</property>\n"
"<accelerator key=\"b\" signal=\"popup\" modifiers=\"GDK_CONTROL_MASK\"/>\n"
"<signal name=\"changed\" handler=\"fill_list\" swapped=\"no\"/>\n"
"<child>\n"
"<object class=\"GtkCellRendererText\" id=\"cellrenderertext11\"/>\n"
"<attributes>\n"
"<attribute name=\"text\">0</attribute>\n"
"</attributes>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">True</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkButton\" id=\"button2\">\n"
"<property name=\"label\">Add Folder</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">True</property>\n"
"<property name=\"image\">add_image</property>\n"
"<property name=\"use_underline\">True</property>\n"
"<signal name=\"clicked\" handler=\"open_folder\" swapped=\"no\"/>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"padding\">4</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkScrolledWindow\" id=\"scrollwindow\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"hscrollbar_policy\">automatic</property>\n"
"<property name=\"vscrollbar_policy\">automatic</property>\n"
"<child>\n"
"<object class=\"GtkTreeView\" id=\"gamelist\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<signal name=\"row-activated\" handler=\"row_exec\" swapped=\"no\"/>\n"
"<child>\n"
"<object class=\"GtkTreeViewColumn\" id=\"treeviewcolumn1\">\n"
"<property name=\"title\" translatable=\"yes\"> Games</property>\n"
"<property name=\"clickable\">True</property>\n"
"<signal name=\"clicked\" handler=\"header_clicked\" swapped=\"no\"/>\n"
"<child>\n"
"<object class=\"GtkCellRendererText\" id=\"cellrenderertext12\"/>\n"
"<attributes>\n"
"<attribute name=\"text\">0</attribute>\n"
"</attributes>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">True</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"<child type=\"tab\">\n"
"<object class=\"GtkLabel\" id=\"label1\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">Game List </property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"tab_fill\">False</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkHBox\" id=\"hbox2\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<object class=\"GtkTreeView\" id=\"globalist\">\n"
"<property name=\"width_request\">200</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"model\">liststore5</property>\n"
"<property name=\"headers_visible\">False</property>\n"
"<property name=\"headers_clickable\">False</property>\n"
"<property name=\"enable_search\">False</property>\n"
"<child>\n"
"<object class=\"GtkTreeViewColumn\" id=\"treeviewcolumn3\">\n"
"<property name=\"title\" translatable=\"yes\">column</property>\n"
"<child>\n"
"<object class=\"GtkCellRendererText\" id=\"cellrenderertext2\"/>\n"
"<attributes>\n"
"<attribute name=\"text\">0</attribute>\n"
"</attributes>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkNotebook\" id=\"notebook2\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<child>\n"
"<object class=\"GtkFrame\" id=\"frame4\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"border_width\">4</property>\n"
"<property name=\"label_xalign\">0</property>\n"
"<property name=\"shadow_type\">none</property>\n"
"<child>\n"
"<object class=\"GtkAlignment\" id=\"alignment4\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"left_padding\">12</property>\n"
"<child>\n"
"<object class=\"GtkVBox\" id=\"vbox7\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<object class=\"GtkCheckButton\" id=\"-video.fs\">\n"
"<property name=\"label\" translatable=\"yes\">Enable fullscreen</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">False</property>\n"
"<property name=\"draw_indicator\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkCheckButton\" id=\"-video.frameskip\">\n"
"<property name=\"label\" translatable=\"yes\">Enable frameskip</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">False</property>\n"
"<property name=\"active\">True</property>\n"
"<property name=\"draw_indicator\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkCheckButton\" id=\"-video.blit_timesync\">\n"
"<property name=\"label\" translatable=\"yes\">Enable time synchronization for frame blitting</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">False</property>\n"
"<property name=\"has_tooltip\">True</property>\n"
"<property name=\"tooltip_text\" translatable=\"yes\">Disable to reduce latency, at the cost of potentially increased video \"juddering\", with the maximum reduction in latency being about 1 video frame's time.\n"
"\n"
"Will work best with emulated systems that are not very computationally expensive to emulate, combined with running on a relatively fast CPU.</property>\n"
"<property name=\"active\">True</property>\n"
"<property name=\"draw_indicator\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">2</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkHBox\" id=\"hbox7\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"spacing\">12</property>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label10\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">Video Driver:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkComboBox\" id=\"-video.driver\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"has_tooltip\">True</property>\n"
"<property name=\"tooltip_text\" translatable=\"yes\">opengl - OpenGL + SDL\n"
"This output method is preferred, as all features are available with it.\n"
"\n"
"sdl - SDL Surface\n"
"Slower with lower-quality scaling than OpenGL, but if you don't have hardware-accelerated OpenGL rendering, it will be faster than software OpenGL rendering. Bilinear interpolation not available. Pixel shaders do not work with this output method, of course.\n"
"\n"
"overlay - SDL Overlay\n"
"As fast as OpenGL, perhaps faster in some situations, *if* it's hardware-accelerated. Scanline effects are not available. hq2x, hq3x, hq4x are not available. The OSD may be missing or glitchy. Bilinear interpolation can't be turned off. Harsh chroma subsampling blurring in some picture types. If you use this output method, it is strongly recommended to use a special scaler with it, such as nn2x.</property>\n"
"<property name=\"model\">liststore2</property>\n"
"<property name=\"active\">0</property>\n"
"<signal name=\"changed\" handler=\"cbvideodrv_changed_cb\" object=\"-video.glvsync\" swapped=\"no\"/>\n"
"<child>\n"
"<object class=\"GtkCellRendererText\" id=\"cellrenderertext3\"/>\n"
"<attributes>\n"
"<attribute name=\"text\">0</attribute>\n"
"</attributes>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"padding\">4</property>\n"
"<property name=\"position\">3</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkAlignment\" id=\"alignment11\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"left_padding\">18</property>\n"
"<child>\n"
"<object class=\"GtkCheckButton\" id=\"-video.glvsync\">\n"
"<property name=\"label\" translatable=\"yes\">Synchronize OpenGL page flips to vertical retrace period</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">False</property>\n"
"<property name=\"active\">True</property>\n"
"<property name=\"draw_indicator\">True</property>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">4</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkHBox\" id=\"hbox48\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"spacing\">12</property>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label66\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">Video Deinterlacer:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkComboBox\" id=\"-video.deinterlacer\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"has_tooltip\">True</property>\n"
"<property name=\"tooltip_text\" translatable=\"yes\">Deinterlacer to use for interlaced video.\n"
"\n"
"weave - Good for low-motion video; can be used in conjunction with negative .scanlines setting values.\n"
"\n"
"bob - Good for causing a headache. All glory to Bob.\n"
"\n"
"bob_offset - Good for high-motion video, but is a bit flickery; reduces the subjective vertical resolution.</property>\n"
"<property name=\"model\">liststore7</property>\n"
"<property name=\"active\">0</property>\n"
"<child>\n"
"<object class=\"GtkCellRendererText\" id=\"cellrenderertext10\"/>\n"
"<attributes>\n"
"<attribute name=\"text\">0</attribute>\n"
"</attributes>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"padding\">4</property>\n"
"<property name=\"position\">5</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkCheckButton\" id=\"-video.disable_composition\">\n"
"<property name=\"label\" translatable=\"yes\">Disable desktop composition</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">False</property>\n"
"<property name=\"has_tooltip\">True</property>\n"
"<property name=\"tooltip_text\" translatable=\"yes\">This setting only has an effect on Windows Vista and Windows 7</property>\n"
"<property name=\"active\">True</property>\n"
"<property name=\"draw_indicator\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">False</property>\n"
"<property name=\"position\">6</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"<child type=\"label\">\n"
"<object class=\"GtkLabel\" id=\"label11\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">&lt;b&gt;Video&lt;/b&gt;</property>\n"
"<property name=\"use_markup\">True</property>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"<child type=\"tab\">\n"
"<object class=\"GtkLabel\" id=\"label3\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">Video</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"tab_fill\">False</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkFrame\" id=\"frame5\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"border_width\">4</property>\n"
"<property name=\"label_xalign\">0</property>\n"
"<property name=\"shadow_type\">none</property>\n"
"<child>\n"
"<object class=\"GtkAlignment\" id=\"alignment5\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"left_padding\">12</property>\n"
"<child>\n"
"<object class=\"GtkVBox\" id=\"vbox8\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<object class=\"GtkCheckButton\" id=\"-sound\">\n"
"<property name=\"label\" translatable=\"yes\">Enable sound</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">False</property>\n"
"<property name=\"active\">True</property>\n"
"<property name=\"draw_indicator\">True</property>\n"
"<signal name=\"toggled\" handler=\"on_tbsound_toggled\" object=\"audio_child\" swapped=\"no\"/>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkAlignment\" id=\"alignment26\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"top_padding\">8</property>\n"
"<property name=\"left_padding\">16</property>\n"
"<child>\n"
"<object class=\"GtkVBox\" id=\"audio_child\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"spacing\">6</property>\n"
"<child>\n"
"<object class=\"GtkTable\" id=\"table4\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"n_rows\">4</property>\n"
"<property name=\"n_columns\">2</property>\n"
"<property name=\"column_spacing\">16</property>\n"
"<child>\n"
"<object class=\"GtkSpinButton\" id=\"-sound.period_time\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"has_tooltip\">True</property>\n"
"<property name=\"tooltip_text\" translatable=\"yes\">In microseconds.\n"
"Currently only affects OSS, ALSA, WASAPI(exclusive mode) and SDL output.</property>\n"
"<property name=\"invisible_char\">•</property>\n"
"<property name=\"invisible_char_set\">True</property>\n"
"<property name=\"primary_icon_activatable\">False</property>\n"
"<property name=\"secondary_icon_activatable\">False</property>\n"
"<property name=\"primary_icon_sensitive\">True</property>\n"
"<property name=\"secondary_icon_sensitive\">True</property>\n"
"<property name=\"adjustment\">adjsoundperiod</property>\n"
"<property name=\"numeric\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"left_attach\">1</property>\n"
"<property name=\"right_attach\">2</property>\n"
"<property name=\"top_attach\">3</property>\n"
"<property name=\"bottom_attach\">4</property>\n"
"<property name=\"x_options\">GTK_FILL</property>\n"
"<property name=\"y_options\">GTK_FILL</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkSpinButton\" id=\"-sound.buffer_time\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"has_tooltip\">True</property>\n"
"<property name=\"tooltip_text\" translatable=\"yes\">Desired buffer size in milliseconds(ms).\n"
"\n"
"The default value of 0 enables automatic buffer size selection.</property>\n"
"<property name=\"invisible_char\">•</property>\n"
"<property name=\"invisible_char_set\">True</property>\n"
"<property name=\"primary_icon_activatable\">False</property>\n"
"<property name=\"secondary_icon_activatable\">False</property>\n"
"<property name=\"primary_icon_sensitive\">True</property>\n"
"<property name=\"secondary_icon_sensitive\">True</property>\n"
"<property name=\"adjustment\">adjustbuffsize</property>\n"
"<property name=\"numeric\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"left_attach\">1</property>\n"
"<property name=\"right_attach\">2</property>\n"
"<property name=\"top_attach\">2</property>\n"
"<property name=\"bottom_attach\">3</property>\n"
"<property name=\"x_options\">GTK_FILL</property>\n"
"<property name=\"y_options\">GTK_FILL</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkSpinButton\" id=\"-sound.rate\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"has_tooltip\">True</property>\n"
"<property name=\"tooltip_text\" translatable=\"yes\">Specifies the sound playback rate, in sound frames per second(\"Hz\").</property>\n"
"<property name=\"invisible_char\">•</property>\n"
"<property name=\"invisible_char_set\">True</property>\n"
"<property name=\"primary_icon_activatable\">False</property>\n"
"<property name=\"secondary_icon_activatable\">False</property>\n"
"<property name=\"primary_icon_sensitive\">True</property>\n"
"<property name=\"secondary_icon_sensitive\">True</property>\n"
"<property name=\"adjustment\">adjustplayrate</property>\n"
"<property name=\"numeric\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"left_attach\">1</property>\n"
"<property name=\"right_attach\">2</property>\n"
"<property name=\"top_attach\">1</property>\n"
"<property name=\"bottom_attach\">2</property>\n"
"<property name=\"x_options\">GTK_FILL</property>\n"
"<property name=\"y_options\">GTK_FILL</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label7\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"xalign\">1</property>\n"
"<property name=\"label\" translatable=\"yes\">Period size:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"top_attach\">3</property>\n"
"<property name=\"bottom_attach\">4</property>\n"
"<property name=\"x_options\">GTK_FILL</property>\n"
"<property name=\"y_options\">GTK_FILL</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label18\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"xalign\">1</property>\n"
"<property name=\"label\" translatable=\"yes\">Total buffer size:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"top_attach\">2</property>\n"
"<property name=\"bottom_attach\">3</property>\n"
"<property name=\"x_options\">GTK_FILL</property>\n"
"<property name=\"y_options\">GTK_FILL</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label19\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">Sound playback rate:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"top_attach\">1</property>\n"
"<property name=\"bottom_attach\">2</property>\n"
"<property name=\"x_options\">GTK_FILL</property>\n"
"<property name=\"y_options\">GTK_FILL</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkComboBox\" id=\"-sound.driver\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"has_tooltip\">True</property>\n"
"<property name=\"tooltip_text\" translatable=\"yes\">default - Default\n"
"Default sound driver.\n"
"\n"
"alsa - ALSA\n"
"A recommended driver, and the default for Linux(if available).\n"
"\n"
"oss - Open Sound System\n"
"A recommended driver, and the default for non-Linux UN*X/POSIX/BSD systems, or anywhere ALSA is unavailable. If the ALSA driver gives you problems, you can try using this one instead.\n"
"\n"
"wasapish - WASAPI(Shared Mode)\n"
"The default when it's available(running on Microsoft Windows Vista and newer).\n"
"\n"
"dsound - DirectSound\n"
"The default for Microsoft Windows XP and older.\n"
"\n"
"wasapi - WASAPI(Exclusive Mode)\n"
"Experimental exclusive-mode WASAPI driver, usable on Windows Vista and newer. Use it for lower-latency sound. May not work properly on all sound cards.\n"
"\n"
"sdl - Simple Directmedia Layer\n"
"This driver is not recommended, but it serves as a backup driver if the others aren't available. Its performance is generally sub-par, requiring higher latency or faster CPUs/SMP for glitch-free playback, except where the OS provides a sound callback API itself, such as with Mac OS X and BeOS.\n"
"\n"
"jack - JACK\n"
"Somewhat experimental driver, unusably buggy until Mednafen 0.8.C. The \"sound.buffer_time\" setting controls the size of the local sound buffer, not the server's sound buffer, and the latency reported during startup is for the local sound buffer only.</property>\n"
"<property name=\"model\">liststore4</property>\n"
"<property name=\"active\">0</property>\n"
"<signal name=\"changed\" handler=\"on_audio_changed\" object=\"-sound.period_time\" swapped=\"no\"/>\n"
"<child>\n"
"<object class=\"GtkCellRendererText\" id=\"cellrenderertext7\"/>\n"
"<attributes>\n"
"<attribute name=\"text\">0</attribute>\n"
"</attributes>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"left_attach\">1</property>\n"
"<property name=\"right_attach\">2</property>\n"
"<property name=\"x_options\">GTK_FILL</property>\n"
"<property name=\"y_options\">GTK_FILL</property>\n"
"<property name=\"y_padding\">8</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label14\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"xalign\">1</property>\n"
"<property name=\"label\" translatable=\"yes\">Sound driver:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"x_options\">GTK_FILL</property>\n"
"<property name=\"y_options\">GTK_FILL</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkHBox\" id=\"hbox17\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"spacing\">24</property>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label16\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">Volume:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkHScale\" id=\"-sound.volume\">\n"
"<property name=\"width_request\">250</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"adjustment\">adjustvolume</property>\n"
"<property name=\"round_digits\">0</property>\n"
"<property name=\"digits\">0</property>\n"
"<property name=\"value_pos\">left</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"padding\">16</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"<child type=\"label\">\n"
"<object class=\"GtkLabel\" id=\"label12\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">&lt;b&gt;Audio&lt;/b&gt;</property>\n"
"<property name=\"use_markup\">True</property>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"<child type=\"tab\">\n"
"<object class=\"GtkLabel\" id=\"label8\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">Audio</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"position\">1</property>\n"
"<property name=\"tab_fill\">False</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkFrame\" id=\"frame6\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"border_width\">4</property>\n"
"<property name=\"label_xalign\">0</property>\n"
"<property name=\"shadow_type\">none</property>\n"
"<child>\n"
"<object class=\"GtkAlignment\" id=\"alignment6\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"left_padding\">12</property>\n"
"<child>\n"
"<object class=\"GtkVBox\" id=\"vbox9\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<object class=\"GtkCheckButton\" id=\"-cheats\">\n"
"<property name=\"label\" translatable=\"yes\">Enable cheats</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">False</property>\n"
"<property name=\"active\">True</property>\n"
"<property name=\"draw_indicator\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkCheckButton\" id=\"-autosave\">\n"
"<property name=\"label\" translatable=\"yes\">Automatic load/save state on game load/save</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">False</property>\n"
"<property name=\"draw_indicator\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkCheckButton\" id=\"-nothrottle\">\n"
"<property name=\"label\" translatable=\"yes\">Disable speed throttling when sound is disabled</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">False</property>\n"
"<property name=\"draw_indicator\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">2</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkCheckButton\" id=\"-cd.image_memcache\">\n"
"<property name=\"label\" translatable=\"yes\">Cache entire CD images in memory</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">False</property>\n"
"<property name=\"has_tooltip\">True</property>\n"
"<property name=\"tooltip_text\" translatable=\"yes\">Reads the entire CD image(s) into memory at startup (which will cause a small delay). Can help obviate emulation hiccups due to emulated CD access. \n"
"\n"
"May cause more harm than good on low memory systems, systems with swap enabled, and/or when the disc images in question are on a fast SSD.</property>\n"
"<property name=\"draw_indicator\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">3</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkCheckButton\" id=\"-debugger.autostepmode\">\n"
"<property name=\"label\" translatable=\"yes\">Automatically go into the debugger's step mode after a game is loaded</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">False</property>\n"
"<property name=\"draw_indicator\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">4</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkCheckButton\" id=\"-filesys.disablesavegz\">\n"
"<property name=\"label\" translatable=\"yes\">Disable gzip compression when saving save states and backup memory</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">False</property>\n"
"<property name=\"draw_indicator\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">5</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"<child type=\"label\">\n"
"<object class=\"GtkLabel\" id=\"label13\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">&lt;b&gt;Miscellaneous&lt;/b&gt;</property>\n"
"<property name=\"use_markup\">True</property>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"position\">2</property>\n"
"</packing>\n"
"</child>\n"
"<child type=\"tab\">\n"
"<object class=\"GtkLabel\" id=\"label9\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">Misc</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"position\">2</property>\n"
"<property name=\"tab_fill\">False</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkFrame\" id=\"frame16\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"border_width\">4</property>\n"
"<property name=\"label_xalign\">0</property>\n"
"<property name=\"shadow_type\">none</property>\n"
"<child>\n"
"<object class=\"GtkAlignment\" id=\"alignment18\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"left_padding\">12</property>\n"
"<child>\n"
"<object class=\"GtkVBox\" id=\"vbox27\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"spacing\">12</property>\n"
"<child>\n"
"<object class=\"GtkHBox\" id=\"hbox49\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<object class=\"GtkButton\" id=\"keyinputbutton\">\n"
"<property name=\"label\" translatable=\"yes\">Key Assignments</property>\n"
"<property name=\"width_request\">300</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">True</property>\n"
"<signal name=\"clicked\" handler=\"on_input_clicked\" swapped=\"no\"/>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">False</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"padding\">12</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"<child type=\"label\">\n"
"<object class=\"GtkLabel\" id=\"label70\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">&lt;b&gt;Key Assignments&lt;/b&gt;</property>\n"
"<property name=\"use_markup\">True</property>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"position\">3</property>\n"
"</packing>\n"
"</child>\n"
"<child type=\"tab\">\n"
"<object class=\"GtkLabel\" id=\"label69\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">Key Assignments</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"position\">3</property>\n"
"<property name=\"tab_fill\">False</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkFrame\" id=\"frame9\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"border_width\">4</property>\n"
"<property name=\"label_xalign\">0</property>\n"
"<property name=\"shadow_type\">none</property>\n"
"<child>\n"
"<object class=\"GtkAlignment\" id=\"alignment7\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"left_padding\">12</property>\n"
"<child>\n"
"<object class=\"GtkVBox\" id=\"vbox17\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<object class=\"GtkCheckButton\" id=\"-input.joystick.global_focus\">\n"
"<property name=\"label\" translatable=\"yes\">Update physical joystick(s) internal state even when Mednafen lacks OS focus</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">False</property>\n"
"<property name=\"draw_indicator\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkTable\" id=\"table5\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"n_rows\">3</property>\n"
"<property name=\"n_columns\">2</property>\n"
"<property name=\"column_spacing\">16</property>\n"
"<child>\n"
"<object class=\"GtkSpinButton\" id=\"-input.autofirefreq\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"has_tooltip\">True</property>\n"
"<property name=\"tooltip_text\" translatable=\"yes\">Auto-fire frequency = GameSystemFrameRateHz / (value + 1)</property>\n"
"<property name=\"invisible_char\">•</property>\n"
"<property name=\"invisible_char_set\">True</property>\n"
"<property name=\"primary_icon_activatable\">False</property>\n"
"<property name=\"secondary_icon_activatable\">False</property>\n"
"<property name=\"primary_icon_sensitive\">True</property>\n"
"<property name=\"secondary_icon_sensitive\">True</property>\n"
"<property name=\"adjustment\">adjautofire</property>\n"
"<property name=\"numeric\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"left_attach\">1</property>\n"
"<property name=\"right_attach\">2</property>\n"
"<property name=\"x_options\">GTK_FILL</property>\n"
"<property name=\"y_options\">GTK_FILL</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkSpinButton\" id=\"-input.ckdelay\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"has_tooltip\">True</property>\n"
"<property name=\"tooltip_text\" translatable=\"yes\">The length of time, in milliseconds, that a button/key corresponding to a \"dangerous\" command like power, reset, exit, etc. must be pressed before the command is executed.</property>\n"
"<property name=\"invisible_char\">•</property>\n"
"<property name=\"invisible_char_set\">True</property>\n"
"<property name=\"primary_icon_activatable\">False</property>\n"
"<property name=\"secondary_icon_activatable\">False</property>\n"
"<property name=\"primary_icon_sensitive\">True</property>\n"
"<property name=\"secondary_icon_sensitive\">True</property>\n"
"<property name=\"adjustment\">adjckdelay</property>\n"
"<property name=\"numeric\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"left_attach\">1</property>\n"
"<property name=\"right_attach\">2</property>\n"
"<property name=\"top_attach\">1</property>\n"
"<property name=\"bottom_attach\">2</property>\n"
"<property name=\"x_options\">GTK_FILL</property>\n"
"<property name=\"y_options\">GTK_FILL</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkSpinButton\" id=\"-input.joystick.axis_threshold\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"has_tooltip\">True</property>\n"
"<property name=\"tooltip_text\" translatable=\"yes\">Threshold for detecting a digital-like \"button\" press on analog axis, in percent.</property>\n"
"<property name=\"invisible_char\">•</property>\n"
"<property name=\"primary_icon_activatable\">False</property>\n"
"<property name=\"secondary_icon_activatable\">False</property>\n"
"<property name=\"primary_icon_sensitive\">True</property>\n"
"<property name=\"secondary_icon_sensitive\">True</property>\n"
"<property name=\"adjustment\">adjaxis</property>\n"
"<property name=\"digits\">2</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"left_attach\">1</property>\n"
"<property name=\"right_attach\">2</property>\n"
"<property name=\"top_attach\">2</property>\n"
"<property name=\"bottom_attach\">3</property>\n"
"<property name=\"x_options\">GTK_FILL</property>\n"
"<property name=\"y_options\">GTK_FILL</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label43\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"xalign\">1</property>\n"
"<property name=\"label\" translatable=\"yes\">Auto-fire frequency:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"x_options\">GTK_FILL</property>\n"
"<property name=\"y_options\">GTK_FILL</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label44\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"xalign\">1</property>\n"
"<property name=\"label\" translatable=\"yes\">Dangerous key action delay:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"top_attach\">1</property>\n"
"<property name=\"bottom_attach\">2</property>\n"
"<property name=\"x_options\">GTK_FILL</property>\n"
"<property name=\"y_options\">GTK_FILL</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label45\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">Analog axis binary press detection threshold:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"top_attach\">2</property>\n"
"<property name=\"bottom_attach\">3</property>\n"
"<property name=\"x_options\">GTK_FILL</property>\n"
"<property name=\"y_options\">GTK_FILL</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"padding\">8</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"<child type=\"label\">\n"
"<object class=\"GtkLabel\" id=\"label42\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">&lt;b&gt;Input&lt;/b&gt;</property>\n"
"<property name=\"use_markup\">True</property>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"position\">4</property>\n"
"</packing>\n"
"</child>\n"
"<child type=\"tab\">\n"
"<object class=\"GtkLabel\" id=\"label17\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">Input</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"position\">4</property>\n"
"<property name=\"tab_fill\">False</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkFrame\" id=\"frame15\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"border_width\">4</property>\n"
"<property name=\"label_xalign\">0</property>\n"
"<property name=\"shadow_type\">none</property>\n"
"<child>\n"
"<object class=\"GtkAlignment\" id=\"alignment17\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"left_padding\">12</property>\n"
"<child>\n"
"<object class=\"GtkVBox\" id=\"vbox22\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"spacing\">9</property>\n"
"<child>\n"
"<object class=\"GtkHBox\" id=\"hbox35\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"spacing\">13</property>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label60\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">Server hostname:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkEntry\" id=\"-netplay.host\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"invisible_char\">•</property>\n"
"<property name=\"primary_icon_activatable\">False</property>\n"
"<property name=\"secondary_icon_activatable\">False</property>\n"
"<property name=\"primary_icon_sensitive\">True</property>\n"
"<property name=\"secondary_icon_sensitive\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label64\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">Server port:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">2</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkSpinButton\" id=\"-netplay.port\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"invisible_char\">•</property>\n"
"<property name=\"invisible_char_set\">True</property>\n"
"<property name=\"primary_icon_activatable\">False</property>\n"
"<property name=\"secondary_icon_activatable\">False</property>\n"
"<property name=\"primary_icon_sensitive\">True</property>\n"
"<property name=\"secondary_icon_sensitive\">True</property>\n"
"<property name=\"adjustment\">adjnetport</property>\n"
"<property name=\"numeric\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">3</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkHBox\" id=\"hbox37\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"spacing\">12</property>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label62\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">Server Password:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkEntry\" id=\"-netplay.password\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"invisible_char\">•</property>\n"
"<property name=\"invisible_char_set\">True</property>\n"
"<property name=\"primary_icon_activatable\">False</property>\n"
"<property name=\"secondary_icon_activatable\">False</property>\n"
"<property name=\"primary_icon_sensitive\">True</property>\n"
"<property name=\"secondary_icon_sensitive\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkHBox\" id=\"hbox36\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"spacing\">59</property>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label61\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">Nickname:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkEntry\" id=\"-netplay.nick\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"invisible_char\">•</property>\n"
"<property name=\"invisible_char_set\">True</property>\n"
"<property name=\"primary_icon_activatable\">False</property>\n"
"<property name=\"secondary_icon_activatable\">False</property>\n"
"<property name=\"primary_icon_sensitive\">True</property>\n"
"<property name=\"secondary_icon_sensitive\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">2</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkHBox\" id=\"hbox38\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"spacing\">6</property>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label63\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">Key to hash with the MD5 hash of the game:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkEntry\" id=\"-netplay.gamekey\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"invisible_char\">•</property>\n"
"<property name=\"invisible_char_set\">True</property>\n"
"<property name=\"primary_icon_activatable\">False</property>\n"
"<property name=\"secondary_icon_activatable\">False</property>\n"
"<property name=\"primary_icon_sensitive\">True</property>\n"
"<property name=\"secondary_icon_sensitive\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">3</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkHBox\" id=\"hbox40\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"spacing\">24</property>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label65\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">Local player count:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkHScale\" id=\"-netplay.localplayers\">\n"
"<property name=\"width_request\">308</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"has_tooltip\">True</property>\n"
"<property name=\"tooltip_text\" translatable=\"yes\">Number of local players for network play. \n"
"\n"
"This number is advisory to the server, and the server may assign fewer players if the number of players requested is higher than the number of controllers currently available.</property>\n"
"<property name=\"adjustment\">adjnetplayers</property>\n"
"<property name=\"round_digits\">0</property>\n"
"<property name=\"digits\">0</property>\n"
"<property name=\"value_pos\">left</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">4</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkCheckButton\" id=\"-netplay.smallfont\">\n"
"<property name=\"label\" translatable=\"yes\">Use small font for netplay chat console</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">False</property>\n"
"<property name=\"draw_indicator\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">5</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"<child type=\"label\">\n"
"<object class=\"GtkLabel\" id=\"label67\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">&lt;b&gt;Netplay&lt;/b&gt;</property>\n"
"<property name=\"use_markup\">True</property>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"position\">5</property>\n"
"</packing>\n"
"</child>\n"
"<child type=\"tab\">\n"
"<object class=\"GtkLabel\" id=\"label59\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">Netplay</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"position\">5</property>\n"
"<property name=\"tab_fill\">False</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkFrame\" id=\"frame13\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"border_width\">4</property>\n"
"<property name=\"label_xalign\">0</property>\n"
"<property name=\"shadow_type\">none</property>\n"
"<child>\n"
"<object class=\"GtkAlignment\" id=\"alignment15\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"left_padding\">12</property>\n"
"<child>\n"
"<object class=\"GtkVBox\" id=\"vbox20\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<object class=\"GtkHBox\" id=\"hbox32\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"spacing\">12</property>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label53\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">Number of frames to keep states for when state rewinding is enabled:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkSpinButton\" id=\"-srwframes\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"has_tooltip\">True</property>\n"
"<property name=\"tooltip_text\" translatable=\"yes\">WARNING: \n"
"Setting this to a large value may cause excessive RAM usage in some circumstances, such as with games that stream large volumes of data off of CDs.</property>\n"
"<property name=\"invisible_char\">•</property>\n"
"<property name=\"invisible_char_set\">True</property>\n"
"<property name=\"primary_icon_activatable\">False</property>\n"
"<property name=\"secondary_icon_activatable\">False</property>\n"
"<property name=\"primary_icon_sensitive\">True</property>\n"
"<property name=\"secondary_icon_sensitive\">True</property>\n"
"<property name=\"adjustment\">adjsrwframes</property>\n"
"<property name=\"numeric\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"padding\">6</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"<child type=\"label\">\n"
"<object class=\"GtkLabel\" id=\"label54\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">&lt;b&gt;State Rewinding&lt;/b&gt;</property>\n"
"<property name=\"use_markup\">True</property>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"position\">6</property>\n"
"</packing>\n"
"</child>\n"
"<child type=\"tab\">\n"
"<object class=\"GtkLabel\" id=\"label52\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">State Rewinding</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"position\">6</property>\n"
"<property name=\"tab_fill\">False</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkFrame\" id=\"frame12\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"border_width\">4</property>\n"
"<property name=\"label_xalign\">0</property>\n"
"<property name=\"shadow_type\">none</property>\n"
"<child>\n"
"<object class=\"GtkAlignment\" id=\"alignment14\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"left_padding\">12</property>\n"
"<child>\n"
"<object class=\"GtkVBox\" id=\"vbox19\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<object class=\"GtkCheckButton\" id=\"-sftoggle\">\n"
"<property name=\"label\" translatable=\"yes\">Treat the slow-forward button as a toggle</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">False</property>\n"
"<property name=\"draw_indicator\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkHBox\" id=\"hbox31\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"spacing\">12</property>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label50\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">Slow-forwarding speed multiplier:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkSpinButton\" id=\"-sfspeed\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"invisible_char\">•</property>\n"
"<property name=\"invisible_char_set\">True</property>\n"
"<property name=\"primary_icon_activatable\">False</property>\n"
"<property name=\"secondary_icon_activatable\">False</property>\n"
"<property name=\"primary_icon_sensitive\">True</property>\n"
"<property name=\"secondary_icon_sensitive\">True</property>\n"
"<property name=\"adjustment\">adjsfspeed</property>\n"
"<property name=\"digits\">2</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"padding\">6</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"<child type=\"label\">\n"
"<object class=\"GtkLabel\" id=\"label51\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">&lt;b&gt;Slow-Forwarding&lt;/b&gt;</property>\n"
"<property name=\"use_markup\">True</property>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"position\">7</property>\n"
"</packing>\n"
"</child>\n"
"<child type=\"tab\">\n"
"<object class=\"GtkLabel\" id=\"label49\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">Slow-Forwarding</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"position\">7</property>\n"
"<property name=\"tab_fill\">False</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkFrame\" id=\"frame11\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"border_width\">4</property>\n"
"<property name=\"label_xalign\">0</property>\n"
"<property name=\"shadow_type\">none</property>\n"
"<child>\n"
"<object class=\"GtkAlignment\" id=\"alignment13\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"left_padding\">12</property>\n"
"<child>\n"
"<object class=\"GtkVBox\" id=\"vbox18\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<object class=\"GtkCheckButton\" id=\"-fftoggle\">\n"
"<property name=\"label\" translatable=\"yes\">Treat the fast-forward button as a toggle</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">False</property>\n"
"<property name=\"draw_indicator\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkCheckButton\" id=\"-ffnosound\">\n"
"<property name=\"label\" translatable=\"yes\">Silence sound output when fast-forwarding</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">False</property>\n"
"<property name=\"active\">True</property>\n"
"<property name=\"draw_indicator\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkHBox\" id=\"hbox30\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"spacing\">12</property>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label48\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">Fast-forwarding speed multiplier:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkSpinButton\" id=\"-ffspeed\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"invisible_char\">•</property>\n"
"<property name=\"invisible_char_set\">True</property>\n"
"<property name=\"primary_icon_activatable\">False</property>\n"
"<property name=\"secondary_icon_activatable\">False</property>\n"
"<property name=\"primary_icon_sensitive\">True</property>\n"
"<property name=\"secondary_icon_sensitive\">True</property>\n"
"<property name=\"adjustment\">adjffspeed</property>\n"
"<property name=\"digits\">2</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"padding\">6</property>\n"
"<property name=\"position\">2</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"<child type=\"label\">\n"
"<object class=\"GtkLabel\" id=\"label47\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">&lt;b&gt;Fast-Forwarding&lt;/b&gt;</property>\n"
"<property name=\"use_markup\">True</property>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"position\">8</property>\n"
"</packing>\n"
"</child>\n"
"<child type=\"tab\">\n"
"<object class=\"GtkLabel\" id=\"label46\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">Fast-Forwarding</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"position\">8</property>\n"
"<property name=\"tab_fill\">False</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkFrame\" id=\"frame14\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"border_width\">4</property>\n"
"<property name=\"label_xalign\">0</property>\n"
"<property name=\"shadow_type\">none</property>\n"
"<child>\n"
"<object class=\"GtkAlignment\" id=\"alignment16\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"left_padding\">12</property>\n"
"<child>\n"
"<object class=\"GtkVBox\" id=\"vbox21\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<object class=\"GtkCheckButton\" id=\"-osd.alpha_blend\">\n"
"<property name=\"label\" translatable=\"yes\">Enable alpha blending for OSD elements</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">False</property>\n"
"<property name=\"active\">True</property>\n"
"<property name=\"draw_indicator\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkHBox\" id=\"hbox34\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"spacing\">12</property>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label57\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">The length of time to display the save state or \n"
"the movie selector after selecting a state or movie:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkSpinButton\" id=\"-osd.state_display_time\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"has_tooltip\">True</property>\n"
"<property name=\"tooltip_text\" translatable=\"yes\">In milliseconds.</property>\n"
"<property name=\"invisible_char\">•</property>\n"
"<property name=\"invisible_char_set\">True</property>\n"
"<property name=\"primary_icon_activatable\">False</property>\n"
"<property name=\"secondary_icon_activatable\">False</property>\n"
"<property name=\"primary_icon_sensitive\">True</property>\n"
"<property name=\"secondary_icon_sensitive\">True</property>\n"
"<property name=\"adjustment\">adjosdtime</property>\n"
"<property name=\"numeric\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"padding\">6</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"<child type=\"label\">\n"
"<object class=\"GtkLabel\" id=\"label58\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">&lt;b&gt;OSD&lt;/b&gt;</property>\n"
"<property name=\"use_markup\">True</property>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"position\">9</property>\n"
"</packing>\n"
"</child>\n"
"<child type=\"tab\">\n"
"<object class=\"GtkLabel\" id=\"label56\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">OSD</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"position\">9</property>\n"
"<property name=\"tab_fill\">False</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkFrame\" id=\"frame7\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"border_width\">4</property>\n"
"<property name=\"label_xalign\">0</property>\n"
"<property name=\"shadow_type\">none</property>\n"
"<child>\n"
"<object class=\"GtkAlignment\" id=\"alignment3\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"left_padding\">12</property>\n"
"<child>\n"
"<object class=\"GtkVBox\" id=\"vbox23\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"spacing\">6</property>\n"
"<child>\n"
"<object class=\"GtkVBox\" id=\"vbox30\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label86\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"xalign\">0</property>\n"
"<property name=\"label\" translatable=\"yes\">Path to directory for cheats:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkHBox\" id=\"hbox65\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<object class=\"GtkEntry\" id=\"-filesys.path_cheat\">\n"
"<property name=\"width_request\">400</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"editable\">False</property>\n"
"<property name=\"invisible_char\">•</property>\n"
"<property name=\"invisible_char_set\">True</property>\n"
"<property name=\"primary_icon_activatable\">False</property>\n"
"<property name=\"secondary_icon_activatable\">False</property>\n"
"<property name=\"primary_icon_sensitive\">True</property>\n"
"<property name=\"secondary_icon_sensitive\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"padding\">12</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkButton\" id=\"button10\">\n"
"<property name=\"label\">gtk-open</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">True</property>\n"
"<property name=\"use_stock\">True</property>\n"
"<signal name=\"clicked\" handler=\"on_button_entry_clicked_folder\" object=\"-filesys.path_cheat\" swapped=\"no\"/>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkVBox\" id=\"vbox31\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label87\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"xalign\">0</property>\n"
"<property name=\"label\" translatable=\"yes\">Path to directory for firmware/BIOS:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkHBox\" id=\"hbox68\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<object class=\"GtkEntry\" id=\"-filesys.path_firmware\">\n"
"<property name=\"width_request\">400</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"editable\">False</property>\n"
"<property name=\"invisible_char\">•</property>\n"
"<property name=\"invisible_char_set\">True</property>\n"
"<property name=\"primary_icon_activatable\">False</property>\n"
"<property name=\"secondary_icon_activatable\">False</property>\n"
"<property name=\"primary_icon_sensitive\">True</property>\n"
"<property name=\"secondary_icon_sensitive\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"padding\">12</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkButton\" id=\"button11\">\n"
"<property name=\"label\">gtk-open</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">True</property>\n"
"<property name=\"use_stock\">True</property>\n"
"<signal name=\"clicked\" handler=\"on_button_entry_clicked_folder\" object=\"-filesys.path_firmware\" swapped=\"no\"/>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkVBox\" id=\"vbox32\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label90\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"xalign\">0</property>\n"
"<property name=\"label\" translatable=\"yes\">Path to directory for movies:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkHBox\" id=\"hbox70\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<object class=\"GtkEntry\" id=\"-filesys.path_movie\">\n"
"<property name=\"width_request\">400</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"editable\">False</property>\n"
"<property name=\"invisible_char\">•</property>\n"
"<property name=\"invisible_char_set\">True</property>\n"
"<property name=\"primary_icon_activatable\">False</property>\n"
"<property name=\"secondary_icon_activatable\">False</property>\n"
"<property name=\"primary_icon_sensitive\">True</property>\n"
"<property name=\"secondary_icon_sensitive\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"padding\">12</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkButton\" id=\"button12\">\n"
"<property name=\"label\">gtk-open</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">True</property>\n"
"<property name=\"use_stock\">True</property>\n"
"<signal name=\"clicked\" handler=\"on_button_entry_clicked_folder\" object=\"-filesys.path_movie\" swapped=\"no\"/>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">2</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkVBox\" id=\"vbox5\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label37\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"xalign\">0</property>\n"
"<property name=\"label\" translatable=\"yes\">Path to directory for custom palettes:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkHBox\" id=\"hbox20\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<object class=\"GtkEntry\" id=\"-filesys.path_palette\">\n"
"<property name=\"width_request\">400</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"editable\">False</property>\n"
"<property name=\"invisible_char\">•</property>\n"
"<property name=\"invisible_char_set\">True</property>\n"
"<property name=\"primary_icon_activatable\">False</property>\n"
"<property name=\"secondary_icon_activatable\">False</property>\n"
"<property name=\"primary_icon_sensitive\">True</property>\n"
"<property name=\"secondary_icon_sensitive\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"padding\">12</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkButton\" id=\"button3\">\n"
"<property name=\"label\">gtk-open</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">True</property>\n"
"<property name=\"use_stock\">True</property>\n"
"<signal name=\"clicked\" handler=\"on_button_entry_clicked_folder\" object=\"-filesys.path_palette\" swapped=\"no\"/>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">3</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkVBox\" id=\"vbox13\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label38\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"xalign\">0</property>\n"
"<property name=\"label\" translatable=\"yes\">Path to directory for save games and nonvolatile memory:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkHBox\" id=\"hbox22\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<object class=\"GtkEntry\" id=\"-filesys.path_sav\">\n"
"<property name=\"width_request\">400</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"has_tooltip\">True</property>\n"
"<property name=\"tooltip_text\" translatable=\"yes\">WARNING: \n"
"Do not set this path to a directory that contains Famicom Disk System disk images, or you will corrupt them when you load an FDS game and exit Mednafen.</property>\n"
"<property name=\"editable\">False</property>\n"
"<property name=\"invisible_char\">•</property>\n"
"<property name=\"invisible_char_set\">True</property>\n"
"<property name=\"primary_icon_activatable\">False</property>\n"
"<property name=\"secondary_icon_activatable\">False</property>\n"
"<property name=\"primary_icon_sensitive\">True</property>\n"
"<property name=\"secondary_icon_sensitive\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"padding\">12</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkButton\" id=\"button4\">\n"
"<property name=\"label\">gtk-open</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">True</property>\n"
"<property name=\"has_tooltip\">True</property>\n"
"<property name=\"tooltip_text\" translatable=\"yes\">WARNING: \n"
"Do not set this path to a directory that contains Famicom Disk System disk images, or you will corrupt them when you load an FDS game and exit Mednafen.</property>\n"
"<property name=\"use_stock\">True</property>\n"
"<signal name=\"clicked\" handler=\"on_button_entry_clicked_folder\" object=\"-filesys.path_sav\" swapped=\"no\"/>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">4</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkVBox\" id=\"vbox14\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label39\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"xalign\">0</property>\n"
"<property name=\"label\" translatable=\"yes\">Path to directory for screen snapshots:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkHBox\" id=\"hbox24\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<object class=\"GtkEntry\" id=\"-filesys.path_snap\">\n"
"<property name=\"width_request\">400</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"editable\">False</property>\n"
"<property name=\"invisible_char\">•</property>\n"
"<property name=\"invisible_char_set\">True</property>\n"
"<property name=\"primary_icon_activatable\">False</property>\n"
"<property name=\"secondary_icon_activatable\">False</property>\n"
"<property name=\"primary_icon_sensitive\">True</property>\n"
"<property name=\"secondary_icon_sensitive\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"padding\">12</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkButton\" id=\"button5\">\n"
"<property name=\"label\">gtk-open</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">True</property>\n"
"<property name=\"use_stock\">True</property>\n"
"<signal name=\"clicked\" handler=\"on_button_entry_clicked_folder\" object=\"-filesys.path_snap\" swapped=\"no\"/>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">5</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkVBox\" id=\"vbox15\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label40\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"xalign\">0</property>\n"
"<property name=\"label\" translatable=\"yes\">Path to directory for save states:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkHBox\" id=\"hbox26\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<object class=\"GtkEntry\" id=\"-filesys.path_state\">\n"
"<property name=\"width_request\">400</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"editable\">False</property>\n"
"<property name=\"invisible_char\">•</property>\n"
"<property name=\"invisible_char_set\">True</property>\n"
"<property name=\"primary_icon_activatable\">False</property>\n"
"<property name=\"secondary_icon_activatable\">False</property>\n"
"<property name=\"primary_icon_sensitive\">True</property>\n"
"<property name=\"secondary_icon_sensitive\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"padding\">12</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkButton\" id=\"button6\">\n"
"<property name=\"label\">gtk-open</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">True</property>\n"
"<property name=\"use_stock\">True</property>\n"
"<signal name=\"clicked\" handler=\"on_button_entry_clicked_folder\" object=\"-filesys.path_state\" swapped=\"no\"/>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">6</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"<child type=\"label\">\n"
"<object class=\"GtkLabel\" id=\"label41\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">&lt;b&gt;Paths&lt;/b&gt;</property>\n"
"<property name=\"use_markup\">True</property>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"position\">10</property>\n"
"</packing>\n"
"</child>\n"
"<child type=\"tab\">\n"
"<object class=\"GtkLabel\" id=\"label24\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">Paths</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"position\">10</property>\n"
"<property name=\"tab_fill\">False</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">True</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"<child type=\"tab\">\n"
"<object class=\"GtkLabel\" id=\"label2\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">Global Settings </property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"position\">1</property>\n"
"<property name=\"tab_fill\">False</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkHBox\" id=\"hbox3\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<object class=\"GtkTreeView\" id=\"systemlist\">\n"
"<property name=\"width_request\">400</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"model\">treemodelfilter1</property>\n"
"<property name=\"headers_visible\">False</property>\n"
"<property name=\"headers_clickable\">False</property>\n"
"<property name=\"enable_search\">False</property>\n"
"<child>\n"
"<object class=\"GtkTreeViewColumn\" id=\"treeviewcolumn2\">\n"
"<property name=\"title\" translatable=\"yes\">column</property>\n"
"<child>\n"
"<object class=\"GtkCellRendererText\" id=\"cellrenderertext13\"/>\n"
"<attributes>\n"
"<attribute name=\"text\">0</attribute>\n"
"</attributes>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkScrolledWindow\" id=\"scrolledwindow1\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"hscrollbar_policy\">automatic</property>\n"
"<property name=\"vscrollbar_policy\">automatic</property>\n"
"<child>\n"
"<object class=\"GtkViewport\" id=\"viewport1\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"shadow_type\">none</property>\n"
"<child>\n"
"<object class=\"GtkNotebook\" id=\"notebook3\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<child>\n"
"<object class=\"GtkVBox\" id=\"embox\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"<child type=\"tab\">\n"
"<object class=\"GtkLabel\" id=\"settings_label\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">Settings </property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"tab_fill\">False</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkVBox\" id=\"vbox3\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"border_width\">8</property>\n"
"<property name=\"spacing\">18</property>\n"
"<child>\n"
"<object class=\"GtkFrame\" id=\"frame1\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label_xalign\">0</property>\n"
"<property name=\"shadow_type\">none</property>\n"
"<child>\n"
"<object class=\"GtkAlignment\" id=\"alignment1\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"left_padding\">12</property>\n"
"<child>\n"
"<object class=\"GtkVBox\" id=\"vbox10\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<object class=\"GtkHBox\" id=\"hbox13\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<object class=\"GtkTable\" id=\"table3\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"n_rows\">4</property>\n"
"<property name=\"n_columns\">2</property>\n"
"<property name=\"column_spacing\">16</property>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label6\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">Bilinear interpolation:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"x_options\">GTK_FILL</property>\n"
"<property name=\"y_options\">GTK_FILL</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkComboBox\" id=\".videoip\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"has_tooltip\">True</property>\n"
"<property name=\"tooltip_text\" translatable=\"yes\">0 - Disabled\n"
"\n"
"1 - Bilinear\n"
"\n"
"x - Linear (X)\n"
"Interpolation only on the X axis.\n"
"\n"
"y - Linear (Y)\n"
"Interpolation only on the Y axis.</property>\n"
"<property name=\"model\">cbstorevideoip</property>\n"
"<property name=\"active\">0</property>\n"
"<child>\n"
"<object class=\"GtkCellRendererText\" id=\"cellrenderertext4\"/>\n"
"<attributes>\n"
"<attribute name=\"text\">0</attribute>\n"
"</attributes>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"left_attach\">1</property>\n"
"<property name=\"right_attach\">2</property>\n"
"<property name=\"x_options\">GTK_FILL</property>\n"
"<property name=\"y_options\">GTK_FILL</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkComboBox\" id=\".stretch\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"has_tooltip\">True</property>\n"
"<property name=\"tooltip_text\" translatable=\"yes\">0 - Disabled\n"
"\n"
"full - Full\n"
"Full-screen stretch, disregarding aspect ratio.\n"
"\n"
"aspect - Aspect Preserve\n"
"Full-screen stretch as far as the aspect ratio(in this sense, the equivalent xscalefs == yscalefs) can be maintained.\n"
"\n"
"aspect_int - Aspect Preserve + Integer Scale\n"
"Full-screen stretch, same as 'aspect' except that the equivalent xscalefs and yscalefs are rounded down to the nearest integer.\n"
"\n"
"aspect_mult2 - Aspect Preserve + Integer Multiple-of-2 Scale\n"
"Full-screen stretch, same as 'aspect_int', but rounds down to the nearest multiple of 2.</property>\n"
"<property name=\"model\">cbstore_stretch</property>\n"
"<property name=\"active\">4</property>\n"
"<child>\n"
"<object class=\"GtkCellRendererText\" id=\"cellrenderertext1\"/>\n"
"<attributes>\n"
"<attribute name=\"text\">0</attribute>\n"
"</attributes>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"left_attach\">1</property>\n"
"<property name=\"right_attach\">2</property>\n"
"<property name=\"top_attach\">1</property>\n"
"<property name=\"bottom_attach\">2</property>\n"
"<property name=\"x_options\">GTK_FILL</property>\n"
"<property name=\"y_options\">GTK_FILL</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkComboBox\" id=\".special\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"has_tooltip\">True</property>\n"
"<property name=\"tooltip_text\" translatable=\"yes\">The destination rectangle is NOT altered by this setting, so if you have xscale and yscale set to '2', and try to use a 3x scaling filter like hq3x, the image is not going to look that great. The nearest-neighbor scalers are intended for use with bilinear interpolation enabled, at high resolutions(such as 1280x1024; nn2x(or nny2x) + bilinear interpolation + fullscreen stretching at this resolution looks quite nice).</property>\n"
"<property name=\"model\">cbstorespecial</property>\n"
"<property name=\"active\">0</property>\n"
"<child>\n"
"<object class=\"GtkCellRendererText\" id=\"cellrenderertext5\"/>\n"
"<attributes>\n"
"<attribute name=\"text\">0</attribute>\n"
"</attributes>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"left_attach\">1</property>\n"
"<property name=\"right_attach\">2</property>\n"
"<property name=\"top_attach\">2</property>\n"
"<property name=\"bottom_attach\">3</property>\n"
"<property name=\"x_options\">GTK_FILL</property>\n"
"<property name=\"y_options\">GTK_FILL</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkComboBox\" id=\".pixshader\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"has_tooltip\">True</property>\n"
"<property name=\"tooltip_text\" translatable=\"yes\">Obviously, this will only work with the OpenGL 'video.driver' setting, and only on cards and OpenGL implementations that support pixel shaders, otherwise you will get a black screen, or Mednafen may display an error message when starting up.\n"
"\n"
"Bilinear interpolation is disabled with pixel shaders, and any interpolation, if present, will be noted in the description of each pixel shader.\n"
"\n"
"none - None/Disabled\n"
"\n"
"autoip - Auto Interpolation\n"
"Will automatically interpolate on each axis if the corresponding effective scaling factor is not an integer.\n"
"\n"
"autoipsharper - Sharper Auto Interpolation\n"
"Same as 'autoip', but when interpolation is done, it is done in a manner that will reduce blurriness if possible.\n"
"\n"
"scale2x - Scale2x\n"
"\n"
"sabr - SABR v3.0\n"
"GPU-intensive.\n"
"\n"
"ipsharper - Sharper bilinear interpolation.\n"
"\n"
"ipxnoty - Linear interpolation on X axis only.\n"
"\n"
"ipynotx - Linear interpolation on Y axis only.\n"
"\n"
"ipxnotysharper - Sharper version of 'ipxnoty'.\n"
"\n"
"ipynotxsharper - Sharper version of 'ipynotx'.</property>\n"
"<property name=\"model\">cbstorepix</property>\n"
"<property name=\"active\">0</property>\n"
"<child>\n"
"<object class=\"GtkCellRendererText\" id=\"cellrenderertext6\"/>\n"
"<attributes>\n"
"<attribute name=\"text\">0</attribute>\n"
"</attributes>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"left_attach\">1</property>\n"
"<property name=\"right_attach\">2</property>\n"
"<property name=\"top_attach\">3</property>\n"
"<property name=\"bottom_attach\">4</property>\n"
"<property name=\"x_options\">GTK_FILL</property>\n"
"<property name=\"y_options\">GTK_FILL</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label5\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">Stretch to fill screen:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"top_attach\">1</property>\n"
"<property name=\"bottom_attach\">2</property>\n"
"<property name=\"x_options\">GTK_FILL</property>\n"
"<property name=\"y_options\">GTK_FILL</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label20\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">Special video scaler:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"top_attach\">2</property>\n"
"<property name=\"bottom_attach\">3</property>\n"
"<property name=\"x_options\">GTK_FILL</property>\n"
"<property name=\"y_options\">GTK_FILL</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label21\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">OpenGL pixel shader:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"top_attach\">3</property>\n"
"<property name=\"bottom_attach\">4</property>\n"
"<property name=\"x_options\">GTK_FILL</property>\n"
"<property name=\"y_options\">GTK_FILL</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"<child type=\"label\">\n"
"<object class=\"GtkLabel\" id=\"label23\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">&lt;b&gt;Filters&lt;/b&gt;</property>\n"
"<property name=\"use_markup\">True</property>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkFrame\" id=\"frame10\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label_xalign\">0</property>\n"
"<property name=\"shadow_type\">none</property>\n"
"<child>\n"
"<object class=\"GtkAlignment\" id=\"alignment10\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"left_padding\">12</property>\n"
"<child>\n"
"<object class=\"GtkHBox\" id=\"hbox4\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"spacing\">12</property>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label22\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">Opacity:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkHScale\" id=\".scanlines\">\n"
"<property name=\"width_request\">300</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"has_tooltip\">True</property>\n"
"<property name=\"tooltip_text\" translatable=\"yes\">Enable scanlines with specified opacity.\n"
"\n"
"Opacity is specified in %; IE a value of \"100\" will give entirely black scanlines.\n"
"\n"
"Negative values are the same as positive values for non-interlaced video, but for interlaced video will cause the scanlines to be overlaid over the previous field's lines(only if the video.deinterlacer setting is set to \"weave\", the default).</property>\n"
"<property name=\"adjustment\">adscanlines</property>\n"
"<property name=\"round_digits\">0</property>\n"
"<property name=\"digits\">0</property>\n"
"<property name=\"value_pos\">left</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"<child type=\"label\">\n"
"<object class=\"GtkLabel\" id=\"label30\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">&lt;b&gt;Scanlines&lt;/b&gt;</property>\n"
"<property name=\"use_markup\">True</property>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkFrame\" id=\"frame8\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label_xalign\">0</property>\n"
"<property name=\"shadow_type\">none</property>\n"
"<child>\n"
"<object class=\"GtkAlignment\" id=\"alignment8\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"left_padding\">12</property>\n"
"<child>\n"
"<object class=\"GtkVBox\" id=\"vbox11\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<object class=\"GtkCheckButton\" id=\".tblur\">\n"
"<property name=\"label\" translatable=\"yes\">Enable video temporal blur</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">False</property>\n"
"<property name=\"draw_indicator\">True</property>\n"
"<signal name=\"toggled\" handler=\"on_tblur_toggled\" object=\"vbox12\" swapped=\"no\"/>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkAlignment\" id=\"alignment2\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"left_padding\">16</property>\n"
"<child>\n"
"<object class=\"GtkVBox\" id=\"vbox12\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"sensitive\">False</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<object class=\"GtkCheckButton\" id=\".tblur.accum\">\n"
"<property name=\"label\" translatable=\"yes\">Accumulate color data rather than discarding it</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">False</property>\n"
"<property name=\"draw_indicator\">True</property>\n"
"<signal name=\"toggled\" handler=\"on_tblur_toggled\" object=\"hbox5\" swapped=\"no\"/>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkHBox\" id=\"hbox5\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"sensitive\">False</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"spacing\">8</property>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"labeltblurnes\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">Blur amount in accumulation mode:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"padding\">24</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkSpinButton\" id=\".tblur.accum.amount\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"has_tooltip\">True</property>\n"
"<property name=\"tooltip_text\" translatable=\"yes\">In percentage of accumulation buffer to mix with the current frame.</property>\n"
"<property name=\"invisible_char\">•</property>\n"
"<property name=\"invisible_char_set\">True</property>\n"
"<property name=\"primary_icon_activatable\">False</property>\n"
"<property name=\"secondary_icon_activatable\">False</property>\n"
"<property name=\"primary_icon_sensitive\">True</property>\n"
"<property name=\"secondary_icon_sensitive\">True</property>\n"
"<property name=\"adjustment\">adjustblur</property>\n"
"<property name=\"numeric\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">True</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"<child type=\"label\">\n"
"<object class=\"GtkLabel\" id=\"label33\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">&lt;b&gt;Blur&lt;/b&gt;</property>\n"
"<property name=\"use_markup\">True</property>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">2</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"<child type=\"tab\">\n"
"<object class=\"GtkLabel\" id=\"label15\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">Filters </property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"position\">1</property>\n"
"<property name=\"tab_fill\">False</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkVBox\" id=\"vbox16\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"border_width\">8</property>\n"
"<property name=\"spacing\">16</property>\n"
"<child>\n"
"<object class=\"GtkFrame\" id=\"frame2\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label_xalign\">0</property>\n"
"<property name=\"shadow_type\">none</property>\n"
"<child>\n"
"<object class=\"GtkAlignment\" id=\"alignment9\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"left_padding\">12</property>\n"
"<child>\n"
"<object class=\"GtkTable\" id=\"table1\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"n_rows\">3</property>\n"
"<property name=\"n_columns\">3</property>\n"
"<property name=\"column_spacing\">16</property>\n"
"<property name=\"row_spacing\">8</property>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label28\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">X</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"left_attach\">1</property>\n"
"<property name=\"right_attach\">2</property>\n"
"<property name=\"x_options\"/>\n"
"<property name=\"y_options\"/>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label32\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">Y</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"left_attach\">2</property>\n"
"<property name=\"right_attach\">3</property>\n"
"<property name=\"x_options\"/>\n"
"<property name=\"y_options\"/>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label26\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">Scaling factor:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"top_attach\">2</property>\n"
"<property name=\"bottom_attach\">3</property>\n"
"<property name=\"x_options\"/>\n"
"<property name=\"y_options\"/>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkSpinButton\" id=\".xres\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"has_tooltip\">True</property>\n"
"<property name=\"tooltip_text\" translatable=\"yes\">A value of '0' will cause the desktop horizontal resolution to be used.</property>\n"
"<property name=\"invisible_char\">•</property>\n"
"<property name=\"invisible_char_set\">True</property>\n"
"<property name=\"primary_icon_activatable\">False</property>\n"
"<property name=\"secondary_icon_activatable\">False</property>\n"
"<property name=\"primary_icon_sensitive\">True</property>\n"
"<property name=\"secondary_icon_sensitive\">True</property>\n"
"<property name=\"adjustment\">adjxres</property>\n"
"<property name=\"numeric\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"left_attach\">1</property>\n"
"<property name=\"right_attach\">2</property>\n"
"<property name=\"top_attach\">1</property>\n"
"<property name=\"bottom_attach\">2</property>\n"
"<property name=\"x_options\"/>\n"
"<property name=\"y_options\"/>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkSpinButton\" id=\".xscalefs\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"has_tooltip\">True</property>\n"
"<property name=\"tooltip_text\" translatable=\"yes\">For this settings to have any effect, the 'stretch' setting must be set to '0'.</property>\n"
"<property name=\"invisible_char\">•</property>\n"
"<property name=\"invisible_char_set\">True</property>\n"
"<property name=\"primary_icon_activatable\">False</property>\n"
"<property name=\"secondary_icon_activatable\">False</property>\n"
"<property name=\"primary_icon_sensitive\">True</property>\n"
"<property name=\"secondary_icon_sensitive\">True</property>\n"
"<property name=\"adjustment\">adjxscalefs</property>\n"
"<property name=\"digits\">2</property>\n"
"<property name=\"numeric\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"left_attach\">1</property>\n"
"<property name=\"right_attach\">2</property>\n"
"<property name=\"top_attach\">2</property>\n"
"<property name=\"bottom_attach\">3</property>\n"
"<property name=\"x_options\"/>\n"
"<property name=\"y_options\"/>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkSpinButton\" id=\".yres\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"has_tooltip\">True</property>\n"
"<property name=\"tooltip_text\" translatable=\"yes\">A value of '0' will cause the desktop vertical resolution to be used.</property>\n"
"<property name=\"invisible_char\">•</property>\n"
"<property name=\"invisible_char_set\">True</property>\n"
"<property name=\"primary_icon_activatable\">False</property>\n"
"<property name=\"secondary_icon_activatable\">False</property>\n"
"<property name=\"primary_icon_sensitive\">True</property>\n"
"<property name=\"secondary_icon_sensitive\">True</property>\n"
"<property name=\"adjustment\">adyres</property>\n"
"<property name=\"numeric\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"left_attach\">2</property>\n"
"<property name=\"right_attach\">3</property>\n"
"<property name=\"top_attach\">1</property>\n"
"<property name=\"bottom_attach\">2</property>\n"
"<property name=\"x_options\"/>\n"
"<property name=\"y_options\"/>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkSpinButton\" id=\".yscalefs\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"has_tooltip\">True</property>\n"
"<property name=\"tooltip_text\" translatable=\"yes\">For this settings to have any effect, the 'stretch' setting must be set to '0'.</property>\n"
"<property name=\"invisible_char\">•</property>\n"
"<property name=\"invisible_char_set\">True</property>\n"
"<property name=\"primary_icon_activatable\">False</property>\n"
"<property name=\"secondary_icon_activatable\">False</property>\n"
"<property name=\"primary_icon_sensitive\">True</property>\n"
"<property name=\"secondary_icon_sensitive\">True</property>\n"
"<property name=\"adjustment\">adjyscalefs</property>\n"
"<property name=\"digits\">2</property>\n"
"<property name=\"numeric\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"left_attach\">2</property>\n"
"<property name=\"right_attach\">3</property>\n"
"<property name=\"top_attach\">2</property>\n"
"<property name=\"bottom_attach\">3</property>\n"
"<property name=\"x_options\"/>\n"
"<property name=\"y_options\"/>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkHBox\" id=\"hbox9\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label25\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">Resolution:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"top_attach\">1</property>\n"
"<property name=\"bottom_attach\">2</property>\n"
"<property name=\"x_options\"/>\n"
"<property name=\"y_options\"/>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"<child type=\"label\">\n"
"<object class=\"GtkLabel\" id=\"label29\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">&lt;b&gt;Fullscreen&lt;/b&gt;</property>\n"
"<property name=\"use_markup\">True</property>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkFrame\" id=\"frame3\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label_xalign\">0</property>\n"
"<property name=\"shadow_type\">none</property>\n"
"<child>\n"
"<object class=\"GtkAlignment\" id=\"alignment12\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"left_padding\">12</property>\n"
"<child>\n"
"<object class=\"GtkTable\" id=\"table2\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"n_rows\">2</property>\n"
"<property name=\"n_columns\">3</property>\n"
"<property name=\"column_spacing\">16</property>\n"
"<property name=\"row_spacing\">8</property>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label34\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">X</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"left_attach\">1</property>\n"
"<property name=\"right_attach\">2</property>\n"
"<property name=\"x_options\"/>\n"
"<property name=\"y_options\"/>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label36\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">Y</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"left_attach\">2</property>\n"
"<property name=\"right_attach\">3</property>\n"
"<property name=\"x_options\"/>\n"
"<property name=\"y_options\"/>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkSpinButton\" id=\".xscale\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"invisible_char\">•</property>\n"
"<property name=\"invisible_char_set\">True</property>\n"
"<property name=\"primary_icon_activatable\">False</property>\n"
"<property name=\"secondary_icon_activatable\">False</property>\n"
"<property name=\"primary_icon_sensitive\">True</property>\n"
"<property name=\"secondary_icon_sensitive\">True</property>\n"
"<property name=\"adjustment\">adjxscale</property>\n"
"<property name=\"digits\">2</property>\n"
"<property name=\"numeric\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"left_attach\">1</property>\n"
"<property name=\"right_attach\">2</property>\n"
"<property name=\"top_attach\">1</property>\n"
"<property name=\"bottom_attach\">2</property>\n"
"<property name=\"x_options\"/>\n"
"<property name=\"y_options\"/>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkSpinButton\" id=\".yscale\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"invisible_char\">•</property>\n"
"<property name=\"invisible_char_set\">True</property>\n"
"<property name=\"primary_icon_activatable\">False</property>\n"
"<property name=\"secondary_icon_activatable\">False</property>\n"
"<property name=\"primary_icon_sensitive\">True</property>\n"
"<property name=\"secondary_icon_sensitive\">True</property>\n"
"<property name=\"adjustment\">adjyscale</property>\n"
"<property name=\"digits\">2</property>\n"
"<property name=\"numeric\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"left_attach\">2</property>\n"
"<property name=\"right_attach\">3</property>\n"
"<property name=\"top_attach\">1</property>\n"
"<property name=\"bottom_attach\">2</property>\n"
"<property name=\"x_options\"/>\n"
"<property name=\"y_options\"/>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkHBox\" id=\"hbox16\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label27\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">Scaling factor:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"top_attach\">1</property>\n"
"<property name=\"bottom_attach\">2</property>\n"
"<property name=\"x_options\"/>\n"
"<property name=\"y_options\"/>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"<child type=\"label\">\n"
"<object class=\"GtkLabel\" id=\"label31\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">&lt;b&gt;Windowed&lt;/b&gt;</property>\n"
"<property name=\"use_markup\">True</property>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"position\">2</property>\n"
"</packing>\n"
"</child>\n"
"<child type=\"tab\">\n"
"<object class=\"GtkLabel\" id=\"label35\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">Resolution </property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"position\">2</property>\n"
"<property name=\"tab_fill\">False</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkVBox\" id=\"vbox25\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"border_width\">8</property>\n"
"<property name=\"spacing\">18</property>\n"
"<child>\n"
"<object class=\"GtkFrame\" id=\"frame43\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label_xalign\">0</property>\n"
"<property name=\"shadow_type\">none</property>\n"
"<child>\n"
"<object class=\"GtkAlignment\" id=\"alignment45\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"left_padding\">12</property>\n"
"<child>\n"
"<object class=\"GtkVBox\" id=\"vbox26\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"spacing\">12</property>\n"
"<child>\n"
"<object class=\"GtkVBox\" id=\"inputbox\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkHBox\" id=\"hbox33\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<object class=\"GtkButton\" id=\"inputbutton\">\n"
"<property name=\"label\" translatable=\"yes\">Controller Setup</property>\n"
"<property name=\"width_request\">300</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">True</property>\n"
"<property name=\"image\">image21</property>\n"
"<signal name=\"clicked\" handler=\"on_input_clicked\" swapped=\"no\"/>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">False</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"<child type=\"label\">\n"
"<object class=\"GtkLabel\" id=\"label68\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">&lt;b&gt;Input&lt;/b&gt;</property>\n"
"<property name=\"use_markup\">True</property>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"position\">3</property>\n"
"</packing>\n"
"</child>\n"
"<child type=\"tab\">\n"
"<object class=\"GtkLabel\" id=\"label55\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">Input </property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"position\">3</property>\n"
"<property name=\"tab_fill\">False</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkVBox\" id=\"vbox6\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"border_width\">8</property>\n"
"<property name=\"spacing\">18</property>\n"
"<child>\n"
"<object class=\"GtkFrame\" id=\"frame19\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label_xalign\">0</property>\n"
"<property name=\"shadow_type\">none</property>\n"
"<child>\n"
"<object class=\"GtkAlignment\" id=\"alignment22\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"left_padding\">12</property>\n"
"<child>\n"
"<object class=\"GtkVBox\" id=\"vbox24\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<object class=\"GtkCheckButton\" id=\"-nes.ntscblitter\">\n"
"<property name=\"label\" translatable=\"yes\">Enable NTSC color generation and blitter</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">False</property>\n"
"<property name=\"has_tooltip\">True</property>\n"
"<property name=\"tooltip_text\" translatable=\"yes\">NOTE: If your refresh rate isn't very close to 60.1Hz(+-0.1), you will need to enable the 'Merge fields to ...' setting to avoid excessive flickering.</property>\n"
"<property name=\"draw_indicator\">True</property>\n"
"<signal name=\"toggled\" handler=\"on_tblur_toggled\" object=\"ntscbox\" swapped=\"no\"/>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkAlignment\" id=\"alignment23\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"top_padding\">8</property>\n"
"<property name=\"left_padding\">16</property>\n"
"<child>\n"
"<object class=\"GtkVBox\" id=\"ntscbox\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"sensitive\">False</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<object class=\"GtkCheckButton\" id=\"-nes.ntsc.mergefields\">\n"
"<property name=\"label\" translatable=\"yes\">Merge fields to partially work around !=60.1Hz refresh rates</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">False</property>\n"
"<property name=\"draw_indicator\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkHBox\" id=\"hbox19\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"spacing\">18</property>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label74\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">Video quality/type preset:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkComboBox\" id=\"-nes.ntsc.preset\">\n"
"<property name=\"width_request\">150</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"model\">ntscstore</property>\n"
"<property name=\"active\">0</property>\n"
"<signal name=\"changed\" handler=\"on_ntsc_changed\" object=\"ntscbox2\" swapped=\"no\"/>\n"
"<child>\n"
"<object class=\"GtkCellRendererText\" id=\"cellrenderertext9\"/>\n"
"<attributes>\n"
"<attribute name=\"text\">0</attribute>\n"
"</attributes>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"padding\">4</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkAlignment\" id=\"alignment24\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"top_padding\">8</property>\n"
"<property name=\"left_padding\">16</property>\n"
"<child>\n"
"<object class=\"GtkVBox\" id=\"ntscbox2\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<object class=\"GtkTable\" id=\"table6\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"n_rows\">5</property>\n"
"<property name=\"n_columns\">2</property>\n"
"<property name=\"column_spacing\">16</property>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label79\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">Brightness:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"x_options\">GTK_FILL</property>\n"
"<property name=\"y_options\">GTK_FILL</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkHScale\" id=\"-nes.ntsc.brightness\">\n"
"<property name=\"width_request\">300</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"adjustment\">adjntscbright</property>\n"
"<property name=\"round_digits\">2</property>\n"
"<property name=\"digits\">2</property>\n"
"<property name=\"value_pos\">left</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"left_attach\">1</property>\n"
"<property name=\"right_attach\">2</property>\n"
"<property name=\"x_options\">GTK_FILL</property>\n"
"<property name=\"y_options\">GTK_FILL</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkHScale\" id=\"-nes.ntsc.contrast\">\n"
"<property name=\"width_request\">300</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"adjustment\">adjntsccon</property>\n"
"<property name=\"round_digits\">2</property>\n"
"<property name=\"digits\">2</property>\n"
"<property name=\"value_pos\">left</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"left_attach\">1</property>\n"
"<property name=\"right_attach\">2</property>\n"
"<property name=\"top_attach\">1</property>\n"
"<property name=\"bottom_attach\">2</property>\n"
"<property name=\"x_options\">GTK_FILL</property>\n"
"<property name=\"y_options\">GTK_FILL</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkHScale\" id=\"-nes.ntsc.hue\">\n"
"<property name=\"width_request\">300</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"adjustment\">adjntschue</property>\n"
"<property name=\"round_digits\">2</property>\n"
"<property name=\"digits\">2</property>\n"
"<property name=\"value_pos\">left</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"left_attach\">1</property>\n"
"<property name=\"right_attach\">2</property>\n"
"<property name=\"top_attach\">2</property>\n"
"<property name=\"bottom_attach\">3</property>\n"
"<property name=\"x_options\">GTK_FILL</property>\n"
"<property name=\"y_options\">GTK_FILL</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkHScale\" id=\"-nes.ntsc.saturation\">\n"
"<property name=\"width_request\">300</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"adjustment\">adjntscsat</property>\n"
"<property name=\"round_digits\">2</property>\n"
"<property name=\"digits\">2</property>\n"
"<property name=\"value_pos\">left</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"left_attach\">1</property>\n"
"<property name=\"right_attach\">2</property>\n"
"<property name=\"top_attach\">3</property>\n"
"<property name=\"bottom_attach\">4</property>\n"
"<property name=\"x_options\">GTK_FILL</property>\n"
"<property name=\"y_options\">GTK_FILL</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkHScale\" id=\"-nes.ntsc.sharpness\">\n"
"<property name=\"width_request\">300</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"adjustment\">adjntscsharp</property>\n"
"<property name=\"round_digits\">2</property>\n"
"<property name=\"digits\">2</property>\n"
"<property name=\"value_pos\">left</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"left_attach\">1</property>\n"
"<property name=\"right_attach\">2</property>\n"
"<property name=\"top_attach\">4</property>\n"
"<property name=\"bottom_attach\">5</property>\n"
"<property name=\"x_options\">GTK_FILL</property>\n"
"<property name=\"y_options\">GTK_FILL</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label75\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">Contrast:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"top_attach\">1</property>\n"
"<property name=\"bottom_attach\">2</property>\n"
"<property name=\"x_options\">GTK_FILL</property>\n"
"<property name=\"y_options\">GTK_FILL</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label76\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">Hue:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"top_attach\">2</property>\n"
"<property name=\"bottom_attach\">3</property>\n"
"<property name=\"x_options\">GTK_FILL</property>\n"
"<property name=\"y_options\">GTK_FILL</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label77\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">Saturation:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"top_attach\">3</property>\n"
"<property name=\"bottom_attach\">4</property>\n"
"<property name=\"x_options\">GTK_FILL</property>\n"
"<property name=\"y_options\">GTK_FILL</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label82\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">Sharpness:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"top_attach\">4</property>\n"
"<property name=\"bottom_attach\">5</property>\n"
"<property name=\"x_options\">GTK_FILL</property>\n"
"<property name=\"y_options\">GTK_FILL</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkVBox\" id=\"customntscbox\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<object class=\"GtkCheckButton\" id=\"-nes.ntsc.matrix\">\n"
"<property name=\"label\" translatable=\"yes\">Enable NTSC custom decoder matrix</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">False</property>\n"
"<property name=\"draw_indicator\">True</property>\n"
"<signal name=\"toggled\" handler=\"on_tblur_toggled\" object=\"matrixbox\" swapped=\"no\"/>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkAlignment\" id=\"alignment25\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"top_padding\">8</property>\n"
"<property name=\"left_padding\">32</property>\n"
"<child>\n"
"<object class=\"GtkTable\" id=\"matrixbox\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"sensitive\">False</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"n_rows\">6</property>\n"
"<property name=\"n_columns\">2</property>\n"
"<property name=\"column_spacing\">16</property>\n"
"<child>\n"
"<object class=\"GtkSpinButton\" id=\"-nes.ntsc.matrix.0\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"invisible_char\">•</property>\n"
"<property name=\"invisible_char_set\">True</property>\n"
"<property name=\"primary_icon_activatable\">False</property>\n"
"<property name=\"secondary_icon_activatable\">False</property>\n"
"<property name=\"primary_icon_sensitive\">True</property>\n"
"<property name=\"secondary_icon_sensitive\">True</property>\n"
"<property name=\"adjustment\">adjntscmatrix0</property>\n"
"<property name=\"digits\">3</property>\n"
"<property name=\"numeric\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"left_attach\">1</property>\n"
"<property name=\"right_attach\">2</property>\n"
"<property name=\"x_options\">GTK_FILL</property>\n"
"<property name=\"y_options\">GTK_FILL</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkSpinButton\" id=\"-nes.ntsc.matrix.1\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"invisible_char\">•</property>\n"
"<property name=\"invisible_char_set\">True</property>\n"
"<property name=\"primary_icon_activatable\">False</property>\n"
"<property name=\"secondary_icon_activatable\">False</property>\n"
"<property name=\"primary_icon_sensitive\">True</property>\n"
"<property name=\"secondary_icon_sensitive\">True</property>\n"
"<property name=\"adjustment\">adjntscmatrix1</property>\n"
"<property name=\"digits\">3</property>\n"
"<property name=\"numeric\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"left_attach\">1</property>\n"
"<property name=\"right_attach\">2</property>\n"
"<property name=\"top_attach\">1</property>\n"
"<property name=\"bottom_attach\">2</property>\n"
"<property name=\"x_options\">GTK_FILL</property>\n"
"<property name=\"y_options\">GTK_FILL</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkSpinButton\" id=\"-nes.ntsc.matrix.2\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"invisible_char\">•</property>\n"
"<property name=\"invisible_char_set\">True</property>\n"
"<property name=\"primary_icon_activatable\">False</property>\n"
"<property name=\"secondary_icon_activatable\">False</property>\n"
"<property name=\"primary_icon_sensitive\">True</property>\n"
"<property name=\"secondary_icon_sensitive\">True</property>\n"
"<property name=\"adjustment\">adjntscmatrix2</property>\n"
"<property name=\"digits\">3</property>\n"
"<property name=\"numeric\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"left_attach\">1</property>\n"
"<property name=\"right_attach\">2</property>\n"
"<property name=\"top_attach\">2</property>\n"
"<property name=\"bottom_attach\">3</property>\n"
"<property name=\"x_options\">GTK_FILL</property>\n"
"<property name=\"y_options\">GTK_FILL</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkSpinButton\" id=\"-nes.ntsc.matrix.3\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"invisible_char\">•</property>\n"
"<property name=\"invisible_char_set\">True</property>\n"
"<property name=\"primary_icon_activatable\">False</property>\n"
"<property name=\"secondary_icon_activatable\">False</property>\n"
"<property name=\"primary_icon_sensitive\">True</property>\n"
"<property name=\"secondary_icon_sensitive\">True</property>\n"
"<property name=\"adjustment\">adjntscmatrix3</property>\n"
"<property name=\"digits\">3</property>\n"
"<property name=\"numeric\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"left_attach\">1</property>\n"
"<property name=\"right_attach\">2</property>\n"
"<property name=\"top_attach\">3</property>\n"
"<property name=\"bottom_attach\">4</property>\n"
"<property name=\"x_options\">GTK_FILL</property>\n"
"<property name=\"y_options\">GTK_FILL</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkSpinButton\" id=\"-nes.ntsc.matrix.4\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"invisible_char\">•</property>\n"
"<property name=\"invisible_char_set\">True</property>\n"
"<property name=\"primary_icon_activatable\">False</property>\n"
"<property name=\"secondary_icon_activatable\">False</property>\n"
"<property name=\"primary_icon_sensitive\">True</property>\n"
"<property name=\"secondary_icon_sensitive\">True</property>\n"
"<property name=\"adjustment\">adjntscmatrix4</property>\n"
"<property name=\"digits\">3</property>\n"
"<property name=\"numeric\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"left_attach\">1</property>\n"
"<property name=\"right_attach\">2</property>\n"
"<property name=\"top_attach\">4</property>\n"
"<property name=\"bottom_attach\">5</property>\n"
"<property name=\"x_options\">GTK_FILL</property>\n"
"<property name=\"y_options\">GTK_FILL</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkSpinButton\" id=\"-nes.ntsc.matrix.5\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"invisible_char\">•</property>\n"
"<property name=\"invisible_char_set\">True</property>\n"
"<property name=\"primary_icon_activatable\">False</property>\n"
"<property name=\"secondary_icon_activatable\">False</property>\n"
"<property name=\"primary_icon_sensitive\">True</property>\n"
"<property name=\"secondary_icon_sensitive\">True</property>\n"
"<property name=\"adjustment\">adjntscmatrix5</property>\n"
"<property name=\"digits\">3</property>\n"
"<property name=\"numeric\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"left_attach\">1</property>\n"
"<property name=\"right_attach\">2</property>\n"
"<property name=\"top_attach\">5</property>\n"
"<property name=\"bottom_attach\">6</property>\n"
"<property name=\"x_options\">GTK_FILL</property>\n"
"<property name=\"y_options\">GTK_FILL</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label81\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"xalign\">0</property>\n"
"<property name=\"label\" translatable=\"yes\">Element 0 (red, value * V):</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"x_options\">GTK_FILL</property>\n"
"<property name=\"y_options\">GTK_FILL</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label83\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"xalign\">0</property>\n"
"<property name=\"label\" translatable=\"yes\">Element 1 (red, value * U):</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"top_attach\">1</property>\n"
"<property name=\"bottom_attach\">2</property>\n"
"<property name=\"x_options\">GTK_FILL</property>\n"
"<property name=\"y_options\">GTK_FILL</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label84\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"xalign\">0</property>\n"
"<property name=\"label\" translatable=\"yes\">Element 2 (green, value * V):</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"top_attach\">2</property>\n"
"<property name=\"bottom_attach\">3</property>\n"
"<property name=\"x_options\">GTK_FILL</property>\n"
"<property name=\"y_options\">GTK_FILL</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label85\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"xalign\">0</property>\n"
"<property name=\"label\" translatable=\"yes\">Element 3 (green, value * U):</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"top_attach\">3</property>\n"
"<property name=\"bottom_attach\">4</property>\n"
"<property name=\"x_options\">GTK_FILL</property>\n"
"<property name=\"y_options\">GTK_FILL</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label88\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"xalign\">0</property>\n"
"<property name=\"label\" translatable=\"yes\">Element 4 (blue, value * V):</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"top_attach\">4</property>\n"
"<property name=\"bottom_attach\">5</property>\n"
"<property name=\"x_options\">GTK_FILL</property>\n"
"<property name=\"y_options\">GTK_FILL</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label89\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"xalign\">0</property>\n"
"<property name=\"label\" translatable=\"yes\">Element 5 (blue, value * U):</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"top_attach\">5</property>\n"
"<property name=\"bottom_attach\">6</property>\n"
"<property name=\"x_options\">GTK_FILL</property>\n"
"<property name=\"y_options\">GTK_FILL</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"padding\">9</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"padding\">9</property>\n"
"<property name=\"position\">2</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"<child type=\"label\">\n"
"<object class=\"GtkLabel\" id=\"label78\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">&lt;b&gt;NTSC Blitter&lt;/b&gt;</property>\n"
"<property name=\"use_markup\">True</property>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"position\">4</property>\n"
"</packing>\n"
"</child>\n"
"<child type=\"tab\">\n"
"<object class=\"GtkLabel\" id=\"label72\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">NTSC </property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"position\">4</property>\n"
"<property name=\"tab_fill\">False</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">True</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"position\">2</property>\n"
"</packing>\n"
"</child>\n"
"<child type=\"tab\">\n"
"<object class=\"GtkLabel\" id=\"label4\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">Systems </property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"position\">2</property>\n"
"<property name=\"tab_fill\">False</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkNotebook\" id=\"notebook4\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<child>\n"
"<object class=\"GtkScrolledWindow\" id=\"scrolledwindow2\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"hscrollbar_policy\">automatic</property>\n"
"<property name=\"vscrollbar_policy\">automatic</property>\n"
"<child>\n"
"<object class=\"GtkTextView\" id=\"textview2\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"editable\">False</property>\n"
"<property name=\"wrap_mode\">word</property>\n"
"<property name=\"cursor_visible\">False</property>\n"
"<property name=\"buffer\">textbufferfe</property>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"<child type=\"tab\">\n"
"<object class=\"GtkLabel\" id=\"label73\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">Front End </property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"tab_fill\">False</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkScrolledWindow\" id=\"scrolledwindow3\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"hscrollbar_policy\">automatic</property>\n"
"<property name=\"vscrollbar_policy\">automatic</property>\n"
"<child>\n"
"<object class=\"GtkTextView\" id=\"textview1\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"editable\">False</property>\n"
"<property name=\"wrap_mode\">word</property>\n"
"<property name=\"cursor_visible\">False</property>\n"
"<property name=\"buffer\">textbufferout</property>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"<child type=\"tab\">\n"
"<object class=\"GtkLabel\" id=\"label80\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">Emulator </property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"position\">1</property>\n"
"<property name=\"tab_fill\">False</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"position\">3</property>\n"
"</packing>\n"
"</child>\n"
"<child type=\"tab\">\n"
"<object class=\"GtkLabel\" id=\"label71\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">Logs </property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"position\">3</property>\n"
"<property name=\"tab_fill\">False</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">True</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkButton\" id=\"button1\">\n"
"<property name=\"label\">_Launch</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">False</property>\n"
"<property name=\"image\">image2</property>\n"
"<property name=\"use_underline\">True</property>\n"
"<signal name=\"clicked\" handler=\"play_exec\" swapped=\"no\"/>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">2</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkHBox\" id=\"hbox8\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<object class=\"GtkStatusbar\" id=\"sbnumber\">\n"
"<property name=\"width_request\">150</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkStatusbar\" id=\"sbname\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">True</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkStatusbar\" id=\"sbversion\">\n"
"<property name=\"width_request\">170</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">2</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">3</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"</interface>\n"
;

#endif /* MEDNAFFE_GLADE_H */
