/*
 * medussa - a distributed cracking system
 * Copyright (C) 1999 Kostas Evangelinos <kos@bastard.net>
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

/*
 * $Id: obfuscate.h,v 1.4 2003/02/05 04:38:37 kos Exp $
 *
 */

#ifndef _OBFUSCATE_H
#define _OBFUSCATE_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "keyspace.h"
#include "generator.h"

#define OBFUSCATE_DEFLEN 8
#define OBFUSCATE_DEFSEED 1926
#define OBFUSCATE_TABLECOL_L 256

typedef struct obfuscate_t {
  int len;
  int minlen;
  int maxlen;  
  key_index_t temp;
  key_index_t index;
  key_index_t minindex;
  key_index_t maxindex;
  key_index_t cur_min;
  key_index_t cur_max;
  key_index_t divisor;
  kchar *table;
  int seed;
} obfuscate_t;

obfuscate_t *obfuscate_init(char *params);
int obfuscate_set(obfuscate_t *, key_index_t index);
int obfuscate_fetch(obfuscate_t *, kchar *buf, int len, int *rlen);
int obfuscate_done(obfuscate_t *);
int obfuscate_destroy(obfuscate_t *);
key_index_t *obfuscate_minindex(obfuscate_t *);
key_index_t *obfuscate_maxindex(obfuscate_t *);
key_index_t *obfuscate_curindex(obfuscate_t *);
int obfuscate_minlen(obfuscate_t *);
int obfuscate_maxlen(obfuscate_t *);

#endif /* _OBFUSCATE_H */
