##############################################################################
#
# Main widget for PyQt MemAid <Peter.Bienstman@ugent.be>
#
##############################################################################

import sys, os
from qt import *
from main_frm import *
from import_dlg import *
from export_dlg import *
from add_items_dlg import *
from edit_item_dlg import *
from edit_items_dlg import *
from activate_categories_dlg import *
from learning_mode_dlg import *
from help_dlg import *
from memaid_core import *



##############################################################################
#
# MainDlg
#
##############################################################################

class MainDlg(MainFrm):

    ##########################################################################
    #
    # __init__
    #
    ##########################################################################
    
    def __init__(self,filename, item_id, parent = None,name = None,fl = 0):
        MainFrm.__init__(self,parent,name,fl)
        
        self.today = QLabel("Today: 0", self.statusBar())
        self.all = QLabel("All: 0", self.statusBar())
        
        self.statusBar().addWidget(self.today,0,1)
        self.statusBar().addWidget(self.all,0,1)
        
        self.statusBar().setSizeGripEnabled(0)
        
        self.connect(self.importAction,SIGNAL("activated()"), self.importXML)
        self.connect(self.exportAction,SIGNAL("activated()"), self.exportXML)
        
        self.connect(self.addItemsAction,SIGNAL("activated()"),
                     self.addItems)
        self.connect(self.editItemsAction,SIGNAL("activated()"),
                     self.editItems)
        self.connect(self.editCurrentItemAction,SIGNAL("activated()"),
                     self.editCurrentItem)
        self.connect(self.activateCategoriesAction,SIGNAL("activated()"),
                     self.activateCategories)
        
        load_config()
        try:
            if filename != None:
                load_database(filename)
            else:
                load_database(get_config("path"))
        except:
            if not os.path.exists(os.path.expanduser("~/.memaid/default.mem")):
                new_database(os.path.expanduser("~/.memaid/default.mem"))
            set_config("path", os.path.expanduser("~/.memaid/default.mem"))
            load_database(get_config("path"))           
        self.updateCaption()
        self.updateStatusBar()
            
        if get_config("hide_toolbar") == True:
            self.toolbar.hide()
            self.showToolbarAction.setOn(0)

        self.connect(self.showToolbarAction,SIGNAL("toggled(bool)"),
                     self.showToolbar)
        self.connect(self.changeFontAction,SIGNAL("activated()"),
                     self.changeFont)
        self.connect(self.setLearningModeAction,SIGNAL("activated()"),
                     self.setLearningMode)
        self.connect(self.show_button, SIGNAL("clicked()"),
                     self.showAnswer)
        self.connect(self.grades,SIGNAL("clicked(int)"),
                     self.gradeAnswer)
        self.connect(self.helpAction,SIGNAL("activated()"),
                     self.helpContents)
        
        if get_config("font") != None:
            font = self.listToFont(get_config("font"))
            self.question_text.setFont(font)
            self.answer_text.setFont(font)
            
        if sys.platform == "win32":
            path = "pixmaps"
        else:
            path = os.path.join(sys.exec_prefix, "lib", "python"+sys.version[:3],
                                "site-packages","pyqt_memaid", "pixmaps")

        self.fileNewAction.setIconSet \
             (QIconSet(QPixmap(os.path.join(path,"filenew.png"))))
        self.fileOpenAction.setIconSet \
             (QIconSet(QPixmap(os.path.join(path,"fileopen.png"))))
        self.fileSaveAction.setIconSet \
             (QIconSet(QPixmap(os.path.join(path,"filesave.png"))))
        self.fileSaveAsAction.setIconSet \
             (QIconSet(QPixmap(os.path.join(path,"filesaveas.png"))))
        self.importAction.setIconSet \
             (QIconSet(QPixmap(os.path.join(path,"fileimport.png"))))
        self.exportAction.setIconSet \
             (QIconSet(QPixmap(os.path.join(path,"fileexport.png"))))
        self.fileExitAction.setIconSet \
             (QIconSet(QPixmap(os.path.join(path,"exit.png"))))

        self.addItemsAction.setIconSet \
             (QIconSet(QPixmap(os.path.join(path,"edit_add.png"))))
        self.editItemsAction.setIconSet \
             (QIconSet(QPixmap(os.path.join(path,"edit.png"))))
        self.editCurrentItemAction.setIconSet \
             (QIconSet(QPixmap(os.path.join(path,"editclear.png"))))
        self.setLearningModeAction.setIconSet \
             (QIconSet(QPixmap(os.path.join(path,"configure.png"))))

        self.setIcon(QPixmap(os.path.join(path,"memaid.png")))

        self.need_to_train = False

        if item_id != None:
            try:
                item = get_item_by_id(long(item_id))
                dlg = EditItemDlg(item,self,"Edit item",0)
                dlg.exec_loop()
            except:
                pass
        
        self.newQuestion()
        
    ##########################################################################
    #
    # fileNew
    #
    ##########################################################################

    def fileNew(self):
        
        path = os.path.expanduser("~/.memaid")
        out = unicode(QFileDialog.getSaveFileName(path, "*.mem"))
        if out != "":
            
            if out[-4:] != ".mem":
                out += ".mem"
                
            if os.path.exists(out):
                status = QMessageBox.warning(None,
                    self.trUtf8("PyQt MemAid"),
                    self.trUtf8("Overwrite existing file?"),
                    self.trUtf8("&Yes"), self.trUtf8("&No"),
                    None, 1, -1)
                if status == 1:
                    return

            self.train_nn_for_x_ms(1000)
            self.need_to_train = False
            unload_database()
            self.clearQuestion()
            self.updateStatusBar()

            new_database(out)
            load_database(get_config("path"))
            self.updateCaption()
            
    ##########################################################################
    #
    # fileOpen
    #
    ##########################################################################

    def fileOpen(self):
                
        out = unicode(QFileDialog.getOpenFileName(get_config("path"),"*.mem"))
        if out != "":

            self.train_nn_for_x_ms(1000)
            self.need_to_train = False
            status = unload_database()
            if status == False:
                QMessageBox.critical(None,
                                     self.trUtf8("PyQt MemAid"),
                                     self.trUtf8("Unable to save file."),
                                     self.trUtf8("&OK"), None, None, 0, -1)   
            self.clearQuestion()
            self.updateStatusBar()
            
            status = load_database(out)
            self.updateCaption()
            if status == False:
                QMessageBox.critical(None,
                    self.trUtf8("PyQt MemAid"),
                    self.trUtf8("File doesn't appear to be in "+\
                                "the correct format."),
                    self.trUtf8("&OK"), None, None, 0, -1)
                return

            self.updateStatusBar()
            self.newQuestion()
                
    ##########################################################################
    #
    # fileSave
    #
    ##########################################################################
    
    def fileSave(self):
        if list_is_loaded() == True:
            status = save_database(get_config("path"))
            if status == False:
                QMessageBox.critical(None,
                    self.trUtf8("PyQt MemAid"),
                    self.trUtf8("Unable to save file."),
                    self.trUtf8("&OK"), None, None, 0, -1)
                return

    ##########################################################################
    #
    # fileSaveAs
    #
    ##########################################################################

    def fileSaveAs(self):
        out = unicode(QFileDialog.getSaveFileName(get_config("path"),"*.mem"))
        if out != "":
            
            if out[-4:] != ".mem":
                out += ".mem"

            if os.path.exists(out) and out != get_config("path"):
                status = QMessageBox.warning(None,
                    self.trUtf8("PyQt MemAid"),
                    self.trUtf8("Overwrite existing file?"),
                    self.trUtf8("&Yes"), self.trUtf8("&No"),
                    None, 1, -1)
                if status == 1:
                    return
                
            status = save_database(out)
            if status == False:
                QMessageBox.critical(None,
                    self.trUtf8("PyQt MemAid"),
                    self.trUtf8("Unable to save file."),
                    self.trUtf8("&OK"), None, None, 0, -1)
                return            

            self.updateCaption()
            
    ##########################################################################
    #
    # importXML
    #
    ##########################################################################

    def importXML(self):
        
        try:
            from xml.sax import saxutils, make_parser
            from xml.sax.handler import feature_namespaces
        except:
            QMessageBox.critical(None,
                  self.trUtf8("PyQt MemAid"),
                  self.trUtf8("PyXML must be installed to import XML."),
                  self.trUtf8("&OK"), None, None, 0, -1)
            return

        dlg = ImportDlg(self,"Import",0)
        dlg.exec_loop()
        self.updateStatusBar()
        if self.item == None:
            self.newQuestion()
        
    ##########################################################################
    #
    # exportXML
    #
    ##########################################################################

    def exportXML(self):
        dlg = ExportDlg(self,"Export",0)
        dlg.exec_loop()
        
    ##########################################################################
    #
    # fileExit
    #
    ##########################################################################

    def fileExit(self):
        self.updateStatusBar()
        self.close()
        
    ##########################################################################
    #
    # addItems
    #
    ##########################################################################

    def addItems(self):
        dlg = AddItemsDlg(self,"Add items",0)
        dlg.exec_loop()
        self.updateStatusBar()
        if self.item == None:
            self.newQuestion()
        
    ##########################################################################
    #
    # editItems
    #
    ##########################################################################
    
    def editItems(self):
        dlg = EditItemsDlg(self,"Edit items",0)
        dlg.exec_loop()
        self.updateStatusBar()
        if not in_revision_queue(self.item):
            self.newQuestion()
        else:
            self.updateQuestion()
            
    ##########################################################################
    #
    # editCurrentItem
    #
    ##########################################################################
    
    def editCurrentItem(self):
        dlg = EditItemDlg(self.item,self,"Edit current item",0)
        dlg.exec_loop()
        self.updateQuestion()
        
    ##########################################################################
    #
    # activateCategories
    #
    ##########################################################################

    def activateCategories(self):
        dlg = ActivateCategoriesDlg(self,"Activate categories",0)
        result = dlg.exec_loop()
        self.updateStatusBar()
        if not in_revision_queue(self.item):
            self.newQuestion()
            
    ##########################################################################
    #
    # setLearningMode
    #
    ##########################################################################

    def setLearningMode(self):
        dlg = LearningModeDlg(self,"Set learning mode",0)
        result = dlg.exec_loop()
        if not in_revision_queue(self.item):
            self.newQuestion()
            
    ##########################################################################
    #
    # showToolbar
    #
    ##########################################################################

    def showToolbar(self, active):
        if active:
            self.toolbar.show()
            set_config("hide_toolbar", False)
        else:
            self.toolbar.hide()
            set_config("hide_toolbar", True)
            
    ##########################################################################
    #
    # fontToList
    #
    ##########################################################################

    def fontToList(self, font):
        list = []
        list.append(str(font.family()))
        list.append(font.pointSize())
        list.append(font.weight())
        list.append(font.bold())
        list.append(font.italic())
        list.append(font.underline())
        list.append(font.strikeOut())
        return list
    
    ##########################################################################
    #
    # listToFont
    #
    ##########################################################################

    def listToFont(self, list):
        font = QFont()
        font.setFamily(list[0])
        font.setPointSize(list[1])
        font.setWeight(list[2])
        font.setBold(list[3])
        font.setItalic(list[4])
        font.setUnderline(list[5])
        font.setStrikeOut(list[6])
        return font
        
    ##########################################################################
    #
    # changeFont
    #
    ##########################################################################

    def changeFont(self):
        font, ok = QFontDialog.getFont(self.question_text.font())
        if ok == True:
            self.question_text.setFont(font)
            self.answer_text.setFont(font)
            self.updateQuestion()         
            set_config("font", self.fontToList(font))
            
    ##########################################################################
    #
    # closeEvent
    #
    ##########################################################################

    def closeEvent(self, event):
        save_config()
        self.train_nn_for_x_ms(1000)
        status = unload_database()
        if status == False:
            QMessageBox.critical(None,
                                 self.trUtf8("PyQt MemAid"),
                                 self.trUtf8("Unable to save file."),
                                 self.trUtf8("&OK"), None, None, 0, -1)   
        event.accept()
        
    ##########################################################################
    #
    # helpContents
    #
    ##########################################################################
    
    def helpContents(self):
        dlg = HelpDlg(self,"Help",0)
        dlg.exec_loop()
        
    ##########################################################################
    #
    # helpAbout
    #
    ##########################################################################
    
    def helpAbout(self):
        QMessageBox.about(None,
            self.trUtf8("PyQt MemAid"),
            self.trUtf8("PyQt MemAid 0.2.3\n\n"+
                        "Author: Peter Bienstman\n"+
                        "original MemAid: David Calinski"))

    ##########################################################################
    #
    # updateCaption
    #
    ##########################################################################

    def updateCaption(self):
        self.setCaption("PyQt Memaid - " \
                        + os.path.basename(get_config("path"))[:-4])
        
    ##########################################################################
    #
    # updateStatusBar
    #
    ##########################################################################

    def updateStatusBar(self):
        self.today.setText("Scheduled: "+str(reps_for_today()))
        self.all.setText("All: "+str(number_of_items()))
        
    ##########################################################################
    #
    # clearQuestion
    #
    ##########################################################################

    def clearQuestion(self):
        self.item = None
        self.question_label.setText("Question:")
        self.question_text.setText("")
        self.answer_text.setText("")
        self.show_button.setEnabled(0)
        self.editCurrentItemAction.setEnabled(0)
        self.grades.setEnabled(0)
        
    ##########################################################################
    #
    # newQuestion
    #
    ##########################################################################

    def newQuestion(self):

        self.clearQuestion()

        self.question_text.setText("")
        self.answer_text.setText("")
        self.show_button.setEnabled(0)
        self.editCurrentItemAction.setEnabled(0)
        self.grades.setEnabled(0)
         
        self.item = get_new_question()

        if self.item == None:
            return
        
        if self.item.cat.name != "<default>":
            self.question_label.setText(escape("Question: " \
                                               + self.item.cat.name))

        self.question_text.setText(escape(self.item.q))

        self.editCurrentItemAction.setEnabled(1)
        self.show_button.setEnabled(1)

    ##########################################################################
    #
    # updateQuestion
    #
    ##########################################################################

    def updateQuestion(self):

        if self.item == None:
            return
                
        if self.item.cat.name != "<default>":
            self.question_label.setText(escape("Question: " \
                                               + self.item.cat.name))
            
        self.question_text.setText(escape(self.item.q))
            
        if self.answer_text.text() != "":
            self.answer_text.setText(escape(self.item.a))

    ##########################################################################
    #
    # showAnswer
    #
    ##########################################################################

    def showAnswer(self):

        self.answer_text.setText(escape(self.item.a))        
        self.show_button.setEnabled(0)
        self.grades.setEnabled(1)
        
    ##########################################################################
    #
    # gradeAnswer
    #
    ##########################################################################

    def gradeAnswer(self, grade):

        process_answer(self.item, grade)
        self.need_to_train = True
        self.grades.setEnabled(0)
        self.updateStatusBar()
        self.question_text.setText("")
        self.answer_text.setText("")
        self.newQuestion()
        
    ##########################################################################
    #
    # train_nn_for_x_ms
    #
    ##########################################################################

    def train_nn_for_x_ms(self, train_time):

        if self.need_to_train == False:
            return

        progress = QProgressDialog(
            self.trUtf8("Training of neural network in progress"),
            "Cancel", train_time, self, "training", 1)
        progress.setAutoClose(1)
        progress.show()

        timer = QTime()
        timer.start()      
        while(timer.elapsed() <= train_time):
        
            progress.setProgress(timer.elapsed())
            qApp.processEvents()

            if progress.wasCancelled():
                break
            
            ma_train_ann(6)
        
        progress.setProgress(train_time)            
        
