%-----------------------------------------------------------------------------%
% Copyright (C) 1998-2000, 2004 The University of Melbourne.
% This file may only be copied under the terms of the GNU General
% Public License - see the file COPYING in the Mercury distribution.
%-----------------------------------------------------------------------------%
% Do not edit - this file was automatically generated by
% $ADITI_ROOT/src/rosi/create_rl_code_m.
% Created Tue Jan 27 23:14:37 2004

%-----------------------------------------------------------------------------%
:- module aditi_backend__rl_code.

%-----------------------------------------------------------------------------%
:- interface.

:- import_module list.

:- type int32		==	int.

:- type int16           ==      int.

:- type arg_num		==	int32.

:- type field_num	==	int32.

:- type var_num		==	int32.

:- type label_num	==	int32.

:- type rule_num	==	int32.

:- type rl_bytecode	==	list(bytecode).

:- type aBlob     	==	int.	% ???

:- type aDouble   	==	float.

:- type aString		==	string.

:- pred rl_code__version(int32, int32).
:- mode rl_code__version(out, out) is det.

:- pred int32_to_bytecode(int32, list(int)).
:- mode int32_to_bytecode(in, out) is det.

:- pred int16_to_bytecode(int16, list(int)).
:- mode int16_to_bytecode(in, out) is det.

:- pred aString_to_bytecode(aString, list(int)).
:- mode aString_to_bytecode(in, out) is det.

:- pred aDouble_to_bytecode(aDouble, list(int)).
:- mode aDouble_to_bytecode(in, out) is det.

:- pred aBlob_to_bytecode(aBlob, list(int)).
:- mode aBlob_to_bytecode(in, out) is det.

:- pred aInt_to_bytecode(aInt, list(int)).
:- mode aInt_to_bytecode(in, out) is det.


:- type aInt		==	int.

:- type bytecode	--->
		rl_EXP_bool_immed(int32)
	;	rl_EXP_int_immed(int32)
	;	rl_EXP_bool_push(int32)
	;	rl_EXP_int_push(int32)
	;	rl_EXP_money_push(int32)
	;	rl_EXP_flt_push(int32)
	;	rl_EXP_str_push(int32)
	;	rl_EXP_blob_push(int32)
	;	rl_EXP_bool_push_var(int32)
	;	rl_EXP_int_push_var(int32)
	;	rl_EXP_money_push_var(int32)
	;	rl_EXP_flt_push_var(int32)
	;	rl_EXP_str_push_var(int32)
	;	rl_EXP_blob_push_var(int32)
	;	rl_EXP_term_push_var(int32)
	;	rl_EXP_bool_pop_var(int32)
	;	rl_EXP_int_pop_var(int32)
	;	rl_EXP_money_pop_var(int32)
	;	rl_EXP_flt_pop_var(int32)
	;	rl_EXP_str_pop_var(int32)
	;	rl_EXP_blob_pop_var(int32)
	;	rl_EXP_term_pop_var(int32)
	;	rl_EXP_bool_dup
	;	rl_EXP_int_dup
	;	rl_EXP_money_dup
	;	rl_EXP_flt_dup
	;	rl_EXP_str_dup
	;	rl_EXP_blob_dup
	;	rl_EXP_term_dup
	;	rl_EXP_bool_pop
	;	rl_EXP_int_pop
	;	rl_EXP_money_pop
	;	rl_EXP_flt_pop
	;	rl_EXP_str_pop
	;	rl_EXP_blob_pop
	;	rl_EXP_term_pop
	;	rl_EXP_error
	;	rl_EXP_error_if_false
	;	rl_EXP_error_msg
	;	rl_EXP_error_msg_if_false
	;	rl_EXP_test_functor(int32)
	;	rl_EXP_new_term_var(int32,int32)
	;	rl_EXP_new_term_output(int32,int32)
	;	rl_EXP_new_term_output1(int32,int32)
	;	rl_EXP_new_term_output2(int32,int32)
	;	rl_EXP_bool_field1(int32)
	;	rl_EXP_int_field1(int32)
	;	rl_EXP_money_field1(int32)
	;	rl_EXP_flt_field1(int32)
	;	rl_EXP_str_field1(int32)
	;	rl_EXP_blob_field1(int32)
	;	rl_EXP_term_field1(int32)
	;	rl_EXP_bool_field2(int32)
	;	rl_EXP_int_field2(int32)
	;	rl_EXP_money_field2(int32)
	;	rl_EXP_flt_field2(int32)
	;	rl_EXP_str_field2(int32)
	;	rl_EXP_blob_field2(int32)
	;	rl_EXP_term_field2(int32)
	;	rl_EXP_get_bool_arg(int32)
	;	rl_EXP_get_int_arg(int32)
	;	rl_EXP_get_money_arg(int32)
	;	rl_EXP_get_flt_arg(int32)
	;	rl_EXP_get_str_arg(int32)
	;	rl_EXP_get_blob_arg(int32)
	;	rl_EXP_get_term_arg(int32)
	;	rl_EXP_set_bool_arg(int32)
	;	rl_EXP_set_int_arg(int32)
	;	rl_EXP_set_money_arg(int32)
	;	rl_EXP_set_flt_arg(int32)
	;	rl_EXP_set_str_arg(int32)
	;	rl_EXP_set_blob_arg(int32)
	;	rl_EXP_set_term_arg(int32,int32)
	;	rl_EXP_jmp(int32)
	;	rl_EXP_beqz(int32)
	;	rl_EXP_bltz(int32)
	;	rl_EXP_bgtz(int32)
	;	rl_EXP_blez(int32)
	;	rl_EXP_bgez(int32)
	;	rl_EXP_bnez(int32)
	;	rl_EXP_bt(int32)
	;	rl_EXP_bf(int32)
	;	rl_EXP_b3way(int32,int32)
	;	rl_EXP_ret
	;	rl_EXP_return_false
	;	rl_EXP_return_true
	;	rl_EXP_return_if_eqz
	;	rl_EXP_return_if_ltz
	;	rl_EXP_return_if_gtz
	;	rl_EXP_return_if_lez
	;	rl_EXP_return_if_gez
	;	rl_EXP_return_if_nez
	;	rl_EXP_fail_if_true
	;	rl_EXP_fail_if_false
	;	rl_EXP_int_result
	;	rl_EXP_bool_result
	;	rl_EXP_output_bool(int32)
	;	rl_EXP_output1_bool(int32)
	;	rl_EXP_output2_bool(int32)
	;	rl_EXP_output_int(int32)
	;	rl_EXP_output1_int(int32)
	;	rl_EXP_output2_int(int32)
	;	rl_EXP_output_money(int32)
	;	rl_EXP_output1_money(int32)
	;	rl_EXP_output2_money(int32)
	;	rl_EXP_output_flt(int32)
	;	rl_EXP_output1_flt(int32)
	;	rl_EXP_output2_flt(int32)
	;	rl_EXP_output_str(int32)
	;	rl_EXP_output1_str(int32)
	;	rl_EXP_output2_str(int32)
	;	rl_EXP_output_blob(int32)
	;	rl_EXP_output1_blob(int32)
	;	rl_EXP_output2_blob(int32)
	;	rl_EXP_output_term(int32)
	;	rl_EXP_output1_term(int32)
	;	rl_EXP_output2_term(int32)
	;	rl_EXP_int_neg
	;	rl_EXP_int_abs
	;	rl_EXP_int_tomoney
	;	rl_EXP_int_toflt
	;	rl_EXP_int_tostr
	;	rl_EXP_money_toint
	;	rl_EXP_money_toflt
	;	rl_EXP_money_tostr
	;	rl_EXP_flt_neg
	;	rl_EXP_flt_abs
	;	rl_EXP_flt_acos
	;	rl_EXP_flt_acosh
	;	rl_EXP_flt_asin
	;	rl_EXP_flt_asinh
	;	rl_EXP_flt_atan
	;	rl_EXP_flt_atanh
	;	rl_EXP_flt_ceil
	;	rl_EXP_flt_cos
	;	rl_EXP_flt_cosh
	;	rl_EXP_flt_cot
	;	rl_EXP_flt_exp
	;	rl_EXP_flt_floor
	;	rl_EXP_flt_log
	;	rl_EXP_flt_log10
	;	rl_EXP_flt_log2
	;	rl_EXP_flt_round
	;	rl_EXP_flt_sin
	;	rl_EXP_flt_sinh
	;	rl_EXP_flt_sqrt
	;	rl_EXP_flt_tan
	;	rl_EXP_flt_tanh
	;	rl_EXP_flt_toint
	;	rl_EXP_flt_tomoney
	;	rl_EXP_flt_tostr
	;	rl_EXP_bool_and
	;	rl_EXP_bool_or
	;	rl_EXP_bool_not
	;	rl_EXP_bool_cmp
	;	rl_EXP_int_eq
	;	rl_EXP_int_lt
	;	rl_EXP_int_gt
	;	rl_EXP_int_le
	;	rl_EXP_int_ge
	;	rl_EXP_int_ne
	;	rl_EXP_int_cmp
	;	rl_EXP_int_add
	;	rl_EXP_int_sub
	;	rl_EXP_int_mult
	;	rl_EXP_int_div
	;	rl_EXP_int_mod
	;	rl_EXP_int_max
	;	rl_EXP_int_min
	;	rl_EXP_money_eq
	;	rl_EXP_money_lt
	;	rl_EXP_money_gt
	;	rl_EXP_money_le
	;	rl_EXP_money_ge
	;	rl_EXP_money_ne
	;	rl_EXP_money_cmp
	;	rl_EXP_flt_eq
	;	rl_EXP_flt_lt
	;	rl_EXP_flt_gt
	;	rl_EXP_flt_le
	;	rl_EXP_flt_ge
	;	rl_EXP_flt_ne
	;	rl_EXP_flt_cmp
	;	rl_EXP_flt_add
	;	rl_EXP_flt_sub
	;	rl_EXP_flt_mult
	;	rl_EXP_flt_div
	;	rl_EXP_flt_mod
	;	rl_EXP_flt_max
	;	rl_EXP_flt_min
	;	rl_EXP_flt_pow
	;	rl_EXP_term_eq
	;	rl_EXP_term_lt
	;	rl_EXP_term_gt
	;	rl_EXP_term_le
	;	rl_EXP_term_ge
	;	rl_EXP_term_ne
	;	rl_EXP_term_cmp
	;	rl_EXP_str_reverse
	;	rl_EXP_str_tolower
	;	rl_EXP_str_toupper
	;	rl_EXP_str_length
	;	rl_EXP_str_toint
	;	rl_EXP_str_tomoney
	;	rl_EXP_str_toflt
	;	rl_EXP_str_eq
	;	rl_EXP_str_lt
	;	rl_EXP_str_gt
	;	rl_EXP_str_le
	;	rl_EXP_str_ge
	;	rl_EXP_str_ne
	;	rl_EXP_str_cmp
	;	rl_EXP_str_match
	;	rl_EXP_str_soundex
	;	rl_EXP_str_index
	;	rl_EXP_str_rindex
	;	rl_EXP_str_substr
	;	rl_EXP_str_submatch
	;	rl_EXP_define_input1_rule(int32,int32,int32,int32)
	;	rl_EXP_define_input2_rule(int32,int32,int32,int32)
	;	rl_EXP_define_var_rule(int32,int32,int32,int32)
	;	rl_EXP_define_output_rule(int32,int32,int32,int32)
	;	rl_EXP_define_output1_rule(int32,int32,int32,int32)
	;	rl_EXP_define_output2_rule(int32,int32,int32,int32)
	;	rl_EXP_copy_term_var(int32)
	;	rl_EXP_copy_term_output(int32)
	;	rl_EXP_copy_term_output1(int32)
	;	rl_EXP_copy_term_output2(int32)
	;	rl_EXP_copy_term_arg(int32)
	;	rl_EXP_put_term_var(int32)
	;	rl_EXP_put_term_output(int32)
	;	rl_EXP_put_term_output1(int32)
	;	rl_EXP_put_term_output2(int32)
	;	rl_EXP_put_term_arg(int32)
	;	rl_EXP_bool_hash
	;	rl_EXP_int_hash
	;	rl_EXP_money_hash
	;	rl_EXP_flt_hash
	;	rl_EXP_str_hash
	;	rl_EXP_blob_hash
	;	rl_EXP_term_hash
	;	rl_EXP_hash_combine
	;	rl_EXP_hash_result
	;	rl_EXP_declare_mercury_proc(int32,int32)
	;	rl_EXP_allocate_mercury_input_args(int32)
	;	rl_EXP_clear_mercury_input_args
	;	rl_EXP_convert_int_mercury_input_arg(int32,int32)
	;	rl_EXP_convert_flt_mercury_input_arg(int32,int32)
	;	rl_EXP_convert_str_mercury_input_arg(int32,int32)
	;	rl_EXP_convert_term_mercury_input_arg(int32,int32)
	;	rl_EXP_convert_int_mercury_output_arg(int32,int32,int32)
	;	rl_EXP_convert_flt_mercury_output_arg(int32,int32,int32)
	;	rl_EXP_convert_str_mercury_output_arg(int32,int32,int32)
	;	rl_EXP_convert_term_mercury_output_arg(int32,int32,int32)
	;	rl_EXP_retrieve_nondet_solution(int32)
	;	rl_EXP_call_mercury_proc(int32)
	;	rl_EXP_update_aggregate_accumulator(int32)
	;	rl_EXP_set_more_solutions
	;	rl_EXP_cleanup_single_solution
	;	rl_EXP_cleanup_nondet_solution
	;	rl_EXP_invalid_solution_location
	;	rl_EXP_last_bytecode
	;	rl_PROC_update(int32)
	;	rl_PROC_modify
	;	rl_PROC_project_torel
	;	rl_PROC_materialise(int32)
	;	rl_PROC_insert_tuple
	;	rl_PROC_whilenotempty(int32)
	;	rl_PROC_while
	;	rl_PROC_while_end
	;	rl_PROC_setrel(int32,int32)
	;	rl_PROC_unsetrel(int32)
	;	rl_PROC_declrel(int32,int32)
	;	rl_PROC_grouprels
	;	rl_PROC_getschemaspec
	;	rl_PROC_setschema(int32)
	;	rl_PROC_settemprel(int32,int32,int32)
	;	rl_PROC_createtemprel(int32,int32)
	;	rl_PROC_nametemprel(int32,int32)
	;	rl_PROC_unnametemprel(int32)
	;	rl_PROC_openpermrel(int32,int32,int32)
	;	rl_PROC_createpermrel(int32,int32,int32)
	;	rl_PROC_addindextorel(int32,int32)
	;	rl_PROC_addindextoschema(int32)
	;	rl_PROC_clear(int32)
	;	rl_PROC_drop(int32)
	;	rl_PROC_dropindex(int32)
	;	rl_PROC_begintransaction(int32,int32)
	;	rl_PROC_savepoint(int32)
	;	rl_PROC_rollback(int32)
	;	rl_PROC_commit
	;	rl_PROC_abort
	;	rl_PROC_delete(int32)
	;	rl_PROC_insert(int32)
	;	rl_PROC_bind_code(int32)
	;	rl_PROC_bind_handle(int32)
	;	rl_PROC_call(int32)
	;	rl_PROC_label(int32)
	;	rl_PROC_goto(int32)
	;	rl_PROC_conditional_goto(int32)
	;	rl_PROC_goto_label(int32)
	;	rl_PROC_conditional_goto_label(int32)
	;	rl_PROC_notempty
	;	rl_PROC_empty
	;	rl_PROC_one_reference(int32)
	;	rl_PROC_is_permanent(int32)
	;	rl_PROC_is_named(int32)
	;	rl_PROC_has_index(int32,int32)
	;	rl_PROC_and
	;	rl_PROC_or
	;	rl_PROC_not
	;	rl_PROC_stream
	;	rl_PROC_stream_end
	;	rl_PROC_stream_list_cons
	;	rl_PROC_stream_list_nil
	;	rl_PROC_var(int32,int32)
	;	rl_PROC_indexed_var(int32,int32,int32)
	;	rl_PROC_var_list_cons(int32,int32)
	;	rl_PROC_var_list_nil
	;	rl_PROC_expr(int32)
	;	rl_PROC_expr_frag(int32)
	;	rl_PROC_expr_end
	;	rl_PROC_expr_list_cons(int32)
	;	rl_PROC_expr_list_nil
	;	rl_PROC_bool_op_list_cons
	;	rl_PROC_bool_op_list_nil
	;	rl_PROC_int_list_cons(int32)
	;	rl_PROC_int_list_nil
	;	rl_PROC_ret
	;	rl_PROC_join
	;	rl_PROC_join_nl
	;	rl_PROC_join_sm
	;	rl_PROC_join_hj
	;	rl_PROC_join_index_simple(int32)
	;	rl_PROC_join_index_complex
	;	rl_PROC_join_cross
	;	rl_PROC_semijoin_nl
	;	rl_PROC_semijoin_sm
	;	rl_PROC_semijoin_hj
	;	rl_PROC_semijoin_index(int32,int32)
	;	rl_PROC_subtract
	;	rl_PROC_subtract_nl
	;	rl_PROC_subtract_sm
	;	rl_PROC_subtract_hj
	;	rl_PROC_subtract_index(int32)
	;	rl_PROC_subtract_cross
	;	rl_PROC_semisubtract_nl
	;	rl_PROC_semisubtract_hj
	;	rl_PROC_semisubtract_index(int32)
	;	rl_PROC_difference
	;	rl_PROC_select
	;	rl_PROC_select_filter
	;	rl_PROC_select_index(int32)
	;	rl_PROC_btree_scan(int32)
	;	rl_PROC_project_tee
	;	rl_PROC_sort(int32)
	;	rl_PROC_union
	;	rl_PROC_union_sm
	;	rl_PROC_uniondiff
	;	rl_PROC_uniondiff_sm
	;	rl_PROC_uniondiff_btree
	;	rl_PROC_aggregate
	;	rl_PROC_aggregate_sm
	;	rl_PROC_aggregate_onegroup
	;	rl_PROC_insert_tuple_stream
	;	rl_PROC_empty_stream(int32)
	;	rl_PROC_hypothetical
	;	rl_PROC_topdown
	;	rl_PROC_last_bytecode
	;	rl_HEAD_proc(int32,int32,int32,int32)
	;	rl_HEAD_proc_end
	;	rl_HEAD_const_int(int32,aInt)
	;	rl_HEAD_const_flt(int32,aDouble)
	;	rl_HEAD_const_str(int32,aString)
	;	rl_HEAD_var_int(int32)
	;	rl_HEAD_var_flt(int32)
	;	rl_HEAD_var_str(int32)
	;	rl_HEAD_var_term(int32)
	;	rl_HEAD_var_stream(int32)
	;	rl_HEAD_define_rule(int32,int32,int32)
	;	rl_HEAD_last_bytecode
	.


:- pred bytecode_to_intlist(bytecode, list(int)).
:- mode bytecode_to_intlist(in, out) is det.

%:- pred bytecode_to_str(bytecode, string).
%:- mode bytecode_to_str(in, out) is det.
%
%:- pred bytecode_name_to_int(bytecode, int).
%:- mode bytecode_name_to_int(in, out) is det.
%
%:- pred bytecode_name_to_str(bytecode, string).
%:- mode bytecode_name_to_str(in, out) is det.

%-----------------------------------------------------------------------------%
:- implementation.

:- import_module backend_libs__bytecode_data.

%-----------------------------------------------------------------------------%

bytecode_to_intlist(rl_EXP_bool_immed(X0int32),	 Splits) :-
	int16_to_bytecode(0, I0Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	list.append(I0Codes, X0int32Codes, Splits).
bytecode_to_intlist(rl_EXP_int_immed(X0int32),	 Splits) :-
	int16_to_bytecode(1, I1Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	list.append(I1Codes, X0int32Codes, Splits).
bytecode_to_intlist(rl_EXP_bool_push(X0aInt),	 Splits) :-
	int16_to_bytecode(2, I2Codes),
	int32_to_bytecode(X0aInt, X0aIntCodes),
	list.append(I2Codes, X0aIntCodes, Splits).
bytecode_to_intlist(rl_EXP_int_push(X0aInt),	 Splits) :-
	int16_to_bytecode(3, I3Codes),
	int32_to_bytecode(X0aInt, X0aIntCodes),
	list.append(I3Codes, X0aIntCodes, Splits).
bytecode_to_intlist(rl_EXP_money_push(X0aInt),	 Splits) :-
	int16_to_bytecode(4, I4Codes),
	int32_to_bytecode(X0aInt, X0aIntCodes),
	list.append(I4Codes, X0aIntCodes, Splits).
bytecode_to_intlist(rl_EXP_flt_push(X0aDouble),	 Splits) :-
	int16_to_bytecode(5, I5Codes),
	int32_to_bytecode(X0aDouble, X0aDoubleCodes),
	list.append(I5Codes, X0aDoubleCodes, Splits).
bytecode_to_intlist(rl_EXP_str_push(X0aString),	 Splits) :-
	int16_to_bytecode(6, I6Codes),
	int32_to_bytecode(X0aString, X0aStringCodes),
	list.append(I6Codes, X0aStringCodes, Splits).
bytecode_to_intlist(rl_EXP_blob_push(X0aBlob),	 Splits) :-
	int16_to_bytecode(7, I7Codes),
	int32_to_bytecode(X0aBlob, X0aBlobCodes),
	list.append(I7Codes, X0aBlobCodes, Splits).
bytecode_to_intlist(rl_EXP_bool_push_var(X0var_num),	 Splits) :-
	int16_to_bytecode(8, I8Codes),
	int32_to_bytecode(X0var_num, X0var_numCodes),
	list.append(I8Codes, X0var_numCodes, Splits).
bytecode_to_intlist(rl_EXP_int_push_var(X0var_num),	 Splits) :-
	int16_to_bytecode(9, I9Codes),
	int32_to_bytecode(X0var_num, X0var_numCodes),
	list.append(I9Codes, X0var_numCodes, Splits).
bytecode_to_intlist(rl_EXP_money_push_var(X0var_num),	 Splits) :-
	int16_to_bytecode(10, I10Codes),
	int32_to_bytecode(X0var_num, X0var_numCodes),
	list.append(I10Codes, X0var_numCodes, Splits).
bytecode_to_intlist(rl_EXP_flt_push_var(X0var_num),	 Splits) :-
	int16_to_bytecode(11, I11Codes),
	int32_to_bytecode(X0var_num, X0var_numCodes),
	list.append(I11Codes, X0var_numCodes, Splits).
bytecode_to_intlist(rl_EXP_str_push_var(X0var_num),	 Splits) :-
	int16_to_bytecode(12, I12Codes),
	int32_to_bytecode(X0var_num, X0var_numCodes),
	list.append(I12Codes, X0var_numCodes, Splits).
bytecode_to_intlist(rl_EXP_blob_push_var(X0var_num),	 Splits) :-
	int16_to_bytecode(13, I13Codes),
	int32_to_bytecode(X0var_num, X0var_numCodes),
	list.append(I13Codes, X0var_numCodes, Splits).
bytecode_to_intlist(rl_EXP_term_push_var(X0var_num),	 Splits) :-
	int16_to_bytecode(14, I14Codes),
	int32_to_bytecode(X0var_num, X0var_numCodes),
	list.append(I14Codes, X0var_numCodes, Splits).
bytecode_to_intlist(rl_EXP_bool_pop_var(X0var_num),	 Splits) :-
	int16_to_bytecode(15, I15Codes),
	int32_to_bytecode(X0var_num, X0var_numCodes),
	list.append(I15Codes, X0var_numCodes, Splits).
bytecode_to_intlist(rl_EXP_int_pop_var(X0var_num),	 Splits) :-
	int16_to_bytecode(16, I16Codes),
	int32_to_bytecode(X0var_num, X0var_numCodes),
	list.append(I16Codes, X0var_numCodes, Splits).
bytecode_to_intlist(rl_EXP_money_pop_var(X0var_num),	 Splits) :-
	int16_to_bytecode(17, I17Codes),
	int32_to_bytecode(X0var_num, X0var_numCodes),
	list.append(I17Codes, X0var_numCodes, Splits).
bytecode_to_intlist(rl_EXP_flt_pop_var(X0var_num),	 Splits) :-
	int16_to_bytecode(18, I18Codes),
	int32_to_bytecode(X0var_num, X0var_numCodes),
	list.append(I18Codes, X0var_numCodes, Splits).
bytecode_to_intlist(rl_EXP_str_pop_var(X0var_num),	 Splits) :-
	int16_to_bytecode(19, I19Codes),
	int32_to_bytecode(X0var_num, X0var_numCodes),
	list.append(I19Codes, X0var_numCodes, Splits).
bytecode_to_intlist(rl_EXP_blob_pop_var(X0var_num),	 Splits) :-
	int16_to_bytecode(20, I20Codes),
	int32_to_bytecode(X0var_num, X0var_numCodes),
	list.append(I20Codes, X0var_numCodes, Splits).
bytecode_to_intlist(rl_EXP_term_pop_var(X0var_num),	 Splits) :-
	int16_to_bytecode(21, I21Codes),
	int32_to_bytecode(X0var_num, X0var_numCodes),
	list.append(I21Codes, X0var_numCodes, Splits).
bytecode_to_intlist(rl_EXP_bool_dup,	 Splits) :-
	int16_to_bytecode(22, I22Codes),
	Splits = I22Codes.
bytecode_to_intlist(rl_EXP_int_dup,	 Splits) :-
	int16_to_bytecode(23, I23Codes),
	Splits = I23Codes.
bytecode_to_intlist(rl_EXP_money_dup,	 Splits) :-
	int16_to_bytecode(24, I24Codes),
	Splits = I24Codes.
bytecode_to_intlist(rl_EXP_flt_dup,	 Splits) :-
	int16_to_bytecode(25, I25Codes),
	Splits = I25Codes.
bytecode_to_intlist(rl_EXP_str_dup,	 Splits) :-
	int16_to_bytecode(26, I26Codes),
	Splits = I26Codes.
bytecode_to_intlist(rl_EXP_blob_dup,	 Splits) :-
	int16_to_bytecode(27, I27Codes),
	Splits = I27Codes.
bytecode_to_intlist(rl_EXP_term_dup,	 Splits) :-
	int16_to_bytecode(28, I28Codes),
	Splits = I28Codes.
bytecode_to_intlist(rl_EXP_bool_pop,	 Splits) :-
	int16_to_bytecode(29, I29Codes),
	Splits = I29Codes.
bytecode_to_intlist(rl_EXP_int_pop,	 Splits) :-
	int16_to_bytecode(30, I30Codes),
	Splits = I30Codes.
bytecode_to_intlist(rl_EXP_money_pop,	 Splits) :-
	int16_to_bytecode(31, I31Codes),
	Splits = I31Codes.
bytecode_to_intlist(rl_EXP_flt_pop,	 Splits) :-
	int16_to_bytecode(32, I32Codes),
	Splits = I32Codes.
bytecode_to_intlist(rl_EXP_str_pop,	 Splits) :-
	int16_to_bytecode(33, I33Codes),
	Splits = I33Codes.
bytecode_to_intlist(rl_EXP_blob_pop,	 Splits) :-
	int16_to_bytecode(34, I34Codes),
	Splits = I34Codes.
bytecode_to_intlist(rl_EXP_term_pop,	 Splits) :-
	int16_to_bytecode(35, I35Codes),
	Splits = I35Codes.
bytecode_to_intlist(rl_EXP_error,	 Splits) :-
	int16_to_bytecode(36, I36Codes),
	Splits = I36Codes.
bytecode_to_intlist(rl_EXP_error_if_false,	 Splits) :-
	int16_to_bytecode(37, I37Codes),
	Splits = I37Codes.
bytecode_to_intlist(rl_EXP_error_msg,	 Splits) :-
	int16_to_bytecode(38, I38Codes),
	Splits = I38Codes.
bytecode_to_intlist(rl_EXP_error_msg_if_false,	 Splits) :-
	int16_to_bytecode(39, I39Codes),
	Splits = I39Codes.
bytecode_to_intlist(rl_EXP_test_functor(X0rule_num),	 Splits) :-
	int16_to_bytecode(40, I40Codes),
	int32_to_bytecode(X0rule_num, X0rule_numCodes),
	list.append(I40Codes, X0rule_numCodes, Splits).
bytecode_to_intlist(rl_EXP_new_term_var(X0var_num,X1rule_num),	 Splits) :-
	int16_to_bytecode(41, I41Codes),
	int32_to_bytecode(X0var_num, X0var_numCodes),
	int32_to_bytecode(X1rule_num, X1rule_numCodes),
	rl_code.condense3(I41Codes, X0var_numCodes, X1rule_numCodes, Splits).
bytecode_to_intlist(rl_EXP_new_term_output(X0field_num,X1rule_num),	 Splits) :-
	int16_to_bytecode(42, I42Codes),
	int32_to_bytecode(X0field_num, X0field_numCodes),
	int32_to_bytecode(X1rule_num, X1rule_numCodes),
	rl_code.condense3(I42Codes, X0field_numCodes, X1rule_numCodes, Splits).
bytecode_to_intlist(rl_EXP_new_term_output1(X0field_num,X1rule_num),	 Splits) :-
	int16_to_bytecode(43, I43Codes),
	int32_to_bytecode(X0field_num, X0field_numCodes),
	int32_to_bytecode(X1rule_num, X1rule_numCodes),
	rl_code.condense3(I43Codes, X0field_numCodes, X1rule_numCodes, Splits).
bytecode_to_intlist(rl_EXP_new_term_output2(X0field_num,X1rule_num),	 Splits) :-
	int16_to_bytecode(44, I44Codes),
	int32_to_bytecode(X0field_num, X0field_numCodes),
	int32_to_bytecode(X1rule_num, X1rule_numCodes),
	rl_code.condense3(I44Codes, X0field_numCodes, X1rule_numCodes, Splits).
bytecode_to_intlist(rl_EXP_bool_field1(X0field_num),	 Splits) :-
	int16_to_bytecode(45, I45Codes),
	int32_to_bytecode(X0field_num, X0field_numCodes),
	list.append(I45Codes, X0field_numCodes, Splits).
bytecode_to_intlist(rl_EXP_int_field1(X0field_num),	 Splits) :-
	int16_to_bytecode(46, I46Codes),
	int32_to_bytecode(X0field_num, X0field_numCodes),
	list.append(I46Codes, X0field_numCodes, Splits).
bytecode_to_intlist(rl_EXP_money_field1(X0field_num),	 Splits) :-
	int16_to_bytecode(47, I47Codes),
	int32_to_bytecode(X0field_num, X0field_numCodes),
	list.append(I47Codes, X0field_numCodes, Splits).
bytecode_to_intlist(rl_EXP_flt_field1(X0field_num),	 Splits) :-
	int16_to_bytecode(48, I48Codes),
	int32_to_bytecode(X0field_num, X0field_numCodes),
	list.append(I48Codes, X0field_numCodes, Splits).
bytecode_to_intlist(rl_EXP_str_field1(X0field_num),	 Splits) :-
	int16_to_bytecode(49, I49Codes),
	int32_to_bytecode(X0field_num, X0field_numCodes),
	list.append(I49Codes, X0field_numCodes, Splits).
bytecode_to_intlist(rl_EXP_blob_field1(X0field_num),	 Splits) :-
	int16_to_bytecode(50, I50Codes),
	int32_to_bytecode(X0field_num, X0field_numCodes),
	list.append(I50Codes, X0field_numCodes, Splits).
bytecode_to_intlist(rl_EXP_term_field1(X0field_num),	 Splits) :-
	int16_to_bytecode(51, I51Codes),
	int32_to_bytecode(X0field_num, X0field_numCodes),
	list.append(I51Codes, X0field_numCodes, Splits).
bytecode_to_intlist(rl_EXP_bool_field2(X0field_num),	 Splits) :-
	int16_to_bytecode(52, I52Codes),
	int32_to_bytecode(X0field_num, X0field_numCodes),
	list.append(I52Codes, X0field_numCodes, Splits).
bytecode_to_intlist(rl_EXP_int_field2(X0field_num),	 Splits) :-
	int16_to_bytecode(53, I53Codes),
	int32_to_bytecode(X0field_num, X0field_numCodes),
	list.append(I53Codes, X0field_numCodes, Splits).
bytecode_to_intlist(rl_EXP_money_field2(X0field_num),	 Splits) :-
	int16_to_bytecode(54, I54Codes),
	int32_to_bytecode(X0field_num, X0field_numCodes),
	list.append(I54Codes, X0field_numCodes, Splits).
bytecode_to_intlist(rl_EXP_flt_field2(X0field_num),	 Splits) :-
	int16_to_bytecode(55, I55Codes),
	int32_to_bytecode(X0field_num, X0field_numCodes),
	list.append(I55Codes, X0field_numCodes, Splits).
bytecode_to_intlist(rl_EXP_str_field2(X0field_num),	 Splits) :-
	int16_to_bytecode(56, I56Codes),
	int32_to_bytecode(X0field_num, X0field_numCodes),
	list.append(I56Codes, X0field_numCodes, Splits).
bytecode_to_intlist(rl_EXP_blob_field2(X0field_num),	 Splits) :-
	int16_to_bytecode(57, I57Codes),
	int32_to_bytecode(X0field_num, X0field_numCodes),
	list.append(I57Codes, X0field_numCodes, Splits).
bytecode_to_intlist(rl_EXP_term_field2(X0field_num),	 Splits) :-
	int16_to_bytecode(58, I58Codes),
	int32_to_bytecode(X0field_num, X0field_numCodes),
	list.append(I58Codes, X0field_numCodes, Splits).
bytecode_to_intlist(rl_EXP_get_bool_arg(X0arg_num),	 Splits) :-
	int16_to_bytecode(59, I59Codes),
	int32_to_bytecode(X0arg_num, X0arg_numCodes),
	list.append(I59Codes, X0arg_numCodes, Splits).
bytecode_to_intlist(rl_EXP_get_int_arg(X0arg_num),	 Splits) :-
	int16_to_bytecode(60, I60Codes),
	int32_to_bytecode(X0arg_num, X0arg_numCodes),
	list.append(I60Codes, X0arg_numCodes, Splits).
bytecode_to_intlist(rl_EXP_get_money_arg(X0arg_num),	 Splits) :-
	int16_to_bytecode(61, I61Codes),
	int32_to_bytecode(X0arg_num, X0arg_numCodes),
	list.append(I61Codes, X0arg_numCodes, Splits).
bytecode_to_intlist(rl_EXP_get_flt_arg(X0arg_num),	 Splits) :-
	int16_to_bytecode(62, I62Codes),
	int32_to_bytecode(X0arg_num, X0arg_numCodes),
	list.append(I62Codes, X0arg_numCodes, Splits).
bytecode_to_intlist(rl_EXP_get_str_arg(X0arg_num),	 Splits) :-
	int16_to_bytecode(63, I63Codes),
	int32_to_bytecode(X0arg_num, X0arg_numCodes),
	list.append(I63Codes, X0arg_numCodes, Splits).
bytecode_to_intlist(rl_EXP_get_blob_arg(X0arg_num),	 Splits) :-
	int16_to_bytecode(64, I64Codes),
	int32_to_bytecode(X0arg_num, X0arg_numCodes),
	list.append(I64Codes, X0arg_numCodes, Splits).
bytecode_to_intlist(rl_EXP_get_term_arg(X0arg_num),	 Splits) :-
	int16_to_bytecode(65, I65Codes),
	int32_to_bytecode(X0arg_num, X0arg_numCodes),
	list.append(I65Codes, X0arg_numCodes, Splits).
bytecode_to_intlist(rl_EXP_set_bool_arg(X0arg_num),	 Splits) :-
	int16_to_bytecode(66, I66Codes),
	int32_to_bytecode(X0arg_num, X0arg_numCodes),
	list.append(I66Codes, X0arg_numCodes, Splits).
bytecode_to_intlist(rl_EXP_set_int_arg(X0arg_num),	 Splits) :-
	int16_to_bytecode(67, I67Codes),
	int32_to_bytecode(X0arg_num, X0arg_numCodes),
	list.append(I67Codes, X0arg_numCodes, Splits).
bytecode_to_intlist(rl_EXP_set_money_arg(X0arg_num),	 Splits) :-
	int16_to_bytecode(68, I68Codes),
	int32_to_bytecode(X0arg_num, X0arg_numCodes),
	list.append(I68Codes, X0arg_numCodes, Splits).
bytecode_to_intlist(rl_EXP_set_flt_arg(X0arg_num),	 Splits) :-
	int16_to_bytecode(69, I69Codes),
	int32_to_bytecode(X0arg_num, X0arg_numCodes),
	list.append(I69Codes, X0arg_numCodes, Splits).
bytecode_to_intlist(rl_EXP_set_str_arg(X0arg_num),	 Splits) :-
	int16_to_bytecode(70, I70Codes),
	int32_to_bytecode(X0arg_num, X0arg_numCodes),
	list.append(I70Codes, X0arg_numCodes, Splits).
bytecode_to_intlist(rl_EXP_set_blob_arg(X0arg_num),	 Splits) :-
	int16_to_bytecode(71, I71Codes),
	int32_to_bytecode(X0arg_num, X0arg_numCodes),
	list.append(I71Codes, X0arg_numCodes, Splits).
bytecode_to_intlist(rl_EXP_set_term_arg(X0arg_num,X1rule_num),	 Splits) :-
	int16_to_bytecode(72, I72Codes),
	int32_to_bytecode(X0arg_num, X0arg_numCodes),
	int32_to_bytecode(X1rule_num, X1rule_numCodes),
	rl_code.condense3(I72Codes, X0arg_numCodes, X1rule_numCodes, Splits).
bytecode_to_intlist(rl_EXP_jmp(X0label_num),	 Splits) :-
	int16_to_bytecode(73, I73Codes),
	int32_to_bytecode(X0label_num, X0label_numCodes),
	list.append(I73Codes, X0label_numCodes, Splits).
bytecode_to_intlist(rl_EXP_beqz(X0label_num),	 Splits) :-
	int16_to_bytecode(74, I74Codes),
	int32_to_bytecode(X0label_num, X0label_numCodes),
	list.append(I74Codes, X0label_numCodes, Splits).
bytecode_to_intlist(rl_EXP_bltz(X0label_num),	 Splits) :-
	int16_to_bytecode(75, I75Codes),
	int32_to_bytecode(X0label_num, X0label_numCodes),
	list.append(I75Codes, X0label_numCodes, Splits).
bytecode_to_intlist(rl_EXP_bgtz(X0label_num),	 Splits) :-
	int16_to_bytecode(76, I76Codes),
	int32_to_bytecode(X0label_num, X0label_numCodes),
	list.append(I76Codes, X0label_numCodes, Splits).
bytecode_to_intlist(rl_EXP_blez(X0label_num),	 Splits) :-
	int16_to_bytecode(77, I77Codes),
	int32_to_bytecode(X0label_num, X0label_numCodes),
	list.append(I77Codes, X0label_numCodes, Splits).
bytecode_to_intlist(rl_EXP_bgez(X0label_num),	 Splits) :-
	int16_to_bytecode(78, I78Codes),
	int32_to_bytecode(X0label_num, X0label_numCodes),
	list.append(I78Codes, X0label_numCodes, Splits).
bytecode_to_intlist(rl_EXP_bnez(X0label_num),	 Splits) :-
	int16_to_bytecode(79, I79Codes),
	int32_to_bytecode(X0label_num, X0label_numCodes),
	list.append(I79Codes, X0label_numCodes, Splits).
bytecode_to_intlist(rl_EXP_bt(X0label_num),	 Splits) :-
	int16_to_bytecode(80, I80Codes),
	int32_to_bytecode(X0label_num, X0label_numCodes),
	list.append(I80Codes, X0label_numCodes, Splits).
bytecode_to_intlist(rl_EXP_bf(X0label_num),	 Splits) :-
	int16_to_bytecode(81, I81Codes),
	int32_to_bytecode(X0label_num, X0label_numCodes),
	list.append(I81Codes, X0label_numCodes, Splits).
bytecode_to_intlist(rl_EXP_b3way(X0label_num,X1label_num),	 Splits) :-
	int16_to_bytecode(82, I82Codes),
	int32_to_bytecode(X0label_num, X0label_numCodes),
	int32_to_bytecode(X1label_num, X1label_numCodes),
	rl_code.condense3(I82Codes, X0label_numCodes, X1label_numCodes, Splits).
bytecode_to_intlist(rl_EXP_ret,	 Splits) :-
	int16_to_bytecode(83, I83Codes),
	Splits = I83Codes.
bytecode_to_intlist(rl_EXP_return_false,	 Splits) :-
	int16_to_bytecode(84, I84Codes),
	Splits = I84Codes.
bytecode_to_intlist(rl_EXP_return_true,	 Splits) :-
	int16_to_bytecode(85, I85Codes),
	Splits = I85Codes.
bytecode_to_intlist(rl_EXP_return_if_eqz,	 Splits) :-
	int16_to_bytecode(86, I86Codes),
	Splits = I86Codes.
bytecode_to_intlist(rl_EXP_return_if_ltz,	 Splits) :-
	int16_to_bytecode(87, I87Codes),
	Splits = I87Codes.
bytecode_to_intlist(rl_EXP_return_if_gtz,	 Splits) :-
	int16_to_bytecode(88, I88Codes),
	Splits = I88Codes.
bytecode_to_intlist(rl_EXP_return_if_lez,	 Splits) :-
	int16_to_bytecode(89, I89Codes),
	Splits = I89Codes.
bytecode_to_intlist(rl_EXP_return_if_gez,	 Splits) :-
	int16_to_bytecode(90, I90Codes),
	Splits = I90Codes.
bytecode_to_intlist(rl_EXP_return_if_nez,	 Splits) :-
	int16_to_bytecode(91, I91Codes),
	Splits = I91Codes.
bytecode_to_intlist(rl_EXP_fail_if_true,	 Splits) :-
	int16_to_bytecode(92, I92Codes),
	Splits = I92Codes.
bytecode_to_intlist(rl_EXP_fail_if_false,	 Splits) :-
	int16_to_bytecode(93, I93Codes),
	Splits = I93Codes.
bytecode_to_intlist(rl_EXP_int_result,	 Splits) :-
	int16_to_bytecode(94, I94Codes),
	Splits = I94Codes.
bytecode_to_intlist(rl_EXP_bool_result,	 Splits) :-
	int16_to_bytecode(95, I95Codes),
	Splits = I95Codes.
bytecode_to_intlist(rl_EXP_output_bool(X0field_num),	 Splits) :-
	int16_to_bytecode(96, I96Codes),
	int32_to_bytecode(X0field_num, X0field_numCodes),
	list.append(I96Codes, X0field_numCodes, Splits).
bytecode_to_intlist(rl_EXP_output1_bool(X0field_num),	 Splits) :-
	int16_to_bytecode(97, I97Codes),
	int32_to_bytecode(X0field_num, X0field_numCodes),
	list.append(I97Codes, X0field_numCodes, Splits).
bytecode_to_intlist(rl_EXP_output2_bool(X0field_num),	 Splits) :-
	int16_to_bytecode(98, I98Codes),
	int32_to_bytecode(X0field_num, X0field_numCodes),
	list.append(I98Codes, X0field_numCodes, Splits).
bytecode_to_intlist(rl_EXP_output_int(X0field_num),	 Splits) :-
	int16_to_bytecode(99, I99Codes),
	int32_to_bytecode(X0field_num, X0field_numCodes),
	list.append(I99Codes, X0field_numCodes, Splits).
bytecode_to_intlist(rl_EXP_output1_int(X0field_num),	 Splits) :-
	int16_to_bytecode(100, I100Codes),
	int32_to_bytecode(X0field_num, X0field_numCodes),
	list.append(I100Codes, X0field_numCodes, Splits).
bytecode_to_intlist(rl_EXP_output2_int(X0field_num),	 Splits) :-
	int16_to_bytecode(101, I101Codes),
	int32_to_bytecode(X0field_num, X0field_numCodes),
	list.append(I101Codes, X0field_numCodes, Splits).
bytecode_to_intlist(rl_EXP_output_money(X0field_num),	 Splits) :-
	int16_to_bytecode(102, I102Codes),
	int32_to_bytecode(X0field_num, X0field_numCodes),
	list.append(I102Codes, X0field_numCodes, Splits).
bytecode_to_intlist(rl_EXP_output1_money(X0field_num),	 Splits) :-
	int16_to_bytecode(103, I103Codes),
	int32_to_bytecode(X0field_num, X0field_numCodes),
	list.append(I103Codes, X0field_numCodes, Splits).
bytecode_to_intlist(rl_EXP_output2_money(X0field_num),	 Splits) :-
	int16_to_bytecode(104, I104Codes),
	int32_to_bytecode(X0field_num, X0field_numCodes),
	list.append(I104Codes, X0field_numCodes, Splits).
bytecode_to_intlist(rl_EXP_output_flt(X0field_num),	 Splits) :-
	int16_to_bytecode(105, I105Codes),
	int32_to_bytecode(X0field_num, X0field_numCodes),
	list.append(I105Codes, X0field_numCodes, Splits).
bytecode_to_intlist(rl_EXP_output1_flt(X0field_num),	 Splits) :-
	int16_to_bytecode(106, I106Codes),
	int32_to_bytecode(X0field_num, X0field_numCodes),
	list.append(I106Codes, X0field_numCodes, Splits).
bytecode_to_intlist(rl_EXP_output2_flt(X0field_num),	 Splits) :-
	int16_to_bytecode(107, I107Codes),
	int32_to_bytecode(X0field_num, X0field_numCodes),
	list.append(I107Codes, X0field_numCodes, Splits).
bytecode_to_intlist(rl_EXP_output_str(X0field_num),	 Splits) :-
	int16_to_bytecode(108, I108Codes),
	int32_to_bytecode(X0field_num, X0field_numCodes),
	list.append(I108Codes, X0field_numCodes, Splits).
bytecode_to_intlist(rl_EXP_output1_str(X0field_num),	 Splits) :-
	int16_to_bytecode(109, I109Codes),
	int32_to_bytecode(X0field_num, X0field_numCodes),
	list.append(I109Codes, X0field_numCodes, Splits).
bytecode_to_intlist(rl_EXP_output2_str(X0field_num),	 Splits) :-
	int16_to_bytecode(110, I110Codes),
	int32_to_bytecode(X0field_num, X0field_numCodes),
	list.append(I110Codes, X0field_numCodes, Splits).
bytecode_to_intlist(rl_EXP_output_blob(X0field_num),	 Splits) :-
	int16_to_bytecode(111, I111Codes),
	int32_to_bytecode(X0field_num, X0field_numCodes),
	list.append(I111Codes, X0field_numCodes, Splits).
bytecode_to_intlist(rl_EXP_output1_blob(X0field_num),	 Splits) :-
	int16_to_bytecode(112, I112Codes),
	int32_to_bytecode(X0field_num, X0field_numCodes),
	list.append(I112Codes, X0field_numCodes, Splits).
bytecode_to_intlist(rl_EXP_output2_blob(X0field_num),	 Splits) :-
	int16_to_bytecode(113, I113Codes),
	int32_to_bytecode(X0field_num, X0field_numCodes),
	list.append(I113Codes, X0field_numCodes, Splits).
bytecode_to_intlist(rl_EXP_output_term(X0field_num),	 Splits) :-
	int16_to_bytecode(114, I114Codes),
	int32_to_bytecode(X0field_num, X0field_numCodes),
	list.append(I114Codes, X0field_numCodes, Splits).
bytecode_to_intlist(rl_EXP_output1_term(X0field_num),	 Splits) :-
	int16_to_bytecode(115, I115Codes),
	int32_to_bytecode(X0field_num, X0field_numCodes),
	list.append(I115Codes, X0field_numCodes, Splits).
bytecode_to_intlist(rl_EXP_output2_term(X0field_num),	 Splits) :-
	int16_to_bytecode(116, I116Codes),
	int32_to_bytecode(X0field_num, X0field_numCodes),
	list.append(I116Codes, X0field_numCodes, Splits).
bytecode_to_intlist(rl_EXP_int_neg,	 Splits) :-
	int16_to_bytecode(117, I117Codes),
	Splits = I117Codes.
bytecode_to_intlist(rl_EXP_int_abs,	 Splits) :-
	int16_to_bytecode(118, I118Codes),
	Splits = I118Codes.
bytecode_to_intlist(rl_EXP_int_tomoney,	 Splits) :-
	int16_to_bytecode(119, I119Codes),
	Splits = I119Codes.
bytecode_to_intlist(rl_EXP_int_toflt,	 Splits) :-
	int16_to_bytecode(120, I120Codes),
	Splits = I120Codes.
bytecode_to_intlist(rl_EXP_int_tostr,	 Splits) :-
	int16_to_bytecode(121, I121Codes),
	Splits = I121Codes.
bytecode_to_intlist(rl_EXP_money_toint,	 Splits) :-
	int16_to_bytecode(122, I122Codes),
	Splits = I122Codes.
bytecode_to_intlist(rl_EXP_money_toflt,	 Splits) :-
	int16_to_bytecode(123, I123Codes),
	Splits = I123Codes.
bytecode_to_intlist(rl_EXP_money_tostr,	 Splits) :-
	int16_to_bytecode(124, I124Codes),
	Splits = I124Codes.
bytecode_to_intlist(rl_EXP_flt_neg,	 Splits) :-
	int16_to_bytecode(125, I125Codes),
	Splits = I125Codes.
bytecode_to_intlist(rl_EXP_flt_abs,	 Splits) :-
	int16_to_bytecode(126, I126Codes),
	Splits = I126Codes.
bytecode_to_intlist(rl_EXP_flt_acos,	 Splits) :-
	int16_to_bytecode(127, I127Codes),
	Splits = I127Codes.
bytecode_to_intlist(rl_EXP_flt_acosh,	 Splits) :-
	int16_to_bytecode(128, I128Codes),
	Splits = I128Codes.
bytecode_to_intlist(rl_EXP_flt_asin,	 Splits) :-
	int16_to_bytecode(129, I129Codes),
	Splits = I129Codes.
bytecode_to_intlist(rl_EXP_flt_asinh,	 Splits) :-
	int16_to_bytecode(130, I130Codes),
	Splits = I130Codes.
bytecode_to_intlist(rl_EXP_flt_atan,	 Splits) :-
	int16_to_bytecode(131, I131Codes),
	Splits = I131Codes.
bytecode_to_intlist(rl_EXP_flt_atanh,	 Splits) :-
	int16_to_bytecode(132, I132Codes),
	Splits = I132Codes.
bytecode_to_intlist(rl_EXP_flt_ceil,	 Splits) :-
	int16_to_bytecode(133, I133Codes),
	Splits = I133Codes.
bytecode_to_intlist(rl_EXP_flt_cos,	 Splits) :-
	int16_to_bytecode(134, I134Codes),
	Splits = I134Codes.
bytecode_to_intlist(rl_EXP_flt_cosh,	 Splits) :-
	int16_to_bytecode(135, I135Codes),
	Splits = I135Codes.
bytecode_to_intlist(rl_EXP_flt_cot,	 Splits) :-
	int16_to_bytecode(136, I136Codes),
	Splits = I136Codes.
bytecode_to_intlist(rl_EXP_flt_exp,	 Splits) :-
	int16_to_bytecode(137, I137Codes),
	Splits = I137Codes.
bytecode_to_intlist(rl_EXP_flt_floor,	 Splits) :-
	int16_to_bytecode(138, I138Codes),
	Splits = I138Codes.
bytecode_to_intlist(rl_EXP_flt_log,	 Splits) :-
	int16_to_bytecode(139, I139Codes),
	Splits = I139Codes.
bytecode_to_intlist(rl_EXP_flt_log10,	 Splits) :-
	int16_to_bytecode(140, I140Codes),
	Splits = I140Codes.
bytecode_to_intlist(rl_EXP_flt_log2,	 Splits) :-
	int16_to_bytecode(141, I141Codes),
	Splits = I141Codes.
bytecode_to_intlist(rl_EXP_flt_round,	 Splits) :-
	int16_to_bytecode(142, I142Codes),
	Splits = I142Codes.
bytecode_to_intlist(rl_EXP_flt_sin,	 Splits) :-
	int16_to_bytecode(143, I143Codes),
	Splits = I143Codes.
bytecode_to_intlist(rl_EXP_flt_sinh,	 Splits) :-
	int16_to_bytecode(144, I144Codes),
	Splits = I144Codes.
bytecode_to_intlist(rl_EXP_flt_sqrt,	 Splits) :-
	int16_to_bytecode(145, I145Codes),
	Splits = I145Codes.
bytecode_to_intlist(rl_EXP_flt_tan,	 Splits) :-
	int16_to_bytecode(146, I146Codes),
	Splits = I146Codes.
bytecode_to_intlist(rl_EXP_flt_tanh,	 Splits) :-
	int16_to_bytecode(147, I147Codes),
	Splits = I147Codes.
bytecode_to_intlist(rl_EXP_flt_toint,	 Splits) :-
	int16_to_bytecode(148, I148Codes),
	Splits = I148Codes.
bytecode_to_intlist(rl_EXP_flt_tomoney,	 Splits) :-
	int16_to_bytecode(149, I149Codes),
	Splits = I149Codes.
bytecode_to_intlist(rl_EXP_flt_tostr,	 Splits) :-
	int16_to_bytecode(150, I150Codes),
	Splits = I150Codes.
bytecode_to_intlist(rl_EXP_bool_and,	 Splits) :-
	int16_to_bytecode(151, I151Codes),
	Splits = I151Codes.
bytecode_to_intlist(rl_EXP_bool_or,	 Splits) :-
	int16_to_bytecode(152, I152Codes),
	Splits = I152Codes.
bytecode_to_intlist(rl_EXP_bool_not,	 Splits) :-
	int16_to_bytecode(153, I153Codes),
	Splits = I153Codes.
bytecode_to_intlist(rl_EXP_bool_cmp,	 Splits) :-
	int16_to_bytecode(154, I154Codes),
	Splits = I154Codes.
bytecode_to_intlist(rl_EXP_int_eq,	 Splits) :-
	int16_to_bytecode(155, I155Codes),
	Splits = I155Codes.
bytecode_to_intlist(rl_EXP_int_lt,	 Splits) :-
	int16_to_bytecode(156, I156Codes),
	Splits = I156Codes.
bytecode_to_intlist(rl_EXP_int_gt,	 Splits) :-
	int16_to_bytecode(157, I157Codes),
	Splits = I157Codes.
bytecode_to_intlist(rl_EXP_int_le,	 Splits) :-
	int16_to_bytecode(158, I158Codes),
	Splits = I158Codes.
bytecode_to_intlist(rl_EXP_int_ge,	 Splits) :-
	int16_to_bytecode(159, I159Codes),
	Splits = I159Codes.
bytecode_to_intlist(rl_EXP_int_ne,	 Splits) :-
	int16_to_bytecode(160, I160Codes),
	Splits = I160Codes.
bytecode_to_intlist(rl_EXP_int_cmp,	 Splits) :-
	int16_to_bytecode(161, I161Codes),
	Splits = I161Codes.
bytecode_to_intlist(rl_EXP_int_add,	 Splits) :-
	int16_to_bytecode(162, I162Codes),
	Splits = I162Codes.
bytecode_to_intlist(rl_EXP_int_sub,	 Splits) :-
	int16_to_bytecode(163, I163Codes),
	Splits = I163Codes.
bytecode_to_intlist(rl_EXP_int_mult,	 Splits) :-
	int16_to_bytecode(164, I164Codes),
	Splits = I164Codes.
bytecode_to_intlist(rl_EXP_int_div,	 Splits) :-
	int16_to_bytecode(165, I165Codes),
	Splits = I165Codes.
bytecode_to_intlist(rl_EXP_int_mod,	 Splits) :-
	int16_to_bytecode(166, I166Codes),
	Splits = I166Codes.
bytecode_to_intlist(rl_EXP_int_max,	 Splits) :-
	int16_to_bytecode(167, I167Codes),
	Splits = I167Codes.
bytecode_to_intlist(rl_EXP_int_min,	 Splits) :-
	int16_to_bytecode(168, I168Codes),
	Splits = I168Codes.
bytecode_to_intlist(rl_EXP_money_eq,	 Splits) :-
	int16_to_bytecode(169, I169Codes),
	Splits = I169Codes.
bytecode_to_intlist(rl_EXP_money_lt,	 Splits) :-
	int16_to_bytecode(170, I170Codes),
	Splits = I170Codes.
bytecode_to_intlist(rl_EXP_money_gt,	 Splits) :-
	int16_to_bytecode(171, I171Codes),
	Splits = I171Codes.
bytecode_to_intlist(rl_EXP_money_le,	 Splits) :-
	int16_to_bytecode(172, I172Codes),
	Splits = I172Codes.
bytecode_to_intlist(rl_EXP_money_ge,	 Splits) :-
	int16_to_bytecode(173, I173Codes),
	Splits = I173Codes.
bytecode_to_intlist(rl_EXP_money_ne,	 Splits) :-
	int16_to_bytecode(174, I174Codes),
	Splits = I174Codes.
bytecode_to_intlist(rl_EXP_money_cmp,	 Splits) :-
	int16_to_bytecode(175, I175Codes),
	Splits = I175Codes.
bytecode_to_intlist(rl_EXP_flt_eq,	 Splits) :-
	int16_to_bytecode(176, I176Codes),
	Splits = I176Codes.
bytecode_to_intlist(rl_EXP_flt_lt,	 Splits) :-
	int16_to_bytecode(177, I177Codes),
	Splits = I177Codes.
bytecode_to_intlist(rl_EXP_flt_gt,	 Splits) :-
	int16_to_bytecode(178, I178Codes),
	Splits = I178Codes.
bytecode_to_intlist(rl_EXP_flt_le,	 Splits) :-
	int16_to_bytecode(179, I179Codes),
	Splits = I179Codes.
bytecode_to_intlist(rl_EXP_flt_ge,	 Splits) :-
	int16_to_bytecode(180, I180Codes),
	Splits = I180Codes.
bytecode_to_intlist(rl_EXP_flt_ne,	 Splits) :-
	int16_to_bytecode(181, I181Codes),
	Splits = I181Codes.
bytecode_to_intlist(rl_EXP_flt_cmp,	 Splits) :-
	int16_to_bytecode(182, I182Codes),
	Splits = I182Codes.
bytecode_to_intlist(rl_EXP_flt_add,	 Splits) :-
	int16_to_bytecode(183, I183Codes),
	Splits = I183Codes.
bytecode_to_intlist(rl_EXP_flt_sub,	 Splits) :-
	int16_to_bytecode(184, I184Codes),
	Splits = I184Codes.
bytecode_to_intlist(rl_EXP_flt_mult,	 Splits) :-
	int16_to_bytecode(185, I185Codes),
	Splits = I185Codes.
bytecode_to_intlist(rl_EXP_flt_div,	 Splits) :-
	int16_to_bytecode(186, I186Codes),
	Splits = I186Codes.
bytecode_to_intlist(rl_EXP_flt_mod,	 Splits) :-
	int16_to_bytecode(187, I187Codes),
	Splits = I187Codes.
bytecode_to_intlist(rl_EXP_flt_max,	 Splits) :-
	int16_to_bytecode(188, I188Codes),
	Splits = I188Codes.
bytecode_to_intlist(rl_EXP_flt_min,	 Splits) :-
	int16_to_bytecode(189, I189Codes),
	Splits = I189Codes.
bytecode_to_intlist(rl_EXP_flt_pow,	 Splits) :-
	int16_to_bytecode(190, I190Codes),
	Splits = I190Codes.
bytecode_to_intlist(rl_EXP_term_eq,	 Splits) :-
	int16_to_bytecode(191, I191Codes),
	Splits = I191Codes.
bytecode_to_intlist(rl_EXP_term_lt,	 Splits) :-
	int16_to_bytecode(192, I192Codes),
	Splits = I192Codes.
bytecode_to_intlist(rl_EXP_term_gt,	 Splits) :-
	int16_to_bytecode(193, I193Codes),
	Splits = I193Codes.
bytecode_to_intlist(rl_EXP_term_le,	 Splits) :-
	int16_to_bytecode(194, I194Codes),
	Splits = I194Codes.
bytecode_to_intlist(rl_EXP_term_ge,	 Splits) :-
	int16_to_bytecode(195, I195Codes),
	Splits = I195Codes.
bytecode_to_intlist(rl_EXP_term_ne,	 Splits) :-
	int16_to_bytecode(196, I196Codes),
	Splits = I196Codes.
bytecode_to_intlist(rl_EXP_term_cmp,	 Splits) :-
	int16_to_bytecode(197, I197Codes),
	Splits = I197Codes.
bytecode_to_intlist(rl_EXP_str_reverse,	 Splits) :-
	int16_to_bytecode(198, I198Codes),
	Splits = I198Codes.
bytecode_to_intlist(rl_EXP_str_tolower,	 Splits) :-
	int16_to_bytecode(199, I199Codes),
	Splits = I199Codes.
bytecode_to_intlist(rl_EXP_str_toupper,	 Splits) :-
	int16_to_bytecode(200, I200Codes),
	Splits = I200Codes.
bytecode_to_intlist(rl_EXP_str_length,	 Splits) :-
	int16_to_bytecode(201, I201Codes),
	Splits = I201Codes.
bytecode_to_intlist(rl_EXP_str_toint,	 Splits) :-
	int16_to_bytecode(202, I202Codes),
	Splits = I202Codes.
bytecode_to_intlist(rl_EXP_str_tomoney,	 Splits) :-
	int16_to_bytecode(203, I203Codes),
	Splits = I203Codes.
bytecode_to_intlist(rl_EXP_str_toflt,	 Splits) :-
	int16_to_bytecode(204, I204Codes),
	Splits = I204Codes.
bytecode_to_intlist(rl_EXP_str_eq,	 Splits) :-
	int16_to_bytecode(205, I205Codes),
	Splits = I205Codes.
bytecode_to_intlist(rl_EXP_str_lt,	 Splits) :-
	int16_to_bytecode(206, I206Codes),
	Splits = I206Codes.
bytecode_to_intlist(rl_EXP_str_gt,	 Splits) :-
	int16_to_bytecode(207, I207Codes),
	Splits = I207Codes.
bytecode_to_intlist(rl_EXP_str_le,	 Splits) :-
	int16_to_bytecode(208, I208Codes),
	Splits = I208Codes.
bytecode_to_intlist(rl_EXP_str_ge,	 Splits) :-
	int16_to_bytecode(209, I209Codes),
	Splits = I209Codes.
bytecode_to_intlist(rl_EXP_str_ne,	 Splits) :-
	int16_to_bytecode(210, I210Codes),
	Splits = I210Codes.
bytecode_to_intlist(rl_EXP_str_cmp,	 Splits) :-
	int16_to_bytecode(211, I211Codes),
	Splits = I211Codes.
bytecode_to_intlist(rl_EXP_str_match,	 Splits) :-
	int16_to_bytecode(212, I212Codes),
	Splits = I212Codes.
bytecode_to_intlist(rl_EXP_str_soundex,	 Splits) :-
	int16_to_bytecode(213, I213Codes),
	Splits = I213Codes.
bytecode_to_intlist(rl_EXP_str_index,	 Splits) :-
	int16_to_bytecode(214, I214Codes),
	Splits = I214Codes.
bytecode_to_intlist(rl_EXP_str_rindex,	 Splits) :-
	int16_to_bytecode(215, I215Codes),
	Splits = I215Codes.
bytecode_to_intlist(rl_EXP_str_substr,	 Splits) :-
	int16_to_bytecode(216, I216Codes),
	Splits = I216Codes.
bytecode_to_intlist(rl_EXP_str_submatch,	 Splits) :-
	int16_to_bytecode(217, I217Codes),
	Splits = I217Codes.
bytecode_to_intlist(rl_EXP_define_input1_rule(X0rule_num,X1aString,X2aString,X3arg_num),	 Splits) :-
	int16_to_bytecode(218, I218Codes),
	int32_to_bytecode(X0rule_num, X0rule_numCodes),
	int32_to_bytecode(X1aString, X1aStringCodes),
	int32_to_bytecode(X2aString, X2aStringCodes),
	int32_to_bytecode(X3arg_num, X3arg_numCodes),
	rl_code.condense5(I218Codes, X0rule_numCodes, X1aStringCodes, X2aStringCodes, X3arg_numCodes, Splits).
bytecode_to_intlist(rl_EXP_define_input2_rule(X0rule_num,X1aString,X2aString,X3arg_num),	 Splits) :-
	int16_to_bytecode(219, I219Codes),
	int32_to_bytecode(X0rule_num, X0rule_numCodes),
	int32_to_bytecode(X1aString, X1aStringCodes),
	int32_to_bytecode(X2aString, X2aStringCodes),
	int32_to_bytecode(X3arg_num, X3arg_numCodes),
	rl_code.condense5(I219Codes, X0rule_numCodes, X1aStringCodes, X2aStringCodes, X3arg_numCodes, Splits).
bytecode_to_intlist(rl_EXP_define_var_rule(X0rule_num,X1aString,X2aString,X3arg_num),	 Splits) :-
	int16_to_bytecode(220, I220Codes),
	int32_to_bytecode(X0rule_num, X0rule_numCodes),
	int32_to_bytecode(X1aString, X1aStringCodes),
	int32_to_bytecode(X2aString, X2aStringCodes),
	int32_to_bytecode(X3arg_num, X3arg_numCodes),
	rl_code.condense5(I220Codes, X0rule_numCodes, X1aStringCodes, X2aStringCodes, X3arg_numCodes, Splits).
bytecode_to_intlist(rl_EXP_define_output_rule(X0rule_num,X1aString,X2aString,X3arg_num),	 Splits) :-
	int16_to_bytecode(221, I221Codes),
	int32_to_bytecode(X0rule_num, X0rule_numCodes),
	int32_to_bytecode(X1aString, X1aStringCodes),
	int32_to_bytecode(X2aString, X2aStringCodes),
	int32_to_bytecode(X3arg_num, X3arg_numCodes),
	rl_code.condense5(I221Codes, X0rule_numCodes, X1aStringCodes, X2aStringCodes, X3arg_numCodes, Splits).
bytecode_to_intlist(rl_EXP_define_output1_rule(X0rule_num,X1aString,X2aString,X3arg_num),	 Splits) :-
	int16_to_bytecode(222, I222Codes),
	int32_to_bytecode(X0rule_num, X0rule_numCodes),
	int32_to_bytecode(X1aString, X1aStringCodes),
	int32_to_bytecode(X2aString, X2aStringCodes),
	int32_to_bytecode(X3arg_num, X3arg_numCodes),
	rl_code.condense5(I222Codes, X0rule_numCodes, X1aStringCodes, X2aStringCodes, X3arg_numCodes, Splits).
bytecode_to_intlist(rl_EXP_define_output2_rule(X0rule_num,X1aString,X2aString,X3arg_num),	 Splits) :-
	int16_to_bytecode(223, I223Codes),
	int32_to_bytecode(X0rule_num, X0rule_numCodes),
	int32_to_bytecode(X1aString, X1aStringCodes),
	int32_to_bytecode(X2aString, X2aStringCodes),
	int32_to_bytecode(X3arg_num, X3arg_numCodes),
	rl_code.condense5(I223Codes, X0rule_numCodes, X1aStringCodes, X2aStringCodes, X3arg_numCodes, Splits).
bytecode_to_intlist(rl_EXP_copy_term_var(X0var_num),	 Splits) :-
	int16_to_bytecode(224, I224Codes),
	int32_to_bytecode(X0var_num, X0var_numCodes),
	list.append(I224Codes, X0var_numCodes, Splits).
bytecode_to_intlist(rl_EXP_copy_term_output(X0field_num),	 Splits) :-
	int16_to_bytecode(225, I225Codes),
	int32_to_bytecode(X0field_num, X0field_numCodes),
	list.append(I225Codes, X0field_numCodes, Splits).
bytecode_to_intlist(rl_EXP_copy_term_output1(X0field_num),	 Splits) :-
	int16_to_bytecode(226, I226Codes),
	int32_to_bytecode(X0field_num, X0field_numCodes),
	list.append(I226Codes, X0field_numCodes, Splits).
bytecode_to_intlist(rl_EXP_copy_term_output2(X0field_num),	 Splits) :-
	int16_to_bytecode(227, I227Codes),
	int32_to_bytecode(X0field_num, X0field_numCodes),
	list.append(I227Codes, X0field_numCodes, Splits).
bytecode_to_intlist(rl_EXP_copy_term_arg(X0arg_num),	 Splits) :-
	int16_to_bytecode(228, I228Codes),
	int32_to_bytecode(X0arg_num, X0arg_numCodes),
	list.append(I228Codes, X0arg_numCodes, Splits).
bytecode_to_intlist(rl_EXP_put_term_var(X0var_num),	 Splits) :-
	int16_to_bytecode(229, I229Codes),
	int32_to_bytecode(X0var_num, X0var_numCodes),
	list.append(I229Codes, X0var_numCodes, Splits).
bytecode_to_intlist(rl_EXP_put_term_output(X0field_num),	 Splits) :-
	int16_to_bytecode(230, I230Codes),
	int32_to_bytecode(X0field_num, X0field_numCodes),
	list.append(I230Codes, X0field_numCodes, Splits).
bytecode_to_intlist(rl_EXP_put_term_output1(X0field_num),	 Splits) :-
	int16_to_bytecode(231, I231Codes),
	int32_to_bytecode(X0field_num, X0field_numCodes),
	list.append(I231Codes, X0field_numCodes, Splits).
bytecode_to_intlist(rl_EXP_put_term_output2(X0field_num),	 Splits) :-
	int16_to_bytecode(232, I232Codes),
	int32_to_bytecode(X0field_num, X0field_numCodes),
	list.append(I232Codes, X0field_numCodes, Splits).
bytecode_to_intlist(rl_EXP_put_term_arg(X0arg_num),	 Splits) :-
	int16_to_bytecode(233, I233Codes),
	int32_to_bytecode(X0arg_num, X0arg_numCodes),
	list.append(I233Codes, X0arg_numCodes, Splits).
bytecode_to_intlist(rl_EXP_bool_hash,	 Splits) :-
	int16_to_bytecode(234, I234Codes),
	Splits = I234Codes.
bytecode_to_intlist(rl_EXP_int_hash,	 Splits) :-
	int16_to_bytecode(235, I235Codes),
	Splits = I235Codes.
bytecode_to_intlist(rl_EXP_money_hash,	 Splits) :-
	int16_to_bytecode(236, I236Codes),
	Splits = I236Codes.
bytecode_to_intlist(rl_EXP_flt_hash,	 Splits) :-
	int16_to_bytecode(237, I237Codes),
	Splits = I237Codes.
bytecode_to_intlist(rl_EXP_str_hash,	 Splits) :-
	int16_to_bytecode(238, I238Codes),
	Splits = I238Codes.
bytecode_to_intlist(rl_EXP_blob_hash,	 Splits) :-
	int16_to_bytecode(239, I239Codes),
	Splits = I239Codes.
bytecode_to_intlist(rl_EXP_term_hash,	 Splits) :-
	int16_to_bytecode(240, I240Codes),
	Splits = I240Codes.
bytecode_to_intlist(rl_EXP_hash_combine,	 Splits) :-
	int16_to_bytecode(241, I241Codes),
	Splits = I241Codes.
bytecode_to_intlist(rl_EXP_hash_result,	 Splits) :-
	int16_to_bytecode(242, I242Codes),
	Splits = I242Codes.
bytecode_to_intlist(rl_EXP_declare_mercury_proc(X0int32,X1aString),	 Splits) :-
	int16_to_bytecode(243, I243Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	int32_to_bytecode(X1aString, X1aStringCodes),
	rl_code.condense3(I243Codes, X0int32Codes, X1aStringCodes, Splits).
bytecode_to_intlist(rl_EXP_allocate_mercury_input_args(X0int32),	 Splits) :-
	int16_to_bytecode(244, I244Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	list.append(I244Codes, X0int32Codes, Splits).
bytecode_to_intlist(rl_EXP_clear_mercury_input_args,	 Splits) :-
	int16_to_bytecode(245, I245Codes),
	Splits = I245Codes.
bytecode_to_intlist(rl_EXP_convert_int_mercury_input_arg(X0int32,X1int32),	 Splits) :-
	int16_to_bytecode(246, I246Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	int32_to_bytecode(X1int32, X1int32Codes),
	rl_code.condense3(I246Codes, X0int32Codes, X1int32Codes, Splits).
bytecode_to_intlist(rl_EXP_convert_flt_mercury_input_arg(X0int32,X1int32),	 Splits) :-
	int16_to_bytecode(247, I247Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	int32_to_bytecode(X1int32, X1int32Codes),
	rl_code.condense3(I247Codes, X0int32Codes, X1int32Codes, Splits).
bytecode_to_intlist(rl_EXP_convert_str_mercury_input_arg(X0int32,X1int32),	 Splits) :-
	int16_to_bytecode(248, I248Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	int32_to_bytecode(X1int32, X1int32Codes),
	rl_code.condense3(I248Codes, X0int32Codes, X1int32Codes, Splits).
bytecode_to_intlist(rl_EXP_convert_term_mercury_input_arg(X0int32,X1int32),	 Splits) :-
	int16_to_bytecode(249, I249Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	int32_to_bytecode(X1int32, X1int32Codes),
	rl_code.condense3(I249Codes, X0int32Codes, X1int32Codes, Splits).
bytecode_to_intlist(rl_EXP_convert_int_mercury_output_arg(X0int32,X1int32,X2int32),	 Splits) :-
	int16_to_bytecode(250, I250Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	int32_to_bytecode(X1int32, X1int32Codes),
	int32_to_bytecode(X2int32, X2int32Codes),
	rl_code.condense4(I250Codes, X0int32Codes, X1int32Codes, X2int32Codes, Splits).
bytecode_to_intlist(rl_EXP_convert_flt_mercury_output_arg(X0int32,X1int32,X2int32),	 Splits) :-
	int16_to_bytecode(251, I251Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	int32_to_bytecode(X1int32, X1int32Codes),
	int32_to_bytecode(X2int32, X2int32Codes),
	rl_code.condense4(I251Codes, X0int32Codes, X1int32Codes, X2int32Codes, Splits).
bytecode_to_intlist(rl_EXP_convert_str_mercury_output_arg(X0int32,X1int32,X2int32),	 Splits) :-
	int16_to_bytecode(252, I252Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	int32_to_bytecode(X1int32, X1int32Codes),
	int32_to_bytecode(X2int32, X2int32Codes),
	rl_code.condense4(I252Codes, X0int32Codes, X1int32Codes, X2int32Codes, Splits).
bytecode_to_intlist(rl_EXP_convert_term_mercury_output_arg(X0int32,X1int32,X2int32),	 Splits) :-
	int16_to_bytecode(253, I253Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	int32_to_bytecode(X1int32, X1int32Codes),
	int32_to_bytecode(X2int32, X2int32Codes),
	rl_code.condense4(I253Codes, X0int32Codes, X1int32Codes, X2int32Codes, Splits).
bytecode_to_intlist(rl_EXP_retrieve_nondet_solution(X0int32),	 Splits) :-
	int16_to_bytecode(254, I254Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	list.append(I254Codes, X0int32Codes, Splits).
bytecode_to_intlist(rl_EXP_call_mercury_proc(X0int32),	 Splits) :-
	int16_to_bytecode(255, I255Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	list.append(I255Codes, X0int32Codes, Splits).
bytecode_to_intlist(rl_EXP_update_aggregate_accumulator(X0int32),	 Splits) :-
	int16_to_bytecode(256, I256Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	list.append(I256Codes, X0int32Codes, Splits).
bytecode_to_intlist(rl_EXP_set_more_solutions,	 Splits) :-
	int16_to_bytecode(257, I257Codes),
	Splits = I257Codes.
bytecode_to_intlist(rl_EXP_cleanup_single_solution,	 Splits) :-
	int16_to_bytecode(258, I258Codes),
	Splits = I258Codes.
bytecode_to_intlist(rl_EXP_cleanup_nondet_solution,	 Splits) :-
	int16_to_bytecode(259, I259Codes),
	Splits = I259Codes.
bytecode_to_intlist(rl_EXP_invalid_solution_location,	 Splits) :-
	int16_to_bytecode(260, I260Codes),
	Splits = I260Codes.
bytecode_to_intlist(rl_EXP_last_bytecode,	 Splits) :-
	int16_to_bytecode(261, I261Codes),
	Splits = I261Codes.
bytecode_to_intlist(rl_PROC_update(X0int32),	 Splits) :-
	int16_to_bytecode(262, I262Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	list.append(I262Codes, X0int32Codes, Splits).
bytecode_to_intlist(rl_PROC_modify,	 Splits) :-
	int16_to_bytecode(263, I263Codes),
	Splits = I263Codes.
bytecode_to_intlist(rl_PROC_project_torel,	 Splits) :-
	int16_to_bytecode(264, I264Codes),
	Splits = I264Codes.
bytecode_to_intlist(rl_PROC_materialise(X0int32),	 Splits) :-
	int16_to_bytecode(265, I265Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	list.append(I265Codes, X0int32Codes, Splits).
bytecode_to_intlist(rl_PROC_insert_tuple,	 Splits) :-
	int16_to_bytecode(266, I266Codes),
	Splits = I266Codes.
bytecode_to_intlist(rl_PROC_whilenotempty(X0int32),	 Splits) :-
	int16_to_bytecode(267, I267Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	list.append(I267Codes, X0int32Codes, Splits).
bytecode_to_intlist(rl_PROC_while,	 Splits) :-
	int16_to_bytecode(268, I268Codes),
	Splits = I268Codes.
bytecode_to_intlist(rl_PROC_while_end,	 Splits) :-
	int16_to_bytecode(269, I269Codes),
	Splits = I269Codes.
bytecode_to_intlist(rl_PROC_setrel(X0int32,X1int32),	 Splits) :-
	int16_to_bytecode(270, I270Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	int32_to_bytecode(X1int32, X1int32Codes),
	rl_code.condense3(I270Codes, X0int32Codes, X1int32Codes, Splits).
bytecode_to_intlist(rl_PROC_unsetrel(X0int32),	 Splits) :-
	int16_to_bytecode(271, I271Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	list.append(I271Codes, X0int32Codes, Splits).
bytecode_to_intlist(rl_PROC_declrel(X0int32,X1int32),	 Splits) :-
	int16_to_bytecode(272, I272Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	int32_to_bytecode(X1int32, X1int32Codes),
	rl_code.condense3(I272Codes, X0int32Codes, X1int32Codes, Splits).
bytecode_to_intlist(rl_PROC_grouprels,	 Splits) :-
	int16_to_bytecode(273, I273Codes),
	Splits = I273Codes.
bytecode_to_intlist(rl_PROC_getschemaspec,	 Splits) :-
	int16_to_bytecode(274, I274Codes),
	Splits = I274Codes.
bytecode_to_intlist(rl_PROC_setschema(X0int32),	 Splits) :-
	int16_to_bytecode(275, I275Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	list.append(I275Codes, X0int32Codes, Splits).
bytecode_to_intlist(rl_PROC_settemprel(X0int32,X1aString,X2aString),	 Splits) :-
	int16_to_bytecode(276, I276Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	int32_to_bytecode(X1aString, X1aStringCodes),
	int32_to_bytecode(X2aString, X2aStringCodes),
	rl_code.condense4(I276Codes, X0int32Codes, X1aStringCodes, X2aStringCodes, Splits).
bytecode_to_intlist(rl_PROC_createtemprel(X0int32,X1aString),	 Splits) :-
	int16_to_bytecode(277, I277Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	int32_to_bytecode(X1aString, X1aStringCodes),
	rl_code.condense3(I277Codes, X0int32Codes, X1aStringCodes, Splits).
bytecode_to_intlist(rl_PROC_nametemprel(X0int32,X1aString),	 Splits) :-
	int16_to_bytecode(278, I278Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	int32_to_bytecode(X1aString, X1aStringCodes),
	rl_code.condense3(I278Codes, X0int32Codes, X1aStringCodes, Splits).
bytecode_to_intlist(rl_PROC_unnametemprel(X0int32),	 Splits) :-
	int16_to_bytecode(279, I279Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	list.append(I279Codes, X0int32Codes, Splits).
bytecode_to_intlist(rl_PROC_openpermrel(X0int32,X1aString,X2aString),	 Splits) :-
	int16_to_bytecode(280, I280Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	int32_to_bytecode(X1aString, X1aStringCodes),
	int32_to_bytecode(X2aString, X2aStringCodes),
	rl_code.condense4(I280Codes, X0int32Codes, X1aStringCodes, X2aStringCodes, Splits).
bytecode_to_intlist(rl_PROC_createpermrel(X0int32,X1aString,X2aString),	 Splits) :-
	int16_to_bytecode(281, I281Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	int32_to_bytecode(X1aString, X1aStringCodes),
	int32_to_bytecode(X2aString, X2aStringCodes),
	rl_code.condense4(I281Codes, X0int32Codes, X1aStringCodes, X2aStringCodes, Splits).
bytecode_to_intlist(rl_PROC_addindextorel(X0int32,X1aString),	 Splits) :-
	int16_to_bytecode(282, I282Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	int32_to_bytecode(X1aString, X1aStringCodes),
	rl_code.condense3(I282Codes, X0int32Codes, X1aStringCodes, Splits).
bytecode_to_intlist(rl_PROC_addindextoschema(X0int32),	 Splits) :-
	int16_to_bytecode(283, I283Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	list.append(I283Codes, X0int32Codes, Splits).
bytecode_to_intlist(rl_PROC_clear(X0int32),	 Splits) :-
	int16_to_bytecode(284, I284Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	list.append(I284Codes, X0int32Codes, Splits).
bytecode_to_intlist(rl_PROC_drop(X0int32),	 Splits) :-
	int16_to_bytecode(285, I285Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	list.append(I285Codes, X0int32Codes, Splits).
bytecode_to_intlist(rl_PROC_dropindex(X0int32),	 Splits) :-
	int16_to_bytecode(286, I286Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	list.append(I286Codes, X0int32Codes, Splits).
bytecode_to_intlist(rl_PROC_begintransaction(X0aString,X1int32),	 Splits) :-
	int16_to_bytecode(287, I287Codes),
	int32_to_bytecode(X0aString, X0aStringCodes),
	int32_to_bytecode(X1int32, X1int32Codes),
	rl_code.condense3(I287Codes, X0aStringCodes, X1int32Codes, Splits).
bytecode_to_intlist(rl_PROC_savepoint(X0int32),	 Splits) :-
	int16_to_bytecode(288, I288Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	list.append(I288Codes, X0int32Codes, Splits).
bytecode_to_intlist(rl_PROC_rollback(X0int32),	 Splits) :-
	int16_to_bytecode(289, I289Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	list.append(I289Codes, X0int32Codes, Splits).
bytecode_to_intlist(rl_PROC_commit,	 Splits) :-
	int16_to_bytecode(290, I290Codes),
	Splits = I290Codes.
bytecode_to_intlist(rl_PROC_abort,	 Splits) :-
	int16_to_bytecode(291, I291Codes),
	Splits = I291Codes.
bytecode_to_intlist(rl_PROC_delete(X0int32),	 Splits) :-
	int16_to_bytecode(292, I292Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	list.append(I292Codes, X0int32Codes, Splits).
bytecode_to_intlist(rl_PROC_insert(X0int32),	 Splits) :-
	int16_to_bytecode(293, I293Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	list.append(I293Codes, X0int32Codes, Splits).
bytecode_to_intlist(rl_PROC_bind_code(X0int32),	 Splits) :-
	int16_to_bytecode(294, I294Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	list.append(I294Codes, X0int32Codes, Splits).
bytecode_to_intlist(rl_PROC_bind_handle(X0int32),	 Splits) :-
	int16_to_bytecode(295, I295Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	list.append(I295Codes, X0int32Codes, Splits).
bytecode_to_intlist(rl_PROC_call(X0aString),	 Splits) :-
	int16_to_bytecode(296, I296Codes),
	int32_to_bytecode(X0aString, X0aStringCodes),
	list.append(I296Codes, X0aStringCodes, Splits).
bytecode_to_intlist(rl_PROC_label(X0int32),	 Splits) :-
	int16_to_bytecode(297, I297Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	list.append(I297Codes, X0int32Codes, Splits).
bytecode_to_intlist(rl_PROC_goto(X0int32),	 Splits) :-
	int16_to_bytecode(298, I298Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	list.append(I298Codes, X0int32Codes, Splits).
bytecode_to_intlist(rl_PROC_conditional_goto(X0int32),	 Splits) :-
	int16_to_bytecode(299, I299Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	list.append(I299Codes, X0int32Codes, Splits).
bytecode_to_intlist(rl_PROC_goto_label(X0int32),	 Splits) :-
	int16_to_bytecode(300, I300Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	list.append(I300Codes, X0int32Codes, Splits).
bytecode_to_intlist(rl_PROC_conditional_goto_label(X0int32),	 Splits) :-
	int16_to_bytecode(301, I301Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	list.append(I301Codes, X0int32Codes, Splits).
bytecode_to_intlist(rl_PROC_notempty,	 Splits) :-
	int16_to_bytecode(302, I302Codes),
	Splits = I302Codes.
bytecode_to_intlist(rl_PROC_empty,	 Splits) :-
	int16_to_bytecode(303, I303Codes),
	Splits = I303Codes.
bytecode_to_intlist(rl_PROC_one_reference(X0int32),	 Splits) :-
	int16_to_bytecode(304, I304Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	list.append(I304Codes, X0int32Codes, Splits).
bytecode_to_intlist(rl_PROC_is_permanent(X0int32),	 Splits) :-
	int16_to_bytecode(305, I305Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	list.append(I305Codes, X0int32Codes, Splits).
bytecode_to_intlist(rl_PROC_is_named(X0int32),	 Splits) :-
	int16_to_bytecode(306, I306Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	list.append(I306Codes, X0int32Codes, Splits).
bytecode_to_intlist(rl_PROC_has_index(X0int32,X1aString),	 Splits) :-
	int16_to_bytecode(307, I307Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	int32_to_bytecode(X1aString, X1aStringCodes),
	rl_code.condense3(I307Codes, X0int32Codes, X1aStringCodes, Splits).
bytecode_to_intlist(rl_PROC_and,	 Splits) :-
	int16_to_bytecode(308, I308Codes),
	Splits = I308Codes.
bytecode_to_intlist(rl_PROC_or,	 Splits) :-
	int16_to_bytecode(309, I309Codes),
	Splits = I309Codes.
bytecode_to_intlist(rl_PROC_not,	 Splits) :-
	int16_to_bytecode(310, I310Codes),
	Splits = I310Codes.
bytecode_to_intlist(rl_PROC_stream,	 Splits) :-
	int16_to_bytecode(311, I311Codes),
	Splits = I311Codes.
bytecode_to_intlist(rl_PROC_stream_end,	 Splits) :-
	int16_to_bytecode(312, I312Codes),
	Splits = I312Codes.
bytecode_to_intlist(rl_PROC_stream_list_cons,	 Splits) :-
	int16_to_bytecode(313, I313Codes),
	Splits = I313Codes.
bytecode_to_intlist(rl_PROC_stream_list_nil,	 Splits) :-
	int16_to_bytecode(314, I314Codes),
	Splits = I314Codes.
bytecode_to_intlist(rl_PROC_var(X0int32,X1int32),	 Splits) :-
	int16_to_bytecode(315, I315Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	int32_to_bytecode(X1int32, X1int32Codes),
	rl_code.condense3(I315Codes, X0int32Codes, X1int32Codes, Splits).
bytecode_to_intlist(rl_PROC_indexed_var(X0int32,X1int32,X2aString),	 Splits) :-
	int16_to_bytecode(316, I316Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	int32_to_bytecode(X1int32, X1int32Codes),
	int32_to_bytecode(X2aString, X2aStringCodes),
	rl_code.condense4(I316Codes, X0int32Codes, X1int32Codes, X2aStringCodes, Splits).
bytecode_to_intlist(rl_PROC_var_list_cons(X0int32,X1int32),	 Splits) :-
	int16_to_bytecode(317, I317Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	int32_to_bytecode(X1int32, X1int32Codes),
	rl_code.condense3(I317Codes, X0int32Codes, X1int32Codes, Splits).
bytecode_to_intlist(rl_PROC_var_list_nil,	 Splits) :-
	int16_to_bytecode(318, I318Codes),
	Splits = I318Codes.
bytecode_to_intlist(rl_PROC_expr(X0int32),	 Splits) :-
	int16_to_bytecode(319, I319Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	list.append(I319Codes, X0int32Codes, Splits).
bytecode_to_intlist(rl_PROC_expr_frag(X0int32),	 Splits) :-
	int16_to_bytecode(320, I320Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	list.append(I320Codes, X0int32Codes, Splits).
bytecode_to_intlist(rl_PROC_expr_end,	 Splits) :-
	int16_to_bytecode(321, I321Codes),
	Splits = I321Codes.
bytecode_to_intlist(rl_PROC_expr_list_cons(X0int32),	 Splits) :-
	int16_to_bytecode(322, I322Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	list.append(I322Codes, X0int32Codes, Splits).
bytecode_to_intlist(rl_PROC_expr_list_nil,	 Splits) :-
	int16_to_bytecode(323, I323Codes),
	Splits = I323Codes.
bytecode_to_intlist(rl_PROC_bool_op_list_cons,	 Splits) :-
	int16_to_bytecode(324, I324Codes),
	Splits = I324Codes.
bytecode_to_intlist(rl_PROC_bool_op_list_nil,	 Splits) :-
	int16_to_bytecode(325, I325Codes),
	Splits = I325Codes.
bytecode_to_intlist(rl_PROC_int_list_cons(X0int32),	 Splits) :-
	int16_to_bytecode(326, I326Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	list.append(I326Codes, X0int32Codes, Splits).
bytecode_to_intlist(rl_PROC_int_list_nil,	 Splits) :-
	int16_to_bytecode(327, I327Codes),
	Splits = I327Codes.
bytecode_to_intlist(rl_PROC_ret,	 Splits) :-
	int16_to_bytecode(328, I328Codes),
	Splits = I328Codes.
bytecode_to_intlist(rl_PROC_join,	 Splits) :-
	int16_to_bytecode(329, I329Codes),
	Splits = I329Codes.
bytecode_to_intlist(rl_PROC_join_nl,	 Splits) :-
	int16_to_bytecode(330, I330Codes),
	Splits = I330Codes.
bytecode_to_intlist(rl_PROC_join_sm,	 Splits) :-
	int16_to_bytecode(331, I331Codes),
	Splits = I331Codes.
bytecode_to_intlist(rl_PROC_join_hj,	 Splits) :-
	int16_to_bytecode(332, I332Codes),
	Splits = I332Codes.
bytecode_to_intlist(rl_PROC_join_index_simple(X0int32),	 Splits) :-
	int16_to_bytecode(333, I333Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	list.append(I333Codes, X0int32Codes, Splits).
bytecode_to_intlist(rl_PROC_join_index_complex,	 Splits) :-
	int16_to_bytecode(334, I334Codes),
	Splits = I334Codes.
bytecode_to_intlist(rl_PROC_join_cross,	 Splits) :-
	int16_to_bytecode(335, I335Codes),
	Splits = I335Codes.
bytecode_to_intlist(rl_PROC_semijoin_nl,	 Splits) :-
	int16_to_bytecode(336, I336Codes),
	Splits = I336Codes.
bytecode_to_intlist(rl_PROC_semijoin_sm,	 Splits) :-
	int16_to_bytecode(337, I337Codes),
	Splits = I337Codes.
bytecode_to_intlist(rl_PROC_semijoin_hj,	 Splits) :-
	int16_to_bytecode(338, I338Codes),
	Splits = I338Codes.
bytecode_to_intlist(rl_PROC_semijoin_index(X0int32,X1int32),	 Splits) :-
	int16_to_bytecode(339, I339Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	int32_to_bytecode(X1int32, X1int32Codes),
	rl_code.condense3(I339Codes, X0int32Codes, X1int32Codes, Splits).
bytecode_to_intlist(rl_PROC_subtract,	 Splits) :-
	int16_to_bytecode(340, I340Codes),
	Splits = I340Codes.
bytecode_to_intlist(rl_PROC_subtract_nl,	 Splits) :-
	int16_to_bytecode(341, I341Codes),
	Splits = I341Codes.
bytecode_to_intlist(rl_PROC_subtract_sm,	 Splits) :-
	int16_to_bytecode(342, I342Codes),
	Splits = I342Codes.
bytecode_to_intlist(rl_PROC_subtract_hj,	 Splits) :-
	int16_to_bytecode(343, I343Codes),
	Splits = I343Codes.
bytecode_to_intlist(rl_PROC_subtract_index(X0int32),	 Splits) :-
	int16_to_bytecode(344, I344Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	list.append(I344Codes, X0int32Codes, Splits).
bytecode_to_intlist(rl_PROC_subtract_cross,	 Splits) :-
	int16_to_bytecode(345, I345Codes),
	Splits = I345Codes.
bytecode_to_intlist(rl_PROC_semisubtract_nl,	 Splits) :-
	int16_to_bytecode(346, I346Codes),
	Splits = I346Codes.
bytecode_to_intlist(rl_PROC_semisubtract_hj,	 Splits) :-
	int16_to_bytecode(347, I347Codes),
	Splits = I347Codes.
bytecode_to_intlist(rl_PROC_semisubtract_index(X0int32),	 Splits) :-
	int16_to_bytecode(348, I348Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	list.append(I348Codes, X0int32Codes, Splits).
bytecode_to_intlist(rl_PROC_difference,	 Splits) :-
	int16_to_bytecode(349, I349Codes),
	Splits = I349Codes.
bytecode_to_intlist(rl_PROC_select,	 Splits) :-
	int16_to_bytecode(350, I350Codes),
	Splits = I350Codes.
bytecode_to_intlist(rl_PROC_select_filter,	 Splits) :-
	int16_to_bytecode(351, I351Codes),
	Splits = I351Codes.
bytecode_to_intlist(rl_PROC_select_index(X0int32),	 Splits) :-
	int16_to_bytecode(352, I352Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	list.append(I352Codes, X0int32Codes, Splits).
bytecode_to_intlist(rl_PROC_btree_scan(X0int32),	 Splits) :-
	int16_to_bytecode(353, I353Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	list.append(I353Codes, X0int32Codes, Splits).
bytecode_to_intlist(rl_PROC_project_tee,	 Splits) :-
	int16_to_bytecode(354, I354Codes),
	Splits = I354Codes.
bytecode_to_intlist(rl_PROC_sort(X0int32),	 Splits) :-
	int16_to_bytecode(355, I355Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	list.append(I355Codes, X0int32Codes, Splits).
bytecode_to_intlist(rl_PROC_union,	 Splits) :-
	int16_to_bytecode(356, I356Codes),
	Splits = I356Codes.
bytecode_to_intlist(rl_PROC_union_sm,	 Splits) :-
	int16_to_bytecode(357, I357Codes),
	Splits = I357Codes.
bytecode_to_intlist(rl_PROC_uniondiff,	 Splits) :-
	int16_to_bytecode(358, I358Codes),
	Splits = I358Codes.
bytecode_to_intlist(rl_PROC_uniondiff_sm,	 Splits) :-
	int16_to_bytecode(359, I359Codes),
	Splits = I359Codes.
bytecode_to_intlist(rl_PROC_uniondiff_btree,	 Splits) :-
	int16_to_bytecode(360, I360Codes),
	Splits = I360Codes.
bytecode_to_intlist(rl_PROC_aggregate,	 Splits) :-
	int16_to_bytecode(361, I361Codes),
	Splits = I361Codes.
bytecode_to_intlist(rl_PROC_aggregate_sm,	 Splits) :-
	int16_to_bytecode(362, I362Codes),
	Splits = I362Codes.
bytecode_to_intlist(rl_PROC_aggregate_onegroup,	 Splits) :-
	int16_to_bytecode(363, I363Codes),
	Splits = I363Codes.
bytecode_to_intlist(rl_PROC_insert_tuple_stream,	 Splits) :-
	int16_to_bytecode(364, I364Codes),
	Splits = I364Codes.
bytecode_to_intlist(rl_PROC_empty_stream(X0aString),	 Splits) :-
	int16_to_bytecode(365, I365Codes),
	int32_to_bytecode(X0aString, X0aStringCodes),
	list.append(I365Codes, X0aStringCodes, Splits).
bytecode_to_intlist(rl_PROC_hypothetical,	 Splits) :-
	int16_to_bytecode(366, I366Codes),
	Splits = I366Codes.
bytecode_to_intlist(rl_PROC_topdown,	 Splits) :-
	int16_to_bytecode(367, I367Codes),
	Splits = I367Codes.
bytecode_to_intlist(rl_PROC_last_bytecode,	 Splits) :-
	int16_to_bytecode(368, I368Codes),
	Splits = I368Codes.
bytecode_to_intlist(rl_HEAD_proc(X0aString,X1aString,X2aString,X3int32),	 Splits) :-
	int16_to_bytecode(369, I369Codes),
	int32_to_bytecode(X0aString, X0aStringCodes),
	int32_to_bytecode(X1aString, X1aStringCodes),
	int32_to_bytecode(X2aString, X2aStringCodes),
	int32_to_bytecode(X3int32, X3int32Codes),
	rl_code.condense5(I369Codes, X0aStringCodes, X1aStringCodes, X2aStringCodes, X3int32Codes, Splits).
bytecode_to_intlist(rl_HEAD_proc_end,	 Splits) :-
	int16_to_bytecode(370, I370Codes),
	Splits = I370Codes.
bytecode_to_intlist(rl_HEAD_const_int(X0int32,X1aInt),	 Splits) :-
	int16_to_bytecode(371, I371Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	aInt_to_bytecode(X1aInt, X1aIntCodes),
	rl_code.condense3(I371Codes, X0int32Codes, X1aIntCodes, Splits).
bytecode_to_intlist(rl_HEAD_const_flt(X0int32,X1aDouble),	 Splits) :-
	int16_to_bytecode(372, I372Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	aDouble_to_bytecode(X1aDouble, X1aDoubleCodes),
	rl_code.condense3(I372Codes, X0int32Codes, X1aDoubleCodes, Splits).
bytecode_to_intlist(rl_HEAD_const_str(X0int32,X1aString),	 Splits) :-
	int16_to_bytecode(373, I373Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	aString_to_bytecode(X1aString, X1aStringCodes),
	rl_code.condense3(I373Codes, X0int32Codes, X1aStringCodes, Splits).
bytecode_to_intlist(rl_HEAD_var_int(X0int32),	 Splits) :-
	int16_to_bytecode(374, I374Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	list.append(I374Codes, X0int32Codes, Splits).
bytecode_to_intlist(rl_HEAD_var_flt(X0int32),	 Splits) :-
	int16_to_bytecode(375, I375Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	list.append(I375Codes, X0int32Codes, Splits).
bytecode_to_intlist(rl_HEAD_var_str(X0int32),	 Splits) :-
	int16_to_bytecode(376, I376Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	list.append(I376Codes, X0int32Codes, Splits).
bytecode_to_intlist(rl_HEAD_var_term(X0int32),	 Splits) :-
	int16_to_bytecode(377, I377Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	list.append(I377Codes, X0int32Codes, Splits).
bytecode_to_intlist(rl_HEAD_var_stream(X0int32),	 Splits) :-
	int16_to_bytecode(378, I378Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	list.append(I378Codes, X0int32Codes, Splits).
bytecode_to_intlist(rl_HEAD_define_rule(X0int32,X1aString,X2aString),	 Splits) :-
	int16_to_bytecode(379, I379Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	int32_to_bytecode(X1aString, X1aStringCodes),
	int32_to_bytecode(X2aString, X2aStringCodes),
	rl_code.condense4(I379Codes, X0int32Codes, X1aStringCodes, X2aStringCodes, Splits).
bytecode_to_intlist(rl_HEAD_last_bytecode,	 Splits) :-
	int16_to_bytecode(380, I380Codes),
	Splits = I380Codes.

int32_to_bytecode(X, List) :-
	int32_to_byte_list(X, List).

int16_to_bytecode(X, List) :-
	short_to_byte_list(X, List).

aString_to_bytecode(Str, Ints) :-
	string_to_byte_list(Str, Ints).

aDouble_to_bytecode(Flt, List) :-
	float_to_byte_list(Flt, List).

aBlob_to_bytecode(_Blob, [0]).	% NYI

aInt_to_bytecode(X, List) :-
	int_to_byte_list(X, List).


:- pred condense3(list(T)::in, list(T)::in, list(T)::in, list(T)::out) is det.
:- pragma no_inline(condense3/4).
condense3(L1, L2, L3, list.append(L1, list.append(L2, L3))).

:- pred condense4(list(T)::in, list(T)::in, list(T)::in, list(T)::in, list(T)::out) is det.
:- pragma no_inline(condense4/5).
condense4(L1, L2, L3, L4, list.append(L1, list.append(L2, list.append(L3, L4)))).

:- pred condense5(list(T)::in, list(T)::in, list(T)::in, list(T)::in, list(T)::in, list(T)::out) is det.
:- pragma no_inline(condense5/6).
condense5(L1, L2, L3, L4, L5, list.append(L1, list.append(L2, list.append(L3, list.append(L4, L5))))).

rl_code__version(1, 28).
