/*
dnsbl.h - MessageWall DNS blacklist declarations
Copyright (C) 2002 Ian Gulliver

This program is free software; you can redistribute it and/or modify
it under the terms of version 2 of the GNU General Public License as
published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef _DNSBL_H
#define _DNSBL_H

#define DNSBL_TEXT_MAXLEN 512

#include "messagewall.h"

int dnsbl_send_queries(int client);
int dnsbl_resend_queries(int client);
int dnsbl_response(int client, int dnsbl);
int dnsbl_check_profile(int client, int force);

int dnsbl_domain_send_queries(int client);
int dnsbl_domain_resend_queries(int client);
int dnsbl_domain_response(int client, int dnsbl);
int dnsbl_domain_check_profile(int client, int force);

#endif
