/***************************************************************************
 *   Copyright (C) 2005 by Florian Roth   *
 *   florian@synatic.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifndef _METABAR_WIDGET_H_
#define _METABAR_WIDGET_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qwidget.h>
#include <qlabel.h>
#include <qevent.h>
#include <qframe.h>
#include <qlayout.h>
#include <qptrdict.h>
#include <qwidgetstack.h>
#include <qslider.h>
#include <qtimer.h>
#include <qprogressbar.h>

#include <kfileitem.h>
#include <kconfig.h>
#include <ksqueezedtextlabel.h>
#include <kpushbutton.h>
#include <kurllabel.h>
#include <kdirwatch.h>
#include <kio/previewjob.h>
#include <kconfig.h>

#include <kvideowidget.h>
#include <kplayobject.h>
#include <kartsserver.h>
#include <kartsdispatcher.h>
#include <kplayobjectfactory.h>

#include "configdialog.h"
#include "linkwidget.h"
#include "metaframe.h"
#include "serviceloader.h"

class ConfigDialog;
class LinkWidget;
class MetaFrame;
class ServiceLoader;

/**
 * @short Application Main Window
 * @author Florian Roth <florian@synatic.net>
 * @version 0.1
 */
class MetabarWidget : public QWidget
{
    Q_OBJECT
  public:
  
    MetabarWidget(QWidget *parent = 0, const char *name = 0);
    virtual ~MetabarWidget();
    
    void setFileItems(const KFileItemList &items);
    
  protected:
    void showEvent(QShowEvent *event);
    void resizeEvent(QResizeEvent *event);
    
  protected slots:
    void slotRun();
    void slotRunDesktopFile(const QString& url);
    void slotShowPropertiesDialog();
    void slotShowSharingDialog();
    void slotShowConfigDialog();
    void slotGotPreview();
    void slotCreatePreview(bool toggled);
    void slotSetPreview(const KFileItem*, const QPixmap&);
    void slotUpdateCurrentInfo(const QString&);
    void slotDeleteCurrentInfo(const QString&);
    void slotPopupInfo();
    void slotShowMore();
    void slotShowMoreActions();
    void loadConfig();
    void openURL(const QString &url);
    void openTab(const QString &url);
    void callAction(const QString &action);
    
    void startPlayer();
    void pausePlayer();
    void stopPlayer();
    void seekPlayer(int);
    void updatePlayerStatus();
  
  private:
    KConfig *config;
    KConfig *iconConfig;
    
    KURLLabel *icon;
    QLabel *info_table;
    QLabel *preview;
    
    KFileItemList *currentItems;
    
    KURLLabel *show_more;
    KURLLabel *show_more_actions;
    
    ConfigDialog *config_dialog;
    
    KPushButton *config_button;
    KPushButton *player_start;
    KPushButton *player_pause;
    KPushButton *player_stop;
    
    KSqueezedTextLabel *name_label;
    KSqueezedTextLabel *type_label;

    KIO::PreviewJob *preview_job;
    KDirWatch *dir_watch;
    
    QFrame *top_frame;
    QFrame *player_frame;

    MetaFrame *action_frame;
    MetaFrame *open_frame;
    MetaFrame *info_frame;
    MetaFrame *preview_frame;
    MetaFrame *link_frame;
    MetaFrame *disk_frame;
    
    QMap<int,KService::Ptr> runlist;
    QPtrList<QWidget> actionList;
    QPtrList<QWidget> openList;
    QPtrList<QWidget> linkList;
    QPtrList<KURLLabel> infoList;
    QDict<QProgressBar> discDict;
    QDict<QLabel> infoDict;
    
    KArtsDispatcher *dispatcher;
    KVideoWidget *video;
    KDE::PlayObject *playobj;
    Arts::SoundServerV2 soundServer;
    KDE::PlayObjectFactory *factory;
    
    QSlider *player_status;
    QTimer *player_timer;
    QWidgetStack *preview_stack;
    
    ServiceLoader *serviceLoader;
    
    bool isVideo;
    bool actionsLoaded;
    
    void updateSingleInfo(const KFileItem &item);
    void updateMultiInfo(const KFileItemList &items);
    void killJobs();
    void deletePlayer();
    void loadLinkList();
    void loadActionList();
    void adjustFrameSizes();
    QString getCurrentFolder();
};

#endif
