/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef BufrExaminer_H
#define BufrExaminer_H

#include "MvQAbstractMessageExaminer.h"

class QComboBox;
class QLabel;
class QSpinBox;
class QSplitter;
class QStackedLayout;
class QTabWidget;
class QTextBrowser;
class QToolButton;
class QTreeView;
class QVBoxLayout;

class MvQBufrBitmapDumpModel;
class MvQBufrSectionDumpModel;
class MvQBufrDataDumpModel;
class MvQBufrDumpSortFilterModel;
class MvQTreeViewSearchLine;
class MvQTreeView;

class BufrExaminer : public MvQAbstractMessageExaminer
{
    Q_OBJECT

public:
    	BufrExaminer(QWidget *parent = 0);
    	~BufrExaminer();
	
public slots:
	void slotMessageSpinChanged(int);
	void slotSubsetSpinChanged(int);
	void slotShowAboutBox();
	void slotCurrentDumpChanged(int);
	void slotStatusMessage(QString);
	
protected:
	void closeEvent(QCloseEvent *);
  
private:
	void setupGotoPanel();
	void setupDumpBox();
 
	void initDumps();
	void initAllKeys();

	void loadKeyProfile(MvKeyProfile *);

	void loadDumps();
	void loadSectionDump();
	void loadDataDump();
	void loadBitmapDump();
	
	void updateFileInfoLabel();
	
	void writeSettings();
	void readSettings();
	
	QSplitter*   centralSplitter_;
	QSplitter*   mainSplitter_;
	QLabel *statusMessageLabel_;
	
	QTabWidget*    dumpTab_;	
	
	QTreeView*     sectionDumpTree_;
	MvQBufrSectionDumpModel* sectionDumpModel_;
	MvQTreeViewSearchLine* sectionDumpSearch_;

	QTreeView*     dataDumpTree_;
	MvQBufrDataDumpModel* dataDumpModel_;
	MvQTreeViewSearchLine* dataDumpSearch_;

	QTreeView*     bitmapDumpTree_;
	MvQBufrBitmapDumpModel* bitmapDumpModel_;
	MvQTreeViewSearchLine* bitmapDumpSearch_;

	QSpinBox *messageSpin_;
	QSpinBox *subsetSpin_;
	QLabel *subsetLabel_;
	MvQTreeViewSearchLine* messageSearch_;

	bool ignoreMessageSpinChangeSignal_;
	bool ignoreSubsetSpinChangeSignal_;
	bool messageCanBeDecoded_;
	
	QWidget* gotoPanel_;
};

#endif

