/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef ColorName_H
#include "ColorName.h"
#endif

#ifndef XMLabel_H
#include "XMLabel.h"
#endif

#ifndef XPalette_H
#include "XPalette.h"
#endif

#ifndef ColourEditor_H
#include "ColourEditor.h"
#endif

#ifndef XMString_H
#include "XMString.h"
#endif


ColorName::ColorName(ColourEditor& owner,const string& name):
	owner_(owner),
	magics_(name)
{
	create(owner.where());
	XMLabel label(name_);
	label.set(name);

	if(name == "BACKGROUND") // Ugly IF !!!!
	{
		XMString xm("None");
		XtVaSetValues(colour_,
			XmNlabelString,
			XmString(xm),
			XmNlabelType,XmSTRING,
			0);
	}
	else
		XtVaSetValues(colour_,
			XmNbackground,
			XPalette::magics(name),
			0);
		

	Manage();
}

ColorName::~ColorName()
{
}

void ColorName::activateCB(Widget,XtPointer)
{
	owner_.magics(magics_);
}
