/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#include <string>
using std::string;

#include "ConfigLoader.h"
#include "IconClass.h"
#include "IconInfo.h"
#include "Basic.h"


typedef multimap<pair<string,int>,ConfigLoader*> Map;

static Map* makers = 0;

ConfigLoader::ConfigLoader(const string& name,int order)
{
	if(makers == 0)
		makers = new Map();

	pair<string,int> p(name,order);
	makers->insert(Map::value_type(p,this));
}

ConfigLoader::~ConfigLoader()
{
	// Not called
}

bool ConfigLoader::process(request *r,int order)
{
	pair<string,int> a(r->name,order);
	pair<Map::iterator,Map::iterator> p = makers->equal_range(a);

	for(Map::iterator j = p.first; j != p.second; ++j)
		(*j).second->load(r);

	return p.first != p.second;
}	
