/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

// File ReplyObserver.h
// Baudouin Raoult - ECMWF Aug 99

#ifndef ReplyObserver_H
#define ReplyObserver_H

// Headers
// #ifndef   machine_H
// #include <machine.h>
// #endif

// Forward declarations

// class ostream;
// typedef class _Pvts os_typespec; // Remove if not persistant

// 


#include <string>
using std::string;


#ifndef Counted_H
#include "Counted.h"
#endif


class Request;

class ReplyObserver : public virtual Counted  {
public:

// -- Exceptions
	// None

// -- Contructors

	ReplyObserver();

// -- Destructor

	virtual ~ReplyObserver(); // Change to virtual if base class

// -- Convertors
	// None

// -- Operators
	// None

// -- Methods

	virtual void reply(const Request&,int) = 0;
	virtual void progress(const Request&) = 0;
	virtual void message(const string&) = 0;

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

	// Uncomment for persistent, remove otherwise
	// static os_typespec* get_os_typespec();

protected:

// -- Members
	// None

// -- Methods
	
	void callService(const string&,const Request&);
	// void print(ostream&) const; // Change to virtual if base class	

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

private:

// No copy allowed

	ReplyObserver(const ReplyObserver&);
	ReplyObserver& operator=(const ReplyObserver&);

// -- Members
	// None

// -- Methods
	// None

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

// -- Friends

	//friend ostream& operator<<(ostream& s,const ReplyObserver& p)
	//	{ p.print(s); return s; }

};


class ReplyObserverH : public Handle<ReplyObserver> {
public:
	ReplyObserverH(ReplyObserver* o) : Handle<ReplyObserver>(o) {}
};

#endif
