/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#include "inc_stl.h"
#include "Runnable.h"
#include "Metview.h"
#include <MvXApplication.h>

typedef set<Runnable*> Set;
static Set runnables;

/* do a process in the "background" */

Boolean Runnable::workCB(XtPointer)
{
	// Copy as Runnable may be removed

	Set s = runnables;
	int active = 0;

	for(Set::iterator j = s.begin(); j != s.end(); ++j)
	{
		if((*j)->actived_)
		{
			active++;
			(*j)->run();
		}
	}

    return (active == 0);
}

Runnable::Runnable():
	actived_(False)
{
	runnables.insert(this);
}

Runnable::~Runnable()
{
	runnables.erase(this);
}

void Runnable::enable()
{
	if(actived_) return;
	XtAppAddWorkProc(MvXApplication::context(),workCB,NULL);
	actived_ = True;
}


void Runnable::disable()
{
	actived_ = False;
}
