/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef StationaryDrawers_H
#include "StationaryDrawers.h"
#endif

#ifndef ConfigLoader_H
#include "ConfigLoader.h"
#endif

#ifndef IconClass_H
#include "IconClass.h"
#endif

#ifndef SyncFolders_H
#include "SyncFolders.h"
#endif


StationaryDrawers::StationaryDrawers():
	FolderDrawers(Folder::folder("stationary"))
{
	// Synchronize those two folders

	SyncFolders::add(
	
		  Folder::folder("stationary"),
		  Folder::folder("system_stationary",false)
	
	);
}

StationaryDrawers::~StationaryDrawers()
{
}

bool StationaryDrawers::fill(int pass)
{
	switch(pass)
	{
		case 0:
			// Try first system stationary
			SyncFolders::sync(folder_,Folder::folder("system_stationary"));
			return true;

		case 1:
			// Create a sub-folder
			Folder::folder("stationary",string("Drawers"));
			return true;

		default:
			return false;
	}
}

void StationaryDrawers::load(request* r)
{
	const char* kind = get_value(r,"class",0);
	const char* name = get_value(r,"default_name",0);
	const char* box;

	if(!kind || !name) return;

	int i = 0;
	while(box = get_value(r,"icon_box",i++))
	{
		Folder *f = Folder::folder("stationary",string(box));
		IconClass::find(kind).createOne(f);
	}
}

// static SimpleLoader<StationaryDrawers> loader("object",1);
