/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef Temporary_H
#include "Temporary.h"
#endif

#ifndef IconFactory_H
#include "IconFactory.h"
#endif

#ifndef Request_H
#include "Request.h"
#endif

#ifndef Language_H
#include "Language.h"
#endif

#ifndef IconClass_H
#include "IconClass.h"
#endif

#include "Dependancy.h"

#include "mars.h"

static string next_name()
{
	static int i = 0;
	char buf[80];
	sprintf(buf,"Temp%04d",i++);
	return buf;
}

Temporary::Temporary(IconObject* ref,const Request& r,const IconClass* c):
	IconObject(0,c ? *c : IconClass::find(r.getVerb()),next_name(),0),
	ref_(ref), request_(r)
{
	cout << "-->  Temporary::Temporary() for" << *ref_ << endl;
	r.print();
	cout << "<--  Temporary::Temporary() for" << *ref_ << endl;
}

Temporary::~Temporary()
{
	cout << "Temporary::~Temporary() for " << *ref_ << endl;
}

Folder* Temporary::parent() const
{
	return ref_->parent();
}

void Temporary::createFiles()
{
}

Request Temporary::request() const
{
	request_.print();
	return request_;
}

void Temporary::request(const Request& r)
{
	request_ = r;
}

Path Temporary::pathForShellTask() const
{
    const char* path = request_("PATH");
    if ( path ) {
        const char* path = request_("PATH");
        return string(path);
    }
	return string("/dev/null");
}

Path Temporary::path() const
{
	return string("/dev/null");
}


Path Temporary::dotPath() const
{
	return string("/dev/null");
}

Path Temporary::embeddedPath() const
{
	return string("/dev/null");
}

string Temporary::fullName() const
{
	return ref_->fullName() + "/" + name();
}
string Temporary::relativeName(IconObject* other) const
{
	return ref_->relativeName(other);
}

string Temporary::makeFullName(const string& name) const
{
	return ref_->makeFullName(name);
}

Folder* Temporary::embeddedFolder(const string& n,bool create) const
{
	return ref_->embeddedFolder(n,create);
}

Folder* Temporary::embeddedFolder(bool create) const
{
	return ref_->embeddedFolder(create);
}

Log& Temporary::log()
{
	return ref_->log();
}

bool Temporary::rename(const string& s)
{
	name_ = s;
	return true;
}

bool Temporary::renamable() const
{
	return true;
}

bool Temporary::temporary() const
{
	return true;
}

