/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#include <QDebug>

#include "MvQLayerContentsIcon.h"

#include "MvQApplication.h"

#include "MvPath.hpp"
#include "GenAppService.hpp"
#include "ObjectList.h"

#include "uPlotBase.h"

#include "MgQSceneItem.h"

MvQLayerContentsIcon::MvQLayerContentsIcon(const MgQIcon &icon) : 
                   canBeDeleted_(false), canBeEdited_(false), canBeSaved_(false), isData_(false)		
{	
  	path_=icon.name_;
	type_=icon.class_;
	id_=icon.id_;
  
	QStringList lst=icon.name_.split("/");
	if(!lst.isEmpty())
	{
		name_=lst.last();
	}
	
	Cached n(type_.toStdString().c_str());	
	MvRequest r=ObjectList::Find("object",n);
	
	const char* pixmap=r("pixmap");
	
	if(pixmap)
		pix_=QPixmap::fromImage(QImage(pixmap,"xpm")).scaled(QSize(24,24),Qt::KeepAspectRatio,Qt::SmoothTransformation);
	  
	//Cached iconFileName = MakeIconPath(type_.toStdString().c_str());
	//qDebug() <<  "icon" << (const char*)iconFileName;
	//pix_=QPixmap::fromImage(QImage((const char*)iconFileName,"xpm")).scaled(QSize(24,24),Qt::KeepAspectRatio,Qt::SmoothTransformation);				 
	Cached verb(type_.toStdString().c_str());

	canBeDeleted_ = false;
	canBeEdited_  = false;
	canBeSaved_   = false;
	
	if(ObjectList::IsDataUnit(verb))
	{
		canBeDeleted_ = true;
		canBeEdited_  = false;
		canBeSaved_   = false;
	}
	else if( ObjectList::IsVisDef(verb)) // || 
//		 ObjectList::IsPText(verb)  )
	{
		canBeDeleted_ = true;
		canBeEdited_   = true;
		canBeSaved_   = true;
	}
	else if(ObjectList::IsView(verb))
	{
		canBeDeleted_ = false;
		canBeEdited_   = true;
		canBeSaved_   = true;
	}
	else
	{
		canBeDeleted_ = false;
		canBeEdited_   = false;
		canBeSaved_   = false;
	}
	
	if(ObjectList::IsDataUnit(verb))
		isData_=true;  	
	
	
	//Check if it is a default icon
	//int idefault = icon_.Request()("_DEFAULT");
	//if (idefault) canBeSaved_ = false;
}


void  MvQLayerContentsIcon::startEditor()
{
	if(!canBeEdited_)
	  	return;
		
	// I need to be edited by MetviewUI
	// Retrieve my Request
	//MvRequest iconRequest = icon_.Request();

	MvRequest req;
	req.read(MakeUserPath(path_.toStdString().c_str()).c_str());

	//cout << "ContentsItem::Edit " << endl;
	req.print();

	// editor will commit suicide
	//ContentsItemEditor* editor = new ContentsItemEditor(MakeName());

	// Ask GenApp to edit my request
	//CallGenAppService(*editor,&MvQLayerContentsWidget::iconEdited,iconRequest);
	
	CallGenAppService(*this,&MvQLayerContentsIcon::edited,req);

}

void MvQLayerContentsIcon::edited(MvRequest& newIconRequest)
{
	// Nothing to be edited. Button CANCEL selected by user.
	if(!newIconRequest) return;

	newIconRequest.print();
	newIconRequest ("_CONTENTS_ICON_EDITED") = id_.toInt();
	newIconRequest ("ICON_ID") = id_.toInt();

	// Retrieve the correct name and other parameters
	newIconRequest("_NAME")  = name_.toStdString().c_str();
	
	// Flag indicating that data was edited from Contents window	

	// Create a new drop request

	newIconRequest("DROP_ID")   = 2;
	newIconRequest("_CONTENTS") = 1;
	newIconRequest("_ACTION") = "EDIT";
	
	
	//!!!!!!!!!!!!!!
	//We would need signals and slots here!!!
	//uPlotBase::Instance().processContentsRequest(newIconRequest);
	
	
	
	
	//MvQApplication::instance()->processDropRequest(&dropRequest);
	
	//MvApplication::callService ("uPlot", dropRequest, 0 );
}
	
	
	