/* Copyright 2005 Matt Flax <flatmax@ieee.org>
   This file is part of MFFM GTK wrapper class set

   MFFM GTK wrapper class set is free software; you can redistribute
   it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   MFFM GTK wrapper class set is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You have received a copy of the GNU General Public License
   along with MFFM GTK wrapper class set
 */
#ifndef LABELS_H_
#define LABELS_H_

#include <iomanip>
#include <gtk/gtk.h>
#include <mffm/LinkList.H>

class Labels : public LinkList<GtkWidget *> {
public:
  Labels& operator <<(const char *str) {
    LinkList<GtkWidget *>::add(gtk_label_new(str));
    gtk_misc_set_alignment (GTK_MISC (current()), 0, 0);
    gtk_widget_show (current());
    return *this;
  }

#ifdef DEBUG
  ~Labels(void){cout<<"Labels::~Labels"<<endl;}
#endif
};
#endif //LABELS_H_
