;;; mh-xemacs.el --- XEmacs MH-E support

;; Copyright (C) 2001, 2002, 2003, 2004, 2005,
;;   2006 Free Software Foundation, Inc.

;; Author: FSF and others (see below)
;; Maintainer: Bill Wohler <wohler@newt.com>
;; Keywords: mail
;; See: mh-e.el

;; This file is part of GNU Emacs.

;; GNU Emacs is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; GNU Emacs is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;;; Commentary:

;;; Change Log:

;;; Code:

(eval-when-compile
  (if (fboundp 'define-behavior)
      (define-behavior 'mh
        "Emacs interface to the MH mail system.
MH is the Rand Mail Handler. Other implementations include nmh
and GNU mailutils."
        :short-doc "Emacs interface to the MH mail system"
        :group 'internet
        :commands
        '(["Read Mail (MH-E)..." (mh-rmail t)]))))



;;; Set up the modeline glyph

(defconst mh-modeline-logo
  "/* XPM */
static char * file[] = {
\"18 13 2 1\",
\"# c #666699\",
\". c None s None\",
\"........##........\",
\".......####.......\",
\"......######......\",
\"......######......\",
\"....#########.....\",
\"..##############..\",
\".##...######....#.\",
\"##...#.#.####...#.\",
\"....#..#.##.#...#.\",
\"...#..##.#.#.#....\",
\"...#..#..#..#.#...\",
\"...#..#.##..#.##..\",
\"...#..#.#..#....#.\"};"
  "The image for the modeline logo.")

(defvar mh-modeline-glyph
  (progn
    (let* ((data mh-modeline-logo)
           (glyph (make-glyph
                   (cond ((and (featurep 'xpm)
                               (device-on-window-system-p)
                               has-modeline-p)
                          `[xpm :data ,data])
                         (t [string :data "MH-E"])))))
      (set-glyph-face glyph 'modeline-buffer-id)
      glyph))
  "Cute little logo to put in the modeline of MH-E buffers.")



;;  This section contains the tool bar icons that MH-E uses under XEmacs. Some
;;  icons were originally created for MH-E but all are now in etc/images. The
;;  XPM files are copied into defconst's and the background color is changed.
;;  These icons are then added to the association list mh-xemacs-icon-map.

(defconst mh-xemacs-has-tool-bar-flag
  (and (featurep 'toolbar)
       (featurep 'xpm)
       (device-on-window-system-p)
       (boundp 'default-toolbar-visible-p)
       (fboundp 'toolbar-make-button-list))
  "Non-nil means that XEmacs has tool bar support.")

(defvar mh-xemacs-icon-map nil
  "Map of GNU Emacs icon file names to XEmacs image constants.")



;;; Tool bar icons.

;; Derived from etc/images/attach.pbm
(defconst mh-xemacs-attach-icon
  (if mh-xemacs-has-tool-bar-flag
      (toolbar-make-button-list
       "/* XPM */
static char * file[] = {
\"24 24 2 1\",
\". c Gray75 s backgroundToolBarColor\",
\"  c black\",
/* pixels */
\"........................\",
\"........................\",
\"........................\",
\"...........  ...........\",
\".......... .. ..........\",
\"......... .... .........\",
\"......... .... .........\",
\"......... .... .........\",
\"......... . .. .........\",
\"......... . .. .........\",
\"......... . .. . .......\",
\"......... . .. . .......\",
\"......... . .. . .......\",
\"......... . .. . .......\",
\"......... . .. . .......\",
\"......... . .. . .......\",
\"......... . .. . .......\",
\"......... ..  .. .......\",
\".......... .... ........\",
\"........... .. .........\",
\"............  ..........\",
\"........................\",
\"........................\",
\"........................\"};")
    nil)
  "*MH attach icon.")

(push '(attach . mh-xemacs-attach-icon) mh-xemacs-icon-map)

;; Derived from etc/images/close.xpm
(defconst mh-xemacs-close-icon
  (if mh-xemacs-has-tool-bar-flag
      (toolbar-make-button-list
       "/* XPM */
static char *magick[] = {
/* columns rows colors chars-per-pixel */
\"24 24 2 1\",
\"  c Gray0\",
\". c Gray75 s backgroundToolBarColor\",
/* pixels */
\"........................\",
\"........................\",
\"........................\",
\"........................\",
\"........................\",
\"........................\",
\"....... ....  ..........\",
\".......  ..    .........\",
\"........  .   ..........\",
\"........     ...........\",
\".........   ............\",
\".........    ...........\",
\"........      ..........\",
\"........  .    .........\",
\".......  ...    ........\",
\"....... .....  .........\",
\"........................\",
\"........................\",
\"........................\",
\"........................\",
\"........................\",
\"........................\",
\"........................\",
\"........................\"};")
    nil)
  "MH close icon.")

(push '(close . mh-xemacs-close-icon) mh-xemacs-icon-map)

;; Derived from etc/images/copy.xpm
(defconst mh-xemacs-copy-icon
  (if mh-xemacs-has-tool-bar-flag
      (toolbar-make-button-list
       "/* XPM */
static char *magick[] = {
/* columns rows colors chars-per-pixel */
\"24 24 7 1\",
\"  c Gray0\",
\". c #424242423a3a\",
\"X c #68e968e96363\",
\"o c #a8b1a8b1992b\",
\"O c #d3d3d3d3bdbd\",
\"+ c #e419e419cd6b\",
\"@ c Gray75 s backgroundToolBarColor\",
/* pixels */
\"@@@@@@@@@@@@@@@@@@@@@@@@\",
\"@@@@@@@@@@@@@@@@@@@@@@@@\",
\"@@@@@@@@@@@@@@@@@@@@@@@@\",
\"@@@@@@@@@@@@@@@@@@@@@@@@\",
\"@@@@@@@@@@@@@@@@@@@@@@@@\",
\"@@@@@@@@  @@@@@@@@@@@@@@\",
\"@@@@@@  Oo @@@@@@@@@@@@@\",
\"@@@@ .ooOO @@@@  @@@@@@@\",
\"@@@@ +XoOOo @  Oo @@@@@@\",
\"@@@@ +.oO++ .ooOO @@@@@@\",
\"@@@@ XoO+++ +XoOOo @@@@@\",
\"@@@@ oOO+++ +.oO++ @@@@@\",
\"@@@@ oO++++ XoOO++o @@@@\",
\"@@@@@ +++++ oOO++++o @@@\",
\"@@@@@ o++++ oO++++++ @@@\",
\"@@@@@@ ++o   +++++++o @@\",
\"@@@@@@ o  @@ o++++o  @@@\",
\"@@@@@@@ @@@@@ ++o  @@@@@\",
\"@@@@@@@@@@ @@ o  @@@@@@@\",
\"@@@@@@@     @@ @@@@@@@@@\",
\"@@@@@@@     @@@@@@@@@@@@\",
\"@@@@@@@@@@ @@@@@@@@@@@@@\",
\"@@@@@@@@@@@@@@@@@@@@@@@@\",
\"@@@@@@@@@@@@@@@@@@@@@@@@\"};")
    nil)
  "MH copy icon.")

(push '(copy . mh-xemacs-copy-icon) mh-xemacs-icon-map)

;; Derived from etc/images/cut.xpm
(defconst mh-xemacs-cut-icon
  (if mh-xemacs-has-tool-bar-flag
      (toolbar-make-button-list
       "/* XPM */
static char *magick[] = {
/* columns rows colors chars-per-pixel */
\"24 24 2 1\",
\"  c Gray0\",
\". c Gray75 s backgroundToolBarColor\",
/* pixels */
\"........................\",
\"........................\",
\"........................\",
\"........................\",
\"........................\",
\".................. .....\",
\"................  ......\",
\"...............  .......\",
\"..............  ........\",
\".............  .........\",
\"....    ....  .....   ..\",
\"... ...  ..  ...    ....\",
\"... ...           ......\",
\"....    ...    .........\",
\"..........  ............\",
\".........   ............\",
\"........ .. ............\",
\"....... ... ............\",
\"....... .. .............\",
\".......   ..............\",
\"........................\",
\"........................\",
\"........................\",
\"........................\"};")
    nil)
  "MH cut icon.")

(push '(cut . mh-xemacs-kill-region-icon) mh-xemacs-icon-map)

;; Derived from mh-e/execute.xpm
(defconst mh-xemacs-execute-icon
  (if mh-xemacs-has-tool-bar-flag
      (toolbar-make-button-list
       "/* XPM */
static char * mail_exec_xpm[] = {
/* columns rows colors chars-per-pixel */
\"24 24 6 1\",
\" 	c Gray75 s backgroundToolBarColor\",
\".	c black\",
\"X	c #a5d8a5d89550\",
\"o	c #d305d305bc3c\",
\"O	c #ea03ea03d271\",
\"+	c white\",
/* pixels */
\"                        \",
\"                        \",
\"                        \",
\"                 ..     \",
\"             XX  ..     \",
\"         oo  XX  ..     \",
\"     OO  oo  XX  ..     \",
\"     OO  oo  XX  ..     \",
\"     OO  oo  XX  ..     \",
\"     OO  oo  XX  ..     \",
\"     OO  oo  XX  ..     \",
\"     OO  oo  XX  ..     \",
\"     OO  oo  XX  ..     \",
\"     OO  oo  XX         \",
\"     OO  oo             \",
\"     OO      +   ..     \",
\"             XX  ..     \",
\"         oo  XX         \",
\"     OO  oo             \",
\"     OO                 \",
\"                        \",
\"                        \",
\"                        \",
\"                        \"};")
    nil)
  "MH execute icon.")

(push '(execute . mh-xemacs-execute-icon) mh-xemacs-icon-map)

;; Derived from etc/images/fld-open.xpm
(defconst mh-xemacs-fld-open-icon
  (if mh-xemacs-has-tool-bar-flag
      (toolbar-make-button-list
       "/* XPM */
static char *magick[] = {
/* columns rows colors chars-per-pixel */
\"24 24 4 1\",
\"  c Gray0\",
\". c #909090909090\",
\"X c #fefefefefefe\",
\"o c Gray75 s backgroundToolBarColor\",
/* pixels */
\"oooooooooooooooooooooooo\",
\"oooooooooooooooooooooooo\",
\"oooooooooooooooooooooooo\",
\"oooooooooooooooooooooooo\",
\"oooooooooooooooooooooooo\",
\"oooooooooooooo  oooooooo\",
\"ooooooooooo   .. ooooooo\",
\"oooo  oo   ....XXo   ooo\",
\"ooo ..  ....XXXX  .. ooo\",
\"ooo .....XXXXX  .... ooo\",
\"oooo ..XXXXX  ...... ooo\",
\"oooo ..XXX  ........ ooo\",
\"ooooo .XX .......... ooo\",
\"ooooo ..X .......... ooo\",
\"oooooo .X .......... ooo\",
\"oooooo .. ........  oooo\",
\"ooooooo . ......  oooooo\",
\"ooooooo . ..... oooooooo\",
\"oooooooo  ...  ooooooooo\",
\"oooooooo  .  ooooooooooo\",
\"ooooooooo  ooooooooooooo\",
\"oooooooooooooooooooooooo\",
\"oooooooooooooooooooooooo\",
\"oooooooooooooooooooooooo\"};")
    nil)
  "MH fld-open icon.")

(push '(fld-open . mh-xemacs-visit-folder-icon) mh-xemacs-icon-map)

;; Derived from etc/images/help.xpm
(defconst mh-xemacs-help-icon
  (if mh-xemacs-has-tool-bar-flag
      (toolbar-make-button-list
       "/* XPM */
static char *magick[] = {
/* columns rows colors chars-per-pixel */
\"24 24 6 1\",
\"  c Gray0\",
\". c #65658b8b5e5e\",
\"X c #934ab2448dfb\",
\"o c #b35dc8c8afaf\",
\"O c #e0b2e944df83\",
\"+ c Gray75 s backgroundToolBarColor\",
/* pixels */
\"++++++++++++++++++++++++\",
\"++++++++++++++++++++++++\",
\"++++++++++++++++++++++++\",
\"++++++++++++++++++++++++\",
\"+++++++++     ++++++++++\",
\"++++++++ oOOOO +++++++++\",
\"+++++++ OOOOOOO ++++++++\",
\"++++++ oOo   oOo +++++++\",
\"+++++++ O +++ OO +++++++\",
\"+++++++O ++++ Oo +++++++\",
\"++++++++++++ OO. +++++++\",
\"+++++++++++ OOX ++++++++\",
\"++++++++++ OOX +++++++++\",
\"+++++++++ XOX ++++++++++\",
\"+++++++++ OX +++++++++++\",
\"+++++++++    +++++++++++\",
\"++++++++++++++++++++++++\",
\"++++++++++  ++++++++++++\",
\"+++++++++ Oo +++++++++++\",
\"+++++++++ oX +++++++++++\",
\"++++++++++  ++++++++++++\",
\"++++++++++++++++++++++++\",
\"++++++++++++++++++++++++\",
\"++++++++++++++++++++++++\"};")
    nil)
  "MH help icon.")

(push '(help . mh-xemacs-help-icon) mh-xemacs-icon-map)

;; Derived from mh-e/highlight.xpm
(defconst mh-xemacs-highlight-icon
  (if mh-xemacs-has-tool-bar-flag
      (toolbar-make-button-list
       "/* XPM */
static char * highlight_xpm[] = {
/* columns rows colors chars-per-pixel */
\"24 24 4 1\",
\" 	c Gray75 s backgroundToolBarColor\",
\".	c black\",
\"X	c #828282827474\",
\"o	c #dd00df007e00\",
/* pixels */
\"                 .....  \",
\"                ..XXX.. \",
\"                .XXXXX. \",
\"               .XXXXX.. \",
\"               .XXXXX.  \",
\"               .XXXXX.  \",
\"              .XXXXX.   \",
\"              .ooXX.    \",
\"              ..ooo.    \",
\"       oooo     ....    \",
\"oo.ooo....oo ...        \",
\"o.o.ooo.oo.o.ooo.o      \",
\".ooo.oo.oo.o.ooooo      \",
\".ooo.oo.oo.o.ooooo      \",
\".ooo.oo...oo.ooooo      \",
\".....oo.oo.o.ooooo      \",
\".ooo.oo.oo.o.ooooo      \",
\".ooo.oo.oo.o.ooo.o      \",
\". oo.o....ooo...o       \",
\"         oo oooo        \",
\"                        \",
\"                        \",
\"                        \",
\"                        \"};")
    nil)
  "MH highlight icon.")

(push '(highlight . mh-xemacs-highlight-icon) mh-xemacs-icon-map)

;; Derived from etc/images/left-arrow.xpm
(defconst mh-xemacs-left-arrow-icon
  (if mh-xemacs-has-tool-bar-flag
      (toolbar-make-button-list
       "/* XPM */
static char * left_arrow_xpm[] = {
\"24 24 9 1\",
\" 	c Gray75 s backgroundToolBarColor\",
\".	c #020202\",
\"+	c #121A12\",
\"@	c #78A16E\",
\"#	c #86AD7D\",
\"$	c #B2C6AE\",
\"%	c #263222\",
\"&	c #E7EDE6\",
\"*	c #497241\",
\"                        \",
\"                        \",
\"                        \",
\"                        \",
\"                        \",
\"                ..      \",
\"              ..$.      \",
\"            ..&&$.      \",
\"          ..&&&&$.      \",
\"        ..&&&&&&$.      \",
\"      .+&&&&&&&&$.      \",
\"    ..$&&&&&&&&&$%      \",
\"    ..**@@@#####@.      \",
\"      ..**@#@###@.      \",
\"        ..**@#@#@.      \",
\"          ..**@@@.      \",
\"            ..*@*.      \",
\"              ..*.      \",
\"                ..      \",
\"                        \",
\"                        \",
\"                        \",
\"                        \",
\"                        \"};")
    nil)
  "MH left arrow icon.")

(push '(left-arrow . mh-xemacs-left-arrow-icon) mh-xemacs-icon-map)

;; Derived from etc/images/mail.xpm
(defconst mh-xemacs-mail-icon
  (if mh-xemacs-has-tool-bar-flag
      (toolbar-make-button-list
       "/* XPM */
static char *magick[] = {
/* columns rows colors chars-per-pixel */
\"24 24 5 1\",
\"  c Gray0\",
\". c #673e666663d4\",
\"X c #a852a7bea3d2\",
\"o c #eb46ea1de471\",
\"O c Gray75 s backgroundToolBarColor\",
/* pixels */
\"OOOOOOOOOOOOOOOOOOOOOOOO\",
\"OOOOOOOOOOOOOOOOOOOOOOOO\",
\"OOOOOOOOOOOOOOOOOOOOOOOO\",
\"OOOOOOOOOOOOOOOOOOOOOOOO\",
\"OOOOOOOOOOOOOOOOOOOOOOOO\",
\"OOOOOOOOOOOOOO    OOOOOO\",
\"OOOOOOOOO     .ooX OOOOO\",
\"OOOO     .XooooooX OOOOO\",
\"OOO .Xoooooooooo.XX OOOO\",
\"OOO o..ooooooooX.Xo OOOO\",
\"OOO XoX..oooooo.Xoo OOOO\",
\"OOOO oooXX.Xoo...ooX OOO\",
\"OOOO oooooXX..XoX.Xo OOO\",
\"OOOO Xoooo.ooooooo.X OOO\",
\"OOOOO oooXXoooooooo.X OO\",
\"OOOOO ooo.oooooooooX  OO\",
\"OOOOO XoXXooooooX   OOOO\",
\"OOOOOO o.ooooX   OOOOOOO\",
\"OOOOOO .XoX   OOOOOOOOOO\",
\"OOOOOO ..  OOOOOOOOOOOOO\",
\"OOOOOOO  OOOOOOOOOOOOOOO\",
\"OOOOOOOOOOOOOOOOOOOOOOOO\",
\"OOOOOOOOOOOOOOOOOOOOOOOO\",
\"OOOOOOOOOOOOOOOOOOOOOOOO\"};")
    nil)
  "*MH mail icon.")

(push '(mail . mh-xemacs-mail-icon) mh-xemacs-icon-map)

;; Derived from etc/images/mail/alias.xpm
(defconst mh-xemacs-mail-alias-icon
  (if mh-xemacs-has-tool-bar-flag
      (toolbar-make-button-list
       "/* XPM */
static char * alias_xpm[] = {
/* columns rows colors chars-per-pixel */
\"24 24 4 1\",
\" 	c Gray75 s backgroundToolBarColor\",
\".	c #61b761b7600a\",
\"X	c #a5d8a5d89550\",
\"o	c black\",
/* pixels */
\"                        \",
\"                        \",
\"                        \",
\"     ......             \",
\"   ...XXXX..XX          \",
\"  o..ooooooo...         \",
\" ooo      oooo..X       \",
\" o.X        ooo...      \",
\" o.X          ooo.XX    \",
\" o.X            oo..    \",
\" o.X             oo.    \",
\" o...            oo..   \",
\"  o.X             o..   \",
\"  o.XX            oX.   \",
\"   o....          oo.   \",
\"    o..XX        oooo   \",
\"     o...XXX   XXoooo   \",
\"      ooo........ooooo  \",
\"        oooooXXooooo.oo \",
\"            ooo    o..oo\",
\"                    o...\",
\"                     ooo\",
\"                      oo\",
\"                        \"};")
    nil)
  "MH mail/alias icon.")

(push '(mail/alias . mh-xemacs-mail-alias-icon) mh-xemacs-icon-map)

;; Derived from etc/images/mail/send.xpm
(defconst mh-xemacs-mail-compose-icon
  (if mh-xemacs-has-tool-bar-flag
      (toolbar-make-button-list
       "/* XPM */
static char *magick[] = {
/* columns rows colors chars-per-pixel */
\"24 24 9 1\",
\"  c Gray0\",
\". c #757560602020\",
\"X c #6711662663d9\",
\"o c #8e8e7d7d4545\",
\"O c #adad8e8e3030\",
\"+ c #d8d8bebe6a6a\",
\"@ c #a8fba84da483\",
\"# c #eb79ea70e4f4\",
\"$ c Gray75 s backgroundToolBarColor\",
/* pixels */
\"$$$$$$$$$$$$$$$$$$$$$$$$\",
\"$$$$$$$$$$$$$$$$$$$$$$$$\",
\"$$$$$$$$$$$$$    $$$$$$$\",
\"$$$$$$$$     X##@ $$$$$$\",
\"$$$     X@######@ $$$$$$\",
\"$$ X@##########X@@ $$$$$\",
\"$$ #XX########@X@# $$$$$\",
\"$$ @#@XX######X@## $$$$$\",
\"$$$ ###@@X@##XXX##@ $ $$\",
\"$$$ #####@@XX@#@X@#  + $\",
\"$$$ @####X#######X@ +o $\",
\"$$$$ ###@@######## +o $$\",
\"$$$$ ###X######## +o $$$\",
\"$$$$ @#@@######@ +o $$$$\",
\"$$$$$ #X####@   +o $$$$$\",
\"$$$$$ X@#@   $ +o $$$$$$\",
\"$$$$$ XX  $$$ +o $$$$$$$\",
\"$$$$$$  $$$$ +o $$$$$$$$\",
\"$$$$$$$$$$$O.  $$$$$$$$$\",
\"$$$$$$$$$$$  $$$$$$$$$$$\",
\"$$$$$$$$$$$$$$$$$$$$$$$$\",
\"$$$$$$$$$$$$$$$$$$$$$$$$\",
\"$$$$$$$$$$$$$$$$$$$$$$$$\",
\"$$$$$$$$$$$$$$$$$$$$$$$$\"};")
    nil)
  "MH mail/compose icon.")

(push '(mail/compose . mh-xemacs-mail-compose-icon) mh-xemacs-icon-map)

;; Derived from etc/images/mail/refile.xpm
(defconst mh-xemacs-mail-refile-icon
  (if mh-xemacs-has-tool-bar-flag
      (toolbar-make-button-list
       "/* XPM */
static char * refile_xpm[] = {
/* columns rows colors chars-per-pixel */
\"24 24 7 1\",
\" 	c Gray75 s backgroundToolBarColor\",
\".	c black\",
\"X	c #a5d8a5d89550\",
\"o	c #d305d305bc3c\",
\"O	c #ea03ea03d271\",
\"+	c #828282827474\",
\"@	c #61b761b7600a\",
/* pixels */
\"             .          \",
\"           ..X.         \",
\"         ..XoO....      \",
\"       ..XooooO.+.      \",
\"     ..XooooooOX..  ..  \",
\"    .@@ooooooOOO@. ...  \",
\"    .O@oooooOOOOO..@@.  \",
\"    .OO@oooOOOOOO..@@.  \",
\"  ...OO@XooOOOOO...@@.  \",
\" ..+.O@XooOOOO..@@@@@.  \",
\" .++..XooOOOO..@@@@@@.  \",
\" .++.@oooOO...@@@@@@@.  \",
\" ..+.XooOOO..@@@@@@@.   \",
\"  .++.OOOO.@@@@@@@@.    \",
\"   .+.oOO..@@@@@@@.     \",
\"   .++.OO.@@@@@@@.      \",
\"    .++.O.@@@@@..       \",
\"    ..+.O.@@@@@.        \",
\"     .++..@@@@.         \",
\"     ..++.@@@.          \",
\"       .+.@@.           \",
\"       ...@.            \",
\"        ...             \",
\"         .              \"};")
    nil)
  "MH mail/refile icon.")

(push '(mail/refile . mh-xemacs-mail-refile-icon) mh-xemacs-icon-map)

;; Derived from etc/images/mail/repack.xpm
(defconst mh-xemacs-mail-repack-icon
  (if mh-xemacs-has-tool-bar-flag
      (toolbar-make-button-list
       "/* XPM */
static char * mail_repack_xpm[] = {
/* columns rows colors chars-per-pixel */
\"24 24 6 1\",
\" 	c Gray75 s backgroundToolBarColor\",
\".	c black\",
\"X	c #a5d8a5d89550\",
\"o	c #d305d305bc3c\",
\"O	c #ea03ea03d271\",
\"+	c #828282827474\",
/* pixels */
\"                        \",
\"                        \",
\"       ..............   \",
\"      .XXXXXXXXXXXX..   \",
\"     .XXXXXXXXXXXX.X.   \",
\"    .XXXXXXXXXXXX.oo.   \",
\"   ..............ooo.   \",
\"   .OOOOOOOOOOOO.oo.    \",
\"   .O++++++++++O.oo.    \",
\"   .O+XXXXXXXX+O.o.     \",
\"    .+XXXXXXXX+.o..     \",
\"    .+XX...XXX+....     \",
\"     ....o.......oo.    \",
\"     ....o.....Oooo.    \",
\"    .OOO...OOOO.oooo.   \",
\"    .++++++++++.oooo.   \",
\"    .+XXXXXXXX+.oooo.   \",
\"   .O+XXXXXXXX+O.ooX.   \",
\"   .O+XXXXXXXX+O.oo..   \",
\"   .O++++++++++O.o..    \",
\"  ..OOOOOOOOOOOO...     \",
\"  ................      \",
\"                        \",
\"                        \"};")
    nil)
  "MH mail/repack icon.")

(push '(mail/repack . mh-xemacs-mail-repack-icon) mh-xemacs-icon-map)

;; Derived from etc/images/mail/reply.xpm
(defconst mh-xemacs-mail-reply-icon
  (if mh-xemacs-has-tool-bar-flag
      (toolbar-make-button-list
       "/* XPM */
static char * mail_reply_xpm[] = {
/* columns rows colors chars-per-pixel */
\"24 24 9 1\",
\" 	c Gray75 s backgroundToolBarColor\",
\".	c black\",
\"X	c #673e666663d4\",
\"o	c #eb46ea1de471\",
\"O	c #a852a7bea3d2\",
\"+	c #ae51c17b9b26\",
\"@	c #8d4d97577838\",
\"#	c #7c7c8b8b6e6e\",
\"$	c #5e0868be52d3\",
/* pixels */
\"                        \",
\"                        \",
\"                        \",
\"                        \",
\"                        \",
\"              ....      \",
\"         .....XooO.     \",
\"    .....XOooooooO.     \",
\"   .XOooooooooooXOO.    \",
\"   .oXXooooooooOXOo.    \",
\"   .OoOXXooooooXOoo.    \",
\"    .oooOOXOooXXXooO.   \",
\"    ........XXOoOXOo.   \",
\"    ..++++@.ooooooXO.   \",
\"     ..+@@@.oooooooXO.  \",
\"    ..+@@@#.oooooooO..  \",
\"  ..++@@@#$.ooooO...    \",
\" .++++@@#.$.oO...       \",
\"  .+@@@#.o....          \",
\"   .+@#$...             \",
\"    .#$.                \",
\"     .$.                \",
\"      .                 \",
\"                        \"};")
    nil)
  "MH mail/reply icon.")

(push '(mail/reply . mh-xemacs-mail-reply-icon) mh-xemacs-icon-map)

;; Derived from etc/images/mail/reply-all.xpm
(defconst mh-xemacs-mail-reply-all-icon
  (if mh-xemacs-has-tool-bar-flag
      (toolbar-make-button-list
       "/* XPM */
static char * reply_all_xpm[] = {
/* columns rows colors chars-per-pixel */
\"24 24 9 1\",
\" 	c Gray75 s backgroundToolBarColor\",
\".	c black\",
\"X	c #673e666663d4\",
\"o	c #eb46ea1de471\",
\"O	c #a852a7bea3d2\",
\"+	c #ae51c17b9b26\",
\"@	c #8d4d97577838\",
\"#	c #7c7c8b8b6e6e\",
\"$	c #5e0868be52d3\",
/* pixels */
\"                        \",
\"                        \",
\"              ....      \",
\"         .....XooO.     \",
\"    .....XOooooooO.     \",
\"   .XOooooooooooXOO.    \",
\"   .oXXooooooooOXOo.    \",
\"   .OoOXXooooooXOoo.    \",
\"    .oooOOXOooXXXooO.   \",
\"    ........XXOoOXOo.   \",
\"    ..++++@.ooooooXO.   \",
\"     ..+@@@.oooooooXO.  \",
\"    ..+@@@#.oooooooO..  \",
\"  ..++@@@#$.ooooO...    \",
\" .++++@@#.$    ..       \",
\"  .+@@@#.o  ..   .O .O  \",
\"   .+@#$.   .O.  .O .O  \",
\"    .#$.   .O .o .O .O  \",
\"     .$.   .  .O .O .O  \",
\"      .    ....O .O .O  \",
\"           .O .O .O .O  \",
\"           .O .O .O .O  \",
\"           .O .O .O .O  \",
\"                        \"};")
    nil)
  "MH mail/reply-all icon.")

(push '(mail/reply-all . mh-xemacs-mail-reply-all-icon) mh-xemacs-icon-map)

;; Derived from etc/images/mail/reply-from.xpm
(defconst mh-xemacs-reply-from-icon
  (if mh-xemacs-has-tool-bar-flag
      (toolbar-make-button-list
       "/* XPM */
static char * reply_from_xpm[] = {
/* columns rows colors chars-per-pixel */
\"24 24 9 1\",
\" 	c Gray75 s backgroundToolBarColor\",
\".	c black\",
\"X	c #673e666663d4\",
\"o	c #eb46ea1de471\",
\"O	c #a852a7bea3d2\",
\"+	c #ae51c17b9b26\",
\"@	c #8d4d97577838\",
\"#	c #7c7c8b8b6e6e\",
\"$	c #5e0868be52d3\",
/* pixels */
\"                        \",
\"                        \",
\"              ....      \",
\"         .....XooO.     \",
\"    .....XOooooooO.     \",
\"   .XOooooooooooXOO.    \",
\"   .oXXooooooooOXOo.    \",
\"   .OoOXXooooooXOoo.    \",
\"    .oooOOXOooXXXooO.   \",
\"    ........XXOoOXOo.   \",
\"    ..++++@.ooooooXO.   \",
\"     ..+@@@.oooooooXO.  \",
\"    ..+@@@#.oooooooO..  \",
\"  ..++@@@#$.ooooO...    \",
\"        #.$.oO...       \",
\"   ...O . ....          \",
\"   ...O                 \",
\"   .O                   \",
\"   ...O ..O .... .O O.  \",
\"   ...O ..O .OO. .....  \",
\"   .O   .O  .  . . . .  \",
\"   .O   .O  .OO. . . .  \",
\"   .O   .O  .... . O .  \",
\"                        \"};")
    nil)
  "MH mail/reply-from icon.")

(push '(mail/reply-from . mh-xemacs-reply-from-icon) mh-xemacs-icon-map)

;; Derived from etc/images/mail/reply-to.xpm
(defconst mh-xemacs-reply-to-icon
  (if mh-xemacs-has-tool-bar-flag
      (toolbar-make-button-list
       "/* XPM */
static char * reply_to_xpm[] = {
/* columns rows colors chars-per-pixel */
\"24 24 9 1\",
\" 	c Gray75 s backgroundToolBarColor\",
\".	c black\",
\"X	c #673e666663d4\",
\"o	c #eb46ea1de471\",
\"O	c #a852a7bea3d2\",
\"+	c #ae51c17b9b26\",
\"@	c #8d4d97577838\",
\"#	c #7c7c8b8b6e6e\",
\"$	c #5e0868be52d3\",
/* pixels */
\"                        \",
\"                        \",
\"              ....      \",
\"         .....XooO.     \",
\"    .....XOooooooO.     \",
\"   .XOooooooooooXOO.    \",
\"   .oXXooooooooOXOo.    \",
\"   .OoOXXooooooXOoo.    \",
\"    .oooOOXOooXXXooO.   \",
\"    ........XXOoOXOo.   \",
\"    ..++++@.ooooooXO.   \",
\"     ..+@@@.oooooooXO.  \",
\"    ..+@@@#.oooooooO..  \",
\"  ..++@@@#$.ooooO...    \",
\" .++++@@#.$             \",
\"  .+@@@#.o  ......      \",
\"   .+@#$.   OO.OOO      \",
\"    .#$.      .O        \",
\"     .$.      .O  ....  \",
\"      .       .O  .OO.  \",
\"              .O  .  .  \",
\"              .O  .OO.  \",
\"              .O  ....  \",
\"                        \"};")
    nil)
  "MH mail/reply-to icon.")

(push '(mail/reply-to . mh-xemacs-reply-to-icon) mh-xemacs-icon-map)

;; Derived from etc/images/mail/send.xpm
(defconst mh-xemacs-mail-send-icon
  (if mh-xemacs-has-tool-bar-flag
      (toolbar-make-button-list
       "/* XPM */
static char *magick[] = {
/* columns rows colors chars-per-pixel */
\"24 24 9 1\",
\"  c Gray0\",
\". c #675e6580613e\",
\"X c #8c8c7c7c6969\",
\"o c #9b458d377822\",
\"O c #a941a6459f3e\",
\"+ c #c8c8b2b29898\",
\"@ c #dadac2c2a5a5\",
\"# c #eb4dea2fe4ad\",
\"$ c Gray75 s backgroundToolBarColor\",
/* pixels */
\"$$$$$$$$$$$$$$$$$$$$$$$$\",
\"$$$$$$$$$$$$$$$$$$$$$$$$\",
\"$$$$$$$$$$$$$    $$$$$$$\",
\"$$$$$$$$     .@#+ $$$$$$\",
\"$$$     .+#####@O $$$$$$\",
\"$$ .+##########.+O $$$$$\",
\"$$ @..########O.+# $$$$$\",
\"$$ O@O..@#####.+## $$$$$\",
\"$$$ ###+O.O##...##O $$$$\",
\"$$$ @####@+..O#O.+# $$$$\",
\"$$$ O####.#######.O $$$$\",
\"$$$$ ###+O########.O $$$\",
\"$$$$ ###.########@O  $$$\",
\"$$$$ +#+O#####@O   $$$$$\",
\"$$$$$ #.###@O     $$$$$$\",
\"$$$$$ .O@O   $$ .. $$$$$\",
\"$$$$$ ..  $$$$ .oo. $$$$\",
\"$$$$$$  $$$$$   oo   $$$\",
\"$$$$$$$$$$$$$$$ Oo $$$$$\",
\"$$$$$$$$$$$$$$ oOOX $$$$\",
\"$$$$$$$$$$$$$$ ++++ $$$$\",
\"$$$$$$$$$$$$$ O@@@@O $$$\",
\"$$$$$$$$$$$$$        $$$\",
\"$$$$$$$$$$$$$$$$$$$$$$$$\"};")
    nil)
  "MH mail/send icon.")

(push '(mail/send . mh-xemacs-mail-send-icon) mh-xemacs-icon-map)

;; Derived from etc/images/page-down.xpm
(defconst mh-xemacs-page-down-icon
  (if mh-xemacs-has-tool-bar-flag
      (toolbar-make-button-list
       "/* XPM */
static char * mail_page_xpm[] = {
/* columns rows colors chars-per-pixel */
\"24 24 5 1\",
\" 	c Gray75 s backgroundToolBarColor\",
\".	c black\",
\"X	c #ea03ea03d271\",
\"o	c #a5d8a5d89550\",
\"O	c #d305d305bc3c\",
/* pixels */
\"                        \",
\"                        \",
\"   ..................   \",
\"   .XXXXXXXXXXXXXXXX.   \",
\"   .XXXXXXXXXXXXXXXX.   \",
\"   .XoooooooooooooXX.   \",
\"   .XXXXXXXXXXXXXXXX.   \",
\"   .XXXXXXXXXXXXXXXX.   \",
\"   .Xoooooooooo..oXX.   \",
\"   .XXXXXXXXXXX..XXX.   \",
\"   .XXXXXXXXXXX..XXX.   \",
\"   .XooooooXXXX..XXX.   \",
\"   .XXXXXXXXXXX..XXX.   \",
\"   .XXXXXXXXX.O..O.X.   \",
\"   .Xoooooooo.....XX.   \",
\"   .XXXXXXXXXX....XX.   \",
\"   .XXXXXXXXXXX..XXX.   \",
\"   .XXXXXXXXXXXooXXX.   \",
\"   .XXXXXXXXXXXXXXXX.   \",
\"   .XXXXXXXXXXXXXXXX.   \",
\"   ..................   \",
\"                        \",
\"                        \",
\"                        \"};")
    nil)
  "MH page-down icon.")

(push '(page-down . mh-xemacs-page-down-icon) mh-xemacs-icon-map)

;; Derived from etc/images/paste.xpm
(defconst mh-xemacs-paste-icon
  (if mh-xemacs-has-tool-bar-flag
      (toolbar-make-button-list
       "/* XPM */
static char *magick[] = {
/* columns rows colors chars-per-pixel */
\"24 24 5 1\",
\"  c Gray0\",
\". c #62ee62ee62ee\",
\"X c Gray68\",
\"o c Gray82\",
\"O c Gray75 s backgroundToolBarColor\",
/* pixels */
\"OOOOOOOOOOOOOOOOOOOOOOOO\",
\"OOOOOOOOOOOOOOOOOOOOOOOO\",
\"OOOOOOOOOOOOOOOOOOOOOOOO\",
\"OOOOOOOOO   OOOOOOOOOOOO\",
\"OOOOOOO  ooo OOOOOO OOOO\",
\"OOOOO  ooooo OOO     OOO\",
\"OOO  oo. .Xoo OO     OOO\",
\"OO ooo.oX..oo OOOOO OOOO\",
\"OO ooo.X..oooo OOOOOOOOO\",
\"OOO oo..Xooooo O  OOOOOO\",
\"OOO oooooooooo  oX OOOOO\",
\"OOOO ooooooo  XXoo OOOOO\",
\"OOOO ooooooo o.XooX OOOO\",
\"OOOOO oooooo o.Xooo OOOO\",
\"OOOOO oooooo .XooooX OOO\",
\"OOOOOO ooooX XooooooX OO\",
\"OOOOOO XXOXX Xooooooo OO\",
\"OOOOOOO XXXX  oooooooX O\",
\"OOOOOOO XX  O XooooX  OO\",
\"OOOOOOOO  OOOO ooX  OOOO\",
\"OOOOOOOOOOOOOO X  OOOOOO\",
\"OOOOOOOOOOOOOOO OOOOOOOO\",
\"OOOOOOOOOOOOOOOOOOOOOOOO\",
\"OOOOOOOOOOOOOOOOOOOOOOOO\"};")
    nil)
  "MH paste icon.")

(push '(paste . mh-xemacs-paste-icon) mh-xemacs-icon-map)

;; Derived from etc/images/preferences.xpm
(defconst mh-xemacs-preferences-icon
  (if mh-xemacs-has-tool-bar-flag
      (toolbar-make-button-list
       "/* XPM */
static char * preferences_xpm[] = {
\"24 24 8 1\",
\" 	c Gray75 s backgroundToolBarColor\",
\".	c #000000\",
\"+	c #E1E0E0\",
\"@	c #D7C99B\",
\"#	c #9A6C4E\",
\"$	c #A4A199\",
\"%	c #858579\",
\"&	c #AD8E30\",
\"                        \",
\"                        \",
\"                        \",
\"             ..         \",
\"           ..++.     .  \",
\"         ..++++.    .@. \",
\"      ...+++++++.  .@#. \",
\"    ..++++++++++. .@#.  \",
\"   .++++++#++++++.@#.   \",
\"   .+++++#++++++.@#.    \",
\"    .++#+#+++++.@#.     \",
\"    .++#$#++++.@#.+.    \",
\"     .++##+++.@#.++@.   \",
\"     .++++++.@#.+++@%.  \",
\"      .++++&+..@$$$$%.  \",
\"      .++++..$$$$$$@.   \",
\"       .+$%%$+++++..    \",
\"       .+++++++++.      \",
\"        .++++++..       \",
\"        .++++@.         \",
\"         .++..          \",
\"          ..            \",
\"                        \",
\"                        \"};")
    nil)
  "MH preferences icon.")

(push '(preferences . mh-xemacs-preferences-icon) mh-xemacs-icon-map)

;; Derived from etc/images/refresh.xpm
;; XXX Needs to be updated.
(defconst mh-xemacs-refresh-icon
  (if mh-xemacs-has-tool-bar-flag
      (toolbar-make-button-list
       "/* XPM */
static char * mail_rescan_xpm[] = {
/* columns rows colors chars-per-pixel */
\"24 24 6 1\",
\" 	c Gray75 s backgroundToolBarColor\",
\".	c black\",
\"X	c #a5d8a5d89550\",
\"o	c #d305d305bc3c\",
\"O	c #ea03ea03d271\",
\"+	c #828282827474\",
/* pixels */
\"                        \",
\"                        \",
\"       ..............   \",
\"      .XXXXXXXXXXXX..   \",
\"     .XXXXXXXXXXXX.X.   \",
\"    .XXXXXXXXXXXX.oo.   \",
\"   ..............ooo.   \",
\"   .OOOOOOOOOOOO.ooo.   \",
\"   .O++++++++++O.ooo.   \",
\"   .O+XXXXXXXX+O.ooo.   \",
\"   .O+XXXXXXXX+O.ooo.   \",
\"   .O+XXXXXXXX+O.ooo.   \",
\"   .O+XXXXXXXX+O.ooo.   \",
\"   .O++++++++++O.ooo.   \",
\"   .OOOOOOOOOOOO.ooo.   \",
\"   .O++++++++++O.ooo.   \",
\"   .O+XXXXXXXX+O.ooo.   \",
\"   .O+XXXXXXXX+O.ooX.   \",
\"   .O+XXXXXXXX+O.oo..   \",
\"   .O++++++++++O.o..    \",
\"  ..OOOOOOOOOOOO...     \",
\"  ................      \",
\"                        \",
\"                        \"};")
    nil)
  "MH refresh icon.")

(push '(refresh . mh-xemacs-refresh-icon) mh-xemacs-icon-map)

;; Derived from etc/images/right-arrow.xpm
(defconst mh-xemacs-right-arrow-icon
  (if mh-xemacs-has-tool-bar-flag
      (toolbar-make-button-list
       "/* XPM */
static char * right_arrow_xpm[] = {
\"24 24 9 1\",
\" 	c Gray75 s backgroundToolBarColor\",
\".	c #020202\",
\"+	c #1A1A1A\",
\"@	c #779D6D\",
\"#	c #88AE80\",
\"$	c #97B78B\",
\"%	c #9EBA92\",
\"&	c #E9EFE8\",
\"*	c #3C5936\",
\"                        \",
\"                        \",
\"                        \",
\"                        \",
\"                        \",
\"      ..                \",
\"      .&..              \",
\"      .&&&..            \",
\"      .&&&&&..          \",
\"      .&&&&&&&..        \",
\"      .&&&&&&&&&+.      \",
\"      +&&&&&&&&&&%..    \",
\"      .%#######@@*..    \",
\"      .%#####@@*..      \",
\"      .%###@@*..        \",
\"      .$#@@*..          \",
\"      .#@*..            \",
\"      .*..              \",
\"      ..                \",
\"                        \",
\"                        \",
\"                        \",
\"                        \",
\"                        \"};")
    nil)
  "*MH right-arrow icon.")

(push '(right-arrow . mh-xemacs-right-arrow-icon) mh-xemacs-icon-map)

;; Derived from etc/images/save.xpm
(defconst mh-xemacs-save-icon
  (if mh-xemacs-has-tool-bar-flag
      (toolbar-make-button-list
       "/* XPM */
static char *magick[] = {
/* columns rows colors chars-per-pixel */
\"24 24 5 1\",
\"  c #01be01be01be\",
\". c #62dd62dd62dd\",
\"X c Gray62\",
\"o c #e625e625e625\",
\"O c Gray75 s backgroundToolBarColor\",
/* pixels */
\"OOOOOOOOOOOOOOOOOOOOOOOO\",
\"OOOOOOOOOOOOOOOOOOOOOOOO\",
\"OOOOOOOOOOOOOOOOOOOOOOOO\",
\"OOOOOOOOOOOOOOOOOOOOOOOO\",
\"OOOOOOOOOOOOO  OOOOOOOOO\",
\"OOOOOOOOOOO  X. OOOOOOOO\",
\"OOOOOOOOO  oXoX OOOOOOOO\",
\"OOOOOOO  oXoooXX OOOOOOO\",
\"OOOOO  oXoooooo. OOOOOOO\",
\"OOO  XoooooooooX  OOOOOO\",
\"OO XooooooooooooX OOOOOO\",
\"OO .XoooooooooooX. OOOOO\",
\"OOO XooooooooooXXX OOOOO\",
\"OOO .XoooooooXX..X. OOOO\",
\"OOOO XoooooXX...X.X OOOO\",
\"OOOO .XooXX.Xoo.X.X. OOO\",
\"OOOOO XXX.oooooX.X.  OOO\",
\"OOOOO .XXoo.ooooXX   OOO\",
\"OOOOOO XX.o XooX.  OOOOO\",
\"OOOOOO .XXooXoX  OOOOOOO\",
\"OOOOOOO .X.oX  OOOOOOOOO\",
\"OOOOOOOO     OOOOOOOOOOO\",
\"OOOOOOOOOOOOOOOOOOOOOOOO\",
\"OOOOOOOOOOOOOOOOOOOOOOOO\"};")
    nil)
  "MH save icon.")

(push '(save . mh-xemacs-save-icon) mh-xemacs-icon-map)

;; Derived from etc/images/search.xpm
(defconst mh-xemacs-search-icon
  (if mh-xemacs-has-tool-bar-flag
      (toolbar-make-button-list
       "/* XPM */
static char *magick[] = {
/* columns rows colors chars-per-pixel */
\"24 24 8 1\",
\"  c #011801180102\",
\". c #464646463e3e\",
\"X c #5c5c5c5c57a0\",
\"o c #878787877979\",
\"O c #a910a91097af\",
\"+ c #ce5ace5ab851\",
\"@ c #e79de79dd134\",
\"# c Gray75 s backgroundToolBarColor\",
/* pixels */
\"########################\",
\"########################\",
\"############# ##########\",
\"###########  O #########\",
\"#########  O@@.#########\",
\"#######  O@@@@@ ########\",
\"#####  O+@@@@@@O #######\",
\"#### XX@++@@@@@@.#######\",
\"#### @.O+@@@@@@@@ ######\",
\"#### @@.++@@@@@@@O #####\",
\"#### @@.o+O.  .+@@ #####\",
\"#### @XO+O.O++o.+@@ ####\",
\"####  O+@.O@@+Oo.@@+ ###\",
\"#### X@@@ +#+OOO @@@@ ##\",
\"#### O@@@ +@OOOo @@@o ##\",
\"##### @@@.oOOOoX.@@  ###\",
\"##### O@@O.oOOX  @ #####\",
\"######X@@@O.  .X  ######\",
\"###### @@@@@@@+    #####\",
\"####### @@@@@O ##   ####\",
\"####### O@@+. ####   ###\",
\"######## @O #######  ###\",
\"#########  #############\",
\"########################\"};")
    nil)
  "MH search icon.")

(push '(search . mh-xemacs-search-icon) mh-xemacs-icon-map)

;; Derived from etc/images/show.xpm
(defconst mh-xemacs-show-icon
  (if mh-xemacs-has-tool-bar-flag
      (toolbar-make-button-list
       "/* XPM */
static char * mail_show_xpm[] = {
/* columns rows colors chars-per-pixel */
\"24 24 4 1\",
\" 	c Gray75 s backgroundToolBarColor\",
\".	c black\",
\"X	c #ea03ea03d271\",
\"o	c #a5d8a5d89550\",
/* pixels */
\"                        \",
\"                        \",
\"   ..................   \",
\"   .XXXXXXXXXXXXXXXX.   \",
\"   .XXXXXXXXXXXXXXXX.   \",
\"   .XoooooooooooooXX.   \",
\"   .XXXXXXXXXXXXXXXX.   \",
\"   .XXXXXXXXXXXXXXXX.   \",
\"   .XoooooooooooooXX.   \",
\"   .XXXXXXXXXXXXXXXX.   \",
\"   .XXXXXXXXXXXXXXXX.   \",
\"   .XooooooXXXXXXXXX.   \",
\"   .XXXXXXXXXXXXXXXX.   \",
\"   .XXXXXXXXXXXXXXXX.   \",
\"   .XoooooooooXXXXXX.   \",
\"   .XXXXXXXXXXXXXXXX.   \",
\"   .XXXXXXXXXXXXXXXX.   \",
\"   .XXXXXXXXXXXXXXXX.   \",
\"   .XXXXXXXXXXXXXXXX.   \",
\"   .XXXXXXXXXXXXXXXX.   \",
\"   ..................   \",
\"                        \",
\"                        \",
\"                        \"};")
    nil)
  "MH show icon.")

(push '(show . mh-xemacs-show-icon) mh-xemacs-icon-map)

;; Derived from etc/images/spell.xpm
(defconst mh-xemacs-spell-icon
  (if mh-xemacs-has-tool-bar-flag
      (toolbar-make-button-list
       "/* XPM */
static char *magick[] = {
/* columns rows colors chars-per-pixel */
\"24 24 5 1\",
\"  c Gray0\",
\". c #41415b5b3939\",
\"X c #4c2f6b4e42d1\",
\"o c #5fe086865454\",
\"O c Gray75 s backgroundToolBarColor\",
/* pixels */
\"OOOOOOOOOOOOOOOOOOOOOOOO\",
\"OOOOOOOOOOOOOOOOOOOOOOOO\",
\"OOOOOOOOOOOOOOOOOOOOOOOO\",
\"OOOOOOOOOOOOOOOOOOOOOOOO\",
\"OOOO  OO   OOO  OOOOOOOO\",
\"OOO OO O OO O OO OOOOOOO\",
\"OOO    O   OO OOOOOOOOOO\",
\"OOO OO O OO O OO OOOOOOO\",
\"OOO OO O   OOO  OOOO  OO\",
\"OOOOOOOOOOOOOOOOOOO  OOO\",
\"OOOOOOOOOOO  OOOOO  OOOO\",
\"OOOOOOOOOOO X OOO . OOOO\",
\"OOOOOOOOOOOO X O X OOOOO\",
\"OOOOOOOOOOOO Xo o. OOOOO\",
\"OOOOOOOOOOOOO XoX OOOOOO\",
\"OOOOOOOOOOOOO Xo. OOOOOO\",
\"OOOOOOOOOOOOOO X OOOOOOO\",
\"OOOOOOOOOOOOOO X OOOOOOO\",
\"OOOOOOOOOOOOOOO OOOOOOOO\",
\"OOOOOOOOOOOOOOOOOOOOOOOO\",
\"OOOOOOOOOOOOOOOOOOOOOOOO\",
\"OOOOOOOOOOOOOOOOOOOOOOOO\",
\"OOOOOOOOOOOOOOOOOOOOOOOO\",
\"OOOOOOOOOOOOOOOOOOOOOOOO\"};")
    nil)
  "MH spell icon.")

(push '(spell . mh-xemacs-spell-icon) mh-xemacs-icon-map)

;; Derived from etc/images/undo.xpm
(defconst mh-xemacs-undo-icon
  (if mh-xemacs-has-tool-bar-flag
      (toolbar-make-button-list
       "/* XPM */
static char *magick[] = {
/* columns rows colors chars-per-pixel */
\"24 24 5 1\",
\"  c Gray0\",
\". c #ae6e66e76a0a\",
\"X c #c6c67d7d8181\",
\"o c #e4e4e4e4dcdc\",
\"O c Gray75 s backgroundToolBarColor\",
/* pixels */
\"OOOOOOOOOOOOOOOOOOOOOOOO\",
\"OOOOOOOOOOOOOOOOOOOOOOOO\",
\"OOOOOOOOOOOOOOOOOOOOOOOO\",
\"OOOOOOOOOOOOOOOOOOOOOOOO\",
\"OOOOOOOOOOOOOOOOOOOOOOOO\",
\"OOOOOOOOOOOOOOOOOOOOOOOO\",
\"OOOOOOOOO OOOOOOOOOOOOOO\",
\"OOOOOOOO  OOOOOOOOOOOOOO\",
\"OOOOOOO oX   OOOOOOOOOOO\",
\"OOOOOO ooooX.  OOOOOOOOO\",
\"OOOOOOO oo   .. OOOOOOOO\",
\"OOOOOOOO  OOO . OOOOOOOO\",
\"OOOOOOOOO OOOO . OOOOOOO\",
\"OOOOOOOOOOOOOOO  OOOOOOO\",
\"OOOOOOOOOOOOOOO  OOOOOOO\",
\"OOOOOOOOOOOOOOO OOOOOOOO\",
\"OOOOOOOOOOOOOO OOOOOOOOO\",
\"OOOOOOOOOOOOOOOOOOOOOOOO\",
\"OOOOOOOOOOOOOOOOOOOOOOOO\",
\"OOOOOOOOOOOOOOOOOOOOOOOO\",
\"OOOOOOOOOOOOOOOOOOOOOOOO\",
\"OOOOOOOOOOOOOOOOOOOOOOOO\",
\"OOOOOOOOOOOOOOOOOOOOOOOO\",
\"OOOOOOOOOOOOOOOOOOOOOOOO\"};")
    nil)
  "MH undo icon.")

(push '(undo . mh-xemacs-undo-icon) mh-xemacs-icon-map)

;; Derived from etc/images/widen.xpm
(defconst mh-xemacs-widen-icon
  (if mh-xemacs-has-tool-bar-flag
      (toolbar-make-button-list
       "/* XPM */
static char * widen_xpm[] = {
/* columns rows colors chars-per-pixel */
\"24 24 3 1\",
\" 	c Gray75 s backgroundToolBarColor\",
\".	c #8d4d97577838\",
\"X	c black\",
/* pixels */
\"                        \",
\"                        \",
\"                        \",
\"  .                  .  \",
\"  .                  .  \",
\"  .                  .  \",
\"  .                  .  \",
\"  .                  .  \",
\"  .   XX        XX   .  \",
\"  .  XX          XX  .  \",
\"  . XX            XX .  \",
\"  .XXXXXXXX  XXXXXXXX.  \",
\"  .XXXXXXXX  XXXXXXXX.  \",
\"  . XX            XX .  \",
\"  .  XX          XX  .  \",
\"  .   XX        XX   .  \",
\"  .                  .  \",
\"  .                  .  \",
\"  .                  .  \",
\"  .                  .  \",
\"  .                  .  \",
\"                        \",
\"                        \",
\"                        \"};")
    nil)
  "MH widen icon.")

(push '(widen . mh-xemacs-widen-icon) mh-xemacs-icon-map)

;; Just to keep mh-xemacs-icon-map alphabetical as well.
(setq mh-xemacs-icon-map (reverse mh-xemacs-icon-map))



(provide 'mh-xemacs)

;;; Local Variables:
;;; indent-tabs-mode: nil
;;; sentence-end-double-space: nil
;;; End:

;;; mh-xemacs.el ends here
