/*
 * Decompiled with CFR 0.152.
 */
package jep;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.util.EmptyStackException;
import jep.AppletFrame;
import jep.AppletHandlerFactory;

public class MySimpleEventQueue
extends EventQueue {
    private static MySimpleEventQueue topQueue = null;

    protected void dispatchEvent(AWTEvent event) {
        long pool = AppletHandlerFactory.allocAutoreleasePool();
        try {
            Container next;
            Object source = event.getSource();
            Component ancestor = (Component)source;
            while ((next = ancestor.getParent()) != null) {
                ancestor = next;
            }
            if (ancestor instanceof AppletFrame) {
                AppletFrame.setCurrentAppletFrame((AppletFrame)ancestor);
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        super.dispatchEvent(event);
        AppletFrame.setCurrentAppletFrame(null);
        AppletHandlerFactory.releaseAutoreleasePool(pool);
    }

    public synchronized void push(EventQueue newEventQueue) {
        if (topQueue == null) {
            topQueue = this;
        }
        super.push(newEventQueue);
    }

    protected void pop() throws EmptyStackException {
        if (topQueue == null || topQueue == this) {
            throw new EmptyStackException();
        }
        super.pop();
    }
}

