/* flags used throughout the code to (hopefully) make it easier to follow */

#ifndef FLAGS_H
#define FLAGS_H

#ifndef TRUE
#define TRUE 1
#define FALSE 0
#endif				/* TRUE */

#ifndef NULL
#define NULL ((void *)0)
#endif				/* NULL */

#define MAX_PORT 65535

#define RWLOCK 0
#define MUTEX 1

#define REDIRECT_REQUEST 0
#define REDIRECT_HEADER 1

#define POLICY_ALLOW 0
#define POLICY_DENY 1

#define NET_UNUSED 0
#define NET_LISTEN 1

#define HTTP_CONNECT 0
#define HTTP_RESP 1
#define HTTP_PROXY 2
#define HTTP_REQUEST 3

#define HTTP_HTTP09 0
#define HTTP_HTTP10 1
#define HTTP_HTTP11 2

#define HEADER_DIRECT 0
#define HEADER_FORWARD 1
#define HEADER_RESP 2

#define THREAD_UNUSED 0 /* thread not used */
#define THREAD_IDLE 1 /* thread hasn't filled in it's info yet (avoid race condition) */
#define THREAD_WAITING 2 /* thread is waiting to handle another connection */
#define THREAD_BUSY 3 /* thread is handling a client request */

#define FORWARD_HTTP 1
#define FORWARD_FTP (1<<1)
#define FORWARD_CONNECT (1<<2)

#define EXTERNAL_PIPE 0
#define EXTERNAL_FILE 1

#define TEMPLATE_FILE 0
#define TEMPLATE_EXECUTABLE 1

#define URL_ENCODE 1
#define URL_DECODEBEFORE (1<<1)
#define URL_DECODEAFTER (1<<2)

#define CLIENT 0
#define SERVER 1

#define UP 0
#define DOWN 1

#define TOP 0
#define BOTTOM 1

#define IN 0
#define OUT 1

#define HIT 0
#define MISS 1

#define HTML_NEWLINES 1
#define HTML_SPACES (1<<1)
#define HTML_JAVASCRIPT (1<<2)

#define SORT_ASCENDING 0
#define SORT_DESCENDING 1

#define SORT_NONE 0
#define SORT_NAME 1
#define SORT_SIZE 2
#define SORT_DATE 3

#define HEADER_KEEPALIVE 1

/* Riadh: changed the order below due to the design of web interface
   PROXY_DIRECT is last because it is not used in the web interface */
#define PROXY_NORMAL 0
#define PROXY_SOCKS4 1
#define PROXY_CONNECT 2
#define PROXY_DIRECT 3

#define REWRITE_CLIENT 1
#define REWRITE_SERVER (1<<1)
#define REWRITE_BODY (1<<2)
#define REWRITE_POST (1<<3)

#define REDIRECT_LOCATION 0
#define REDIRECT_URL 1
#define REDIRECT_BOTH 2

#define ERROR_AUTH -4
#define ERROR_DNS -3
#define ERROR_CONNECT -2
#define ERROR_UNKNOWN -1

#define SOCKS_GRANTED 90
#define SOCKS_FAILED 91
#define SOCKS_NOIDENT 92
#define SOCKS_BADIDENT 93

#define COOKIE_IN 0
#define COOKIE_OUT 1
#define COOKIE_BOTH 2

#define MMLOG_REQUEST 1
#define MMLOG_NETWORK (1 << 1)
#define MMLOG_FILTER (1 << 2)
#define MMLOG_HEADER (1 << 3)
#define MMLOG_MIME (1 << 4)
#define MMLOG_COOKIE (1 << 5)
#define MMLOG_REDIRECT (1 << 6)
#define MMLOG_TEMPLATE (1 << 7)
#define MMLOG_KEYWORDS (1 << 8)
#define MMLOG_REWRITE (1 << 9)
#define MMLOG_LIMITS (1 << 10)
#define MMLOG_CACHE (1 << 11)
#define MMLOG_PREFETCH (1<<12)
#define MMLOG_ICP (1<<13)
#define MMLOG_FORWARD (1<<14)
#define MMLOG_SYNC (1<<15)
#define MMLOG_ANTIVIRUS (1<<16)
#define MMLOG_EXTERNAL (1<<17)
#define MMLOG_DNSBL (1<<18)
#define MMLOG_SECURITY (1 << 19)
#define MMLOG_WARN (1 << 20)
#define MMLOG_ERROR (1 << 21)
#define MMLOG_DEBUG (1 << 22)

#define FEATURE_FILTER 1
#define FEATURE_HEADER (1<<1)
#define FEATURE_MIME (1<<2)
#define FEATURE_REDIRECT (1<<3)
#define FEATURE_COOKIES (1<<4)
#define FEATURE_REWRITE (1<<5)
#define FEATURE_EXTERNAL (1<<6)
#define FEATURE_FORWARD (1<<7)
#define FEATURE_KEYWORDS (1<<8)
#define FEATURE_DNSBL (1<<9)
#define FEATURE_LIMITS (1<<10)

#define ACCESS_CONFIG 1
#define ACCESS_PROXY (1<<1)
#define ACCESS_HTTP (1<<2)
#define ACCESS_TRANSPARENT (1<<3)
#define ACCESS_CONNECT (1<<4)
#define ACCESS_BYPASS (1<<5)
#define ACCESS_URLCOMMAND (1<<6)

#define CACHE_WRITING 1 /* cache file is being written */
#define CACHE_INVALID (1<<1) /* cache item is no longer valid */
#define CACHE_EXPIRED (1<<2) /* cache item expired */
#define CACHE_VALIDATE (1<<3) /* cache item needs to be validated */
#define CACHE_PREFETCHED (1<<4) /* cached as a result of a prefetch request */
#define CACHE_VIOLATION (1<<5) /* caching this violates RFC */ 
#define CACHE_OFFLINE (1<<6)
#define CACHE_DISK (1<<7) /* cached on disk */
#define CACHE_MEM (1<<8) /* cached in memory */
#define CACHE_NEW (1<<9) /* cache is new (wasn't loaded from journal) */

#define SBALANCE_FILLSIZE 0
#define SBALANCE_FILLPERCENT 1

#define ICP_NONE 0 /* no ICP releationship with this proxy */
#define ICP_PARENT 1 /* proxy is a parent cache */
#define ICP_SIBLING 2 /* proxy is a sibling cache */

/* flags which are masked off from journal entries */
#define CACHE_SESSION_FLAGS (CACHE_EXPIRED | CACHE_VALIDATE | CACHE_PREFETCHED | CACHE_MEM | CACHE_VIOLATION)

#define CONNECTION_BUFFER 1 /* file to be buffered */
#define CONNECTION_VALIDATE (1<<1) /* cached file is being validated using If-Modified-Since header */
#define CONNECTION_VALIDATED (1<<2)  /* cached file was successfully validated */
#define CONNECTION_CACHING (1<<3) /* file is being cached */
#define CONNECTION_AUTHENTICATED (1<<4) /* authenticated with forwarding proxy */
#define CONNECTION_OFFLINE (1<<5) /* send only cached files, ignoring expiry date */
#define CONNECTION_PROCESS (1<<6) /* file will be processed */
#define CONNECTION_LOGGEDIN (1<<7) /* already logged in (i.e. ftp connection from pool) */
#define CONNECTION_LIMITCACHE (1<<8) /* limit bytes transfered from cache as well */
#define CONNECTION_PREFETCH (1<<9) /* prefetch connection */
#define CONNECTION_ENCODED (1<<10) /* content is encoded but client doesn't support it */
#define CONNECTION_FAILED (1<<11) /* transfer failed */
#define CONNECTION_NOPROXY (1<<12) /* connection can't be proxied (SOCKS4 is ok) */
#define CONNECTION_SSLCLIENT (1<<13) /* encrypted connection to web server */
#define CONNECTION_NOCLIENT (1<<14) /* no client initiating request */

#define HEADER_FILTERED 1 /* header was filtered */
#define HEADER_CL (1<<1) /* content-length header was given */
#define HEADER_DPORT (1<<2) /* default protocol port was used, since non was given explicity. */

#define HEADER_CLIENT 1 /* filter client header */
#define HEADER_SERVER (1 << 1) /* filter server header */

#define TIMER_ONCE 0
#define TIMER_REPEAT 1

#define LIMIT_CACHE 1

#define TIMEMATCH_ABSOLUTE 0
#define TIMEMATCH_ALLRANGES 1

#define ICP_OP_INVALID 0
#define ICP_OP_QUERY  1
#define ICP_OP_HIT 2
#define ICP_OP_MISS 3
#define ICP_OP_ERR 4
#define ICP_OP_SECHO 10
#define ICP_OP_DECHO 11
#define ICP_OP_MISS_NOFETCH 21
#define ICP_OP_DENIED 22
#define ICP_OP_HIT_OBJ 23

#define ICP_PACKET_LEN 20 /* the size of an ICP packet (minus payload) */
#define ICP_MESSAGE_MAX 65546 /* maximum length of an ICP packet */

#endif				/* FLAGS_H */
