/*
    MiddleMan filtering proxy server
    Copyright (C) 2002-2004  Jason McLaughlin

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <stdio.h>
#include <string.h>
#include "proto.h"

extern GLOBAL *global;
extern GeneralSection *general_section;

HTTPRESPONSE *http_fetch(URL * url)
{
	int x;
	CONNECTION *connection;
	char *headbuf;
	Filebuf *filebuf = NULL;
	HTTPRESPONSE *resp = NULL;

	connection = connection_new();

	connection->flags |= CONNECTION_NOCLIENT;
	connection->ip = xstrdup("127.0.0.1");
	connection->interface = xstrdup("127.0.0.1");

	connection->header = header_new();
	connection->header->type = HTTP_PROXY;
	connection->header->version = HTTP_HTTP11;
	connection->header->method = xstrdup("GET");
	connection->header->proto = xstrdup(url->proto);
	connection->header->host = xstrdup(url->host);
	connection->header->file = xstrdup(url->file);
	connection->header->port = url->port;

	struct HTTP_HEADER hdr;
	hdr.type = string("User-Agent");
	hdr.value = string(PREFETCH_USERAGENT);
	hdr.send = TRUE;
	connection->header->header.push_back(hdr);

        if (url->username != NULL) connection->header->username = xstrdup(url->username);
        if (url->password != NULL) connection->header->password = xstrdup(url->password);

	x = protocol_start(connection);
	if (x < 0)
		goto out;

	connection->server = xnew Socket(x);

	header_send(connection->header, connection, SERVER, HEADER_DIRECT);

	headbuf = header_get_reconnect(connection, general_section->timeout_get());
	if (headbuf == NULL)
		goto out;

	connection->rheader = http_header_parse_response(headbuf);
	if (connection->rheader == NULL || connection->rheader->code != 200) goto out;

	filebuf = http_transfer_filebuf(connection, SERVER, ~0);

	out:

	if (connection->keepalive_server == TRUE)
		pool_add(global->pool, connection->server, connection->header->proto, (connection->proxy_type == PROXY_NORMAL && connection->proxy_host != NULL) ? connection->proxy_host : connection->header->host, (connection->proxy_type == PROXY_NORMAL) ? connection->proxy_port : connection->header->port, NULL, NULL);
	else
		xdelete connection->server;

	if (filebuf != NULL) {
		resp = (HTTPRESPONSE *)xmalloc(sizeof(HTTPRESPONSE));
		resp->header = connection->rheader;
		resp->body = filebuf;
	} else if (connection->rheader != NULL)
		http_header_free(connection->rheader);

	http_header_free(connection->header);

	connection_free(connection);

	return resp;
}

void httpresponse_free(HTTPRESPONSE *resp) {
	xdelete resp->header;
	xdelete resp->body;

	xfree(resp);
}
