/*
    MiddleMan filtering proxy server
    Copyright (C) 2002-2004  Jason McLaughlin
    Copyright (C) 2003  Riadh Elloumi

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <stdio.h>
#include <string.h>
#include "proto.h"

extern GLOBAL *global;

ProfileSection::ProfileSection():
     Section("profiles", RWLOCK)
{
}

void ProfileSection::update()
{
	profile_list.clear();

	ItemList::iterator item;
	for (item = sub_vec[0].item_list.begin(); item != sub_vec[0].item_list.end(); item++)
		profile_list.push_back(Profile(*item));
	
}


Profile::Profile(const Item& item):
     enabled       (item.field_vec[0].int_value),
     comment       (item.field_vec[1].string_value),
     profiles      (item.field_vec[2].string_list_value),
     protocol      (item.field_vec[3].string_value),
     host          (item.field_vec[4].string_value),
     file          (item.field_vec[5].string_value),
     mime          (item.field_vec[6].string_value),
     portrange     (item.field_vec[7].port_range_list_value),
     addprofiles   (item.field_vec[8].string_list_value),
     removeprofiles(item.field_vec[9].string_list_value),
     urlcommand    (item.field_vec[10].string_list_value)
{
	pe = (protocol != "") ? reg_compile(protocol.c_str(), REGFLAGS) : NULL;
	he = (host != "") ? reg_compile(host.c_str(), REGFLAGS) : NULL;
	fe = (file != "") ? reg_compile(file.c_str(), REGFLAGS) : NULL;
	me = (mime != "") ? reg_compile(file.c_str(), REGFLAGS) : NULL;
}

Profile::Profile(const Profile& p):
     enabled       (p.enabled),
     comment       (p.comment),
     profiles      (p.profiles),
     protocol      (p.protocol),
     host          (p.host),
     file          (p.file),
     mime          (p.mime),
     portrange     (p.portrange),
     addprofiles   (p.addprofiles),
     removeprofiles(p.removeprofiles),
     urlcommand    (p.urlcommand)
{
	pe = (protocol != "") ? reg_compile(protocol.c_str(), REGFLAGS) : NULL;
	he = (host != "") ? reg_compile(host.c_str(), REGFLAGS) : NULL;
	fe = (file != "") ? reg_compile(file.c_str(), REGFLAGS) : NULL;
	me = (mime != "") ? reg_compile(file.c_str(), REGFLAGS) : NULL;
}

Profile::~Profile()
{
	if (pe != NULL)
		reg_free(pe);
	if (he != NULL)
		reg_free(he);
	if (fe != NULL)
		reg_free(fe);
	if (me != NULL)
		reg_free(me);
}

void ProfileSection::profiles_update(CONNECTION * connection)
{
	int ret;
	struct url_command_t **url_command;

	read_lock();

	ProfileList::const_iterator profile;
	for (profile = profile_list.begin(); profile != profile_list.end(); profile++) {
		if (profile->enabled == FALSE)
			continue;

		if (!profile_find(connection->profiles, profile->profiles))
			continue;

		if (profile->portrange.has(connection->header->port) == FALSE) continue;

		if (profile->me != NULL) {
			if (connection->rheader == NULL || connection->rheader->content_type == NULL)
				continue;

			ret = reg_exec(profile->me, connection->rheader->content_type);
			if (ret) continue;
		} else if (connection->rheader != NULL)
			continue;

		if (profile->pe != NULL && connection->header->proto != NULL) {
			ret = reg_exec(profile->pe, connection->header->proto);
			if (ret)
				continue;
		} else if (profile->pe != NULL)
			continue;

		if (profile->he != NULL && connection->header->host != NULL) {
			ret = reg_exec(profile->he, connection->header->host);
			if (ret)
				continue;
		} else if (profile->he != NULL)
			continue;

		if (profile->fe != NULL) {
			ret = reg_exec(profile->fe, connection->header->file);
			if (ret)
				continue;
		}

                if (profile->urlcommand.size() != 0) {
                        if (connection->url_command == NULL)
                                continue;

                        url_command = connection->url_command;

                        for (; *url_command; url_command++)
                                if (profile->urlcommand.has((*url_command)->command))
                                        break;

                        if (*url_command == NULL)
                                continue;
                }

		StringList::const_iterator str;
		for (str = profile->addprofiles.begin(); str != profile->addprofiles.end(); str++)
			connection->profiles.push_back(*str);

		for (str = profile->removeprofiles.begin(); str != profile->removeprofiles.end(); str++)
			connection->profiles.remove(*str);
	}

	unlock();
}

int profile_find(const StringList& user_list, const StringList& entry_list)
{
	int neg, found_negated = FALSE;
	const char *ptr;

	/* If the entry does not have any profiles, it is valid. */
	if (entry_list.size() == 0)
		return TRUE;

	StringList::const_iterator entry;
	for (entry = entry_list.begin(); entry != entry_list.end(); entry++) {
		const char* str = entry->c_str();
		
		neg = (*str == '!');
		ptr =  neg ? str+1 : str;

		StringList::const_iterator user;
		for (user = user_list.begin(); user != user_list.end(); user++) {
			if (*user == ptr)
				return neg ? FALSE : TRUE;
		}

		/* remember if an unmatched negated entry profile is found */
		if (neg)
			found_negated = TRUE;
	}

	/* No active profile matched an entry profile. But if one of the entry's
	   profiles was negated, the entry is valid.
	*/
	return found_negated ? TRUE : FALSE;
}
