/*
    MiddleMan filtering proxy server
    Copyright (C) 2002-2004  Jason McLaughlin

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <stdio.h>
#include <time.h>
#include "proto.h"

extern char masterhost[];
extern char syncsections[];
extern char nosyncsections[];
extern int masterport;
extern TiXmlDocument *document;
extern pthread_mutex_t documentlock;
extern time_t documentsynctime;
extern int syncinterval;

void config_sync() {
	char buf[256];
	URL *url = NULL;
	HTTPRESPONSE *resp = NULL;
	struct tm timeval;
	time_t documentlmtime = 0;
        SectionMap::const_iterator iter;
	char **sargs = NULL, **nsargs = NULL;

	snprintf(buf, sizeof(buf), "http://%s:%d/mman/xml", masterhost, masterport);
	url = url_parse(buf);
	if (url == NULL) goto error;

	resp = http_fetch(url);
	if (resp == NULL) goto error;

	if (resp->header->last_modified != NULL) {
		strptime(resp->header->last_modified, HTTPTIMEFORMAT, &timeval);
		documentlmtime = mktime(&timeval);

		if (documentlmtime <= documentsynctime) {
			putlog(MMLOG_SYNC, "syncronized with %s:%d", masterhost, masterport);

			goto out;
		} else documentsynctime = documentlmtime;
	}

	pthread_mutex_lock(&documentlock);
	xdelete document;
	document = xnew TiXmlDocument();

	resp->body->Add("", 1);
	document->Parse(resp->body->data, 0);

	if (document->Error()) {
		pthread_mutex_unlock(&documentlock);

		goto error;
	}

	if (syncsections[0]) sargs = string_break(syncsections, ',');
	if (nosyncsections[0]) nsargs = string_break(nosyncsections, ',');

	putlog(MMLOG_SYNC, "syncronizing with %s:%d", masterhost, masterport);

        for (iter = Section::map.begin(); iter != Section::map.end(); iter++) {
		if (sargs != NULL) {
			char **arg;
			for (arg = sargs; *arg && strcasecmp(*arg, iter->first.c_str()); arg++);
			if (!*arg) continue;
		}
		if (nsargs != NULL) {
			char **arg;
			for (arg = nsargs; *arg && strcasecmp(*arg, iter->first.c_str()); arg++);
			if (*arg) continue;
		}

		try {
	                iter->second->load(document, TRUE);
		} catch (ConfigError e) {
			putlog(MMLOG_SYNC, "error syncronizing %s section", iter->first.c_str());

			continue;
		}

		putlog(MMLOG_SYNC, "syncronized %s section", iter->first.c_str());
        }

	pthread_mutex_unlock(&documentlock);

	if (sargs != NULL)  array_free(sargs);
	if (nsargs != NULL) array_free(nsargs);

	out:

	if (resp != NULL) httpresponse_free(resp);
	if (url != NULL) url_free(url);

	return;

	error:

	if (resp != NULL) httpresponse_free(resp);
	if (url != NULL) url_free(url);

	putlog(MMLOG_SYNC, "failed to syncronize with master");

	return;
}

void sync_thread() {
	while(1) {
		sleep(syncinterval);

		config_sync();
	}
}	
