/*
    MiddleMan filtering proxy server
    Copyright (C) 2002-2004  Jason McLaughlin

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "proto.h"

#if 0
/* unused code for the moment */
TIMERS *timers_init() {
	TIMERS *timers;

	timers = xmalloc(sizeof(TIMERS));
	timers->timers = NULL;
	timers->tid = 0;

	pthread_mutex_init(&timers->lock, NULL);

	return timers;
}

int timers_add(TIMERS *timers, int interval, int flags, void *callback, void *arg) {
	int tid;
	struct TIMERS_LIST *timer;

	pthread_mutex_lock(&timers->lock);

	timer = xmalloc(sizeof(struct TIMERS_LIST));
	tid = timer->tid = timers->tid++;
	timer->callback = callback;
	timer->arg = arg;
	timer->etime = time(NULL) + interval;
	timer->interval = interval;
	timer->flags = flags;

	timers_insert(timers, timer);
	
	pthread_mutex_unlock(&timers->lock);

	putlog(MMLOG_DEBUG, "added timer %d", tid);

	return tid;
}

int timers_remove(TIMERS *timers, int tid) {
	struct TIMERS_LIST *tmp;

	tmp = timers_find(timers, tid);
	if (tmp != NULL) {
		if (tmp->prev != NULL)
			tmp->prev->next = tmp->next;
		else
			timers->timers = tmp->next;

		if (tmp->next != NULL) tmp->next->prev = tmp->prev;

		xfree(tmp);
	}

	pthread_mutex_unlock(&timers->lock);

	return !!tmp;
}

void timers_check(TIMERS *timers) {
	time_t curtime = time(NULL);
	struct TIMERS_LIST *tmp, *next = NULL;

	pthread_mutex_lock(&timers->lock);

	for (tmp = timers->timers; tmp; tmp = next) {
		next = tmp->next;

		if (tmp->etime <= curtime) {
			putlog(MMLOG_DEBUG, "executing timer %d", tmp->tid);

			tmp->callback(tmp->arg);
			
			if (tmp->prev != NULL)
				tmp->prev->next = tmp->next;
			else
				timers->timers = tmp->next;

			if (tmp->next != NULL)
				tmp->next->prev = tmp->prev;

			if (tmp->flags & TIMER_REPEAT) {
				/* add timer back to list in appropiate position and compensate 
				   for when curtime > etime */
				tmp->etime = curtime + tmp->interval - (curtime - tmp->etime);

				timers_insert(timers, tmp);
			} else
				xfree(tmp);
		} else
			/* list is sorted, no expired timers are in the list now */
			break;
	}

	pthread_mutex_unlock(&timers->lock);
}

struct TIMERS_LIST *timers_find(TIMERS *timers, int tid) {
	struct TIMERS_LIST *tmp;

	/* leave locked so caller doesn't race if list changes */
	pthread_mutex_lock(&timers->lock);

	for (tmp = timers->timers; tmp; tmp = tmp->next) {
		if (timers->tid == tid) return tmp;
	}

	return NULL;
}

void timers_insert(TIMERS *timers, struct TIMERS_LIST *tl) {
	struct TIMERS_LIST *tmp;

	/* keep timer list sorted with timers expiring first at the beginning so we don't
	   have to traverse the entire list everytime we call timers_check */
	if (timers->timers == NULL || timers->timers->etime > tl->etime) {
		tl->prev = NULL;
		tl->next = timers->timers;
		if (timers->timers != NULL) timers->timers->prev = tl;
		timers->timers = tl;
	} else {
		for (tmp = timers->timers; tmp; tmp = tmp->next) {
			if (tmp->next == NULL || tmp->next->etime > tl->etime) {
				tl->prev = tmp;
				tl->next = tmp->next;
				if (tmp->next != NULL) tmp->next->prev = tmp;
				tmp->next = tl;

				break;
			}
		}
	}
}
#endif /* #if 0 */
