/*
 *  ppui/Font.cpp
 *
 *  Copyright 2008 Peter Barth
 *
 *  This file is part of Milkytracker.
 *
 *  Milkytracker is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Milkytracker is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Milkytracker.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

//////////////////////////////////////////////////////////////////////
//
// PPFont.cpp: implementation of the PPFont class.
//
//////////////////////////////////////////////////////////////////////

#include "Font.h"
#include <stdio.h>

struct FontEntry
{
	FontEntry(const char* theName,
			  const unsigned int theWidth,
			  const unsigned int theHeight,
			  const char* theData) :
		name(theName),
		width(theWidth),
		height(theHeight),
		data(theData)
	{
	}
	
	const char* name;
	const unsigned int width, height;
	const char* data;
};

FontEntry fontEntries[] = {
// Font no. 0
FontEntry("ARIEL", 8, 8, 
"\x0\x0\x0\x0\x0\x0\x0\x0\x7e\x81\xa5\x81\xbd\x99\x81\x7e\x7e\xff\xdb\xff\xff\xc3\xe7\x7e\x0\x77\x7f\x7f\x3e\x1c\x8\x0\x8\x1c\x3e\x7f\x3e\x1c\x8\x0\x18\x3c\x18\xff\xff\x52\x18\x0\x8\x1c\x3e\x7f\x7f\x49\x1c\x0\x0\x0\x18\x3c\x18\x0\x0\x0"
"\xff\xff\xe7\xc3\xe7\xff\xff\xff\x0\x3c\x42\x81\x81\x42\x3c\x0\xff\xc3\xbd\x7e\x7e\xbd\xc3\xff\xf8\xe0\xb0\x3e\x63\x63\x3e\x0\x0\x7e\xc3\xc3\x7e\x18\x7e\x18\x20\x60\xe0\x20\x20\x3f\x1f\x0\x30\x50\xb0\xd0\x9f\x8f\xf0\xf0\x81\xc2\xbc\xe4\xa4\xfc\xea\xff"
"\x0\x0\x6\x1e\x7e\x1e\x6\x0\x0\x0\x60\x78\x7e\x78\x60\x0\x18\x7e\x18\x18\x18\x18\x7e\x18\x66\x66\x66\x66\x66\x0\x66\x0\xff\x6d\x6e\x6c\x6c\x6c\x6c\x0\x7e\x81\x3e\x42\x42\x7c\x81\x7e\x0\x0\x0\x7e\x7e\x0\x0\x0\x18\x7e\x18\x18\x7e\x18\x0\xff"
"\x18\x7e\x18\x18\x18\x18\x18\x0\x18\x18\x18\x18\x18\x7e\x18\x0\x0\x20\x60\xff\x60\x20\x0\x0\x0\x4\x6\xff\x6\x4\x0\x0\x0\x0\x0\x3\x3\x3\xff\x0\x0\x24\x66\xff\x66\x24\x0\x0\x0\x0\x8\x1c\x3e\x7f\x0\x0\x0\x0\x0\x7f\x3e\x1c\x8\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\xc\xc\xc\xc\xc\x0\xc\x0\x66\x66\x0\x0\x0\x0\x0\x0\xa\x1f\xa\x1f\xa\x0\x0\x0\x3e\x4b\xb\x3e\x68\x6b\x3e\x8\xc7\x65\x37\x18\xec\xa6\xe3\x0\x1c\x32\x1c\xa2\x63\x73\x5e\x80\x30\x30\x18\x0\x0\x0\x0\x0"
"\x8\x6\x3\x3\x3\x6\x8\x0\x8\x30\x60\x60\x60\x30\x8\x0\x0\x2a\x1c\x7f\x1c\x2a\x0\x0\x0\x18\x18\x7e\x18\x18\x0\x0\x0\x0\x0\x0\x0\x0\x18\xe\x0\x0\x0\x7e\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x30\x0\x80\xc0\x60\x30\x18\xc\x6\x3"
"\x3c\x66\x66\x66\x66\x66\x3c\x0\x18\x1c\x18\x18\x18\x18\x3c\x0\x3e\x63\x60\x30\xc\x6\x7f\x0\x3e\x63\x60\x3c\x60\x63\x3e\x0\x70\x78\x6c\x66\x7f\x60\x60\x0\x7f\x3\x3\x3f\x60\x60\x3f\x0\x3e\x63\x3\x3f\x63\x63\x3e\x0\x7f\x60\x30\x18\xc\xc\xc\x0"
"\x3e\x63\x63\x3e\x63\x63\x3e\x0\x3e\x63\x63\x7e\x60\x63\x3e\x0\x0\xc\x0\x0\x0\xc\x0\x0\x0\xc\x0\x0\x0\xc\x4\x0\x0\x38\xc\x6\xc\x38\x0\x0\x0\x0\x7e\x0\x7e\x0\x0\x0\x0\xe\x18\x30\x18\xe\x0\x0\x3e\x63\x30\x18\xc\x0\xc\x0"
"\x3e\x41\x5d\x55\x7d\x1\x3e\x0\x1c\x36\x63\x63\x7f\x63\x63\x0\x3f\x63\x63\x3f\x63\x63\x3f\x0\x3e\x63\x3\x3\x63\x63\x3e\x0\x3f\x63\x63\x63\x63\x63\x3f\x0\x7f\x3\x3\x1f\x3\x3\x7f\x0\x7f\x43\x3\x1f\x13\x3\x3\x0\x3e\x63\x3\x7b\x43\x63\x5e\x0"
"\x63\x63\x63\x7f\x63\x63\x63\x0\x7e\x18\x18\x18\x18\x18\x7e\x0\x78\x30\x30\x30\x30\x33\x1e\x0\x63\x33\x1b\xf\x1b\x33\x63\x0\xf\x6\x6\x6\x6\x46\x7f\x0\x63\x77\x7f\x6b\x6b\x63\x63\x0\x63\x67\x6f\x7b\x73\x63\x63\x0\x3e\x63\x63\x63\x63\x63\x3e\x0"
"\x3f\x66\x66\x3e\x6\x6\xf\x0\x3e\x63\x63\x63\x7b\x73\x3e\x60\x3f\x66\x66\x3e\x66\x66\x67\xc0\x3e\x43\x3\x3e\x60\x63\x3e\x0\x7e\x18\x18\x18\x18\x18\x18\x0\x63\x63\x63\x63\x63\x63\x3e\x0\x63\x63\x63\x63\x63\x36\x1c\x0\x63\x63\x6b\x6b\x6b\x77\x63\x0"
"\x63\x36\x1c\x8\x1c\x36\x63\x0\x41\x63\x36\x1c\x8\x8\x1c\x0\x7f\x61\x30\x18\xc\x46\x7f\x0\x38\x18\x18\x18\x18\x18\x18\x38\x3\x6\xc\x18\x30\x60\xc0\x80\xe\xc\xc\xc\xc\xc\xc\xe\x8\x1c\x36\x63\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\xff"
"\xc\xc\x18\x0\x0\x0\x0\x0\x0\x0\x3e\x60\x7e\x63\x7e\x0\x3\x3\x3f\x63\x63\x63\x3f\x0\x0\x0\x3e\x63\x3\x63\x3e\x0\x60\x60\x7e\x63\x63\x63\x7e\x0\x0\x0\x3e\x63\x7f\x3\x3e\x0\x3c\x66\x6\x3f\x6\x6\x6\x0\x0\x0\xbe\x63\x63\x7e\x60\x3e"
"\x3\x3\x3f\x63\x63\x63\x63\x0\x18\x0\x1c\x18\x18\x18\x3c\x0\x30\x0\x38\x30\x30\x30\x33\x1e\x3\x3\x63\x1b\xf\x1b\x63\x0\x1c\x18\x18\x18\x18\x18\x38\x0\x0\x0\x63\x7f\x6b\x6b\x63\x0\x0\x0\x3f\x63\x63\x63\x63\x0\x0\x0\x3e\x63\x63\x63\x3e\x0"
"\x0\x0\x3f\x63\x63\x3f\x3\x3\x0\x0\x7e\x63\x63\x7e\x60\xe0\x0\x0\x7b\x6e\x66\x6\x6\x0\x0\x0\x7e\x3\x3e\x60\x3f\x0\x18\x18\x7e\x18\x18\x18\x78\x0\x0\x0\x63\x63\x63\x63\x7e\x0\x0\x0\x63\x63\x63\x36\x1c\x0\x0\x0\x63\x6b\x6b\x77\x63\x0"
"\x0\x0\x63\x36\x1c\x36\x63\x0\x0\x0\x63\x63\x63\x7e\x60\x3f\x0\x0\x7f\x30\x8\x46\x7f\x0\x70\x18\x18\xe\x18\x18\x70\x0\x18\x18\x18\x0\x18\x18\x18\x0\x7\xc\xc\x38\xc\xc\x7\x0\xe\xd9\x70\x0\x0\x0\x0\x0\x0\x0\x8\x14\x22\x7f\x0\x0"
"\xff\x1\x1\x1\x1\x1\x1\x1\xff\x0\x0\x0\x0\x0\x0\x0\xff\x80\x80\x80\x80\x80\x80\x80\x1\x1\x1\x1\x1\x1\x1\x1\x80\x80\x80\x80\x80\x80\x80\x80\x1\x1\x1\x1\x1\x1\x1\xff\x0\x0\x0\x0\x0\x0\x0\xff\x80\x80\x80\x80\x80\x80\x80\xff"
"\x1\x0\x0\x0\x0\x0\x0\x0\x80\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x1\x0\x0\x0\x0\x0\x0\x0\x80\x1\x3\x7\xf\x1f\x3f\x7f\xff\xff\xfe\xfc\xf8\xf0\xe0\xc0\x80\xff\xff\x3\x3\x3\x3\x3\x3\xff\xff\x0\x0\x0\x0\x0\x0"
"\xff\xff\xc0\xc0\xc0\xc0\xc0\xc0\x3\x3\x3\x3\x3\x3\x3\x3\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\x3\x3\x3\x3\x3\x3\xff\xff\x0\x0\x0\x0\x0\x0\xff\xff\xc0\xc0\xc0\xc0\xc0\xc0\xff\xff\x3\x3\x0\x0\x0\x0\x0\x0\xc0\xc0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x3\x3\x0\x0\x0\x0\x0\x0\xc0\xc0\x0\x0\x0\x55\x0\x0\x0\x0\x0\x3f\x3f\x3f\x3f\x3f\x3f\x0\x0\x7e\x7e\x7e\x7e\x7e\x7e\x0\x0\xfc\xfc\xfc\xfc\xfc\xfc\x0\x0\xf8\xf8\xf8\xf8\xf8\xf8\x0\x0\xf0\xf0\xf0\xf0\xf0\xf0\x0"
"\x0\xe0\xe0\xe0\xe0\xe0\xe0\x0\x0\xc0\xc0\xc0\xc0\xc0\xc0\x0\x0\x80\x80\x80\x80\x80\x80\x0\x0\x1\x1\x1\x1\x1\x1\x0\x0\x3\x3\x3\x3\x3\x3\x0\x0\x7\x7\x7\x7\x7\x7\x0\x0\xf\xf\xf\xf\xf\xf\x0\x0\x1f\x1f\x1f\x1f\x1f\x1f\x0"
"\x55\x6b\x55\x6b\x55\x6b\x55\x6b\xff\xff\x0\x0\x0\x8\x1c\x3e\xff\xff\x0\x0\x0\x0\x0\x7f\xff\xff\x0\x0\x8\x1c\x3e\x7f\xff\xff\x0\xc3\xe7\xff\xdb\xc3\x0\x0\x0\x0\x18\x0\x0\x0\x0\x3\x3\x3\x3\x3\x3\x3\x0\x1b\x1b\x1b\x1b\x1b\x1b\x1b"
"\x0\xdb\xdb\xdb\xdb\xdb\xdb\xdb\x0\x6\x6\x6\x6\x6\x6\x6\x0\x36\x36\x36\x36\x36\x36\x36\x0\xb6\xb6\xb6\xb6\xb6\xb6\xb6\x0\x1\x1\x1\x1\x1\x1\x1\x0\xd\xd\xd\xd\xd\xd\xd\x0\x6d\x6d\x6d\x6d\x6d\x6d\x6d\x0\x0\x18\x3c\x3c\x18\x0\x0"
"\x0\x0\x0\x1f\x18\x1f\x18\x18\x6c\x6c\x6c\x6f\x60\x6f\x6c\x6c\x6c\x6c\x6c\x6c\x6c\x6c\x6c\x6c\x0\x0\x0\x7f\x60\x6f\x6c\x6c\x6c\x6c\x6c\x6f\x60\x7f\x0\x0\x6c\x6c\x6c\x7f\x0\x0\x0\x0\x18\x18\x18\x1f\x18\x1f\x0\x0\x0\x0\x0\x1f\x18\x18\x18\x18"
"\x18\x18\x18\xf8\x0\x0\x0\x0\x18\x18\x18\xff\x0\x0\x0\x0\x0\x0\x0\xff\x18\x18\x18\x18\x18\x18\x18\xf8\x18\x18\x18\x18\x0\x0\x0\x0\xff\x0\x0\x0\x18\x18\x18\xff\x18\x18\x18\x18\x18\x18\x18\xf8\x18\xf8\x18\x18\x6c\x6c\x6c\xec\x6c\x6c\x6c\x6c"
"\x6c\x6c\x6c\xec\xc\xfc\x0\x0\x0\x0\x0\xfc\xc\xec\x6c\x6c\x6c\x6c\x6c\xef\x0\xff\x0\x0\x0\x0\x0\xff\x0\xef\x6c\x6c\x6c\x6c\x6c\xec\xc\xec\x6c\x6c\x0\x0\x0\xff\x0\xff\x0\x0\x6c\x6c\x6c\xef\x0\xef\x6c\x6c\x18\x18\x18\xff\x0\xff\x0\x0"
"\x6c\x6c\x6c\xff\x0\x0\x0\x0\x0\x0\x0\xff\x0\xff\x18\x18\x0\x0\x0\xff\x6c\x6c\x6c\x6c\x6c\x6c\x6c\xfc\x0\x0\x0\x0\x18\x18\x18\xf8\x18\xf8\x0\x0\x0\x0\x0\xf8\x18\xf8\x18\x18\x0\x0\x0\xfc\x6c\x6c\x6c\x6c\x6c\x6c\x6c\xff\x6c\x6c\x6c\x6c"
"\x18\x18\x18\xff\x18\xff\x18\x18\x18\x18\x18\x1f\x0\x0\x0\x0\x0\x0\x0\xf8\x18\x18\x18\x18\xff\xff\xff\xff\xff\xff\xff\xff\x0\x0\x0\x0\xff\xff\xff\xff\xf\xf\xf\xf\xf\xf\xf\xf\xf0\xf0\xf0\xf0\xf0\xf0\xf0\xf0\xff\xff\xff\xff\x0\x0\x0\x0"
"\x0\x0\xee\x19\x19\xee\x0\x0\x38\x6c\x66\x3f\x63\x63\x3f\x3\x7f\x46\x6\x6\x6\x6\x6\x0\x0\x0\xff\x66\x66\x66\x66\x0\x7f\x46\xc\x18\xc\x46\x7f\x0\x0\x0\xfc\x66\x63\x33\x1e\x0\x0\x0\xcc\xcc\xcc\x7c\xc\xf\x0\x0\xff\x18\x18\x18\x18\x0"
"\x3c\x18\x3c\x66\x66\x3c\x18\x3c\x0\x3e\x63\x7f\x63\x3e\x0\x0\x0\x7e\xc3\xc3\xc3\x66\xe7\x0\x78\x98\x3c\x66\x63\x33\x1e\x0\x0\x0\x66\x99\x99\x66\x0\x0\x0\xc0\x3e\x73\x67\x3e\x3\x0\x0\x7c\x3\x7f\x3\x7c\x0\x0\x0\x0\x0\x0\x0\xdb\xdb\x0"
"\x0\x7e\x0\x7e\x0\x7e\x0\x0\x0\xf8\x8\x8\x8\x8\xf8\x0\x0\xff\x0\x0\x0\x0\xff\x0\x0\x1f\x10\x10\x10\x10\x1f\x0\x0\x0\x0\x8\x0\x0\x0\x0\x0\x0\x0\x2\x1\x0\x0\x0\x20\x30\x28\x24\x22\xa1\x60\x20\x0\x0\x0\x1\x2\x0\x0\x0"
"\x20\x60\xa1\x22\x24\x28\x30\x20\x0\x0\x0\x40\x40\x40\x40\x7f\xff\x81\x81\x81\x81\x80\x80\x80\x0\x0\x0\x20\x20\x11\x11\xe\x38\x44\x44\x82\x82\x0\x0\x0\x0\x0\xfe\x7c\x38\x10\x0\x0\x0\x0\x10\x38\x7c\xfe\x0\x0\x80\xc1\x63\x36\x1c\x8\x0\x0"
),
// Font no. 1
FontEntry("ATHENA", 12, 12, 
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x70\x80\xf\xf8\x80\xf\xf8\x0\x7\x70\x0\x0\x0\x0\x7\x70\x0\x0\xdc\xc1\x1d\x10\x1\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\xe0\x38\x8e\xf3\x7f\x8e\xe3\x38\x8e"
"\xe3\x38\xff\xe7\x38\x8e\x3\x0\x50\x0\x5\xfe\x73\x5\x57\xe0\x3f\x50\x7\x75\xfe\x3\x5\x50\x0\x0\x0\x0\x1c\xc7\x71\xe\xe0\x0\x7\x70\x80\x3\x38\xc7\x71\x1c\x0\x0\xfe\x70\x18\x87\xf1\xc\x7e\xc0\x3\x76\x32\x3e\xc3\x71\x3c\x7e\x7\x0\x70\x0"
"\x7\x40\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\xf0\x80\x3\x38\x80\x3\x38\x80\x3\x38\x80\x3\x38\x80\x3\xf0\x0\x0\x78\x0\xe\xe0\x0\xe\xe0\x0\xe\xe0\x0\xe\xe0\x0\xe\x78\x0\x0\x0\x0\x2\x70\x80\xf\xff\xe7\x3f\xfc\xc1\x1f"
"\x8e\x33\x60\x0\x0\x0\x0\x0\x7\x70\x0\x7\x70\xf0\x7f\x70\x0\x7\x70\x0\x7\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x7\x70\x0\x4\x0\x0\x0\x0\x0\x0\x0\xf0\x7f\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x7\x70\x0\x0\x0\x0\x1c\xc0\x1\xe\xe0\x0\x7\x70\x80\x3\x38\xc0\x1\x1c\x0\x0\xfe\x73\x70\x7\x77\x70\x7\x77\x70\x7\x77\x70\x7\x77\x70\xfe\x3\x0\x70\x80\x7\x70\x0\x7\x70\x0\x7\x70\x0\x7\x70\x0"
"\x7\xfe\x3\x0\xfe\x73\x70\x7\x7\x38\xc0\x1\xe\x70\x80\x3\x1c\xe0\x0\xff\x7\x0\xfe\x73\x70\x7\x7\x70\xe0\x3\x70\x0\x7\x70\x7\x77\x70\xfe\x3\x0\x7\x77\x70\x7\x77\x70\xfe\x7\x70\x0\x7\x70\x0\x7\x70\x0\x7\x0\xff\x77\x0\x7\x70\x0"
"\xff\x3\x70\x0\x7\x70\x7\x77\x70\xfe\x3\x0\xfe\x73\x0\x7\x70\x0\xff\x73\x70\x7\x77\x70\x7\x77\x70\xfe\x3\x0\xff\x7\x70\x0\x7\x38\x80\x3\x7f\xc0\x1\xe\xe0\x0\x7\x70\x0\x0\xfe\x73\x70\x7\x77\x70\xfe\x73\x70\x7\x77\x70\x7\x77\x70\xfe"
"\x3\x0\xfe\x73\x70\x7\x77\x70\x7\x77\x70\xfe\x7\x70\x0\x7\x70\xfe\x3\x0\x0\x0\x0\x0\x0\x0\x0\x0\x7\x70\x0\x0\x0\x0\x7\x70\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x7\x70\x0\x0\x0\x0\x7\x70\x0\x4\x0\x0\x0\xc0\x1\xe\x70\x80"
"\x3\x1c\x80\x3\x70\x0\xe\xc0\x1\x0\x0\x0\x0\x0\xe0\x3f\x0\x0\x0\x0\xe0\x3f\x0\x0\x0\x0\x0\x0\x0\x0\x0\x1c\x80\x3\x70\x0\xe\xc0\x1\xe\x70\x80\x3\x1c\x0\x0\xfe\x73\x70\x0\x7\x70\x0\x7\x3e\x70\x0\x7\x0\x0\x7\x70\x0\x0"
"\xfc\xe1\x38\x67\x77\x7b\x37\x77\x73\x37\x77\x73\xe7\xe3\x0\xfc\x1\x0\xfe\x73\x70\x7\x77\x70\xff\x77\x70\x7\x77\x70\x7\x77\x70\x7\x7\x0\xff\x73\x70\x7\x77\x70\xff\x73\x70\x7\x77\x70\x7\x77\x70\xff\x3\x0\xfe\x73\x70\x7\x70\x0\x7\x70\x0\x7"
"\x70\x0\x7\x70\x70\xfe\x3\x0\xff\x71\x38\x7\x77\x70\x7\x77\x70\x7\x77\x70\x7\x77\x38\xff\x1\x0\xff\x77\x0\x7\x70\x0\x7f\x70\x0\x7\x70\x0\x7\x70\x0\xff\x7\x0\xff\x77\x0\x7\x70\x0\x7f\x70\x0\x7\x70\x0\x7\x70\x0\x7\x0\x0\xfe\x73"
"\x70\x7\x70\x0\xc7\x77\x70\x7\x77\x70\x7\x77\x70\xfe\x3\x0\x7\x77\x70\x7\x77\x70\xff\x77\x70\x7\x77\x70\x7\x77\x70\x7\x7\x0\xff\x7\x7\x70\x0\x7\x70\x0\x7\x70\x0\x7\x70\x0\x7\xff\x7\x0\xfe\x7\x70\x0\x7\x70\x0\x7\x70\x0\x7\x70"
"\x0\x77\x70\xfe\x3\x0\x7\x77\x70\x7\x77\x38\xff\x71\x38\x7\x77\x70\x7\x77\x70\x7\x7\x0\x7\x70\x0\x7\x70\x0\x7\x70\x0\x7\x70\x0\x7\x70\x0\xff\x7\x0\x3\x76\x70\x8f\xf7\x7d\xff\x77\x77\x27\x77\x70\x7\x77\x70\x7\x7\x0\x3\x77\x70\xf"
"\xf7\x71\x3f\x77\x77\xe7\x77\x7c\x87\x77\x70\x7\x6\x0\xfe\x73\x70\x7\x77\x70\x7\x77\x70\x7\x77\x70\x7\x77\x70\xfe\x3\x0\xff\x73\x70\x7\x77\x70\xff\x73\x0\x7\x70\x0\x7\x70\x0\x7\x0\x0\xfe\x73\x70\x7\x77\x70\x7\x77\x70\x7\x77\x76\xe7\x77"
"\x7c\xbe\x3\x30\xff\x73\x70\x7\x77\x70\xff\x73\x70\x7\x77\x70\x7\x77\x70\x7\x7\x0\xfe\x73\x70\x7\x70\x0\xfe\x3\x70\x0\x7\x70\x0\x77\x70\xfe\x3\x0\xff\x7\x7\x70\x0\x7\x70\x0\x7\x70\x0\x7\x70\x0\x7\x70\x0\x0\x7\x77\x70\x7\x77\x70"
"\x7\x77\x70\x7\x77\x70\x7\x77\x70\xfe\x3\x0\x7\x77\x70\x7\x77\x70\x7\x77\x70\x7\x77\x70\x8e\xc3\x1d\xf8\x0\x0\x7\x77\x70\x7\x77\x70\x27\x77\x77\xff\xf7\x7d\x8f\x77\x70\x3\x6\x0\x7\x77\x70\x7\xe7\x38\xfc\xe1\x38\x7\x77\x70\x7\x77\x70\x7"
"\x7\x0\x7\x77\x70\x7\x77\x70\xfe\x7\x70\x0\x7\x70\x0\x7\x70\xfc\x3\x0\xff\x7\x70\x80\x3\x1c\xe0\x0\x7\x38\xc0\x1\xe\x70\x0\xff\x7\x0\xf8\x80\x3\x38\x80\x3\x38\x80\x3\x38\x80\x3\x38\x80\x3\xf8\x0\x0\x0\xc0\x1\x1c\x80\x3\x38\x0"
"\x7\x70\x0\xe\xe0\x0\x1c\xc0\x1\x0\xf8\x0\xe\xe0\x0\xe\xe0\x0\xe\xe0\x0\xe\xe0\x0\xe\xf8\x0\x0\x20\x0\x7\xf8\xc0\x1d\x8e\x3\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\xff\x7\x0"
"\x70\x0\x7\x40\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\xe0\x3f\x0\x7\x70\xfe\x77\x70\x7\x77\x70\xfe\x7\x0\x7\x70\x0\x7\xf0\x3f\x7\x77\x70\x7\x77\x70\x7\x77\x70\xff\x3\x0\x0\x0\x0\x0\xe0\x3f\x7\x77\x0\x7"
"\x70\x0\x7\x70\x70\xfe\x3\x0\x0\x7\x70\x0\xe7\x7f\x7\x77\x70\x7\x77\x70\x7\x77\x70\xfe\x7\x0\x0\x0\x0\x0\xe0\x3f\x7\x77\x70\xff\x77\x0\x7\x70\x70\xfe\x3\x0\xe0\x3\x7\x70\x0\x7\x70\xe0\x3f\x70\x0\x7\x70\x0\x7\x70\x0\x0\x0\x0"
"\x0\x0\xe0\x3f\x7\x77\x70\xfe\x7\x70\x0\x77\x70\xfe\x3\x0\x7\x70\x0\x7\xf0\x3f\x7\x77\x70\x7\x77\x70\x7\x77\x70\x7\x7\x0\x0\x0\x7\x0\xe0\x3f\x70\x0\x7\x70\x0\x7\x70\x0\x7\xfe\x3\x0\x0\x0\x70\x0\x0\x70\x0\x7\x70\x0\x7\x70"
"\x0\x77\x70\xfe\x3\x0\x7\x70\x0\x7\x77\x70\x7\x77\x38\xff\x71\x38\x7\x77\x70\x7\x7\x0\x0\x80\x3\x38\x80\x3\x38\x80\x3\x38\x80\x3\x38\x80\x3\xf0\x1\x0\x0\x0\x0\x0\xe0\x3f\x27\x77\x72\x27\x77\x72\x7\x77\x70\x7\x7\x0\x0\x0\x0\x0"
"\xe0\x3f\x7\x77\x70\x7\x77\x70\x7\x77\x70\x7\x7\x0\x0\x0\x0\x0\xe0\x3f\x7\x77\x70\x7\x77\x70\x7\x77\x70\xfe\x3\x0\x0\x0\x0\x0\xf0\x3f\x7\x77\x70\x7\x77\x70\x7\xf7\x3f\x7\x70\x0\x0\x0\x0\x0\xe0\x7f\x7\x77\x70\x7\x77\x70\x7\xe7"
"\x7f\x0\x7\x70\x0\x0\x0\x0\xe0\x3f\x7\x77\x0\x7\x70\x0\x7\x70\x0\x7\x0\x0\x0\x0\x0\x0\xe0\x3f\x7\x70\x0\xfe\x1\x70\x0\x7\x70\xfe\x3\x0\x0\x70\x0\x7\x70\x0\x7\xf0\x3\x7\x70\x0\x7\x77\x70\xfe\x3\x0\x0\x0\x0\x0\x70\x70"
"\x7\x77\x70\x7\x77\x70\x7\x77\x70\xfe\x3\x0\x0\x0\x0\x0\x70\x70\x7\x77\x70\x7\x77\x70\x8e\xc3\x1d\xf8\x0\x0\x0\x0\x0\x0\x70\x70\x7\x77\x70\x27\x77\x72\x27\x77\x72\xfe\x3\x0\x0\x0\x0\x0\x70\x70\x7\x77\x70\xfe\x73\x70\x7\x77\x70\x7"
"\x7\x0\x0\x0\x0\x0\x70\x70\x7\x77\x70\xfe\x7\x70\x0\x77\x70\xfe\x3\x0\x0\x0\x0\x0\xf0\x7f\xc0\x3\x1e\xf0\x80\x7\x3c\xe0\x1\xff\x7\x0\xf0\x80\x3\x38\x80\x3\x70\xc0\xf\x70\x80\x3\x38\x80\x3\xf0\x0\x0\x70\x0\x7\x70\x0\x7\x70\x0"
"\x7\x70\x0\x7\x70\x0\x7\x70\x0\x0\x78\x0\xe\xe0\x0\xe\x70\x80\x1f\x70\x0\xe\xe0\x0\xe\x78\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\xf0\xff\xff\xf\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\xf0\xff\x7\x70\x0\x7\x70\x0\xff\xf"
"\x0\x0\x0\x0\x0\x0\x0\x0\xf0\xff\x0\x0\x0\x0\x0\x0\xff\xf\x0\x0\x0\x0\x0\x0\x0\x0\xf0\xff\x0\xe\xe0\x0\xe\xe0\xff\xf\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\xc0\x1f\xf8\x80\xf\x70\x0\x7\x20\x0\x2\x0\x0\x0\x0\x0\x0\x20\x0\x2\x70\x0\x7\xf8\x80\xf\xfc\x1\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
),
// Font no. 2
FontEntry("ATHENA_SPACED", 12, 12, 
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x70\x80\xf\xf8\x80\xf\xf8\x0\x7\x70\x0\x0\x70\x0\x7\x0\x0\x0\xdc\xc1\x1d\x10\x1\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\xe0\x38\x8e\xf3\x7f\x8e\xe3\x38\x8e"
"\xf3\x7f\x8e\xe3\x38\x0\x0\x0\x50\x0\x5\xfe\x73\x5\xfe\x3\x75\x50\xe7\x3f\x50\x0\x5\x0\x0\x0\x0\x0\x0\xe7\x70\xe\x70\x0\x7\x38\x80\x3\x1c\xc7\x71\x0\x0\x0\xfe\x70\x18\xcf\xe0\x7\x3c\x60\x27\xe3\x33\x1c\xc7\xe3\x77\x0\x0\x0\x70\x0"
"\x7\x40\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\xf0\x80\x3\x38\x80\x3\x38\x80\x3\x38\x80\x3\x38\x0\xf\x0\x0\x0\x78\x0\xe\xe0\x0\xe\xe0\x0\xe\xe0\x0\xe\xe0\x80\x7\x0\x0\x0\x0\x0\x2\x70\x80\xf\xff\xe7\x3f\xfc\xc1\x1f"
"\x8e\x33\x60\x0\x0\x0\x0\x0\x0\x70\x0\x7\x70\xf0\x7f\x70\x0\x7\x70\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x70\x0\x7\x40\x0\x0\x0\x0\x0\x0\x0\x0\x0\xf0\x7f\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x70\x0\x7\x0\x0\x0\xc0\x1\x1c\xe0\x0\xe\x70\x0\x7\x38\x80\x3\x1c\xc0\x1\x0\x0\x0\xfe\x73\x70\x7\x77\x70\x7\x77\x70\x7\x77\x70\x7\xe7\x3f\x0\x0\x0\x70\x80\x7\x70\x0\x7\x70\x0\x7\x70\x0\x7\x70\xe0"
"\x3f\x0\x0\x0\xfe\x73\x70\x87\x3\x1c\xe0\x0\x7\x38\xc0\x1\xe\xf0\x7f\x0\x0\x0\xfe\x73\x70\x7\x7\x70\xe0\x3\x70\x0\x77\x70\x7\xe7\x3f\x0\x0\x0\x7\x77\x70\x7\x77\x70\xfe\x7\x70\x0\x7\x70\x0\x7\x70\x0\x0\x0\xff\x77\x0\x7\x70\x0"
"\xff\x3\x70\x0\x77\x70\x7\xe7\x3f\x0\x0\x0\xfe\x73\x0\x7\x70\x0\xff\x73\x70\x7\x77\x70\x7\xe7\x3f\x0\x0\x0\xff\x7\x70\x0\x7\x38\x80\x3\x7f\xc0\x1\xe\xe0\x0\x7\x0\x0\x0\xfe\x73\x70\x7\x77\x70\xfe\x73\x70\x7\x77\x70\x7\xe7\x3f\x0"
"\x0\x0\xfe\x73\x70\x7\x77\x70\x7\xe7\x7f\x0\x7\x70\x0\xe7\x3f\x0\x0\x0\x0\x0\x0\x0\x0\x0\x70\x0\x7\x0\x0\x0\x70\x0\x7\x0\x0\x0\x0\x0\x0\x0\x0\x0\x70\x0\x7\x0\x0\x0\x70\x0\x7\x40\x0\x0\x0\x0\x1c\xe0\x0\x7\x38\xc0"
"\x1\x38\x0\x7\xe0\x0\x1c\x0\x0\x0\x0\x0\x0\x0\xe0\x3f\x0\x0\x0\x0\xe0\x3f\x0\x0\x0\x0\x0\x0\x0\xc0\x1\x38\x0\x7\xe0\x0\x1c\xe0\x0\x7\x38\xc0\x1\x0\x0\x0\xfe\x73\x70\x0\x7\x70\xe0\x3\x7\x70\x0\x0\x70\x0\x7\x0\x0\x0"
"\xfc\xe1\x38\x67\x77\x7b\x37\x77\x73\x37\x77\x3e\xe\xc0\x1f\x0\x0\x0\xfe\x73\x70\x7\x77\x70\xff\x77\x70\x7\x77\x70\x7\x77\x70\x0\x0\x0\xff\x73\x70\x7\x77\x70\xff\x73\x70\x7\x77\x70\x7\xf7\x3f\x0\x0\x0\xfe\x73\x70\x7\x70\x0\x7\x70\x0\x7"
"\x70\x0\x7\xe7\x3f\x0\x0\x0\xff\x71\x38\x7\x77\x70\x7\x77\x70\x7\x77\x70\x87\xf3\x1f\x0\x0\x0\xff\x77\x0\x7\x70\x0\x7f\x70\x0\x7\x70\x0\x7\xf0\x7f\x0\x0\x0\xff\x77\x0\x7\x70\x0\x7f\x70\x0\x7\x70\x0\x7\x70\x0\x0\x0\x0\xfe\x73"
"\x70\x7\x70\x0\xc7\x77\x70\x7\x77\x70\x7\xe7\x3f\x0\x0\x0\x7\x77\x70\x7\x77\x70\xff\x77\x70\x7\x77\x70\x7\x77\x70\x0\x0\x0\xff\x7\x7\x70\x0\x7\x70\x0\x7\x70\x0\x7\x70\xf0\x7f\x0\x0\x0\xfe\x7\x70\x0\x7\x70\x0\x7\x70\x0\x7\x70"
"\x7\xe7\x3f\x0\x0\x0\x7\x77\x70\x7\x77\x38\xff\x71\x38\x7\x77\x70\x7\x77\x70\x0\x0\x0\x7\x70\x0\x7\x70\x0\x7\x70\x0\x7\x70\x0\x7\xf0\x7f\x0\x0\x0\x3\x76\x70\x8f\xf7\x7d\xff\x77\x77\x27\x77\x70\x7\x77\x70\x0\x0\x0\x3\x77\x70\xf"
"\xf7\x71\x3f\x77\x77\xe7\x77\x7c\x87\x77\x70\x0\x0\x0\xfe\x73\x70\x7\x77\x70\x7\x77\x70\x7\x77\x70\x7\xe7\x3f\x0\x0\x0\xff\x73\x70\x7\x77\x70\xff\x73\x0\x7\x70\x0\x7\x70\x0\x0\x0\x0\xfe\x73\x70\x7\x77\x70\x7\x77\x70\x67\x77\x7e\xc7\xe7"
"\x3b\x0\x3\x0\xff\x73\x70\x7\x77\x70\xff\x73\x70\x7\x77\x70\x7\x77\x70\x0\x0\x0\xfe\x73\x70\x7\x70\x0\xfe\x3\x70\x0\x7\x70\x7\xe7\x3f\x0\x0\x0\xff\x7\x7\x70\x0\x7\x70\x0\x7\x70\x0\x7\x70\x0\x7\x0\x0\x0\x7\x77\x70\x7\x77\x70"
"\x7\x77\x70\x7\x77\x70\x7\xe7\x3f\x0\x0\x0\x7\x77\x70\x7\x77\x70\x7\x77\x70\x7\x77\x70\x8e\xc3\x1d\xf8\x0\x0\x7\x77\x70\x7\x77\x72\x77\xf7\x7f\xdf\xf7\x78\x7\x37\x60\x0\x0\x0\x7\x77\x70\x7\xe7\x38\xfc\xe1\x38\x7\x77\x70\x7\x77\x70\x0"
"\x0\x0\x7\x77\x70\x7\x77\x70\xfe\x7\x70\x0\x7\x70\x0\xc7\x3f\x0\x0\x0\xff\x7\x70\x80\x3\x1c\xe0\x0\x7\x38\xc0\x1\xe\xf0\x7f\x0\x0\x0\xf8\x80\x3\x38\x80\x3\x38\x80\x3\x38\x80\x3\x38\x80\xf\x0\x0\x0\x1c\xc0\x1\x38\x80\x3\x70\x0"
"\x7\xe0\x0\xe\xc0\x1\x1c\x0\x0\x0\xf8\x0\xe\xe0\x0\xe\xe0\x0\xe\xe0\x0\xe\xe0\x80\xf\x0\x0\x0\x20\x0\x7\xf8\xc0\x1d\x8e\x3\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\xf0\x7f\x0\x0\x0"
"\x70\x0\x7\x40\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\xfe\x3\x70\x0\xe7\x7f\x7\x77\x70\x7\xe7\x7f\x0\x0\x0\x7\x70\x0\xff\x73\x70\x7\x77\x70\x7\x77\x70\x7\xf7\x3f\x0\x0\x0\x0\x0\x0\xfe\x73\x70\x7\x70\x0\x7"
"\x70\x0\x7\xe7\x3f\x0\x0\x0\x0\x7\x70\xfe\x77\x70\x7\x77\x70\x7\x77\x70\x7\xe7\x7f\x0\x0\x0\x0\x0\x0\xfe\x73\x70\x7\xf7\x7f\x7\x70\x0\x7\xe7\x3f\x0\x0\x0\xe0\x3\x7\x70\x0\x7\xfe\x3\x7\x70\x0\x7\x70\x0\x7\x0\x0\x0\x0\x0"
"\x0\xfe\x73\x70\x7\xe7\x7f\x0\x7\x70\x7\xe7\x3f\x0\x0\x0\x7\x70\x0\xff\x73\x70\x7\x77\x70\x7\x77\x70\x7\x77\x70\x0\x0\x0\x70\x0\x0\xfe\x3\x7\x70\x0\x7\x70\x0\x7\x70\xe0\x3f\x0\x0\x0\x0\x7\x0\x0\x7\x70\x0\x7\x70\x0\x7\x70"
"\x7\xe7\x3f\x0\x0\x0\x7\x70\x70\x7\x77\x70\x87\xf3\x1f\x87\x73\x70\x7\x77\x70\x0\x0\x0\x38\x80\x3\x38\x80\x3\x38\x80\x3\x38\x80\x3\x38\x0\x1f\x0\x0\x0\x0\x0\x0\xfe\x73\x72\x27\x77\x72\x27\x77\x70\x7\x77\x70\x0\x0\x0\x0\x0\x0\xfe"
"\x73\x70\x7\x77\x70\x7\x77\x70\x7\x77\x70\x0\x0\x0\x0\x0\x0\xfe\x73\x70\x7\x77\x70\x7\x77\x70\x7\xe7\x3f\x0\x0\x0\x0\x0\x0\xff\x73\x70\x7\x77\x70\x7\x77\x70\xff\x73\x0\x7\x0\x0\x0\x0\x0\xfe\x77\x70\x7\x77\x70\x7\x77\x70\xfe\x7"
"\x70\x0\x7\x0\x0\x0\x0\xfe\x73\x70\x7\x70\x0\x7\x70\x0\x7\x70\x0\x0\x0\x0\x0\x0\x0\xfe\x73\x0\x7\xe0\x1f\x0\x7\x70\x0\xe7\x3f\x0\x0\x0\x0\x70\x0\x7\x70\x0\x3f\x70\x0\x7\x70\x70\x7\xe7\x3f\x0\x0\x0\x0\x0\x0\x7\x77\x70"
"\x7\x77\x70\x7\x77\x70\x7\xe7\x3f\x0\x0\x0\x0\x0\x0\x7\x77\x70\x7\x77\x70\x7\xe7\x38\xdc\x81\xf\x0\x0\x0\x0\x0\x0\x7\x77\x70\x7\x77\x72\x27\x77\x72\x27\xe7\x3f\x0\x0\x0\x0\x0\x0\x7\x77\x70\x7\xe7\x3f\x7\x77\x70\x7\x77\x70\x0"
"\x0\x0\x0\x0\x0\x7\x77\x70\x7\xe7\x7f\x0\x7\x70\x7\xe7\x3f\x0\x0\x0\x0\x0\x0\xff\x7\x3c\xe0\x1\xf\x78\xc0\x3\x1e\xf0\x7f\x0\x0\x0\xf0\x80\x3\x38\x0\x7\xfc\x0\x7\x38\x80\x3\x38\x0\xf\x0\x0\x0\x70\x0\x7\x70\x0\x7\x70\x0"
"\x7\x70\x0\x7\x70\x0\x7\x0\x0\x0\x78\x0\xe\xe0\x0\x7\xf8\x1\x7\xe0\x0\xe\xe0\x80\x7\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\xf0\xff\xff\xf\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\xf0\xff\x7\x70\x0\x7\x70\x0\xff\xf"
"\x0\x0\x0\x0\x0\x0\x0\x0\xf0\xff\x0\x0\x0\x0\x0\x0\xff\xf\x0\x0\x0\x0\x0\x0\x0\x0\xf0\xff\x0\xe\xe0\x0\xe\xe0\xff\xf\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\xc0\x1f\xf8\x80\xf\x70\x0\x7\x20\x0\x2\x0\x0\x0\x0\x0\x0\x20\x0\x2\x70\x0\x7\xf8\x80\xf\xfc\x1\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
),
// Font no. 3
FontEntry("DISORDERTRACKER2", 8, 8, 
"\x0\x0\x0\x0\x0\x0\x0\x0\x57\x51\x73\x54\x57\x0\x0\x0\x77\x21\x23\x21\x21\x0\x0\x0\x0\x0\x0\x0\x18\x0\x0\x0\xec\x4a\x42\x4a\x4e\x0\x0\x0\x13\x15\x13\x15\x75\x0\x0\x0\x3c\x42\x99\x85\x99\x42\x3c\x0\x20\x50\x70\x50\x50\x0\x0\x0"
"\x71\x21\x21\x21\x27\x0\x0\x0\xf3\x1b\x7b\xdb\xdb\xdb\x73\x0\xf\xf\xf\xf\xf\xf\xf\xf\x0\x0\x0\xff\x0\x0\x0\x0\x18\x3c\x7e\x18\x18\x18\x18\x0\x18\x18\x18\x18\x7e\x3c\x18\x0\xfe\xc6\xfe\xc6\xc6\xe6\x67\x3\x0\x0\x0\x80\x41\x22\x14\x8"
"\x0\x0\xf8\x8\x3e\x1c\x8\x0\xf\x7\xf\x5d\x78\x70\x78\x0\x18\x3c\x7e\x18\x18\x7e\x3c\x18\x66\x66\x66\x66\x66\x0\x66\x0\xfe\xdb\xdb\xde\xd8\xd8\xd8\x0\x7c\xc6\x1c\x36\x36\x1c\x61\x3f\x0\x0\x0\x0\x7e\x7e\x7e\x0\x18\x3c\x7e\x18\x7e\x3c\x18\xff"
"\x18\x3c\x7e\x18\x18\x18\x18\x0\x18\x18\x18\x18\x7e\x3c\x18\x0\x0\x18\x30\x7f\x30\x18\x0\x0\x0\xc\x6\x7f\x6\xc\x0\x0\x0\x0\x3\x3\x3\x7f\x0\x0\x0\x24\x66\xff\x66\x24\x0\x0\x0\x0\x18\x3c\x3c\x18\x0\x0\x0\xff\xff\x7e\x3c\x18\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x18\x18\x18\x18\x18\x0\x18\x0\x36\x36\x36\x0\x0\x0\x0\x0\x0\x36\x7f\x36\x36\x7f\x36\x0\x8\x7e\xb\x3e\x68\x6b\x3e\x8\x0\x63\x33\x18\xc\x66\x63\x0\x1c\x36\x1c\x6e\x3b\x33\x6e\x0\xc\xc\x6\x0\x0\x0\x0\x0"
"\xc\x6\x6\x6\x6\x6\xc\x0\x18\x30\x30\x30\x30\x30\x18\x0\x8\x2a\x1c\x7f\x1c\x2a\x8\x0\x0\x18\x18\x7e\x18\x18\x0\x0\x0\x0\x0\x0\x0\x18\x18\xc\x0\x0\x0\x7e\x0\x0\x0\x0\x0\x0\x0\x0\x0\x18\x18\x0\x60\x30\x18\xc\x6\x3\x1\x0"
"\x3e\x63\x63\x6b\x63\x63\x3e\x0\x18\x1c\x18\x18\x18\x18\x3c\x0\x3e\x63\x60\x38\xe\x3\x7f\x0\x3e\x63\x60\x3c\x60\x63\x3e\x0\x63\x63\x63\x7e\x60\x60\x60\x0\x7f\x3\x3\x3f\x60\x63\x3e\x0\x3e\x3\x3\x3f\x63\x63\x3e\x0\x7f\x60\x30\x18\x18\x18\x18\x0"
"\x3e\x63\x63\x3e\x63\x63\x3e\x0\x3e\x63\x63\x7e\x60\x63\x3e\x0\x0\x18\x18\x0\x0\x18\x18\x0\x0\x18\x18\x0\x0\x18\x18\xc\x18\xc\x6\x3\x6\xc\x18\x0\x0\x0\x7e\x0\x7e\x0\x0\x0\x6\xc\x18\x30\x18\xc\x6\x0\x3e\x63\x30\x18\x18\x0\x18\x0"
"\x3e\x63\x7b\x7b\x3b\x3\x3e\x0\x3e\x63\x63\x7f\x63\x63\x63\x0\x3f\x63\x63\x3f\x63\x63\x3f\x0\x3e\x63\x3\x3\x3\x63\x3e\x0\x1f\x33\x63\x63\x63\x63\x3f\x0\x7f\x3\x3\x1f\x3\x3\x7f\x0\x7f\x3\x3\x1f\x3\x3\x3\x0\x7e\x3\x3\x7b\x63\x63\x3e\x0"
"\x63\x63\x63\x7f\x63\x63\x63\x0\x1e\xc\xc\xc\xc\xc\x1e\x0\x7c\x60\x60\x60\x60\x63\x3e\x0\x63\x63\x3f\x33\x63\x63\x63\x0\x3\x3\x3\x3\x3\x3\x7f\x0\x63\x77\x7f\x6b\x63\x63\x63\x0\x63\x67\x6f\x7b\x73\x63\x63\x0\x3e\x63\x63\x63\x63\x63\x3e\x0"
"\x3f\x63\x63\x3f\x3\x3\x3\x0\x3e\x63\x63\x63\x63\x7b\x3e\x60\x3f\x63\x63\x3f\x63\x63\x63\x0\x3e\x63\x3\x3e\x60\x63\x3e\x0\x3f\xc\xc\xc\xc\xc\xc\x0\x63\x63\x63\x63\x63\x63\x3e\x0\x63\x63\x63\x63\x63\x36\x1c\x0\x63\x63\x63\x6b\x7f\x77\x63\x0"
"\x63\x63\x36\x1c\x36\x63\x63\x0\x63\x63\x63\x7e\x60\x63\x3e\x0\x7f\x30\x18\xc\x6\x3\x7f\x0\x1e\x6\x6\x6\x6\x6\x1e\x0\x3\x6\xc\x18\x30\x60\x40\x0\x1e\x18\x18\x18\x18\x18\x1e\x0\x8\x1c\x36\x63\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\xff"
"\xc\xc\x18\x0\x0\x0\x0\x0\x0\x0\x3e\x60\x7c\x66\x7c\x0\x6\x6\x3e\x66\x66\x66\x3e\x0\x0\x0\x3c\x66\x6\x66\x3c\x0\x60\x60\x7c\x66\x66\x66\x7c\x0\x0\x0\x3c\x66\x7e\x6\x3c\x0\x0\x3c\x66\x6\x1e\x6\x6\x0\x0\x0\x7c\x66\x66\x7c\x60\x3e"
"\x6\x6\x3e\x66\x66\x66\x66\x0\x18\x0\x18\x18\x18\x18\x18\x0\x30\x0\x30\x30\x30\x30\x33\x1e\x6\x6\x66\x36\x1e\x36\x66\x0\x18\x18\x18\x18\x18\x18\x18\x0\x0\x0\x3e\x6b\x6b\x6b\x63\x0\x0\x0\x3c\x66\x66\x66\x66\x0\x0\x0\x3c\x66\x66\x66\x3c\x0"
"\x0\x0\x3e\x66\x66\x3e\x6\x6\x0\x0\x7c\x66\x66\x7c\x60\x60\x0\x0\x3e\x66\x6\x6\x6\x0\x0\x0\x7c\x6\x3c\x60\x3e\x0\x6\x6\x3e\x6\x6\x66\x3c\x0\x0\x0\x66\x66\x66\x66\x3c\x0\x0\x0\x66\x66\x66\x3c\x18\x0\x0\x0\x63\x63\x6b\x6b\x3e\x0"
"\x0\x0\x66\x66\x3c\x66\x66\x0\x0\x0\x66\x66\x66\x7c\x60\x3e\x0\x0\x7e\x30\x18\xc\x7e\x0\x38\xc\xc\x7\xc\xc\x38\x0\x18\x18\x18\x0\x18\x18\x18\x0\x7\xc\xc\x38\xc\xc\x7\x0\x6e\x3b\x0\x0\x0\x0\x0\x0\x0\x8\x1c\x36\x63\x63\x7f\x0"
"\x3e\x63\x3\x63\x3e\x30\x60\x3e\x0\x33\x0\x33\x33\x33\x6e\x0\x38\x0\x1e\x33\x3f\x3\x1e\x0\x7e\x81\x3c\x60\x7c\x66\xdc\x0\x33\x0\x1e\x30\x3e\x33\x6e\x0\x7\x0\x1e\x30\x3e\x33\x6e\x0\xc\xc\x1e\x30\x3e\x33\x6e\x0\x0\x0\x3e\x63\x3\x1e\x30\x1c"
"\x7e\x81\x3c\x66\x7e\x6\x3c\x0\x33\x0\x1e\x33\x3f\x3\x1e\x0\x7\x0\x1e\x33\x3f\x3\x1e\x0\x33\x0\xe\xc\xc\xc\x1e\x0\x3e\x41\x1c\x18\x18\x18\x3c\x0\x7\x0\xe\xc\xc\xc\x1e\x0\x63\x8\x3e\x63\x7f\x63\x63\x0\xc\xc\x0\x1e\x33\x3f\x33\x0"
"\x38\x0\x3f\x6\x1e\x6\x3f\x0\x0\x0\xfe\x30\xfe\x33\xfe\x0\x7c\x36\x33\x7f\x33\x33\x73\x0\x1e\x21\x0\x1e\x33\x33\x1e\x0\x0\x33\x0\x1e\x33\x33\x1e\x0\x0\x7\x0\x1e\x33\x33\x1e\x0\x1e\x21\x0\x33\x33\x33\x6e\x0\x0\x7\x0\x33\x33\x33\x6e\x0"
"\x0\x33\x0\x33\x33\x3e\x30\x1f\xc3\x18\x3c\x66\x66\x3c\x18\x0\x33\x0\x33\x33\x33\x33\x1e\x0\x18\x18\x7e\x3\x3\x7e\x18\x18\x1c\x36\x26\xf\x6\x67\x3f\x0\x33\x33\x1e\xc\x3f\xc\x3f\xc\x1f\x33\x33\x5f\x63\xf3\x63\xc3\x70\xd8\x18\x3c\x18\x18\x1b\xe"
"\x38\x0\x1e\x30\x3e\x33\x6e\x0\x1c\x0\xe\xc\xc\xc\x1e\x0\x0\x38\x0\x1e\x33\x33\x1e\x0\x0\x38\x0\x33\x33\x33\x6e\x0\x0\x1f\x0\x1d\x33\x33\x33\x0\x3f\x0\x33\x37\x3f\x3b\x33\x0\x3c\x36\x36\x7c\x0\x7e\x0\x0\x1c\x36\x36\x1c\x0\x3e\x0\x0"
"\x18\x0\x18\x18\xc\x66\x3c\x0\x0\x0\x0\x3f\x3\x3\x0\x0\x0\x0\x0\x3f\x30\x30\x0\x0\x63\x33\x1b\x6c\xd6\x43\x21\xf0\xc3\x63\x33\xdb\xec\xb6\xf3\xc0\x18\x0\x18\x18\x3c\x3c\x18\x0\x0\xcc\x66\x33\x66\xcc\x0\x0\x0\x33\x66\xcc\x66\x33\x0\x0"
"\x44\x11\x44\x11\x44\x11\x44\x11\xaa\x55\xaa\x55\xaa\x55\xaa\x55\xbb\xee\xbb\xee\xbb\xee\xbb\xee\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x1f\x18\x18\x18\x18\x18\x1f\x18\x1f\x18\x18\x18\x6c\x6c\x6c\x6c\x6f\x6c\x6c\x6c\x0\x0\x0\x0\x7f\x6c\x6c\x6c"
"\x0\x0\x1f\x18\x1f\x18\x18\x18\x6c\x6c\x6f\x60\x6f\x6c\x6c\x6c\x6c\x6c\x6c\x6c\x6c\x6c\x6c\x6c\x0\x0\x7f\x60\x6f\x6c\x6c\x6c\x6c\x6c\x6f\x60\x7f\x0\x0\x0\x6c\x6c\x6c\x6c\x7f\x0\x0\x0\x18\x18\x1f\x18\x1f\x0\x0\x0\x0\x0\x0\x0\x1f\x18\x18\x18"
"\x18\x18\x18\x18\xf8\x0\x0\x0\x18\x18\x18\x18\xff\x0\x0\x0\x0\x0\x0\x0\xff\x18\x18\x18\x18\x18\x18\x18\xf8\x18\x18\x18\x0\x0\x0\x0\xff\x0\x0\x0\x18\x18\x18\x18\xff\x18\x18\x18\x18\x18\xf8\x18\xf8\x18\x18\x18\x6c\x6c\x6c\x6c\xec\x6c\x6c\x6c"
"\x6c\x6c\xec\xc\xfc\x0\x0\x0\x0\x0\xfc\xc\xec\x6c\x6c\x6c\x6c\x6c\xef\x0\xff\x0\x0\x0\x0\x0\xff\x0\xef\x6c\x6c\x6c\x6c\x6c\xec\xc\xec\x6c\x6c\x6c\x0\x0\xff\x0\xff\x0\x0\x0\x6c\x6c\xef\x0\xef\x6c\x6c\x6c\x18\x18\xff\x0\xff\x0\x0\x0"
"\x6c\x6c\x6c\x6c\xff\x0\x0\x0\x0\x0\xff\x0\xff\x18\x18\x18\x0\x0\x0\x0\xff\x6c\x6c\x6c\x6c\x6c\x6c\x6c\xfc\x0\x0\x0\x18\x18\xf8\x18\xf8\x0\x0\x0\x0\x0\xf8\x18\xf8\x18\x18\x18\x0\x0\x0\x0\xfc\x6c\x6c\x6c\x6c\x6c\x6c\x6c\xff\x6c\x6c\x6c"
"\x18\x18\xff\x18\xff\x18\x18\x18\x18\x18\x18\x18\x1f\x0\x0\x0\x0\x0\x0\x0\xf8\x18\x18\x18\xff\xff\xff\xff\xff\xff\xff\xff\x0\x0\x0\x0\xff\xff\xff\xff\xf\xf\xf\xf\xf\xf\xf\xf\xf0\xf0\xf0\xf0\xf0\xf0\xf0\xf0\xff\xff\xff\xff\x0\x0\x0\x0"
"\x0\x0\x6e\x3b\x13\x3b\x6e\x0\x0\x1e\x33\x1f\x33\x1f\x3\x3\x0\x3f\x33\x3\x3\x3\x3\x0\x0\x0\x7f\x36\x36\x36\x36\x0\x3f\x33\x6\xc\x6\x33\x3f\x0\x0\x0\x7e\x1b\x1b\x1b\xe\x0\x0\x66\x66\x66\x66\x3e\x6\x3\x0\x6e\x3b\x18\x18\x18\x18\x0"
"\x3f\xc\x1e\x33\x33\x1e\xc\x3f\x1c\x36\x63\x7f\x63\x36\x1c\x0\x1c\x36\x63\x63\x36\x36\x77\x0\x38\xc\x18\x3e\x33\x33\x1e\x0\x0\x0\x7e\xdb\xdb\x7e\x0\x0\x60\x30\x7e\xdb\xdb\x7e\x6\x3\x1c\x6\x3\x1f\x3\x6\x1c\x0\x0\x0\x0\x0\x0\xdb\xdb\x0"
"\x0\x7e\x0\x7e\x0\x7e\x0\x0\x0\xf8\x8\x8\x8\x8\xf8\x0\x0\xff\x0\x0\x0\x0\xff\x0\x0\x1f\x10\x10\x10\x10\x1f\x0\x0\x0\x0\x8\x0\x0\x0\x0\x0\x0\x0\x2\x1\x0\x0\x0\x20\x30\x28\x24\x22\xa1\x60\x20\x0\x0\x0\x1\x2\x0\x0\x0"
"\x20\x60\xa1\x22\x24\x28\x30\x20\x0\x0\x0\x40\x40\x40\x40\x7f\xff\x81\x81\x81\x81\x80\x80\x80\x0\x0\x0\x20\x20\x11\x11\xe\x38\x44\x44\x82\x82\x0\x0\x0\x0\x0\xfe\x7c\x38\x10\x0\x0\x0\x0\x10\x38\x7c\xfe\x0\x0\x80\xc1\x63\x36\x1c\x8\x0\x0"
),
// Font no. 4
FontEntry("DX-FUTUR", 8, 8, 
"\x0\x0\x0\x0\x0\x0\x0\x0\x7e\x81\xa5\x81\xbd\x99\x81\x7e\x7e\xff\xdb\xff\xff\xc3\xe7\x7e\x0\x77\x7f\x7f\x3e\x1c\x8\x0\x8\x1c\x3e\x7f\x3e\x1c\x8\x0\x18\x3c\x18\xff\xff\x52\x18\x0\x8\x1c\x3e\x7f\x7f\x49\x1c\x0\x0\x0\x18\x3c\x18\x0\x0\x0"
"\xff\xff\xe7\xc3\xe7\xff\xff\xff\x0\x3c\x42\x81\x81\x42\x3c\x0\xff\xc3\xbd\x7e\x7e\xbd\xc3\xff\xf8\xe0\xb0\x3e\x63\x63\x3e\x0\x0\x7e\xc3\xc3\x7e\x18\x7e\x18\x20\x60\xe0\x20\x20\x3f\x1f\x0\x30\x50\xb0\xd0\x9f\x8f\xf0\xf0\x81\xc2\xbc\xe4\xa4\xfc\xea\xff"
"\x0\x0\x6\x1e\x7e\x1e\x6\x0\x0\x0\x60\x78\x7e\x78\x60\x0\x18\x7e\x18\x18\x18\x18\x7e\x18\x66\x66\x66\x66\x66\x0\x66\x0\xff\x6d\x6e\x6c\x6c\x6c\x6c\x0\x7e\x81\x3e\x42\x42\x7c\x81\x7e\x0\x0\x0\x7e\x7e\x0\x0\x0\x18\x7e\x18\x18\x7e\x18\x0\xff"
"\x18\x7e\x18\x18\x18\x18\x18\x0\x18\x18\x18\x18\x18\x7e\x18\x0\x0\x20\x60\xff\x60\x20\x0\x0\x0\x4\x6\xff\x6\x4\x0\x0\x0\x0\x0\x3\x3\x3\xff\x0\x0\x24\x66\xff\x66\x24\x0\x0\x0\x0\x8\x1c\x3e\x7f\x0\x0\x0\x0\x0\x7f\x3e\x1c\x8\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\xc\xc\xc\xc\xc\x0\xc\x0\x14\x14\x0\x0\x0\x0\x0\x0\x0\x14\x3e\x14\x3e\x14\x0\x0\x3e\x4b\xb\x3e\x68\x6b\x3e\x8\xc7\x65\x37\x18\xec\xa6\xe3\x0\x3e\x63\x6\x73\x63\x63\x3e\x0\x30\x30\x18\x0\x0\x0\x0\x0"
"\xc\x6\x6\x6\x6\x6\xc\x0\xc\x18\x18\x18\x18\x18\xc\x0\x0\x22\x14\x36\x14\x22\x0\x0\x0\x18\x18\x7e\x18\x18\x0\x0\x0\x0\x0\x0\x0\x18\x18\xc\x0\x0\x0\x7e\x0\x0\x0\x0\x0\x0\x0\x0\x0\x18\x18\x0\xc0\x60\x30\x18\xc\x6\x3\x0"
"\x7e\x63\x73\x6b\x67\x63\x3f\x0\x1c\x18\x18\x18\x18\x18\x3c\x0\x3f\x60\x3e\x3\x3\x3\x7f\x0\x7f\x60\x38\x60\x60\x60\x3f\x0\x63\x63\x7f\x60\x60\x60\x60\x0\x7f\x3\x3f\x60\x60\x60\x3f\x0\x7e\x3\x7f\x63\x63\x63\x3f\x0\x7f\x60\x30\x18\x18\x18\x18\x0"
"\x7e\x63\x3e\x63\x63\x63\x3f\x0\x3e\x63\x7e\x60\x60\x60\x60\x0\x0\x18\x18\x0\x0\x18\x18\x0\x0\x18\x18\x0\x0\x18\x18\xc\x0\x0\x38\xc\x6\xc\x38\x0\x0\x0\x0\x7e\x0\x7e\x0\x0\x0\x0\xe\x18\x30\x18\xe\x0\x7e\x63\x63\x38\x0\x18\x18\x0"
"\x3e\x41\x5d\x55\x7d\x1\x3e\x0\x70\x78\x6c\x66\x63\x63\x6f\x0\x3f\x60\x3b\x63\x63\x63\x3f\x0\x7e\x0\x3\x3\x3\x3\x7e\x0\x1f\x30\x63\x63\x63\x63\x3f\x0\x7f\x0\xf\x3\x3\x3\x7f\x0\x7f\x0\xf\x3\x3\x3\x3\x0\x7e\x0\x7b\x63\x63\x63\x3e\x0"
"\x63\x63\x7f\x63\x63\x63\x63\x0\x3c\x0\x18\x18\x18\x18\x3c\x0\x30\x30\x30\x30\x30\x30\x1f\x0\x43\x63\x33\x7b\x63\x63\x63\x0\x6\x6\x6\x6\x6\x6\x7e\x0\x3f\x60\x6b\x6b\x6b\x63\x63\x0\x3f\x60\x63\x63\x63\x63\x63\x0\x7e\x60\x63\x63\x63\x63\x3f\x0"
"\x7e\x60\x3e\x6\x6\x6\x6\x0\x7e\x63\x63\x63\x63\x3\x7f\x0\x7f\x60\x3f\x33\x63\x63\x63\x0\x7e\x3\x7f\x60\x60\x60\x3f\x0\x7e\x0\x18\x18\x18\x18\x18\x0\x63\x63\x63\x63\x63\x3\x7e\x0\x63\x63\x63\x63\x33\x1b\xf\x0\x63\x63\x6b\x6b\x6b\x63\x3f\x0"
"\x63\x36\x1c\x0\x1c\x36\x63\x0\x63\x63\x3f\x0\xc\xc\xc\x0\x7f\x0\x30\x18\xc\x6\x7f\x0\x3c\xc\xc\xc\xc\xc\x3c\x0\x3\x6\xc\x18\x30\x60\xc0\x0\x3c\x30\x30\x30\x30\x30\x3c\x0\x8\x1c\x36\x63\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\xff"
"\xc\xc\x18\x0\x0\x0\x0\x0\x0\x0\x7f\x60\x6e\x63\x3f\x0\x3\x3\x7b\x63\x63\x63\x3e\x0\x0\x0\x7e\x3\x3\x3\x7e\x0\x60\x60\x6e\x63\x63\x63\x3f\x0\x0\x0\x7e\x63\x3b\x3\x7f\x0\x3c\x0\x1e\x6\x6\x6\x6\x0\x0\x0\x7e\x63\x63\x6f\x60\x3e"
"\x3\x3\x3f\x63\x63\x63\x63\x0\x18\x0\x18\x18\x18\x18\x18\x0\x30\x0\x30\x30\x30\x30\x30\x1f\x3\x3\x63\x33\x7b\x63\x63\x0\x1c\x18\x18\x18\x18\x18\x18\x0\x0\x0\x3f\x63\x6b\x6b\x63\x0\x0\x0\x3f\x63\x63\x63\x63\x0\x0\x0\x7e\x63\x63\x63\x3f\x0"
"\x0\x0\x7e\x63\x63\x3b\x3\x3\x0\x0\x7e\x63\x63\x6f\x60\x60\x0\x0\x7c\x6\x6\x6\x6\x0\x0\x0\x7e\x3\x7f\x60\x3f\x0\xc\x0\x3c\xc\xc\xc\x78\x0\x0\x0\x63\x63\x63\x63\x7e\x0\x0\x0\x63\x63\x63\x33\x1f\x0\x0\x0\x63\x6b\x6b\x63\x3f\x0"
"\x0\x0\x63\x36\x14\x36\x63\x0\x0\x0\x63\x63\x63\x6f\x60\x3f\x0\x0\x7f\x0\xc\x6\x7f\x0\x70\x18\x18\xe\x18\x18\x70\x0\x18\x18\x18\x0\x18\x18\x18\x0\x7\xc\xc\x38\xc\xc\x7\x0\xe\x5a\x70\x0\x0\x0\x0\x0\x0\x0\x8\x14\x22\x7f\x0\x0"
"\xff\x1\x1\x1\x1\x1\x1\x1\xff\x0\x0\x0\x0\x0\x0\x0\xff\x80\x80\x80\x80\x80\x80\x80\x1\x1\x1\x1\x1\x1\x1\x1\x80\x80\x80\x80\x80\x80\x80\x80\x1\x1\x1\x1\x1\x1\x1\xff\x0\x0\x0\x0\x0\x0\x0\xff\x80\x80\x80\x80\x80\x80\x80\xff"
"\x1\x0\x0\x0\x0\x0\x0\x0\x80\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x1\x0\x0\x0\x0\x0\x0\x0\x80\x1\x3\x7\xf\x1f\x3f\x7f\xff\xff\xfe\xfc\xf8\xf0\xe0\xc0\x80\xff\xff\x3\x3\x3\x3\x3\x3\xff\xff\x0\x0\x0\x0\x0\x0"
"\xff\xff\xc0\xc0\xc0\xc0\xc0\xc0\x3\x3\x3\x3\x3\x3\x3\x3\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\x3\x3\x3\x3\x3\x3\xff\xff\x0\x0\x0\x0\x0\x0\xff\xff\xc0\xc0\xc0\xc0\xc0\xc0\xff\xff\x3\x3\x0\x0\x0\x0\x0\x0\xc0\xc0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x3\x3\x0\x0\x0\x0\x0\x0\xc0\xc0\x0\x0\x0\xff\x0\x0\x0\x0\x0\x1f\x31\x31\x31\x3f\x3e\x0\x0\x3e\x62\x62\x62\x7e\x7c\x0\x0\x7c\xc4\xc4\xc4\xfc\xf8\x0\x0\xf8\x88\x88\x88\xf8\xf0\x0\x0\xf0\x10\x10\x10\xf0\xe0\x0"
"\x0\xe0\x20\x20\x20\xe0\xc0\x0\x0\xc0\x40\x40\x40\xc0\x80\x0\x0\x80\x80\x80\x80\x80\x0\x0\x0\x0\x1\x1\x1\x1\x1\x0\x0\x1\x3\x3\x3\x3\x3\x0\x0\x3\x6\x6\x6\x7\x7\x0\x0\x7\xc\xc\xc\xf\xf\x0\x0\xf\x18\x18\x18\x1f\x1f\x0"
"\x18\x18\x18\x18\x18\x18\x18\x18\xff\xff\x0\x0\x0\x8\x1c\x3e\xff\xff\x0\x0\x0\x0\x0\x7f\xff\xff\x0\x0\x8\x1c\x3e\x7f\xff\xff\x0\xc3\xe7\xff\xdb\xc3\x0\x0\x0\x0\x8\x0\x0\x0\x0\x2\x2\x2\x2\x2\x2\x2\x0\x12\x12\x12\x12\x12\x12\x12"
"\x0\x92\x92\x92\x92\x92\x92\x92\x0\x4\x4\x4\x4\x4\x4\x4\x0\x24\x24\x24\x24\x24\x24\x24\x0\x24\x24\x24\x24\x24\x24\x24\x0\x1\x1\x1\x1\x1\x1\x1\x0\x9\x9\x9\x9\x9\x9\x9\x0\x49\x49\x49\x49\x49\x49\x49\x0\x0\x0\x18\x18\x0\x0\x0"
"\x0\x0\x0\x0\x55\x0\x0\x0\x0\x0\x70\x88\x4\x0\x0\x0\x0\x0\x0\x20\x11\xe\x0\x0\x0\x3e\x22\x22\x22\x22\xe3\x0\x0\x3e\x22\x22\x22\x22\x63\x0\x0\xc\x34\xc4\x4\x4\x4\x0\x0\x20\x20\x20\x23\x2c\x30\x0\x0\x60\x20\x20\x20\x20\x60\x0"
"\x0\x3\x2\x2\x2\x2\x3\x0\x0\x0\x0\x18\x18\x0\x0\x0\x0\x0\x18\x3c\x3c\x18\x0\x0\x0\x0\x18\x3c\x3c\x18\x0\x0\x0\x0\x0\x0\xff\x0\x0\x0\x0\x0\x3c\x3c\x3c\x3c\x0\x0\x0\x18\x3c\x7e\x7e\x3c\x18\x0\x0\x18\x3c\x7e\x7e\x3c\x18\x0"
"\x0\x3c\x7e\x7e\x7e\x7e\x3c\x0\x0\x3c\x7e\x7e\x7e\x7e\x3c\x0\x6c\x6c\x6c\xef\x0\xff\x0\x0\x0\x0\x0\xff\x0\xef\x6c\x6c\x6c\x6c\x6c\xec\xc\xec\x6c\x6c\x0\x0\x0\xff\x0\xff\x0\x0\x6c\x6c\x6c\xef\x0\xef\x6c\x6c\x18\x18\x18\xff\x0\xff\x0\x0"
"\x6c\x6c\x6c\xff\x0\x0\x0\x0\x0\x0\x0\xff\x0\xff\x18\x18\x0\x0\x0\xff\x6c\x6c\x6c\x6c\x6c\x6c\x6c\xfc\x0\x0\x0\x0\x18\x18\x18\xf8\x18\xf8\x0\x0\x0\x0\x0\xf8\x18\xf8\x18\x18\x0\x0\x0\xfc\x6c\x6c\x6c\x6c\x6c\x6c\x6c\xff\x6c\x6c\x6c\x6c"
"\x18\x18\x18\xff\x18\xff\x18\x18\x18\x18\x18\x1f\x0\x0\x0\x0\x0\x0\x0\xf8\x18\x18\x18\x18\xff\xff\xff\xff\xff\xff\xff\xff\x0\x0\x0\x0\xff\xff\xff\xff\xf\xf\xf\xf\xf\xf\xf\xf\xf0\xf0\xf0\xf0\xf0\xf0\xf0\xf0\xff\xff\xff\xff\x0\x0\x0\x0"
"\x0\x0\xee\x19\x19\xee\x0\x0\x38\x6c\x66\x3f\x63\x63\x3f\x3\x7f\x46\x6\x6\x6\x6\x6\x0\x0\x0\xff\x66\x66\x66\x66\x0\x7f\x46\xc\x18\xc\x46\x7f\x0\x0\x0\xfc\x66\x63\x33\x1e\x0\x0\x0\xcc\xcc\xcc\x7c\xc\xf\x0\x0\xff\x18\x18\x18\x18\x0"
"\x3c\x18\x3c\x66\x66\x3c\x18\x3c\x0\x3e\x63\x7f\x63\x3e\x0\x0\x0\x7e\xc3\xc3\xc3\x66\xe7\x0\x78\x98\x3c\x66\x63\x33\x1e\x0\x0\x0\x66\x99\x99\x66\x0\x0\x0\xc0\x3e\x73\x67\x3e\x3\x0\x0\x7c\x3\x7f\x3\x7c\x0\x0\x0\x0\x0\x0\x0\xdb\xdb\x0"
"\x0\x7e\x0\x7e\x0\x7e\x0\x0\x0\xf8\x8\x8\x8\x8\xf8\x0\x0\xff\x0\x0\x0\x0\xff\x0\x0\x1f\x10\x10\x10\x10\x1f\x0\x0\x0\x0\x8\x0\x0\x0\x0\x0\x0\x0\x2\x1\x0\x0\x0\x20\x30\x28\x24\x22\xa1\x60\x20\x0\x0\x0\x1\x2\x0\x0\x0"
"\x20\x60\xa1\x22\x24\x28\x30\x20\x0\x0\x0\x40\x40\x40\x40\x7f\xff\x81\x81\x81\x81\x80\x80\x80\x0\x0\x0\x20\x20\x11\x11\xe\x38\x44\x44\x82\x82\x0\x0\x0\x0\x0\xfe\x7c\x38\x10\x0\x0\x0\x0\x10\x38\x7c\xfe\x0\x0\x80\xc1\x63\x36\x1c\x8\x0\x0"
),
// Font no. 5
FontEntry("EK-MAC", 8, 8, 
"\x0\x0\x0\x0\x0\x0\x0\x0\x3e\x41\x55\x41\x5d\x22\x1c\x0\x3e\x49\x49\x7f\x5d\x22\x1c\x0\x36\x7f\x7f\x7f\x3e\x1c\x8\x0\x8\x1c\x3e\x7f\x3e\x1c\x8\x0\x1c\x1c\x6b\x7f\x6b\x8\x1c\x0\x8\x1c\x3e\x7f\x7f\x49\x1c\x0\x0\x18\x3c\x3c\x3c\x18\x0\x0"
"\x7e\x66\x42\x42\x42\x66\x7e\x0\x0\x18\x24\x24\x24\x18\x0\x0\x7e\x66\x5a\x5a\x5a\x66\x7e\x0\x70\x60\x50\x3c\x66\x66\x3c\x0\x3c\x66\x66\x3c\x18\x7e\x18\x0\x30\x30\x30\x30\x30\x1c\xc\x0\x7c\x6c\x6c\x6c\x67\x3b\x18\x0\x80\xaa\x94\xaa\x94\xaa\x80\xff"
"\x0\x6\x1e\x7e\x1e\x6\x0\x0\x0\x30\x3c\x3f\x3c\x30\x0\x0\x8\x3e\x8\x3e\x8\x8\x0\x0\x66\x66\x66\x66\x66\x0\x66\x0\x7c\x5a\x5a\x5a\x5c\x58\x58\x0\x3c\x46\x3e\x66\x7c\x62\x3c\x0\x0\x0\x0\x7e\x7e\x0\x0\x0\x8\x1c\x3e\x0\x3e\x1c\x8\x7f"
"\x0\x8\x1c\x3e\x7f\x0\x0\x0\x0\x0\x7f\x3e\x1c\x8\x0\x0\x8\x18\x38\x78\x38\x18\x8\x0\x10\x18\x1c\x1e\x1c\x18\x10\x0\x0\x0\x0\x6\x6\x6\x7e\x0\x0\x14\x36\x77\x36\x14\x0\x0\x0\x0\x8\x1c\x3e\x7f\x0\x0\x0\x0\x0\x7f\x3e\x1c\x8\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\xc\xc\xc\xc\xc\x0\xc\x0\x36\x36\x14\x0\x0\x0\x0\x0\x14\x3e\x14\x3e\x14\x0\x0\x0\x18\x3c\x46\x3c\x62\x3c\x18\x0\x4\x6a\x34\x18\x2c\x56\x20\x0\x1c\x36\x1c\x26\x66\x66\x7c\x0\x18\x10\x8\x0\x0\x0\x0\x0"
"\x30\x18\x18\x18\x18\x18\x30\x0\xc\x18\x18\x18\x18\x18\xc\x0\x18\x5a\x3c\x5a\x18\x0\x0\x0\x0\x18\x18\x7e\x18\x18\x0\x0\x0\x0\x0\x0\x0\x18\x18\xc\x0\x0\x0\x7e\x0\x0\x0\x0\x0\x0\x0\x0\x0\x18\x18\x0\x0\x60\x30\x18\xc\x6\x0\x0"
"\x3c\x66\x66\x66\x66\x66\x3c\x0\x18\x1c\x18\x18\x18\x18\x18\x0\x3c\x66\x60\x30\x18\xc\x7e\x0\x3c\x66\x60\x38\x60\x66\x3c\x0\x70\x78\x6c\x66\x7e\x60\x60\x0\x7e\x6\x3e\x60\x60\x66\x3c\x0\x3c\x66\x6\x3e\x66\x66\x3c\x0\x7e\x60\x30\x18\x18\x18\x18\x0"
"\x3c\x66\x66\x3c\x66\x66\x3c\x0\x3c\x66\x66\x7c\x60\x66\x3c\x0\x0\x18\x18\x0\x18\x18\x0\x0\x0\x18\x18\x0\x18\x10\x8\x0\x30\x18\xc\x6\xc\x18\x30\x0\x0\x0\x7e\x0\x7e\x0\x0\x0\x6\xc\x18\x30\x18\xc\x6\x0\x3c\x66\x60\x30\x18\x0\x18\x0"
"\x3c\x62\x6a\x6a\x7a\x2\x3c\x0\x3c\x66\x66\x66\x7e\x66\x66\x0\x3e\x66\x66\x3e\x66\x66\x3e\x0\x3c\x66\x6\x6\x6\x66\x3c\x0\x3e\x66\x66\x66\x66\x66\x3e\x0\x7e\x6\x6\x1e\x6\x6\x7e\x0\x7e\x6\x6\x1e\x6\x6\x6\x0\x3c\x66\x6\x76\x66\x66\x3c\x0"
"\x66\x66\x66\x7e\x66\x66\x66\x0\x18\x18\x18\x18\x18\x18\x18\x0\x60\x60\x60\x60\x60\x66\x3c\x0\x66\x66\x66\x3e\x66\x66\x66\x0\x6\x6\x6\x6\x6\x6\x3e\x0\x3f\x6b\x6b\x6b\x6b\x6b\x6b\x0\x3e\x66\x66\x66\x66\x66\x66\x0\x3c\x66\x66\x66\x66\x66\x3c\x0"
"\x3e\x66\x66\x66\x3e\x6\x6\x0\x3c\x66\x66\x66\x66\x36\x6c\x0\x3e\x66\x66\x3e\x66\x66\x66\x0\x3c\x66\x6\x3c\x60\x66\x3c\x0\x7e\x18\x18\x18\x18\x18\x18\x0\x66\x66\x66\x66\x66\x66\x3c\x0\x66\x66\x66\x66\x66\x26\x1e\x0\x6b\x6b\x6b\x6b\x6b\x6b\x3f\x0"
"\x66\x66\x66\x3c\x66\x66\x66\x0\x66\x66\x66\x3c\x18\x18\x18\x0\x7e\x60\x30\x18\xc\x6\x7e\x0\x78\x18\x18\x18\x18\x18\x18\x78\x0\x6\xc\x18\x30\x60\x0\x0\x1e\x18\x18\x18\x18\x18\x18\x1e\x8\x1c\x36\x63\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x7e"
"\x18\x8\x10\x0\x0\x0\x0\x0\x0\x0\x3c\x62\x7c\x66\x7c\x0\x6\x6\x3e\x66\x66\x66\x3e\x0\x0\x0\x3c\x66\x6\x66\x3c\x0\x60\x60\x7c\x66\x66\x66\x7c\x0\x0\x0\x3c\x66\x7e\x6\x3c\x0\x38\x4c\x1e\xc\xc\xc\xc\x0\x0\x0\x7c\x66\x66\x7c\x62\x3c"
"\x6\x6\x3e\x66\x66\x66\x66\x0\x18\x0\x1c\x18\x18\x18\x18\x0\x30\x0\x38\x30\x30\x30\x32\x1c\x6\x6\x66\x66\x3e\x66\x66\x0\x1c\x18\x18\x18\x18\x18\x18\x0\x0\x0\x3f\x6b\x6b\x6b\x6b\x0\x0\x0\x3e\x66\x66\x66\x66\x0\x0\x0\x3c\x66\x66\x66\x3c\x0"
"\x0\x0\x3e\x66\x66\x66\x3e\x6\x0\x0\x7c\x66\x66\x66\x7c\x60\x0\x0\x3e\x66\x66\x6\x6\x0\x0\x0\x3c\x46\x3c\x62\x3c\x0\x0\x18\x3c\x18\x18\x18\x30\x0\x0\x0\x66\x66\x66\x66\x3c\x0\x0\x0\x66\x66\x66\x26\x1e\x0\x0\x0\x6b\x6b\x6b\x6b\x3f\x0"
"\x0\x0\x66\x66\x3c\x66\x66\x0\x0\x0\x66\x66\x66\x7c\x62\x3c\x0\x0\x7e\x30\x18\xc\x7e\x0\x30\x18\x18\xc\x18\x18\x30\x0\x18\x18\x18\x18\x18\x18\x18\x18\xc\x18\x18\x30\x18\x18\xc\x0\xc\x5a\x30\x0\x0\x0\x0\x0\x0\x0\x18\x24\x66\x7e\x0\x0"
"\xfe\x1\x1\x1\x1\x1\x1\x1\xff\x0\x0\x0\x0\x0\x0\x0\x7f\x80\x80\x80\x80\x80\x80\x80\x1\x1\x1\x1\x1\x1\x1\x1\x80\x80\x80\x80\x80\x80\x80\x80\x1\x1\x1\x1\x1\x1\x1\xfe\x0\x0\x0\x0\x0\x0\x0\xff\x80\x80\x80\x80\x80\x80\x80\x7f"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x1\x3\x7\xf\x1f\x3f\x7f\xff\xff\xfe\xfc\xf8\xf0\xe0\xc0\x80\xfc\xfe\x7\xf3\xb\xb\xb\xb\xff\xff\x0\xff\x0\x0\x0\x0"
"\x3f\x7f\xe0\xcf\xd0\xd0\xd0\xd0\xb\xb\xb\xb\xb\xb\xb\xb\xd0\xd0\xd0\xd0\xd0\xd0\xd0\xd0\xb\xb\xb\xb\xf3\x7\xfe\xfc\x0\x0\x0\x0\xff\x0\xff\xff\xd0\xd0\xd0\xd0\xcf\xe0\x7f\x3f\xb\x9\x4\x3\x0\x0\x0\x0\xd0\x90\x20\xc0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x3\x4\x9\xb\x0\x0\x0\x0\xc0\x20\x90\xd0\x0\x0\x0\xaa\x0\x0\x0\x0\x0\x3f\x7e\x3f\x7e\x3f\x7e\x0\x0\x7e\x7e\x7e\x7e\x7e\x7e\x0\x0\x7e\xfc\x7e\xfc\x7e\xfc\x0\x0\xfe\xf0\xfe\xf0\xfe\xf0\x0\x0\xfe\xe0\xfe\xe0\xfe\xe0\x0"
"\x0\xfc\xc0\xfc\xc0\xfc\xc0\x0\x0\xf0\x80\xf0\x80\xf0\x80\x0\x0\xc0\x0\xc0\x0\xc0\x0\x0\x0\x0\x3\x0\x3\x0\x3\x0\x0\x1\xf\x1\xf\x1\xf\x0\x0\x3\x3f\x3\x3f\x3\x3f\x0\x0\x7\x7f\x7\x7f\x7\x7f\x0\x0\xf\x7f\xf\x7f\xf\x7f\x0"
"\x3c\x3c\x3c\x3c\x3c\x3c\x3c\x3c\xff\xff\x0\xff\x0\x18\x3c\x0\xff\xff\x0\xff\x0\x0\x0\x7e\xff\xff\x0\xff\x0\x18\x3c\x7e\xff\xff\x0\xff\x0\x3e\x56\x56\x0\x0\x0\x18\x18\x0\x0\x0\x0\x7\x7\x7\x7\x7\x7\x0\x0\x3f\x3f\x3f\x3f\x3f\x3f\x0"
"\x0\xff\xff\xff\xff\xff\xff\x0\x0\x7\x7\x7\x7\x7\x7\x0\x0\x3f\x3f\x3f\x3f\x3f\x3f\x0\x0\xff\xff\xff\xff\xff\xff\x0\x0\x3\x3\x3\x3\x3\x3\x0\x0\x1f\x1f\x1f\x1f\x1f\x1f\x0\x0\xff\xff\xff\xff\xff\xff\x0\x0\x0\x3c\x3c\x3c\x3c\x0\x0"
"\x0\x0\x0\xf\x18\x1f\x18\x18\x6c\x6c\x6c\x67\x60\x67\x6c\x6c\x6c\x6c\x6c\x6c\x6c\x6c\x6c\x6c\x0\x0\x0\x3f\x60\x67\x6c\x6c\x6c\x6c\x6c\x67\x60\x3f\x0\x0\x6c\x6c\x6c\x3f\x0\x0\x0\x0\x18\x18\x18\x1f\x18\xf\x0\x0\x0\x0\x0\xf\x18\x18\x18\x18"
"\x18\x18\x18\xf0\x0\x0\x0\x0\x18\x18\x18\xff\x0\x0\x0\x0\x0\x0\x0\xff\x18\x18\x18\x18\x18\x18\x18\xf8\x18\x18\x18\x18\x0\x0\x0\x0\xff\x0\x0\x0\x18\x18\x18\xff\x18\x18\x18\x18\x18\x18\x18\xf8\x18\xf8\x18\x18\x6c\x6c\x6c\xec\x6c\x6c\x6c\x6c"
"\x6c\x6c\x6c\xcc\xc\xf8\x0\x0\x0\x0\x0\xf8\xc\xcc\x6c\x6c\x6c\x6c\x6c\xc7\x0\xff\x0\x0\x0\x0\x0\xff\x0\xc7\x6c\x6c\x6c\x6c\x6c\xcc\xc\xcc\x6c\x6c\x0\x0\x0\xff\x0\xff\x0\x0\x6c\x6c\x6c\xc7\x0\xc7\x6c\x6c\x18\x18\x18\xff\x0\xff\x0\x0"
"\x6c\x6c\x6c\xff\x0\x0\x0\x0\x0\x0\x0\xff\x0\xff\x18\x18\x0\x0\x0\xff\x6c\x6c\x6c\x6c\x6c\x6c\x6c\xf8\x0\x0\x0\x0\x18\x18\x18\xf8\x18\xf0\x0\x0\x0\x0\x0\xf0\x18\xf8\x18\x18\x0\x0\x0\xf8\x6c\x6c\x6c\x6c\x6c\x6c\x6c\xff\x6c\x6c\x6c\x6c"
"\x18\x18\x18\xff\x18\xff\x18\x18\x18\x18\x18\xf\x0\x0\x0\x0\x0\x0\x0\xf0\x18\x18\x18\x18\xff\xff\xff\xff\xff\xff\xff\xff\x0\x0\x0\x0\xff\xff\xff\xff\xf\xf\xf\xf\xf\xf\xf\xf\xf0\xf0\xf0\xf0\xf0\xf0\xf0\xf0\xff\xff\xff\xff\x0\x0\x0\x0"
"\x0\x0\x0\x6c\x36\x36\x6c\x0\x3c\x66\x66\x36\x66\x66\x36\x6\x3c\x46\x6\x6\x6\x6\x6\x0\x0\x0\xff\x66\x66\x66\x66\x0\x7e\x6\xc\x18\xc\x6\x7e\x0\x0\x0\xfc\x66\x66\x66\x3c\x0\x0\x0\x66\x66\x66\x66\x3e\x3\x0\x0\x3c\x18\x18\x18\x30\x0"
"\x0\x18\x3c\x66\x66\x66\x3c\x18\x38\x64\x66\x7e\x66\x26\x1c\x0\x3c\x66\x66\x66\x24\x24\x66\x0\x70\x98\x3c\x66\x66\x66\x3c\x0\x0\x0\x36\x6b\x6b\x36\x0\x0\x0\x60\x3c\x66\x66\x66\x3c\x6\x0\x0\x7c\x6\x7e\x6\x7c\x0\x0\x0\x0\x0\x0\xdb\xdb\x0"
"\x0\x7e\x0\x7e\x0\x7e\x0\x0\x0\xf8\x8\x8\x8\x8\xf8\x0\x0\xff\x0\x0\x0\x0\xff\x0\x0\x1f\x10\x10\x10\x10\x1f\x0\x0\x0\x0\x8\x0\x0\x0\x0\x0\x0\x0\x2\x1\x0\x0\x0\x20\x30\x28\x24\x22\xa1\x60\x20\x0\x0\x0\x1\x2\x0\x0\x0"
"\x20\x60\xa1\x22\x24\x28\x30\x20\x0\x0\x0\x40\x40\x40\x40\x7f\xff\x81\x81\x81\x81\x80\x80\x80\x0\x0\x0\x20\x20\x11\x11\xe\x38\x44\x44\x82\x82\x0\x0\x0\x0\x0\xfe\x7c\x38\x10\x0\x0\x0\x0\x10\x38\x7c\xfe\x0\x0\x80\xc1\x63\x36\x1c\x8\x0\x0"
),
// Font no. 6
FontEntry("EK-SPACE", 8, 8, 
"\x0\x0\x0\x0\x0\x0\x0\x0\x3e\x41\x55\x41\x5d\x22\x1c\x0\x3e\x49\x49\x7f\x5d\x22\x1c\x0\x36\x7f\x7f\x7f\x3e\x1c\x8\x0\x8\x1c\x3e\x7f\x3e\x1c\x8\x0\x1c\x1c\x6b\x7f\x6b\x8\x1c\x0\x8\x1c\x3e\x7f\x7f\x49\x1c\x0\x0\x1c\x3e\x3e\x3e\x1c\x0\x0"
"\x7f\x63\x41\x41\x41\x63\x7f\x0\x0\x1c\x22\x22\x22\x1c\x0\x0\x7f\x63\x5d\x5d\x5d\x63\x7f\x0\x70\x60\x50\x3e\x63\x63\x3e\x0\x3e\x63\x63\x3e\x8\x3e\x8\x0\x30\x30\x30\x30\x30\x1c\xc\x0\x7c\x6c\x6c\x6c\x67\x3b\x18\x0\x80\xaa\x94\xaa\x94\xaa\x80\xff"
"\x0\x6\x1e\x7e\x1e\x6\x0\x0\x0\x30\x3c\x3f\x3c\x30\x0\x0\x18\x7e\x18\x18\x18\x18\x7e\x18\x66\x66\x66\x66\x66\x0\x66\x0\x7e\x6b\x6b\x6b\x6e\x68\x68\x0\x7e\x3\x3f\x63\x7e\x60\x3f\x0\x0\x0\x0\x7e\x7e\x0\x0\x0\x8\x1c\x3e\x0\x3e\x1c\x8\x7f"
"\x0\x8\x1c\x3e\x7f\x0\x0\x0\x0\x0\x7f\x3e\x1c\x8\x0\x0\x8\x18\x38\x78\x38\x18\x8\x0\x10\x18\x1c\x1e\x1c\x18\x10\x0\x0\x0\x0\x3\x3\x3\x7e\x0\x0\x14\x36\x77\x36\x14\x0\x0\x0\x0\x8\x1c\x3e\x7f\x0\x0\x0\x0\x0\x7f\x3e\x1c\x8\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\xc\xc\xc\xc\xc\x0\xc\x0\x36\x36\x14\x0\x0\x0\x0\x0\xa\x1f\xa\x1f\xa\x0\x0\x0\x3e\x6b\xb\x3e\x68\x6b\x3e\x0\x4c\x6a\x36\x18\x6c\x56\x32\x0\x1c\x36\x1c\x26\x63\x63\x7e\x0\x18\x18\xc\x0\x0\x0\x0\x0"
"\x8\x6\x3\x3\x3\x6\x8\x0\x8\x30\x60\x60\x60\x30\x8\x0\x0\x2a\x1c\x7f\x1c\x2a\x0\x0\x0\x18\x18\x7e\x18\x18\x0\x0\x0\x0\x0\x0\x0\x18\x18\xc\x0\x0\x0\x3e\x0\x0\x0\x0\x0\x0\x0\x0\x0\x18\x18\x0\x0\x60\x30\x18\xc\x6\x0\x0"
"\x3e\x63\x63\x6b\x63\x63\x3e\x0\x18\x1c\x18\x18\x18\x18\x7e\x0\x3e\x63\x60\x38\xe\x3\x7f\x0\x3e\x63\x60\x3c\x60\x63\x3e\x0\x70\x78\x6c\x66\x63\x7f\x60\x0\x7f\x3\x3\x3f\x60\x60\x3f\x0\x3e\x63\x3\x3f\x63\x63\x3e\x0\x7f\x30\x18\x3e\xc\xc\xc\x0"
"\x3e\x63\x63\x3e\x63\x63\x3e\x0\x3e\x63\x63\x7e\x60\x63\x3e\x0\x0\x18\x18\x0\x18\x18\x0\x0\x0\x18\x18\x0\x18\x18\x8\x0\x30\x18\xc\x6\xc\x18\x30\x0\x0\x0\x3e\x0\x3e\x0\x0\x0\x6\xc\x18\x30\x18\xc\x6\x0\x3c\x62\x60\x30\x18\x0\x18\x0"
"\x3c\x62\x6b\x6b\x7b\x3\x3e\x0\x1c\x36\x63\x63\x7f\x63\x63\x0\x3f\x63\x63\x3f\x63\x63\x3f\x0\x3e\x63\x3\x3\x3\x63\x3e\x0\x3f\x63\x63\x63\x63\x63\x3f\x0\x7f\x3\x3\x1f\x3\x3\x7f\x0\x7f\x3\x3\x1f\x3\x3\x3\x0\x3e\x63\x3\x7b\x63\x63\x3e\x0"
"\x63\x63\x63\x7f\x63\x63\x63\x0\x3c\x18\x18\x18\x18\x18\x3c\x0\x78\x60\x60\x60\x60\x63\x3e\x0\x63\x33\x1b\xf\x1b\x33\x63\x0\x6\x6\x6\x6\x6\x6\x7e\x0\x63\x77\x7f\x6b\x6b\x63\x63\x0\x63\x67\x6f\x7b\x73\x63\x63\x0\x3e\x63\x63\x63\x63\x63\x3e\x0"
"\x3f\x63\x63\x63\x3f\x3\x3\x0\x3e\x63\x63\x63\x6b\x33\x6e\x60\x3f\x63\x63\x63\x3f\x63\x63\x0\x3e\x63\x3\x3e\x60\x63\x3e\x0\x7e\x18\x18\x18\x18\x18\x18\x0\x63\x63\x63\x63\x63\x63\x3e\x0\x63\x63\x63\x63\x63\x36\x1c\x0\x63\x63\x6b\x6b\x6b\x77\x63\x0"
"\x63\x63\x36\x1c\x36\x63\x63\x0\x66\x66\x66\x3c\x18\x18\x18\x0\x7f\x30\x18\x3e\xc\x6\x7f\x0\x78\x18\x18\x18\x18\x18\x18\x78\x0\x6\xc\x18\x30\x60\x0\x0\x1e\x18\x18\x18\x18\x18\x18\x1e\x8\x1c\x36\x63\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\xff"
"\x18\x18\x30\x0\x0\x0\x0\x0\x0\x0\x3e\x60\x7e\x63\x7e\x0\x3\x3\x3f\x63\x63\x63\x3f\x0\x0\x0\x3e\x63\x3\x63\x3e\x0\x60\x60\x7e\x63\x63\x63\x7e\x0\x0\x0\x3e\x63\x7f\x3\x3e\x0\x3c\x46\x6\x3f\x6\x6\x6\x0\x0\x0\x3e\x63\x63\x7e\x60\x3e"
"\x3\x3\x3f\x63\x63\x63\x63\x0\x18\x0\x1c\x18\x18\x18\x18\x0\x30\x0\x38\x30\x30\x30\x31\x1e\x3\x3\x63\x3b\xf\x3b\x63\x0\x1c\x18\x18\x18\x18\x18\x18\x0\x0\x0\x36\x7f\x6b\x6b\x63\x0\x0\x0\x3e\x63\x63\x63\x63\x0\x0\x0\x3e\x63\x63\x63\x3e\x0"
"\x0\x0\x3e\x63\x63\x63\x3f\x3\x0\x0\x3e\x63\x63\x63\x7e\x60\x0\x0\x3e\x63\x63\x3\x3\x0\x0\x0\x7e\x3\x3e\x60\x3f\x0\xc\xc\x3e\xc\xc\xc\x38\x0\x0\x0\x63\x63\x63\x63\x3e\x0\x0\x0\x63\x63\x63\x36\x1c\x0\x0\x0\x63\x6b\x6b\x77\x22\x0"
"\x0\x0\x63\x36\x1c\x36\x63\x0\x0\x0\x63\x63\x63\x7e\x60\x3e\x0\x0\x7f\x30\x1c\x6\x7f\x0\x38\xc\xc\x6\xc\xc\x38\x0\x18\x18\x18\x18\x18\x18\x18\x18\xe\x18\x18\x30\x18\x18\xe\x0\xe\x99\x70\x0\x0\x0\x0\x0\x0\x0\x8\x14\x22\x7f\x0\x0"
"\xfe\x1\x1\x1\x1\x1\x1\x1\xff\x0\x0\x0\x0\x0\x0\x0\x7f\x80\x80\x80\x80\x80\x80\x80\x1\x1\x1\x1\x1\x1\x1\x1\x80\x80\x80\x80\x80\x80\x80\x80\x1\x1\x1\x1\x1\x1\x1\xfe\x0\x0\x0\x0\x0\x0\x0\xff\x80\x80\x80\x80\x80\x80\x80\x7f"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x1\x1\x2\x2\x4\x8\x30\xc0\x3\xc\x10\x20\x40\x40\x80\x80\xf0\xfc\xe\x6\x3\x3\x3\x3\xff\xff\x0\x0\x0\x0\x0\x0"
"\xf\x3f\x70\x60\xc0\xc0\xc0\xc0\x3\x3\x3\x3\x3\x3\x3\x3\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\x3\x3\x3\x3\x6\xe\xfc\xf0\x0\x0\x0\x0\x0\x0\xff\xff\xc0\xc0\xc0\xc0\x60\x70\x3f\xf\x1\x0\x0\x0\x0\x0\x0\x0\x80\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x1\x0\x0\x0\x0\x0\x0\x0\x80\x0\x0\x0\x55\xaa\x0\x0\x0\x0\x38\x7e\x7f\x7f\x7f\x3e\x0\x0\x3c\x7e\x7e\x7e\x7e\x3c\x0\x0\x1c\x7e\xfe\xfe\xfe\x7c\x0\x0\x0\x38\x7e\xfe\xfe\xfc\x0\x0\x0\x0\x0\x1e\xfe\xfc\x0"
"\x0\x0\x0\x0\x0\xe\xfc\x0\x0\x0\x0\x0\x0\x80\xe0\x0\x0\x0\x0\x0\x0\x80\xc0\x0\x0\x0\x0\x0\x0\x1\x3\x0\x0\x0\x0\x0\x0\x1\x7\x0\x0\x0\x0\x0\x0\x70\x3f\x0\x0\x0\x0\x0\x78\x7f\x3f\x0\x0\x0\x1c\x7e\x7f\x7f\x3f\x0"
"\x14\x2a\x14\x2a\x14\x2a\x14\x2a\xff\xff\x0\x0\x8\x1c\x3e\x0\xff\xff\x0\x0\x0\x0\x0\x2a\xff\xff\x0\x0\x8\x1c\x3e\x7f\xff\xff\x0\x36\x7f\x6b\x6b\x6b\x0\x0\x0\x18\x18\x0\x0\x0\x0\x6\x3\x3\x3\x3\x1\x0\x0\xe\x1b\x1b\x1b\x1b\x31\x0"
"\x0\x8e\xdb\xdb\xdb\xdb\x71\x0\x0\x3\x6\x6\x6\x6\xc\x0\x0\x63\x36\x36\x36\x36\x1c\x0\x0\xe3\xb6\xb6\xb6\xb6\x1c\x0\x0\x0\x1\x1\x1\x1\x3\x0\x0\x18\xd\xd\xd\xd\x7\x0\x0\x38\x6d\x6d\x6d\x6d\xc7\x0\x0\x1c\x3e\x3e\x3e\x1c\x0\x0"
"\x0\x0\x0\xf\x18\x1f\x18\x18\x6c\x6c\x6c\x67\x60\x67\x6c\x6c\x6c\x6c\x6c\x6c\x6c\x6c\x6c\x6c\x0\x0\x0\x3f\x60\x67\x6c\x6c\x6c\x6c\x6c\x67\x60\x3f\x0\x0\x6c\x6c\x6c\x3f\x0\x0\x0\x0\x18\x18\x18\x1f\x18\xf\x0\x0\x0\x0\x0\xf\x18\x18\x18\x18"
"\x18\x18\x18\xf0\x0\x0\x0\x0\x18\x18\x18\xff\x0\x0\x0\x0\x0\x0\x0\xff\x18\x18\x18\x18\x18\x18\x18\xf8\x18\x18\x18\x18\x0\x0\x0\x0\xff\x0\x0\x0\x18\x18\x18\xff\x18\x18\x18\x18\x18\x18\x18\xf8\x18\xf8\x18\x18\x6c\x6c\x6c\xec\x6c\x6c\x6c\x6c"
"\x6c\x6c\x6c\xcc\xc\xf8\x0\x0\x0\x0\x0\xf8\xc\xcc\x6c\x6c\x6c\x6c\x6c\xc7\x0\xff\x0\x0\x0\x0\x0\xff\x0\xc7\x6c\x6c\x6c\x6c\x6c\xcc\xc\xcc\x6c\x6c\x0\x0\x0\xff\x0\xff\x0\x0\x6c\x6c\x6c\xc7\x0\xc7\x6c\x6c\x18\x18\x18\xff\x0\xff\x0\x0"
"\x6c\x6c\x6c\xff\x0\x0\x0\x0\x0\x0\x0\xff\x0\xff\x18\x18\x0\x0\x0\xff\x6c\x6c\x6c\x6c\x6c\x6c\x6c\xf8\x0\x0\x0\x0\x18\x18\x18\xf8\x18\xf0\x0\x0\x0\x0\x0\xf0\x18\xf8\x18\x18\x0\x0\x0\xf8\x6c\x6c\x6c\x6c\x6c\x6c\x6c\xff\x6c\x6c\x6c\x6c"
"\x18\x18\x18\xff\x18\xff\x18\x18\x18\x18\x18\xf\x0\x0\x0\x0\x0\x0\x0\xf0\x18\x18\x18\x18\xff\xff\xff\xff\xff\xff\xff\xff\x0\x0\x0\x0\xff\xff\xff\xff\xf\xf\xf\xf\xf\xf\xf\xf\xf0\xf0\xf0\xf0\xf0\xf0\xf0\xf0\xff\xff\xff\xff\x0\x0\x0\x0"
"\x0\x0\x0\x6e\x33\x33\x6e\x0\x3c\x66\x63\x3b\x63\x63\x3b\x3\x3c\x46\x6\x6\x6\x6\x6\x0\x0\x0\x7f\x36\x36\x36\x36\x0\x3c\x46\xc\x18\xc\x46\x3c\x0\x0\x0\xfc\x66\x63\x33\x1e\x0\x0\x0\x66\x66\x66\x66\x3e\x3\x0\x0\x3e\xc\xc\xc\x18\x0"
"\x0\x8\x3e\x6b\x6b\x6b\x3e\x8\x3c\x66\x63\x7f\x63\x33\x1e\x0\x3e\x63\x63\x63\x36\x36\x63\x0\x70\x98\x3c\x66\x63\x33\x1e\x0\x0\x0\x36\x6b\x6b\x36\x0\x0\x0\x0\x5e\x33\x6b\x66\x3d\x0\x0\x0\x7e\x3\x7f\x3\x7e\x0\x0\x0\x0\x0\x0\xdb\xdb\x0"
"\x0\x7e\x0\x7e\x0\x7e\x0\x0\x0\xf8\x8\x8\x8\x8\xf8\x0\x0\xff\x0\x0\x0\x0\xff\x0\x0\x1f\x10\x10\x10\x10\x1f\x0\x0\x0\x0\x8\x0\x0\x0\x0\x0\x0\x0\x2\x1\x0\x0\x0\x20\x30\x28\x24\x22\xa1\x60\x20\x0\x0\x0\x1\x2\x0\x0\x0"
"\x20\x60\xa1\x22\x24\x28\x30\x20\x0\x0\x0\x40\x40\x40\x40\x7f\xff\x81\x81\x81\x81\x80\x80\x80\x0\x0\x0\x20\x20\x11\x11\xe\x38\x44\x44\x82\x82\x0\x0\x0\x0\x0\xfe\x7c\x38\x10\x0\x0\x0\x0\x10\x38\x7c\xfe\x0\x0\x80\xc1\x63\x36\x1c\x8\x0\x0"
),
// Font no. 7
FontEntry("FINELINE", 8, 8, 
"\x0\x0\x0\x0\x0\x0\x0\x0\x7e\x81\xa5\x81\xbd\x99\x81\x7e\x7e\xff\xdb\xff\xff\xc3\xe7\x7e\x0\x77\x7f\x7f\x3e\x1c\x8\x0\x8\x1c\x3e\x7f\x3e\x1c\x8\x0\x18\x3c\x18\xff\xff\x52\x18\x0\x8\x1c\x3e\x7f\x7f\x49\x1c\x0\x0\x0\x18\x3c\x18\x0\x0\x0"
"\xff\xff\xe7\xc3\xe7\xff\xff\xff\x0\x3c\x42\x42\x42\x42\x3c\x0\xff\xc3\xbd\xbd\xbd\xbd\xc3\xff\xf8\xe0\xb0\x3e\x63\x63\x3e\x0\x0\x7e\xc3\xc3\x7e\x18\x7e\x18\x20\x60\xe0\x20\x20\x3f\x1f\x0\x30\x50\xb0\xd0\x9f\x8f\xf0\xf0\x81\xc2\xbc\xe4\xa4\xfc\xea\xff"
"\x0\x0\x6\x1e\x7e\x1e\x6\x0\x0\x0\x60\x78\x7e\x78\x60\x0\x18\x7e\x18\x18\x18\x18\x7e\x18\x66\x66\x66\x66\x66\x0\x66\x0\xff\x6d\x6e\x6c\x6c\x6c\x6c\x0\x7e\x81\x3e\x42\x42\x7c\x81\x7e\x0\x0\x0\x7e\x7e\x0\x0\x0\x18\x7e\x18\x18\x7e\x18\x0\xff"
"\x18\x7e\x18\x18\x18\x18\x18\x0\x18\x18\x18\x18\x18\x7e\x18\x0\x0\x20\x60\xff\x60\x20\x0\x0\x0\x4\x6\xff\x6\x4\x0\x0\x0\x0\x0\x3\x3\x3\xff\x0\x0\x24\x66\xff\x66\x24\x0\x0\x0\x0\x8\x1c\x3e\x7f\x0\x0\x0\x0\x0\x7f\x3e\x1c\x8\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\xc\xc\xc\xc\xc\x0\xc\x0\x66\x66\x0\x0\x0\x0\x0\x0\xa\x1f\xa\x1f\xa\x0\x0\x0\x3e\x4b\xb\x3e\x68\x6b\x3e\x8\xc7\x65\x37\x18\xec\xa6\xe3\x0\x1c\x32\x1c\xa2\x63\x73\x5e\x80\x30\x30\x18\x0\x0\x0\x0\x0"
"\x8\x6\x3\x3\x3\x6\x8\x0\x8\x30\x60\x60\x60\x30\x8\x0\x0\x2a\x1c\x7f\x1c\x2a\x0\x0\x0\x18\x18\x7e\x18\x18\x0\x0\x0\x0\x0\x0\x0\x0\x18\xe\x0\x0\x0\x7e\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x30\x0\x80\xc0\x60\x30\x18\xc\x6\x3"
"\x1e\x21\x21\x21\x21\x21\x1e\x0\x8\xc\x8\x8\x8\x8\x1c\x0\x1e\x21\x10\x8\x4\x2\x3f\x0\x3e\x41\x40\x3c\x40\x41\x3e\x0\x30\x28\x24\x22\x7f\x20\x20\x0\x7f\x1\x1\x3f\x40\x40\x3f\x0\x3e\x41\x1\x3f\x41\x41\x3e\x0\x7f\x20\x10\x8\x8\x8\x8\x0"
"\x3e\x41\x41\x3e\x41\x41\x3e\x0\x3e\x41\x41\x7e\x40\x41\x3e\x0\x0\xc\x0\x0\x0\xc\x0\x0\x0\xc\x0\x0\x0\xc\x4\x0\x0\x38\xc\x6\xc\x38\x0\x0\x0\x0\x7e\x0\x7e\x0\x0\x0\x0\xe\x18\x30\x18\xe\x0\x0\x3e\x63\x30\x18\xc\x0\xc\x0"
"\x3e\x41\x5d\x55\x7d\x1\x3e\x0\x1c\x22\x41\x41\x7f\x41\x41\x0\x3f\x41\x41\x3f\x41\x41\x3f\x0\x3e\x41\x1\x1\x41\x41\x3e\x0\x3f\x41\x41\x41\x41\x41\x3f\x0\x7f\x1\x1\x1f\x1\x1\x7f\x0\x7f\x1\x1\x1f\x1\x1\x1\x0\x3e\x41\x1\x79\x41\x61\x5e\x0"
"\x41\x41\x41\x7f\x41\x41\x41\x0\x3e\x8\x8\x8\x8\x8\x3e\x0\x78\x20\x20\x20\x20\x21\x1e\x0\x21\x11\x9\x7\x9\x11\x21\x0\x2\x2\x2\x2\x2\x2\x7e\x0\x63\x55\x55\x49\x49\x41\x41\x0\x41\x43\x45\x49\x51\x61\x41\x0\x3e\x41\x41\x41\x41\x41\x3e\x0"
"\x3f\x42\x42\x3e\x2\x2\x7\x0\x3e\x41\x41\x49\x51\x61\x3e\x40\x1f\x21\x21\x1f\x11\x21\x21\x40\x3e\x41\x1\x3e\x40\x41\x3e\x0\x7f\x8\x8\x8\x8\x8\x8\x0\x41\x41\x41\x41\x41\x41\x3e\x0\x41\x41\x41\x41\x41\x22\x1c\x0\x41\x49\x49\x49\x55\x63\x41\x0"
"\x41\x22\x14\x8\x14\x22\x41\x0\x41\x22\x14\x8\x8\x8\x8\x0\x7f\x20\x10\x8\x4\x2\x7f\x0\x38\x18\x18\x18\x18\x18\x18\x38\x3\x6\xc\x18\x30\x60\xc0\x80\xe\xc\xc\xc\xc\xc\xc\xe\x8\x1c\x36\x63\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\xff"
"\xc\xc\x18\x0\x0\x0\x0\x0\x0\x0\x3e\x40\x7e\x41\x7e\x0\x1\x1\x3f\x41\x41\x41\x3f\x0\x0\x0\x3e\x41\x1\x41\x3e\x0\x40\x40\x7e\x41\x41\x41\x7e\x0\x0\x0\x3e\x41\x7f\x1\x3e\x0\x3c\x42\x2\x3f\x2\x2\x2\x0\x0\x0\xbe\x41\x41\x7e\x40\x3e"
"\x1\x1\x3f\x41\x41\x41\x41\x0\xc\x0\x8\x8\x8\x8\x1c\x0\x20\x0\x30\x20\x20\x20\x21\x1e\x1\x1\x31\x9\x7\x9\x31\x0\x8\x8\x8\x8\x8\x8\x18\x0\x0\x0\x63\x55\x49\x49\x41\x0\x0\x0\x3f\x41\x41\x41\x41\x0\x0\x0\x3e\x41\x41\x41\x3e\x0"
"\x0\x0\x3f\x41\x41\x3f\x1\x1\x0\x0\x7e\x41\x41\x7e\x40\xc0\x0\x0\x39\x66\x2\x2\x2\x0\x0\x0\x7e\x1\x3e\x40\x3f\x0\x8\x8\x3e\x8\x8\x8\x18\x0\x0\x0\x41\x41\x41\x41\x7e\x0\x0\x0\x41\x41\x41\x22\x1c\x0\x0\x0\x41\x49\x55\x63\x41\x0"
"\x0\x0\x22\x14\x8\x14\x22\x0\x0\x0\x41\x41\x41\x7e\x40\x3f\x0\x0\x7f\x10\x8\x4\x7f\x0\x70\x18\x18\xe\x18\x18\x70\x0\x18\x18\x18\x0\x18\x18\x18\x0\x7\xc\xc\x38\xc\xc\x7\x0\xe\xd9\x70\x0\x0\x0\x0\x0\x0\x0\x8\x14\x22\x7f\x0\x0"
"\xff\x1\x1\x1\x1\x1\x1\x1\xff\x0\x0\x0\x0\x0\x0\x0\xff\x80\x80\x80\x80\x80\x80\x80\x1\x1\x1\x1\x1\x1\x1\x1\x80\x80\x80\x80\x80\x80\x80\x80\x1\x1\x1\x1\x1\x1\x1\xff\x0\x0\x0\x0\x0\x0\x0\xff\x80\x80\x80\x80\x80\x80\x80\xff"
"\x1\x0\x0\x0\x0\x0\x0\x0\x80\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x1\x0\x0\x0\x0\x0\x0\x0\x80\x1\x3\x7\xf\x1f\x3f\x7f\xff\xff\xfe\xfc\xf8\xf0\xe0\xc0\x80\xff\xff\x3\x3\x3\x3\x3\x3\xff\xff\x0\x0\x0\x0\x0\x0"
"\xff\xff\xc0\xc0\xc0\xc0\xc0\xc0\x3\x3\x3\x3\x3\x3\x3\x3\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\x3\x3\x3\x3\x3\x3\xff\xff\x0\x0\x0\x0\x0\x0\xff\xff\xc0\xc0\xc0\xc0\xc0\xc0\xff\xff\x3\x3\x0\x0\x0\x0\x0\x0\xc0\xc0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x3\x3\x0\x0\x0\x0\x0\x0\xc0\xc0\x0\x0\x0\x55\x0\x0\x0\x0\x0\x1e\x33\x2d\x2d\x33\x1e\x0\x0\x3c\x66\x5a\x5a\x66\x3c\x0\x0\x78\xcc\xb4\xb4\xcc\x78\x0\x0\xf0\x98\x68\x68\x98\xf0\x0\x0\xe0\x30\xd0\xd0\x30\xe0\x0"
"\x0\xc0\x60\xa0\xa0\x60\xc0\x0\x0\x80\xc0\x40\x40\xc0\x80\x0\x0\x0\x80\x80\x80\x80\x0\x0\x0\x0\x1\x1\x1\x1\x0\x0\x0\x1\x3\x2\x2\x3\x1\x0\x0\x3\x6\x5\x5\x6\x3\x0\x0\x7\xc\xb\xb\xc\x7\x0\x0\xf\x19\x16\x16\x19\xf\x0"
"\x36\x2a\x36\x2a\x36\x2a\x36\x2a\xff\xff\x0\x0\x0\x8\x1c\x3e\xff\xff\x0\x0\x0\x0\x0\x7f\xff\xff\x0\x0\x8\x1c\x3e\x7f\xff\xff\x0\xc3\xe7\xff\xdb\xc3\x0\x0\x0\x0\x10\x0\x0\x0\x0\x3\x3\x3\x3\x3\x3\x3\x0\x1b\x1b\x1b\x1b\x1b\x1b\x1b"
"\x0\xdb\xdb\xdb\xdb\xdb\xdb\xdb\x0\x6\x6\x6\x6\x6\x6\x6\x0\x36\x36\x36\x36\x36\x36\x36\x0\xb6\xb6\xb6\xb6\xb6\xb6\xb6\x0\x1\x1\x1\x1\x1\x1\x1\x0\xd\xd\xd\xd\xd\xd\xd\x0\x6d\x6d\x6d\x6d\x6d\x6d\x6d\x0\x0\x18\x3c\x3c\x18\x0\x0"
"\x0\x0\x0\x1f\x18\x1f\x18\x18\x6c\x6c\x6c\x6f\x60\x6f\x6c\x6c\x6c\x6c\x6c\x6c\x6c\x6c\x6c\x6c\x0\x0\x0\x7f\x60\x6f\x6c\x6c\x6c\x6c\x6c\x6f\x60\x7f\x0\x0\x6c\x6c\x6c\x7f\x0\x0\x0\x0\x18\x18\x18\x1f\x18\x1f\x0\x0\x0\x0\x0\x1f\x18\x18\x18\x18"
"\x18\x18\x18\xf8\x0\x0\x0\x0\x18\x18\x18\xff\x0\x0\x0\x0\x0\x0\x0\xff\x18\x18\x18\x18\x18\x18\x18\xf8\x18\x18\x18\x18\x0\x0\x0\x0\xff\x0\x0\x0\x18\x18\x18\xff\x18\x18\x18\x18\x18\x18\x18\xf8\x18\xf8\x18\x18\x6c\x6c\x6c\xec\x6c\x6c\x6c\x6c"
"\x6c\x6c\x6c\xec\xc\xfc\x0\x0\x0\x0\x0\xfc\xc\xec\x6c\x6c\x6c\x6c\x6c\xef\x0\xff\x0\x0\x0\x0\x0\xff\x0\xef\x6c\x6c\x6c\x6c\x6c\xec\xc\xec\x6c\x6c\x0\x0\x0\xff\x0\xff\x0\x0\x6c\x6c\x6c\xef\x0\xef\x6c\x6c\x18\x18\x18\xff\x0\xff\x0\x0"
"\x6c\x6c\x6c\xff\x0\x0\x0\x0\x0\x0\x0\xff\x0\xff\x18\x18\x0\x0\x0\xff\x6c\x6c\x6c\x6c\x6c\x6c\x6c\xfc\x0\x0\x0\x0\x18\x18\x18\xf8\x18\xf8\x0\x0\x0\x0\x0\xf8\x18\xf8\x18\x18\x0\x0\x0\xfc\x6c\x6c\x6c\x6c\x6c\x6c\x6c\xff\x6c\x6c\x6c\x6c"
"\x18\x18\x18\xff\x18\xff\x18\x18\x18\x18\x18\x1f\x0\x0\x0\x0\x0\x0\x0\xf8\x18\x18\x18\x18\xff\xff\xff\xff\xff\xff\xff\xff\x0\x0\x0\x0\xff\xff\xff\xff\xf\xf\xf\xf\xf\xf\xf\xf\xf0\xf0\xf0\xf0\xf0\xf0\xf0\xf0\xff\xff\xff\xff\x0\x0\x0\x0"
"\x0\x0\xee\x19\x19\xee\x0\x0\x38\x6c\x66\x3f\x63\x63\x3f\x3\x7f\x46\x6\x6\x6\x6\x6\x0\x0\x0\xff\x66\x66\x66\x66\x0\x7f\x46\xc\x18\xc\x46\x7f\x0\x0\x0\xfc\x66\x63\x33\x1e\x0\x0\x0\xcc\xcc\xcc\x7c\xc\xf\x0\x0\xff\x18\x18\x18\x18\x0"
"\x3c\x18\x3c\x66\x66\x3c\x18\x3c\x0\x3e\x63\x7f\x63\x3e\x0\x0\x0\x7e\xc3\xc3\xc3\x66\xe7\x0\x78\x98\x3c\x66\x63\x33\x1e\x0\x0\x0\x66\x99\x99\x66\x0\x0\x0\xc0\x3e\x73\x67\x3e\x3\x0\x0\x7c\x3\x7f\x3\x7c\x0\x0\x0\x0\x0\x0\x0\xdb\xdb\x0"
"\x0\x7e\x0\x7e\x0\x7e\x0\x0\x0\xf8\x8\x8\x8\x8\xf8\x0\x0\xff\x0\x0\x0\x0\xff\x0\x0\x1f\x10\x10\x10\x10\x1f\x0\x0\x0\x0\x8\x0\x0\x0\x0\x0\x0\x0\x2\x1\x0\x0\x0\x20\x30\x28\x24\x22\xa1\x60\x20\x0\x0\x0\x1\x2\x0\x0\x0"
"\x20\x60\xa1\x22\x24\x28\x30\x20\x0\x0\x0\x40\x40\x40\x40\x7f\xff\x81\x81\x81\x81\x80\x80\x80\x0\x0\x0\x20\x20\x11\x11\xe\x38\x44\x44\x82\x82\x0\x0\x0\x0\x0\xfe\x7c\x38\x10\x0\x0\x0\x0\x10\x38\x7c\xfe\x0\x0\x80\xc1\x63\x36\x1c\x8\x0\x0"
),
// Font no. 8
FontEntry("FN-ICE", 8, 8, 
"\x0\x0\x0\x0\x0\x0\x0\x0\x7e\x81\xa5\x81\xbd\x99\x81\x7e\x7e\xff\xdb\xff\xc3\xe7\xff\x7e\x36\x7f\x7f\x7f\x3e\x1c\x8\x0\x8\x1c\x3e\x7f\x3e\x1c\x8\x0\x1c\x3e\x1c\x7f\x7f\x49\x8\x3e\x0\x8\x1c\x3e\x7f\x3e\x1c\x3e\x0\x0\x18\x3c\x3c\x18\x0\x0"
"\xff\xff\xe7\xc3\xc3\xe7\xff\xff\x0\x3c\x66\x42\x42\x66\x3c\x0\xff\xc3\x99\xbd\xbd\x99\xc3\xff\xf0\xe0\xf0\xbe\x33\x33\x33\x1e\x3c\x66\x66\x66\x3c\x18\x7e\x18\xfc\xcc\xfc\xc\xc\xe\xf\x7\xfe\xc6\xfe\xc6\xc6\xe6\x67\x3\x99\x5a\x3c\xe7\xe7\x3c\x5a\x99"
"\x1\x7\x1f\x7f\x1f\x7\x1\x0\x40\x70\x7c\x7f\x7c\x70\x40\x0\x18\x3c\x7e\x18\x18\x7e\x3c\x18\x66\x66\x66\x66\x66\x0\x66\x0\xfe\xdb\xdb\xde\xd8\xd8\xd8\x0\x7c\xc6\x1c\x36\x36\x1c\x61\x3f\x0\x0\x0\x0\x7e\x7e\x7e\x0\x18\x3c\x7e\x18\x7e\x3c\x18\xff"
"\x18\x3c\x7e\x18\x18\x18\x18\x0\x18\x18\x18\x18\x7e\x3c\x18\x0\x0\x18\x30\x7f\x30\x18\x0\x0\x0\xc\x6\x7f\x6\xc\x0\x0\x0\x0\x3\x3\x3\x7f\x0\x0\x0\x24\x66\xff\x66\x24\x0\x0\x0\x18\x3c\x7e\xff\xff\x0\x0\x0\xff\xff\x7e\x3c\x18\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x4\xc\x1c\x1c\x1c\x0\x1c\x0\x36\x36\x14\x0\x0\x0\x0\x0\x0\x14\x3e\x14\x3e\x14\x0\x0\x8\x3c\x6a\xc\x38\x6a\x3c\x8\x0\x7a\x25\x12\x8\x24\x52\x20\x10\x0\x18\x24\x4\x18\x0\x8\xc\xc\x6\x0\x0\x0\x0\x0"
"\x30\x18\xc\xc\xc\xc\x18\x30\xc\x18\x30\x30\x30\x30\x18\xc\x0\x41\x36\x1c\x3e\x5d\x8\x8\x0\x18\x18\x7e\x18\x18\x0\x0\x0\x0\x0\x0\x0\x18\x18\xc\x0\x0\x0\x7e\x0\x0\x0\x0\x0\x0\x0\x0\x0\x18\x18\x0\x40\x60\x30\x18\xc\x6\x2\x0"
"\x3e\x63\x63\x63\x63\x63\x3e\x0\x8\x8\xc\xe\xc\xc\x1e\x0\x1e\x23\x31\x18\x6\x23\x3f\x0\x1e\x23\x20\x1c\x20\x23\x1e\x0\x23\x23\x23\x23\x3e\x20\x20\x0\x3f\x3\x3\x3f\x20\x21\x1e\x0\x3e\x3\x3\x1f\x23\x23\x1e\x0\x3f\x23\x20\x10\x8\xc\xc\x0"
"\x1e\x23\x23\x1e\x23\x23\x1e\x0\x1e\x23\x23\x3e\x20\x23\x1e\x0\x0\x18\x18\x0\x0\x18\x18\x0\x0\x18\x18\x0\x0\x18\x18\xc\x0\x60\x30\x18\xc\x18\x30\x60\x0\x0\x0\x7e\x0\x7e\x0\x0\x0\x6\xc\x18\x30\x18\xc\x6\x3e\x47\x20\x10\x18\x0\x18\x0"
"\x3e\x41\x5d\x45\x5d\x41\x3e\x0\x7\xf\x1b\x33\x3f\x33\x33\x0\xf\x1b\x33\x7f\x33\x63\x3f\x0\x7\xf\x1b\x33\x3\x3\x3f\x0\x7\xf\x1b\x33\x63\x63\x3f\x0\x7\xf\x1b\x33\xf\x3\x3f\x0\x7\xf\x1b\x33\xf\x3\x3\x0\xf\x1f\x33\x23\x1b\x23\x3f\x0"
"\x3\x3\x13\x33\x3f\x33\x33\x0\x8\x18\x18\x18\x18\x18\x18\x0\x20\x30\x30\x30\x33\x33\x3e\x0\x3\x1b\x33\x33\xf\x33\x33\x0\x3\x3\x3\x3\x3\x3\x7f\x0\x63\x77\x7f\x6b\x63\x63\x63\x0\x3\x17\x3b\x33\x33\x33\x33\x0\x6\xf\x1b\x33\x63\x63\x3e\x0"
"\x7\xf\x1b\x33\x3f\x3\x3\x0\xe\x1b\x33\x63\x63\x33\x6e\x0\x7\xf\x1b\x33\x1f\x33\x33\x0\x7\xf\x1b\x3\x1e\x20\x1f\x0\x3\x6\xc\x1c\x2c\xc\xc\x0\x3\x3\x23\x63\x63\x63\x3e\x0\x3\x3\x23\x63\x36\x1c\x8\x0\x3\x3\x23\x6b\x6b\x6b\x3e\x0"
"\x22\x63\x36\x8\x36\x63\x22\x0\x3\x13\x33\x36\x3c\x20\x1f\x0\x6\xd\x18\x18\xc\x6\x3f\x0\x38\xc\xc\xc\xc\xc\xc\x38\x2\x6\xc\x18\x30\x60\x40\x0\x1c\x30\x30\x30\x30\x30\x30\x1c\x8\x1c\x36\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\xff"
"\xc\xc\x18\x0\x0\x0\x0\x0\x0\x0\x0\x3e\x33\x33\x6e\x0\x1\x3\x3\x1f\x33\x33\x1f\x0\x0\x0\x0\x1e\x33\x3\x3e\x0\x30\x30\x30\x3e\x33\x33\x3e\x0\x0\x0\x0\x1e\x33\xf\x3e\x0\x1c\x36\x6\x6\x1f\x6\x6\x0\x0\x0\x0\x1e\x33\x3e\x31\x1e"
"\x3\x3\x3\x1f\x33\x33\x33\x0\x0\xc\x0\xc\xc\xc\xc\x0\x0\x30\x0\x30\x30\x33\x33\x1e\x3\x3\x33\x1b\xf\x1b\x33\x0\xe\xc\xc\xc\xc\xc\xc\x0\x0\x0\x0\x37\x7f\x6b\x63\x0\x0\x0\x0\x1d\x33\x33\x33\x0\x0\x0\x0\x1e\x33\x33\x1e\x0"
"\x0\x0\x0\x3b\x66\x3e\x6\xf\x0\x0\x0\x6e\x33\x3e\x30\x78\x0\x0\x0\x3c\x66\x6\x6\x0\x0\x0\x0\x3e\x7\x38\x1f\x0\x0\x8\xc\x3f\xc\x6c\x38\x0\x0\x0\x0\x33\x33\x33\x6e\x0\x0\x0\x0\x33\x33\x1e\xc\x0\x0\x0\x0\x6b\x6b\x7f\x36\x0"
"\x0\x0\x0\x77\x18\xc\x77\x0\x0\x0\x0\x33\x33\x3e\x30\x1f\x0\x0\x0\x7f\x30\xe\x7f\x0\x38\xc\xc\x7\xc\xc\x38\x0\x18\x18\x18\x0\x18\x18\x18\x0\x7\xc\xc\x38\xc\xc\x7\x0\xff\x0\x0\x0\x0\x0\x0\x0\x0\x8\x1c\x36\x63\x63\x7f\x0"
"\xff\x1\x1\x1\x1\x1\x1\x1\xff\x0\x0\x0\x0\x0\x0\x0\xff\x80\x80\x80\x80\x80\x80\x80\x1\x1\x1\x1\x1\x1\x1\x1\x80\x80\x80\x80\x80\x80\x80\x80\x1\x1\x1\x1\x1\x1\x1\xff\x0\x0\x0\x0\x0\x0\x0\xff\x80\x80\x80\x80\x80\x80\x80\xff"
"\x1\x0\x0\x0\x0\x0\x0\x0\x80\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x1\x0\x0\x0\x0\x0\x0\x0\x80\x1\x3\x7\xf\x1f\x3f\x7f\xff\xff\xfe\xfc\xf8\xf0\xe0\xc0\x80\xff\xff\x3\x3\x3\x3\x3\x3\xff\xff\x0\x0\x0\x0\x0\x0"
"\xff\xff\xc0\xc0\xc0\xc0\xc0\xc0\x3\x3\x3\x3\x3\x3\x3\x3\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\x3\x3\x3\x3\x3\x3\xff\xff\x0\x0\x0\x0\x0\x0\xff\xff\xc0\xc0\xc0\xc0\xc0\xc0\xff\xff\x3\x3\x0\x0\x0\x0\x0\x0\xc0\xc0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x3\x3\x0\x0\x0\x0\x0\x0\xc0\xc0\x0\x0\xaa\x55\x55\xaa\x0\x0\x0\x0\xe\x7f\xff\x7f\xe\x0\x0\x0\x3c\x7e\xff\x7e\x3c\x0\x0\x0\x70\xfe\xff\xfe\x70\x0\x0\x0\xe0\xfc\xfe\xfc\xe0\x0\x0\x0\x0\xf0\xfc\xf0\x0\x0"
"\x0\x0\x0\xc0\xf8\xc0\x0\x0\x0\x0\x0\x80\xf0\x80\x0\x0\x0\x0\x0\x80\xe0\x80\x0\x0\x0\x0\x0\x1\x7\x1\x0\x0\x0\x0\x0\x1\xf\x1\x0\x0\x0\x0\x0\x3\x1f\x3\x0\x0\x0\x0\x0\xf\x3f\xf\x0\x0\x0\x0\x7\x3f\x7f\x3f\x7\x0"
"\x24\x18\x24\x18\x24\x18\x24\x18\xff\xff\x3e\x1c\x8\x8\x0\x0\xff\xff\x1c\x8\x8\x0\x0\x0\xff\xff\x3e\x3e\x1c\x1c\x8\x8\xff\xff\x0\x42\x66\x5a\x42\x42\x0\x0\x0\x18\x18\x0\x0\x0\x0\x0\x1\x3\x3\x3\x0\x0\x0\x1\x3\xb\x1b\x7\x6\x0"
"\x0\xbb\xbb\x77\x77\x77\xee\xee\x0\x0\x1\x3\x7\x3\x1\x0\x0\x1\xb\x17\x37\x17\x6\x2\x0\xbb\xbb\x77\x77\x77\xee\xee\x0\x0\x1\x1\x1\x1\x0\x0\x0\x0\x3\x3\xf\x7\x2\x0\x0\xbb\xbb\x77\x77\x77\xee\xee\x0\x0\x18\x3c\x3c\x18\x0\x0"
"\x0\x0\x1f\x18\x1f\x18\x18\x18\x6c\x6c\x6f\x60\x6f\x6c\x6c\x6c\x6c\x6c\x6c\x6c\x6c\x6c\x6c\x6c\x0\x0\x7f\x60\x6f\x6c\x6c\x6c\x6c\x6c\x6f\x60\x7f\x0\x0\x0\x6c\x6c\x6c\x6c\x7f\x0\x0\x0\x18\x18\x1f\x18\x1f\x0\x0\x0\x0\x0\x0\x0\x1f\x18\x18\x18"
"\x18\x18\x18\x18\xf8\x0\x0\x0\x18\x18\x18\x18\xff\x0\x0\x0\x0\x0\x0\x0\xff\x18\x18\x18\x18\x18\x18\x18\xf8\x18\x18\x18\x0\x0\x0\x0\xff\x0\x0\x0\x18\x18\x18\x18\xff\x18\x18\x18\x18\x18\xf8\x18\xf8\x18\x18\x18\x6c\x6c\x6c\x6c\xec\x6c\x6c\x6c"
"\x6c\x6c\xec\xc\xfc\x0\x0\x0\x0\x0\xfc\xc\xec\x6c\x6c\x6c\x6c\x6c\xef\x0\xff\x0\x0\x0\x0\x0\xff\x0\xef\x6c\x6c\x6c\x6c\x6c\xec\xc\xec\x6c\x6c\x6c\x0\x0\xff\x0\xff\x0\x0\x0\x6c\x6c\xef\x0\xef\x6c\x6c\x6c\x18\x18\xff\x0\xff\x0\x0\x0"
"\x6c\x6c\x6c\x6c\xff\x0\x0\x0\x0\x0\xff\x0\xff\x18\x18\x18\x0\x0\x0\x0\xff\x6c\x6c\x6c\x6c\x6c\x6c\x6c\xfc\x0\x0\x0\x18\x18\xf8\x18\xf8\x0\x0\x0\x0\x0\xf8\x18\xf8\x18\x18\x18\x0\x0\x0\x0\xfc\x6c\x6c\x6c\x6c\x6c\x6c\x6c\xff\x6c\x6c\x6c"
"\x18\x18\xff\x18\xff\x18\x18\x18\x18\x18\x18\x18\x1f\x0\x0\x0\x0\x0\x0\x0\xf8\x18\x18\x18\xff\xff\xff\xff\xff\xff\xff\xff\x0\x0\x0\x0\xff\xff\xff\xff\xf\xf\xf\xf\xf\xf\xf\xf\xf0\xf0\xf0\xf0\xf0\xf0\xf0\xf0\xff\xff\xff\xff\x0\x0\x0\x0"
"\x0\x0\x6e\x3b\x13\x3b\x6e\x0\x0\x1e\x33\x1f\x33\x1f\x3\x3\x0\x3f\x33\x3\x3\x3\x3\x0\x0\x0\x7f\x36\x36\x36\x36\x0\x3f\x33\x6\xc\x6\x33\x3f\x0\x0\x0\x7e\x1b\x1b\x1b\xe\x0\x0\x66\x66\x66\x66\x3e\x6\x3\x0\x6e\x3b\x18\x18\x18\x18\x0"
"\x3f\xc\x1e\x33\x33\x1e\xc\x3f\x1c\x36\x63\x7f\x63\x36\x1c\x0\x1c\x36\x63\x63\x36\x36\x77\x0\x38\xc\x18\x3e\x33\x33\x1e\x0\x0\x0\x7e\xdb\xdb\x7e\x0\x0\x60\x30\x7e\xdb\xdb\x7e\x6\x3\x1c\x6\x3\x1f\x3\x6\x1c\x0\x0\x0\x0\x0\x0\xdb\xdb\x0"
"\x0\x7e\x0\x7e\x0\x7e\x0\x0\x0\xf8\x8\x8\x8\x8\xf8\x0\x0\xff\x0\x0\x0\x0\xff\x0\x0\x1f\x10\x10\x10\x10\x1f\x0\x0\x0\x0\x8\x0\x0\x0\x0\x0\x0\x0\x2\x1\x0\x0\x0\x20\x30\x28\x24\x22\xa1\x60\x20\x0\x0\x0\x1\x2\x0\x0\x0"
"\x20\x60\xa1\x22\x24\x28\x30\x20\x0\x0\x0\x40\x40\x40\x40\x7f\xff\x81\x81\x81\x81\x80\x80\x80\x0\x0\x0\x20\x20\x11\x11\xe\x38\x44\x44\x82\x82\x0\x0\x0\x0\x0\xfe\x7c\x38\x10\x0\x0\x0\x0\x10\x38\x7c\xfe\x0\x0\x80\xc1\x63\x36\x1c\x8\x0\x0"
),
// Font no. 9
FontEntry("FN-LOWER", 8, 8, 
"\x0\x0\x0\x0\x0\x0\x0\x0\x7e\x81\xa5\x81\xbd\x99\x81\x7e\x7e\xff\xdb\xff\xc3\xe7\xff\x7e\x36\x7f\x7f\x7f\x3e\x1c\x8\x0\x8\x1c\x3e\x7f\x3e\x1c\x8\x0\x1c\x3e\x1c\x7f\x7f\x49\x8\x3e\x0\x8\x1c\x3e\x7f\x3e\x1c\x3e\x0\x0\x18\x3c\x3c\x18\x0\x0"
"\xff\xff\xe7\xc3\xc3\xe7\xff\xff\x0\x3c\x66\x42\x42\x66\x3c\x0\xff\xc3\x99\xbd\xbd\x99\xc3\xff\xf0\xe0\xf0\xbe\x33\x33\x33\x1e\x3c\x66\x66\x66\x3c\x18\x7e\x18\xfc\xcc\xfc\xc\xc\xe\xf\x7\xfe\xc6\xfe\xc6\xc6\xe6\x67\x3\x99\x5a\x3c\xe7\xe7\x3c\x5a\x99"
"\x1\x7\x1f\x7f\x1f\x7\x1\x0\x40\x70\x7c\x7f\x7c\x70\x40\x0\x18\x3c\x7e\x18\x18\x7e\x3c\x18\x66\x66\x66\x66\x66\x0\x66\x0\xfe\xdb\xdb\xde\xd8\xd8\xd8\x0\x7c\xc6\x1c\x36\x36\x1c\x61\x3f\x0\x0\x0\x0\x7e\x7e\x7e\x0\x18\x3c\x7e\x18\x7e\x3c\x18\xff"
"\x18\x3c\x7e\x18\x18\x18\x18\x0\x18\x18\x18\x18\x7e\x3c\x18\x0\x0\x18\x30\x7f\x30\x18\x0\x0\x0\xc\x6\x7f\x6\xc\x0\x0\x0\x0\x3\x3\x3\x7f\x0\x0\x0\x24\x66\xff\x66\x24\x0\x0\x0\x18\x3c\x7e\xff\xff\x0\x0\x0\xff\xff\x7e\x3c\x18\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x18\x3c\x3c\x18\x18\x0\x18\x0\x36\x36\x36\x0\x0\x0\x0\x0\x0\x0\x14\x3e\x14\x3e\x14\x0\x18\x7e\x3\x3e\x60\x3f\x18\x0\x0\x63\x33\x18\xc\x66\x63\x0\x1c\x36\x1c\x6e\x3b\x33\x6e\x0\xc\xc\x6\x0\x0\x0\x0\x0"
"\x18\xc\x6\x6\x6\xc\x18\x0\x6\xc\x18\x18\x18\xc\x6\x0\x0\x66\x3c\xff\x3c\x66\x0\x0\x0\x18\x18\x7e\x18\x18\x0\x0\x0\x0\x0\x0\x0\x18\x18\xc\x0\x0\x0\x0\x3e\x0\x0\x0\x0\x0\x0\x0\x0\x18\x18\x0\x60\x30\x18\xc\x6\x3\x1\x0"
"\x3e\x73\x7b\x6f\x67\x63\x3e\x0\xc\xe\xc\xc\xc\xc\x3f\x0\x1e\x33\x30\x1c\x6\x33\x3f\x0\x1e\x33\x30\x1c\x30\x33\x1e\x0\x38\x3c\x36\x33\x7f\x30\x78\x0\x3f\x3\x1f\x30\x30\x33\x1e\x0\x1c\x6\x3\x1f\x33\x33\x1e\x0\x3f\x33\x30\x18\xc\xc\xc\x0"
"\x1e\x33\x33\x1e\x33\x33\x1e\x0\x1e\x33\x33\x3e\x30\x18\xe\x0\x0\x18\x18\x0\x0\x18\x18\x0\x0\x18\x18\x0\x0\x18\x18\xc\x18\xc\x6\x3\x6\xc\x18\x0\x0\x0\x7e\x0\x7e\x0\x0\x0\x6\xc\x18\x30\x18\xc\x6\x0\x3c\x66\x30\x18\x18\x0\x18\x0"
"\x3e\x63\x7b\x7b\x3b\x3\x3e\x0\x0\x0\x1e\x30\x3e\x33\x6e\x0\x7\x6\x6\x3e\x66\x66\x3b\x0\x0\x0\x1e\x33\x3\x33\x1e\x0\x38\x30\x30\x3e\x33\x33\x6e\x0\x0\x0\x1e\x33\x3f\x3\x1e\x0\x1c\x36\x26\xf\x6\x6\xf\x0\x0\x0\x6e\x33\x33\x3e\x30\x1f"
"\x7\x6\x36\x6e\x66\x66\x67\x0\xc\x0\xe\xc\xc\xc\x1e\x0\x30\x0\x38\x30\x30\x33\x33\x1e\x7\x6\x66\x36\x1e\x36\x67\x0\xe\xc\xc\xc\xc\xc\x1e\x0\x0\x0\x33\x7f\x7f\x6b\x6b\x0\x0\x0\x1d\x33\x33\x33\x33\x0\x0\x0\x1e\x33\x33\x33\x1e\x0"
"\x0\x0\x3b\x66\x66\x3e\x6\xf\x0\x0\x6e\x33\x33\x3e\x30\x78\x0\x0\x3b\x6e\x46\x6\xf\x0\x0\x0\x3e\x3\xe\x38\x1f\x0\x8\xc\x3f\xc\xc\x2c\x18\x0\x0\x0\x33\x33\x33\x33\x6e\x0\x0\x0\x33\x33\x33\x1e\xc\x0\x0\x0\x63\x63\x6b\x7f\x36\x0"
"\x0\x0\x63\x36\x1c\x36\x63\x0\x0\x0\x33\x33\x33\x3e\x30\x1f\x0\x0\x3f\x19\xc\x26\x3f\x0\x1e\x6\x6\x6\x6\x6\x1e\x0\x3\x6\xc\x18\x30\x60\x40\x0\x1e\x18\x18\x18\x18\x18\x1e\x0\x8\x1c\x36\x63\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\xff"
"\xc\xc\x18\x0\x0\x0\x0\x0\x0\x0\x1e\x30\x3e\x33\x6e\x0\x7\x6\x6\x3e\x66\x66\x3b\x0\x0\x0\x1e\x33\x3\x33\x1e\x0\x38\x30\x30\x3e\x33\x33\x6e\x0\x0\x0\x1e\x33\x3f\x3\x1e\x0\x1c\x36\x26\xf\x6\x6\xf\x0\x0\x0\x6e\x33\x33\x3e\x30\x1f"
"\x7\x6\x36\x6e\x66\x66\x67\x0\xc\x0\xe\xc\xc\xc\x1e\x0\x30\x0\x38\x30\x30\x33\x33\x1e\x7\x6\x66\x36\x1e\x36\x67\x0\xe\xc\xc\xc\xc\xc\x1e\x0\x0\x0\x33\x7f\x7f\x6b\x6b\x0\x0\x0\x1d\x33\x33\x33\x33\x0\x0\x0\x1e\x33\x33\x33\x1e\x0"
"\x0\x0\x3b\x66\x66\x3e\x6\xf\x0\x0\x6e\x33\x33\x3e\x30\x78\x0\x0\x3b\x6e\x46\x6\xf\x0\x0\x0\x3e\x3\xe\x38\x1f\x0\x8\xc\x3f\xc\xc\x2c\x18\x0\x0\x0\x33\x33\x33\x33\x6e\x0\x0\x0\x33\x33\x33\x1e\xc\x0\x0\x0\x63\x63\x6b\x7f\x36\x0"
"\x0\x0\x63\x36\x1c\x36\x63\x0\x0\x0\x33\x33\x33\x3e\x30\x1f\x0\x0\x3f\x19\xc\x26\x3f\x0\x38\xc\xc\x7\xc\xc\x38\x0\x18\x18\x18\x0\x18\x18\x18\x0\x7\xc\xc\x38\xc\xc\x7\x0\x6e\x3b\x0\x0\x0\x0\x0\x0\x0\x8\x1c\x36\x63\x63\x7f\x0"
"\xff\xff\x3\x3\x3\x3\x3\x3\xff\xff\x0\x0\x0\x0\x0\x0\xff\xff\xc0\xc0\xc0\xc0\xc0\xc0\x3\x3\x3\x3\x3\x3\x3\x3\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\x3\x3\x3\x3\x3\x3\xff\xff\x0\x0\x0\x0\x0\x0\xff\xff\xc0\xc0\xc0\xc0\xc0\xc0\xff\xff"
"\x3\x3\x0\x0\x0\x0\x0\x0\xc0\xc0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x3\x3\x0\x0\x0\x0\x0\x0\xc0\xc0\x3\x1\x3\x7\xf\x1f\xbf\xff\xff\xfd\xf8\xf0\xe0\xc0\x80\xc0\xff\xff\x7\x7\x7\x7\x7\x7\xff\xff\x0\x0\x0\x0\x0\x0"
"\xff\xff\xe0\xe0\xe0\xe0\xe0\xe0\x7\x7\x7\x7\x7\x7\x7\x7\xe0\xe0\xe0\xe0\xe0\xe0\xe0\xe0\x7\x7\x7\x7\x7\x7\xff\xff\x0\x0\x0\x0\x0\x0\xff\xff\xe0\xe0\xe0\xe0\xe0\xe0\xff\xff\x7\x7\x0\x0\x0\x0\x0\x0\xe0\xe0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x7\x7\x0\x0\x0\x0\x0\x0\xe0\xe0\x0\x0\x0\x0\x55\x0\x0\x0\x0\x3f\x3f\x3f\x3f\x3f\x3f\x0\x0\x7e\x7e\x7e\x7e\x7e\x7e\x0\x0\xfc\xfc\xfc\xfc\xfc\xfc\x0\x0\xf8\xf8\xf8\xf8\xf8\xf8\x0\x0\xf0\xf0\xf0\xf0\xf0\xf0\x0"
"\x0\xe0\xe0\xe0\xe0\xe0\xe0\x0\x0\xc0\xc0\xc0\xc0\xc0\xc0\x0\x0\x80\x80\x80\x80\x80\x80\x0\x0\x1\x1\x1\x1\x1\x1\x0\x0\x3\x3\x3\x3\x3\x3\x0\x0\x7\x7\x7\x7\x7\x7\x0\x0\xf\xf\xf\xf\xf\xf\x0\x0\x1f\x1f\x1f\x1f\x1f\x1f\x0"
"\x3c\x3c\x3c\x3c\x3c\x3c\x3c\x3c\xff\xff\x0\x18\x3c\x7e\xff\x0\xff\xff\x0\x0\x0\x0\x18\x18\xff\xff\x0\x18\x3c\x7e\xff\x18\xff\xff\x0\x42\x66\x5a\x42\x42\x0\x0\x0\x0\x18\x0\x0\x0\x0\x3\x3\x3\x3\x3\x3\x3\x0\x1b\x1b\x1b\x1b\x1b\x1b\x1b"
"\x0\xdb\xdb\xdb\xdb\xdb\xdb\xdb\x0\x6\x6\x6\x6\x6\x6\x6\x0\x36\x36\x36\x36\x36\x36\x36\x0\xb6\xb6\xb6\xb6\xb6\xb6\xb6\x0\x1\x1\x1\x1\x1\x1\x1\x0\xd\xd\xd\xd\xd\xd\xd\x0\x6d\x6d\x6d\x6d\x6d\x6d\x6d\x0\x0\x0\x18\x3c\x18\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x38\x44\x82\x0\x0\x0\x0\x0\x0\x0\x0\x41\x22\x1c\x0\x0\xfc\x84\x84\x84\x80\x80\x0\x0\x0\x0\x10\x10\x10\x1f\x0\x0\x80\x80\x80\x8c\xb0\xc0\x0\x0\x1\x6\x18\x0\x0\x0\x0\x3c\x66\x30\x18\x18\x0\x18\x0"
"\x3c\x66\x30\x18\x18\x0\x18\x0\x0\x0\x0\x0\x8\x0\x0\x0\x0\x0\x0\x8\x1c\x8\x0\x0\x0\x0\x0\x18\x3c\x18\x0\x0\x0\x0\x0\x0\xff\x0\x0\x0\x0\x0\x3c\x3c\x3c\x3c\x0\x0\x0\x18\x3c\x7e\x7e\x3c\x18\x0\x0\x3c\x7e\x7e\x7e\x7e\x3c\x0"
"\x18\x7e\x7e\xff\xff\x7e\x7e\x18\x3c\x7e\xff\xff\xff\xff\x7e\x3c\x6c\x6c\xef\x0\xff\x0\x0\x0\x0\x0\xff\x0\xef\x6c\x6c\x6c\x6c\x6c\xec\xc\xec\x6c\x6c\x6c\x0\x0\xff\x0\xff\x0\x0\x0\x6c\x6c\xef\x0\xef\x6c\x6c\x6c\x18\x18\xff\x0\xff\x0\x0\x0"
"\x6c\x6c\x6c\x6c\xff\x0\x0\x0\x0\x0\xff\x0\xff\x18\x18\x18\x0\x0\x0\x0\xff\x6c\x6c\x6c\x6c\x6c\x6c\x6c\xfc\x0\x0\x0\x18\x18\xf8\x18\xf8\x0\x0\x0\x0\x0\xf8\x18\xf8\x18\x18\x18\x0\x0\x0\x0\xfc\x6c\x6c\x6c\x6c\x6c\x6c\x6c\xff\x6c\x6c\x6c"
"\x18\x18\xff\x18\xff\x18\x18\x18\x18\x18\x18\x18\x1f\x0\x0\x0\x0\x0\x0\x0\xf8\x18\x18\x18\xff\xff\xff\xff\xff\xff\xff\xff\x0\x0\x0\x0\xff\xff\xff\xff\xf\xf\xf\xf\xf\xf\xf\xf\xf0\xf0\xf0\xf0\xf0\xf0\xf0\xf0\xff\xff\xff\xff\x0\x0\x0\x0"
"\x0\x0\x6e\x3b\x13\x3b\x6e\x0\x0\x1e\x33\x1f\x33\x1f\x3\x3\x0\x3f\x33\x3\x3\x3\x3\x0\x0\x0\x7f\x36\x36\x36\x36\x0\x3f\x33\x6\xc\x6\x33\x3f\x0\x0\x0\x7e\x1b\x1b\x1b\xe\x0\x0\x66\x66\x66\x66\x3e\x6\x3\x0\x6e\x3b\x18\x18\x18\x18\x0"
"\x3f\xc\x1e\x33\x33\x1e\xc\x3f\x1c\x36\x63\x7f\x63\x36\x1c\x0\x1c\x36\x63\x63\x36\x36\x77\x0\x38\xc\x18\x3e\x33\x33\x1e\x0\x0\x0\x7e\xdb\xdb\x7e\x0\x0\x60\x30\x7e\xdb\xdb\x7e\x6\x3\x1c\x6\x3\x1f\x3\x6\x1c\x0\x0\x0\x0\x0\x0\xdb\xdb\x0"
"\x0\x7e\x0\x7e\x0\x7e\x0\x0\x0\xf8\x8\x8\x8\x8\xf8\x0\x0\xff\x0\x0\x0\x0\xff\x0\x0\x1f\x10\x10\x10\x10\x1f\x0\x0\x0\x0\x8\x0\x0\x0\x0\x0\x0\x0\x2\x1\x0\x0\x0\x20\x30\x28\x24\x22\xa1\x60\x20\x0\x0\x0\x1\x2\x0\x0\x0"
"\x20\x60\xa1\x22\x24\x28\x30\x20\x0\x0\x0\x40\x40\x40\x40\x7f\xff\x81\x81\x81\x81\x80\x80\x80\x0\x0\x0\x20\x20\x11\x11\xe\x38\x44\x44\x82\x82\x0\x0\x0\x0\x0\xfe\x7c\x38\x10\x0\x0\x0\x0\x10\x38\x7c\xfe\x0\x0\x80\xc1\x63\x36\x1c\x8\x0\x0"
),
// Font no. 10
FontEntry("FN-ROUND", 8, 8, 
"\x0\x0\x0\x0\x0\x0\x0\x0\x78\x84\xaa\x81\xb9\x9d\x81\x7e\x78\xfc\xd6\xff\xc7\xe3\xff\x7e\x0\x6c\xfe\xfe\x7c\x38\x10\x0\x10\x38\x7c\xfe\x7c\x38\x10\x0\x10\x38\x54\xfe\x54\x10\x38\x0\x10\x38\x7c\xfe\xd6\x10\x7c\x0\x0\x0\x18\x3c\x3c\x18\x0\x0"
"\xff\xff\xe7\xc3\xc3\xe7\xff\xff\x0\x3c\x66\x42\x42\x66\x3c\x0\xff\xc3\x99\xbd\xbd\x99\xc3\xff\xe0\xc0\xae\x19\x11\x13\xe\x0\x38\x4c\x46\x46\x3c\x18\x7e\x18\xfc\xcc\xfc\xc\xc\xe\xf\x7\xfe\xc6\xfe\xc6\xc6\xe6\x67\x3\x99\x5a\x3c\xe7\xe7\x3c\x5a\x99"
"\x1\x7\x1f\x7f\x1f\x7\x1\x0\x40\x70\x7c\x7f\x7c\x70\x40\x0\x18\x3c\x7e\x18\x18\x7e\x3c\x18\x66\x66\x66\x66\x66\x0\x66\x0\xfe\xdb\xdb\xde\xd8\xd8\xd8\x0\x7c\xc6\x1c\x36\x36\x1c\x61\x3f\x0\x0\x0\x0\x7e\x7e\x7e\x0\x18\x3c\x7e\x18\x7e\x3c\x18\xff"
"\x18\x3c\x7e\x18\x18\x18\x18\x0\x18\x18\x18\x18\x7e\x3c\x18\x0\x0\x18\x30\x7f\x30\x18\x0\x0\x0\xc\x6\x7f\x6\xc\x0\x0\x0\x0\x3\x3\x3\x7f\x0\x0\x0\x24\x66\xff\x66\x24\x0\x0\x0\x18\x3c\x7e\xff\xff\x0\x0\x0\xff\xff\x7e\x3c\x18\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x30\x38\x38\x18\x18\x0\xc\x0\x6c\x36\x36\x0\x0\x0\x0\x0\x0\x6c\x6c\xff\x66\xff\x36\x36\x0\x10\x78\x16\x3c\x48\x3e\x8\x0\x6e\x35\x1a\x2c\x56\x3b\x0\x30\x0\x70\xc\x6\x3c\x0\x18\xc\xc\x6\x0\x0\x0\x0\x0"
"\x70\x1c\x6\x6\x6\xc\x18\x0\x18\x30\x60\x60\x60\x38\xe\x0\x0\x10\x92\x7c\x38\x6c\x82\x0\x0\x0\x18\x18\x7e\x18\x18\x0\x0\x0\x0\x0\x20\x20\x30\x18\x0\x0\x0\x0\xff\x0\x0\x0\x0\x0\x0\x0\x0\x30\x38\x0\x60\x30\x18\xc\x6\x3\x1\x0"
"\x30\x6c\x66\x63\x63\x63\x3e\x0\x30\x38\x30\x30\x18\x18\x3c\x0\x30\x6c\x66\x30\x18\x4c\x3e\x0\x30\x6c\x66\x30\x60\x66\x3c\x0\x60\x68\x6c\x66\x3e\x30\x30\x0\x70\xc\x6\x3e\x40\x62\x3c\x0\x70\x18\xc\x36\x4e\x46\x3c\x0\x70\x6e\x60\x30\x18\x18\xc\x0"
"\x70\x58\x4c\x38\x44\x66\x3c\x0\x30\x4c\x66\x3c\x30\x18\xc\x0\x0\x0\x30\x30\x0\x18\x18\x0\x0\x0\x30\x30\x0\x18\x18\xc\x70\x1c\x6\x3\x6\xc\x18\x0\x0\x0\x0\xfc\x0\x7e\x0\x0\x18\x30\x60\xc0\x60\x38\xe\x0\x38\x4c\x66\x30\x30\x0\x18\x0"
"\x78\x84\x9a\xa5\x79\x1\x7e\x0\x60\x78\x64\x66\x7f\x63\x63\x0\x30\x6c\x66\x37\x3b\x63\x3f\x0\x30\x6c\x66\x3\x3\x3\x7e\x0\x30\x6c\xc6\xc3\xc3\x63\x3f\x0\x30\x6c\x6\x3f\x3\x43\x3f\x0\x60\xd8\xc\x3f\x6\x6\x6\x0\x30\x6c\x6\x3\x73\x43\x3e\x0"
"\x64\x64\x66\x3f\x33\x33\x33\x0\x1c\x18\x18\x1c\xc\xc\xc\x0\x60\x60\x60\x32\x33\x33\x1f\x0\x4c\x66\x36\x1f\x33\x63\x63\x0\x10\xc\x6\x3\x3\x3\x7f\x0\x44\x6e\x6e\x7a\x6b\x6b\x63\x0\x44\x6e\x6e\x6a\x7b\x73\x63\x0\x30\x6c\x66\x63\x63\x77\x3e\x0"
"\x30\x6c\x66\x63\x3f\x3\x3\x0\x30\x6c\x66\x63\x63\x3b\x6e\x0\x30\x6c\x66\x63\x3f\x63\x63\x0\x30\x6c\x6\x7\x7e\x40\x3e\x0\x70\x1e\x18\x18\xc\xc\xe\x0\x68\x6c\x66\x63\x63\x63\x7e\x0\x68\x6c\x66\x63\x63\x36\x1c\x0\x68\x6c\x66\x63\x6b\x6b\x3e\x0"
"\x80\xc3\x66\x1c\x38\xe6\xc3\x0\x6c\x66\x63\x33\x1e\xc\xc\x0\x7c\x4e\x63\x38\xc\x46\x3f\x0\x38\xc\xc\x6\x6\x6\x1e\x0\x4\xc\xc\x18\x30\x60\xc0\x0\x1c\x30\x30\x30\x18\x18\x1e\x0\x18\x2c\x6e\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\xff"
"\x18\xc\xc\x0\x0\x0\x0\x0\x0\x0\x70\x4c\x46\x66\x5c\x0\xc\x6\x36\x4e\x46\x26\x1c\x0\x0\x0\x70\xc\x6\x46\x3c\x0\x60\x60\x78\x64\x46\x46\x3c\x0\x0\x0\x70\x4c\x3e\x6\x3c\x0\x30\x28\xc\x6\x1f\x6\x6\x6\x0\x0\x70\x4c\x66\x7c\x60\x3c"
"\x18\xc\x4\x36\x6e\x66\x66\x0\x0\x18\x0\x18\xc\xc\xc\x0\x0\x18\x0\x18\xc\xc\xc\x7\x8\xc\x64\x36\x2e\x66\x66\x0\x18\x18\x18\x18\xc\xc\xc\x0\x0\x0\x1a\x3e\x6b\x6b\x63\x0\x0\x0\x34\x7c\x66\x66\x66\x0\x0\x0\x30\x6c\x66\x66\x3c\x0"
"\x0\x0\x34\x4c\x44\x3e\x6\x6\x0\x0\x58\x24\x26\x3e\x60\x60\x0\x0\x66\x1c\xe\x6\x6\x0\x0\x0\x70\xe\x3c\x60\x3e\x0\x30\x30\x18\x78\x1e\x18\xc\xc\x0\x0\x68\x6c\x66\x36\x6c\x0\x0\x0\x68\x6c\x66\x34\x18\x0\x0\x0\x64\x66\x63\x6b\x36\x0"
"\x0\xc0\x63\x34\x18\x2c\xc6\x3\x0\x0\x68\x6c\x66\x3e\x30\x1e\x0\x0\x78\x44\x30\xc\x7e\x0\x20\x30\x18\xc\xc\x18\x10\x0\x30\x30\x30\x0\x18\x18\x18\x0\x8\x18\x30\x30\x18\xc\x4\x0\xff\x0\x0\x0\x0\x0\x0\x0\x0\x0\x8\x1c\x36\x7f\x0\x0"
"\xff\xf\x3\x1\x1\x1\x1\x1\xff\x0\x0\x0\x0\x0\x0\x0\xff\xe0\xc0\xc0\x80\x80\x80\x80\x1\x1\x1\x1\x1\x1\x1\x1\x80\x80\x80\x80\x80\x80\x80\x80\x1\x1\x1\x1\x3\x3\x7\xff\x0\x0\x0\x0\x0\x0\x0\xff\x80\x80\x80\x80\x80\xc0\xf0\xff"
"\x7\x0\x0\x0\x0\x0\x0\x0\x80\x80\x80\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x1\x1\x1\x0\x0\x0\x0\x0\x0\x0\xe0\x1\x3\x7\xf\x1f\x3f\x7f\xff\xff\xfe\xfc\xf8\xf0\xe0\xc0\x80\xff\xff\x3f\xf\x7\x3\x3\x3\xff\xff\x0\x0\x0\x0\x0\x0"
"\xff\xff\xf8\xf0\xe0\xe0\xc0\xc0\x3\x3\x3\x3\x3\x3\x3\x3\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\x3\x3\x7\x7\xf\x1f\xff\xff\x0\x0\x0\x0\x0\x0\xff\xff\xc0\xc0\xc0\xe0\xf0\xfc\xff\xff\x3\x1\x0\x0\x0\x0\x0\x0\xc0\x80\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x1\x3\x0\x0\x0\x0\x0\x0\x80\xc0\x0\x0\x0\xff\xff\x0\x0\x0\x0\x0\x1c\x3f\x7e\x3f\x1c\x0\x0\x0\x18\x7e\xff\x7e\x18\x0\x0\x0\x38\xfc\x7e\xfc\x38\x0\x0\x0\xe0\x78\x3c\x78\xe0\x0\x0\x0\xc0\x70\x38\x70\xc0\x0"
"\x0\x0\x0\xc0\x70\xc0\x0\x0\x0\x0\x0\x80\x40\x80\x0\x0\x0\x0\x80\x0\x0\x0\x80\x0\x0\x0\x1\x0\x0\x0\x1\x0\x0\x0\x0\x1\x2\x1\x0\x0\x0\x0\x0\x3\xe\x3\x0\x0\x0\x0\x3\x6\x1c\x6\x3\x0\x0\x0\x7\x1e\x3c\x1e\x7\x0"
"\x18\x18\x18\x18\x18\x18\x18\x18\xff\xff\x0\x18\x3c\x7e\xff\x0\xff\xff\x0\x0\x0\x0\x18\x18\xff\xff\x0\x18\x3c\x7e\xff\x18\xff\xff\x0\x42\x66\x5a\x42\x42\x0\x0\x0\x18\x18\x0\x0\x0\x0\x1\x0\x3\x3\x0\x1\x0\x0\xd\x0\x1f\x1f\x0\xd\x0"
"\x0\x6d\x0\xff\xff\x0\x6d\x0\x0\x3\x0\x7\x7\x0\x3\x0\x0\x1b\x0\x3f\x3f\x0\x1b\x0\x0\xdb\x0\xff\xff\x0\xdb\x0\x0\x0\x0\x1\x1\x0\x0\x0\x0\x6\x0\xf\xf\x0\x6\x0\x0\xb6\x0\xff\xff\x0\xb6\x0\x0\x0\x0\x0\x7f\x6c\x6c\x6c"
"\x0\x0\x1f\x18\x1f\x18\x18\x18\x6c\x6c\x6f\x60\x6f\x6c\x6c\x6c\x6c\x6c\x6c\x6c\x6c\x6c\x6c\x6c\x0\x0\x7f\x60\x6f\x6c\x6c\x6c\x6c\x6c\x6f\x60\x7f\x0\x0\x0\x6c\x6c\x6c\x6c\x7f\x0\x0\x0\x18\x18\x1f\x18\x1f\x0\x0\x0\x0\x0\x0\x0\x1f\x18\x18\x18"
"\x18\x18\x18\x18\xf8\x0\x0\x0\x18\x18\x18\x18\xff\x0\x0\x0\x0\x0\x0\x0\xff\x18\x18\x18\x18\x18\x18\x18\xf8\x18\x18\x18\x0\x0\x0\x0\xff\x0\x0\x0\x18\x18\x18\x18\xff\x18\x18\x18\x18\x18\xf8\x18\xf8\x18\x18\x18\x6c\x6c\x6c\x6c\xec\x6c\x6c\x6c"
"\x6c\x6c\xec\xc\xfc\x0\x0\x0\x0\x0\xfc\xc\xec\x6c\x6c\x6c\x6c\x6c\xef\x0\xff\x0\x0\x0\x0\x0\xff\x0\xef\x6c\x6c\x6c\x6c\x6c\xec\xc\xec\x6c\x6c\x6c\x0\x0\xff\x0\xff\x0\x0\x0\x6c\x6c\xef\x0\xef\x6c\x6c\x6c\x18\x18\xff\x0\xff\x0\x0\x0"
"\x6c\x6c\x6c\x6c\xff\x0\x0\x0\x0\x0\xff\x0\xff\x18\x18\x18\x0\x0\x0\x0\xff\x6c\x6c\x6c\x6c\x6c\x6c\x6c\xfc\x0\x0\x0\x18\x18\xf8\x18\xf8\x0\x0\x0\x0\x0\xf8\x18\xf8\x18\x18\x18\x0\x0\x0\x0\xfc\x6c\x6c\x6c\x6c\x6c\x6c\x6c\xff\x6c\x6c\x6c"
"\x18\x18\xff\x18\xff\x18\x18\x18\x18\x18\x18\x18\x1f\x0\x0\x0\x0\x0\x0\x0\xf8\x18\x18\x18\xff\xff\xff\xff\xff\xff\xff\xff\x0\x0\x0\x0\xff\xff\xff\xff\xf\xf\xf\xf\xf\xf\xf\xf\xf0\xf0\xf0\xf0\xf0\xf0\xf0\xf0\xff\xff\xff\xff\x0\x0\x0\x0"
"\x0\x0\x6e\x3b\x13\x3b\x6e\x0\x0\x1e\x33\x1f\x33\x1f\x3\x3\x0\x3f\x33\x3\x3\x3\x3\x0\x0\x0\x7f\x36\x36\x36\x36\x0\x3f\x33\x6\xc\x6\x33\x3f\x0\x0\x0\x7e\x1b\x1b\x1b\xe\x0\x0\x66\x66\x66\x66\x3e\x6\x3\x0\x6e\x3b\x18\x18\x18\x18\x0"
"\x3f\xc\x1e\x33\x33\x1e\xc\x3f\x1c\x36\x63\x7f\x63\x36\x1c\x0\x1c\x36\x63\x63\x36\x36\x77\x0\x38\xc\x18\x3e\x33\x33\x1e\x0\x0\x0\x7e\xdb\xdb\x7e\x0\x0\x60\x30\x7e\xdb\xdb\x7e\x6\x3\x1c\x6\x3\x1f\x3\x6\x1c\x0\x0\x0\x0\x0\x0\xdb\xdb\x0"
"\x0\x7e\x0\x7e\x0\x7e\x0\x0\x0\xf8\x8\x8\x8\x8\xf8\x0\x0\xff\x0\x0\x0\x0\xff\x0\x0\x1f\x10\x10\x10\x10\x1f\x0\x0\x0\x0\x8\x0\x0\x0\x0\x0\x0\x0\x2\x1\x0\x0\x0\x20\x30\x28\x24\x22\xa1\x60\x20\x0\x0\x0\x1\x2\x0\x0\x0"
"\x20\x60\xa1\x22\x24\x28\x30\x20\x0\x0\x0\x40\x40\x40\x40\x7f\xff\x81\x81\x81\x81\x80\x80\x80\x0\x0\x0\x20\x20\x11\x11\xe\x38\x44\x44\x82\x82\x0\x0\x0\x0\x0\xfe\x7c\x38\x10\x0\x0\x0\x0\x10\x38\x7c\xfe\x0\x0\x80\xc1\x63\x36\x1c\x8\x0\x0"
),
// Font no. 11
FontEntry("GRAFPAPR", 8, 8, 
"\x0\x0\x0\x0\x0\x0\x0\x0\x7e\x81\xa5\x81\xbd\x99\x81\x7e\x7e\xff\xdb\xff\xff\xc3\xe7\x7e\x0\x77\x7f\x7f\x3e\x1c\x8\x0\x8\x1c\x3e\x7f\x3e\x1c\x8\x0\x18\x3c\x18\xff\xff\x52\x18\x0\x8\x1c\x3e\x7f\x7f\x49\x1c\x0\x0\x0\x18\x3c\x18\x0\x0\x0"
"\xff\xff\xe7\xc3\xe7\xff\xff\xff\x0\x3c\x42\x81\x81\x42\x3c\x0\xff\xc3\xbd\x7e\x7e\xbd\xc3\xff\xf8\xe0\xb0\x3e\x63\x63\x3e\x0\x0\x7e\xc3\xc3\x7e\x18\x7e\x18\x20\x60\xe0\x20\x20\x3f\x1f\x0\x30\x50\xb0\xd0\x9f\x8f\xf0\xf0\x81\xc2\xbc\xe4\xa4\xfc\xea\xff"
"\x0\x0\x6\x1e\x7e\x1e\x6\x0\x0\x0\x60\x78\x7e\x78\x60\x0\x18\x7e\x18\x18\x18\x18\x7e\x18\x66\x66\x66\x66\x66\x0\x66\x0\xff\x6d\x6e\x6c\x6c\x6c\x6c\x0\x7e\x81\x3e\x42\x42\x7c\x81\x7e\x0\x0\x0\x7e\x7e\x0\x0\x0\x18\x7e\x18\x18\x7e\x18\x0\xff"
"\x18\x7e\x18\x18\x18\x18\x18\x0\x18\x18\x18\x18\x18\x7e\x18\x0\x0\x20\x60\xff\x60\x20\x0\x0\x0\x4\x6\xff\x6\x4\x0\x0\x0\x0\x0\x3\x3\x3\xff\x0\x0\x24\x66\xff\x66\x24\x0\x0\x0\x0\x8\x1c\x3e\x7f\x0\x0\x0\x0\x0\x7f\x3e\x1c\x8\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\xc\xc\xc\xc\xc\x0\xc\x0\x66\x66\x0\x0\x0\x0\x0\x0\xa\x1f\xa\x1f\xa\x0\x0\x0\x3e\x4b\xb\x3e\x68\x6b\x3e\x8\xc7\x65\x37\x18\xec\xa6\xe3\x0\x1c\x32\x1c\xa2\x63\x73\x5e\x80\x30\x30\x18\x0\x0\x0\x0\x0"
"\x8\x6\x3\x3\x3\x6\x8\x0\x8\x30\x60\x60\x60\x30\x8\x0\x0\x2a\x1c\x7f\x1c\x2a\x0\x0\x0\x18\x18\x7e\x18\x18\x0\x0\x0\x0\x0\x0\x0\x0\x18\xe\x0\x0\x0\x7e\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x30\x0\x80\xc0\x60\x30\x18\xc\x6\x3"
"\x0\x1c\x22\x22\x22\x22\x1c\x0\x18\x1c\x1e\x18\x18\x18\x3e\x0\x3e\x63\x60\x30\xc\x6\x7f\x0\x3e\x63\x60\x3c\x60\x63\x3e\x0\x70\x78\x6c\x66\x7f\x60\x60\x0\x7f\x3\x3\x3f\x60\x60\x3f\x0\x3e\x63\x3\x3f\x63\x63\x3e\x0\x7f\x60\x30\x18\xc\xc\xc\x0"
"\x3e\x63\x63\x3e\x63\x63\x3e\x0\x3e\x63\x63\x7e\x60\x63\x3e\x0\x0\xc\x0\x0\x0\xc\x0\x0\x0\xc\x0\x0\x0\xc\x4\x0\x0\x38\xc\x6\xc\x38\x0\x0\x0\x0\x7e\x0\x7e\x0\x0\x0\x0\xe\x18\x30\x18\xe\x0\x0\x3e\x63\x30\x18\xc\x0\xc\x0"
"\x3e\x41\x5d\x55\x7d\x1\x3e\x0\x0\x1c\x26\x43\x7f\x43\x43\x0\x0\x3f\x63\x3f\x63\x63\x3f\x0\x0\x3e\x63\x3\x3\x63\x3e\x0\x0\x3f\x63\x63\x63\x63\x3f\x0\x0\x7f\x3\x1f\x3\x3\x7f\x0\x0\x7f\x43\x1f\x13\x3\x3\x0\x0\x3e\x63\x3\x7b\x63\x5e\x0"
"\x63\x63\x63\x7f\x63\x63\x63\x0\x7e\x18\x18\x18\x18\x18\x7e\x0\x78\x30\x30\x30\x30\x33\x1e\x0\x63\x33\x1b\xf\x1b\x33\x63\x0\xf\x6\x6\x6\x6\x46\x7f\x0\x63\x77\x7f\x6b\x6b\x63\x63\x0\x63\x67\x6f\x7b\x73\x63\x63\x0\x3e\x63\x63\x63\x63\x63\x3e\x0"
"\x3f\x66\x66\x3e\x6\x6\xf\x0\x3e\x63\x63\x63\x7b\x73\x3e\x60\x3f\x66\x66\x3e\x66\x66\x67\xc0\x3e\x43\x3\x3e\x60\x63\x3e\x0\x7e\x18\x18\x18\x18\x18\x18\x0\x63\x63\x63\x63\x63\x63\x3e\x0\x63\x63\x63\x63\x63\x36\x1c\x0\x63\x63\x6b\x6b\x6b\x77\x63\x0"
"\x63\x36\x1c\x8\x1c\x36\x63\x0\x41\x63\x36\x1c\x8\x8\x1c\x0\x7f\x61\x30\x18\xc\x46\x7f\x0\x38\x18\x18\x18\x18\x18\x18\x38\x3\x6\xc\x18\x30\x60\xc0\x80\xe\xc\xc\xc\xc\xc\xc\xe\x8\x1c\x36\x63\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\xff"
"\xc\xc\x18\x0\x0\x0\x0\x0\x0\x0\x3e\x60\x7e\x63\x7e\x0\x3\x3\x3f\x63\x63\x63\x3f\x0\x0\x0\x3e\x63\x3\x63\x3e\x0\x60\x60\x7e\x63\x63\x63\x7e\x0\x0\x0\x3e\x63\x7f\x3\x3e\x0\x3c\x66\x6\x3f\x6\x6\x6\x0\x0\x0\xbe\x63\x63\x7e\x60\x3e"
"\x3\x3\x3f\x63\x63\x63\x63\x0\x18\x0\x1c\x18\x18\x18\x3c\x0\x30\x0\x38\x30\x30\x30\x33\x1e\x3\x3\x63\x1b\xf\x1b\x63\x0\x1c\x18\x18\x18\x18\x18\x38\x0\x0\x0\x63\x7f\x6b\x6b\x63\x0\x0\x0\x3f\x63\x63\x63\x63\x0\x0\x0\x3e\x63\x63\x63\x3e\x0"
"\x0\x0\x3f\x63\x63\x3f\x3\x3\x0\x0\x7e\x63\x63\x7e\x60\xe0\x0\x0\x7b\x6e\x66\x6\x6\x0\x0\x0\x7e\x3\x3e\x60\x3f\x0\x18\x18\x7e\x18\x18\x18\x78\x0\x0\x0\x63\x63\x63\x63\x7e\x0\x0\x0\x63\x63\x63\x36\x1c\x0\x0\x0\x63\x6b\x6b\x77\x63\x0"
"\x0\x0\x63\x36\x1c\x36\x63\x0\x0\x0\x63\x63\x63\x7e\x60\x3f\x0\x0\x7f\x30\x8\x46\x7f\x0\x70\x18\x18\xe\x18\x18\x70\x0\x18\x18\x18\x0\x18\x18\x18\x0\x7\xc\xc\x38\xc\xc\x7\x0\xe\xd9\x70\x0\x0\x0\x0\x0\x0\x0\x8\x14\x22\x7f\x0\x0"
"\xff\x1\x1\x1\x1\x1\x1\x1\xff\x0\x0\x0\x0\x0\x0\x0\xff\x80\x80\x80\x80\x80\x80\x80\x1\x1\x1\x1\x1\x1\x1\x1\x80\x80\x80\x80\x80\x80\x80\x80\x1\x1\x1\x1\x1\x1\x1\xff\x0\x0\x0\x0\x0\x0\x0\xff\x80\x80\x80\x80\x80\x80\x80\xff"
"\x1\x0\x0\x0\x0\x0\x0\x0\x80\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x1\x0\x0\x0\x0\x0\x0\x0\x80\x1\x3\x7\xf\x1f\x3f\x7f\xff\xff\xfe\xfc\xf8\xf0\xe0\xc0\x80\xff\xff\x3\x3\x3\x3\x3\x3\xff\xff\x0\x0\x0\x0\x0\x0"
"\xff\xff\xc0\xc0\xc0\xc0\xc0\xc0\x3\x3\x3\x3\x3\x3\x3\x3\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\x3\x3\x3\x3\x3\x3\xff\xff\x0\x0\x0\x0\x0\x0\xff\xff\xc0\xc0\xc0\xc0\xc0\xc0\xff\xff\x3\x3\x0\x0\x0\x0\x0\x0\xc0\xc0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x3\x3\x0\x0\x0\x0\x0\x0\xc0\xc0\x0\x0\x0\x55\x0\x0\x0\x0\x0\x3f\x3f\x3f\x3f\x3f\x3f\x0\x0\x7e\x7e\x7e\x7e\x7e\x7e\x0\x0\xfc\xfc\xfc\xfc\xfc\xfc\x0\x0\xf8\xf8\xf8\xf8\xf8\xf8\x0\x0\xf0\xf0\xf0\xf0\xf0\xf0\x0"
"\x0\xe0\xe0\xe0\xe0\xe0\xe0\x0\x0\xc0\xc0\xc0\xc0\xc0\xc0\x0\x0\x80\x80\x80\x80\x80\x80\x0\x0\x1\x1\x1\x1\x1\x1\x0\x0\x3\x3\x3\x3\x3\x3\x0\x0\x7\x7\x7\x7\x7\x7\x0\x0\xf\xf\xf\xf\xf\xf\x0\x0\x1f\x1f\x1f\x1f\x1f\x1f\x0"
"\x55\x6b\x55\x6b\x55\x6b\x55\x6b\xff\xff\x0\x0\x0\x8\x1c\x3e\xff\xff\x0\x0\x0\x0\x0\x7f\xff\xff\x0\x0\x8\x1c\x3e\x7f\xff\xff\x0\xc3\xe7\xff\xdb\xc3\xaa\xd5\xaa\xd5\xaa\xd5\xaa\xff\x0\x3\x3\x3\x3\x3\x3\x3\x0\x1b\x1b\x1b\x1b\x1b\x1b\x1b"
"\x0\xdb\xdb\xdb\xdb\xdb\xdb\xdb\x0\x6\x6\x6\x6\x6\x6\x6\x0\x36\x36\x36\x36\x36\x36\x36\x0\xb6\xb6\xb6\xb6\xb6\xb6\xb6\x0\x1\x1\x1\x1\x1\x1\x1\x0\xd\xd\xd\xd\xd\xd\xd\x0\x6d\x6d\x6d\x6d\x6d\x6d\x6d\x0\x0\x18\x3c\x3c\x18\x0\x0"
"\x0\x0\x0\x1f\x18\x1f\x18\x18\x6c\x6c\x6c\x6f\x60\x6f\x6c\x6c\x6c\x6c\x6c\x6c\x6c\x6c\x6c\x6c\x0\x0\x0\x7f\x60\x6f\x6c\x6c\x6c\x6c\x6c\x6f\x60\x7f\x0\x0\x6c\x6c\x6c\x7f\x0\x0\x0\x0\x18\x18\x18\x1f\x18\x1f\x0\x0\x0\x0\x0\x1f\x18\x18\x18\x18"
"\x18\x18\x18\xf8\x0\x0\x0\x0\x18\x18\x18\xff\x0\x0\x0\x0\x0\x0\x0\xff\x18\x18\x18\x18\x18\x18\x18\xf8\x18\x18\x18\x18\x0\x0\x0\x0\xff\x0\x0\x0\x18\x18\x18\xff\x18\x18\x18\x18\x18\x18\x18\xf8\x18\xf8\x18\x18\x6c\x6c\x6c\xec\x6c\x6c\x6c\x6c"
"\x6c\x6c\x6c\xec\xc\xfc\x0\x0\x0\x0\x0\xfc\xc\xec\x6c\x6c\x6c\x6c\x6c\xef\x0\xff\x0\x0\x0\x0\x0\xff\x0\xef\x6c\x6c\x6c\x6c\x6c\xec\xc\xec\x6c\x6c\x0\x0\x0\xff\x0\xff\x0\x0\x6c\x6c\x6c\xef\x0\xef\x6c\x6c\x18\x18\x18\xff\x0\xff\x0\x0"
"\x6c\x6c\x6c\xff\x0\x0\x0\x0\x0\x0\x0\xff\x0\xff\x18\x18\x0\x0\x0\xff\x6c\x6c\x6c\x6c\x6c\x6c\x6c\xfc\x0\x0\x0\x0\x18\x18\x18\xf8\x18\xf8\x0\x0\x0\x0\x0\xf8\x18\xf8\x18\x18\x0\x0\x0\xfc\x6c\x6c\x6c\x6c\x6c\x6c\x6c\xff\x6c\x6c\x6c\x6c"
"\x18\x18\x18\xff\x18\xff\x18\x18\x18\x18\x18\x1f\x0\x0\x0\x0\x0\x0\x0\xf8\x18\x18\x18\x18\xff\xff\xff\xff\xff\xff\xff\xff\x0\x0\x0\x0\xff\xff\xff\xff\xf\xf\xf\xf\xf\xf\xf\xf\xf0\xf0\xf0\xf0\xf0\xf0\xf0\xf0\xff\xff\xff\xff\x0\x0\x0\x0"
"\x0\x0\xee\x19\x19\xee\x0\x0\x38\x6c\x66\x3f\x63\x63\x3f\x3\x7f\x46\x6\x6\x6\x6\x6\x0\x0\x0\xff\x66\x66\x66\x66\x0\x7f\x46\xc\x18\xc\x46\x7f\x0\x0\x0\xfc\x66\x63\x33\x1e\x0\x0\x0\xcc\xcc\xcc\x7c\xc\xf\x0\x0\xff\x18\x18\x18\x18\x0"
"\x3c\x18\x3c\x66\x66\x3c\x18\x3c\x0\x3e\x63\x7f\x63\x3e\x0\x0\x0\x7e\xc3\xc3\xc3\x66\xe7\x0\x78\x98\x3c\x66\x63\x33\x1e\x0\x0\x0\x66\x99\x99\x66\x0\x0\x0\xc0\x3e\x73\x67\x3e\x3\x0\x0\x7c\x3\x7f\x3\x7c\x0\x0\x0\x0\x0\x0\x0\xdb\xdb\x0"
"\x0\x7e\x0\x7e\x0\x7e\x0\x0\x0\xf8\x8\x8\x8\x8\xf8\x0\x0\xff\x0\x0\x0\x0\xff\x0\x0\x1f\x10\x10\x10\x10\x1f\x0\x0\x0\x0\x8\x0\x0\x0\x0\x0\x0\x0\x2\x1\x0\x0\x0\x20\x30\x28\x24\x22\xa1\x60\x20\x0\x0\x0\x1\x2\x0\x0\x0"
"\x20\x60\xa1\x22\x24\x28\x30\x20\x0\x0\x0\x40\x40\x40\x40\x7f\xff\x81\x81\x81\x81\x80\x80\x80\x0\x0\x0\x20\x20\x11\x11\xe\x38\x44\x44\x82\x82\x0\x0\x0\x0\x0\xfe\x7c\x38\x10\x0\x0\x0\x0\x10\x38\x7c\xfe\x0\x0\x80\xc1\x63\x36\x1c\x8\x0\x0"
),
// Font no. 12
FontEntry("GTHS-BUG", 8, 8, 
"\x0\x0\x0\x0\x0\x0\x0\x0\x7e\x81\xa5\x81\xbd\x99\x81\x7e\x7e\xff\xdb\xff\xc3\xe7\xff\x7e\x36\x7f\x7f\x7f\x3e\x1c\x8\x0\x8\x1c\x3e\x7f\x3e\x1c\x8\x0\x1c\x3e\x1c\x7f\x7f\x3e\x1c\x3e\x8\x8\x1c\x3e\x7f\x3e\x1c\x3e\x0\x0\x18\x3c\x3c\x18\x0\x0"
"\xff\xff\xe7\xc3\xc3\xe7\xff\xff\x0\x3c\x66\x42\x42\x66\x3c\x0\xff\xc3\x99\xbd\xbd\x99\xc3\xff\xf0\xe0\xf0\xbe\x33\x33\x33\x1e\x3c\x66\x66\x66\x3c\x18\x7e\x18\xfc\xcc\xfc\xc\xc\xe\xf\x7\xfe\xc6\xfe\xc6\xc6\xe6\x67\x3\x0\x0\x0\x3c\x0\x3c\x0\x0"
"\x1\x7\x1f\x7f\x1f\x7\x1\x0\x40\x70\x7c\x7f\x7c\x70\x40\x0\x18\x3c\x7e\x18\x18\x7e\x3c\x18\x66\x66\x66\x66\x66\x0\x66\x0\x0\x7c\x56\x56\x7c\x50\x50\x0\x3c\x66\x1c\x36\x36\x1c\x33\x1e\x0\x0\x0\x0\x7e\x7e\x7e\x0\x18\x3c\x7e\x18\x7e\x3c\x18\xff"
"\x18\x3c\x7e\x18\x18\x18\x18\x0\x18\x18\x18\x18\x7e\x3c\x18\x0\x0\x18\x30\x7f\x30\x18\x0\x0\x0\xc\x6\x7f\x6\xc\x0\x0\x0\x0\x3\x3\x3\x7f\x0\x0\x0\x24\x66\xff\x66\x24\x0\x0\x0\x18\x3c\x66\xdb\xbd\x0\x0\x0\xbd\xdb\x66\x3c\x18\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x1c\x1c\x1c\x1c\x1c\x0\x1c\x0\x36\x36\x36\x0\x0\x0\x0\x0\x36\x36\x7f\x36\x7f\x36\x36\x0\xc\x3e\x3\x1e\x30\x1f\xc\x0\x0\x63\x33\x18\xc\x66\x63\x0\x1c\x36\x1c\x6e\x3b\x33\x6e\x0\x6\x6\x3\x0\x0\x0\x0\x0"
"\x18\xc\x6\x6\x6\xc\x18\x0\x6\xc\x18\x18\x18\xc\x6\x0\x0\x66\x3c\xff\x3c\x66\x0\x0\x0\xc\xc\x3f\xc\xc\x0\x0\x0\x0\x0\x0\x0\x1c\x18\xc\x0\x0\x0\x3f\x0\x0\x0\x0\x0\x0\x0\x0\x0\x1c\x1c\x0\x60\x30\x18\xc\x6\x3\x1\x0"
"\x3e\x63\x63\x6b\x63\x63\x3e\x0\x18\x1e\x18\x18\x18\x18\x7e\x0\x3e\x60\x60\x3e\x3\x3\x7f\x0\x3e\x60\x60\x3c\x60\x60\x3f\x0\x68\x6c\x66\x63\x7f\x60\x60\x0\x7f\x3\x1f\x30\x60\x60\x3f\x0\x3c\x6\x3\x3b\x63\x63\x3e\x0\x7f\x60\x30\x30\x18\x18\xc\x0"
"\x7e\x63\x63\x3e\x63\x63\x3e\x0\x3e\x63\x63\x6e\x60\x30\x1e\x0\x0\x1c\x1c\x0\x0\x1c\x1c\x0\x0\x1c\x1c\x0\x0\x1c\x18\xc\x18\xc\x6\x3\x6\xc\x18\x0\x0\x0\x3f\x0\x0\x3f\x0\x0\x6\xc\x18\x30\x18\xc\x6\x0\x3f\x60\x30\x18\x18\x0\x18\x0"
"\x3e\x63\x7b\x7b\x7b\x3\x1e\x0\x1e\x30\x63\x63\x7f\x63\x63\x40\x3f\x63\x63\x3b\x63\x33\x1f\x0\x7e\x3\x3\x3\x3\x6\x7c\x0\x3f\x63\x63\x63\x63\x33\x1f\x0\x3e\x63\x3\x3b\x3\x3\x7e\x0\x7c\x6\x6\x3f\x6\x6\x6\x0\x7e\x3\x3\x73\x63\x66\x7c\x40"
"\x63\x63\x3\x7f\x63\x63\x63\x40\x3c\x0\x18\x18\x18\x18\x3c\x0\x78\x0\x60\x60\x60\x30\x1f\x0\x63\x33\x1b\xf\x33\x63\x63\x40\x3\x3\x3\x3\x3\x3\x7f\x0\x3f\x63\x6b\x6b\x6b\x6b\x63\x40\x1f\x30\x63\x63\x63\x63\x63\x40\x3e\x63\x63\x63\x63\x66\x3c\x0"
"\x3f\x63\x63\x33\x1f\x3\x3\x0\x3e\x63\x63\x63\x6b\x2e\x18\x70\x3f\x63\x63\x33\x1f\x33\x63\x40\x7e\x3\x6\x3c\x60\x60\x3f\x0\x7e\x18\x18\x18\x18\x18\x18\x0\x63\x63\x63\x63\x63\x6\x7c\x0\x63\x63\x63\x63\x36\x1c\x8\x0\x6b\x6b\x6b\x6b\x6b\x63\x3f\x0"
"\x43\x63\x36\x1c\x36\x63\x63\x40\x63\x63\x63\x66\x7c\x63\x3e\x0\x7f\x60\x30\x18\xc\x6\x7f\x0\x1e\x6\x6\x6\x6\x6\x1e\x0\x3\x6\xc\x18\x30\x60\x40\x0\x1e\x18\x18\x18\x18\x18\x1e\x0\x8\x1c\x36\x63\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\xff"
"\xc\xc\x18\x0\x0\x0\x0\x0\x0\x0\x7e\x63\x63\x63\x6e\x0\x3\x3\x1f\x33\x63\x63\x3b\x0\x0\x0\x7e\x63\x3\x6\x7c\x0\x60\x60\x7c\x66\x63\x63\x6e\x0\x0\x0\x7e\x63\x7f\x3\x7e\x0\x7c\x6\x6\x1f\x6\x6\x6\x0\x0\x0\x7e\x63\x63\x6e\x60\x3f"
"\x3\x3\x1f\x33\x63\x63\x63\x0\x18\x0\x18\x18\x18\x18\x18\x0\x30\x0\x30\x30\x30\x30\x30\x1f\x3\x3\x7f\xf\x1b\x33\x63\x0\x10\x18\x18\x18\x18\x18\x18\x0\x0\x0\x3f\x6b\x6b\x6b\x63\x0\x0\x0\x3f\x63\x63\x63\x63\x0\x0\x0\x3e\x63\x63\x66\x3c\x0"
"\x0\x0\x3b\x63\x63\x3f\x3\x3\x0\x0\x6e\x63\x63\x7e\x60\x60\x0\x0\x7b\xf\x7\x3\x3\x0\x0\x0\x7e\x3\x3e\x60\x3f\x0\x8\xc\x3f\xc\xc\xc\x38\x0\x0\x0\x63\x63\x63\x63\x6e\x0\x0\x0\x63\x63\x36\x1c\x8\x0\x0\x0\x63\x6b\x7f\x3e\x14\x0"
"\x0\x0\x63\x36\x1c\x36\x63\x0\x0\x0\x63\x63\x63\x7e\x60\x3f\x0\x0\x7f\x30\x1c\x6\x7f\x0\x38\xc\xc\x7\xc\xc\x38\x0\x18\x18\x18\x0\x18\x18\x18\x0\x7\xc\xc\x38\xc\xc\x7\x0\x6e\x3b\x0\x0\x0\x0\x0\x0\x0\x8\x1c\x36\x63\x63\x7f\x0"
"\xfe\x3\xf9\x5\x5\x5\x5\x5\xff\x0\xff\x0\x0\x0\x0\x0\x7f\xc0\x9f\xa0\xa0\xa0\xa0\xa0\x5\x5\x5\x5\x5\x5\x5\x5\xa0\xa0\xa0\xa0\xa0\xa0\xa0\xa0\x5\x5\x5\x5\x5\xf9\x3\xfe\x0\x0\x0\x0\x0\xff\x0\xff\xa0\xa0\xa0\xa0\xa0\x9f\xc0\x7f"
"\x4\x6\x3\x0\x0\x0\x0\x0\x20\x60\xc0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x3\x6\x4\x0\x0\x0\x0\x0\xc0\x60\x20\x9\x12\x25\x4b\x97\x2f\x5e\xbc\x3d\x7a\xf4\xe9\xd2\xa4\x48\x90\xfc\xfe\x7\xf3\xb\xb\xb\xb\xff\xff\x0\xff\x0\x0\x0\x0"
"\x3f\x7f\xe0\xcf\xd0\xd0\xd0\xd0\xb\xb\xb\xb\xb\xb\xb\xb\xd0\xd0\xd0\xd0\xd0\xd0\xd0\xd0\xb\xb\xb\xb\xf3\x7\xfe\xfc\x0\x0\x0\x0\xff\x0\xff\xff\xd0\xd0\xd0\xd0\xcf\xe0\x7f\x3f\xb\x9\xc\x7\x0\x0\x0\x0\xd0\x90\x30\xe0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x7\xc\x9\xb\x0\x0\x0\x0\xe0\x30\x90\xd0\x0\x0\x33\x66\x33\x0\x0\x0\x0\x0\xc\x16\x3e\x3f\x33\x0\x42\x18\xaa\x38\x3c\x7e\x32\x0\x0\x0\x30\x58\x7c\xfc\x30\x0\x0\x0\x0\x60\xb8\xf8\x30\x0\x0\x0\x0\xc0\x60\xf0\x30\x0"
"\x0\x0\x0\x80\xc0\xe0\x20\x0\x0\x0\x0\x0\x80\xc0\x20\x0\x0\x0\x0\x0\x0\x80\x20\x0\x0\x0\x0\x0\x0\x1\x1\x0\x0\x0\x0\x0\x1\x3\x3\x0\x0\x0\x0\x1\x2\x7\x3\x0\x0\x0\x0\x3\x5\xf\x3\x0\x0\x0\x0\x6\x1b\x1f\x13\x0"
"\x5a\x4a\x42\x52\x5a\x4a\x42\x52\xff\xff\x0\x18\x3c\x66\xc3\x81\xff\xff\x0\x0\x0\x0\x18\x3c\xff\xff\x0\x18\x3c\x66\xdb\xbd\xff\xff\x0\x22\x77\x7f\x6b\x22\x0\x0\x0\x18\x0\x0\x0\x0\x0\x7\x0\x4\x6\x0\x7\x0\x0\x1f\x0\xc\x6\x0\x1f\x0"
"\x0\xff\x0\xcc\x66\x0\xff\x0\x0\x7\x0\x4\x6\x0\x7\x0\x0\x3f\x0\xc\x26\x0\x3f\x0\x0\xff\x0\xcc\x66\x0\xff\x0\x0\x1\x0\x0\x0\x0\x1\x0\x0\x1f\x0\xc\x6\x0\x1f\x0\x0\xff\x0\xcc\x66\x0\xff\x0\x0\x18\x3c\x66\x3c\x18\x0\x0"
"\x0\x24\x7e\x3c\x7e\x24\x0\x0\x6c\x6c\x6f\x60\x6f\x6c\x6c\x6c\x6c\x6c\x6c\x6c\x6c\x6c\x6c\x6c\x0\x0\x7f\x60\x6f\x6c\x6c\x6c\x6c\x6c\x6f\x60\x7f\x0\x0\x0\x6c\x6c\x6c\x6c\x7f\x0\x0\x0\x18\x18\x1f\x18\x1f\x0\x0\x0\x0\x0\x0\x0\x1f\x18\x18\x18"
"\x18\x18\x18\x18\xf8\x0\x0\x0\x18\x18\x18\x18\xff\x0\x0\x0\x0\x0\x0\x0\xff\x18\x18\x18\x18\x18\x18\x18\xf8\x18\x18\x18\x0\x0\x0\x0\xff\x0\x0\x0\x18\x18\x18\x18\xff\x18\x18\x18\x18\x18\xf8\x18\xf8\x18\x18\x18\x6c\x6c\x6c\x6c\xec\x6c\x6c\x6c"
"\x6c\x6c\xec\xc\xfc\x0\x0\x0\x0\x0\xfc\xc\xec\x6c\x6c\x6c\x6c\x6c\xef\x0\xff\x0\x0\x0\x0\x0\xff\x0\xef\x6c\x6c\x6c\x6c\x6c\xec\xc\xec\x6c\x6c\x6c\x0\x0\xff\x0\xff\x0\x0\x0\x6c\x6c\xef\x0\xef\x6c\x6c\x6c\x18\x18\xff\x0\xff\x0\x0\x0"
"\x6c\x6c\x6c\x6c\xff\x0\x0\x0\x0\x0\xff\x0\xff\x18\x18\x18\x0\x0\x0\x0\xff\x6c\x6c\x6c\x6c\x6c\x6c\x6c\xfc\x0\x0\x0\x18\x18\xf8\x18\xf8\x0\x0\x0\x0\x0\xf8\x18\xf8\x18\x18\x18\x0\x0\x0\x0\xfc\x6c\x6c\x6c\x6c\x6c\x6c\x6c\xff\x6c\x6c\x6c"
"\x18\x18\xff\x18\xff\x18\x18\x18\x18\x18\x18\x18\x1f\x0\x0\x0\x0\x0\x0\x0\xf8\x18\x18\x18\xff\xff\xff\xff\xff\xff\xff\xff\x0\x0\x0\x0\xff\xff\xff\xff\xf\xf\xf\xf\xf\xf\xf\xf\xf0\xf0\xf0\xf0\xf0\xf0\xf0\xf0\xff\xff\xff\xff\x0\x0\x0\x0"
"\x0\x0\x6e\x3b\x13\x3b\x6e\x0\x0\x1e\x33\x1f\x33\x1f\x3\x3\x0\x3f\x33\x3\x3\x3\x3\x0\x0\x7f\x36\x36\x36\x36\x36\x0\x3f\x33\x6\xc\x6\x33\x3f\x0\x0\x0\x7e\x1b\x1b\x1b\xe\x0\x0\x66\x66\x66\x66\x3e\x6\x3\x0\x6e\x3b\x18\x18\x18\x18\x0"
"\x3f\xc\x1e\x33\x33\x1e\xc\x3f\x1c\x36\x63\x7f\x63\x36\x1c\x0\x1c\x36\x63\x63\x36\x36\x77\x0\x38\xc\x18\x3e\x33\x33\x1e\x0\x0\x0\x7e\xdb\xdb\x7e\x0\x0\x60\x30\x7e\xdb\xdb\x7e\x6\x3\x1c\x6\x3\x1f\x3\x6\x1c\x0\x0\x0\x0\x0\x0\xdb\xdb\x0"
"\x0\x7e\x0\x7e\x0\x7e\x0\x0\x0\xf8\x8\x8\x8\x8\xf8\x0\x0\xff\x0\x0\x0\x0\xff\x0\x0\x1f\x10\x10\x10\x10\x1f\x0\x0\x0\x0\x8\x0\x0\x0\x0\x0\x0\x0\x2\x1\x0\x0\x0\x20\x30\x28\x24\x22\xa1\x60\x20\x0\x0\x0\x1\x2\x0\x0\x0"
"\x20\x60\xa1\x22\x24\x28\x30\x20\x0\x0\x0\x40\x40\x40\x40\x7f\xff\x81\x81\x81\x81\x80\x80\x80\x0\x0\x0\x20\x20\x11\x11\xe\x38\x44\x44\x82\x82\x0\x0\x0\x0\x0\xfe\x7c\x38\x10\x0\x0\x0\x0\x10\x38\x7c\xfe\x0\x0\x80\xc1\x63\x36\x1c\x8\x0\x0"
),
// Font no. 13
FontEntry("IDC-Harmonica", 8, 8, 
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x18\x18\x18\x18\x18\x0\x18\x0\x36\x36\x12\x0\x0\x0\x0\x0\x36\x36\x7f\x36\x7f\x36\x36\x0\x8\x7e\xb\x3e\x68\x3f\x8\x0\x6\x69\x36\x18\xc\x36\x4b\x30\x1e\x33\x16\x6e\x3b\x33\x6e\x0\x18\x18\xc\x0\x0\x0\x0\x0"
"\x18\xc\x6\x6\x6\xc\x18\x0\xc\x18\x30\x30\x30\x18\xc\x0\x0\x36\x7f\x7f\x3e\x1c\x8\x0\x0\x18\x18\x7e\x18\x18\x0\x0\x18\x18\xc\x0\x0\x0\x0\x0\x0\x0\x0\x3e\x0\x0\x0\x0\x0\x0\x0\x0\x0\x18\x18\x0\xc0\x60\x30\x18\xc\x6\x3\x0"
"\x0\x1e\x33\x7b\x6f\x67\x3e\x0\x18\x18\x1c\x18\x18\x18\x7e\x0\x3e\x60\x3e\x3\x3\x3\x7f\x0\x7e\x60\x38\x60\x60\x63\x3e\x0\xc\x4c\x66\x63\x7f\x60\x60\x0\x7f\x3\x3f\x60\x60\x63\x3e\x0\x3e\x3\x3f\x63\x63\x63\x3e\x0\x7f\x60\x30\x18\xc\xc\xc\x0"
"\x3e\x63\x3e\x63\x63\x63\x3e\x0\x3e\x63\x63\x63\x7e\x60\x30\x0\x0\x18\x18\x0\x18\x18\x0\x0\x0\x18\x18\x0\x18\x18\x10\x0\x30\x18\xc\x6\xc\x18\x30\x0\x0\x0\x7e\x0\x7e\x0\x0\x0\xc\x18\x30\x60\x30\x18\xc\x0\x3e\x63\x60\x3c\xc\x0\xc\x0"
"\x3c\x66\x63\x7b\x3b\x3\x7e\x0\x3c\x66\x63\x7f\x63\x63\x63\x0\x1f\x33\x3f\x63\x63\x63\x3f\x0\x3c\x66\x3\x3\x3\x63\x3e\x0\x1f\x33\x63\x63\x63\x63\x3f\x0\x7f\x3\x1f\x3\x3\x3\x7f\x0\x7f\x3\x1f\x3\x3\x3\x3\x0\x3c\x66\x3\x73\x63\x73\x6e\x60"
"\x63\x63\x7f\x63\x63\x63\x63\x0\x7e\x18\x18\x18\x18\x18\x7e\x0\x78\x60\x60\x60\x63\x63\x3e\x0\x63\x33\x1b\xf\x1b\x33\x63\x0\x3\x3\x3\x3\x3\x3\x7f\x0\x63\x77\x7f\x6b\x63\x63\x63\x0\x63\x67\x6f\x7b\x73\x63\x63\x0\x3c\x66\x63\x63\x63\x33\x1e\x0"
"\x3f\x63\x63\x63\x3f\x3\x3\x0\x3c\x66\x63\x63\x63\x3b\x36\x60\x3f\x63\x63\x3f\x1b\x33\x63\x0\x3e\x63\xe\x38\x62\x63\x3e\x0\x7e\x18\x18\x18\x18\x18\x18\x0\x63\x63\x63\x63\x63\x63\x3e\x0\x63\x63\x63\x63\x33\x1b\xe\x0\x63\x63\x63\x6b\x7f\x77\x63\x0"
"\x63\x36\x1c\x1c\x36\x63\x63\x0\x63\x63\x63\x3e\x18\x18\x18\x0\x7f\x30\x18\xc\x6\x3\x7f\x0\x3c\xc\xc\xc\xc\xc\x3c\x0\x3\x6\xc\x18\x30\x60\x40\x0\x3c\x30\x30\x30\x30\x30\x3c\x0\x8\x1c\x36\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x7f"
"\x18\x18\x30\x0\x0\x0\x0\x0\x0\x0\x3c\x60\x7e\x63\x7e\x0\x3\x3\x3f\x63\x63\x63\x3f\x0\x0\x0\x3e\x63\x3\x63\x3e\x0\x60\x60\x7e\x63\x63\x63\x7e\x0\x0\x0\x3e\x63\x7f\x3\x7e\x0\x7c\x6\x6\x3e\x6\x6\x6\x6\x0\x0\x7e\x63\x63\x7e\x60\x3f"
"\x3\x3\x3f\x63\x63\x63\x63\x0\x18\x0\x1c\x18\x18\x18\x7e\x0\x60\x0\x70\x60\x60\x60\x66\x3c\x3\x3\x63\x33\x1f\x33\x63\x0\x6\x6\x6\x6\x6\x6\x7c\x0\x0\x0\x37\x7f\x6b\x63\x63\x0\x0\x0\x3f\x63\x63\x63\x63\x0\x0\x0\x3e\x63\x63\x63\x3e\x0"
"\x0\x0\x3f\x63\x63\x63\x3f\x3\x0\x0\x7e\x63\x63\x63\x7e\x60\x0\x0\x3b\x67\x3\x3\x3\x0\x0\x0\x7e\x3\x3e\x60\x3f\x0\xc\xc\x3e\xc\xc\xc\x78\x0\x0\x0\x63\x63\x63\x63\x7e\x0\x0\x0\x63\x63\x36\x36\x1c\x0\x0\x0\x63\x63\x6b\x7f\x36\x0"
"\x0\x0\x63\x36\x1c\x36\x63\x0\x0\x0\x63\x63\x63\x7e\x60\x3f\x0\x0\x3f\x18\xc\x6\x7f\x0\x70\x18\x18\xc\x18\x18\x70\x0\xff\x0\x0\x0\x0\x0\x0\x0\xe\x18\x18\x30\x18\x18\xe\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\xff\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\xdb\xdb\x0"
"\x0\x7e\x0\x7e\x0\x7e\x0\x0\x0\xf8\x8\x8\x8\x8\xf8\x0\x0\xff\x0\x0\x0\x0\xff\x0\x0\x1f\x10\x10\x10\x10\x1f\x0\x0\x0\x0\x8\x0\x0\x0\x0\x0\x0\x0\x2\x1\x0\x0\x0\x20\x30\x28\x24\x22\xa1\x60\x20\x0\x0\x0\x1\x2\x0\x0\x0"
"\x20\x60\xa1\x22\x24\x28\x30\x20\x0\x0\x0\x40\x40\x40\x40\x7f\xff\x81\x81\x81\x81\x80\x80\x80\x0\x0\x0\x20\x20\x11\x11\xe\x38\x44\x44\x82\x82\x0\x0\x0\x0\x0\xfe\x7c\x38\x10\x0\x0\x0\x0\x10\x38\x7c\xfe\x0\x0\x80\xc1\x63\x36\x1c\x8\x0\x0"
),
// Font no. 14
FontEntry("IDC-Hoodlum", 8, 8, 
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x18\x18\x18\x18\x18\x0\x18\x0\x6c\x6c\x6c\x0\x0\x0\x0\x0\x0\x6c\xfe\x6c\xfe\x6c\x0\x0\x10\xfe\x16\xfe\xd0\xfe\x10\x0\x0\x66\x36\x18\x6c\x66\x0\x0\x38\x6c\x38\xfc\x66\xde\x0\x0\x18\x18\xc\x0\x0\x0\x0\x0"
"\x0\x30\x18\x18\x18\x30\x0\x0\x0\x18\x30\x30\x30\x18\x0\x0\x18\x42\x18\x3c\x18\x42\x18\x0\x0\x18\x18\x7e\x18\x18\x0\x0\x0\x0\x0\x0\x18\x18\xc\x0\x0\x0\x0\xfe\x0\x0\x0\x0\x0\x0\x0\x0\x18\x18\x0\x0\x0\xc0\x60\x30\x18\xc\x6\x0"
"\x0\xfe\xc6\xc6\xc6\xfe\x0\x0\x0\x3c\x30\x30\x30\x30\x78\x0\x0\xfe\xc0\xfe\xe\xfe\x0\x0\x0\xfe\xc0\xf8\xc0\xfe\x0\x0\xe\xe\x6e\x6e\xfe\x60\x60\x0\x0\xfe\xe\x7e\xc0\x7e\x0\x0\xe\xe\xe\xe\xfe\xce\xfe\x0\x0\xfe\xc0\xc0\xc0\xc0\xc0\x0"
"\x0\xfe\xce\xfe\xce\xfe\x0\x0\x0\xfe\xc6\xfe\xc0\xc0\xc0\xc0\x0\x18\x18\x0\x18\x18\x0\x0\x0\x18\x18\x0\x18\x18\xc\x0\x60\x30\x18\xc\x18\x30\x60\x0\x0\x0\xfe\x0\xfe\x0\x0\x0\xc\x18\x30\x60\x30\x18\xc\x0\x0\xfe\xc6\xf0\x30\x0\x30\x0"
"\x7c\xc6\xf6\xd6\x76\x6\x7c\x0\x0\xff\xc0\xfe\xce\xce\x0\x0\x0\x7f\xc0\x7e\xce\x7e\x0\x0\x0\xfc\xe\xe\xe\xfc\x0\x0\x0\x7f\xc0\xce\xce\x7e\x0\x0\x0\xff\x0\xfe\xe\xfe\x0\x0\x0\xff\x0\xfe\xe\xe\x0\x0\x0\xfc\xe\xce\xce\xfc\x0\x0"
"\x0\xce\xce\xfe\xce\xce\xe\x0\x0\x38\x38\x38\x38\x38\x0\x0\x0\xff\x30\x30\x30\x30\x3e\x0\x0\xce\x6e\x3e\x6e\xce\x0\x0\xe\xe\xe\xe\xe\xfe\x0\x0\x0\xc6\xee\xfe\xd6\xc6\x6\x2\x6\xce\xde\xfe\xee\xce\x80\x0\x0\x7f\xc0\xc6\xc6\x7c\x0\x0"
"\x0\x7f\xc0\x7e\xe\xe\x0\x0\x0\x7f\xc0\xc6\xf6\x7c\xc0\x0\x0\x7f\xc0\x7e\x6e\xce\x0\x0\x0\xf0\x38\x38\x38\x1f\x0\x0\x0\xff\x38\x38\x38\x38\x0\x0\x0\xce\xce\xce\xce\x7c\x0\x0\x0\xce\xce\xce\x7c\x38\x0\x0\xc0\xc6\xd6\xfe\xee\xc6\x0\x0"
"\x0\xce\xce\x7c\xce\xce\x0\x0\x0\xce\xce\xfe\x38\x38\x38\x0\x0\xff\x70\x38\x1c\xfe\x0\x0\x0\x18\x8\x8\x8\x18\x0\x0\x0\x6\xc\x18\x30\x60\xc0\x0\x0\x18\x10\x10\x10\x18\x0\x0\x10\x38\x6c\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\xff"
"\x18\x18\xc\x0\x0\x0\x0\x0\x0\xff\xc0\xfe\xce\xce\x0\x0\x0\x7f\xc0\x7e\xce\x7e\x0\x0\x0\xfc\xe\xe\xe\xfc\x0\x0\x0\x7f\xc0\xce\xce\x7e\x0\x0\x0\xff\x0\xfe\xe\xfe\x0\x0\x0\xff\x0\xfe\xe\xe\x0\x0\x0\xfc\xe\xce\xce\xfc\x0\x0"
"\x0\xce\xce\xfe\xce\xce\xe\x0\x0\x38\x38\x38\x38\x38\x0\x0\x0\xff\x30\x30\x30\x30\x3e\x0\x0\xce\x6e\x3e\x6e\xce\x0\x0\xe\xe\xe\xe\xe\xfe\x0\x0\x0\xc6\xee\xfe\xd6\xc6\x6\x2\x6\xce\xde\xfe\xee\xce\x80\x0\x0\x7f\xc0\xc6\xc6\x7c\x0\x0"
"\x0\x7f\xc0\x7e\xe\xe\x0\x0\x0\x7f\xc0\xc6\xf6\x7c\xc0\x0\x0\x7f\xc0\x7e\x6e\xce\x0\x0\x0\xf0\x38\x38\x38\x1f\x0\x0\x0\xff\x38\x38\x38\x38\x0\x0\x0\xce\xce\xce\xce\x7c\x0\x0\x0\xce\xce\xce\x7c\x38\x0\x0\xc0\xc6\xd6\xfe\xee\xc6\x0\x0"
"\x0\xce\xce\x7c\xce\xce\x0\x0\x0\xce\xce\xfe\x38\x38\x38\x0\x0\xff\x30\x18\xc\xfe\x0\x0\x30\x18\x18\xc\x18\x18\x30\x0\x18\x18\x18\x18\x18\x18\x18\x0\xc\x18\x18\x30\x18\x18\xc\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\xff\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\xdb\xdb\x0"
"\x0\x7e\x0\x7e\x0\x7e\x0\x0\x0\xf8\x8\x8\x8\x8\xf8\x0\x0\xff\x0\x0\x0\x0\xff\x0\x0\x1f\x10\x10\x10\x10\x1f\x0\x0\x0\x0\x8\x0\x0\x0\x0\x0\x0\x0\x2\x1\x0\x0\x0\x20\x30\x28\x24\x22\xa1\x60\x20\x0\x0\x0\x1\x2\x0\x0\x0"
"\x20\x60\xa1\x22\x24\x28\x30\x20\x0\x0\x0\x40\x40\x40\x40\x7f\xff\x81\x81\x81\x81\x80\x80\x80\x0\x0\x0\x20\x20\x11\x11\xe\x38\x44\x44\x82\x82\x0\x0\x0\x0\x0\xfe\x7c\x38\x10\x0\x0\x0\x0\x10\x38\x7c\xfe\x0\x0\x80\xc1\x63\x36\x1c\x8\x0\x0"
),
// Font no. 15
FontEntry("IDC-MicroKnight", 8, 8, 
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x18\x18\x18\x18\x18\x0\x18\x0\x36\x36\x24\x0\x0\x0\x0\x0\x36\x36\x7f\x36\x7f\x36\x36\x0\x8\x3e\xb\x3e\x68\x68\x3e\x8\x6\x69\x3e\x18\xc\x36\x4b\x30\xe\x1b\xe\x6f\x3b\x1b\x3e\x60\x18\x18\x10\x8\x0\x0\x0\x0"
"\x18\xc\x6\x6\x6\xc\x18\x0\xc\x18\x30\x30\x30\x18\xc\x0\x0\x36\x1c\x7f\x1c\x36\x0\x0\x0\x18\x18\x7e\x18\x18\x0\x0\x0\x0\x0\x0\x18\x18\x10\x8\x0\x0\x0\x3e\x0\x0\x0\x0\x0\x0\x0\x0\x0\x18\x18\x0\x0\x60\x30\x18\xc\x6\x3\x0"
"\x0\x1e\x33\x7b\x6f\x67\x3e\x0\x18\x18\x1c\x18\x18\x18\x7e\x0\x3e\x60\x3c\x6\x3\x3\x7f\x0\x3c\x60\x38\x60\x62\x63\x3e\x0\x18\x18\xc\x36\x33\x7f\x30\x0\x1f\x3\x3f\x60\x62\x33\x1e\x0\xe\x3\x3f\x63\x63\x33\x1e\x0\x7f\x60\x30\x18\x18\x18\x18\x0"
"\x1e\x33\x3e\x63\x63\x33\x1e\x0\x1e\x33\x63\x63\x7e\x60\x38\x0\x0\x18\x18\x0\x0\x18\x18\x0\x0\x18\x18\x0\x0\x18\x10\x8\x0\x18\xc\x6\xc\x18\x0\x0\x0\x0\x3e\x0\x3e\x0\x0\x0\x0\xc\x18\x30\x18\xc\x0\x0\x3e\x63\x60\x3c\xc\x0\xc\x0"
"\x1c\x36\x7b\x6f\x7b\x3\x66\x3c\x1e\x33\x63\x7f\x63\x63\x63\x0\x1f\x33\x3f\x63\x63\x33\x1f\x0\x1e\x33\x3\x3\x3\x63\x3e\x0\x1f\x33\x63\x63\x63\x63\x3f\x0\x7f\x3\x3f\x3\x3\x3\x7f\x0\x7f\x3\x3f\x3\x3\x3\x3\x0\x1c\x6\x3\x73\x63\x63\x7e\x60"
"\x63\x63\x63\x7f\x63\x63\x63\x0\x7e\x18\x18\x18\x18\x18\x7e\x0\x70\x60\x60\x60\x63\x63\x3e\x0\x63\x33\x1b\xf\x1b\x33\x63\x0\x3\x3\x3\x3\x3\x3\x7f\x0\x63\x77\x7f\x6b\x63\x63\x63\x0\x63\x67\x6f\x7b\x73\x63\x63\x0\x1e\x33\x63\x63\x63\x63\x3e\x0"
"\x1f\x33\x63\x63\x3f\x3\x3\x0\x1e\x33\x63\x63\x63\x6b\x3e\x30\x1f\x33\x63\x63\x3f\x1b\x33\x60\x1e\x3\x3e\x60\x62\x63\x3e\x0\x7e\x18\x18\x18\x18\x18\x18\x0\x63\x63\x63\x63\x63\x63\x3e\x0\x63\x63\x63\x36\x36\x1c\x1c\x0\x63\x63\x63\x6b\x7f\x77\x63\x0"
"\x63\x36\x1c\x1c\x36\x63\x63\x0\x63\x63\x63\x3e\x30\x30\x30\x0\x7f\x30\x18\xc\x6\x3\x7f\x0\x1c\xc\xc\xc\xc\xc\x1c\x0\x0\x3\x6\xc\x18\x30\x60\x0\x1c\x18\x18\x18\x18\x18\x1c\x0\x8\x1c\x36\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x7f"
"\x18\x18\x10\x8\x0\x0\x0\x0\x0\x3c\x60\x7e\x63\x63\x7e\x0\x3\x1f\x33\x63\x63\x63\x3f\x0\x0\x1e\x33\x3\x3\x63\x3e\x0\x60\x7c\x66\x63\x63\x63\x7e\x0\x0\x1e\x33\x3f\x3\x63\x3e\x0\x1c\x36\x6\x1e\x6\x6\x6\x6\x0\x7e\x63\x63\x63\x7e\x60\x3e"
"\x3\x1f\x33\x63\x63\x63\x63\x0\x18\x0\x1c\x18\x18\x18\x7e\x0\x30\x0\x38\x30\x30\x30\x32\x1c\x3\x33\x1b\xf\x1b\x33\x63\x0\x1c\x18\x18\x18\x18\x18\x7e\x0\x0\x23\x77\x7f\x6b\x63\x63\x0\x0\x1f\x33\x63\x63\x63\x63\x0\x0\x1e\x33\x63\x63\x63\x3e\x0"
"\x0\x1f\x33\x63\x63\x63\x3f\x3\x0\x7c\x66\x63\x63\x63\x7e\x60\x0\x3f\x63\x3\x3\x3\x3\x0\x0\x1e\x3\x3e\x60\x63\x3e\x0\xc\x3e\xc\xc\xc\x4c\x38\x0\x0\x63\x63\x63\x63\x63\x7e\x0\x0\x63\x63\x36\x36\x1c\x1c\x0\x0\x63\x6b\x7f\x3e\x36\x22\x0"
"\x0\x63\x36\x1c\x1c\x36\x63\x0\x0\x63\x63\x63\x63\x7e\x60\x3e\x0\x7f\x30\x18\xc\x6\x7f\x0\x30\x18\x18\xc\x18\x18\x30\x0\x18\x18\x18\x18\x18\x18\x18\x18\xc\x18\x18\x30\x18\x18\xc\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\xff\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\xdb\xdb\x0"
"\x0\x7e\x0\x7e\x0\x7e\x0\x0\x0\xf8\x8\x8\x8\x8\xf8\x0\x0\xff\x0\x0\x0\x0\xff\x0\x0\x1f\x10\x10\x10\x10\x1f\x0\x0\x0\x0\x8\x0\x0\x0\x0\x0\x0\x0\x2\x1\x0\x0\x0\x20\x30\x28\x24\x22\xa1\x60\x20\x0\x0\x0\x1\x2\x0\x0\x0"
"\x20\x60\xa1\x22\x24\x28\x30\x20\x0\x0\x0\x40\x40\x40\x40\x7f\xff\x81\x81\x81\x81\x80\x80\x80\x0\x0\x0\x20\x20\x11\x11\xe\x38\x44\x44\x82\x82\x0\x0\x0\x0\x0\xfe\x7c\x38\x10\x0\x0\x0\x0\x10\x38\x7c\xfe\x0\x0\x80\xc1\x63\x36\x1c\x8\x0\x0"
),
// Font no. 16
FontEntry("INVERSE", 8, 8, 
"\x0\x0\x0\x0\x0\x0\x0\x0\x7e\x81\xa5\x81\xbd\x99\x81\x7e\x7e\xff\xdb\xff\xff\xc3\xe7\x7e\x0\x77\x7f\x7f\x3e\x1c\x8\x0\x8\x1c\x3e\x7f\x3e\x1c\x8\x0\x18\x3c\x18\xff\xff\x52\x18\x0\x8\x1c\x3e\x7f\x7f\x49\x1c\x0\x0\x0\x18\x3c\x18\x0\x0\x0"
"\xff\xff\xe7\xc3\xe7\xff\xff\xff\x0\x3c\x42\x81\x81\x42\x3c\x0\xff\xc3\xbd\x7e\x7e\xbd\xc3\xff\xf8\xe0\xb0\x3e\x63\x63\x3e\x0\x0\x7e\xc3\xc3\x7e\x18\x7e\x18\x20\x60\xe0\x20\x20\x3f\x1f\x0\x30\x50\xb0\xd0\x9f\x8f\xf0\xf0\x81\xc2\xbc\xe4\xa4\xfc\xea\xff"
"\x0\x0\x6\x1e\x7e\x1e\x6\x0\x0\x0\x60\x78\x7e\x78\x60\x0\x18\x7e\x18\x18\x18\x18\x7e\x18\x66\x66\x66\x66\x66\x0\x66\x0\xff\x6d\x6e\x6c\x6c\x6c\x6c\x0\x7e\x81\x3e\x42\x42\x7c\x81\x7e\x0\x0\x0\x7e\x7e\x0\x0\x0\x18\x7e\x18\x18\x7e\x18\x0\xff"
"\x18\x7e\x18\x18\x18\x18\x18\x0\x18\x18\x18\x18\x18\x7e\x18\x0\x0\x20\x60\xff\x60\x20\x0\x0\x0\x4\x6\xff\x6\x4\x0\x0\x0\x0\x0\x3\x3\x3\xff\x0\x0\x24\x66\xff\x66\x24\x0\x0\x0\x0\x8\x1c\x3e\x7f\x0\x0\x0\x0\x0\x7f\x3e\x1c\x8\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\xc\xc\xc\xc\xc\x0\xc\x0\x66\x66\x0\x0\x0\x0\x0\x0\xa\x1f\xa\x1f\xa\x0\x0\x0\x3e\x4b\xb\x3e\x68\x6b\x3e\x8\xc7\x65\x37\x18\xec\xa6\xe3\x0\x1c\x32\x1c\xa2\x63\x73\x5e\x80\x30\x30\x18\x0\x0\x0\x0\x0"
"\x8\x6\x3\x3\x3\x6\x8\x0\x8\x30\x60\x60\x60\x30\x8\x0\x0\x2a\x1c\x7f\x1c\x2a\x0\x0\x0\x18\x18\x7e\x18\x18\x0\x0\x0\x0\x0\x0\x0\x0\x18\xe\x0\x0\x0\xff\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x30\x0\x80\xc0\x60\x30\x18\xc\x6\x3"
"\xff\xc3\x99\x99\x99\x99\xc3\xff\xff\xe7\xe3\xe7\xe7\xe7\xc3\xff\xff\xc3\x99\xcf\xe7\xb3\x81\xff\xff\xc3\x9d\xcf\x9f\x99\xc3\xff\xff\xcf\xd7\xdb\x81\xdf\xdf\xff\xff\x81\xf9\xc1\x9f\x9d\xc3\xff\xff\xe3\xf9\xc1\x99\x99\xc3\xff\xff\x81\xbf\xcf\xe7\xe7\xe7\xff"
"\xff\xc3\x99\xc3\x99\x99\xc3\xff\xff\xc3\x99\x99\x83\xdf\xe7\xff\x0\xc\x0\x0\x0\xc\x0\x0\x0\xc\x0\x0\x0\xc\x4\x0\x0\x38\xc\x6\xc\x38\x0\x0\x0\x0\x7e\x0\x7e\x0\x0\x0\x0\xe\x18\x30\x18\xe\x0\x0\x3e\x63\x30\x18\xc\x0\xc\x0"
"\x3e\x41\x5d\x55\x7d\x1\x3e\x0\xff\xe7\xdb\xdb\x81\xbd\xbd\xff\xff\xc1\x99\xc1\x99\x99\xc1\xff\xff\x83\x39\xf9\xf9\x39\x83\xff\xff\xc1\x99\x99\x99\x99\xc1\xff\xff\x81\xb9\xe1\xe9\xb9\x81\xff\xff\x81\xb9\xe1\xe9\xf9\xf9\xff\xff\xc3\xb9\xf9\x89\xb9\x83\xff"
"\x63\x63\x63\x7f\x63\x63\x63\x0\x7e\x18\x18\x18\x18\x18\x7e\x0\x78\x30\x30\x30\x30\x33\x1e\x0\x63\x33\x1b\xf\x1b\x33\x63\x0\xf\x6\x6\x6\x6\x46\x7f\x0\x63\x77\x7f\x6b\x6b\x63\x63\x0\x63\x67\x6f\x7b\x73\x63\x63\x0\x3e\x63\x63\x63\x63\x63\x3e\x0"
"\x3f\x66\x66\x3e\x6\x6\xf\x0\x3e\x63\x63\x63\x7b\x73\x3e\x60\x3f\x66\x66\x3e\x66\x66\x67\xc0\x3e\x43\x3\x3e\x60\x63\x3e\x0\x7e\x18\x18\x18\x18\x18\x18\x0\x63\x63\x63\x63\x63\x63\x3e\x0\x63\x63\x63\x63\x63\x36\x1c\x0\x63\x63\x6b\x6b\x6b\x77\x63\x0"
"\x63\x36\x1c\x8\x1c\x36\x63\x0\x41\x63\x36\x1c\x8\x8\x1c\x0\x7f\x61\x30\x18\xc\x46\x7f\x0\x38\x18\x18\x18\x18\x18\x18\x38\x3\x6\xc\x18\x30\x60\xc0\x80\xe\xc\xc\xc\xc\xc\xc\xe\x8\x1c\x36\x63\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\xff"
"\xc\xc\x18\x0\x0\x0\x0\x0\x0\x0\x3e\x60\x7e\x63\x7e\x0\x3\x3\x3f\x63\x63\x63\x3f\x0\x0\x0\x3e\x63\x3\x63\x3e\x0\x60\x60\x7e\x63\x63\x63\x7e\x0\x0\x0\x3e\x63\x7f\x3\x3e\x0\x3c\x66\x6\x3f\x6\x6\x6\x0\x0\x0\xbe\x63\x63\x7e\x60\x3e"
"\x3\x3\x3f\x63\x63\x63\x63\x0\x18\x0\x1c\x18\x18\x18\x3c\x0\x30\x0\x38\x30\x30\x30\x33\x1e\x3\x3\x63\x1b\xf\x1b\x63\x0\x1c\x18\x18\x18\x18\x18\x38\x0\x0\x0\x63\x7f\x6b\x6b\x63\x0\x0\x0\x3f\x63\x63\x63\x63\x0\x0\x0\x3e\x63\x63\x63\x3e\x0"
"\x0\x0\x3f\x63\x63\x3f\x3\x3\x0\x0\x7e\x63\x63\x7e\x60\xe0\x0\x0\x7b\x6e\x66\x6\x6\x0\x0\x0\x7e\x3\x3e\x60\x3f\x0\x18\x18\x7e\x18\x18\x18\x78\x0\x0\x0\x63\x63\x63\x63\x7e\x0\x0\x0\x63\x63\x63\x36\x1c\x0\x0\x0\x63\x6b\x6b\x77\x63\x0"
"\x0\x0\x63\x36\x1c\x36\x63\x0\x0\x0\x63\x63\x63\x7e\x60\x3f\x0\x0\x7f\x30\x8\x46\x7f\x0\x70\x18\x18\xe\x18\x18\x70\x0\x18\x18\x18\x0\x18\x18\x18\x0\x7\xc\xc\x38\xc\xc\x7\x0\xe\xd9\x70\x0\x0\x0\x0\x0\x0\x0\x8\x14\x22\x7f\x0\x0"
"\xff\x1\x1\x1\x1\x1\x1\x1\xff\x0\x0\x0\x0\x0\x0\x0\xff\x80\x80\x80\x80\x80\x80\x80\x1\x1\x1\x1\x1\x1\x1\x1\x80\x80\x80\x80\x80\x80\x80\x80\x1\x1\x1\x1\x1\x1\x1\xff\x0\x0\x0\x0\x0\x0\x0\xff\x80\x80\x80\x80\x80\x80\x80\xff"
"\x1\x0\x0\x0\x0\x0\x0\x0\x80\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x1\x0\x0\x0\x0\x0\x0\x0\x80\x1\x3\x7\xf\x1f\x3f\x7f\xff\xff\xfe\xfc\xf8\xf0\xe0\xc0\x80\xff\xff\xff\x7\x7\x7\x7\x7\xff\xff\xff\x0\x0\x0\x0\x0"
"\xff\xff\xff\xe0\xe0\xe0\xe0\xe0\x7\x7\x7\x7\x7\x7\x7\x7\xe0\xe0\xe0\xe0\xe0\xe0\xe0\xe0\x7\x7\x7\x7\x7\xff\xff\xff\x0\x0\x0\x0\x0\xff\xff\xff\xe0\xe0\xe0\xe0\xe0\xff\xff\xff\x7\x3\x1\x0\x0\x0\x0\x0\xe0\xc0\x80\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x1\x3\x7\x0\x0\x0\x0\x0\x80\xc0\xe0\x0\x0\x0\xee\x0\x0\x0\x0\x0\x3f\x3f\x3f\x3f\x3f\x3f\x0\x0\x7e\x7e\x7e\x7e\x7e\x7e\x0\x0\xfc\xfc\xfc\xfc\xfc\xfc\x0\x0\xf8\xf8\xf8\xf8\xf8\xf8\x0\x0\xf0\xf0\xf0\xf0\xf0\xf0\x0"
"\x0\xe0\xe0\xe0\xe0\xe0\xe0\x0\x0\xc0\xc0\xc0\xc0\xc0\xc0\x0\x0\x80\x80\x80\x80\x80\x80\x0\x0\x1\x1\x1\x1\x1\x1\x0\x0\x3\x3\x3\x3\x3\x3\x0\x0\x7\x7\x7\x7\x7\x7\x0\x0\xf\xf\xf\xf\xf\xf\x0\x0\x1f\x1f\x1f\x1f\x1f\x1f\x0"
"\x7e\x7e\x7e\x7e\x7e\x7e\x7e\x7e\xff\xff\x0\x18\x3c\x7e\xff\x0\xff\xff\x0\x0\x0\x0\x18\x18\xff\xff\x0\x18\x3c\x7e\xff\x18\xff\xff\x0\x42\x66\x5a\x42\x42\x0\x0\x0\x0\x18\x0\x0\x0\x0\x3\x3\x3\x3\x3\x3\x3\x0\x1b\x1b\x1b\x1b\x1b\x1b\x1b"
"\x0\xdb\xdb\xdb\xdb\xdb\xdb\xdb\x0\x6\x6\x6\x6\x6\x6\x6\x0\x36\x36\x36\x36\x36\x36\x36\x0\xb6\xb6\xb6\xb6\xb6\xb6\xb6\x0\x1\x1\x1\x1\x1\x1\x1\x0\xd\xd\xd\xd\xd\xd\xd\x0\x6d\x6d\x6d\x6d\x6d\x6d\x6d\x0\x0\x18\x3c\x3c\x18\x0\x0"
"\x0\x0\x0\x1f\x18\x1f\x18\x18\x6c\x6c\x6c\x6f\x60\x6f\x6c\x6c\x6c\x6c\x6c\x6c\x6c\x6c\x6c\x6c\x0\x0\x0\x7f\x60\x6f\x6c\x6c\x6c\x6c\x6c\x6f\x60\x7f\x0\x0\x6c\x6c\x6c\x7f\x0\x0\x0\x0\x18\x18\x18\x1f\x18\x1f\x0\x0\x0\x0\x0\x1f\x18\x18\x18\x18"
"\x18\x18\x18\xf8\x0\x0\x0\x0\x18\x18\x18\xff\x0\x0\x0\x0\x0\x0\x0\xff\x18\x18\x18\x18\x18\x18\x18\xf8\x18\x18\x18\x18\x0\x0\x0\x0\xff\x0\x0\x0\x18\x18\x18\xff\x18\x18\x18\x18\x18\x18\x18\xf8\x18\xf8\x18\x18\x6c\x6c\x6c\xec\x6c\x6c\x6c\x6c"
"\x6c\x6c\x6c\xec\xc\xfc\x0\x0\x0\x0\x0\xfc\xc\xec\x6c\x6c\x6c\x6c\x6c\xef\x0\xff\x0\x0\x0\x0\x0\xff\x0\xef\x6c\x6c\x6c\x6c\x6c\xec\xc\xec\x6c\x6c\x0\x0\x0\xff\x0\xff\x0\x0\x6c\x6c\x6c\xef\x0\xef\x6c\x6c\x18\x18\x18\xff\x0\xff\x0\x0"
"\x6c\x6c\x6c\xff\x0\x0\x0\x0\x0\x0\x0\xff\x0\xff\x18\x18\x0\x0\x0\xff\x6c\x6c\x6c\x6c\x6c\x6c\x6c\xfc\x0\x0\x0\x0\x18\x18\x18\xf8\x18\xf8\x0\x0\x0\x0\x0\xf8\x18\xf8\x18\x18\x0\x0\x0\xfc\x6c\x6c\x6c\x6c\x6c\x6c\x6c\xff\x6c\x6c\x6c\x6c"
"\x18\x18\x18\xff\x18\xff\x18\x18\x18\x18\x18\x1f\x0\x0\x0\x0\x0\x0\x0\xf8\x18\x18\x18\x18\xff\xff\xff\xff\xff\xff\xff\xff\x0\x0\x0\x0\xff\xff\xff\xff\xf\xf\xf\xf\xf\xf\xf\xf\xf0\xf0\xf0\xf0\xf0\xf0\xf0\xf0\xff\xff\xff\xff\x0\x0\x0\x0"
"\x0\x0\xee\x19\x19\xee\x0\x0\x38\x6c\x66\x3f\x63\x63\x3f\x3\x7f\x46\x6\x6\x6\x6\x6\x0\x0\x0\xff\x66\x66\x66\x66\x0\x7f\x46\xc\x18\xc\x46\x7f\x0\x0\x0\xfc\x66\x63\x33\x1e\x0\x0\x0\xcc\xcc\xcc\x7c\xc\xf\x0\x0\xff\x18\x18\x18\x18\x0"
"\x3c\x18\x3c\x66\x66\x3c\x18\x3c\x0\x3e\x63\x7f\x63\x3e\x0\x0\x0\x7e\xc3\xc3\xc3\x66\xe7\x0\x78\x98\x3c\x66\x63\x33\x1e\x0\x0\x0\x66\x99\x99\x66\x0\x0\x0\xc0\x3e\x73\x67\x3e\x3\x0\x0\x7c\x3\x7f\x3\x7c\x0\x0\x0\x0\x0\x0\x0\xdb\xdb\x0"
"\x0\x7e\x0\x7e\x0\x7e\x0\x0\x0\xf8\x8\x8\x8\x8\xf8\x0\x0\xff\x0\x0\x0\x0\xff\x0\x0\x1f\x10\x10\x10\x10\x1f\x0\x0\x0\x0\x8\x0\x0\x0\x0\x0\x0\x0\x2\x1\x0\x0\x0\x20\x30\x28\x24\x22\xa1\x60\x20\x0\x0\x0\x1\x2\x0\x0\x0"
"\x20\x60\xa1\x22\x24\x28\x30\x20\x0\x0\x0\x40\x40\x40\x40\x7f\xff\x81\x81\x81\x81\x80\x80\x80\x0\x0\x0\x20\x20\x11\x11\xe\x38\x44\x44\x82\x82\x0\x0\x0\x0\x0\xfe\x7c\x38\x10\x0\x0\x0\x0\x10\x38\x7c\xfe\x0\x0\x80\xc1\x63\x36\x1c\x8\x0\x0"
),
// Font no. 17
FontEntry("J-CURSE", 8, 8, 
"\x0\x0\x0\x0\x0\x0\x0\x0\x7e\x81\xa5\x81\xbd\x99\x81\x7e\x7e\xff\xdb\xff\xff\xc3\xe7\x7e\x0\x77\x7f\x7f\x3e\x1c\x8\x0\x8\x1c\x3e\x7f\x3e\x1c\x8\x0\x18\x3c\x18\xff\xff\x52\x18\x0\x8\x1c\x3e\x7f\x7f\x49\x1c\x0\x0\x0\x18\x3c\x18\x0\x0\x0"
"\xff\xff\xe7\xc3\xe7\xff\xff\xff\x0\x3c\x42\x81\x81\x42\x3c\x0\xff\xc3\xbd\x7e\x7e\xbd\xc3\xff\xf8\xe0\xb0\x3e\x63\x63\x3e\x0\x0\x7e\xc3\xc3\x7e\x18\x7e\x18\x20\x60\xe0\x20\x20\x3f\x1f\x0\x30\x50\xb0\xd0\x9f\x8f\xf0\xf0\x81\xc2\xbc\xe4\xa4\xfc\xea\xff"
"\x0\x0\x6\x1e\x7e\x1e\x6\x0\x0\x0\x60\x78\x7e\x78\x60\x0\x18\x7e\x18\x18\x18\x18\x7e\x18\x66\x66\x66\x66\x66\x0\x66\x0\xff\x6d\x6e\x6c\x6c\x6c\x6c\x0\x7e\x81\x3e\x42\x42\x7c\x81\x7e\x0\x0\x0\x7e\x7e\x0\x0\x0\x18\x7e\x18\x18\x7e\x18\x0\xff"
"\x18\x7e\x18\x18\x18\x18\x18\x0\x18\x18\x18\x18\x18\x7e\x18\x0\x0\x20\x60\xff\x60\x20\x0\x0\x0\x4\x6\xff\x6\x4\x0\x0\x0\x0\x0\x3\x3\x3\xff\x0\x0\x24\x66\xff\x66\x24\x0\x0\x0\x0\x8\x1c\x3e\x7f\x0\x0\x0\x0\x0\x7f\x3e\x1c\x8\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x18\x18\x18\xc\xc\x0\xc\x0\x6c\x36\x1b\x0\x0\x0\x0\x0\x0\x6c\xfe\x6c\x6c\xfe\x6c\x0\x18\x7e\x3\x3e\x60\x3f\xc\x0\x0\x66\x33\x18\xcc\x66\x0\x0\x1c\x36\x1c\xb6\x63\x73\xde\x0\x60\x30\x18\x0\x0\x0\x0\x0"
"\x30\x18\x18\x18\x18\x18\x18\x30\x6\xc\xc\xc\xc\xc\xc\x6\x8\x2a\x1c\x7f\x1c\x2a\x8\x0\x0\x18\x18\x7e\x18\x18\x0\x0\x0\x0\x0\x0\x0\x0\x18\xc\x0\x0\x0\x7e\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\xc\x0\x0\xc0\x60\x30\x18\xc\x6\x0"
"\x3c\x66\x66\x6b\x6b\x63\x3e\x0\x30\x38\x30\x18\x18\x18\x18\x0\x3e\x63\x60\x3c\x6\x3\x7f\x0\x3c\x66\x60\x3c\x60\x63\x3e\x0\x66\x66\x66\x63\x7f\x60\x60\x0\x7e\x6\x6\x3e\x60\x60\x3f\x0\x3c\x66\x6\x3f\x63\x63\x3e\x0\x7f\x60\x30\x18\xc\xc\xc\x0"
"\x3c\x66\x66\x3e\x63\x63\x3e\x0\x3c\x66\x66\x7c\x60\x60\x3f\x0\x0\xc\x0\x0\x0\xc\x0\x0\x0\xc\x0\x0\x0\xc\x6\x0\x0\x18\xc\x6\xc\x18\x0\x0\x0\x0\x7e\x0\x7e\x0\x0\x0\x0\xc\x18\x30\x18\xc\x0\x0\x3e\x63\x60\x38\xc\x0\xc\x0"
"\x7e\xc3\xdb\xdb\x7b\x3\x3e\x0\x7c\x66\x66\x7f\x63\x63\x63\x0\x7c\x66\x66\x7f\x63\x63\x3f\x0\x7c\x66\x6\x3\x3\x63\x3f\x0\x7c\x66\x66\x63\x63\x63\x3f\x0\x7c\x6\x6\x7f\x3\x3\x7f\x0\x7c\x6\x6\x7f\x3\x3\x3\x0\x7c\x66\x6\x73\x63\x63\x3f\x0"
"\xc6\xc6\xc6\x7f\x63\x63\x63\x0\x30\x30\x30\x18\x18\x18\x18\x0\x60\x60\x60\x60\x30\x33\x1e\x0\x66\x36\x1e\xf\x1b\x33\x63\x0\x6\x6\x6\x3\x3\x3\x7f\x0\x66\x7e\x7e\x6b\x6b\x63\x63\x0\x66\x6e\x7e\x7b\x73\x63\x63\x0\x3c\x66\x66\x63\x63\x63\x3e\x0"
"\x3c\x66\x66\x3f\x3\x3\x3\x0\x3c\x66\x66\x63\x63\x5b\x36\x60\x3e\x66\x66\x3f\x63\x63\x63\x0\x3c\x66\x6\x3c\x60\x63\x3e\x0\xfe\x30\x30\x18\x18\x18\x18\x0\xc6\xc6\xc6\x63\x63\x63\x3e\x0\xc6\xc6\xc6\x63\x63\x36\x1c\x0\xc6\xc6\xc6\x63\x6b\x6b\x3e\x0"
"\xc6\x6c\x38\x18\x3c\x66\xc3\x0\x66\x66\x3c\x18\xc\xc\xc\x0\x7f\x60\x30\x1c\x6\x3\x7f\x0\x38\x18\x18\x18\x18\x18\x18\x38\x0\x6\xc\x18\x30\x60\xc0\x0\xe\xc\xc\xc\xc\xc\xc\xe\x18\x3c\x66\xc3\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\xff"
"\xc\x18\x30\x0\x0\x0\x0\x0\x0\x0\x7c\xc0\xfe\x63\x7e\x0\x6\x6\x3e\x63\x63\x63\x3f\x0\x0\x0\x3c\x66\x3\x63\x3e\x0\xc0\xc0\xfc\x66\x63\x63\x7e\x0\x0\x0\x3c\x66\x7f\x3\x7e\x0\x38\xc\xc\x3f\x6\x6\x6\x0\x0\x0\x3c\x66\x63\x7e\x60\x3e"
"\x6\x6\x3e\x63\x63\x63\x63\x0\x30\x0\x30\x30\x18\x18\x18\x0\x60\x0\x60\x60\x30\x30\x30\x1f\x6\x6\x36\x1b\xf\x1b\x33\x0\x30\x30\x30\x18\x18\x18\x18\x0\x0\x0\x3e\x6b\x6b\x6b\x6b\x0\x0\x0\x3c\x66\x63\x63\x63\x0\x0\x0\x3c\x66\x63\x63\x3e\x0"
"\x0\x0\x3c\x66\x63\x3f\x3\x3\x0\x0\x7c\x66\x63\x7e\x60\x60\x0\x0\x3e\x63\x3\x3\x3\x0\x0\x0\x3c\x6\x3c\x60\x3e\x0\x30\x30\x7c\x18\x18\x18\x18\x0\x0\x0\x66\x66\x63\x63\x3e\x0\x0\x0\xc6\xc6\x66\x36\x1c\x0\x0\x0\x6b\x6b\x6b\x6b\x3f\x0"
"\x0\x0\x63\x36\x1c\x36\x63\x0\x0\x0\xc6\xc6\x63\x7e\x60\x3f\x0\x0\x7f\x30\x1c\x6\x7f\x0\x30\x18\x18\xc\x18\x18\x30\x0\x18\x18\x18\x18\x18\x18\x18\x18\x6\xc\xc\x18\xc\xc\x6\x0\xe\xdb\x70\x0\x0\x0\x0\x0\x0\x0\x8\x14\x22\x7f\x0\x0"
"\xff\x1\x1\x1\x1\x1\x1\x1\xff\x0\x0\x0\x0\x0\x0\x0\xff\x80\x80\x80\x80\x80\x80\x80\x1\x1\x1\x1\x1\x1\x1\x1\x80\x80\x80\x80\x80\x80\x80\x80\x1\x1\x1\x1\x1\x1\x1\xff\x0\x0\x0\x0\x0\x0\x0\xff\x80\x80\x80\x80\x80\x80\x80\xff"
"\x1\x0\x0\x0\x0\x0\x0\x0\x80\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x1\x0\x0\x0\x0\x0\x0\x0\x80\x1\x3\x7\xf\x1f\x3f\x7f\xff\xff\xfe\xfc\xf8\xf0\xe0\xc0\x80\xff\xff\x3\x3\x3\x3\x3\x3\xff\xff\x0\x0\x0\x0\x0\x0"
"\xff\xff\xc0\xc0\xc0\xc0\xc0\xc0\x3\x3\x3\x3\x3\x3\x3\x3\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\x3\x3\x3\x3\x3\x3\xff\xff\x0\x0\x0\x0\x0\x0\xff\xff\xc0\xc0\xc0\xc0\xc0\xc0\xff\xff\x3\x3\x0\x0\x0\x0\x0\x0\xc0\xc0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x3\x3\x0\x0\x0\x0\x0\x0\xc0\xc0\x0\x0\x0\x55\x0\x0\x0\x0\x0\x3f\x3f\x3f\x3f\x3f\x3f\x0\x0\x7e\x7e\x7e\x7e\x7e\x7e\x0\x0\xfc\xfc\xfc\xfc\xfc\xfc\x0\x0\xf8\xf8\xf8\xf8\xf8\xf8\x0\x0\xf0\xf0\xf0\xf0\xf0\xf0\x0"
"\x0\xe0\xe0\xe0\xe0\xe0\xe0\x0\x0\xc0\xc0\xc0\xc0\xc0\xc0\x0\x0\x80\x80\x80\x80\x80\x80\x0\x0\x1\x1\x1\x1\x1\x1\x0\x0\x3\x3\x3\x3\x3\x3\x0\x0\x7\x7\x7\x7\x7\x7\x0\x0\xf\xf\xf\xf\xf\xf\x0\x0\x1f\x1f\x1f\x1f\x1f\x1f\x0"
"\x55\x6b\x55\x6b\x55\x6b\x55\x6b\xff\xff\x0\x0\x0\x8\x1c\x3e\xff\xff\x0\x0\x0\x0\x0\x7f\xff\xff\x0\x0\x8\x1c\x3e\x7f\xff\xff\x0\xc3\xe7\xff\xdb\xc3\x0\x0\x0\x0\x18\x0\x0\x0\x0\x3\x3\x3\x3\x3\x3\x3\x0\x1b\x1b\x1b\x1b\x1b\x1b\x1b"
"\x0\xdb\xdb\xdb\xdb\xdb\xdb\xdb\x0\x6\x6\x6\x6\x6\x6\x6\x0\x36\x36\x36\x36\x36\x36\x36\x0\xb6\xb6\xb6\xb6\xb6\xb6\xb6\x0\x1\x1\x1\x1\x1\x1\x1\x0\xd\xd\xd\xd\xd\xd\xd\x0\x6d\x6d\x6d\x6d\x6d\x6d\x6d\x0\x0\x18\x3c\x3c\x18\x0\x0"
"\x0\x0\x0\x1f\x18\x1f\x18\x18\x6c\x6c\x6c\x6f\x60\x6f\x6c\x6c\x6c\x6c\x6c\x6c\x6c\x6c\x6c\x6c\x0\x0\x0\x7f\x60\x6f\x6c\x6c\x6c\x6c\x6c\x6f\x60\x7f\x0\x0\x6c\x6c\x6c\x7f\x0\x0\x0\x0\x18\x18\x18\x1f\x18\x1f\x0\x0\x0\x0\x0\x1f\x18\x18\x18\x18"
"\x18\x18\x18\xf8\x0\x0\x0\x0\x18\x18\x18\xff\x0\x0\x0\x0\x0\x0\x0\xff\x18\x18\x18\x18\x18\x18\x18\xf8\x18\x18\x18\x18\x0\x0\x0\x0\xff\x0\x0\x0\x18\x18\x18\xff\x18\x18\x18\x18\x18\x18\x18\xf8\x18\xf8\x18\x18\x6c\x6c\x6c\xec\x6c\x6c\x6c\x6c"
"\x6c\x6c\x6c\xec\xc\xfc\x0\x0\x0\x0\x0\xfc\xc\xec\x6c\x6c\x6c\x6c\x6c\xef\x0\xff\x0\x0\x0\x0\x0\xff\x0\xef\x6c\x6c\x6c\x6c\x6c\xec\xc\xec\x6c\x6c\x0\x0\x0\xff\x0\xff\x0\x0\x6c\x6c\x6c\xef\x0\xef\x6c\x6c\x18\x18\x18\xff\x0\xff\x0\x0"
"\x6c\x6c\x6c\xff\x0\x0\x0\x0\x0\x0\x0\xff\x0\xff\x18\x18\x0\x0\x0\xff\x6c\x6c\x6c\x6c\x6c\x6c\x6c\xfc\x0\x0\x0\x0\x18\x18\x18\xf8\x18\xf8\x0\x0\x0\x0\x0\xf8\x18\xf8\x18\x18\x0\x0\x0\xfc\x6c\x6c\x6c\x6c\x6c\x6c\x6c\xff\x6c\x6c\x6c\x6c"
"\x18\x18\x18\xff\x18\xff\x18\x18\x18\x18\x18\x1f\x0\x0\x0\x0\x0\x0\x0\xf8\x18\x18\x18\x18\xff\xff\xff\xff\xff\xff\xff\xff\x0\x0\x0\x0\xff\xff\xff\xff\xf\xf\xf\xf\xf\xf\xf\xf\xf0\xf0\xf0\xf0\xf0\xf0\xf0\xf0\xff\xff\xff\xff\x0\x0\x0\x0"
"\x0\x0\xee\x19\x19\xee\x0\x0\x38\x6c\x66\x3f\x63\x63\x3f\x3\x7f\x46\x6\x6\x6\x6\x6\x0\x0\x0\xff\x66\x66\x66\x66\x0\x7f\x46\xc\x18\xc\x46\x7f\x0\x0\x0\xfc\x66\x63\x33\x1e\x0\x0\x0\xcc\xcc\xcc\x7c\xc\xf\x0\x0\xff\x18\x18\x18\x18\x0"
"\x3c\x18\x3c\x66\x66\x3c\x18\x3c\x0\x3e\x63\x7f\x63\x3e\x0\x0\x0\x7e\xc3\xc3\xc3\x66\xe7\x0\x78\x98\x3c\x66\x63\x33\x1e\x0\x0\x0\x66\x99\x99\x66\x0\x0\x0\xc0\x3e\x73\x67\x3e\x3\x0\x0\x7c\x3\x7f\x3\x7c\x0\x0\x0\x0\x0\x0\x0\xdb\xdb\x0"
"\x0\x7e\x0\x7e\x0\x7e\x0\x0\x0\xf8\x8\x8\x8\x8\xf8\x0\x0\xff\x0\x0\x0\x0\xff\x0\x0\x1f\x10\x10\x10\x10\x1f\x0\x0\x0\x0\x8\x0\x0\x0\x0\x0\x0\x0\x2\x1\x0\x0\x0\x20\x30\x28\x24\x22\xa1\x60\x20\x0\x0\x0\x1\x2\x0\x0\x0"
"\x20\x60\xa1\x22\x24\x28\x30\x20\x0\x0\x0\x40\x40\x40\x40\x7f\xff\x81\x81\x81\x81\x80\x80\x80\x0\x0\x0\x20\x20\x11\x11\xe\x38\x44\x44\x82\x82\x0\x0\x0\x0\x0\xfe\x7c\x38\x10\x0\x0\x0\x0\x10\x38\x7c\xfe\x0\x0\x80\xc1\x63\x36\x1c\x8\x0\x0"
),
// Font no. 18
FontEntry("J-ELECTR", 8, 8, 
"\x0\x0\x0\x0\x0\x0\x0\x0\x7e\x81\xa5\x81\xbd\x99\x81\x7e\x7e\xff\xdb\xff\xc3\xe7\xff\x7e\x36\x7f\x7f\x7f\x3e\x1c\x8\x0\x8\x1c\x3e\x7f\x3e\x1c\x8\x0\x1c\x3e\x1c\x7f\x7f\x49\x8\x3e\x0\x8\x1c\x3e\x7f\x3e\x1c\x3e\x0\x0\x18\x3c\x3c\x18\x0\x0"
"\xff\xff\xe7\xc3\xc3\xe7\xff\xff\x0\x3c\x66\x42\x42\x66\x3c\x0\xff\xc3\x99\xbd\xbd\x99\xc3\xff\xf0\xe0\xf0\xbe\x33\x33\x33\x1e\x3c\x66\x66\x66\x3c\x18\x7e\x18\xfc\xcc\xfc\xc\xc\xe\xf\x7\xfe\xc6\xfe\xc6\xc6\xe6\x67\x3\x99\x5a\x3c\xe7\xe7\x3c\x5a\x99"
"\x1\x7\x1f\x7f\x1f\x7\x1\x0\x40\x70\x7c\x7f\x7c\x70\x40\x0\x18\x3c\x7e\x18\x18\x7e\x3c\x18\x66\x66\x66\x66\x66\x0\x66\x0\xfe\xdb\xdb\xde\xd8\xd8\xd8\x0\x7c\xc6\x1c\x36\x36\x1c\x61\x3f\x0\x0\x0\x0\x7e\x7e\x7e\x0\x18\x3c\x7e\x18\x7e\x3c\x18\xff"
"\x18\x3c\x7e\x18\x18\x18\x18\x0\x18\x18\x18\x18\x7e\x3c\x18\x0\x0\x18\x30\x7f\x30\x18\x0\x0\x0\xc\x6\x7f\x6\xc\x0\x0\x0\x0\x3\x3\x3\x7f\x0\x0\x0\x24\x66\xff\x66\x24\x0\x0\x0\x18\x3c\x7e\xff\xff\x0\x0\x0\xff\xff\x7e\x3c\x18\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x8\x8\x8\x8\x8\x0\x8\x0\x24\x24\x24\x0\x0\x0\x0\x0\x22\x7f\x22\x22\x22\x7f\x22\x0\x14\x7e\x15\x3e\x54\x3f\x14\x0\x0\x44\x22\x10\x8\x44\x22\x0\x1c\x22\x14\x6a\x11\x11\x6e\x0\x10\x10\x10\x0\x0\x0\x0\x0"
"\x10\x8\x4\x4\x4\x8\x10\x0\x4\x8\x10\x10\x10\x8\x4\x0\x8\x2a\x1c\x7f\x1c\x2a\x8\x0\x0\x8\x8\x3e\x8\x8\x0\x0\x0\x0\x0\x0\x0\x8\x4\x0\x0\x0\x0\x7e\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x8\x0\x0\x40\x20\x10\x8\x4\x2\x0"
"\x1c\x22\x51\x49\x45\x22\x1c\x0\xe\x8\x8\x8\x8\x28\x3e\x0\x1f\x20\x20\x1e\x1\x1\x3f\x0\x1f\x20\x20\x1c\x20\x20\x1f\x0\x1\x21\x21\x21\x7f\x20\x20\x0\x3f\x1\x1\x1f\x20\x20\x1f\x0\x1\x1\x1\x3f\x41\x41\x3e\x0\x3f\x20\x20\x10\x8\x8\x8\x0"
"\x1c\x22\x22\x3e\x41\x41\x3e\x0\x3e\x41\x41\x7e\x40\x40\x40\x0\x0\x0\x8\x0\x0\x8\x0\x0\x0\x0\x8\x0\x0\x8\x4\x0\x20\x10\x8\x4\x8\x10\x20\x0\x0\x0\x7e\x0\x7e\x0\x0\x0\x4\x8\x10\x20\x10\x8\x4\x0\x3c\x42\x40\x20\x10\x0\x10\x0"
"\x3c\x42\x99\xa5\x59\x2\x7c\x0\x3c\x42\x41\x41\x7f\x41\x41\x0\x3f\x41\x41\x3f\x41\x41\x3f\x0\x7c\x2\x1\x1\x1\x2\x7c\x0\x3f\x41\x41\x41\x41\x41\x3f\x0\x7f\x1\x1\x7f\x1\x1\x7f\x0\x7f\x1\x1\x7f\x1\x1\x1\x0\x7c\x2\x1\x71\x41\x41\x3e\x0"
"\x41\x41\x41\x7f\x41\x41\x41\x0\x8\x8\x8\x8\x8\x8\x8\x0\x40\x40\x40\x40\x40\x20\x1e\x0\x21\x11\x9\x7\x9\x11\x21\x0\x1\x1\x1\x1\x1\x1\x7f\x0\x1f\x29\x49\x49\x49\x49\x49\x0\x1f\x21\x41\x41\x41\x41\x41\x0\x3c\x42\x41\x41\x41\x21\x1e\x0"
"\x3f\x41\x41\x41\x3f\x1\x1\x0\x3c\x42\x41\x41\x41\x51\x2e\x40\x3f\x41\x41\x21\x1f\x21\x41\x0\x7c\x2\x1\x3e\x40\x40\x3f\x0\x3e\x8\x8\x8\x8\x8\x8\x0\x41\x41\x41\x41\x41\x41\x3e\x0\x41\x41\x41\x41\x41\x22\x1c\x0\x49\x49\x49\x49\x49\x49\x3f\x0"
"\x41\x41\x22\x1c\x22\x41\x41\x0\x41\x22\x14\x8\x8\x8\x8\x0\x7f\x40\x30\x8\x6\x1\x7f\x0\xe\x2\x2\x2\x2\x2\xe\x0\x0\x2\x4\x8\x10\x20\x40\x0\x1c\x10\x10\x10\x10\x10\x1c\x0\x8\x14\x22\x41\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\xff"
"\x4\x4\x4\x0\x0\x0\x0\x0\x0\x0\x3e\x40\x7e\x41\x7e\x0\x1\x1\x3f\x41\x41\x41\x3f\x0\x0\x0\x7e\x1\x1\x1\x7e\x0\x40\x40\x7e\x41\x41\x41\x7e\x0\x0\x0\x3e\x41\x7f\x1\x7e\x0\x3c\x2\x1f\x2\x2\x2\x2\x0\x0\x0\x3e\x41\x41\x7e\x40\x3f"
"\x1\x1\x1f\x21\x41\x41\x41\x0\x10\x0\x1c\x10\x10\x10\x10\x0\x20\x0\x38\x20\x20\x20\x10\xf\x1\x1\x21\x11\xf\x11\x21\x0\x4\x4\x4\x4\x4\x4\x18\x0\x0\x0\x3f\x49\x49\x49\x49\x0\x0\x0\x1f\x21\x41\x41\x41\x0\x0\x0\x3e\x41\x41\x41\x3e\x0"
"\x0\x0\x3f\x41\x41\x3f\x1\x1\x0\x0\x7e\x41\x41\x7e\x40\x40\x0\x0\x3f\x41\x1\x1\x1\x0\x0\x0\x3e\x1\x1e\x20\x1f\x0\x8\x8\x3e\x8\x8\x8\x30\x0\x0\x0\x41\x41\x41\x41\x3e\x0\x0\x0\x41\x41\x41\x22\x1c\x0\x0\x0\x49\x49\x49\x49\x3f\x0"
"\x0\x0\x41\x22\x1c\x22\x41\x0\x0\x0\x41\x41\x41\x7e\x40\x3f\x0\x0\x7f\x20\x1c\x2\x7f\x0\x60\x10\x10\xc\x10\x10\x60\x0\x8\x8\x8\x8\x8\x8\x8\x8\x6\x8\x8\x30\x8\x8\x6\x0\x26\x19\x0\x0\x0\x0\x0\x0\x0\x8\x1c\x36\x63\x63\x7f\x0"
"\xff\x1\x1\x1\x1\x1\x1\x1\xff\x0\x0\x0\x0\x0\x0\x0\xff\x80\x80\x80\x80\x80\x80\x80\x1\x1\x1\x1\x1\x1\x1\x1\x80\x80\x80\x80\x80\x80\x80\x80\x1\x1\x1\x1\x1\x1\x1\xff\x0\x0\x0\x0\x0\x0\x0\xff\x80\x80\x80\x80\x80\x80\x80\xff"
"\x1\x0\x0\x0\x0\x0\x0\x0\x80\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x1\x0\x0\x0\x0\x0\x0\x0\x80\x1\x3\x7\xf\x1f\x3f\x7f\xff\xff\xfe\xfc\xf8\xf0\xe0\xc0\x80\xff\xff\x3\x3\x3\x3\x3\x3\xff\xff\x0\x0\x0\x0\x0\x0"
"\xff\xff\xc0\xc0\xc0\xc0\xc0\xc0\x3\x3\x3\x3\x3\x3\x3\x3\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\x3\x3\x3\x3\x3\x3\xff\xff\x0\x0\x0\x0\x0\x0\xff\xff\xc0\xc0\xc0\xc0\xc0\xc0\xff\xff\x3\x3\x0\x0\x0\x0\x0\x0\xc0\xc0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x3\x3\x0\x0\x0\x0\x0\x0\xc0\xc0\x0\x0\x0\xaa\x0\x0\x0\x0\x0\x3f\x3f\x3f\x3f\x3f\x3f\x0\x0\x7e\x7e\x7e\x7e\x7e\x7e\x0\x0\xfc\xfc\xfc\xfc\xfc\xfc\x0\x0\xf8\xf8\xf8\xf8\xf8\xf8\x0\x0\xf0\xf0\xf0\xf0\xf0\xf0\x0"
"\x0\xe0\xe0\xe0\xe0\xe0\xe0\x0\x0\xc0\xc0\xc0\xc0\xc0\xc0\x0\x0\x80\x80\x80\x80\x80\x80\x0\x0\x1\x1\x1\x1\x1\x1\x0\x0\x3\x3\x3\x3\x3\x3\x0\x0\x7\x7\x7\x7\x7\x7\x0\x0\xf\xf\xf\xf\xf\xf\x0\x0\x1f\x1f\x1f\x1f\x1f\x1f\x0"
"\x7e\x7e\x7e\x7e\x7e\x7e\x7e\x7e\xff\xff\x0\x18\x3c\x7e\xff\x0\xff\xff\x0\x0\x0\x0\x18\x18\xff\xff\x0\x18\x3c\x7e\xff\x18\xff\xff\x0\x42\x66\x5a\x42\x42\x0\x0\x0\x18\x18\x0\x0\x0\x0\x3\x3\x3\x3\x3\x3\x3\x0\x1b\x1b\x1b\x1b\x1b\x1b\x1b"
"\x0\xdb\xdb\xdb\xdb\xdb\xdb\xdb\x0\x6\x6\x6\x6\x6\x6\x6\x0\x36\x36\x36\x36\x36\x36\x36\x0\xb6\xb6\xb6\xb6\xb6\xb6\xb6\x0\x1\x1\x1\x1\x1\x1\x1\x0\xd\xd\xd\xd\xd\xd\xd\x0\x6d\x6d\x6d\x6d\x6d\x6d\x6d\x0\x0\x18\x3c\x3c\x18\x0\x0"
"\x0\x0\x1f\x18\x1f\x18\x18\x18\x6c\x6c\x6f\x60\x6f\x6c\x6c\x6c\x6c\x6c\x6c\x6c\x6c\x6c\x6c\x6c\x0\x0\x7f\x60\x6f\x6c\x6c\x6c\x6c\x6c\x6f\x60\x7f\x0\x0\x0\x6c\x6c\x6c\x6c\x7f\x0\x0\x0\x18\x18\x1f\x18\x1f\x0\x0\x0\x0\x0\x0\x0\x1f\x18\x18\x18"
"\x18\x18\x18\x18\xf8\x0\x0\x0\x18\x18\x18\x18\xff\x0\x0\x0\x0\x0\x0\x0\xff\x18\x18\x18\x18\x18\x18\x18\xf8\x18\x18\x18\x0\x0\x0\x0\xff\x0\x0\x0\x18\x18\x18\x18\xff\x18\x18\x18\x18\x18\xf8\x18\xf8\x18\x18\x18\x6c\x6c\x6c\x6c\xec\x6c\x6c\x6c"
"\x6c\x6c\xec\xc\xfc\x0\x0\x0\x0\x0\xfc\xc\xec\x6c\x6c\x6c\x6c\x6c\xef\x0\xff\x0\x0\x0\x0\x0\xff\x0\xef\x6c\x6c\x6c\x6c\x6c\xec\xc\xec\x6c\x6c\x6c\x0\x0\xff\x0\xff\x0\x0\x0\x6c\x6c\xef\x0\xef\x6c\x6c\x6c\x18\x18\xff\x0\xff\x0\x0\x0"
"\x6c\x6c\x6c\x6c\xff\x0\x0\x0\x0\x0\xff\x0\xff\x18\x18\x18\x0\x0\x0\x0\xff\x6c\x6c\x6c\x6c\x6c\x6c\x6c\xfc\x0\x0\x0\x18\x18\xf8\x18\xf8\x0\x0\x0\x0\x0\xf8\x18\xf8\x18\x18\x18\x0\x0\x0\x0\xfc\x6c\x6c\x6c\x6c\x6c\x6c\x6c\xff\x6c\x6c\x6c"
"\x18\x18\xff\x18\xff\x18\x18\x18\x18\x18\x18\x18\x1f\x0\x0\x0\x0\x0\x0\x0\xf8\x18\x18\x18\xff\xff\xff\xff\xff\xff\xff\xff\x0\x0\x0\x0\xff\xff\xff\xff\xf\xf\xf\xf\xf\xf\xf\xf\xf0\xf0\xf0\xf0\xf0\xf0\xf0\xf0\xff\xff\xff\xff\x0\x0\x0\x0"
"\x0\x0\x6e\x3b\x13\x3b\x6e\x0\x0\x1e\x33\x1f\x33\x1f\x3\x3\x0\x3f\x33\x3\x3\x3\x3\x0\x0\x0\x7f\x36\x36\x36\x36\x0\x3f\x33\x6\xc\x6\x33\x3f\x0\x0\x0\x7e\x1b\x1b\x1b\xe\x0\x0\x66\x66\x66\x66\x3e\x6\x3\x0\x6e\x3b\x18\x18\x18\x18\x0"
"\x3f\xc\x1e\x33\x33\x1e\xc\x3f\x1c\x36\x63\x7f\x63\x36\x1c\x0\x1c\x36\x63\x63\x36\x36\x77\x0\x38\xc\x18\x3e\x33\x33\x1e\x0\x0\x0\x7e\xdb\xdb\x7e\x0\x0\x60\x30\x7e\xdb\xdb\x7e\x6\x3\x1c\x6\x3\x1f\x3\x6\x1c\x0\x0\x0\x0\x0\x0\xdb\xdb\x0"
"\x0\x7e\x0\x7e\x0\x7e\x0\x0\x0\xf8\x8\x8\x8\x8\xf8\x0\x0\xff\x0\x0\x0\x0\xff\x0\x0\x1f\x10\x10\x10\x10\x1f\x0\x0\x0\x0\x8\x0\x0\x0\x0\x0\x0\x0\x2\x1\x0\x0\x0\x20\x30\x28\x24\x22\xa1\x60\x20\x0\x0\x0\x1\x2\x0\x0\x0"
"\x20\x60\xa1\x22\x24\x28\x30\x20\x0\x0\x0\x40\x40\x40\x40\x7f\xff\x81\x81\x81\x81\x80\x80\x80\x0\x0\x0\x20\x20\x11\x11\xe\x38\x44\x44\x82\x82\x0\x0\x0\x0\x0\xfe\x7c\x38\x10\x0\x0\x0\x0\x10\x38\x7c\xfe\x0\x0\x80\xc1\x63\x36\x1c\x8\x0\x0"
),
// Font no. 19
FontEntry("J-FLUX", 8, 8, 
"\x0\x0\x0\x0\x0\x0\x0\x0\x7e\x81\xa5\x81\xbd\x99\x81\x7e\x7e\xff\xdb\xff\xc3\xe7\xff\x7e\x36\x7f\x7f\x7f\x3e\x1c\x8\x0\x8\x1c\x3e\x7f\x3e\x1c\x8\x0\x1c\x3e\x1c\x7f\x7f\x49\x8\x3e\x0\x8\x1c\x3e\x7f\x3e\x1c\x3e\x0\x0\x18\x3c\x3c\x18\x0\x0"
"\xff\xff\xe7\xc3\xc3\xe7\xff\xff\x0\x3c\x66\x42\x42\x66\x3c\x0\xff\xc3\x99\xbd\xbd\x99\xc3\xff\xf0\xe0\xf0\xbe\x33\x33\x33\x1e\x3c\x66\x66\x66\x3c\x18\x7e\x18\xfc\xcc\xfc\xc\xc\xe\xf\x7\xfe\xc6\xfe\xc6\xc6\xe6\x67\x3\x99\x5a\x3c\xe7\xe7\x3c\x5a\x99"
"\x1\x7\x1f\x7f\x1f\x7\x1\x0\x40\x70\x7c\x7f\x7c\x70\x40\x0\x18\x3c\x7e\x18\x18\x7e\x3c\x18\x66\x66\x66\x66\x66\x0\x66\x0\xfe\xdb\xdb\xde\xd8\xd8\xd8\x0\x7c\xc6\x1c\x36\x36\x1c\x61\x3f\x0\x0\x0\x0\x7e\x7e\x7e\x0\x18\x3c\x7e\x18\x7e\x3c\x18\xff"
"\x18\x3c\x7e\x18\x18\x18\x18\x0\x18\x18\x18\x18\x7e\x3c\x18\x0\x0\x18\x30\x7f\x30\x18\x0\x0\x0\xc\x6\x7f\x6\xc\x0\x0\x0\x0\x3\x3\x3\x7f\x0\x0\x0\x24\x66\xff\x66\x24\x0\x0\x0\x18\x3c\x7e\xff\xff\x0\x0\x0\xff\xff\x7e\x3c\x18\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\xc\xc\xc\xc\xc\x0\xc\x0\x36\x36\x36\x0\x0\x0\x0\x0\x36\x36\x7f\x36\x7f\x36\x36\x0\x18\x7e\x3\x3e\x60\x3f\x18\x0\x0\x66\x33\x18\xc\x66\x33\x0\x1c\x36\x1c\x6e\x3b\x33\x6e\x0\x30\x30\x30\x0\x0\x0\x0\x0"
"\x18\xc\x6\x6\x6\xc\x18\x0\x6\xc\x18\x18\x18\xc\x6\x0\x0\x66\x3c\xff\x3c\x66\x0\x0\x0\x18\x18\x7e\x18\x18\x0\x0\x0\x0\x0\x0\x0\x18\xc\x0\x0\x0\x0\x7e\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x18\x0\x0\x60\x30\x18\xc\x6\x0\x0"
"\x3e\x63\x6b\x6b\x6b\x63\x3e\x0\xe\xc\xc\xc\xc\x2c\x3e\x0\x1f\x30\x30\x1e\x3\x3\x3f\x0\x1f\x30\x30\x1e\x30\x30\x1f\x0\x3\x33\x33\x33\x7f\x30\x30\x0\x3f\x3\x3\x1f\x30\x30\x1f\x0\x3\x3\x3\x3f\x63\x63\x3e\x0\x3f\x30\x30\x18\xc\xc\xc\x0"
"\x1c\x36\x36\x3e\x63\x63\x3e\x0\x3e\x63\x63\x7e\x60\x60\x60\x0\x0\x0\x18\x0\x0\x18\x0\x0\x0\x0\x18\x0\x0\x18\xc\x0\x0\x30\x18\xc\x18\x30\x0\x0\x0\x0\x7e\x0\x7e\x0\x0\x0\x0\xc\x18\x30\x18\xc\x0\x0\x3c\x66\x60\x30\x18\x0\x18\x0"
"\x3c\x66\xdb\xdb\x73\x6\x3c\x0\x3c\x66\x63\x63\x7f\x63\x63\x0\x3f\x63\x63\x3f\x63\x63\x3f\x0\x7c\x6\x3\x3\x3\x6\x7c\x0\x3f\x63\x63\x63\x63\x63\x3f\x0\x7f\x3\x3\x7f\x3\x3\x7f\x0\x7f\x3\x3\x7f\x3\x3\x3\x0\x7c\x6\x3\x73\x63\x63\x3e\x0"
"\x63\x63\x63\x7f\x63\x63\x63\x0\x18\x18\x18\x18\x18\x18\x18\x0\x60\x60\x60\x60\x60\x60\x3e\x0\x63\x33\x1b\xf\x1b\x33\x63\x0\x3\x3\x3\x3\x3\x3\x7f\x0\x3f\x6b\x6b\x6b\x6b\x6b\x6b\x0\x1f\x33\x63\x63\x63\x63\x63\x0\x3c\x66\x63\x63\x63\x63\x3e\x0"
"\x3f\x63\x63\x63\x3f\x3\x3\x0\x3c\x66\x63\x63\x63\x5b\x36\x60\x3f\x63\x63\x63\x3f\x63\xc3\x0\x7c\x6\x3\x3e\x60\x60\x3f\x0\x7e\x18\x18\x18\x18\x18\x18\x0\x63\x63\x63\x63\x63\x63\x3e\x0\x63\x63\x63\x63\x63\x36\x1c\x0\x6b\x6b\x6b\x6b\x6b\x6b\x3f\x0"
"\x63\x63\x63\x3e\x63\x63\x63\x0\x33\x33\x33\x1e\xc\xc\xc\x0\x7f\x60\x30\x18\xc\x6\x7f\x0\x1e\x6\x6\x6\x6\x6\x1e\x0\x0\x6\xc\x18\x30\x60\x0\x0\x1e\x18\x18\x18\x18\x18\x1e\x0\x18\x3c\x66\xc3\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\xff"
"\xc\xc\xc\x0\x0\x0\x0\x0\x0\x0\x3e\x60\x7e\x63\x7e\x0\x3\x3\x3f\x63\x63\x63\x3f\x0\x0\x0\x7e\x3\x3\x3\x7e\x0\x60\x60\x7e\x63\x63\x63\x7e\x0\x0\x0\x3e\x63\x7f\x3\x7e\x0\x3c\x6\x1f\x6\x6\x6\x6\x0\x0\x0\x3e\x63\x63\x7e\x60\x3f"
"\x3\x3\x3f\x63\x63\x63\x63\x0\x18\x0\x1e\x18\x18\x18\x18\x0\x30\x0\x3c\x30\x30\x30\x30\x1f\x3\x3\x63\x33\x1f\x33\x63\x0\xc\xc\xc\xc\xc\xc\x38\x0\x0\x0\x3f\x6b\x6b\x6b\x6b\x0\x0\x0\x3f\x63\x63\x63\x63\x0\x0\x0\x3e\x63\x63\x63\x3e\x0"
"\x0\x0\x3f\x63\x63\x3f\x3\x3\x0\x0\x7e\x63\x63\x7e\x60\x60\x0\x0\x3f\x63\x3\x3\x3\x0\x0\x0\x3e\x3\x1e\x30\x1f\x0\xc\xc\x3f\xc\xc\xc\x38\x0\x0\x0\x63\x63\x63\x63\x3e\x0\x0\x0\x63\x63\x63\x36\x1c\x0\x0\x0\x6b\x6b\x6b\x6b\x3f\x0"
"\x0\x0\x63\x63\x3e\x63\x63\x0\x0\x0\x63\x63\x63\x7e\x60\x3f\x0\x0\x7f\x30\x1c\x6\x7f\x0\xe0\x30\x30\x1c\x30\x30\xe0\x0\x18\x18\x18\x18\x18\x18\x18\x18\x7\xc\xc\x38\xc\xc\x7\x0\x6e\x3b\x0\x0\x0\x0\x0\x0\x0\x8\x1c\x36\x63\x63\x7f\x0"
"\xff\x1\x1\x1\x1\x1\x1\x1\xff\x0\x0\x0\x0\x0\x0\x0\xff\x80\x80\x80\x80\x80\x80\x80\x1\x1\x1\x1\x1\x1\x1\x1\x80\x80\x80\x80\x80\x80\x80\x80\x1\x1\x1\x1\x1\x1\x1\xff\x0\x0\x0\x0\x0\x0\x0\xff\x80\x80\x80\x80\x80\x80\x80\xff"
"\x1\x0\x0\x0\x0\x0\x0\x0\x80\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x1\x0\x0\x0\x0\x0\x0\x0\x80\x1\x3\x7\xf\x1f\x3f\x7f\xff\xff\xfe\xfc\xf8\xf0\xe0\xc0\x80\xff\xff\x3\x3\x3\x3\x3\x3\xff\xff\x0\x0\x0\x0\x0\x0"
"\xff\xff\xc0\xc0\xc0\xc0\xc0\xc0\x3\x3\x3\x3\x3\x3\x3\x3\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\x3\x3\x3\x3\x3\x3\xff\xff\x0\x0\x0\x0\x0\x0\xff\xff\xc0\xc0\xc0\xc0\xc0\xc0\xff\xff\x3\x3\x0\x0\x0\x0\x0\x0\xc0\xc0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x3\x3\x0\x0\x0\x0\x0\x0\xc0\xc0\x0\x0\x0\xaa\x0\x0\x0\x0\x0\x3f\x3f\x3f\x3f\x3f\x3f\x0\x0\x7e\x7e\x7e\x7e\x7e\x7e\x0\x0\xfc\xfc\xfc\xfc\xfc\xfc\x0\x0\xf8\xf8\xf8\xf8\xf8\xf8\x0\x0\xf0\xf0\xf0\xf0\xf0\xf0\x0"
"\x0\xe0\xe0\xe0\xe0\xe0\xe0\x0\x0\xc0\xc0\xc0\xc0\xc0\xc0\x0\x0\x80\x80\x80\x80\x80\x80\x0\x0\x1\x1\x1\x1\x1\x1\x0\x0\x3\x3\x3\x3\x3\x3\x0\x0\x7\x7\x7\x7\x7\x7\x0\x0\xf\xf\xf\xf\xf\xf\x0\x0\x1f\x1f\x1f\x1f\x1f\x1f\x0"
"\x7e\x7e\x7e\x7e\x7e\x7e\x7e\x7e\xff\xff\x0\x18\x3c\x7e\xff\x0\xff\xff\x0\x0\x0\x0\x18\x18\xff\xff\x0\x18\x3c\x7e\xff\x18\xff\xff\x0\x42\x66\x5a\x42\x42\x0\x0\x0\x18\x18\x0\x0\x0\x0\x3\x3\x3\x3\x3\x3\x3\x0\x1b\x1b\x1b\x1b\x1b\x1b\x1b"
"\x0\xdb\xdb\xdb\xdb\xdb\xdb\xdb\x0\x6\x6\x6\x6\x6\x6\x6\x0\x36\x36\x36\x36\x36\x36\x36\x0\xb6\xb6\xb6\xb6\xb6\xb6\xb6\x0\x1\x1\x1\x1\x1\x1\x1\x0\xd\xd\xd\xd\xd\xd\xd\x0\x6d\x6d\x6d\x6d\x6d\x6d\x6d\x0\x0\x18\x3c\x3c\x18\x0\x0"
"\x0\x0\x1f\x18\x1f\x18\x18\x18\x6c\x6c\x6f\x60\x6f\x6c\x6c\x6c\x6c\x6c\x6c\x6c\x6c\x6c\x6c\x6c\x0\x0\x7f\x60\x6f\x6c\x6c\x6c\x6c\x6c\x6f\x60\x7f\x0\x0\x0\x6c\x6c\x6c\x6c\x7f\x0\x0\x0\x18\x18\x1f\x18\x1f\x0\x0\x0\x0\x0\x0\x0\x1f\x18\x18\x18"
"\x18\x18\x18\x18\xf8\x0\x0\x0\x18\x18\x18\x18\xff\x0\x0\x0\x0\x0\x0\x0\xff\x18\x18\x18\x18\x18\x18\x18\xf8\x18\x18\x18\x0\x0\x0\x0\xff\x0\x0\x0\x18\x18\x18\x18\xff\x18\x18\x18\x18\x18\xf8\x18\xf8\x18\x18\x18\x6c\x6c\x6c\x6c\xec\x6c\x6c\x6c"
"\x6c\x6c\xec\xc\xfc\x0\x0\x0\x0\x0\xfc\xc\xec\x6c\x6c\x6c\x6c\x6c\xef\x0\xff\x0\x0\x0\x0\x0\xff\x0\xef\x6c\x6c\x6c\x6c\x6c\xec\xc\xec\x6c\x6c\x6c\x0\x0\xff\x0\xff\x0\x0\x0\x6c\x6c\xef\x0\xef\x6c\x6c\x6c\x18\x18\xff\x0\xff\x0\x0\x0"
"\x6c\x6c\x6c\x6c\xff\x0\x0\x0\x0\x0\xff\x0\xff\x18\x18\x18\x0\x0\x0\x0\xff\x6c\x6c\x6c\x6c\x6c\x6c\x6c\xfc\x0\x0\x0\x18\x18\xf8\x18\xf8\x0\x0\x0\x0\x0\xf8\x18\xf8\x18\x18\x18\x0\x0\x0\x0\xfc\x6c\x6c\x6c\x6c\x6c\x6c\x6c\xff\x6c\x6c\x6c"
"\x18\x18\xff\x18\xff\x18\x18\x18\x18\x18\x18\x18\x1f\x0\x0\x0\x0\x0\x0\x0\xf8\x18\x18\x18\xff\xff\xff\xff\xff\xff\xff\xff\x0\x0\x0\x0\xff\xff\xff\xff\xf\xf\xf\xf\xf\xf\xf\xf\xf0\xf0\xf0\xf0\xf0\xf0\xf0\xf0\xff\xff\xff\xff\x0\x0\x0\x0"
"\x0\x0\x6e\x3b\x13\x3b\x6e\x0\x0\x1e\x33\x1f\x33\x1f\x3\x3\x0\x3f\x33\x3\x3\x3\x3\x0\x0\x0\x7f\x36\x36\x36\x36\x0\x3f\x33\x6\xc\x6\x33\x3f\x0\x0\x0\x7e\x1b\x1b\x1b\xe\x0\x0\x66\x66\x66\x66\x3e\x6\x3\x0\x6e\x3b\x18\x18\x18\x18\x0"
"\x3f\xc\x1e\x33\x33\x1e\xc\x3f\x1c\x36\x63\x7f\x63\x36\x1c\x0\x1c\x36\x63\x63\x36\x36\x77\x0\x38\xc\x18\x3e\x33\x33\x1e\x0\x0\x0\x7e\xdb\xdb\x7e\x0\x0\x60\x30\x7e\xdb\xdb\x7e\x6\x3\x1c\x6\x3\x1f\x3\x6\x1c\x0\x0\x0\x0\x0\x0\xdb\xdb\x0"
"\x0\x7e\x0\x7e\x0\x7e\x0\x0\x0\xf8\x8\x8\x8\x8\xf8\x0\x0\xff\x0\x0\x0\x0\xff\x0\x0\x1f\x10\x10\x10\x10\x1f\x0\x0\x0\x0\x8\x0\x0\x0\x0\x0\x0\x0\x2\x1\x0\x0\x0\x20\x30\x28\x24\x22\xa1\x60\x20\x0\x0\x0\x1\x2\x0\x0\x0"
"\x20\x60\xa1\x22\x24\x28\x30\x20\x0\x0\x0\x40\x40\x40\x40\x7f\xff\x81\x81\x81\x81\x80\x80\x80\x0\x0\x0\x20\x20\x11\x11\xe\x38\x44\x44\x82\x82\x0\x0\x0\x0\x0\xfe\x7c\x38\x10\x0\x0\x0\x0\x10\x38\x7c\xfe\x0\x0\x80\xc1\x63\x36\x1c\x8\x0\x0"
),
// Font no. 20
FontEntry("J-TERMO", 8, 8, 
"\x0\x0\x0\x0\x0\x0\x0\x0\x7e\x81\xa5\x81\xbd\x99\x81\x7e\x7e\xff\xdb\xff\xff\xc3\xe7\x7e\x0\x77\x7f\x7f\x3e\x1c\x8\x0\x8\x1c\x3e\x7f\x3e\x1c\x8\x0\x18\x3c\x18\xff\xff\x52\x18\x0\x8\x1c\x3e\x7f\x7f\x49\x1c\x0\x0\x0\x18\x3c\x18\x0\x0\x0"
"\xff\xff\xe7\xc3\xe7\xff\xff\xff\x0\x3c\x42\x81\x81\x42\x3c\x0\xff\xc3\xbd\x7e\x7e\xbd\xc3\xff\xf8\xe0\xb0\x3e\x63\x63\x3e\x0\x0\x7e\xc3\xc3\x7e\x18\x7e\x18\x20\x60\xe0\x20\x20\x3f\x1f\x0\x30\x50\xb0\xd0\x9f\x8f\xf0\xf0\x81\xc2\xbc\xe4\xa4\xfc\xea\xff"
"\x0\x0\x6\x1e\x7e\x1e\x6\x0\x0\x0\x60\x78\x7e\x78\x60\x0\x18\x7e\x18\x18\x18\x18\x7e\x18\x66\x66\x66\x66\x66\x0\x66\x0\xff\x6d\x6e\x6c\x6c\x6c\x6c\x0\x7e\x81\x3e\x42\x42\x7c\x81\x7e\x0\x0\x0\x7e\x7e\x0\x0\x0\x18\x7e\x18\x18\x7e\x18\x0\xff"
"\x18\x7e\x18\x18\x18\x18\x18\x0\x18\x18\x18\x18\x18\x7e\x18\x0\x0\x20\x60\xff\x60\x20\x0\x0\x0\x4\x6\xff\x6\x4\x0\x0\x0\x0\x0\x3\x3\x3\xff\x0\x0\x24\x66\xff\x66\x24\x0\x0\x0\x0\x8\x1c\x3e\x7f\x0\x0\x0\x0\x0\x7f\x3e\x1c\x8\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x1c\x1c\x1c\x1c\x1c\x0\x1c\x0\x77\x77\x77\x0\x0\x0\x0\x0\x0\x6c\xfe\x6c\x6c\xfe\x6c\x0\x18\x7e\x7\x3e\x70\x3f\xc\x0\x0\x66\x33\x18\xcc\x66\x0\x0\x1c\x36\x1c\xb6\x63\x73\xde\x0\x60\x30\x18\x0\x0\x0\x0\x0"
"\x30\x18\x18\x18\x18\x18\x18\x30\x6\xc\xc\xc\xc\xc\xc\x6\x8\x2a\x1c\x7f\x1c\x2a\x8\x0\x0\x18\x18\x7e\x18\x18\x0\x0\x0\x0\x0\x0\x0\x0\x18\xc\x0\x0\x0\x7e\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\xc\x0\x0\xe0\x70\x38\x1c\xe\x7\x0"
"\x3e\x77\x77\x7f\x77\x77\x3e\x0\x38\x3c\x38\x38\x38\x38\x7c\x0\x3e\x77\x70\x3c\xe\x7\x7f\x0\x3e\x70\x3c\x70\x77\x77\x3e\x0\x77\x77\x77\x77\x7e\x70\x70\x0\x7f\x7\x3f\x70\x77\x77\x3f\x0\x3e\x77\x7\x3f\x77\x77\x3e\x0\x7f\x60\x70\x38\x1c\x1c\x1c\x0"
"\x3e\x77\x77\x3e\x77\x77\x3e\x0\x3e\x77\x7e\x70\x77\x77\x3e\x0\x0\xc\x0\x0\x0\xc\x0\x0\x0\xc\x0\x0\x0\xc\x6\x0\x0\x18\xc\x6\xc\x18\x0\x0\x0\x0\x7e\x0\x7e\x0\x0\x0\x0\xc\x18\x30\x18\xc\x0\x0\x3e\x77\x70\x38\x1c\x0\x1c\x0"
"\x7e\xc3\xdb\xdb\x7b\x3\x3e\x0\x3e\x77\x7f\x77\x77\x77\x77\x0\x3f\x77\x3f\x77\x77\x77\x3f\x0\x3e\x77\x7\x7\x7\x77\x3e\x0\x3f\x77\x77\x77\x77\x77\x3f\x0\x7f\x7\x1f\x7\x77\x77\x7f\x0\x7f\x7\x1f\x7\x7\x7\x7\x0\x7e\x7\x77\x77\x77\x77\x3e\x0"
"\x77\x77\x77\x7f\x77\x77\x77\x0\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x0\x70\x70\x70\x70\x77\x77\x3e\x0\x77\x77\x3f\xf\x3f\x77\x77\x0\x7\x7\x7\x7\x77\x77\x7f\x0\x77\x7f\x77\x77\x77\x77\x77\x0\x3f\x77\x77\x77\x77\x77\x77\x0\x3e\x7f\x77\x77\x77\x7f\x3e\x0"
"\x3f\x77\x3f\x7\x7\x7\x7\x0\x3e\x77\x77\x77\x77\x77\x7e\xe0\x3f\x77\x3f\x77\x77\x77\x77\x0\x3e\x7\x3e\x70\x77\x77\x3e\x0\x7f\x1c\x1c\x1c\x1c\x1c\x1c\x0\x77\x77\x77\x77\x77\x77\x3e\x0\x77\x77\x77\x77\x77\x36\x1c\x0\x77\x77\x77\x77\x77\x7f\x77\x0"
"\x77\x77\x3e\x1c\x3e\x77\x77\x0\x77\x77\x3e\x1c\x1c\x1c\x1c\x0\x7f\x70\x38\x1c\xe\x7\x7f\x0\x38\x18\x18\x18\x18\x18\x18\x38\x0\x7\xe\x1c\x38\x70\xe0\x0\xe\xc\xc\xc\xc\xc\xc\xe\x18\x3c\x66\xc3\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\xff"
"\xc\x18\x30\x0\x0\x0\x0\x0\x0\x0\x3e\x70\x7e\x77\x7e\x0\x7\x7\x3f\x77\x77\x77\x3f\x0\x0\x0\x3e\x77\x7\x77\x3e\x0\x70\x70\x7e\x77\x77\x77\x7e\x0\x0\x0\x3e\x77\x7f\x7\x7e\x0\x3c\xe\xe\x3f\xe\xe\xe\x0\x0\x0\x3e\x77\x77\x7e\x70\x3e"
"\x7\x7\x3f\x77\x77\x77\x77\x0\x38\x0\x38\x38\x38\x38\x38\x0\x70\x0\x70\x70\x70\x70\x70\x3f\x7\x7\x77\x37\x1f\x37\x77\x0\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x0\x0\x0\x3f\x6b\x6b\x6b\x6b\x0\x0\x0\x3f\x77\x77\x77\x77\x0\x0\x0\x3e\x77\x77\x77\x3e\x0"
"\x0\x0\x3f\x77\x77\x3f\x7\x7\x0\x0\x7e\x77\x77\x7e\x70\x70\x0\x0\x3f\x77\x7\x7\x7\x0\x0\x0\x7e\x7\x7e\xe0\x7e\x0\x1c\x1c\x7f\x1c\x1c\x1c\x1c\x0\x0\x0\x77\x77\x77\x77\x3e\x0\x0\x0\x77\x77\x77\x36\x1c\x0\x0\x0\x6b\x6b\x6b\x6b\x3f\x0"
"\x0\x0\x77\x36\x1c\x36\x77\x0\x0\x0\x77\x77\x77\x7e\x70\x3f\x0\x0\x7f\x38\x1c\xe\x7f\x0\x30\x18\x18\xc\x18\x18\x30\x0\x18\x18\x18\x18\x18\x18\x18\x18\x6\xc\xc\x18\xc\xc\x6\x0\xe\xdb\x70\x0\x0\x0\x0\x0\x0\x0\x8\x14\x22\x7f\x0\x0"
"\xff\x1\x1\x1\x1\x1\x1\x1\xff\x0\x0\x0\x0\x0\x0\x0\xff\x80\x80\x80\x80\x80\x80\x80\x1\x1\x1\x1\x1\x1\x1\x1\x80\x80\x80\x80\x80\x80\x80\x80\x1\x1\x1\x1\x1\x1\x1\xff\x0\x0\x0\x0\x0\x0\x0\xff\x80\x80\x80\x80\x80\x80\x80\xff"
"\x1\x0\x0\x0\x0\x0\x0\x0\x80\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x1\x0\x0\x0\x0\x0\x0\x0\x80\x1\x3\x7\xf\x1f\x3f\x7f\xff\xff\xfe\xfc\xf8\xf0\xe0\xc0\x80\xff\xff\x3\x3\x3\x3\x3\x3\xff\xff\x0\x0\x0\x0\x0\x0"
"\xff\xff\xc0\xc0\xc0\xc0\xc0\xc0\x3\x3\x3\x3\x3\x3\x3\x3\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\x3\x3\x3\x3\x3\x3\xff\xff\x0\x0\x0\x0\x0\x0\xff\xff\xc0\xc0\xc0\xc0\xc0\xc0\xff\xff\x3\x3\x0\x0\x0\x0\x0\x0\xc0\xc0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x3\x3\x0\x0\x0\x0\x0\x0\xc0\xc0\x0\x0\x0\x55\x0\x0\x0\x0\x0\x3f\x3f\x3f\x3f\x3f\x3f\x0\x0\x7e\x7e\x7e\x7e\x7e\x7e\x0\x0\xfc\xfc\xfc\xfc\xfc\xfc\x0\x0\xf8\xf8\xf8\xf8\xf8\xf8\x0\x0\xf0\xf0\xf0\xf0\xf0\xf0\x0"
"\x0\xe0\xe0\xe0\xe0\xe0\xe0\x0\x0\xc0\xc0\xc0\xc0\xc0\xc0\x0\x0\x80\x80\x80\x80\x80\x80\x0\x0\x1\x1\x1\x1\x1\x1\x0\x0\x3\x3\x3\x3\x3\x3\x0\x0\x7\x7\x7\x7\x7\x7\x0\x0\xf\xf\xf\xf\xf\xf\x0\x0\x1f\x1f\x1f\x1f\x1f\x1f\x0"
"\x55\x6b\x55\x6b\x55\x6b\x55\x6b\xff\xff\x0\x0\x0\x8\x1c\x3e\xff\xff\x0\x0\x0\x0\x0\x7f\xff\xff\x0\x0\x8\x1c\x3e\x7f\xff\xff\x0\xc3\xe7\xff\xdb\xc3\x0\x0\x0\x0\x18\x0\x0\x0\x0\x3\x3\x3\x3\x3\x3\x3\x0\x1b\x1b\x1b\x1b\x1b\x1b\x1b"
"\x0\xdb\xdb\xdb\xdb\xdb\xdb\xdb\x0\x6\x6\x6\x6\x6\x6\x6\x0\x36\x36\x36\x36\x36\x36\x36\x0\xb6\xb6\xb6\xb6\xb6\xb6\xb6\x0\x1\x1\x1\x1\x1\x1\x1\x0\xd\xd\xd\xd\xd\xd\xd\x0\x6d\x6d\x6d\x6d\x6d\x6d\x6d\x0\x0\x18\x3c\x3c\x18\x0\x0"
"\x0\x0\x0\x1f\x18\x1f\x18\x18\x6c\x6c\x6c\x6f\x60\x6f\x6c\x6c\x6c\x6c\x6c\x6c\x6c\x6c\x6c\x6c\x0\x0\x0\x7f\x60\x6f\x6c\x6c\x6c\x6c\x6c\x6f\x60\x7f\x0\x0\x6c\x6c\x6c\x7f\x0\x0\x0\x0\x18\x18\x18\x1f\x18\x1f\x0\x0\x0\x0\x0\x1f\x18\x18\x18\x18"
"\x18\x18\x18\xf8\x0\x0\x0\x0\x18\x18\x18\xff\x0\x0\x0\x0\x0\x0\x0\xff\x18\x18\x18\x18\x18\x18\x18\xf8\x18\x18\x18\x18\x0\x0\x0\x0\xff\x0\x0\x0\x18\x18\x18\xff\x18\x18\x18\x18\x18\x18\x18\xf8\x18\xf8\x18\x18\x6c\x6c\x6c\xec\x6c\x6c\x6c\x6c"
"\x6c\x6c\x6c\xec\xc\xfc\x0\x0\x0\x0\x0\xfc\xc\xec\x6c\x6c\x6c\x6c\x6c\xef\x0\xff\x0\x0\x0\x0\x0\xff\x0\xef\x6c\x6c\x6c\x6c\x6c\xec\xc\xec\x6c\x6c\x0\x0\x0\xff\x0\xff\x0\x0\x6c\x6c\x6c\xef\x0\xef\x6c\x6c\x18\x18\x18\xff\x0\xff\x0\x0"
"\x6c\x6c\x6c\xff\x0\x0\x0\x0\x0\x0\x0\xff\x0\xff\x18\x18\x0\x0\x0\xff\x6c\x6c\x6c\x6c\x6c\x6c\x6c\xfc\x0\x0\x0\x0\x18\x18\x18\xf8\x18\xf8\x0\x0\x0\x0\x0\xf8\x18\xf8\x18\x18\x0\x0\x0\xfc\x6c\x6c\x6c\x6c\x6c\x6c\x6c\xff\x6c\x6c\x6c\x6c"
"\x18\x18\x18\xff\x18\xff\x18\x18\x18\x18\x18\x1f\x0\x0\x0\x0\x0\x0\x0\xf8\x18\x18\x18\x18\xff\xff\xff\xff\xff\xff\xff\xff\x0\x0\x0\x0\xff\xff\xff\xff\xf\xf\xf\xf\xf\xf\xf\xf\xf0\xf0\xf0\xf0\xf0\xf0\xf0\xf0\xff\xff\xff\xff\x0\x0\x0\x0"
"\x0\x0\xee\x19\x19\xee\x0\x0\x38\x6c\x66\x3f\x63\x63\x3f\x3\x7f\x46\x6\x6\x6\x6\x6\x0\x0\x0\xff\x66\x66\x66\x66\x0\x7f\x46\xc\x18\xc\x46\x7f\x0\x0\x0\xfc\x66\x63\x33\x1e\x0\x0\x0\xcc\xcc\xcc\x7c\xc\xf\x0\x0\xff\x18\x18\x18\x18\x0"
"\x3c\x18\x3c\x66\x66\x3c\x18\x3c\x0\x3e\x63\x7f\x63\x3e\x0\x0\x0\x7e\xc3\xc3\xc3\x66\xe7\x0\x78\x98\x3c\x66\x63\x33\x1e\x0\x0\x0\x66\x99\x99\x66\x0\x0\x0\xc0\x3e\x73\x67\x3e\x3\x0\x0\x7c\x3\x7f\x3\x7c\x0\x0\x0\x0\x0\x0\x0\xdb\xdb\x0"
"\x0\x7e\x0\x7e\x0\x7e\x0\x0\x0\xf8\x8\x8\x8\x8\xf8\x0\x0\xff\x0\x0\x0\x0\xff\x0\x0\x1f\x10\x10\x10\x10\x1f\x0\x0\x0\x0\x8\x0\x0\x0\x0\x0\x0\x0\x2\x1\x0\x0\x0\x20\x30\x28\x24\x22\xa1\x60\x20\x0\x0\x0\x1\x2\x0\x0\x0"
"\x20\x60\xa1\x22\x24\x28\x30\x20\x0\x0\x0\x40\x40\x40\x40\x7f\xff\x81\x81\x81\x81\x80\x80\x80\x0\x0\x0\x20\x20\x11\x11\xe\x38\x44\x44\x82\x82\x0\x0\x0\x0\x0\xfe\x7c\x38\x10\x0\x0\x0\x0\x10\x38\x7c\xfe\x0\x0\x80\xc1\x63\x36\x1c\x8\x0\x0"
),
// Font no. 21
FontEntry("KANAFONT", 8, 8, 
"\x0\x0\x0\x0\x0\x0\x0\x0\x3c\x42\xa5\x81\xbd\x99\x42\x3c\x3c\x7e\xdb\xff\xc3\xe7\x7e\x3c\x0\x66\xff\xff\xff\x7e\x18\x0\x0\x0\x1c\x3e\x3e\x1c\x0\x0\x0\x18\x3c\x66\xe7\x18\x3c\x0\x18\x3c\x7e\xff\x7e\x18\x3c\x0\x0\x0\x3c\x7e\x7e\x3c\x0\x0"
"\xff\xff\xc3\x81\x81\xc3\xff\xff\x0\x0\x3c\x7e\x66\x7e\x3c\x0\xff\xff\xc3\x81\x99\x81\xc3\xff\x78\x70\x58\x3e\x63\x63\x3e\x0\x3c\x66\x66\x3c\x18\x7e\x18\x18\xf8\x18\x18\xf8\x18\x1e\x1f\xe\xfe\xc6\xc6\xfe\xc6\xe6\x77\x3\xdb\xdb\x18\xff\xff\x18\xdb\xdb"
"\xe\x1e\x3e\x7e\x3e\x1e\xe\x0\x70\x78\x7c\x7e\x7c\x78\x70\x0\x18\x3c\x7e\x18\x7e\x3c\x18\x0\x66\x66\x66\x66\x66\x0\x66\x0\xff\xff\x66\x66\x66\x66\x66\x0\x7e\x3\x3f\x66\x66\x7c\x60\x3f\x0\x0\x0\x0\xff\xff\xff\x0\x18\x3c\x7e\x18\x7e\x3c\x18\x7e"
"\x18\x3c\x7e\x18\x18\x18\x18\x0\x18\x18\x18\x18\x7e\x3c\x18\x0\x0\x18\x30\x7f\x30\x18\x0\x0\x0\xc\x6\x7f\x6\xc\x0\x0\x0\x0\x3\x3\x7f\x7f\x0\x0\x0\x24\x66\xff\x66\x24\x0\x0\x0\x18\x3c\x7e\xff\xff\x0\x0\x0\x0\xff\xff\x7e\x3c\x18\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x18\x3c\x3c\x3c\x18\x0\x18\x0\x33\x77\x66\x0\x0\x0\x0\x0\x36\x7f\x7f\x36\x7f\x7f\x36\x0\x1c\x7e\xf\x3e\x78\x3f\x1c\x0\x0\x6e\x77\x38\x1c\xee\x76\x0\x1c\x3e\x36\xde\x77\x7f\xde\x0\x18\x1c\xc\x0\x0\x0\x0\x0"
"\x38\x3c\xc\xc\xc\x3c\x38\x0\x1c\x3c\x30\x30\x30\x3c\x1c\x0\x0\x36\x1c\x7f\x7f\x1c\x36\x0\x0\x18\x18\x7e\x7e\x18\x18\x0\x0\x0\x0\x0\x0\x18\x1c\xc\x0\x0\x0\x7e\x7e\x0\x0\x0\x0\x0\x0\x0\x0\x18\x18\x0\x0\x60\x70\x38\x1c\xe\x6\x0"
"\x3e\x7f\x67\x63\x73\x7f\x3e\x0\x1e\x1e\x18\x18\x18\x7e\x7e\x0\x3f\x7f\x60\x3e\x7\x7f\x7f\x0\x3f\x7f\x60\x3c\x70\x7f\x3f\x0\x63\x63\x63\x7f\x7f\x60\x60\x0\x7f\x7f\x3\x3f\x70\x7f\x3f\x0\x7c\x7e\x7\x3f\x63\x7f\x3e\x0\x7f\x7f\x60\x70\x1c\xe\xe\x0"
"\x3e\x7f\x63\x3e\x63\x7f\x3e\x0\x3e\x7f\x63\x7f\x70\x7f\x3f\x0\x0\x18\x18\x0\x0\x18\x18\x0\x0\x18\x18\x0\x0\x18\x1c\xc\x0\x38\x1c\xe\xe\x1c\x38\x0\x0\x7f\x7f\x0\x0\x7f\x7f\x0\x0\x1c\x38\x70\x70\x38\x1c\x0\x3e\x7f\x70\x38\x1c\x0\x1c\x1c"
"\x3e\x7f\x63\x7b\x3\x7f\x7e\x0\x3e\x7f\x63\x7f\x7f\x63\x63\x0\x3f\x7f\x63\x3f\x63\x7f\x3f\x0\x7c\x7e\x7\x3\x3\x7f\x7e\x0\x1f\x3f\x73\x63\x63\x7f\x3f\x0\x7c\x7e\x7\x7f\x3\x7f\x7f\x0\x7c\x7e\x7\x7f\x7f\x3\x3\x0\x7c\x7e\x7\x7b\x63\x7f\x3e\x0"
"\x63\x63\x63\x7f\x7f\x63\x63\x0\x3c\x3c\x18\x18\x18\x3c\x3c\x0\x7c\x7c\x60\x60\x70\x7f\x3f\x0\x63\x63\x33\x1f\x3f\x73\x63\x0\x3\x3\x3\x3\x7\x7e\x7c\x0\x63\x7f\x7f\x63\x63\x63\x63\x0\x67\x6f\x7f\x7b\x73\x63\x63\x0\x3c\x7e\x67\x63\x63\x7f\x3e\x0"
"\x3f\x7f\x63\x7f\x3f\x3\x3\x0\x3c\x7e\x67\x63\x5b\x3b\x76\x60\x3f\x7f\x63\x3f\x3f\x63\x63\x0\x7e\x7f\x3\x3f\x60\x7f\x3f\x0\x7e\x7e\x18\x18\x18\x18\x18\x0\x63\x63\x63\x63\x63\x7f\x3e\x0\x63\x63\x63\x63\x77\x3e\x1c\x0\x63\x63\x63\x63\x7f\x7f\x63\x0"
"\x63\x63\x63\x3e\x3e\x63\x63\x0\x63\x63\x7f\x7e\x60\x7f\x3f\x0\xff\xff\x70\x38\xe\xff\xff\x0\x3c\x3c\xc\xc\xc\x3c\x3c\x0\x0\x6\xe\x1c\x38\x70\x60\x0\x3c\x3c\x30\x30\x30\x3c\x3c\x0\x1c\x3e\x77\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\xff\xff"
"\xc\x1c\x18\x0\x0\x0\x0\x0\x0\x0\x3e\x7f\x63\x7f\x7e\x0\x3\x3\x3f\x7f\x63\x7f\x3f\x0\x0\x0\x7e\x7f\x3\x7f\x7e\x0\x60\x60\x7e\x7f\x63\x7f\x7e\x0\x0\x3e\x7f\x63\x7f\x3\x7e\x0\x70\x78\x18\x7e\x18\x1e\xe\x0\x0\x3e\x7f\x63\x7e\x60\x7f\x3f"
"\x3\x3\x3f\x7f\x63\x63\x63\x0\x1c\x1c\x0\x1e\x1e\x78\x70\x0\x70\x70\x0\x78\x78\x70\x3f\x1f\x3\x33\x33\x1f\x3f\x33\x33\x0\x18\x18\x18\x18\x18\x78\x70\x0\x0\x0\x3e\x7f\x6b\x63\x63\x0\x0\x0\x3f\x7f\x63\x63\x63\x0\x0\x0\x3e\x7f\x63\x7f\x3e\x0"
"\x0\x3e\x7f\x63\x7f\x3f\x3\x3\x0\x7e\x7f\x63\x7f\x7e\x60\x60\x0\x0\x3f\x7f\x63\x3\x3\x0\x0\x0\x7e\xf\x3e\x78\x3f\x0\xc\xc\x3f\x3f\xc\x3c\x38\x0\x0\x0\x63\x63\x63\x7f\x3e\x0\x0\x0\x63\x63\x77\x3e\x1c\x0\x0\x0\x63\x63\x6b\x7f\x3e\x0"
"\x0\x0\x63\x3e\x3e\x63\x63\x0\x0\x66\x66\x7e\x7c\x70\x3f\x1f\x0\x0\x7f\x78\x3e\x7\x7f\x0\x70\x78\x18\xe\xe\x18\x78\x70\x18\x18\x18\x18\x18\x18\x18\x18\xe\x1e\x18\x70\x70\x18\x1e\xe\x6e\x7f\x3b\x0\x0\x0\x0\x0\x0\x8\x1c\x3e\x77\x7f\x0\x0"
"\xff\x1\x1\x1\x1\x1\x1\x1\xff\x0\x0\x0\x0\x0\x0\x0\xff\x80\x80\x80\x80\x80\x80\x80\x1\x1\x1\x1\x1\x1\x1\x1\x80\x80\x80\x80\x80\x80\x80\x80\x1\x1\x1\x1\x1\x1\x1\xff\x0\x0\x0\x0\x0\x0\x0\xff\x80\x80\x80\x80\x80\x80\x80\xff"
"\x1\x0\x0\x0\x0\x0\x0\x0\x80\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x1\x0\x0\x0\x0\x0\x0\x0\x80\x1\x3\x7\xf\x1f\x3f\x7f\xff\xff\xfe\xfc\xf8\xf0\xe0\xc0\x80\xff\xff\x3\x3\x3\x3\x3\x3\xff\xff\x0\x0\x0\x0\x0\x0"
"\xff\xff\xc0\xc0\xc0\xc0\xc0\xc0\x3\x3\x3\x3\x3\x3\x3\x3\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\x3\x3\x3\x3\x3\x3\xff\xff\x0\x0\x0\x0\x0\x0\xff\xff\xc0\xc0\xc0\xc0\xc0\xc0\xff\xff\x3\x3\x0\x0\x0\x0\x0\x0\xc0\xc0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x3\x3\x0\x0\x0\x0\x0\x0\xc0\xc0\x0\x0\x0\xaa\x0\x0\x0\x0\x0\x3f\x3f\x3f\x3f\x3f\x3f\x0\x0\x7e\x7e\x7e\x7e\x7e\x7e\x0\x0\xfc\xfc\xfc\xfc\xfc\xfc\x0\x0\xf8\xf8\xf8\xf8\xf8\xf8\x0\x0\xf0\xf0\xf0\xf0\xf0\xf0\x0"
"\x0\xe0\xe0\xe0\xe0\xe0\xe0\x0\x0\xc0\xc0\xc0\xc0\xc0\xc0\x0\x0\x80\x80\x80\x80\x80\x80\x0\x0\x1\x1\x1\x1\x1\x1\x0\x0\x3\x3\x3\x3\x3\x3\x0\x0\x7\x7\x7\x7\x7\x7\x0\x0\xf\xf\xf\xf\xf\xf\x0\x0\x1f\x1f\x1f\x1f\x1f\x1f\x0"
"\x7e\x7e\x7e\x7e\x7e\x7e\x7e\x7e\xff\xff\x18\x3c\x66\xc3\x66\x66\xff\xff\x0\x0\x0\x0\x18\x18\xff\xff\x0\x18\x3c\x7e\x18\x18\xff\xff\x0\x66\x7e\x7e\x66\x66\x0\x0\x0\x8\x0\x0\x0\x0\x0\x3\x3\x3\x3\x3\x3\x3\x0\x1b\x1b\x1b\x1b\x1b\x1b\x1b"
"\x0\xdb\xdb\xdb\xdb\xdb\xdb\xdb\x0\x6\x6\x6\x6\x6\x6\x6\x0\x36\x36\x36\x36\x36\x36\x36\x0\xb6\xb6\xb6\xb6\xb6\xb6\xb6\x0\x1\x1\x1\x1\x1\x1\x1\x0\xd\xd\xd\xd\xd\xd\xd\x0\x6d\x6d\x6d\x6d\x6d\x6d\x6d\x0\x0\x0\x18\x18\x0\x0\x0"
"\x0\x0\x1f\x18\x1f\x18\x18\x18\x66\x66\x67\x60\x67\x66\x66\x66\x66\x66\x66\x66\x66\x66\x66\x66\x0\x0\x7f\x60\x67\x66\x66\x66\x66\x66\x67\x60\x7f\x0\x0\x0\x66\x66\x66\x66\x7f\x0\x0\x0\x18\x18\x1f\x18\x1f\x0\x0\x0\x0\x0\x0\x1f\x18\x18\x18\x18"
"\x18\x18\x18\xf8\x0\x0\x0\x0\x18\x18\x18\xff\x0\x0\x0\x0\x0\x0\x0\xff\x18\x18\x18\x18\x18\x18\x18\xf8\x18\x18\x18\x18\x0\x0\x0\x0\xff\x0\x0\x0\x18\x18\x18\xff\x18\x18\x18\x18\x18\x18\xf8\x18\xf8\x18\x18\x18\x66\x66\x66\x66\xe6\x66\x66\x66"
"\x66\x66\xe6\x6\xfe\x0\x0\x0\x0\x0\xfe\x6\xe6\x66\x66\x66\x66\x66\xe7\x0\xff\x0\x0\x0\x0\x0\xff\x0\xe7\x66\x66\x66\x66\x66\xe6\x6\xe6\x66\x66\x66\x0\x0\xff\x0\xff\x0\x0\x0\x66\x66\xe7\x0\xe7\x66\x66\x66\x18\x18\xff\x0\xff\x0\x0\x0"
"\x66\x66\x66\xff\x0\x0\x0\x0\x0\x0\xff\x0\xff\x18\x18\x18\x0\x0\x0\xff\x66\x66\x66\x66\x66\x66\x66\xfe\x0\x0\x0\x0\x18\x18\xf8\x18\xf8\x0\x0\x0\x0\x0\xf8\x18\xf8\x18\x18\x18\x0\x0\x0\xfe\x66\x66\x66\x66\x66\x66\x66\xff\x66\x66\x66\x66"
"\x18\x18\xff\x18\xff\x18\x18\x18\x18\x18\x18\x1f\x0\x0\x0\x0\x0\x0\x0\xf8\x18\x18\x18\x18\xff\xff\xff\xff\xff\xff\xff\xff\x0\x0\x0\x0\xff\xff\xff\xff\xf\xf\xf\xf\xf\xf\xf\xf\xf0\xf0\xf0\xf0\xf0\xf0\xf0\xf0\xff\xff\xff\xff\x0\x0\x0\x0"
"\x0\x0\x6e\x7f\x33\x7f\x6e\x0\x3f\x7f\x63\x3f\x63\x7f\x3f\x3\x7f\x7f\x63\x3\x3\x3\x3\x0\x0\x3\xff\xff\x66\x66\x66\x0\x7f\x7f\xe\x1c\xe\x7f\x7f\x0\x0\xc0\xfe\x7f\x33\x3f\x1e\x0\x0\x0\x66\x66\x7e\x3e\x7\x3\x0\x0\xff\xff\x1b\x18\x18\x0"
"\x0\x3c\x7e\x66\x66\x7e\x3c\x0\x3e\x7f\x63\x7f\x63\x7f\x3e\x0\x3e\x7f\x63\x77\x36\x77\x77\x0\x7e\x7\x3e\x7f\x63\x7f\x3e\x0\x0\x0\x7e\xdb\xdb\x7e\x0\x0\x30\x30\x7e\xdb\xdb\x7e\xc\xc\x3e\x3f\x3\x3f\x3\x3f\x3e\x0\x0\x0\x0\x0\x0\xdb\xdb\x0"
"\x0\x7e\x0\x7e\x0\x7e\x0\x0\x0\xf8\x8\x8\x8\x8\xf8\x0\x0\xff\x0\x0\x0\x0\xff\x0\x0\x1f\x10\x10\x10\x10\x1f\x0\x0\x0\x0\x8\x0\x0\x0\x0\x0\x0\x0\x2\x1\x0\x0\x0\x20\x30\x28\x24\x22\xa1\x60\x20\x0\x0\x0\x1\x2\x0\x0\x0"
"\x20\x60\xa1\x22\x24\x28\x30\x20\x0\x0\x0\x40\x40\x40\x40\x7f\xff\x81\x81\x81\x81\x80\x80\x80\x0\x0\x0\x20\x20\x11\x11\xe\x38\x44\x44\x82\x82\x0\x0\x0\x0\x0\xfe\x7c\x38\x10\x0\x0\x0\x0\x10\x38\x7c\xfe\x0\x0\x80\xc1\x63\x36\x1c\x8\x0\x0"
),
// Font no. 22
FontEntry("MOTIF", 8, 8, 
"\x0\x0\x0\x0\x0\x0\x0\x0\x7e\x81\xa5\x81\xbd\x99\x81\x7e\x3e\x7f\x6b\x5d\x63\x7f\x3e\x0\x63\x77\x7f\x7f\x3e\x1c\x8\x0\x8\x1c\x3e\x7f\x3e\x1c\x8\x0\x8\x1c\x8\x77\x77\x8\x1c\x0\x1c\x3e\x7f\x7f\x36\x8\x1c\x0\x0\x18\x3c\x7e\x3c\x18\x0\x0"
"\xff\xe7\xc3\x81\xc3\xe7\xff\xff\x0\x18\x3c\x66\x66\x3c\x18\x0\xff\xe7\xc3\x99\x99\xc3\xe7\xff\x78\x70\x78\x6c\x1e\x33\x33\x1e\x7e\xc3\xc3\x7e\x18\x7e\x18\x18\x78\x58\x78\x18\x18\xe\xf\x6\x7c\x7c\x6c\x6c\x6f\x66\x78\x30\xdb\x3c\x66\xe7\x66\x3c\xdb\x0"
"\x1\x3\xf\x1f\xf\x3\x1\x0\x40\x60\x78\x7c\x78\x60\x40\x0\x18\x3c\x7e\x18\x7e\x3c\x18\x0\x66\x66\x66\x66\x66\x0\x66\x0\xfe\xdb\xde\xdc\xd8\xd8\xd8\x0\x3c\x66\x1c\x36\x36\x1c\x33\x1e\x0\x0\x0\x0\x7f\x7f\x7f\x0\x18\x3c\x7e\x18\x7e\x3c\x18\x7e"
"\x18\x3c\x7e\x18\x18\x18\x18\x0\x18\x18\x18\x18\x7e\x3c\x18\x0\x0\x18\x38\x7f\x38\x18\x0\x0\x0\xc\xe\x7f\xe\xc\x0\x0\x0\x0\x3\x3\x3\x7f\x0\x0\x0\x24\x66\xff\x66\x24\x0\x0\x0\x8\x1c\x3e\x3e\x7f\x0\x0\x0\x7f\x3e\x3e\x1c\x8\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x18\x3c\x3c\x18\x18\x0\x18\x0\x36\x36\x36\x0\x0\x0\x0\x0\x36\x36\x7f\x36\x7f\x36\x36\x0\x18\x7e\x3\x3e\x60\x3f\x18\x0\x0\x63\x30\x18\xc\x6\x63\x0\x1c\x36\x1c\x6e\x33\x33\x6e\x0\x18\x18\xc\x0\x0\x0\x0\x0"
"\x18\xc\x6\x6\x6\xc\x18\x0\x6\xc\x18\x18\x18\xc\x6\x0\x0\x77\x3e\x7f\x3e\x77\x0\x0\x0\x18\x18\x7e\x18\x18\x0\x0\x0\x0\x0\x0\x18\x18\xc\x0\x0\x0\x0\x7f\x0\x0\x0\x0\x0\x0\x0\x0\x0\x1c\x1c\x0\x60\x30\x18\xc\x6\x3\x1\x0"
"\x0\x0\x3c\x76\x66\x6e\x3c\x0\x0\x0\x18\x1c\x18\x18\x3c\x0\x0\x0\x3c\x66\x30\xc\x7e\x0\x0\x7e\x30\x38\x60\x60\x30\x1e\x0\x34\x36\x36\x33\x7f\x30\x0\x0\x7e\x2\x3e\x66\x60\x30\x1e\x38\xc\x6\x3e\x66\x66\x3c\x0\x0\x7e\x60\x30\x38\x18\xc\xc"
"\x3c\x66\x66\x3c\x66\x66\x3c\x0\x0\x3c\x66\x66\x7c\x60\x30\x1c\x0\x0\x4\x0\x0\x4\x0\x0\x0\x18\x18\x0\x0\x18\x18\xc\x30\x18\xc\x6\xc\x18\x30\x0\x0\x0\x7f\x0\x0\x7f\x0\x0\x6\xc\x18\x30\x18\xc\x6\x0\x3e\x63\x60\x30\x18\x0\x18\x0"
"\x3e\x63\x63\x7b\x3b\x3\x7e\x0\x1c\x36\x63\x63\x7f\x63\x63\x0\x3f\x66\x66\x3e\x66\x66\x3f\x0\x3c\x66\x3\x3\x3\x66\x3c\x0\x1f\x36\x66\x66\x66\x36\x1f\x0\x3f\x33\x6\xc\x6\x33\x3f\x0\x1c\x6\x3\x1f\x3\x3\x3\x0\x3e\x63\x3\x3\x7b\x63\x3e\x0"
"\x63\x63\x63\x7f\x63\x63\x63\x0\x3c\x18\x18\x18\x18\x18\x3c\x0\x18\x18\x18\x18\x1b\x1b\xe\x0\x63\x33\x1b\xf\x1b\x33\x63\x0\xf\x6\x6\x6\x6\x46\x7f\x0\x63\x77\x7f\x6b\x6b\x63\x63\x0\x1e\x33\x33\x33\x33\x33\x33\x0\x1c\x36\x63\x7f\x63\x36\x1c\x0"
"\x3f\x66\x66\x3e\x6\x6\xf\x0\x3e\x63\x63\x63\x63\x6b\x3e\x60\x0\x3f\x33\x3\x3\x3\x3\x0\x3e\x63\x3\x3e\x60\x63\x3e\x0\x0\x6e\x3b\x18\x18\x18\x18\x0\x63\x63\x63\x63\x63\x63\x3e\x0\x63\x63\x63\x63\x36\x1c\x8\x0\x63\x63\x6b\x6b\x7f\x77\x63\x0"
"\x63\x36\x1c\x1c\x1c\x36\x63\x0\x66\x66\x66\x66\x66\x7c\x60\xc0\x7f\x61\x30\x18\xc\x46\x7f\x0\x3e\x6\x6\x6\x6\x6\x3e\x0\x3\x6\xc\x18\x30\x60\x40\x0\x3e\x30\x30\x30\x30\x30\x3e\x0\x8\x1c\x36\x63\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\xff"
"\xc\xc\x18\x0\x0\x0\x0\x0\x0\x0\x6e\x3b\x13\x3b\x6e\x0\x0\x1e\x33\x1f\x33\x1f\x3\x3\x0\x0\x3e\x63\x3\x63\x3e\x0\x0\x0\x3f\x66\x66\x66\x3f\x0\x0\x1c\x6\x3\x1f\x3\x6\x1c\x0\x0\x7f\x3\x1f\x3\x3\x0\x0\x0\x3c\x66\x66\x38\x60\x38"
"\x0\x0\x63\x63\x7f\x63\x63\x0\x0\x0\x3c\x18\x18\x18\x3c\x0\x0\x0\x30\x30\x30\x36\x1c\x0\x0\x0\x63\x33\x1f\x33\x63\x0\x0\x0\x3\x3\x3\x3\x3f\x0\x0\x0\x63\x77\x6b\x6b\x63\x0\x0\x0\x7e\x6c\x6c\x6c\x6c\x0\x0\x0\x3e\x63\x63\x63\x3e\x0"
"\x0\x0\x3f\x66\x3e\x6\xf\x0\x0\x0\x3e\x63\x63\x3b\x6e\x0\x0\x0\x3f\x66\x3e\x36\x67\x0\x0\x0\x3e\x3\x3e\x60\x3e\x0\x0\x0\x7e\x5a\x18\x18\x3c\x0\x0\x0\x63\x63\x63\x63\x3e\x0\x0\x0\x63\x63\x36\x1c\x8\x0\x0\x0\x63\x6b\x6b\x77\x63\x0"
"\x0\x0\x63\x36\x1c\x36\x63\x0\x0\x0\x66\x66\x3c\x18\x18\x0\x0\x0\x3f\x19\xc\x26\x3f\x0\x70\x18\x18\xe\x18\x18\x70\x0\x18\x18\x18\x0\x18\x18\x18\x0\xe\x18\x18\x70\x18\x18\xe\x0\x6e\x3b\x0\x0\x0\x0\x0\x0\x0\x8\x1c\x1c\x36\x36\x7f\x0"
"\xff\x1\x1\x1\x1\x1\x1\x1\xff\x0\x0\x0\x0\x0\x0\x0\xff\x80\x80\x80\x80\x80\x80\x80\x1\x1\x1\x1\x1\x1\x1\x1\x80\x80\x80\x80\x80\x80\x80\x80\x1\x1\x1\x1\x1\x1\x1\xff\x0\x0\x0\x0\x0\x0\x0\xff\x80\x80\x80\x80\x80\x80\x80\xff"
"\x1\x0\x0\x0\x0\x0\x0\x0\x80\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x1\x0\x0\x0\x0\x0\x0\x0\x80\x1\x3\x7\xf\x1f\x3f\x7f\xff\xff\xfe\xfc\xf8\xf0\xe0\xc0\x80\xff\xff\x3\x3\x3\x3\x3\x3\xff\xff\x0\x0\x0\x0\x0\x0"
"\xff\xff\xc0\xc0\xc0\xc0\xc0\xc0\x3\x3\x3\x3\x3\x3\x3\x3\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\x3\x3\x3\x3\x3\x3\xff\xff\x0\x0\x0\x0\x0\x0\xff\xff\xc0\xc0\xc0\xc0\xc0\xc0\xff\xff\x3\x3\x0\x0\x0\x0\x0\x0\xc0\xc0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x3\x3\x0\x0\x0\x0\x0\x0\xc0\xc0\x0\xff\x30\xb7\x81\xed\xc\xff\x0\x3f\x29\x23\x31\x25\x3f\x0\x0\x7e\x52\x46\x62\x4a\x7e\x0\x0\xfc\xa4\x8c\xc4\x94\xfc\x0\x0\xf8\x48\x18\x88\x28\xf8\x0\x0\xf0\x90\x30\x10\x50\xf0\x0"
"\x0\xe0\x20\x60\x20\xa0\xe0\x0\x0\xc0\x40\xc0\x40\x40\xc0\x0\x0\x80\x80\x80\x80\x80\x80\x0\x0\x1\x1\x1\x1\x1\x1\x0\x0\x3\x2\x2\x3\x2\x3\x0\x0\x7\x5\x4\x6\x4\x7\x0\x0\xf\xa\x8\xc\x9\xf\x0\x0\x1f\x14\x11\x18\x12\x1f\x0"
"\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xff\xff\x0\x18\x3c\x7e\xff\x0\xff\xff\x0\x0\x0\x0\x18\x18\xff\xff\x0\x18\x3c\x7e\xff\x3c\xff\xff\x0\x42\x66\x5a\x42\x42\x0\x0\x0\x18\x18\x0\x0\x0\x0\x0\x1\x1\x1\x1\x1\x0\x0\x0\x15\x15\x15\x15\x15\x0"
"\x0\x0\x55\x55\x55\x55\x55\x0\x0\x0\x5\x5\x5\x5\x5\x0\x0\x0\x55\x55\x55\x55\x55\x0\x0\x0\x55\x55\x55\x55\x55\x0\x0\x0\x1\x1\x1\x1\x1\x0\x0\x0\x5\x5\x5\x5\x5\x0\x0\x0\x55\x55\x55\x55\x55\x0\x0\x0\x18\x3c\x3c\x18\x0\x0"
"\x0\x0\x0\x66\x0\x0\x0\x0\x0\x78\x84\x2\x0\x0\x0\x0\x0\x0\x0\x41\x22\x1c\x0\x0\x0\x7c\x44\x44\x44\x44\xc6\x0\x0\x7c\x44\x44\x44\x44\xc7\x0\x0\xc\x34\xc4\x4\x4\x4\x0\x0\x20\x20\x20\x23\x2c\x30\x0\x0\x60\x20\x20\x20\x20\x60\x0"
"\x0\x3\x2\x2\x2\x2\x3\x0\x0\x0\x0\x18\x18\x0\x0\x0\x0\x0\x18\x3c\x3c\x18\x0\x0\x0\x0\x18\x3c\x3c\x18\x0\x0\x0\x0\x0\x0\xff\x0\x0\x0\x0\x0\x3c\x3c\x3c\x3c\x0\x0\x0\x18\x3c\x7e\x7e\x3c\x18\x0\x0\x18\x3c\x7e\x7e\x3c\x18\x0"
"\x0\x3c\x7e\x7e\x7e\x7e\x3c\x0\x0\x3c\x7e\x7e\x7e\x7e\x3c\x0\x6c\x6c\xef\x0\xff\x0\x0\x0\x0\x0\xff\x0\xef\x6c\x6c\x6c\x6c\x6c\xec\xc\xec\x6c\x6c\x6c\x0\x0\xff\x81\xff\x0\x0\x0\x6c\x6c\xef\x0\xef\x6c\x6c\x6c\x18\x18\xff\x0\xff\x0\x0\x0"
"\x6c\x6c\x6c\x6c\xff\x0\x0\x0\x0\x0\xff\x0\xff\x18\x18\x18\x0\x0\x0\x0\xff\x6c\x6c\x6c\x6c\x6c\x6c\x6c\xfc\x0\x0\x0\x18\x18\xf8\x18\xf8\x0\x0\x0\x0\x0\xf8\x18\xf8\x18\x18\x18\x0\x0\x0\x0\xfc\x6c\x6c\x6c\x6c\x6c\x6c\x6c\xff\x6c\x6c\x6c"
"\x18\x18\xff\x18\xff\x18\x18\x18\x18\x18\x18\x18\x1f\x0\x0\x0\x0\x0\x0\x0\xf8\x18\x18\x18\xff\xff\xff\xff\xff\xff\xff\xff\x0\x0\x0\x0\xff\xff\xff\xff\xf\xf\xf\xf\xf\xf\xf\xf\xf0\xf0\xf0\xf0\xf0\xf0\xf0\xf0\xff\xff\xff\xff\x0\x0\x0\x0"
"\x0\x0\x6e\x3b\x13\x3b\x6e\x0\x0\x1e\x33\x1f\x33\x1f\x3\x3\x0\x3f\x33\x3\x3\x3\x3\x0\x0\x0\x7f\x36\x36\x36\x36\x0\x3f\x33\x6\xc\x6\x33\x3f\x0\x0\x0\x7e\x1b\x1b\x1b\xe\x0\x0\x66\x66\x66\x66\x3e\x6\x3\x0\x6e\x3b\x18\x18\x18\x18\x0"
"\x3f\xc\x1e\x33\x33\x1e\xc\x3f\x1c\x36\x63\x7f\x63\x36\x1c\x0\x1c\x36\x63\x63\x36\x36\x77\x0\x38\xc\x18\x3e\x33\x33\x1e\x0\x0\x0\x7e\xdb\xdb\x7e\x0\x0\x60\x30\x7e\xdb\xdb\x7e\x6\x3\x1c\x6\x3\x1f\x3\x6\x1c\x0\x0\x0\x0\x0\x0\xdb\xdb\x0"
"\x0\x7e\x0\x7e\x0\x7e\x0\x0\x0\xf8\x8\x8\x8\x8\xf8\x0\x0\xff\x0\x0\x0\x0\xff\x0\x0\x1f\x10\x10\x10\x10\x1f\x0\x0\x0\x0\x8\x0\x0\x0\x0\x0\x0\x0\x2\x1\x0\x0\x0\x20\x30\x28\x24\x22\xa1\x60\x20\x0\x0\x0\x1\x2\x0\x0\x0"
"\x20\x60\xa1\x22\x24\x28\x30\x20\x0\x0\x0\x40\x40\x40\x40\x7f\xff\x81\x81\x81\x81\x80\x80\x80\x0\x0\x0\x20\x20\x11\x11\xe\x38\x44\x44\x82\x82\x0\x0\x0\x0\x0\xfe\x7c\x38\x10\x0\x0\x0\x0\x10\x38\x7c\xfe\x0\x0\x80\xc1\x63\x36\x1c\x8\x0\x0"
),
// Font no. 23
FontEntry("NOTCH", 8, 8, 
"\x0\x0\x0\x0\x0\x0\x0\x0\x7e\x81\xa5\x81\xbd\x99\x81\x7e\x7e\xff\xdb\xff\xff\xc3\xe7\x7e\x22\x77\x7f\x7f\x3e\x1c\x8\x0\x8\x1c\x3e\x7f\x3e\x1c\x8\x0\x18\x3c\x18\xff\xff\x52\x18\x0\x8\x1c\x3e\x7f\x7f\x49\x1c\x0\x0\x0\x18\x3c\x18\x0\x0\x0"
"\xff\xff\xe7\xc3\xe7\xff\xff\xff\x0\x3c\x42\x42\x42\x42\x3c\x0\xff\xc3\xbd\xbd\xbd\xbd\xc3\xff\xf8\xe0\xb0\x3e\x63\x63\x3e\x0\x0\x7e\xc3\xc3\x7e\x18\x7e\x18\x20\x60\xe0\x20\x2e\x3f\x1f\xe\x30\x50\xb0\xd0\x9f\x8f\xf0\xf0\x81\xc2\xbc\xe4\xa4\xfc\xea\xff"
"\x1\x3\x7\xf\xf\x7\x3\x1\x80\xc0\xe0\xf0\xf0\xe0\xc0\x80\xc\x1e\x3f\xc\xc\x3f\x1e\xc\x66\x66\x66\x66\x66\x0\x66\x0\xff\x6d\x6d\x6e\x6c\x6c\x6c\x0\x3e\x41\x1e\x22\x22\x3c\x41\x3e\x0\x0\x0\x0\x7f\x7f\x7f\x7f\x18\x7e\x18\x18\x7e\x18\x0\xff"
"\x18\x3c\x7e\x18\x18\x18\x18\x0\x18\x18\x18\x18\x7e\x3c\x18\x0\x0\x20\x60\xff\x60\x20\x0\x0\x0\x4\x6\xff\x6\x4\x0\x0\x0\x0\x0\x3\x3\x3\xff\x0\x0\x24\x66\xff\x66\x24\x0\x0\x0\x0\x0\x0\x18\x3c\x7e\xff\xff\x7e\x3c\x18\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\xc\xc\xc\xc\xc\x0\xc\x0\x66\x66\x11\x0\x0\x0\x0\x0\xa\x1f\xa\x1f\xa\x0\x0\x0\x3e\x4b\xb\x3e\x68\x6b\x3e\x8\xc7\x65\x37\x18\xec\xa6\xe3\x0\x1c\x36\x1c\x6e\x3b\x33\x6e\x0\xc\xc\x6\x0\x0\x0\x0\x0"
"\x40\x30\x18\x18\x18\x30\x40\x0\x1\x6\xc\xc\xc\x6\x1\x0\x0\x2a\x1c\x7f\x1c\x2a\x0\x0\x0\x18\x18\x7e\x18\x18\x0\x0\x0\x0\x0\x0\x0\xc\xc\x6\x0\x0\x0\x3f\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x30\x0\x80\xc0\x60\x30\x18\xc\x6\x3"
"\x3e\x61\x63\x6b\x63\x63\x3e\x0\x18\x1c\x18\x18\x18\x18\x3c\x0\x3e\x63\x60\x30\xc\x6\x7f\x0\x3e\x43\x60\x3c\x60\x63\x3e\x0\x70\x78\x6c\x46\x7f\x60\x60\x0\x7f\x1\x3\x3f\x60\x60\x3f\x0\x3e\x63\x3\x3f\x63\x63\x3e\x0\x7f\x40\x30\x18\xc\xc\xc\x0"
"\x3e\x63\x63\x3e\x63\x63\x3e\x0\x3e\x63\x63\x7e\x60\x30\x1c\x0\x0\xc\xc\x0\x0\xc\xc\x0\x0\xc\xc\x0\xc\xc\x6\x0\xc0\x60\x30\x18\x18\x30\x60\xc0\x0\x0\x7e\x0\x7e\x0\x0\x0\x3\x6\xc\x18\x18\xc\x6\x3\x3e\x63\x30\x18\xc\x0\xc\x0"
"\x3e\x41\x5d\x55\x7d\x1\x3e\x0\x1c\x36\x63\x63\x7f\x63\x63\x0\x3f\x61\x63\x3f\x63\x63\x3f\x0\x3c\x66\x3\x3\x43\x66\x3c\x0\x3f\x61\x63\x63\x63\x63\x3f\x0\x7f\x1\x3\x1f\x3\x3\x7f\x0\x7f\x41\x3\x1f\x13\x3\x3\x0\x3e\x63\x3\x7b\x4b\x63\x5e\x0"
"\x63\x63\x63\x7f\x63\x63\x63\x0\x7e\x8\x18\x18\x18\x18\x7e\x0\x78\x10\x30\x30\x30\x33\x1e\x0\x63\x33\x1b\xf\x1b\x33\x63\x0\xf\x2\x6\x6\x6\x46\x7f\x0\x63\x77\x7f\x6b\x6b\x63\x63\x0\x63\x67\x6f\x7b\x73\x63\x63\x0\x3e\x61\x63\x63\x63\x63\x3e\x0"
"\x3f\x62\x66\x3e\x6\x6\xf\x0\x3e\x61\x63\x63\x7b\x73\x3e\x60\x3f\x62\x66\x3e\x66\x66\x67\xc0\x3e\x43\x3\x3e\x60\x63\x3e\x0\x7e\x8\x18\x18\x18\x18\x18\x0\x63\x63\x63\x63\x63\x63\x3e\x0\x63\x63\x63\x63\x63\x36\x1c\x0\x63\x63\x6b\x6b\x6b\x77\x63\x0"
"\x63\x36\x1c\x8\x1c\x36\x63\x0\x41\x63\x36\x1c\xc\xc\x1e\x0\x7f\x61\x30\x18\xc\x46\x7f\x0\x70\x30\x30\x30\x30\x30\x30\x70\x3\x6\xc\x18\x30\x60\xc0\x80\xe\xc\xc\xc\xc\xc\xc\xe\x8\x1c\x36\x63\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\xff"
"\x18\x18\x30\x0\x0\x0\x0\x0\x0\x0\x3e\x60\x7e\x63\x7e\x0\x3\x3\x3f\x63\x63\x63\x3f\x0\x0\x0\x3e\x63\x3\x63\x3e\x0\x60\x60\x7e\x63\x63\x63\x7e\x0\x0\x0\x3e\x63\x7f\x3\x3e\x0\x3c\x66\x6\x3f\x6\x6\x7\x0\x0\x0\xbe\x63\x63\x7e\x60\x3e"
"\x3\x3\x3f\x63\x63\x63\x63\x0\x18\x0\x1c\x18\x18\x18\x3c\x0\x30\x0\x38\x30\x30\x30\x33\x1e\x3\x3\x63\x1b\xf\x1b\x63\x0\x1c\x18\x18\x18\x18\x18\x38\x0\x0\x0\x63\x7f\x6b\x6b\x63\x0\x0\x0\x3f\x61\x63\x63\x63\x0\x0\x0\x3e\x63\x63\x63\x3e\x0"
"\x0\x0\x3f\x61\x63\x3f\x3\x3\x0\x0\x7e\x43\x63\x7e\x60\xe0\x0\x0\x7b\x6e\x66\x6\x6\x0\x0\x0\x7e\x3\x3e\x60\x3f\x0\x18\x18\x7e\x18\x18\x18\x78\x0\x0\x0\x63\x63\x63\x63\x3e\x0\x0\x0\x63\x63\x63\x36\x1c\x8\x0\x0\x63\x6b\x6b\x7f\x63\x0"
"\x0\x0\x63\x36\x1c\x36\x63\x0\x0\x0\x63\x63\x36\x1c\xc\x7\x0\x0\x7f\x30\x8\x46\x7f\x0\x70\x18\x18\xe\x18\x18\x70\x0\x18\x18\x18\x0\x18\x18\x18\x0\x7\xc\xc\x38\xc\xc\x7\x0\xe\xd9\x70\x0\x0\x0\x0\x0\x0\x0\x8\x14\x22\x7f\x0\x0"
"\xff\x1\x1\x1\x1\x1\x1\x1\xff\x0\x0\x0\x0\x0\x0\x0\xff\x80\x80\x80\x80\x80\x80\x80\x1\x1\x1\x1\x1\x1\x1\x1\x80\x80\x80\x80\x80\x80\x80\x80\x1\x1\x1\x1\x1\x1\x1\xff\x0\x0\x0\x0\x0\x0\x0\xff\x80\x80\x80\x80\x80\x80\x80\xff"
"\x1\x0\x0\x0\x0\x0\x0\x0\x80\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x1\x0\x0\x0\x0\x0\x0\x0\x80\x1\x3\x6\xd\x1a\x35\x6a\xd5\xab\x56\xac\x58\xb0\x60\xc0\x80\xff\xff\x3\x3\x3\x3\x3\x3\xff\xff\x0\x0\x0\x0\x0\x0"
"\xff\xff\xc0\xc0\xc0\xc0\xc0\xc0\x3\x3\x3\x3\x3\x3\x3\x3\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\x3\x3\x3\x3\x3\x3\xff\xff\x0\x0\x0\x0\x0\x0\xff\xff\xc0\xc0\xc0\xc0\xc0\xc0\xff\xff\x3\x3\x0\x0\x0\x0\x0\x0\xc0\xc0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x3\x3\x0\x0\x0\x0\x0\x0\xc0\xc0\x0\x0\x0\x55\x0\x0\x0\x0\x0\x3f\x3f\x3f\x3f\x3f\x3f\x0\x0\x7e\x7e\x7e\x7e\x7e\x7e\x0\x0\xfc\xfc\xfc\xfc\xfc\xfc\x0\x0\xf8\xf8\xf8\xf8\xf8\xf8\x0\x0\xf0\xf0\xf0\xf0\xf0\xf0\x0"
"\x0\xe0\xe0\xe0\xe0\xe0\xe0\x0\x0\xc0\xc0\xc0\xc0\xc0\xc0\x0\x0\x80\x80\x80\x80\x80\x80\x0\x0\x1\x1\x1\x1\x1\x1\x0\x0\x3\x3\x3\x3\x3\x3\x0\x0\x7\x7\x7\x7\x7\x7\x0\x0\xf\xf\xf\xf\xf\xf\x0\x0\x1f\x1f\x1f\x1f\x1f\x1f\x0"
"\x3e\x3e\x3e\x3e\x3e\x3e\x3e\x3e\xff\xff\x0\x0\x0\x8\x1c\x3e\xff\xff\x0\x0\x0\x0\x0\x7f\xff\xff\x0\x0\x8\x1c\x3e\x7f\xff\xff\x0\xc3\xe7\xff\xdb\xc3\x0\x0\x0\x0\x18\x0\x0\x0\x0\x3\x3\x3\x3\x3\x3\x3\x0\x1b\x1b\x1b\x1b\x1b\x1b\x1b"
"\x0\xdb\xdb\xdb\xdb\xdb\xdb\xdb\x0\x6\x6\x6\x6\x6\x6\x6\x0\x36\x36\x36\x36\x36\x36\x36\x0\xb6\xb6\xb6\xb6\xb6\xb6\xb6\x0\x1\x1\x1\x1\x1\x1\x1\x0\xd\xd\xd\xd\xd\xd\xd\x0\x6d\x6d\x6d\x6d\x6d\x6d\x6d\x0\x0\x18\x3c\x3c\x18\x0\x0"
"\x7f\x7f\x7f\x7f\x7f\x7f\x7f\x3e\x7e\x7e\x7e\x7e\x7e\x7e\x3c\x0\x3f\x3f\x3f\x3f\x3f\x3f\xbf\x3f\x7f\x7f\x7f\x7f\x7f\x7f\x7f\x7f\x3c\x3c\x3c\x3c\x3c\x3c\xbc\x3e\x7c\x7c\x7c\x7c\x7c\x7c\x7c\x7e\x18\x18\x18\x1f\x18\x1f\x0\x0\x0\x0\x0\x1f\x18\x18\x18\x18"
"\x18\x18\x18\xf8\x0\x0\x0\x0\x18\x18\x18\xff\x0\x0\x0\x0\x0\x0\x0\xff\x18\x18\x18\x18\x18\x18\x18\xf8\x18\x18\x18\x18\x0\x0\x0\x0\xff\x0\x0\x0\x18\x18\x18\xff\x18\x18\x18\x18\x18\x18\x18\xf8\x18\xf8\x18\x18\x6c\x6c\x6c\xec\x6c\x6c\x6c\x6c"
"\x6c\x6c\x6c\xec\xc\xfc\x0\x0\x0\x0\x0\xfc\xc\xec\x6c\x6c\x6c\x6c\x6c\xef\x0\xff\x0\x0\x0\x0\x0\xff\x0\xef\x6c\x6c\x6c\x6c\x6c\xec\xc\xec\x6c\x6c\x0\x0\x0\xff\x0\xff\x0\x0\x6c\x6c\x6c\xef\x0\xef\x6c\x6c\x18\x18\x18\xff\x0\xff\x0\x0"
"\x6c\x6c\x6c\xff\x0\x0\x0\x0\x0\x0\x0\xff\x0\xff\x18\x18\x0\x0\x0\xff\x6c\x6c\x6c\x6c\x6c\x6c\x6c\xfc\x0\x0\x0\x0\x18\x18\x18\xf8\x18\xf8\x0\x0\x0\x0\x0\xf8\x18\xf8\x18\x18\x0\x0\x0\xfc\x6c\x6c\x6c\x6c\x6c\x6c\x6c\xff\x6c\x6c\x6c\x6c"
"\x18\x18\x18\xff\x18\xff\x18\x18\x18\x18\x18\x1f\x0\x0\x0\x0\x0\x0\x0\xf8\x18\x18\x18\x18\xff\xff\xff\xff\xff\xff\xff\xff\x0\x0\x0\x0\xff\xff\xff\xff\xf\xf\xf\xf\xf\xf\xf\xf\xf0\xf0\xf0\xf0\xf0\xf0\xf0\xf0\xff\xff\xff\xff\x0\x0\x0\x0"
"\x0\x0\xee\x19\x19\xee\x0\x0\x38\x6c\x66\x3f\x63\x63\x3f\x3\x7f\x46\x6\x6\x6\x6\x6\x0\x0\x0\xff\x66\x66\x66\x66\x0\x7f\x46\xc\x18\xc\x46\x7f\x0\x0\x0\xfc\x66\x63\x33\x1e\x0\x0\x0\xcc\xcc\xcc\x7c\xc\xf\x0\x0\xff\x18\x18\x18\x18\x0"
"\x3c\x18\x3c\x66\x66\x3c\x18\x3c\x0\x3e\x63\x7f\x63\x3e\x0\x0\x0\x7e\xc3\xc3\xc3\x66\xe7\x0\x78\x98\x3c\x66\x63\x33\x1e\x0\x0\x0\x66\x99\x99\x66\x0\x0\x0\xc0\x3e\x73\x67\x3e\x3\x0\x0\x7c\x3\x7f\x3\x7c\x0\x0\x0\x0\x0\x0\x0\xdb\xdb\x0"
"\x0\x7e\x0\x7e\x0\x7e\x0\x0\x0\xf8\x8\x8\x8\x8\xf8\x0\x0\xff\x0\x0\x0\x0\xff\x0\x0\x1f\x10\x10\x10\x10\x1f\x0\x0\x0\x0\x8\x0\x0\x0\x0\x0\x0\x0\x2\x1\x0\x0\x0\x20\x30\x28\x24\x22\xa1\x60\x20\x0\x0\x0\x1\x2\x0\x0\x0"
"\x20\x60\xa1\x22\x24\x28\x30\x20\x0\x0\x0\x40\x40\x40\x40\x7f\xff\x81\x81\x81\x81\x80\x80\x80\x0\x0\x0\x20\x20\x11\x11\xe\x38\x44\x44\x82\x82\x0\x0\x0\x0\x0\xfe\x7c\x38\x10\x0\x0\x0\x0\x10\x38\x7c\xfe\x0\x0\x80\xc1\x63\x36\x1c\x8\x0\x0"
),
// Font no. 24
FontEntry("PEANUT", 8, 8, 
"\x0\x0\x0\x0\x0\x0\x0\x0\x7e\x81\xa5\x81\xbd\x99\x81\x7e\x7e\xff\xdb\xff\xc3\xe7\xff\x7e\x36\x7f\x7f\x7f\x3e\x1c\x8\x0\x8\x1c\x3e\x7f\x3e\x1c\x8\x0\x1c\x3e\x1c\x7f\x7f\x49\x8\x3e\x0\x8\x1c\x3e\x7f\x3e\x1c\x3e\x0\x0\x18\x3c\x3c\x18\x0\x0"
"\xff\xff\xe7\xc3\xc3\xe7\xff\xff\x0\x3c\x66\x42\x42\x66\x3c\x0\xff\xc3\x99\xbd\xbd\x99\xc3\xff\xf0\xe0\xf0\xbe\x33\x33\x33\x1e\x3c\x66\x66\x66\x3c\x18\x7e\x18\xfc\xcc\xfc\xc\xc\xe\xf\x7\xfe\xc6\xfe\xc6\xc6\xe6\x67\x3\x99\x5a\x3c\xe7\xe7\x3c\x5a\x99"
"\x1\x7\x1f\x7f\x1f\x7\x1\x0\x40\x70\x7c\x7f\x7c\x70\x40\x0\x18\x3c\x7e\x18\x18\x7e\x3c\x18\x66\x66\x66\x66\x66\x0\x66\x0\xfe\xdb\xdb\xde\xd8\xd8\xd8\x0\x7c\xc6\x1c\x36\x36\x1c\x61\x3f\x0\x0\x0\x0\x7e\x7e\x7e\x0\x18\x3c\x7e\x18\x7e\x3c\x18\xff"
"\x18\x3c\x7e\x18\x18\x18\x18\x0\x18\x18\x18\x18\x7e\x3c\x18\x0\x0\x18\x30\x7f\x30\x18\x0\x0\x0\xc\x6\x7f\x6\xc\x0\x0\x0\x0\x3\x3\x3\x7f\x0\x0\x0\x24\x66\xff\x66\x24\x0\x0\x0\x18\x3c\x7e\xff\xff\x0\x0\x0\xff\xff\x7e\x3c\x18\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x8\x1c\x1c\x8\x8\x0\x8\x0\x48\x24\x0\x0\x0\x0\x0\x0\x22\x7f\x22\x22\x22\x7f\x22\x0\x8\x3c\xa\x1c\x28\x1e\x8\x0\x0\x44\x22\x10\x8\x44\x22\x0\x1c\x22\x14\x6a\x11\x11\x6e\x0\x20\x10\x0\x0\x0\x0\x0\x0"
"\x10\x8\x4\x4\x4\x8\x10\x0\x4\x8\x10\x10\x10\x8\x4\x0\x8\x2a\x1c\x7f\x1c\x2a\x8\x0\x0\x8\x8\x3e\x8\x8\x0\x0\x0\x0\x0\x0\x0\x8\x4\x0\x0\x0\x0\x7e\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x8\x0\x0\x40\x20\x10\x8\x4\x2\x0"
"\x1c\x22\x32\x2a\x26\x22\x1c\x0\xc\x8\x8\x8\x8\x8\x8\x0\x1c\x22\x20\x18\x4\x2\x3e\x0\x1c\x22\x20\x18\x20\x22\x1c\x0\x0\x10\x8\x24\x22\x7e\x20\x0\x3f\x1\x1e\x20\x20\x11\xe\x0\x4\x2\x2\x3a\x46\x42\x3c\x0\x3c\x20\x20\x10\x10\x8\x8\x0"
"\x3c\x12\xa\x3c\x42\x42\x3c\x0\x3c\x42\x62\x5c\x40\x40\x20\x0\x0\x0\x8\x0\x0\x8\x0\x0\x0\x0\x8\x0\x0\x8\x4\x0\x20\x10\x8\x4\x8\x10\x20\x0\x0\x0\x7e\x0\x7e\x0\x0\x0\x4\x8\x10\x20\x10\x8\x4\x0\x3c\x46\x46\x20\x10\x0\x10\x0"
"\x3c\x42\x99\xa5\x59\x2\x7c\x0\x1c\x22\x42\x42\x7e\x42\x42\x0\x1e\x21\x21\x1f\x21\x21\x1f\x0\x3c\x2\x1\x1\x1\x2\x3c\x0\x3f\x41\x41\x41\x41\x41\x3f\x0\x3e\x1\x1\x1f\x1\x1\x3e\x0\x3c\x2\x2\x1e\x2\x2\x2\x0\x1e\x21\x1\x19\x21\x21\x1e\x0"
"\x42\x42\x42\x42\x7e\x42\x42\x0\x1c\x8\x8\x8\x8\x8\x1c\x0\x30\x20\x20\x20\x20\x20\x1c\x0\x2\x22\x12\xa\xe\x12\x22\x0\x2\x2\x2\x2\x2\x2\x3e\x0\x1a\x2e\x2a\x2a\x2a\x2a\x2a\x0\x1a\x26\x22\x22\x22\x22\x22\x0\x1c\x22\x22\x22\x22\x22\x1c\x0"
"\x3c\x42\x42\x3e\x2\x2\x2\x0\x3c\x42\x41\x41\x41\x51\x2e\x40\x3c\x42\x42\x3e\x12\x22\x42\x0\x1c\x22\x4\x8\x10\x22\x1c\x0\x3c\xa\x8\x8\x8\x8\x8\x0\x22\x22\x22\x22\x22\x32\x2c\x0\x22\x22\x22\x22\x22\x14\x8\x0\x2a\x2a\x2a\x2a\x2a\x2a\x1e\x0"
"\x22\x22\x14\x8\x14\x22\x22\x0\x22\x22\x22\x32\x2c\x20\x18\x0\x3e\x20\x10\x8\x4\x2\x3e\x0\xe\x2\x2\x2\x2\x2\xe\x0\x0\x2\x4\x8\x10\x20\x40\x0\x1c\x10\x10\x10\x10\x10\x1c\x0\x8\x1c\x36\x1c\x8\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\xff"
"\x4\x4\x4\x0\x0\x0\x0\x0\x0\x0\x0\x3c\x42\x62\x5c\x0\x2\x2\x2\x3a\x46\x42\x3c\x0\x0\x0\x0\x3c\x2\x2\x3c\x0\x40\x40\x40\x5c\x62\x42\x3c\x0\x0\x0\x1c\x22\x3e\x2\x3c\x0\x0\x1c\x2\x1e\x2\x2\x2\x0\x0\x0\x3c\x42\x62\x5c\x40\x3c"
"\x2\x2\x2\x2\x3a\x46\x42\x0\x0\x0\x8\x0\x8\x8\x8\x0\x0\x0\x20\x0\x20\x20\x20\x18\x2\x2\x2\x12\xa\x16\x22\x0\x8\x8\x8\x8\x8\x8\x8\x0\x0\x0\x0\x6a\x56\x52\x52\x0\x0\x0\x0\x3a\x26\x22\x22\x0\x0\x0\x0\x1c\x22\x22\x1c\x0"
"\x0\x0\x3c\x42\x46\x3a\x2\x2\x0\x0\x3c\x42\x62\x5c\x40\x40\x0\x0\x1a\x26\x2\x2\x2\x0\x0\x0\x18\x24\x8\x12\xc\x0\x0\x0\x8\x38\xc\x8\x8\x0\x0\x0\x0\x42\x42\x62\x5c\x0\x0\x0\x0\x42\x42\x24\x18\x0\x0\x0\x0\x2a\x2a\x2a\x1e\x0"
"\x0\x0\x20\x16\x8\x34\x2\x0\x0\x0\x42\x42\x62\x5c\x40\x3c\x0\x0\x2c\x12\x8\x24\x1a\x0\x60\x10\x10\xc\x10\x10\x60\x0\x8\x8\x8\x8\x8\x8\x8\x8\x6\x8\x8\x30\x8\x8\x6\x0\x26\x19\x0\x0\x0\x0\x0\x0\x0\x8\x1c\x36\x63\x63\x7f\x0"
"\xfc\x2\x1\x1\x1\x1\x1\x1\xff\x0\x0\x0\x0\x0\x0\x0\x3f\x40\x80\x80\x80\x80\x80\x80\x1\x1\x1\x1\x1\x1\x1\x1\x80\x80\x80\x80\x80\x80\x80\x80\x1\x1\x1\x1\x1\x1\x2\xfc\x0\x0\x0\x0\x0\x0\x0\xff\x80\x80\x80\x80\x80\x80\x40\x3f"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x1\x3\x7\xf\x1f\x3f\x7e\xfc\x3f\x7e\xfc\xf8\xf0\xe0\xc0\x80\xc0\xb0\xec\x3c\x1a\xe\x7\x5\xff\x55\xff\x0\x0\x0\x0\x0"
"\x3\xd\x3f\x34\x78\x50\xe0\xa0\x7\x5\x7\x5\x7\x5\x7\x5\xe0\xa0\xe0\xa0\xe0\xa0\xe0\xa0\x7\x5\xe\xa\x3c\xec\x70\xc0\x0\x0\x0\x0\x0\xff\x55\xff\xe0\xa0\x70\x58\x3c\x37\xd\x3\x7\x5\x7\x0\x0\x0\x0\x0\xe0\xa0\xe0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x7\x5\x7\x0\x0\x0\x0\x0\xe0\xa0\xe0\x0\x81\xc3\xe7\xff\x7e\x3c\x18\x0\x1e\x29\x23\x31\x25\x1e\x0\x0\x3c\x52\x46\x62\x4a\x3c\x0\x0\x78\xa4\x8c\xc4\x94\x78\x0\x0\xf0\x48\x18\x88\x28\xf0\x0\x0\xe0\x90\x30\x10\x50\xe0\x0"
"\x0\xc0\x20\x60\x20\xa0\xc0\x0\x0\x80\x40\xc0\x40\x40\x80\x0\x0\x0\x80\x80\x80\x80\x0\x0\x0\x0\x1\x1\x1\x1\x0\x0\x0\x1\x2\x2\x3\x2\x1\x0\x0\x3\x5\x4\x6\x4\x3\x0\x0\x7\xa\x8\xc\x9\x7\x0\x0\xf\x14\x11\x18\x12\xf\x0"
"\x78\x3c\x1e\x3c\x78\x3c\x1e\x3c\xff\xff\x0\x18\x3c\x7e\xff\x0\xff\xff\x0\x0\x0\x0\x18\x18\xff\xff\x0\x18\x3c\x7e\xff\x18\xff\xff\x0\x42\x66\x5a\x42\x42\x0\x0\x0\x0\x10\x0\x0\x0\x0\x3\x3\x3\x3\x3\x3\x3\x0\x1b\x1b\x1b\x1b\x1b\x1b\x1b"
"\x0\xdb\xdb\xdb\xdb\xdb\xdb\xdb\x0\x6\x6\x6\x6\x6\x6\x6\x0\x36\x36\x36\x36\x36\x36\x36\x0\xb6\xb6\xb6\xb6\xb6\xb6\xb6\x0\x1\x1\x1\x1\x1\x1\x1\x0\xd\xd\xd\xd\xd\xd\xd\x0\x6d\x6d\x6d\x6d\x6d\x6d\x6d\x0\x0\x18\x3c\x3c\x18\x0\x0"
"\x0\x0\x0\x66\x0\x0\x0\x0\x0\x78\x84\x2\x0\x0\x0\x0\x0\x0\x0\x41\x22\x1c\x0\x0\x0\x7c\x44\x44\x44\x44\xc6\x0\x0\x7c\x44\x44\x44\x44\xc7\x0\x0\xc\x34\xc4\x4\x4\x4\x0\x0\x20\x20\x20\x23\x2c\x30\x0\x0\x60\x20\x20\x20\x20\x60\x0"
"\x0\x3\x2\x2\x2\x2\x3\x0\x0\x0\x0\x18\x18\x0\x0\x0\x0\x0\x18\x3c\x3c\x18\x0\x0\x0\x0\x18\x3c\x3c\x18\x0\x0\x0\x0\x0\x0\xff\x0\x0\x0\x0\x0\x3c\x3c\x3c\x3c\x0\x0\x0\x18\x3c\x7e\x7e\x3c\x18\x0\x0\x18\x3c\x7e\x7e\x3c\x18\x0"
"\x0\x3c\x7e\x7e\x7e\x7e\x3c\x0\x0\x3c\x7e\x7e\x7e\x7e\x3c\x0\x6c\x6c\xef\x0\xff\x0\x0\x0\x0\x0\xff\x0\xef\x6c\x6c\x6c\x6c\x6c\xec\xc\xec\x6c\x6c\x6c\x0\x0\xff\x81\xff\x0\x0\x0\x6c\x6c\xef\x0\xef\x6c\x6c\x6c\x18\x18\xff\x0\xff\x0\x0\x0"
"\x6c\x6c\x6c\x6c\xff\x0\x0\x0\x0\x0\xff\x0\xff\x18\x18\x18\x0\x0\x0\x0\xff\x6c\x6c\x6c\x6c\x6c\x6c\x6c\xfc\x0\x0\x0\x18\x18\xf8\x18\xf8\x0\x0\x0\x0\x0\xf8\x18\xf8\x18\x18\x18\x0\x0\x0\x0\xfc\x6c\x6c\x6c\x6c\x6c\x6c\x6c\xff\x6c\x6c\x6c"
"\x18\x18\xff\x18\xff\x18\x18\x18\x18\x18\x18\x18\x1f\x0\x0\x0\x0\x0\x0\x0\xf8\x18\x18\x18\xff\xff\xff\xff\xff\xff\xff\xff\x0\x0\x0\x0\xff\xff\xff\xff\xf\xf\xf\xf\xf\xf\xf\xf\xf0\xf0\xf0\xf0\xf0\xf0\xf0\xf0\xff\xff\xff\xff\x0\x0\x0\x0"
"\x0\x0\x6e\x3b\x13\x3b\x6e\x0\x0\x1e\x33\x1f\x33\x1f\x3\x3\x0\x3f\x33\x3\x3\x3\x3\x0\x0\x0\x7f\x36\x36\x36\x36\x0\x3f\x33\x6\xc\x6\x33\x3f\x0\x0\x0\x7e\x1b\x1b\x1b\xe\x0\x0\x66\x66\x66\x66\x3e\x6\x3\x0\x6e\x3b\x18\x18\x18\x18\x0"
"\x3f\xc\x1e\x33\x33\x1e\xc\x3f\x1c\x36\x63\x7f\x63\x36\x1c\x0\x1c\x36\x63\x63\x36\x36\x77\x0\x38\xc\x18\x3e\x33\x33\x1e\x0\x0\x0\x7e\xdb\xdb\x7e\x0\x0\x60\x30\x7e\xdb\xdb\x7e\x6\x3\x1c\x6\x3\x1f\x3\x6\x1c\x0\x0\x0\x0\x0\x0\xdb\xdb\x0"
"\x0\x7e\x0\x7e\x0\x7e\x0\x0\x0\xf8\x8\x8\x8\x8\xf8\x0\x0\xff\x0\x0\x0\x0\xff\x0\x0\x1f\x10\x10\x10\x10\x1f\x0\x0\x0\x0\x8\x0\x0\x0\x0\x0\x0\x0\x2\x1\x0\x0\x0\x20\x30\x28\x24\x22\xa1\x60\x20\x0\x0\x0\x1\x2\x0\x0\x0"
"\x20\x60\xa1\x22\x24\x28\x30\x20\x0\x0\x0\x40\x40\x40\x40\x7f\xff\x81\x81\x81\x81\x80\x80\x80\x0\x0\x0\x20\x20\x11\x11\xe\x38\x44\x44\x82\x82\x0\x0\x0\x0\x0\xfe\x7c\x38\x10\x0\x0\x0\x0\x10\x38\x7c\xfe\x0\x0\x80\xc1\x63\x36\x1c\x8\x0\x0"
),
// Font no. 25
FontEntry("PERISOFT", 8, 8, 
"\x0\x0\x0\x0\x0\x0\x0\x0\x7e\x81\xa5\x81\xbd\x99\x81\x7e\x7e\xff\xdb\xff\xff\xc3\xe7\x7e\x0\x77\x7f\x7f\x3e\x1c\x8\x0\x8\x1c\x3e\x7f\x3e\x1c\x8\x0\x18\x3c\x18\xff\xff\x52\x18\x0\x8\x1c\x3e\x7f\x7f\x49\x1c\x0\x0\x0\x18\x3c\x18\x0\x0\x0"
"\xff\xff\xe7\xc3\xe7\xff\xff\xff\x0\x3c\x42\x81\x81\x42\x3c\x0\xff\xc3\xbd\x7e\x7e\xbd\xc3\xff\xf8\xe0\xb0\x3e\x63\x63\x3e\x0\x0\x7e\xc3\xc3\x7e\x18\x7e\x18\x20\x60\xe0\x20\x20\x3f\x1f\x0\x30\x50\xb0\xd0\x9f\x8f\xf0\xf0\x81\xc2\xbc\xe4\xa4\xfc\xea\xff"
"\x0\x0\x6\x1e\x7e\x1e\x6\x0\x0\x0\x60\x78\x7e\x78\x60\x0\x18\x7e\x18\x18\x18\x18\x7e\x18\x66\x66\x66\x66\x66\x0\x66\x0\xff\x6d\x6e\x6c\x6c\x6c\x6c\x0\x7e\x81\x3e\x42\x42\x7c\x81\x7e\x0\x0\x0\x7e\x7e\x0\x0\x0\x18\x7e\x18\x18\x7e\x18\x0\xff"
"\x18\x7e\x18\x18\x18\x18\x18\x0\x18\x18\x18\x18\x18\x7e\x18\x0\x0\x20\x60\xff\x60\x20\x0\x0\x0\x4\x6\xff\x6\x4\x0\x0\x0\x0\x0\x3\x3\x3\xff\x0\x0\x24\x66\xff\x66\x24\x0\x0\x0\x8\x8\x14\x36\x6b\x0\x7f\x0\x0\x0\x7f\x3e\x1c\x8\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x8\xc\xc\xc\x4\x0\xc\x0\x66\x44\x0\x0\x0\x0\x0\x0\x12\x36\x7f\x36\x7f\x36\x12\x0\x3e\x6b\xb\xb\x3e\x69\x3e\x8\xce\x69\x35\x1a\x6c\x56\x33\x0\x1c\x26\xa6\x7c\x3e\x23\x5e\x80\x10\x18\xc\x0\x0\x0\x0\x0"
"\xe0\x30\x18\x18\x18\x30\x60\xc0\x3\x6\xc\x18\x18\x18\xc\x7\x9\x2a\x1c\x7f\x1c\x2a\x48\x0\x8\x18\x18\x18\x7e\x18\x10\x0\x0\x0\x0\x0\x0\x10\x18\xe\x0\x0\x0\x7e\x1\x0\x0\x0\x0\x0\x0\x0\x0\x18\x38\x0\x80\xc0\x60\x30\x18\xc\x6\x3"
"\x3c\x66\x76\x56\x4e\x2e\x1c\x0\xc\x18\x18\x18\x18\x18\x3c\x0\x3e\x63\x40\x60\x3e\x7\x7f\x0\x3e\x63\x60\x60\x38\x63\x3e\x0\x30\x58\x4c\x46\x43\x7e\x40\x0\x3f\x63\x3\x3\x3e\x40\x3f\x0\x3c\x66\x43\x3\x3f\x43\x3e\x0\x3f\x60\x30\x18\xc\x6\x3\x0"
"\x3e\x43\x43\x43\x3e\x43\x3e\x0\x3e\x43\x43\x43\x7e\x41\x3e\x0\x0\x8\xc\x0\x0\xc\x8\x0\x0\x8\x8\x0\x8\xc\x4\x0\x0\x30\x18\xc\x6\xc\x18\x0\x0\x0\x40\x7e\x0\x7e\x2\x0\x0\x3\x6\xc\x18\xc\x6\x0\x3e\x63\x60\x60\x3c\x0\xc\x8"
"\x1c\x22\x49\x55\x35\x9\x22\x1c\xe\x1b\x23\x43\x43\x7f\x43\x0\x3e\x43\x43\x23\x3f\x43\x3e\x0\x3e\x43\x43\x3\x43\x43\x3e\x0\x3e\x43\x43\x43\x43\x23\x1f\x0\x3e\x43\x3\x1b\x7\x43\x3e\x0\x3e\x43\x3\x1b\x7\x3\x2\x0\x3e\x43\x23\x3\x3b\x43\x3e\x0"
"\x42\x43\x43\x63\x7f\x43\x42\x0\x7e\x18\x10\x10\x10\x18\x7e\x0\x18\x30\x20\x20\x21\x33\x1e\x0\x62\x33\x1b\xf\xf\x1b\x32\x0\x6\x3\x3\x3\x3\x43\x3e\x0\x22\x63\x63\x77\x7f\x6b\x22\x0\x42\x43\x43\x47\x4f\x5b\x72\x0\x3e\x43\x43\x43\x43\x43\x3e\x0"
"\x3e\x43\x43\x43\x3f\x3\x6\x0\x3e\x43\x43\x43\x43\x53\x5e\x80\x3e\x43\x43\x23\x1f\x23\x42\x0\x3e\x43\x3\xe\x38\x43\x3e\x0\x7f\x1c\x18\x18\x18\x18\x8\x0\x42\x43\x43\x43\x43\x43\x3e\x0\x42\x43\x43\x43\x23\x13\xe\x0\x42\x43\x43\x43\x5b\x6f\x46\x0"
"\x81\x43\x23\x16\x1c\x3e\x63\x0\x43\x43\x26\x2c\x18\x8\x8\x0\x3e\x61\x30\x18\x7f\x6\x7f\x0\x70\x18\x18\x18\x18\x18\x18\x70\x3\x6\xc\x18\x30\x60\xc0\x80\x7\xc\xc\xc\xc\xc\xc\x7\x8\x1c\x26\x43\x81\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\xff"
"\x8\xc\x18\x30\x0\x0\x0\x0\x0\x0\x1e\x20\x3e\x63\xde\x0\x2\x3\x3\x3b\x47\x43\x3e\x0\x0\x0\x1e\x23\x3\x43\x3e\x0\x20\x40\x5c\x66\x63\x43\x7e\x0\x0\x0\x1e\x23\x1f\x3\x3e\x0\x3c\x46\x46\x6\x6\x1f\x6\x0\x0\x0\x3e\x43\x63\x5e\x40\x3e"
"\x2\x3\x3b\x6f\x47\x43\x42\x0\x18\x10\x4\x18\x18\x18\x38\x0\x40\x60\x0\x60\x20\x21\x31\x1e\x2\x23\x13\xb\x7\xb\x12\x0\xc\x18\x18\x18\x18\x18\x30\x0\x0\x0\x22\x77\x6b\x6b\x22\x0\x0\x0\x3e\x43\x43\x43\x43\x0\x0\x0\x3e\x43\x43\x43\x3e\x0"
"\x0\x0\x1e\x23\x43\x3f\x3\x2\x0\x0\x3c\x46\x43\x7e\x40\x80\x0\x0\x38\x4f\x46\x6\x6\x0\x0\x0\x3e\x3\x1c\x30\x1f\x0\x8\xc\xc\xc\x7f\xc\x78\x0\x0\x0\x43\x43\x43\x46\xbc\x0\x0\x0\x42\x43\x43\x26\x1c\x0\x0\x0\x22\x6b\x6b\x77\x22\x0"
"\x0\x0\x23\x16\xc\x16\x23\x0\x0\x0\x43\x43\x43\x7e\x40\x3f\x0\x0\x7e\x30\x8\x6\x7f\x0\x78\xc\x18\xe\x18\xc\x78\x0\x8\x18\x18\x18\x18\x18\x18\x10\x7\xc\x6\x3c\x6\xc\x7\x0\x6\x8d\x78\x0\x0\x0\x0\x0\x0\x0\x8\x14\x22\x7f\x0\x0"
"\xfe\xff\x3\xf3\xb\xb\xb\xb\xff\xff\x0\xff\x0\x0\x0\x0\x7f\xff\xc0\xcf\xd0\xd0\xd0\xd0\xb\xb\xb\xb\xb\xb\xb\xb\xd0\xd0\xd0\xd0\xd0\xd0\xd0\xd0\xb\xb\xb\xb\xf3\x3\xff\xfe\x0\x0\x0\x0\xff\x0\xff\xff\xd0\xd0\xd0\xd0\xcf\xc0\xff\x7f"
"\xb\xd\x6\x3\x0\x0\x0\x0\xd0\xb0\x60\xc0\x0\x0\x0\x0\x0\x0\x0\x0\x3\x6\xd\xb\x0\x0\x0\x0\xc0\x60\xb0\xd0\xb\xb\x13\x33\xc6\xe\xfc\xf0\xf\x3f\x70\x60\xc1\xc6\xc4\xc8\xfe\xff\x47\xa3\xd3\x6b\x37\x1b\xff\xff\x55\xaa\xff\x0\x0\x0"
"\xff\xff\xd5\xea\xdf\xe8\xd8\xe8\x1b\x17\x1b\x17\x1b\x17\x1b\x17\xe8\xd8\xe8\xd8\xe8\xd8\xe8\xd8\x17\x1b\x17\xfb\x57\xab\xff\xff\x0\x0\x0\xff\x55\xaa\xff\xff\xd8\xe8\xd8\xef\xd5\xea\xff\xff\x17\x1b\x15\x1a\xf\x0\x0\x0\xd8\xe8\x58\xa8\xf0\x0\x0\x0"
"\x0\x0\x0\xf\x15\x1a\x17\x1b\x0\x0\x0\xf0\x58\xa8\xd8\xe8\x0\x0\x0\x55\x0\xaa\x0\x0\x0\x1c\x26\x26\x26\x3e\x7f\x2a\x0\x0\x1c\x26\x26\x26\x3e\x7f\x0\x0\x1c\x26\xe6\xa6\x3e\x7f\x0\x0\x1c\x26\xe6\xa6\x3e\x7f\x0\x1c\x26\xa6\xe6\x3e\x7f\x0"
"\xe0\x30\x30\x30\xf0\xf8\x0\x0\x80\xc0\xc0\xc0\xc0\xe0\x0\x0\x0\x0\x80\x80\x80\x80\xc0\x0\x0\x0\x0\x0\x1f\x1d\x0\x0\x0\x0\x0\x1\x1f\x3c\x10\x38\x0\x1\x5\xf\x19\x3b\x10\x38\x3\x4\x4\x1c\x37\x2f\x70\x38\x0\x7\x9\x9\x9\x1f\x3f\x38"
"\x18\x2c\x26\x1c\x38\x64\x3c\x18\xff\xff\x0\x0\x8\x8\x14\x6b\xff\xff\x0\x0\x0\x0\x0\x7f\xff\xff\x0\x8\x8\x14\x2a\x5d\xff\x7e\x0\x42\xe7\xff\xdb\x42\x0\x0\x0\x8\x18\x0\x0\x0\x0\x3\x5\x5\x5\x5\x3\x0\x0\x7\x1d\x29\x29\x1d\x7\x0"
"\x0\x0\xf\xf9\xc9\x3d\xf\x0\x0\x0\x6\x5\x5\x6\x0\x0\x0\x20\x3e\x33\x27\x3e\x20\x0\x0\xe0\xfe\x9b\x93\xde\xf0\x0\x0\xf\x1a\x12\x12\x12\x1b\xf\x0\x1f\x3a\x52\x52\x52\x3b\x1f\x0\x7f\xda\x92\x92\xd2\xfb\x1f\x0\x0\x18\x3c\x3c\x18\x0\x0"
"\x0\x0\x0\x1f\x18\x1f\x18\x18\x6c\x6c\x6c\x6f\x60\x6f\x6c\x6c\x6c\x6c\x6c\x6c\x6c\x6c\x6c\x6c\x0\x0\x0\x7f\x60\x6f\x6c\x6c\x6c\x6c\x6c\x6f\x60\x7f\x0\x0\x6c\x6c\x6c\x7f\x0\x0\x0\x0\x18\x18\x18\x1f\x18\x1f\x0\x0\x0\x0\x0\x1f\x18\x18\x18\x18"
"\x18\x18\x18\xf8\x0\x0\x0\x0\x18\x18\x18\xff\x0\x0\x0\x0\x0\x0\x0\xff\x18\x18\x18\x18\x18\x18\x18\xf8\x18\x18\x18\x18\x0\x0\x0\x0\xff\x0\x0\x0\x18\x18\x18\xff\x18\x18\x18\x18\x18\x18\x18\xf8\x18\xf8\x18\x18\x6c\x6c\x6c\xec\x6c\x6c\x6c\x6c"
"\x6c\x6c\x6c\xec\xc\xfc\x0\x0\x0\x0\x0\xfc\xc\xec\x6c\x6c\x6c\x6c\x6c\xef\x0\xff\x0\x0\x0\x0\x0\xff\x0\xef\x6c\x6c\x6c\x6c\x6c\xec\xc\xec\x6c\x6c\x0\x0\x0\xff\x0\xff\x0\x0\x6c\x6c\x6c\xef\x0\xef\x6c\x6c\x18\x18\x18\xff\x0\xff\x0\x0"
"\x6c\x6c\x6c\xff\x0\x0\x0\x0\x0\x0\x0\xff\x0\xff\x18\x18\x0\x0\x0\xff\x6c\x6c\x6c\x6c\x6c\x6c\x6c\xfc\x0\x0\x0\x0\x18\x18\x18\xf8\x18\xf8\x0\x0\x0\x0\x0\xf8\x18\xf8\x18\x18\x0\x0\x0\xfc\x6c\x6c\x6c\x6c\x6c\x6c\x6c\xff\x6c\x6c\x6c\x6c"
"\x18\x18\x18\xff\x18\xff\x18\x18\x18\x18\x18\x1f\x0\x0\x0\x0\x0\x0\x0\xf8\x18\x18\x18\x18\xff\xff\xff\xff\xff\xff\xff\xff\x0\x0\x0\x0\xff\xff\xff\xff\xf\xf\xf\xf\xf\xf\xf\xf\xf0\xf0\xf0\xf0\xf0\xf0\xf0\xf0\xff\xff\xff\xff\x0\x0\x0\x0"
"\x0\x0\xee\x19\x19\xee\x0\x0\x38\x6c\x66\x3f\x63\x63\x3f\x3\x7f\x46\x6\x6\x6\x6\x6\x0\x0\x0\xff\x66\x66\x66\x66\x0\x7f\x46\xc\x18\xc\x46\x7f\x0\x0\x0\xfc\x66\x63\x33\x1e\x0\x0\x0\xcc\xcc\xcc\x7c\xc\xf\x0\x0\xff\x18\x18\x18\x18\x0"
"\x3c\x18\x3c\x66\x66\x3c\x18\x3c\x0\x3e\x63\x7f\x63\x3e\x0\x80\xc0\x20\xd0\xe8\xf4\x1a\x8d\xe6\xaa\x83\x7d\x4d\x75\x4d\x7a\x85\xaa\xff\xff\x9d\xad\xbb\xd9\xff\xaa\xff\x7f\xdd\xea\xab\x5d\xff\xaa\xcc\x77\xcc\xff\xe0\xdb\x7b\x0\x0\x0\x0\x0\xdb\xdb\x0"
"\x0\x7e\x0\x7e\x0\x7e\x0\x0\x0\xf8\x8\x8\x8\x8\xf8\x0\x0\xff\x0\x0\x0\x0\xff\x0\x0\x1f\x10\x10\x10\x10\x1f\x0\x0\x0\x0\x8\x0\x0\x0\x0\x0\x0\x0\x2\x1\x0\x0\x0\x20\x30\x28\x24\x22\xa1\x60\x20\x0\x0\x0\x1\x2\x0\x0\x0"
"\x20\x60\xa1\x22\x24\x28\x30\x20\x0\x0\x0\x40\x40\x40\x40\x7f\xff\x81\x81\x81\x81\x80\x80\x80\x0\x0\x0\x20\x20\x11\x11\xe\x38\x44\x44\x82\x82\x0\x0\x0\x0\x0\xfe\x7c\x38\x10\x0\x0\x0\x0\x10\x38\x7c\xfe\x0\x0\x80\xc1\x63\x36\x1c\x8\x0\x0"
),
// Font no. 26
FontEntry("REZ-ASCII", 8, 8, 
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x18\x18\x18\x18\x0\x18\x18\x0\x0\x6c\x6c\x6c\x0\x0\x0\x0\x0\x24\x7e\x24\x24\x7e\x24\x0\x18\x7c\xe\x3c\x70\x3e\x18\x0\x4e\x6a\x3e\x18\x7c\x56\x72\x0\x3c\x66\x66\x3c\x1e\x36\x6c\x0\x18\x18\xc\x0\x0\x0\x0\x0"
"\x60\x30\x18\x18\x18\x30\x60\x0\x6\xc\x18\x18\x18\xc\x6\x0\x0\x10\x54\x38\x38\x54\x10\x0\x0\x0\x18\x18\x7e\x18\x18\x0\x0\x0\x0\x0\x0\x18\x18\xc\x0\x0\x0\x3c\x3c\x0\x0\x0\x0\x0\x0\x0\x0\x18\x18\x0\x40\x60\x30\x18\xc\x6\x2\x0"
"\x3c\x66\x76\x7e\x6e\x66\x3c\x0\x18\x1c\x18\x18\x18\x18\x3c\x0\x3c\x66\x66\x30\x18\xc\x7e\x0\x3c\x66\x66\x30\x66\x66\x3c\x0\x6\x6\x66\x66\x7c\x60\x60\x0\x7e\x66\x6\x3e\x60\x66\x3c\x0\x3c\x66\x6\x3e\x66\x66\x3c\x0\x7e\x66\x60\x30\x18\xc\xc\x0"
"\x3c\x66\x66\x3c\x66\x66\x3c\x0\x3c\x66\x66\x7c\x60\x66\x3c\x0\x0\x0\x18\x18\x0\x18\x18\x0\x0\x0\x18\x18\x0\x18\x18\xc\x20\x30\x18\xc\x18\x30\x20\x0\x0\x0\x3c\x3c\x0\x3c\x3c\x0\x8\x18\x30\x60\x30\x18\x8\x0\x3c\x66\x66\x30\x18\x0\x18\x0"
"\x78\x84\xb2\xaa\xaa\x72\x4\xf8\x3c\x66\x66\x7e\x66\x66\x66\x0\x3e\x66\x66\x3e\x66\x66\x3e\x0\x3c\x66\x66\x6\x66\x66\x3c\x0\x3e\x66\x66\x66\x66\x66\x3e\x0\x7e\x66\x6\xe\x6\x66\x7e\x0\x7e\x66\x6\xe\x6\x6\x6\x0\x3c\x66\x6\x76\x66\x66\x3c\x0"
"\x66\x66\x66\x7e\x66\x66\x66\x0\x3c\x18\x18\x18\x18\x18\x3c\x0\x78\x30\x30\x30\x36\x36\x1c\x0\x66\x66\x66\x3e\x66\x66\x66\x0\x6\x6\x6\x6\x6\x6\x7e\x0\x42\x66\x7e\x66\x66\x66\x66\x0\x62\x66\x6e\x7e\x76\x66\x46\x0\x3c\x66\x66\x66\x66\x66\x3c\x0"
"\x3e\x66\x66\x3e\x6\x6\x6\x0\x3c\x66\x66\x66\x66\x76\x3c\x60\x3e\x66\x66\x3e\x66\x66\x66\x0\x3c\x66\x6\x3c\x60\x66\x3c\x0\x3e\x60\x60\x60\x60\x60\x60\x0\x66\x66\x66\x66\x66\x66\x3c\x0\x66\x66\x66\x66\x66\x6c\x38\x0\x66\x66\x66\x66\x7e\x66\x42\x0"
"\x66\x66\x66\x3c\x66\x66\x66\x0\x66\x66\x66\x3c\x18\x18\x18\x0\x7e\x66\x30\x18\xc\x66\x7e\x0\x78\x18\x18\x18\x18\x18\x78\x0\x2\x6\xc\x18\x30\x60\x40\x0\x1e\x18\x18\x18\x18\x18\x1e\x0\x10\x38\x6c\x44\x0\x0\x0\x0\x0\x0\x0\x0\x0\x7e\x7e\x0"
"\x0\x18\x18\x30\x0\x0\x0\x0\x0\x0\x3e\x60\x7e\x66\x7e\x0\x6\x6\x3e\x66\x66\x66\x3e\x0\x0\x0\x3c\x66\x6\x66\x3c\x0\x60\x60\x7c\x66\x66\x66\x7c\x0\x0\x0\x3c\x66\x7e\x6\x7c\x0\x3c\x66\x66\x6\xe\x6\x6\x0\x0\x0\x7c\x66\x66\x7c\x60\x3e"
"\x6\x6\x3e\x66\x66\x66\x66\x0\x18\x0\x18\x18\x18\x18\x18\x0\x60\x0\x60\x60\x60\x66\x66\x3c\x6\x6\x66\x66\x3e\x66\x66\x0\x18\x18\x18\x18\x18\x18\x18\x0\x0\x0\x66\x7e\x66\x66\x66\x0\x0\x0\x3e\x66\x66\x66\x66\x0\x0\x0\x3c\x66\x66\x66\x3c\x0"
"\x0\x0\x3e\x66\x66\x66\x3e\x6\x0\x0\x7c\x66\x66\x66\x7c\x60\x0\x0\x3e\x66\x66\x6\x6\x0\x0\x0\x7c\x6\x7e\x60\x3e\x0\xc\xc\x3c\xc\xc\x6c\x78\x0\x0\x0\x66\x66\x66\x66\x3c\x0\x0\x0\x66\x66\x66\x6c\x38\x0\x0\x0\x66\x66\x66\x7e\x66\x0"
"\x0\x0\x66\x66\x3c\x66\x66\x0\x0\x0\x66\x66\x66\x7c\x60\x3e\x0\x0\x7e\x30\x18\xc\x7e\x0\x70\x18\x18\xc\x18\x18\x70\x0\x18\x18\x18\x0\x18\x18\x18\x0\xe\x18\x18\x30\x18\x18\xe\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\xff\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\xdb\xdb\x0"
"\x0\x7e\x0\x7e\x0\x7e\x0\x0\x0\xf8\x8\x8\x8\x8\xf8\x0\x0\xff\x0\x0\x0\x0\xff\x0\x0\x1f\x10\x10\x10\x10\x1f\x0\x0\x0\x0\x8\x0\x0\x0\x0\x0\x0\x0\x2\x1\x0\x0\x0\x20\x30\x28\x24\x22\xa1\x60\x20\x0\x0\x0\x1\x2\x0\x0\x0"
"\x20\x60\xa1\x22\x24\x28\x30\x20\x0\x0\x0\x40\x40\x40\x40\x7f\xff\x81\x81\x81\x81\x80\x80\x80\x0\x0\x0\x20\x20\x11\x11\xe\x38\x44\x44\x82\x82\x0\x0\x0\x0\x0\xfe\x7c\x38\x10\x0\x0\x0\x0\x10\x38\x7c\xfe\x0\x0\x80\xc1\x63\x36\x1c\x8\x0\x0"
),
// Font no. 27
FontEntry("SCRIPT", 8, 8, 
"\x0\x0\x0\x0\x0\x0\x0\x0\x7e\x81\xa5\x81\xbd\x99\x81\x7e\x7e\xff\xdb\xff\xc3\xe7\xff\x7e\x36\x7f\x7f\x7f\x3e\x1c\x8\x0\x8\x1c\x3e\x7f\x3e\x1c\x8\x0\x1c\x3e\x1c\x7f\x7f\x49\x8\x3e\x0\x8\x1c\x3e\x7f\x3e\x1c\x3e\x0\x0\x18\x3c\x3c\x18\x0\x0"
"\xff\xff\xe7\xc3\xc3\xe7\xff\xff\x0\x3c\x66\x42\x42\x66\x3c\x0\xff\xc3\x99\xbd\xbd\x99\xc3\xff\xf0\xe0\xf0\xbe\x33\x33\x33\x1e\x3c\x66\x66\x66\x3c\x18\x7e\x18\xfc\xcc\xfc\xc\xc\xe\xf\x7\xfe\xc6\xfe\xc6\xc6\xe6\x67\x3\x99\x5a\x3c\xe7\xe7\x3c\x5a\x99"
"\x1\x7\x1f\x7f\x1f\x7\x1\x0\x40\x70\x7c\x7f\x7c\x70\x40\x0\x18\x3c\x7e\x18\x18\x7e\x3c\x18\x66\x66\x66\x66\x66\x0\x66\x0\xfe\xdb\xdb\xde\xd8\xd8\xd8\x0\x7c\xc6\x1c\x36\x36\x1c\x61\x3f\x0\x0\x0\x0\x7e\x7e\x7e\x0\x18\x3c\x7e\x18\x7e\x3c\x18\xff"
"\x18\x3c\x7e\x18\x18\x18\x18\x0\x18\x18\x18\x18\x7e\x3c\x18\x0\x0\x18\x30\x7f\x30\x18\x0\x0\x0\xc\x6\x7f\x6\xc\x0\x0\x0\x0\x3\x3\x3\x7f\x0\x0\x0\x24\x66\xff\x66\x24\x0\x0\x0\x18\x3c\x7e\xff\xff\x0\x0\x0\xff\xff\x7e\x3c\x18\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x8\x8\x8\x8\x8\x0\x8\x0\x14\x14\x14\x0\x0\x0\x0\x0\x0\x14\x3e\x14\x3e\x14\x0\x0\x8\x3c\xa\x1c\x28\x1e\x8\x0\x0\x46\x26\x10\x8\x64\x62\x0\xc\x12\xc\x4c\x52\x22\x5c\x0\x8\x8\x4\x0\x0\x0\x0\x0"
"\x10\x8\x8\x8\x8\x8\x10\x0\x8\x10\x10\x10\x10\x10\x8\x0\x0\x2a\x1c\x8\x1c\x2a\x0\x0\x0\x8\x8\x3e\x8\x8\x0\x0\x0\x0\x0\x0\x0\x8\x8\x4\x0\x0\x0\x7e\x0\x0\x0\x0\x0\x0\x0\x0\x0\x18\x18\x0\x40\x20\x10\x8\x4\x2\x1\x0"
"\x3c\x42\x42\x5a\x42\x42\x3c\x0\x10\x18\x10\x10\x10\x10\x38\x0\x3c\x42\x40\x38\x4\x2\x7e\x0\x3c\x42\x40\x20\x40\x42\x3c\x0\x20\x30\x28\x24\x7e\x20\x20\x0\x7e\x2\x3e\x40\x40\x42\x3c\x0\x38\x44\x2\x3a\x46\x42\x3c\x0\x7e\x40\x20\x10\x10\x10\x10\x0"
"\x3c\x42\x42\x3c\x42\x42\x3c\x0\x3c\x42\x42\x7c\x40\x42\x3c\x0\x0\x0\x18\x0\x0\x18\x0\x0\x0\x8\x8\x0\x0\x8\x8\x4\x20\x10\x8\x4\x8\x10\x20\x0\x0\x0\x7e\x0\x7e\x0\x0\x0\x4\x8\x10\x20\x10\x8\x4\x0\x3c\x42\x20\x10\x10\x0\x10\x0"
"\x3c\x42\x5a\x5a\x32\x2\x7c\x0\x20\x30\x30\x28\xbc\x62\x31\x0\x3e\x44\x46\x3d\xc2\x62\x3f\x0\x38\x44\x6\x3\x82\x42\x3c\x0\x1e\x24\x46\x45\xc2\x62\x3f\x0\x38\x44\x2\x1d\xc2\x42\x3c\x0\x6c\x52\x41\x29\xb0\x50\x8\x0\x38\x44\x6\x73\xc2\x62\x5c\x0"
"\x44\x44\x46\x3d\xa2\x62\x22\x0\x20\x18\x14\x13\x88\x48\x30\x0\x20\x30\x28\x35\xae\x62\x12\xc\x24\x14\xe\x7\x8a\x52\x22\x0\x10\xc\xa\x5\x84\x42\x3e\x0\x44\x64\x56\x2b\xaa\x61\x31\x0\x88\x8c\x4e\x55\xd4\x62\x22\x0\x78\x84\x86\x43\xc2\x62\x1c\x0"
"\x3e\x44\x46\x23\x9f\x62\x2\x0\x78\x84\x86\x43\xd2\x62\x5c\x0\x3e\x44\x42\x3f\xa2\x61\x21\x0\x20\x20\x50\x48\xc5\x46\x39\x0\xc0\x3e\x9\x5\x82\x42\x3c\x0\x44\x44\x46\x43\xa2\x22\x1c\x0\x44\x44\x22\x63\x94\x14\x8\x0\x44\x44\x42\x23\xaa\x6a\x14\x0"
"\x22\x26\x15\x9\x94\x62\x22\x0\x88\x44\x42\x43\xfc\x44\x42\x3c\x3c\x42\x41\x39\xe0\x5c\x42\x3c\x38\x8\x8\x8\x8\x8\x38\x0\x1\x2\x4\x8\x10\x20\x40\x0\x1c\x10\x10\x10\x10\x10\x1c\x0\x8\x14\x22\x41\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\xff"
"\x4\x4\x8\x0\x0\x0\x0\x0\x0\x0\x5c\x27\x92\x52\x2c\x0\x8\x4\x16\x2d\xa2\x52\x3c\x0\x0\x0\x3e\x25\x82\x42\x3c\x0\x80\x80\x5c\x67\xe2\x52\x4c\x0\x0\x0\x1c\x23\x9e\x42\x3c\x0\x30\x4c\x42\x71\xa8\x24\x14\x8\x0\x0\xbc\x47\xe2\x5c\x22\x1c"
"\x8\xc\x36\x4d\xa4\x62\x32\x0\x0\x20\x0\x10\x99\x4e\x38\x0\x0\x40\x0\x70\xad\x72\x9\x7\x4\x4\x16\xb\x8e\x52\x32\x0\x20\x18\x14\xa\x89\x44\x38\x0\x0\x0\x2a\x57\xd2\x49\x29\x0\x0\x0\x34\x4f\xc4\x62\x22\x0\x0\x0\x3c\x47\xa2\x22\x1c\x0"
"\x0\x0\x1a\x27\xa6\x5e\x2\x1\x0\x0\x5c\x23\xb2\x6c\x60\x20\x0\x0\x66\x59\xa0\x60\x30\x0\x0\x0\x30\x50\xcc\x43\x3c\x0\x20\x20\x7c\x13\x90\x48\x38\x0\x0\x0\x24\x27\x92\x52\x2c\x0\x0\x0\x26\x63\x92\xa\x4\x0\x0\x0\x46\x43\xaa\x2a\x14\x0"
"\x0\x0\x22\x15\x88\x54\x22\x0\x0\x0\x44\x23\xa2\x7c\x22\x1c\x0\x0\x3c\x23\x98\x74\x12\xc\x20\x10\x10\x8\x10\x10\x20\x0\x8\x8\x8\x0\x8\x8\x8\x0\x4\x8\x8\x10\x8\x8\x4\x0\x24\x1a\x0\x0\x0\x0\x0\x0\x0\x8\x14\x22\x41\x41\x7f\x0"
"\xff\x1\x1\x1\x1\x1\x1\x1\xff\x0\x0\x0\x0\x0\x0\x0\xff\x80\x80\x80\x80\x80\x80\x80\x1\x1\x1\x1\x1\x1\x1\x1\x80\x80\x80\x80\x80\x80\x80\x80\x1\x1\x1\x1\x1\x1\x1\xff\x0\x0\x0\x0\x0\x0\x0\xff\x80\x80\x80\x80\x80\x80\x80\xff"
"\x1\x0\x0\x0\x0\x0\x0\x0\x80\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x1\x0\x0\x0\x0\x0\x0\x0\x80\x1\x3\x7\xf\x1f\x3f\x7f\xff\xff\xfe\xfc\xf8\xf0\xe0\xc0\x80\xff\xff\x3\x3\x3\x3\x3\x3\xff\xff\x0\x0\x0\x0\x0\x0"
"\xff\xff\xc0\xc0\xc0\xc0\xc0\xc0\x3\x3\x3\x3\x3\x3\x3\x3\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\x3\x3\x3\x3\x3\x3\xff\xff\x0\x0\x0\x0\x0\x0\xff\xff\xc0\xc0\xc0\xc0\xc0\xc0\xff\xff\x3\x3\x0\x0\x0\x0\x0\x0\xc0\xc0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x3\x3\x0\x0\x0\x0\x0\x0\xc0\xc0\x0\x0\x0\x55\x0\x0\x0\x0\x0\x1e\x3f\x3f\x3f\x3f\x1e\x0\x0\x3c\x7e\x7e\x7e\x7e\x3c\x0\x0\x78\xfc\xfc\xfc\xfc\x78\x0\x0\xf0\xf8\xf8\xf8\xf8\xf0\x0\x0\xe0\xf0\xf0\xf0\xf0\xe0\x0"
"\x0\xc0\xe0\xe0\xe0\xe0\xc0\x0\x0\x80\xc0\xc0\xc0\xc0\x80\x0\x0\x0\x80\x80\x80\x80\x0\x0\x0\x0\x1\x1\x1\x1\x0\x0\x0\x1\x3\x3\x3\x3\x1\x0\x0\x3\x7\x7\x7\x7\x3\x0\x0\x7\xf\xf\xf\xf\x7\x0\x0\xf\x1f\x1f\x1f\x1f\xf\x0"
"\x7e\x7e\x7e\x7e\x7e\x7e\x7e\x7e\xff\xff\x0\x18\x3c\x7e\xff\x0\xff\xff\x0\x0\x0\x0\x18\x18\xff\xff\x0\x18\x3c\x7e\xff\x18\xff\xff\x0\xe7\x5a\x42\x42\xe7\x0\x0\x0\x18\x18\x0\x0\x0\x0\x1\x1\x2\x2\x2\x1\x1\x0\x9\x9\x12\x12\x12\x9\x9"
"\x0\x49\x49\x92\x92\x92\x49\x49\x0\x2\x2\x4\x4\x4\x2\x2\x0\x12\x12\x24\x24\x24\x12\x12\x0\x92\x92\x24\x24\x24\x92\x92\x0\x0\x0\x1\x1\x1\x0\x0\x0\x4\x4\x9\x9\x9\x4\x4\x0\x24\x24\x49\x49\x49\x24\x24\x0\x0\x18\x3c\x3c\x18\x0\x0"
"\x0\x0\x1f\x18\x1f\x18\x18\x18\x6c\x6c\x6f\x60\x6f\x6c\x6c\x6c\x6c\x6c\x6c\x6c\x6c\x6c\x6c\x6c\x0\x0\x7f\x60\x6f\x6c\x6c\x6c\x6c\x6c\x6f\x60\x7f\x0\x0\x0\x6c\x6c\x6c\x6c\x7f\x0\x0\x0\x18\x18\x1f\x18\x1f\x0\x0\x0\x0\x0\x0\x0\x1f\x18\x18\x18"
"\x18\x18\x18\x18\xf8\x0\x0\x0\x18\x18\x18\x18\xff\x0\x0\x0\x0\x0\x0\x0\xff\x18\x18\x18\x18\x18\x18\x18\xf8\x18\x18\x18\x0\x0\x0\x0\xff\x0\x0\x0\x18\x18\x18\x18\xff\x18\x18\x18\x18\x18\xf8\x18\xf8\x18\x18\x18\x6c\x6c\x6c\x6c\xec\x6c\x6c\x6c"
"\x6c\x6c\xec\xc\xfc\x0\x0\x0\x0\x0\xfc\xc\xec\x6c\x6c\x6c\x6c\x6c\xef\x0\xff\x0\x0\x0\x0\x0\xff\x0\xef\x6c\x6c\x6c\x6c\x6c\xec\xc\xec\x6c\x6c\x6c\x0\x0\xff\x0\xff\x0\x0\x0\x6c\x6c\xef\x0\xef\x6c\x6c\x6c\x18\x18\xff\x0\xff\x0\x0\x0"
"\x6c\x6c\x6c\x6c\xff\x0\x0\x0\x0\x0\xff\x0\xff\x18\x18\x18\x0\x0\x0\x0\xff\x6c\x6c\x6c\x6c\x6c\x6c\x6c\xfc\x0\x0\x0\x18\x18\xf8\x18\xf8\x0\x0\x0\x0\x0\xf8\x18\xf8\x18\x18\x18\x0\x0\x0\x0\xfc\x6c\x6c\x6c\x6c\x6c\x6c\x6c\xff\x6c\x6c\x6c"
"\x18\x18\xff\x18\xff\x18\x18\x18\x18\x18\x18\x18\x1f\x0\x0\x0\x0\x0\x0\x0\xf8\x18\x18\x18\xff\xff\xff\xff\xff\xff\xff\xff\x0\x0\x0\x0\xff\xff\xff\xff\xf\xf\xf\xf\xf\xf\xf\xf\xf0\xf0\xf0\xf0\xf0\xf0\xf0\xf0\xff\xff\xff\xff\x0\x0\x0\x0"
"\x0\x0\x6e\x3b\x13\x3b\x6e\x0\x0\x1e\x33\x1f\x33\x1f\x3\x3\x0\x3f\x33\x3\x3\x3\x3\x0\x0\x0\x7f\x36\x36\x36\x36\x0\x3f\x33\x6\xc\x6\x33\x3f\x0\x0\x0\x7e\x1b\x1b\x1b\xe\x0\x0\x66\x66\x66\x66\x3e\x6\x3\x0\x6e\x3b\x18\x18\x18\x18\x0"
"\x3f\xc\x1e\x33\x33\x1e\xc\x3f\x1c\x36\x63\x7f\x63\x36\x1c\x0\x1c\x36\x63\x63\x36\x36\x77\x0\x38\xc\x18\x3e\x33\x33\x1e\x0\x0\x0\x7e\xdb\xdb\x7e\x0\x0\x60\x30\x7e\xdb\xdb\x7e\x6\x3\x1c\x6\x3\x1f\x3\x6\x1c\x0\x0\x0\x0\x0\x0\xdb\xdb\x0"
"\x0\x7e\x0\x7e\x0\x7e\x0\x0\x0\xf8\x8\x8\x8\x8\xf8\x0\x0\xff\x0\x0\x0\x0\xff\x0\x0\x1f\x10\x10\x10\x10\x1f\x0\x0\x0\x0\x8\x0\x0\x0\x0\x0\x0\x0\x2\x1\x0\x0\x0\x20\x30\x28\x24\x22\xa1\x60\x20\x0\x0\x0\x1\x2\x0\x0\x0"
"\x20\x60\xa1\x22\x24\x28\x30\x20\x0\x0\x0\x40\x40\x40\x40\x7f\xff\x81\x81\x81\x81\x80\x80\x80\x0\x0\x0\x20\x20\x11\x11\xe\x38\x44\x44\x82\x82\x0\x0\x0\x0\x0\xfe\x7c\x38\x10\x0\x0\x0\x0\x10\x38\x7c\xfe\x0\x0\x80\xc1\x63\x36\x1c\x8\x0\x0"
),
// Font no. 28
FontEntry("SMALLCAP", 8, 8, 
"\x0\x0\x0\x0\x0\x0\x0\x0\x7e\x81\xa5\x81\xbd\x99\x81\x7e\x3e\x7f\x6b\x5d\x63\x7f\x3e\x0\x63\x77\x7f\x7f\x3e\x1c\x8\x0\x8\x1c\x3e\x7f\x3e\x1c\x8\x0\x8\x1c\x8\x77\x77\x8\x1c\x0\x1c\x3e\x7f\x7f\x36\x8\x1c\x0\x0\x18\x3c\x7e\x3c\x18\x0\x0"
"\xff\xe7\xc3\x81\xc3\xe7\xff\xff\x0\x18\x3c\x66\x66\x3c\x18\x0\xff\xe7\xc3\x99\x99\xc3\xe7\xff\x78\x70\x78\x6c\x1e\x33\x33\x1e\x7e\xc3\xc3\x7e\x18\x7e\x18\x18\x78\x58\x78\x18\x18\xe\xf\x6\x7c\x7c\x6c\x6c\x6f\x66\x78\x30\xdb\x3c\x66\xe7\x66\x3c\xdb\x0"
"\x1\x3\xf\x1f\xf\x3\x1\x0\x40\x60\x78\x7c\x78\x60\x40\x0\x18\x3c\x7e\x18\x7e\x3c\x18\x0\x66\x66\x66\x66\x66\x0\x66\x0\xfe\xdb\xde\xdc\xd8\xd8\xd8\x0\x3c\x66\x1c\x36\x36\x1c\x33\x1e\x0\x0\x0\x0\x7f\x7f\x7f\x0\x18\x3c\x7e\x18\x7e\x3c\x18\x7e"
"\x18\x3c\x7e\x18\x18\x18\x18\x0\x18\x18\x18\x18\x7e\x3c\x18\x0\x0\x18\x38\x7f\x38\x18\x0\x0\x0\xc\xe\x7f\xe\xc\x0\x0\x0\x0\x3\x3\x3\x7f\x0\x0\x0\x24\x66\xff\x66\x24\x0\x0\x0\x8\x1c\x3e\x3e\x7f\x0\x0\x0\x7f\x3e\x3e\x1c\x8\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x18\x3c\x3c\x18\x18\x0\x18\x0\x36\x36\x36\x0\x0\x0\x0\x0\x36\x36\x7f\x36\x7f\x36\x36\x0\x18\x7e\x3\x3e\x60\x3f\x18\x0\x0\x63\x30\x18\xc\x6\x63\x0\x1c\x36\x1c\x6e\x33\x33\x6e\x0\x18\x18\xc\x0\x0\x0\x0\x0"
"\x18\xc\x6\x6\x6\xc\x18\x0\x6\xc\x18\x18\x18\xc\x6\x0\x0\x77\x3e\x7f\x3e\x77\x0\x0\x0\x18\x18\x7e\x18\x18\x0\x0\x0\x0\x0\x0\x18\x18\xc\x0\x0\x0\x0\x7f\x0\x0\x0\x0\x0\x0\x0\x0\x0\x1c\x1c\x0\x60\x30\x18\xc\x6\x3\x1\x0"
"\x0\x0\x3c\x76\x66\x6e\x3c\x0\x0\x0\x18\x1c\x18\x18\x3c\x0\x0\x0\x3c\x66\x30\xc\x7e\x0\x0\x7e\x30\x38\x60\x60\x30\x1e\x0\x34\x36\x36\x33\x7f\x30\x0\x0\x7e\x2\x3e\x66\x60\x30\x1e\x38\xc\x6\x3e\x66\x66\x3c\x0\x0\x7e\x60\x30\x38\x18\xc\xc"
"\x3c\x66\x66\x3c\x66\x66\x3c\x0\x0\x3c\x66\x66\x7c\x60\x30\x1c\x0\x38\x38\x0\x0\x38\x38\x0\x0\x18\x18\x0\x0\x18\x18\xc\x30\x18\xc\x6\xc\x18\x30\x0\x0\x0\x7f\x0\x0\x7f\x0\x0\x6\xc\x18\x30\x18\xc\x6\x0\x3e\x63\x60\x30\x18\x0\x18\x0"
"\x3e\x63\x63\x7b\x3b\x3\x7e\x0\x1c\x36\x63\x63\x7f\x63\x63\x0\x3f\x66\x66\x3e\x66\x66\x3f\x0\x3c\x66\x3\x3\x3\x66\x3c\x0\x1f\x36\x66\x66\x66\x36\x1f\x0\x7f\x43\x3\x1f\x3\x43\x7f\x0\x7f\x46\x6\x3e\x6\x6\xf\x0\x3e\x63\x3\x3\x7b\x63\x3e\x0"
"\x63\x63\x63\x7f\x63\x63\x63\x0\x3c\x18\x18\x18\x18\x18\x3c\x0\x3c\x18\x18\x18\x1b\x1b\xe\x0\x63\x33\x1b\xf\x1b\x33\x63\x0\xf\x6\x6\x6\x6\x46\x7f\x0\x63\x77\x7f\x6b\x6b\x63\x63\x0\x63\x67\x67\x6f\x7b\x73\x63\x0\x3e\x63\x63\x63\x63\x63\x3e\x0"
"\x3f\x66\x66\x3e\x6\x6\xf\x0\x3e\x63\x63\x63\x63\x6b\x3e\x60\x3f\x63\x63\x3f\x1b\x33\x63\x0\x3e\x63\x3\x3e\x60\x63\x3e\x0\x7e\x5a\x18\x18\x18\x18\x3c\x0\x63\x63\x63\x63\x63\x63\x3e\x0\x63\x63\x63\x63\x36\x1c\x8\x0\x63\x63\x6b\x6b\x7f\x77\x63\x0"
"\x63\x36\x1c\x1c\x1c\x36\x63\x0\x66\x66\x66\x3c\x18\x18\x3c\x0\x7f\x61\x30\x18\xc\x46\x7f\x0\x3e\x6\x6\x6\x6\x6\x3e\x0\x3\x6\xc\x18\x30\x60\x40\x0\x3e\x30\x30\x30\x30\x30\x3e\x0\x8\x1c\x36\x63\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\xff"
"\xc\xc\x18\x0\x0\x0\x0\x0\x0\x0\x3e\x63\x7f\x63\x63\x0\x0\x0\x3f\x66\x3e\x66\x3f\x0\x0\x0\x3e\x63\x3\x63\x3e\x0\x0\x0\x3f\x66\x66\x66\x3f\x0\x0\x0\x7f\x3\x1f\x3\x7f\x0\x0\x0\x7f\x3\x1f\x3\x3\x0\x0\x0\x7e\x3\x73\x63\x3e\x0"
"\x0\x0\x63\x63\x7f\x63\x63\x0\x0\x0\x3c\x18\x18\x18\x3c\x0\x0\x0\x78\x30\x30\x33\x1e\x0\x0\x0\x63\x33\x1f\x33\x63\x0\x0\x0\x3\x3\x3\x3\x3f\x0\x0\x0\x63\x77\x6b\x6b\x63\x0\x0\x0\x67\x6f\x6b\x7b\x73\x0\x0\x0\x3e\x63\x63\x63\x3e\x0"
"\x0\x0\x3f\x66\x3e\x6\xf\x0\x0\x0\x3e\x63\x63\x3b\x6e\x0\x0\x0\x3f\x66\x3e\x36\x67\x0\x0\x0\x3e\x3\x3e\x60\x3e\x0\x0\x0\x7e\x5a\x18\x18\x3c\x0\x0\x0\x63\x63\x63\x63\x3e\x0\x0\x0\x63\x63\x36\x1c\x8\x0\x0\x0\x63\x6b\x6b\x77\x63\x0"
"\x0\x0\x63\x36\x1c\x36\x63\x0\x0\x0\x66\x66\x3c\x18\x18\x0\x0\x0\x3f\x19\xc\x26\x3f\x0\x70\x18\x18\xe\x18\x18\x70\x0\x18\x18\x18\x0\x18\x18\x18\x0\xe\x18\x18\x70\x18\x18\xe\x0\x6e\x3b\x0\x0\x0\x0\x0\x0\x0\x8\x1c\x1c\x36\x36\x7f\x0"
"\xff\x1\x1\x1\x1\x1\x1\x1\xff\x0\x0\x0\x0\x0\x0\x0\xff\x80\x80\x80\x80\x80\x80\x80\x1\x1\x1\x1\x1\x1\x1\x1\x80\x80\x80\x80\x80\x80\x80\x80\x1\x1\x1\x1\x1\x1\x1\xff\x0\x0\x0\x0\x0\x0\x0\xff\x80\x80\x80\x80\x80\x80\x80\xff"
"\x1\x0\x0\x0\x0\x0\x0\x0\x80\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x1\x0\x0\x0\x0\x0\x0\x0\x80\x1\x3\x7\xf\x1f\x3f\x7f\xff\xff\xfe\xfc\xf8\xf0\xe0\xc0\x80\xff\xff\x3\x3\x3\x3\x3\x3\xff\xff\x0\x0\x0\x0\x0\x0"
"\xff\xff\xc0\xc0\xc0\xc0\xc0\xc0\x3\x3\x3\x3\x3\x3\x3\x3\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\x3\x3\x3\x3\x3\x3\xff\xff\x0\x0\x0\x0\x0\x0\xff\xff\xc0\xc0\xc0\xc0\xc0\xc0\xff\xff\x3\x3\x0\x0\x0\x0\x0\x0\xc0\xc0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x3\x3\x0\x0\x0\x0\x0\x0\xc0\xc0\x0\x0\x40\xaa\x4\x0\x0\x0\x0\x1e\x33\x2d\x2d\x33\x1e\x0\x0\x7e\x66\x5a\x5a\x66\x7e\x0\x0\xfc\x84\xb4\xb4\x84\xfc\x0\x0\xf8\x48\x18\x88\x28\xf8\x0\x0\xf0\x30\x10\x10\x30\xf0\x0"
"\x0\xc0\x60\x20\x20\x60\xc0\x0\x0\x80\xc0\x40\xc0\xc0\x80\x0\x0\x0\x80\x80\x80\x80\x0\x0\x0\x1\x1\x1\x1\x1\x1\x0\x0\x3\x3\x2\x2\x3\x3\x0\x0\x3\x6\x4\x4\x6\x3\x0\x0\x7\xd\xc\x8\xe\x7\x0\x0\xf\x19\x16\x16\x19\xf\x0"
"\x7e\x7e\x7e\x7e\x7e\x7e\x7e\x7e\xff\xff\x0\x18\x3c\x7e\xff\x0\xff\xff\x0\x0\x0\x0\x18\x18\xff\xff\x0\x18\x3c\x7e\xff\x18\xff\xff\x0\x42\x66\x5a\x42\x42\x0\x0\x0\x18\x18\x0\x0\x0\x0\x0\x1\x3\x2\x3\x1\x0\x0\x0\x7\x9\x18\x9\x7\x0"
"\x0\x1c\x63\xc1\x80\xc1\x63\x1c\x0\x0\x3\x5\x4\x5\x3\x0\x0\x0\x1f\x21\x10\x21\x1f\x0\x0\xfc\x7\xc1\x20\xc1\x7\xfc\x0\x0\x1\x2\x3\x2\x1\x0\x0\x7\xc\x9\x9\x9\xc\x7\x0\x1f\x70\xc1\x82\xc1\x70\x1f\x0\x0\x18\x3c\x3c\x18\x0\x0"
"\x0\x0\x1f\x18\x1f\x18\x18\x18\x6c\x6c\x6f\x60\x6f\x6c\x6c\x6c\x6c\x6c\x6c\x6c\x6c\x6c\x6c\x6c\x0\x0\x7f\x60\x6f\x6c\x6c\x6c\x6c\x6c\x6f\x60\x7f\x0\x0\x0\x6c\x6c\x6c\x6c\x7f\x0\x0\x0\x18\x18\x1f\x18\x1f\x0\x0\x0\x0\x0\x0\x0\x1f\x18\x18\x18"
"\x18\x18\x18\x18\xf8\x0\x0\x0\x18\x18\x18\x18\xff\x0\x0\x0\x0\x0\x0\x0\xff\x18\x18\x18\x18\x18\x18\x18\xf8\x18\x18\x18\x0\x0\x0\x0\xff\x0\x0\x0\x18\x18\x18\x18\xff\x18\x18\x18\x18\x18\xf8\x18\xf8\x18\x18\x18\x6c\x6c\x6c\x6c\xec\x6c\x6c\x6c"
"\x6c\x6c\xec\xc\xfc\x0\x0\x0\x0\x0\xfc\xc\xec\x6c\x6c\x6c\x6c\x6c\xef\x0\xff\x0\x0\x0\x0\x0\xff\x0\xef\x6c\x6c\x6c\x6c\x6c\xec\xc\xec\x6c\x6c\x6c\x0\x0\xff\x0\xff\x0\x0\x0\x6c\x6c\xef\x0\xef\x6c\x6c\x6c\x18\x18\xff\x0\xff\x0\x0\x0"
"\x6c\x6c\x6c\x6c\xff\x0\x0\x0\x0\x0\xff\x0\xff\x18\x18\x18\x0\x0\x0\x0\xff\x6c\x6c\x6c\x6c\x6c\x6c\x6c\xfc\x0\x0\x0\x18\x18\xf8\x18\xf8\x0\x0\x0\x0\x0\xf8\x18\xf8\x18\x18\x18\x0\x0\x0\x0\xfc\x6c\x6c\x6c\x6c\x6c\x6c\x6c\xff\x6c\x6c\x6c"
"\x18\x18\xff\x18\xff\x18\x18\x18\x18\x18\x18\x18\x1f\x0\x0\x0\x0\x0\x0\x0\xf8\x18\x18\x18\xff\xff\xff\xff\xff\xff\xff\xff\x0\x0\x0\x0\xff\xff\xff\xff\xf\xf\xf\xf\xf\xf\xf\xf\xf0\xf0\xf0\xf0\xf0\xf0\xf0\xf0\xff\xff\xff\xff\x0\x0\x0\x0"
"\x0\x0\x6e\x3b\x13\x3b\x6e\x0\x0\x1e\x33\x1f\x33\x1f\x3\x3\x0\x3f\x33\x3\x3\x3\x3\x0\x0\x0\x7f\x36\x36\x36\x36\x0\x3f\x33\x6\xc\x6\x33\x3f\x0\x0\x0\x7e\x1b\x1b\x1b\xe\x0\x0\x66\x66\x66\x66\x3e\x6\x3\x0\x6e\x3b\x18\x18\x18\x18\x0"
"\x3f\xc\x1e\x33\x33\x1e\xc\x3f\x1c\x36\x63\x7f\x63\x36\x1c\x0\x1c\x36\x63\x63\x36\x36\x77\x0\x38\xc\x18\x3e\x33\x33\x1e\x0\x0\x0\x7e\xdb\xdb\x7e\x0\x0\x60\x30\x7e\xdb\xdb\x7e\x6\x3\x1c\x6\x3\x1f\x3\x6\x1c\x0\x0\x0\x0\x0\x0\xdb\xdb\x0"
"\x0\x7e\x0\x7e\x0\x7e\x0\x0\x0\xf8\x8\x8\x8\x8\xf8\x0\x0\xff\x0\x0\x0\x0\xff\x0\x0\x1f\x10\x10\x10\x10\x1f\x0\x0\x0\x0\x8\x0\x0\x0\x0\x0\x0\x0\x2\x1\x0\x0\x0\x20\x30\x28\x24\x22\xa1\x60\x20\x0\x0\x0\x1\x2\x0\x0\x0"
"\x20\x60\xa1\x22\x24\x28\x30\x20\x0\x0\x0\x40\x40\x40\x40\x7f\xff\x81\x81\x81\x81\x80\x80\x80\x0\x0\x0\x20\x20\x11\x11\xe\x38\x44\x44\x82\x82\x0\x0\x0\x0\x0\xfe\x7c\x38\x10\x0\x0\x0\x0\x10\x38\x7c\xfe\x0\x0\x80\xc1\x63\x36\x1c\x8\x0\x0"
),
// Font no. 29
FontEntry("THICK", 8, 8, 
"\x0\x0\x0\x0\x0\x0\x0\x0\x7e\x81\xa5\x81\xbd\x99\x81\x7e\x7e\xff\xdb\xff\xff\xc3\xe7\x7e\x0\x77\x7f\x7f\x3e\x1c\x8\x0\x8\x1c\x3e\x7f\x3e\x1c\x8\x0\x18\x3c\x18\xff\xff\x52\x18\x0\x8\x1c\x3e\x7f\x7f\x49\x1c\x0\x0\x0\x18\x3c\x18\x0\x0\x0"
"\xff\xff\xe7\xc3\xe7\xff\xff\xff\x0\x3c\x42\x81\x81\x42\x3c\x0\xff\xc3\xbd\x7e\x7e\xbd\xc3\xff\xf8\xe0\xb0\x3e\x63\x63\x3e\x0\x0\x7e\xc3\xc3\x7e\x18\x7e\x18\x20\x60\xe0\x20\x20\x3f\x1f\x0\x30\x50\xb0\xd0\x9f\x8f\xf0\xf0\x81\xc2\xbc\xe4\xa4\xfc\xea\xff"
"\x0\x0\x6\x1e\x7e\x1e\x6\x0\x0\x0\x60\x78\x7e\x78\x60\x0\x18\x7e\x18\x18\x18\x18\x7e\x18\x66\x66\x66\x66\x66\x0\x66\x0\xff\x6d\x6e\x6c\x6c\x6c\x6c\x0\x7e\x81\x3e\x42\x42\x7c\x81\x7e\x0\x0\x0\x7e\x7e\x0\x0\x0\x18\x7e\x18\x18\x7e\x18\x0\xff"
"\x18\x7e\x18\x18\x18\x18\x18\x0\x18\x18\x18\x18\x18\x7e\x18\x0\x0\x20\x60\xff\x60\x20\x0\x0\x0\x4\x6\xff\x6\x4\x0\x0\x0\x0\x0\x3\x3\x3\xff\x0\x0\x24\x66\xff\x66\x24\x0\x0\x0\x0\x8\x1c\x3e\x7f\x0\x0\x0\x0\x0\x7f\x3e\x1c\x8\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\xc\x1e\x1e\x1e\xc\x0\xc\x0\x33\x66\xcc\x0\x0\x0\x0\x0\x0\x6c\xfe\x6c\x6c\xfe\x6c\x0\x3e\x6b\xb\x3e\x68\x6b\x3e\x8\xc7\x65\x37\x18\xec\xa6\xe3\x0\x1c\x32\x1c\xa2\x63\x73\x5e\x80\x60\x30\x18\x0\x0\x0\x0\x0"
"\x30\x18\x18\x18\x18\x18\x18\x30\x6\xc\xc\xc\xc\xc\xc\x6\x8\x2a\x1c\x7f\x1c\x2a\x8\x0\x0\x18\x18\x7e\x18\x18\x0\x0\x0\x0\x0\x0\x0\x0\x18\xc\x0\x0\x0\x7e\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\xc\x0\x0\xc0\x60\x30\x18\xc\x6\x0"
"\x3e\x73\x7b\x7f\x77\x73\x3e\x0\x38\x3c\x38\x38\x38\x38\x38\x0\x3e\x73\x70\x38\x1c\xe\x7f\x0\x3e\x73\x70\x3c\x70\x73\x3e\x0\x73\x73\x73\x73\x7f\x70\x70\x0\x7f\x7\x7\x3f\x70\x70\x3f\x0\x3e\x67\x7\x3f\x67\x67\x3e\x0\x7f\x60\x70\x38\x1c\x1c\x1c\x0"
"\x3e\x67\x67\x3e\x67\x67\x3e\x0\x3e\x73\x73\x7e\x70\x70\x3f\x0\x0\xc\x0\x0\x0\xc\x0\x0\x0\xc\x0\x0\x0\xc\x6\x0\x0\x18\xc\x6\xc\x18\x0\x0\x0\x0\x7e\x0\x7e\x0\x0\x0\x0\xc\x18\x30\x18\xc\x0\x0\x3e\x63\x70\x38\x1c\x0\x1c\x0"
"\x3e\x63\x7b\x7b\x3b\x3\x3e\x0\x3e\x67\x67\x67\x7f\x67\x67\x0\x3f\x67\x67\x3f\x67\x67\x3f\x0\x3e\x67\x7\x7\x67\x67\x3e\x0\x3f\x67\x67\x67\x67\x67\x3f\x0\x7f\x7\x7\x7f\x7\x7\x7f\x0\x7f\x7\x7\x7f\x7\x7\x7\x0\x3e\x67\x7\x77\x67\x67\x3e\x0"
"\x67\x67\x67\x7f\x67\x67\x67\x0\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x0\x70\x70\x70\x70\x73\x73\x3e\x0\x67\x37\x1f\xf\x1f\x37\x67\x0\x7\x7\x7\x7\x7\x7\x7f\x0\x63\x77\x7f\x6b\x63\x63\x63\x0\x63\x67\x6f\x7f\x77\x67\x67\x0\x3e\x67\x67\x67\x67\x67\x3e\x0"
"\x3f\x67\x67\x3f\x7\x7\x7\x0\x3e\x67\x67\x67\x67\x57\x2e\x40\x3f\x67\x67\x3f\x67\x67\x67\x0\x3e\x67\x7\x3e\x70\x73\x3e\x0\x7f\x1c\x1c\x1c\x1c\x1c\x1c\x0\x67\x67\x67\x67\x67\x67\x3e\x0\x67\x67\x67\x67\x67\x3e\x1c\x0\x63\x63\x63\x6b\x6b\x7f\x3f\x0"
"\xc7\x6e\x3c\x18\x3c\x76\xe3\x0\x67\x67\x3e\x1c\x1c\x1c\x1c\x0\x7f\x70\x38\x1c\xe\x7\x7f\x0\x38\x18\x18\x18\x18\x18\x18\x38\x0\x6\xc\x18\x30\x60\xc0\x0\xe\xc\xc\xc\xc\xc\xc\xe\x18\x3c\x66\xc3\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\xff"
"\xc\x18\x30\x0\x0\x0\x0\x0\x0\x0\x3e\x70\x7e\x73\x7e\x0\x3\x3\x3f\x67\x67\x67\x3f\x0\x0\x0\x3e\x67\x7\x67\x3e\x0\x60\x60\x7e\x73\x73\x73\x7e\x0\x0\x0\x3e\x67\x7f\x7\x7e\x0\x3c\xe\xe\x3f\xe\xe\xe\x0\x0\x0\x3e\x73\x73\x7e\x70\x3e"
"\x3\x3\x3f\x67\x67\x67\x67\x0\x18\x0\x18\x1c\x1c\x1c\x1c\x0\x30\x0\x30\x38\x38\x38\x38\x1f\x3\x3\x33\x1b\xf\x1b\x33\x0\x18\x18\x1c\x1c\x1c\x1c\x1c\x0\x0\x0\x3f\x6b\x6b\x6b\x6b\x0\x0\x0\x3f\x67\x67\x67\x67\x0\x0\x0\x3e\x67\x67\x67\x3e\x0"
"\x0\x0\x3f\x67\x67\x3f\x7\x7\x0\x0\x7e\x73\x73\x7e\x70\x70\x0\x0\x3f\x67\x7\x7\x7\x0\x0\x0\x7e\x7\x3e\x70\x3f\x0\x18\x18\x7e\x1c\x1c\x1c\x1c\x0\x0\x0\x67\x67\x67\x67\x7e\x0\x0\x0\x67\x67\x67\x36\x1c\x0\x0\x0\x6b\x6b\x6b\x6b\x3f\x0"
"\x0\x0\x67\x3e\x1c\x3e\x73\x0\x0\x0\x73\x73\x73\x7e\x70\x3f\x0\x0\x7f\x38\x1c\xe\x7f\x0\x30\x18\x18\xc\x18\x18\x30\x0\x18\x18\x18\x18\x18\x18\x18\x18\x6\xc\xc\x18\xc\xc\x6\x0\xe\xdb\x70\x0\x0\x0\x0\x0\x0\x0\x8\x14\x22\x7f\x0\x0"
"\xff\x1\x1\x1\x1\x1\x1\x1\xff\x0\x0\x0\x0\x0\x0\x0\xff\x80\x80\x80\x80\x80\x80\x80\x1\x1\x1\x1\x1\x1\x1\x1\x80\x80\x80\x80\x80\x80\x80\x80\x1\x1\x1\x1\x1\x1\x1\xff\x0\x0\x0\x0\x0\x0\x0\xff\x80\x80\x80\x80\x80\x80\x80\xff"
"\x1\x0\x0\x0\x0\x0\x0\x0\x80\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x1\x0\x0\x0\x0\x0\x0\x0\x80\x1\x3\x7\xf\x1f\x3f\x7f\xff\xff\xfe\xfc\xf8\xf0\xe0\xc0\x80\xff\xff\x3\x3\x3\x3\x3\x3\xff\xff\x0\x0\x0\x0\x0\x0"
"\xff\xff\xc0\xc0\xc0\xc0\xc0\xc0\x3\x3\x3\x3\x3\x3\x3\x3\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\x3\x3\x3\x3\x3\x3\xff\xff\x0\x0\x0\x0\x0\x0\xff\xff\xc0\xc0\xc0\xc0\xc0\xc0\xff\xff\x3\x3\x0\x0\x0\x0\x0\x0\xc0\xc0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x3\x3\x0\x0\x0\x0\x0\x0\xc0\xc0\x0\x0\x0\x55\x0\x0\x0\x0\x0\x3f\x3f\x3f\x3f\x3f\x3f\x0\x0\x7e\x7e\x7e\x7e\x7e\x7e\x0\x0\xfc\xfc\xfc\xfc\xfc\xfc\x0\x0\xf8\xf8\xf8\xf8\xf8\xf8\x0\x0\xf0\xf0\xf0\xf0\xf0\xf0\x0"
"\x0\xe0\xe0\xe0\xe0\xe0\xe0\x0\x0\xc0\xc0\xc0\xc0\xc0\xc0\x0\x0\x80\x80\x80\x80\x80\x80\x0\x0\x1\x1\x1\x1\x1\x1\x0\x0\x3\x3\x3\x3\x3\x3\x0\x0\x7\x7\x7\x7\x7\x7\x0\x0\xf\xf\xf\xf\xf\xf\x0\x0\x1f\x1f\x1f\x1f\x1f\x1f\x0"
"\x55\x6b\x55\x6b\x55\x6b\x55\x6b\xff\xff\x0\x0\x0\x8\x1c\x3e\xff\xff\x0\x0\x0\x0\x0\x7f\xff\xff\x0\x0\x8\x1c\x3e\x7f\xff\xff\x0\xc3\xe7\xff\xdb\xc3\x0\x0\x0\x0\x18\x0\x0\x0\x0\x3\x3\x3\x3\x3\x3\x3\x0\x1b\x1b\x1b\x1b\x1b\x1b\x1b"
"\x0\xdb\xdb\xdb\xdb\xdb\xdb\xdb\x0\x6\x6\x6\x6\x6\x6\x6\x0\x36\x36\x36\x36\x36\x36\x36\x0\xb6\xb6\xb6\xb6\xb6\xb6\xb6\x0\x1\x1\x1\x1\x1\x1\x1\x0\xd\xd\xd\xd\xd\xd\xd\x0\x6d\x6d\x6d\x6d\x6d\x6d\x6d\x0\x0\x18\x3c\x3c\x18\x0\x0"
"\x0\x0\x0\x1f\x18\x1f\x18\x18\x6c\x6c\x6c\x6f\x60\x6f\x6c\x6c\x6c\x6c\x6c\x6c\x6c\x6c\x6c\x6c\x0\x0\x0\x7f\x60\x6f\x6c\x6c\x6c\x6c\x6c\x6f\x60\x7f\x0\x0\x6c\x6c\x6c\x7f\x0\x0\x0\x0\x18\x18\x18\x1f\x18\x1f\x0\x0\x0\x0\x0\x1f\x18\x18\x18\x18"
"\x18\x18\x18\xf8\x0\x0\x0\x0\x18\x18\x18\xff\x0\x0\x0\x0\x0\x0\x0\xff\x18\x18\x18\x18\x18\x18\x18\xf8\x18\x18\x18\x18\x0\x0\x0\x0\xff\x0\x0\x0\x18\x18\x18\xff\x18\x18\x18\x18\x18\x18\x18\xf8\x18\xf8\x18\x18\x6c\x6c\x6c\xec\x6c\x6c\x6c\x6c"
"\x6c\x6c\x6c\xec\xc\xfc\x0\x0\x0\x0\x0\xfc\xc\xec\x6c\x6c\x6c\x6c\x6c\xef\x0\xff\x0\x0\x0\x0\x0\xff\x0\xef\x6c\x6c\x6c\x6c\x6c\xec\xc\xec\x6c\x6c\x0\x0\x0\xff\x0\xff\x0\x0\x6c\x6c\x6c\xef\x0\xef\x6c\x6c\x18\x18\x18\xff\x0\xff\x0\x0"
"\x6c\x6c\x6c\xff\x0\x0\x0\x0\x0\x0\x0\xff\x0\xff\x18\x18\x0\x0\x0\xff\x6c\x6c\x6c\x6c\x6c\x6c\x6c\xfc\x0\x0\x0\x0\x18\x18\x18\xf8\x18\xf8\x0\x0\x0\x0\x0\xf8\x18\xf8\x18\x18\x0\x0\x0\xfc\x6c\x6c\x6c\x6c\x6c\x6c\x6c\xff\x6c\x6c\x6c\x6c"
"\x18\x18\x18\xff\x18\xff\x18\x18\x18\x18\x18\x1f\x0\x0\x0\x0\x0\x0\x0\xf8\x18\x18\x18\x18\xff\xff\xff\xff\xff\xff\xff\xff\x0\x0\x0\x0\xff\xff\xff\xff\xf\xf\xf\xf\xf\xf\xf\xf\xf0\xf0\xf0\xf0\xf0\xf0\xf0\xf0\xff\xff\xff\xff\x0\x0\x0\x0"
"\x0\x0\xee\x19\x19\xee\x0\x0\x38\x6c\x66\x3f\x63\x63\x3f\x3\x7f\x46\x6\x6\x6\x6\x6\x0\x0\x0\xff\x66\x66\x66\x66\x0\x7f\x46\xc\x18\xc\x46\x7f\x0\x0\x0\xfc\x66\x63\x33\x1e\x0\x0\x0\xcc\xcc\xcc\x7c\xc\xf\x0\x0\xff\x18\x18\x18\x18\x0"
"\x3c\x18\x3c\x66\x66\x3c\x18\x3c\x0\x3e\x63\x7f\x63\x3e\x0\x0\x0\x7e\xc3\xc3\xc3\x66\xe7\x0\x78\x98\x3c\x66\x63\x33\x1e\x0\x0\x0\x66\x99\x99\x66\x0\x0\x0\xc0\x3e\x73\x67\x3e\x3\x0\x0\x7c\x3\x7f\x3\x7c\x0\x0\x0\x0\x0\x0\x0\xdb\xdb\x0"
"\x0\x7e\x0\x7e\x0\x7e\x0\x0\x0\xf8\x8\x8\x8\x8\xf8\x0\x0\xff\x0\x0\x0\x0\xff\x0\x0\x1f\x10\x10\x10\x10\x1f\x0\x0\x0\x0\x8\x0\x0\x0\x0\x0\x0\x0\x2\x1\x0\x0\x0\x20\x30\x28\x24\x22\xa1\x60\x20\x0\x0\x0\x1\x2\x0\x0\x0"
"\x20\x60\xa1\x22\x24\x28\x30\x20\x0\x0\x0\x40\x40\x40\x40\x7f\xff\x81\x81\x81\x81\x80\x80\x80\x0\x0\x0\x20\x20\x11\x11\xe\x38\x44\x44\x82\x82\x0\x0\x0\x0\x0\xfe\x7c\x38\x10\x0\x0\x0\x0\x10\x38\x7c\xfe\x0\x0\x80\xc1\x63\x36\x1c\x8\x0\x0"
),
// Font no. 30
FontEntry("TINY", 6, 5, 
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x28\xaf\xbc\x2\x0\x0\x0\x40\x4c\x44\x46\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\xe2\x8\x0\x0\x0\x0\x0\x0\x1e\x0\x0\x0\x0\x6\x40\x44\x44\x0\x44\x29\x45\x0\x31\x84\x10\x60\x90\x11\xe\x18"
"\x64\x90\x1\x42\x39\x84\x80\x13\xe\x19\xc0\x84\x53\x6\x38\x44\x8\x1\x44\x11\x45\x0\x51\xc\x19\x0\xc\x30\x0\x0\x0\x0\x0\x88\x8\x82\x0\xf0\xc0\x3\x20\x8\x22\x2\x0\x0\x0\x0\x0\x0\x0\x0\x51\xca\x29\x60\x94\x51\x6\x30\x21\x4\x3\x46"
"\x29\x65\x80\x13\x4e\x38\xe0\x84\x11\x2\x30\xe1\x14\x3\x4a\x39\xa5\x0\x21\x84\x10\x40\x8\x21\x6\x28\x65\x94\x2\x42\x8\xe1\x80\xf4\x52\x4a\x20\xad\xd5\x12\x10\xa5\x14\x1\x46\x39\x21\x0\x51\x4a\x71\x60\x94\x51\xa\x30\x41\x90\x1\x8e\x10\x42\x80\x52"
"\x4a\x39\xa0\x94\x52\x4\x48\x29\xbd\x4\x4a\x11\xa5\x80\x52\x84\x10\xe0\x10\x11\xe\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x88\x2\x0\x0\x0\x0\x0\x0\x0\x0\x0\x70\xd8\x7a\x0\x84\x51\x4\x0\x26\x4\x3\x10\x72\xc9\x1\x60\xd2\x71\x0\x30"
"\x71\x4\x0\x6e\xb1\x1\x40\x38\xa5\x0\x20\x80\x10\x0\x8\x20\x6\x0\xa1\x8c\x2\x40\x8\xc1\x0\x90\x5e\x4a\x0\xb4\x95\x12\x0\xa2\x14\x1\xc0\x28\x23\x0\x70\xca\x21\x0\x94\x15\x2\x0\x26\x98\x1\x80\x38\xc2\x0\x50\x4a\x31\x0\x94\x52\x4\x0\x29"
"\xbd\x4\x40\x11\xa5\x0\x50\x8a\x18\x0\x1c\x32\xe\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x6a\x5\x0\x30\xcf\x0\xf0\x42\x78\x0\x3e\x0\x1f\x80\xf\xe1\x7\x0\x10\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x20\xc4\x11\x0\x88\x23\x4\x0\x0\x0\x0"
),
// Font no. 31
FontEntry("TINY_UPPERCASE", 6, 5, 
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x28\xaf\xbc\x2\x0\x0\x0\x40\x4c\x44\x46\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\xe2\x8\x0\x0\x0\x0\x0\x0\x1e\x0\x0\x0\x0\x6\x40\x44\x44\x0\x44\x29\x45\x0\x31\x84\x10\x60\x90\x11\xe\x18"
"\x64\x90\x1\x42\x39\x84\x80\x13\xe\x19\xc0\x84\x53\x6\x38\x44\x8\x1\x44\x11\x45\x0\x51\xc\x19\x0\xc\x30\x0\x0\x0\x0\x0\x88\x8\x82\x0\xf0\xc0\x3\x20\x8\x22\x2\x0\x0\x0\x0\x0\x0\x0\x0\x51\xca\x29\x60\x94\x51\x6\x30\x21\x4\x3\x46"
"\x29\x65\x80\x13\x4e\x38\xe0\x84\x11\x2\x30\xe1\x14\x3\x4a\x39\xa5\x0\x21\x84\x10\x40\x8\x21\x6\x28\x65\x94\x2\x42\x8\xe1\x80\xf4\x52\x4a\x20\xad\xd5\x12\x10\xa5\x14\x1\x46\x39\x21\x0\x51\x4a\x71\x60\x94\x51\xa\x30\x41\x90\x1\x8e\x10\x42\x80\x52"
"\x4a\x39\xa0\x94\x52\x4\x48\x29\xbd\x4\x4a\x11\xa5\x80\x52\x84\x10\xe0\x10\x11\xe\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x88\x2\x0\x0\x0\x0\x0\x0\x0\x0\x0\x51\xca\x29\x60\x94\x51\x6\x30\x21\x4\x3\x46\x29\x65\x80\x13\x4e\x38\xe0\x84"
"\x11\x2\x30\xe1\x14\x3\x4a\x39\xa5\x0\x21\x84\x10\x40\x8\x21\x6\x28\x65\x94\x2\x42\x8\xe1\x80\xf4\x52\x4a\x20\xad\xd5\x12\x10\xa5\x14\x1\x46\x39\x21\x0\x51\x4a\x71\x60\x94\x51\xa\x30\x41\x90\x1\x8e\x10\x42\x80\x52\x4a\x39\xa0\x94\x52\x4\x48\x29"
"\xbd\x4\x4a\x11\xa5\x80\x52\x84\x10\xe0\x10\x11\xe\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x6a\x5\x0\x30\xcf\x0\xf0\x42\x78\x0\x3e\x0\x1f\x80\xf\xe1\x7\x0\x10\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x20\xc4\x11\x0\x88\x23\x4\x0\x0\x0\x0"
),
// Font no. 32
FontEntry("XTSAMP", 8, 8, 
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x20\x60\xff\xff\x60\x20\x0\x0\x4\x6\xff\xff\x6\x4\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x18\x3c\x7e\xff\x0\x0\x0\x0\x0\x0\xff\x7e\x3c\x18\x0\x4\xc\x1c\x3c\x3c\x1c\xc\x4\x20\x30\x38\x3c\x3c\x38\x30\x20\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x18\x18\x18\x18\x0\x18\x0\x0\x36\x12\x0\x0\x0\x0\x0\x0\x0\x24\x7e\x24\x7e\x24\x0\x0\x10\x78\x1c\x70\x3c\x10\x0\x0\x40\x66\x30\x18\xc\x66\x0\x0\x0\x1c\x36\x5c\x36\x5c\x0\x0\x18\x10\x0\x0\x0\x0\x0"
"\x0\x18\xc\x6\x6\xc\x18\x0\x0\x18\x30\x60\x60\x30\x18\x0\x0\x0\x66\x3c\xff\x3c\x66\x0\x0\x0\x18\x18\x7e\x18\x18\x0\x0\x0\x0\x0\x0\x18\x10\x0\x0\x0\x0\x0\x7e\x0\x0\x0\x0\x0\x0\x0\x0\x0\x30\x0\x0\x40\x60\x30\x18\xc\x6\x0"
"\x0\x3c\x66\x76\x6e\x66\x3c\x0\x0\x18\x1e\x18\x18\x18\x18\x0\x0\x3c\x66\x60\x30\x18\x7e\x0\x0\x3e\x60\x7e\x60\x60\x3e\x0\x0\x70\x78\x6c\x66\x7c\x60\x0\x0\x7e\x6\x3e\x60\x60\x3e\x0\x0\x7c\x6\x3e\x66\x66\x3c\x0\x0\x7e\x0\x30\x18\x18\x18\x0"
"\x0\x3c\x66\x3c\x66\x66\x3c\x0\x0\x3c\x66\x66\x6c\x70\x1e\x0\x0\x0\x0\x18\x0\x0\x18\x0\x0\x0\x18\x0\x0\x18\x8\x0\x0\x30\x18\xc\x6\xc\x18\x0\x0\x0\x0\x3e\x0\x3e\x0\x0\x0\x6\xc\x18\x30\x18\xc\x0\x0\x3c\x60\x60\x38\x0\x18\x0"
"\x0\x1c\x22\x32\x32\x2\x3c\x0\x0\x7c\xe\x66\x7e\x66\x66\x0\x0\x3c\x6\x66\x3e\x66\x3e\x0\x0\x7c\x0\x6\x6\xe\x7c\x0\x0\x3e\x70\x66\x66\x66\x3e\x0\x0\x7e\x0\x6\x36\x6\x7e\x0\x0\x7e\x0\x6\x76\x6\x6\x0\x0\x7c\xe\x6\x76\x66\x3c\x0"
"\x0\x66\x66\x66\x76\x66\x66\x0\x0\x18\x18\x18\x18\x18\x18\x0\x0\x7e\x0\x60\x60\x70\x3e\x0\x0\x66\x66\x26\x1e\x76\x66\x0\x0\x6\x6\x6\x6\x0\x7e\x0\x0\x46\x6e\x7e\x36\x46\x66\x0\x0\x66\x6e\x5e\x3e\x76\x66\x0\x0\x3c\x70\x66\x66\x66\x3c\x0"
"\x0\x3e\x60\x66\x36\x6\x6\x0\x0\x3c\x66\x66\x56\x36\x6c\x0\x0\x3e\x60\x66\x1e\x36\x66\x0\x0\x7c\x6\x6\x7c\x60\x3e\x0\x0\x7e\x0\x18\x18\x18\x18\x0\x0\x66\x66\x66\x66\x70\x3c\x0\x0\x66\x66\x66\x6e\x2c\x8\x0\x0\x46\x46\x56\x56\x56\x3c\x0"
"\x0\x42\x66\x2c\x18\x66\x42\x0\x0\x66\x66\x34\x30\x18\x18\x0\x0\x7e\x0\x30\x18\xc\x7e\x0\x0\x3e\x6\x6\x6\x6\x3e\x0\x0\x2\x6\xc\x18\x30\x60\x0\x0\x78\x60\x60\x60\x60\x78\x0\x0\x18\x3c\x66\x42\x0\x0\x0\x0\x0\x0\x0\x0\x0\x7e\x0"
"\x0\xc\x18\x0\x0\x0\x0\x0\x0\x0\x0\x3e\x6c\x66\x7c\x0\x0\x6\x6\x3e\x76\x66\x3e\x0\x0\x0\x0\x7c\xe\xe\x7c\x0\x0\x60\x60\x7c\x6e\x66\x7c\x0\x0\x0\x3e\x66\x76\x6\x7c\x0\x0\x78\x1c\xc\x3e\xc\xc\x0\x0\x0\x7c\x66\x7c\x60\x3c\x0"
"\x0\x6\x6\x3e\x76\x66\x66\x0\x0\x0\x18\x0\x18\x18\x18\x0\x0\x18\x0\x18\x18\x18\xe\x0\x0\x6\x6\x36\x1e\x36\x66\x0\x0\x18\x18\x18\x18\x18\x18\x0\x0\x0\x0\x7f\xd6\xd6\xd6\x0\x0\x0\x0\x3f\x76\x66\x66\x0\x0\x0\x0\x3c\x66\x66\x3c\x0"
"\x0\x0\x0\x3f\x66\x3e\x6\x0\x0\x0\x0\xfc\x66\x7c\x60\x0\x0\x0\x0\x78\x1c\xc\xc\x0\x0\x0\x0\x3c\xe\x78\x3e\x0\x0\xc\xc\xc\x1e\xc\xc\x0\x0\x0\x0\x0\x66\x66\x3e\x0\x0\x0\x0\x0\x66\x3c\x18\x0\x0\x0\x0\x56\x56\x7e\x6c\x0"
"\x0\x0\x0\x0\x66\x3c\x66\x0\x0\x0\x0\x6c\x7c\x60\x3c\x0\x0\x0\x0\x7e\x30\x18\x7e\x0\x0\x30\x18\x18\x4\x18\x30\x0\x0\x18\x18\x18\x0\x18\x18\x0\x0\xc\x18\x18\x20\x18\xc\x0\x0\x0\x6c\x36\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x6c\x0\x3e\x6c\x66\x3e\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x66\x0\x7c\x6\x7e\x66\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x66\x0\x3c\x66\x66\x1c\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x66\x18\x6e\x66\x66\x3c\x0\x0\x66\x0\x66\x66\x66\x3c\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\xff\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x3e\x3e\x3e\x3e\x3e\x3e\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\xdb\xdb\x0"
"\x0\x7e\x0\x7e\x0\x7e\x0\x0\x0\xf8\x8\x8\x8\x8\xf8\x0\x0\xff\x0\x0\x0\x0\xff\x0\x0\x1f\x10\x10\x10\x10\x1f\x0\x0\x0\x0\x8\x0\x0\x0\x0\x0\x0\x0\x2\x1\x0\x0\x0\x20\x30\x28\x24\x22\xa1\x60\x20\x0\x0\x0\x1\x2\x0\x0\x0"
"\x20\x60\xa1\x22\x24\x28\x30\x20\x0\x0\x0\x40\x40\x40\x40\x7f\xff\x81\x81\x81\x81\x80\x80\x80\x0\x0\x0\x20\x20\x11\x11\xe\x38\x44\x44\x82\x82\x0\x0\x0\x0\x0\xfe\x7c\x38\x10\x0\x0\x0\x0\x10\x38\x7c\xfe\x0\x0\x80\xc1\x63\x36\x1c\x8\x0\x0"
),
// Font no. 33
FontEntry("ZERO", 8, 8, 
"\x0\x0\x0\x0\x0\x0\x0\x0\x7e\x81\xa5\x81\xbd\x99\x81\x7e\x7e\xff\xdb\xff\xff\xc3\xe7\x7e\x0\x77\x7f\x7f\x3e\x1c\x8\x0\x8\x1c\x3e\x7f\x3e\x1c\x8\x0\x18\x3c\x18\xff\xff\x52\x18\x0\x8\x1c\x3e\x7f\x7f\x49\x1c\x0\x0\x0\x18\x3c\x18\x0\x0\x0"
"\xff\xff\xe7\xc3\xe7\xff\xff\xff\x0\x3c\x42\x42\x42\x42\x3c\x0\xff\xc3\xbd\xbd\xbd\xbd\xc3\xff\xf8\xe0\xb0\x3e\x63\x63\x3e\x0\x0\x7e\xc3\xc3\x7e\x18\x7e\x18\x20\x60\xe0\x20\x2e\x3f\x1f\xe\xfe\xc6\xfe\xc6\xc6\xe6\x67\x3\x81\xc2\xbc\xe4\xa4\xfc\xea\xff"
"\x0\x0\x6\x1e\x7e\x1e\x6\x0\x0\x0\x60\x78\x7e\x78\x60\x0\x18\x7e\x18\x18\x18\x18\x7e\x18\x66\x66\x66\x66\x66\x0\x66\x0\xff\x6d\x6e\x6c\x6c\x6c\x6c\x0\x7e\x81\x3e\x42\x42\x7c\x81\x7e\x0\x0\x0\x7e\x7e\x0\x0\x0\x18\x7e\x18\x18\x7e\x18\x0\xff"
"\x18\x7e\x18\x18\x18\x18\x18\x0\x18\x18\x18\x18\x18\x7e\x18\x0\x0\x20\x60\xff\x60\x20\x0\x0\x0\x4\x6\xff\x6\x4\x0\x0\x0\x0\x0\x3\x3\x3\xff\x0\x0\x24\x66\xff\x66\x24\x0\x0\x0\x0\x8\x1c\x3e\x7f\x0\x0\x0\x0\x0\x7f\x3e\x1c\x8\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\xc\xc\xc\xc\xc\x0\xc\x0\x66\x66\x0\x0\x0\x0\x0\x0\xa\x1f\xa\x1f\xa\x0\x0\x0\x3e\x4b\xb\x3e\x68\x6b\x3e\x8\xc7\x65\x37\x18\xec\xa6\xe3\x0\x1c\x32\x1c\xa2\x63\x73\x5e\x80\x30\x30\x18\x0\x0\x0\x0\x0"
"\x8\x6\x3\x3\x3\x6\x8\x0\x8\x30\x60\x60\x60\x30\x8\x0\x8\x2a\x1c\x7f\x1c\x2a\x8\x0\x0\x18\x18\x7e\x18\x18\x0\x0\x0\x0\x0\x0\x0\x0\x18\xe\x0\x0\x0\x7e\x0\x0\x0\x0\x0\x0\x0\x0\x0\x60\x60\x0\x80\xc0\x60\x30\x18\xc\x6\x3"
"\x0\x18\x24\x24\x24\x24\x18\x0\x18\x1c\x1e\x18\x18\x18\x3e\x0\x3e\x63\x60\x30\xc\x6\x7f\x0\x3e\x63\x60\x3c\x60\x63\x3e\x0\x70\x78\x6c\x66\x7f\x60\x60\x0\x7f\x3\x3\x3f\x60\x60\x3f\x0\x3e\x63\x3\x3f\x63\x63\x3e\x0\x7f\x60\x30\x18\xc\xc\xc\x0"
"\x3e\x63\x63\x3e\x63\x63\x3e\x0\x3e\x63\x63\x7e\x60\x63\x3e\x0\x0\xc\x0\x0\x0\xc\x0\x0\x0\xc\x0\x0\x0\xc\x4\x2\x80\xc0\x60\x30\x30\x60\xc0\x80\x0\x0\x7e\x0\x7e\x0\x0\x0\x3\x6\xc\x18\x18\xc\x6\x3\x3e\x63\x30\x18\xc\x0\xc\x0"
"\x3e\x41\x5d\x55\x7d\x1\x3e\x0\x8\x1c\x36\x63\x63\x7f\x63\x41\x3f\x61\x63\x3f\x63\x63\x3f\x0\x3e\x61\x3\x3\x43\x63\x3e\x0\x1f\x31\x63\x63\x63\x33\x1f\x0\x7f\x1\x3\x1f\x3\x3\x7f\x0\x7f\x41\x3\x1f\x13\x3\x3\x0\x3e\x61\x3\x7b\x43\x63\x5e\x0"
"\x63\x63\x63\x7f\x63\x63\x63\x0\x7e\x18\x18\x18\x18\x18\x7e\x0\x78\x30\x30\x30\x30\x33\x1e\x0\x63\x33\x1b\xf\x1b\x33\x63\x0\xf\x6\x6\x6\x6\x46\x7f\x0\x63\x77\x7f\x6b\x6b\x63\x63\x0\x63\x67\x6f\x7b\x73\x63\x63\x0\x3e\x63\x63\x63\x63\x63\x3e\x0"
"\x3f\x66\x66\x3e\x6\x6\xf\x0\x3e\x63\x63\x63\x7b\x33\x3e\x60\x3f\x66\x66\x3e\x66\x66\x67\xc0\x3e\x43\x3\x3e\x60\x63\x3e\x0\x7e\x18\x18\x18\x18\x18\x18\x0\x63\x63\x63\x63\x63\x63\x3e\x0\x63\x63\x63\x63\x63\x36\x1c\x0\x63\x63\x6b\x6b\x6b\x77\x63\x0"
"\x63\x36\x1c\x8\x1c\x36\x63\x0\x41\x63\x36\x1c\x8\x8\x1c\x0\x7f\x61\x30\x18\xc\x46\x7f\x0\x38\x18\x18\x18\x18\x18\x18\x38\x3\x6\xc\x18\x30\x60\xc0\x80\xe\xc\xc\xc\xc\xc\xc\xe\x8\x1c\x36\x63\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\xff"
"\xc\xc\x18\x0\x0\x0\x0\x0\x0\x0\x3e\x60\x7e\x63\x7e\x0\x3\x3\x3f\x63\x63\x63\x3f\x0\x0\x0\x3e\x63\x3\x63\x3e\x0\x60\x60\x7e\x63\x63\x63\x7e\x0\x0\x0\x3e\x63\x7f\x3\x3e\x0\x3c\x66\x6\x3f\x6\x6\x6\x0\x0\x0\xbe\x63\x63\x7e\x60\x3e"
"\x3\x3\x3f\x63\x63\x63\x63\x0\x18\x0\x1c\x18\x18\x18\x3c\x0\x30\x0\x38\x30\x30\x30\x33\x1e\x3\x3\x63\x1b\xf\x1b\x63\x0\x1c\x18\x18\x18\x18\x18\x38\x0\x0\x0\x63\x7f\x6b\x6b\x63\x0\x0\x0\x3f\x63\x63\x63\x63\x0\x0\x0\x3e\x63\x63\x63\x3e\x0"
"\x0\x0\x3f\x63\x63\x3f\x3\x3\x0\x0\x7e\x63\x63\x7e\x60\xe0\x0\x0\x7b\x6e\x66\x6\x6\x0\x0\x0\x7e\x3\x3e\x60\x3f\x0\x18\x18\x7e\x18\x18\x18\x78\x0\x0\x0\x63\x63\x63\x63\x7e\x0\x0\x0\x63\x63\x63\x36\x1c\x0\x0\x0\x63\x6b\x6b\x77\x63\x0"
"\x0\x0\x63\x36\x1c\x36\x63\x0\x0\x0\x63\x63\x63\x7e\x60\x3f\x0\x0\x7f\x30\x8\x46\x7f\x0\x70\x18\x18\xe\x18\x18\x70\x0\x18\x18\x18\x0\x18\x18\x18\x0\x7\xc\xc\x38\xc\xc\x7\x0\xe\xd9\x70\x0\x0\x0\x0\x0\x0\x0\x8\x14\x22\x7f\x0\x0"
"\xff\x1\x1\x1\x1\x1\x1\x1\xff\x0\x0\x0\x0\x0\x0\x0\xff\x80\x80\x80\x80\x80\x80\x80\x1\x1\x1\x1\x1\x1\x1\x1\x80\x80\x80\x80\x80\x80\x80\x80\x1\x1\x1\x1\x1\x1\x1\xff\x0\x0\x0\x0\x0\x0\x0\xff\x80\x80\x80\x80\x80\x80\x80\xff"
"\x1\x0\x0\x0\x0\x0\x0\x0\x80\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x1\x0\x0\x0\x0\x0\x0\x0\x80\x1\x3\x7\xf\x1f\x3f\x7f\xff\xff\xfe\xfc\xf8\xf0\xe0\xc0\x80\xff\xff\x3\x3\x3\x3\x3\x3\xff\xff\x0\x0\x0\x0\x0\x0"
"\xff\xff\xc0\xc0\xc0\xc0\xc0\xc0\x3\x3\x3\x3\x3\x3\x3\x3\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\x3\x3\x3\x3\x3\x3\xff\xff\x0\x0\x0\x0\x0\x0\xff\xff\xc0\xc0\xc0\xc0\xc0\xc0\xff\xff\x3\x3\x0\x0\x0\x0\x0\x0\xc0\xc0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x3\x3\x0\x0\x0\x0\x0\x0\xc0\xc0\x55\xaa\xff\x0\xff\xaa\x55\x0\x0\x3f\x3f\x3f\x3f\x3f\x3f\x0\x0\x7e\x7e\x7e\x7e\x7e\x7e\x0\x0\xfc\xfc\xfc\xfc\xfc\xfc\x0\x0\xf8\xf8\xf8\xf8\xf8\xf8\x0\x0\xf0\xf0\xf0\xf0\xf0\xf0\x0"
"\x0\xe0\xe0\xe0\xe0\xe0\xe0\x0\x0\xc0\xc0\xc0\xc0\xc0\xc0\x0\x0\x80\x80\x80\x80\x80\x80\x0\x0\x1\x1\x1\x1\x1\x1\x0\x0\x3\x3\x3\x3\x3\x3\x0\x0\x7\x7\x7\x7\x7\x7\x0\x0\xf\xf\xf\xf\xf\xf\x0\x0\x1f\x1f\x1f\x1f\x1f\x1f\x0"
"\x55\x6b\x55\x6b\x55\x6b\x55\x6b\xff\xff\x0\x0\x0\x8\x1c\x3e\xff\xff\x0\x0\x0\x0\x0\x7f\xff\xff\x0\x0\x8\x1c\x3e\x7f\xff\xff\x0\xc3\xe7\xff\xdb\xc3\x0\x0\x0\x8\x0\x0\x0\x0\x0\x3\x3\x3\x3\x3\x3\x3\x0\x1b\x1b\x1b\x1b\x1b\x1b\x1b"
"\x0\xdb\xdb\xdb\xdb\xdb\xdb\xdb\x0\x6\x6\x6\x6\x6\x6\x6\x0\x36\x36\x36\x36\x36\x36\x36\x0\xb6\xb6\xb6\xb6\xb6\xb6\xb6\x0\x1\x1\x1\x1\x1\x1\x1\x0\xd\xd\xd\xd\xd\xd\xd\x0\x6d\x6d\x6d\x6d\x6d\x6d\x6d\x8\x10\x18\xbe\x7d\x18\x8\x10"
"\x0\x0\x1f\x18\x1f\x18\x18\x18\x6c\x6c\x6f\x60\x6f\x6c\x6c\x6c\x6c\x6c\x6c\x6c\x6c\x6c\x6c\x6c\x0\x0\x7f\x60\x6f\x6c\x6c\x6c\x6c\x6c\x6f\x60\x7f\x0\x0\x0\x6c\x6c\x6c\x6c\x7f\x0\x0\x0\x18\x18\x1f\x18\x1f\x0\x0\x0\x0\x0\x0\x1f\x18\x18\x18\x18"
"\x18\x18\x18\xf8\x0\x0\x0\x0\x18\x18\x18\xff\x0\x0\x0\x0\x0\x0\x0\xff\x18\x18\x18\x18\x18\x18\x18\xf8\x18\x18\x18\x18\x0\x0\x0\x0\xff\x0\x0\x0\x18\x18\x18\xff\x18\x18\x18\x18\x18\x18\x18\xf8\x18\xf8\x18\x18\x6c\x6c\x6c\xec\x6c\x6c\x6c\x6c"
"\x6c\x6c\x6c\xec\xc\xfc\x0\x0\x0\x0\x0\xfc\xc\xec\x6c\x6c\x6c\x6c\x6c\xef\x0\xff\x0\x0\x0\x0\x0\xff\x0\xef\x6c\x6c\x6c\x6c\x6c\xec\xc\xec\x6c\x6c\x0\x0\x0\xff\x0\xff\x0\x0\x6c\x6c\x6c\xef\x0\xef\x6c\x6c\x18\x18\x18\xff\x0\xff\x0\x0"
"\x6c\x6c\x6c\xff\x0\x0\x0\x0\x0\x0\x0\xff\x0\xff\x18\x18\x0\x0\x0\xff\x6c\x6c\x6c\x6c\x6c\x6c\x6c\xfc\x0\x0\x0\x0\x18\x18\x18\xf8\x18\xf8\x0\x0\x0\x0\x0\xf8\x18\xf8\x18\x18\x0\x0\x0\xfc\x6c\x6c\x6c\x6c\x6c\x6c\x6c\xff\x6c\x6c\x6c\x6c"
"\x18\x18\x18\xff\x18\xff\x18\x18\x18\x18\x18\x1f\x0\x0\x0\x0\x0\x0\x0\xf8\x18\x18\x18\x18\xff\xff\xff\xff\xff\xff\xff\xff\x0\x0\x0\x0\xff\xff\xff\xff\xf\xf\xf\xf\xf\xf\xf\xf\xf0\xf0\xf0\xf0\xf0\xf0\xf0\xf0\xff\xff\xff\xff\x0\x0\x0\x0"
"\x0\x0\xee\x19\x19\xee\x0\x0\x38\x6c\x66\x3f\x63\x63\x3f\x3\x7f\x46\x6\x6\x6\x6\x6\x0\x0\x0\xff\x66\x66\x66\x66\x0\x7f\x46\xc\x18\xc\x46\x7f\x0\x0\x0\xfc\x66\x63\x33\x1e\x0\x0\x0\xcc\xcc\xcc\x7c\xc\xf\x0\x0\xff\x18\x18\x18\x18\x0"
"\x3c\x18\x3c\x66\x66\x3c\x18\x3c\x0\x3e\x63\x7f\x63\x3e\x0\x0\x0\x7e\xc3\xc3\xc3\x66\xe7\x0\x78\x98\x3c\x66\x63\x33\x1e\x0\x0\x0\x66\x99\x99\x66\x0\x0\x0\xc0\x3e\x73\x67\x3e\x3\x0\x0\x7c\x3\x7f\x3\x7c\x0\x0\x0\x0\x0\x0\x0\xdb\xdb\x0"
"\x0\x7e\x0\x7e\x0\x7e\x0\x0\x0\xf8\x8\x8\x8\x8\xf8\x0\x0\xff\x0\x0\x0\x0\xff\x0\x0\x1f\x10\x10\x10\x10\x1f\x0\x0\x0\x0\x8\x0\x0\x0\x0\x0\x0\x0\x2\x1\x0\x0\x0\x20\x30\x28\x24\x22\xa1\x60\x20\x0\x0\x0\x1\x2\x0\x0\x0"
"\x20\x60\xa1\x22\x24\x28\x30\x20\x0\x0\x0\x40\x40\x40\x40\x7f\xff\x81\x81\x81\x81\x80\x80\x80\x0\x0\x0\x20\x20\x11\x11\xe\x38\x44\x44\x82\x82\x0\x0\x0\x0\x0\xfe\x7c\x38\x10\x0\x0\x0\x0\x10\x38\x7c\xfe\x0\x0\x80\xc1\x63\x36\x1c\x8\x0\x0"
),
// Font no. 34
FontEntry("ZIRCFONT", 8, 8, 
"\x0\x0\x0\x0\x0\x0\x0\x0\x7e\x81\xa5\x81\xbd\x99\x81\x7e\x7e\xff\xdb\xff\xc3\xe7\xff\x7e\x36\x7f\x7f\x7f\x3e\x1c\x8\x0\x8\x1c\x3e\x7f\x3e\x1c\x8\x0\x1c\x3e\x1c\x7f\x7f\x49\x8\x3e\x0\x8\x1c\x3e\x7f\x3e\x1c\x3e\x0\x0\x18\x3c\x3c\x18\x0\x0"
"\xff\xff\xe7\xc3\xc3\xe7\xff\xff\x0\x3c\x66\x42\x42\x66\x3c\x0\xff\xc3\x99\xbd\xbd\x99\xc3\xff\xf0\xe0\xf0\xbe\x33\x33\x33\x1e\x3c\x66\x66\x66\x3c\x18\x7e\x18\xfc\xcc\xfc\xc\xc\xe\xf\x7\xfe\xc6\xfe\xc6\xc6\xe6\x67\x3\x99\x5a\x3c\xe7\xe7\x3c\x5a\x99"
"\x1\x7\x1f\x7f\x1f\x7\x1\x0\x40\x70\x7c\x7f\x7c\x70\x40\x0\x18\x3c\x7e\x18\x18\x7e\x3c\x18\x66\x66\x66\x66\x66\x0\x66\x0\xfe\xdb\xdb\xde\xd8\xd8\xd8\x0\x7c\xc6\x1c\x36\x36\x1c\x61\x3f\x0\x0\x0\x0\x7e\x7e\x7e\x0\x18\x3c\x7e\x18\x7e\x3c\x18\xff"
"\x18\x3c\x7e\x18\x18\x18\x18\x0\x18\x18\x18\x18\x7e\x3c\x18\x0\x0\x18\x30\x7f\x30\x18\x0\x0\x0\xc\x6\x7f\x6\xc\x0\x0\x0\x0\x3\x3\x3\x7f\x0\x0\x0\x24\x66\xff\x66\x24\x0\x0\x0\x18\x3c\x7e\xff\xff\x0\x0\x0\xff\xff\x7e\x3c\x18\x0\x0"
"\x0\x0\x0\x0\x0\x0\x0\x0\x10\x18\x18\x18\x8\x0\x18\x0\x22\x36\x34\x0\x0\x0\x0\x0\x0\x44\x7f\x64\x27\x7e\x22\x0\x10\x7e\x19\x3e\x6c\x3f\x4\x0\x0\x41\x63\x30\xc\x46\x63\x0\x1c\x26\x36\x1c\x7e\x19\x27\x0\x8\xc\x6\x0\x0\x0\x0\x0"
"\x18\xc\x6\x2\x6\xc\x38\x0\xe\x18\x30\x20\x30\x18\xc\x0\x0\x4\x6c\x1f\x78\x16\x33\x0\x0\x8\x18\x78\x1e\x18\x10\x0\x0\x0\x0\x0\x0\x10\x18\xc\x0\x0\x0\x7c\x1f\x0\x0\x0\x0\x0\x0\x0\x0\x18\x10\x0\x60\x30\x10\x8\xc\x6\x3\x0"
"\x1e\x30\x69\x4d\x67\x33\x1e\x0\x8\xc\x8\x8\x8\x3c\xe\x0\x3e\x67\x60\x38\xc\x76\x1f\x0\x7e\x60\x38\x6c\x41\x63\x3e\x0\x24\x26\x36\x32\x7f\x10\x10\x0\x3f\x1\x3f\x63\x40\x73\x3e\x0\x3c\x6\x3\x3b\x67\x66\x3c\x0\x3e\x67\x20\x30\x18\x18\x8\x0"
"\x4e\x62\x36\x1c\x36\x33\x1e\x0\x5e\x63\x61\x73\x6c\x20\x20\x0\x0\x10\x18\x0\x0\x18\x8\x0\x0\x8\x18\x0\x0\x10\x18\xc\x18\xc\x6\x3\x6\x1c\x30\x0\x0\x0\x7e\x0\x1e\x78\x0\x0\x6\x1c\x30\x60\x30\x18\xc\x0\x3c\x66\x22\x30\x18\x0\x18\x0"
"\x3c\x42\x79\x65\x79\x3\x3e\x0\x8\x8\x1c\x14\x3e\x63\xc1\x0\x3e\x63\x64\x3c\x64\x66\x3f\x0\x7c\xe\x3\x3\x43\x63\x3e\x0\x3e\x63\x40\x44\x64\x36\x1f\x0\x7c\x6\x2\x3f\x2\x6\x7c\x0\x7a\xf\x2\x1e\x7\x6\x6\x0\x1c\x32\x3\x39\x63\x66\x3c\x0"
"\x20\x21\x21\x7f\x33\x22\x22\x0\x3c\x10\x18\x18\x18\x8\x3c\x0\x7c\x20\x20\x60\x60\x67\x3c\x0\x62\x32\x1a\xe\x1e\x33\x42\x0\x2\x2\x3\x3\x2\x7a\x3f\x0\x23\x37\x7d\x69\x49\x41\x41\x0\x21\x23\x63\x67\x65\x4d\x79\x0\x3c\xe\x43\x41\x63\x36\x1c\x0"
"\x3e\x43\x64\x3e\x6\x6\x2\x0\x1e\x32\x60\x6d\x31\x3b\x6e\x0\x3e\x43\x64\x3e\xe\x36\x62\x0\x3c\x46\x2\x1c\x70\x61\x3e\x0\x78\x1f\x8\xc\xc\x4\x4\x0\x43\x43\x43\x61\x61\x33\x1e\x0\x41\x43\x62\x26\x24\x1c\x18\x0\x41\x41\x69\x6b\x2b\x3f\x36\x0"
"\x1\x62\x36\x1c\x1c\x36\x63\x0\x41\x62\x66\x3c\x18\xc\x6\x0\x3f\x30\x18\x8\xc\x66\x3e\x0\x3e\x2\x6\x6\x6\x4\x1c\x0\x2\x6\xc\x8\x18\x30\x60\x0\x3c\x20\x30\x30\x30\x10\x1e\x0\x8\x3c\x66\x41\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\xf8\x1f"
"\x4\xc\x18\x0\x0\x0\x0\x0\x0\x0\x2c\x32\x61\x63\x5e\x0\x2\x2\x3b\x67\x43\x61\x3d\x0\x0\x0\x3c\x6\x3\x71\x3e\x0\x20\x20\x6e\x73\x61\x43\x5e\x0\x0\x0\x3e\x33\x1b\x6\x7c\x0\x38\xc\x4\x3c\xe\x8\x8\x0\x0\x0\x5e\x63\x61\x6e\x20\x1e"
"\x1\x1\x1b\x37\x63\x42\x42\x0\x0\x10\x0\x10\x18\x18\x8\x0\x0\x8\x0\x8\x18\x18\x10\xe\x2\x2\x23\x1b\xf\x11\x21\x0\x8\x8\x18\x18\x18\x10\x10\x0\x0\x0\x35\x7f\x4b\x49\x49\x0\x0\x0\xd\x1b\x31\x31\x21\x0\x0\x0\x1e\x21\x63\x66\x3c\x0"
"\x0\x0\x39\x4d\x67\x3b\x2\x2\x0\x0\x2e\x39\x33\x3e\x10\x10\x0\x0\x19\x37\x3\x2\x2\x0\x0\x0\x1e\x7\x3c\x60\x3e\x0\x10\x10\x7e\x18\x18\x8\x8\x0\x0\x0\x44\x46\x66\x72\x4c\x0\x0\x0\x61\x33\x16\x1c\x8\x0\x0\x0\x42\x43\x6b\x69\x36\x0"
"\x0\x0\x31\x1e\xc\x16\x23\x0\x0\x0\x43\x26\x3c\x18\xc\x3\x0\x0\x3c\x33\x8\x6\x3f\x0\x18\xc\x4\x3\x4\xc\x38\x0\x8\x18\x8\x10\x18\x18\x10\x0\xe\x10\x10\x60\x10\x18\xe\x0\x4c\x3b\x0\x0\x0\x0\x0\x0\x0\x8\x1c\x36\x63\x63\x7f\x0"
"\xff\x1\x1\x1\x1\x1\x1\x1\xff\x0\x0\x0\x0\x0\x0\x0\xff\x80\x80\x80\x80\x80\x80\x80\x1\x1\x1\x1\x1\x1\x1\x1\x80\x80\x80\x80\x80\x80\x80\x80\x1\x1\x1\x1\x1\x1\x1\xff\x0\x0\x0\x0\x0\x0\x0\xff\x80\x80\x80\x80\x80\x80\x80\xff"
"\x1\x0\x0\x0\x0\x0\x0\x0\x80\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x0\x1\x0\x0\x0\x0\x0\x0\x0\x80\x1\x3\x7\xf\x1f\x3f\x7f\xff\xff\xfe\xfc\xf8\xf0\xe0\xc0\x80\xff\xff\x3\x3\x3\x3\x3\x3\xff\xff\x0\x0\x0\x0\x0\x0"
"\xff\xff\xc0\xc0\xc0\xc0\xc0\xc0\x3\x3\x3\x3\x3\x3\x3\x3\xc0\xc0\xc0\xc0\xc0\xc0\xc0\xc0\x3\x3\x3\x3\x3\x3\xff\xff\x0\x0\x0\x0\x0\x0\xff\xff\xc0\xc0\xc0\xc0\xc0\xc0\xff\xff\x3\x3\x0\x0\x0\x0\x0\x0\xc0\xc0\x0\x0\x0\x0\x0\x0"
"\x0\x0\x0\x0\x0\x0\x3\x3\x0\x0\x0\x0\x0\x0\xc0\xc0\x0\x0\x0\x41\x14\x0\x0\x0\x0\x18\x19\xf\x3c\x36\x6\x0\x0\x42\x76\x1c\x3c\x66\x43\x0\x0\x18\xd8\xf0\x3c\x6e\x60\x0\x0\x60\x60\xf8\xfc\x60\x40\x0\x0\x80\x98\xf0\xc0\x60\x60\x0"
"\x0\x20\x60\xc0\xc0\x60\x30\x0\x0\x80\x80\x0\xc0\xe0\x0\x0\x0\x0\x0\x80\xc0\x0\x0\x0\x0\x0\x0\x3\x1\x0\x0\x0\x0\x1\x1\x0\x3\x3\x0\x0\x0\x4\x7\x1\x3\x6\x4\x0\x0\x1\x1d\xf\x3\x6\x6\x0\x0\x6\x6\x3f\x1f\x6\x4\x0"
"\x7e\x7e\x7e\x7e\x7e\x7e\x7e\x7e\xff\xff\x0\x18\x24\x42\x3c\x0\xff\xff\x0\x18\x24\x42\x5a\x0\xff\xff\x0\x18\x3c\x7e\x3c\x0\xff\xff\x0\xe7\x5a\x42\x42\xe7\x0\x0\x0\x18\x18\x0\x0\x0\x0\x2\x3\x3\x2\x3\x1\x0\x0\x2\x3\x13\x3a\x1b\x11\x10"
"\x0\x32\x33\x13\x3a\x1b\x11\x10\x1\x3\x1\x3\x6\x6\x0\x0\x1\x3\x1\x43\x26\x66\x30\x10\x1\x33\x71\x63\x26\x66\x30\x10\x0\x2\x3\x1\x0\x0\x0\x0\x0\x2\x33\x31\x6\x7\x3\x2\x20\x62\x73\x31\x26\x67\x63\x2\x0\x0\x18\x3c\x3c\x18\x0\x0"
"\x0\x0\x1f\x18\x1f\x18\x18\x18\x6c\x6c\x6f\x60\x6f\x6c\x6c\x6c\x6c\x6c\x6c\x6c\x6c\x6c\x6c\x6c\x0\x0\x7f\x60\x6f\x6c\x6c\x6c\x6c\x6c\x6f\x60\x7f\x0\x0\x0\x6c\x6c\x6c\x6c\x7f\x0\x0\x0\x18\x18\x1f\x18\x1f\x0\x0\x0\x0\x0\x0\x0\x1f\x18\x18\x18"
"\x18\x18\x18\x18\xf8\x0\x0\x0\x18\x18\x18\x18\xff\x0\x0\x0\x0\x0\x0\x0\xff\x18\x18\x18\x18\x18\x18\x18\xf8\x18\x18\x18\x0\x0\x0\x0\xff\x0\x0\x0\x18\x18\x18\x18\xff\x18\x18\x18\x18\x18\xf8\x18\xf8\x18\x18\x18\x6c\x6c\x6c\x6c\xec\x6c\x6c\x6c"
"\x6c\x6c\xec\xc\xfc\x0\x0\x0\x0\x0\xfc\xc\xec\x6c\x6c\x6c\x6c\x6c\xef\x0\xff\x0\x0\x0\x0\x0\xff\x0\xef\x6c\x6c\x6c\x6c\x6c\xec\xc\xec\x6c\x6c\x6c\x0\x0\xff\x0\xff\x0\x0\x0\x6c\x6c\xef\x0\xef\x6c\x6c\x6c\x18\x18\xff\x0\xff\x0\x0\x0"
"\x6c\x6c\x6c\x6c\xff\x0\x0\x0\x0\x0\xff\x0\xff\x18\x18\x18\x0\x0\x0\x0\xff\x6c\x6c\x6c\x6c\x6c\x6c\x6c\xfc\x0\x0\x0\x18\x18\xf8\x18\xf8\x0\x0\x0\x0\x0\xf8\x18\xf8\x18\x18\x18\x0\x0\x0\x0\xfc\x6c\x6c\x6c\x6c\x6c\x6c\x6c\xff\x6c\x6c\x6c"
"\x18\x18\xff\x18\xff\x18\x18\x18\x18\x18\x18\x18\x1f\x0\x0\x0\x0\x0\x0\x0\xf8\x18\x18\x18\xff\xff\xff\xff\xff\xff\xff\xff\x0\x0\x0\x0\xff\xff\xff\xff\xf\xf\xf\xf\xf\xf\xf\xf\xf0\xf0\xf0\xf0\xf0\xf0\xf0\xf0\xff\xff\xff\xff\x0\x0\x0\x0"
"\x0\x0\x6e\x3b\x13\x3b\x6e\x0\x0\x1e\x33\x1f\x33\x1f\x3\x3\x0\x3f\x33\x3\x3\x3\x3\x0\x0\x0\x7f\x36\x36\x36\x36\x0\x3f\x33\x6\xc\x6\x33\x3f\x0\x0\x0\x7e\x1b\x1b\x1b\xe\x0\x0\x66\x66\x66\x66\x3e\x6\x3\x0\x6e\x3b\x18\x18\x18\x18\x0"
"\x3f\xc\x1e\x33\x33\x1e\xc\x3f\x1c\x36\x63\x7f\x63\x36\x1c\x0\x1c\x36\x63\x63\x36\x36\x77\x0\x38\xc\x18\x3e\x33\x33\x1e\x0\x0\x0\x7e\xdb\xdb\x7e\x0\x0\x60\x30\x7e\xdb\xdb\x7e\x6\x3\x1c\x6\x3\x1f\x3\x6\x1c\x0\x0\x0\x0\x0\x0\xdb\xdb\x0"
"\x0\x7e\x0\x7e\x0\x7e\x0\x0\x0\xf8\x8\x8\x8\x8\xf8\x0\x0\xff\x0\x0\x0\x0\xff\x0\x0\x1f\x10\x10\x10\x10\x1f\x0\x0\x0\x0\x8\x0\x0\x0\x0\x0\x0\x0\x2\x1\x0\x0\x0\x20\x30\x28\x24\x22\xa1\x60\x20\x0\x0\x0\x1\x2\x0\x0\x0"
"\x20\x60\xa1\x22\x24\x28\x30\x20\x0\x0\x0\x40\x40\x40\x40\x7f\xff\x81\x81\x81\x81\x80\x80\x80\x0\x0\x0\x20\x20\x11\x11\xe\x38\x44\x44\x82\x82\x0\x0\x0\x0\x0\xfe\x7c\x38\x10\x0\x0\x0\x0\x10\x38\x7c\xfe\x0\x0\x80\xc1\x63\x36\x1c\x8\x0\x0"
),
};

const unsigned int numFontsEntries = 35;

PPFont* PPFont::fontInstances[MAXFONTS];
pp_uint32 PPFont::numFontInstances = 0;

pp_uint8 PPFont::bigFont[256*16*16/8];

PPFont::FontFamilyDescription PPFont::fontFamilyDescriptions[FONT_LAST] = {
	FontFamilyDescription(PPSize(6,5), "Tiny (6x5)", "FONT_TINY", 31, 31, -1), 
	FontFamilyDescription(PPSize(8,8), "System (8x8)", "FONT_SYSTEM", 19, 19, -1), 
	FontFamilyDescription(PPSize(12,12), "Large (12x12)", "FONT_LARGE", 1, 1, -1),
	FontFamilyDescription(PPSize(16,16), "Huge (16x16)", "FONT_HUGE", 19, 19, -1)
};

pp_int32 PPFont::enumerationIndex = -1;

void PPFont::createLargeFromSystem(pp_uint32 index)
{
	Bitstream bitstream(bigFont, (16*16*256)/8);
	bitstream.clear();			
	
	Bitstream stream2((pp_uint8*)fontEntries[index].data, (8*8*256)/8);
	
	for (pp_int32 k = 0; k < 256; k++)
		for (pp_int32 j = 0; j < 16; j++)
			for (pp_int32 i = 0; i < 16; i++)
			{
				pp_int32 srcOffset = ((j>>1)*8+(i>>1))+(8*8*k);
				pp_int32 dstOffset = (j*16+i)+(16*16*k);
				if (stream2.read(srcOffset))
				{
					bitstream.write(dstOffset, 1);
				}
			}
				
}

PPFont::PPFont(pp_uint8* bits, const pp_uint32 chrWidth, const pp_uint32 chrHeight, pp_uint32 fontId) :
	charWidth(chrWidth), charHeight(chrHeight), charDim(chrHeight*chrWidth)
{
	fontBits = bits;

	bitstream = new Bitstream(fontBits, 0);

	this->fontId = fontId;

	fontInstances[numFontInstances++] = this;
}

PPFont::~PPFont()
{
	delete bitstream;
}

PPFont* PPFont::getFont(pp_uint32 fontId)
{
	pp_uint32 i;
	
	for (i = 0; i < numFontInstances; i++)
		if (fontInstances[i]->fontId == fontId)
			return fontInstances[i];

	if (numFontInstances >= MAXFONTS)
		return NULL;

	pp_uint32 index = fontFamilyDescriptions[fontId].fontEntryIndex;

	switch (fontId)
	{
		case FONT_TINY:
		{			
			return new PPFont((pp_uint8*)fontEntries[index].data, 5, 6, fontId);
		}

		case FONT_SYSTEM:
		{				
			return new PPFont((pp_uint8*)fontEntries[index].data, 8, 8, fontId);
		}

		case FONT_LARGE:
		{				
			return new PPFont((pp_uint8*)fontEntries[index].data, 12, 12, fontId);
		}

		case FONT_HUGE:
		{
			createLargeFromSystem(index);
			
			return new PPFont(bigFont, 16, 16, fontId);
			break;
		}
	
	}

	return NULL;
}

pp_uint32 PPFont::getStrWidth(const char* str) const
{
	if (str == NULL)
		return 0;

	return strlen(str)*getCharWidth();	
}

const char* PPFont::getFamilyInternalName(FontID fontID)
{
	if (fontID >= FONT_LAST)
		return NULL;

	return fontFamilyDescriptions[fontID].internalName;
}

const char* PPFont::getFirstFontFamilyName()
{
	enumerationIndex = FONT_TINY;
	if (enumerationIndex < FONT_LAST)
		return fontFamilyDescriptions[enumerationIndex].name;
	else
		return NULL;
}

const char* PPFont::getNextFontFamilyName()
{
	enumerationIndex++;
	if (enumerationIndex >= FONT_LAST)
	{
		enumerationIndex = -1;
		return NULL;
	}
	
	return fontFamilyDescriptions[enumerationIndex].name;
}

const char* PPFont::getFirstFontEntryName(FontID fontID)
{
	if (fontID >= FONT_LAST)
		return NULL;

	FontFamilyDescription* desc = &fontFamilyDescriptions[fontID];

	PPSize size = desc->size;
	if (fontID == FONT_HUGE)
	{
		size.width >>= 1;
		size.height >>= 1;
	}

	pp_int32 i = 0;
	bool found = false;
	for (i = 0; i < (signed)numFontsEntries && !found; i++)
		if (size.match(fontEntries[i].width, fontEntries[i].height))
			found = true;
			
	if (found)
	{
		desc->enumerationIndex = i-1;
		return fontEntries[i-1].name;
	}
		
	return NULL;
}

const char* PPFont::getNextFontEntryName(FontID fontID)
{
	if (fontID >= FONT_LAST)
		return NULL;

	FontFamilyDescription* desc = &fontFamilyDescriptions[fontID];

	PPSize size = desc->size;
	if (fontID == FONT_HUGE)
	{
		size.width >>= 1;
		size.height >>= 1;
	}

	pp_int32 i = desc->enumerationIndex+1;
	bool found = false;
	for (i = desc->enumerationIndex+1; i < (signed)numFontsEntries && !found; i++)
		if (size.match(fontEntries[i].width, fontEntries[i].height))
			found = true;
			
	if (found)
	{
		desc->enumerationIndex = i-1;
		return fontEntries[i-1].name;
	}
		
	desc->enumerationIndex = -1;
	return NULL;
}

void PPFont::selectFontFace(FontID fontID, const char* faceName)
{
	if (fontID >= FONT_LAST)
		return;

	FontFamilyDescription* desc = &fontFamilyDescriptions[fontID];

	PPSize size = desc->size;
	if (fontID == FONT_HUGE)
	{
		size.width >>= 1;
		size.height >>= 1;
	}

	pp_int32 i = 0;
	bool found = false;
	for (i = 0; i < (signed)numFontsEntries && !found; i++)
		if (size.match(fontEntries[i].width, fontEntries[i].height) && strcmp(fontEntries[i].name, faceName) == 0)
			found = true;
	
	if (!found)
		return;
							
	i--;
	desc->fontEntryIndex = i;

	for (pp_uint32 j = 0; j < numFontInstances; j++)
		if ((unsigned)fontInstances[j]->fontId == (unsigned)fontID)
		{	
			if (fontID == FONT_HUGE)
				createLargeFromSystem(i);
			else
			{
				fontInstances[j]->fontBits = (pp_uint8*)fontEntries[i].data;
				fontInstances[j]->bitstream->setSource(fontInstances[j]->fontBits, fontEntries[i].width*fontEntries[i].height / 8);
			}
		}
}

const char* PPFont::getCurrentFontFace(FontID fontID)
{
	if (fontID >= FONT_LAST)
		return NULL;

	FontFamilyDescription* desc = &fontFamilyDescriptions[fontID];
	
	return fontEntries[desc->fontEntryIndex].name;
}

