#############################################################################
# mined text editor make actions (make include file for make targets)

# Character set table modules
CHARO=charmaps/cjk-big5.o charmaps/cjk-ejis.o charmaps/cjk-johb.o charmaps/cjk-uhc.o charmaps/cjk-cns.o charmaps/cjk-gb.o charmaps/cjk-sjis.o charmaps/viscii.o

# Mined modules
OBJ	= $(SCREENOBJ) keyboard.o keymaps.o keydefs.o charmaps.o output.o \
	prompt.o mousemen.o justify.o mined1.o mined2.o minedaux.o search.o \
	iswide.o iscombin.o isrtol.o locale.o encoding.o \
	$(CHARO)

# Default make target:
all:	mined

# Source update archive:
update:
	cd man; make
	zip mined-src-update *.h *.c makefile.* mk* doc/changes.html doc/mined.html man/mined.1 -x cjk-*

# Unicode data tables:

SpecialCasing.txt:
	echo Trying to retrieve Unicode data file via Internet
	wget http://unicode.org/Public/UNIDATA/SpecialCasing.txt

UnicodeData.txt:
	echo Trying to retrieve Unicode data file via Internet
	wget http://unicode.org/Public/UNIDATA/UnicodeData.txt

Scripts.txt:
	echo Trying to retrieve Unicode data file via Internet
	wget http://unicode.org/Public/UNIDATA/Scripts.txt

Blocks.txt:
	echo Trying to retrieve Unicode data file via Internet
	wget http://unicode.org/Public/UNIDATA/Blocks.txt

Unihan.zip:
	echo Trying to retrieve Unicode data file via Internet
	wget http://unicode.org/Public/UNIDATA/Unihan.zip

Unihan.txt:
	make Unihan.zip
	unzip -o Unihan.zip
	touch -r Unihan.txt Unihan.zip

BIG5.TXT:
	echo Trying to retrieve Unicode data file via Internet
	wget http://unicode.org/Public/MAPPINGS/OBSOLETE/EASTASIA/OTHER/BIG5.TXT

unidata:	UnicodeData.txt SpecialCasing.txt Scripts.txt CJKdata
	./mkcasetb
	./mkcasesp
	./mkscript

CJKdata:	Unihan.txt BIG5.TXT


casetabl.h:	mkcasetb # UnicodeData.txt
	./mkcasetb

casespec.h:	mkcasesp # SpecialCasing.txt
	./mkcasesp

cjk-b5.h:	mkbig5table # Unihan.txt BIG5.TXT
	./mkbig5table

# Unicode character information tables:
scriptbl.h:	mkscript # Scripts.txt
	./mkscript

colours.h:	colours.cfg # mkinclud.mak
	sed -e 's/^[ 	"]*\([A-Z][A-Z]*\)[ 	,"]*\([0-9][0-9]*\).*/	{"\1", \2},/' -e t -e d colours.cfg | sort > colours.h

# Keyboard mapping table configuration:
# source lines: Greek	keymap_GreekMonotonic	gr

# OBSOLETE: generate:	#include "Cangjie.h"
keymaps.h:	keymaps.cfg keymaps0/*.h # mkinclud.mak
	sed -e 's/^[ 	"]*\([A-Za-z][^ 	]*\)[ 	,"]*\([A-Za-z_][^ 	]*\).*\([^ 	][^ 	]\).*/#include "\2.h"/' -e t -e d keymaps.cfg > keymaps.h

KEYMAPSCFG=$(shell sed -e 's/^[ 	"]*\([A-Za-z][^ 	]*\)[ 	,"]*\([A-Za-z_][^ 	]*\).*\([^ 	][^ 	]\).*/\2.h/' -e t -e d keymaps.cfg )
KEYMAPS0=keymaps0/*.h
KEYMAPS1=$(shell ls keymaps/[0-9A-Za-z]*.h )

# generate cumulative keymaps file
keymaps/_keymaps.h:	keymaps.cfg $(KEYMAPS0) $(KEYMAPS1) mkkmincl # mkinclud.mak
	test -d keymaps || mkdir keymaps
	./mkkmincl $(KEYMAPSCFG) > keymaps/_keymaps.h

# generate:	{keymap_GreekMonotonic, "gr"},
keymapsk.h:	keymaps.cfg # mkinclud.mak
	sed -e 's/^[ 	"]*\([A-Za-z][^ 	]*\)[ 	,"]*\([A-Za-z_][^ 	]*\).*\([^ 	][^ 	]\).*/	{keymap_\2, "\3"},/' -e t -e d keymaps.cfg > keymapsk.h

# generate:	{"Greek", select_keymap_entry, "gr"},
keymapsm.h:	keymaps.cfg # mkinclud.mak
	sed -e 's/^-.*/	{"", separator, ""},/' -e t -e 's/^[ 	"]*\([A-Za-z][^ 	]*\)[ 	,"]*\([A-Za-z_][^ 	]*\).*\([^ 	][^ 	]\).*/	{"\1", select_keymap_entry, "\3"},/' -e t -e d keymaps.cfg > keymapsm.h

keymaps:	keymapsk.h keymapsm.h

# Character input support tables:
MNEMOS=mnemos.???	# mnemos.add mnemos.rfc mnemos.tex mnemos.www
mnemos.h:	$(MNEMOS)
	cat $(MNEMOS) > mnemos.h

# Documentation page for mined additional mnemos
mnemodoc:	../doc/mnemodoc.html
../doc/mnemodoc.html:	mnemos.add mkmnemodoc
	./mkmnemodoc

# Location of online help file:
minedhlp.h:
	echo '	helpfile = "$(helpdir)/mined.hlp";' > minedhlp.h

# Source compilation:
mined1.o:	mined1.c textbuf.c mined.h minedhlp.h
	$(CC) $(CFLAGS) -c mined1.c
justify.o:	justify.c mined.h minedhlp.h
	$(CC) $(CFLAGS) $(PROTOFLAGS) -c justify.c
mined2.o:	mined2.c mined.h casespec.h casetabl.h scriptbl.h
	$(CC) $(CFLAGS) -c mined2.c
minedaux.o:	minedaux.c mined.h
	$(CC) $(CFLAGS) $(DECLFLAGS) -c minedaux.c
search.o:	search.c mined.h
	$(CC) $(CFLAGS) $(DECLFLAGS) -c search.c
mousemen.o:	mousemen.c mined.h keymapsm.h
	$(CC) $(CFLAGS) $(DECLFLAGS) -c mousemen.c
output.o:	output.c colours.h mined.h pc437.map
	$(CC) $(CFLAGS) $(DECLFLAGS) -c output.c
charmaps.o:	charmaps.c charmaps.h
	$(CC) $(CFLAGS) $(DECLFLAGS) -c charmaps.c
charmaps/%.o:	charmaps/%.map charmaps.h mkchrmap
	./mkchrmap $<
prompt.o:	prompt.c mined.h
	$(CC) $(CFLAGS) $(DECLFLAGS) -c prompt.c
io.o:	io.c io.h mined.h
	$(CC) $(CFLAGS) $(PROTOFLAGS) -c io.c
iocurses.o:	io.c io.h mined.h
	$(CC) $(CFLAGS) $(PROTOFLAGS) -c io.c $(ICURSES) -o iocurses.o
keyboard.o:	keyboard.c mined.h
	$(CC) $(CFLAGS) $(PROTOFLAGS) -c keyboard.c
keymaps.o:	keymaps.c keymapsk.h keymaps/_keymaps.h
	$(CC) -Ikeymaps $(CFLAGS) $(PROTOFLAGS) -c keymaps.c
keydefs.o:	keydefs.c mined.h mnemos.h
	$(CC) $(CFLAGS) $(DECLFLAGS) -c keydefs.c
iswide.o:	iswide.c
	$(CC) $(CFLAGS) -c iswide.c
iscombin.o:	iscombin.c
	$(CC) $(CFLAGS) -c iscombin.c
isrtol.o:	isrtol.c
	$(CC) $(CFLAGS) -c isrtol.c
locale.o:	locale.c
	$(CC) $(CFLAGS) -c locale.c
encoding.o:	encoding.c
	$(CC) $(CFLAGS) -c encoding.c

# Mined generation:
mined:	$(OBJ)
	$(CC) $(OBJ) $(SLIB) $(LINKOPTS) -o mined

# Online help:
help:	../mined.hlp

../mined.hlp:	../VERSION help/* mkhelp
	./mkhelp > ../mined.hlp

# Manual page:
man:	../man/mined.1

../man/mined.1:	../doc/mined.html
	cd ../man; make

# Installation:
install:	mined ../mined.hlp ../man/mined.1
	mkdir -p $(bindir)
	install mined $(bindir)
	mkdir -p $(helpdir)
	install ../mined.hlp $(helpdir)
	mkdir -p $(mandir)/man1
	install ../man/mined.1 $(mandir)/man1

# Local target to make binary archives for binary distribution:
bin:	../minedcyg.zip ../mineddj.zip

../minedcyg.zip:	cyg/mined.exe cyg/cyg*.dll
	cd cyg; zip minedcyg mined.exe cyg*.dll
	mv cyg/minedcyg.zip ../

../mineddj.zip:	dj/mined.exe
	cd dj; zip mineddj mined.exe
	mv dj/mineddj.zip ../

# Cleanup after compilation:
clean:
	rm -f $(OBJ) core # mined


#############################################################################
# end
