/*
 * Written by Bastien Chevreux (BaCh)
 *
 * Copyright (C) 2003 and later by Bastien Chevreux
 *
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the 
 * Free Software Foundation, Inc., 
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 * 
 */

#ifndef _bas_fastq_mira_h_
#define _bas_fastq_mira_h_

#include <iostream>

#include "stdinc/defines.H"
#include "errorhandling/errorhandling.H"



class FastQ
{
  //Variables
private:
  static string FQ_blanks;

  ifstream FQ_fin;
  string FQ_linebuffer;
  size_t FQ_linecount; 
  streampos FQ_filesize;
  streampos FQ_tellgofread;
  streampos FQ_lasttellg;
  bool      FQ_tracktellg;

  string FQ_name;
  string FQ_comment;
  string FQ_seq;
  string FQ_quals;

  // for splitting quality name line and comparing to FQ_name
  string FQ_dummy1;
  string FQ_dummy2;

public:


  //Functions
private:
  void foolCompiler();

  void splitNameLine(string & name,string & comment);
  size_t safeGetLineIntoLineBuffer();

public:
  FastQ();
  FastQ(FastQ const &other);
  ~FastQ();

  FastQ const & operator=(FastQ const & other);
  friend ostream & operator<<(ostream &ostr, FastQ const &fq);

  void openFile(const string & filename, bool tracktellg=false);
  int64 loadNext();
  int64 loadNext(streampos sp);

  inline const string & getName() const {return FQ_name;}
  inline const string & getComment() const {return FQ_comment;}
  inline const string & getSequence() const {return FQ_seq;}
  inline const string & getQuals() const {return FQ_quals;}
  streampos getStreamposOfRead() const;
  void setStreampos(streampos sp) const;
  inline streampos getFileSize() const {return FQ_filesize;}

  void discard();
};


#endif
