/*
 * Written by Bastien Chevreux (BaCh)
 *
 * Copyright (C) 2003 and later by Bastien Chevreux
 *
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the 
 * Free Software Foundation, Inc., 
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 * 
 */

#ifndef _bas_gbf_h_
#define _bas_gbf_h_

#include <ctype.h>
#include <string.h>

#include <iostream>
#include <fstream>
#include <string>

#include "stdinc/defines.H"
#include "errorhandling/errorhandling.H"

#include "io/exp.H"
#include "util/progressindic.H"

//// apparently, some systems may lack isblank() although it's part
////  of C99
//// patch kindly provided by
////  Alfredo Jose Hernandez Alvarez <ajhernan@lcg.unam.mx>
//#ifndef isblank
//#define isblank(c) ((c) == ' ' || (c) == '\t')
//#endif

#if HAVE_ISBLANK == 0
#define isblank(c) ((c) == ' ' || (c) == '\t')
#endif

using namespace std;



class GBF
{
  //Variables
private:
  uint32 GBF_valid;

  vector<string>          GBF_sequencenames;
  vector<string>          GBF_sequences;
  vector<vector<tag_t> >  GBF_tags;

  static vector<string>   GBF_gbffeaturenames;
  static vector<string>   GBF_gap4featurenames;

  static bool   GBF_staticfeaturesinit;
  static const char * GBF_featuretranslations[];

public:


  //Functions
private:
  void foolCompiler();
  void init();
  void zeroVars();

  void loadTheFile(ifstream & gbfin, uint64 lentoreserve);
  void getNextToken(const string & line, 
		    string::size_type & linepos, 
		    string & token) const;

  //const char * getFeatureIdentifier(const string & feature) const;
  void addKeyVal2TagComment(const string & actkey,
			    const string & actval, 
			    tag_t & thetag) const; 
  void storeAccumulatedTags(tag_t & acttag, vector<int32> & fromto);
  void parseGBFLocation(const string & location, 
			vector<int32> & fromto,
			int32 direction) const;
  string::size_type getCorrespondingRightBracket(const string & chars, 
						 string::size_type start) const;
  void correctForTagPositionErrors();

  static void fillFeatureTranslationVectors();

public:
  GBF();
  GBF(GBF const &other);
  ~GBF();

  GBF const & operator=(GBF const & other);
  friend ostream & operator<<(ostream &ostr, GBF const & gbf);

  void discard();

  void load(const string & gbfin);
  size_t getNumSequences() const {return GBF_sequences.size();}
  const string & getSequenceName(uint32 i) const;
  const string & getSequence(uint32 i) const;
  const vector<tag_t> & getTags(uint32 i) const;

  void transferGeneInfoToCDSInfo();

  static const char * translateGBFfeat2GAP4GBFfeat(const string & feature);
  static const char * translateGAP4GBFfeat2GBFfeat(const string & feature);

  // multitag?
  static bool checkIfGBFfeature(const string & feature);
  static bool checkIfGAP4GBFfeaure(const string & feature);
};


#endif
