# Miro - an RSS based video player application
# Copyright (C) 2005-2007 Participatory Culture Foundation
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA

import gtk

import threading
from frontend_implementation.gtk_queue import queue
import gtcache
import config
import prefs
import gtk.glade
import platformutils

###############################################################################
#### Application object                                                    ####
###############################################################################

class Application:

    def __init__(self):
        #print "Application init"
        pass
    def Run(self):
        gtk.glade.bindtextdomain("miro", config.get(prefs.GETTEXT_PATHNAME))
        gtk.glade.textdomain("miro")

        queue.main_thread = threading.currentThread()
        platformutils.setMainThread()
        gtk.gdk.threads_init()
        self.onStartup()
        gtk.main()
        self.onShutdown()

    def onStartup(self):
        # For overriding
        pass

    def finishStartupSequence(self):
        pass

    def onShutdown(self):
        # For overriding
        pass

    def addAndSelectFeed(self, url):
        # For overriding
        pass

###############################################################################
###############################################################################
