
#ifndef _COMPAT_H
#define _COMPAT_H

#ifndef PATH_SEP_STR
#ifdef WIN32
#define PATH_SEP_STR "\\"
#define PATH_SEP '\\'
#else
#define PATH_SEP_STR "/"
#define PATH_SEP '/'
#endif
#endif

#ifndef WIN32

#define double_mode(x) ((mode_t) x)

#undef shutdown
#define shutdown(f,h) close(f)

#else

#undef HAVE_DIR_D_NAMELEN
#define HAVE_DIR_D_NAMELEN 1

#undef HAVE_STRUCT_LINGER
#define HAVE_STRUCT_LINGER 1

struct passwd {
    char *pw_name;		/* user name */
    char *pw_passwd;		/* user password */
    uid_t pw_uid;		/* user id */
    gid_t pw_gid;		/* group id */
    char *pw_gecos;		/* real name */
    char *pw_dir;		/* home directory */
    char *pw_shell;		/* shell program */
};

struct group {
    char *gr_name;		/* group name */
    char *gr_passwd;		/* group password */
    gid_t gr_gid;		/* group id */
    char **gr_mem;		/* group members */
};

#define WIFEXITED(x) 0
#define WEXITSTATUS(x) 0

#define getuid() 0
#define geteuid() 0
#define getgid() 0

/* ftp stuff */
#define PRELIM		1	/* positive preliminary */
#define COMPLETE	2	/* positive completion */
#define CONTINUE	3	/* positive intermediate */
#define TRANSIENT	4	/* transient negative completion */

/* telnet stuff */
#define IAC		255	/* interpret as command: */
#define IP		244	/* interrupt process--permanently */
#define DM		242	/* data mark--for connect. cleaning */	

#define ELOOP EMLINK

#define endpwent()  

#define EWOULDBLOCK WSAEWOULDBLOCK

#define S_IRGRP S_IRUSR
#define S_IROTH S_IRUSR

#define S_IXGRP S_IXUSR
#define S_IXOTH S_IXUSR

#define S_IRWXG S_IRWXU
#define S_IWGRP S_IWUSR
#define S_IRWXO S_IRWXU
#define S_IWOTH S_IWUSR

#undef S_IFMT
#undef S_IFSOCK

#undef S_IFMT
#undef S_IFSOCK
#undef S_IFLNK
#undef S_IFREG
#undef S_IFBLK
#undef S_IFDIR
#undef S_IFCHR
#undef S_IFIFO
#undef S_ISUID
#undef S_ISGID
#undef S_ISVTX

#define S_IFMT		0xF0000000UL
#define S_IFSOCK	0xC0000000UL
#define S_IFLNK  	0xA0000000UL
#define S_IFREG		0x80008000UL
#define S_IFBLK  	0x60000000UL
#define S_IFDIR		0x40004000UL
#define S_IFCHR  	0x20000000UL
#define S_IFIFO  	0x10000000UL
#define S_ISUID  	0x08000000UL
#define S_ISGID  	0x04000000UL
#define S_ISVTX  	0x02000000UL

#undef S_ISLNK
#undef S_ISREG
#undef S_ISCHR
#undef S_ISBLK
#undef S_ISDIR
#undef S_ISFIFO
#undef S_ISSOCK

#define S_ISDIR(m)	((m) & S_IFDIR)
#define S_ISREG(m)	((m) & S_IFREG)

#define S_ISLNK(m)	(((m) & S_IFMT) == S_IFLNK)
#define S_ISCHR(m)	(((m) & S_IFMT) == S_IFCHR)
#define S_ISBLK(m)	(((m) & S_IFMT) == S_IFBLK)
#define S_ISFIFO(m)	(((m) & S_IFMT) == S_IFIFO)
#define S_ISSOCK(m)	(((m) & S_IFMT) == S_IFSOCK)


#define A_ISNORMAL(m)	((m) & 0700)

#define double_mode(x) (((unsigned long) x) << 16)

/* these are redefined for safety */
#undef S_ISUID
#define	S_ISUID	0

#undef S_ISGID
#define	S_ISGID	0

#undef S_ISVTX
#define	S_ISVTX 0

#define setgrent()  

#define getppid() 12344

#define kill(x,y)  

struct passwd *getpwuid (uid_t uid);
struct group *getgrgid (gid_t gid);
int fork (void);
int execve (char *argv_0, char **argv, char *envp[]);
int waitpid (pid_t pid, int *result, int flags);
int wait (int *result);
int gettimeofday (void *a, void *b);
int chown (char *path, uid_t owner, gid_t group);
int mknod (char *pathname,...);
int readlink (char *path, char *buf, size_t bufsiz);
int symlink (char *oldpath, char *newpath);
int link (char *f1, char *f2);
char *getpass (char *prompt);
#undef creat
#define creat(x,y) mingw32_open(x, O_CREAT | O_WRONLY, y)
#define open(x,y...) mingw32_open(x, y)
#ifndef _COMPAT_C
int mingw32_open (const char *szFileName, int flags,...);
#endif
#define stat(x,y) mingw32_stat (x, y)
#define fstat(x,y) mingw32_fstat (x, y)
#define lstat(x,y) mingw32_stat (x, y)
#define chmod(x,y) mingw32_chmod (x, y)
#define mkdir(x,y) mingw32_mkdir (x, y)

typedef unsigned long l_mode_t;
#undef mode_t
#define mode_t l_mode_t

#ifndef _COMPAT_C
int mingw32_stat (const char *file_name, void *buf);
int mingw32_fstat (int filedes, void *buf);
int mingw32_chmod (char *path, mode_t mode);
int mingw32_mkdir (char *filename, mode_t mode);
mode_t mode_mingw32_to_unix (int a);

/* windoze doesn't understand stderr or stdout ??? */
int mingwin32_fprintf (FILE *stream, const char *format, ...);
#endif

#define ioctl(a,b,c) ioctlsocket(a,b, (unsigned long *) c)

#define fprintf(a,b...)	mingwin32_fprintf (a,b)

#undef shutdown
#define shutdown(f,h) z_socket_close(f)

#endif
#endif

