//
// Copyright (C) 2008-2009 Jordi Mas i Hernandez, jmas@softcatala.org
//
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
//
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
// LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
// OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//

using System;
using System.IO;
using System.Runtime.InteropServices;

using Mistelix.DataModel;
using Mistelix.Core;

namespace Mistelix.Backends.OS
{
	//
	// Unix specific functions
	// 
	public static class Unix
	{
		[DllImport ("libmistelix")]
		static extern void mistelix_launchtool (string app, string args, string in_file, string out_file, string err_file);

		static Unix ()
		{

		}

		// There is no SpecialFolder support for videos. We have to read the xdg configuration directly
		public static string GetDefaultVideoDirectory ()
		{
			string directory = null, line;
			const string home = "$HOME/";
			const string key = "XDG_VIDEOS_DIR";
			string home_dir = Environment.GetEnvironmentVariable ("HOME");
			string config_file;

			try {
				config_file = Path.Combine (home_dir, ".config/user-dirs.dirs");

				using (StreamReader reader = new StreamReader (config_file))
				{
					while ((line = reader.ReadLine ()) != null) 
					{
						line = line.Trim ();
						int pos = line.IndexOf ('=');
				                if (pos > 8 && line.Substring (0, pos) == key) {
							string path = line.Substring (pos + 1).Trim ('"');
							bool relative = false;

							if (path.StartsWith (home)) {
								relative = true;
								path = path.Substring (home.Length);
							} else if (!path.StartsWith ("/"))
								relative = true;

			                    		directory = relative ? Path.Combine (home_dir, path) : path;
							break;
						}
		                	}
				}
			}
			catch (Exception) { }

			if (directory == null)
				return Environment.GetFolderPath (Environment.SpecialFolder.Personal);
			else
				return directory;
		}

		static public void LaunchTool (string app, string args, string in_file, string out_file, string err_file)
		{
			mistelix_launchtool (app, args, in_file, out_file, err_file);
		}
	}
}
