/***************************************************************************
                          dlgprefvinyl.cpp  -  description
                             -------------------
    begin                : Thu Oct 23 2006
    copyright            : (C) 2006 by Stefan Langhammer
    email                : stefan.langhammer@9elements.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


//////////////////////////////////////////////////////////////
// Currently the Input Device selection is disabled. You can 
// just select the input stereo channels of the Output device.
// Feel free to implement it !
//////////////////////////////////////////////////////////////


#include "dlgprefvinyl.h"
#include "playerproxy.h"
#include <qcombobox.h>
#include <qcheckbox.h>
#include <qpushbutton.h>
#include <qslider.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qmessagebox.h>
#include <qthread.h>
#include "controlobject.h"
#include <qwidget.h>

DlgPrefVinyl::DlgPrefVinyl(QWidget *parent, PlayerProxy *_player,
                           ConfigObject<ConfigValue> *_config) : DlgPrefVinylDlg(parent,"")
{
    player = _player;
    config = _config;

	// Disable Input Device selection (see note at the top)
	ComboBoxDeviceDeck1->setEnabled( FALSE );
	ComboBoxDeviceDeck2->setEnabled( FALSE );

	// Disabled Input Device selection (see note at the top)
	/*
    connect(ComboBoxDeviceDeck1,  SIGNAL(activated(int)),    this, SLOT(slotApply()));
    connect(ComboBoxDeviceDeck2,  SIGNAL(activated(int)),    this, SLOT(slotApply()));
	*/

	// Connect event handler
	connect(ComboBoxChannelsDeck1, SIGNAL(activated(int)), this, SLOT(ChannelsSlotApply()));
	connect(ComboBoxChannelsDeck2, SIGNAL(activated(int)), this, SLOT(ChannelsSlotApply()));
	connect(EnableRIAA,            SIGNAL(stateChanged(int)), this, SLOT(EnableRIAASlotApply()));
	connect(RelativeMode,		   SIGNAL(stateChanged(int)), this, SLOT(EnableRelativeModeSlotApply()));
	connect(AutoCalibration,	   SIGNAL(clicked()),		  this, SLOT(AutoCalibrationSlotApply()));
	connect(LeadinTime,			   SIGNAL( lostFocus ()),	  this, SLOT(slotApply()));
	connect(ComboBoxVinylType,	   SIGNAL(activated(int)),	  this, SLOT(VinylTypeSlotApply()));

	// TODO: Enable this button; add two more text boxes for gain&precision; run the calibration test of Scratchlib
	AutoCalibration->setEnabled( FALSE );

	// Disable output text box
	precision->setEnabled( FALSE );
	gain->setEnabled( FALSE );

	// Add vinyl types
	ComboBoxVinylType->insertItem("NI FinalScratch");
	ComboBoxVinylType->insertItem("Mixvibes DVS CD Version");
}

DlgPrefVinyl::~DlgPrefVinyl()
{
}

void DlgPrefVinyl::slotUpdate()
{
	// Enable/Disable RIAA Correction checkbox
    int iEnableRIAA = config->getValueString(ConfigKey("[Soundcard]","bInputRIAACorrection")).toInt();
    if (iEnableRIAA)
        EnableRIAA->setChecked(true);
    else
        EnableRIAA->setChecked(false);

	// Update device list
    QStringList interfaces = player->getInterfaces();
    QStringList::iterator it;
    int j;

    // Decks input devices
    ComboBoxDeviceDeck1->clear();
    ComboBoxDeviceDeck1->insertItem("None");
	ComboBoxDeviceDeck2->clear();
    ComboBoxDeviceDeck2->insertItem("None");
    it = interfaces.begin();
    j = 1;
    while (it!=interfaces.end())
    {
        ComboBoxDeviceDeck1->insertItem((*it));
		ComboBoxDeviceDeck2->insertItem((*it));
        if ((*it)==config->getValueString(ConfigKey("[Soundcard]","DeviceMasterLeft")))
		{
            ComboBoxDeviceDeck1->setCurrentItem(j);
			ComboBoxDeviceDeck2->setCurrentItem(j);
		}
        ++j;
        ++it;
    }

	// Get input channels of the current device
	ComboBoxChannelsDeck1->clear();
	ComboBoxChannelsDeck2->clear();
	//ALBERT changed this (Dec 21) temporarily:
	int channels; //= player->getInputChannelsCount();
	channels = 0;
	QString channelname = "";

	for (int i = 0; i < channels; i+=2)
	{
		channelname = QString( "%1 / %2" ).arg( i+1 ).arg( i+2 );    

		ComboBoxChannelsDeck1->insertItem(channelname);
		ComboBoxChannelsDeck2->insertItem(channelname);

		if (channelname == config->getValueString(ConfigKey("[Soundcard]","strInputChannelsDeck1")))
			ComboBoxChannelsDeck1->setCurrentItem(i/2);
		if (channelname == config->getValueString(ConfigKey("[Soundcard]","strInputChannelsDeck2")))
			ComboBoxChannelsDeck2->setCurrentItem(i/2);
	}

	// Set vinyl control types
	if (config->getValueString(ConfigKey("[Soundcard]","strVinylType")) == "NI FinalScratch")
		ComboBoxVinylType->setCurrentItem(0);
	else if (config->getValueString(ConfigKey("[Soundcard]","strVinylType")) == "Mixvibes DVS CD Version")
		ComboBoxVinylType->setCurrentItem(1);
	else // see the ctor for correct vinyl type names
	{
	//	QMessageBox::warning(this,"Scratchlib vinyl selection","Vinyl type not properly installed");
		//Set up defaults
		ComboBoxVinylType->setCurrentItem(0);		
	}


	// set lead-in time
	LeadinTime->setText (config->getValueString(ConfigKey("[Soundcard]","iLeadInTime")) );

	// set Relative mode
	 int iRelativeMode = config->getValueString(ConfigKey("[Soundcard]","bRelativeMode")).toInt();
    if (iRelativeMode)
        RelativeMode->setChecked(true);
    else
        RelativeMode->setChecked(false);
}


 // Update the config object with parameters from dialog
void DlgPrefVinyl::slotApply()
{
	qDebug("DlgPrefVinyl::Apply");

    // Lead-in time
	 QString strLeadIn	= LeadinTime->text();
	 bool isInteger;
	 int	 iLeadIn	= strLeadIn.toInt(&isInteger);
	 if (isInteger)
	    config->set(ConfigKey("[Soundcard]","iLeadInTime"), strLeadIn);
	 else
		config->set(ConfigKey("[Soundcard]","iLeadInTime"), 30);

	 // Apply Soundcard options
	 /*
	player->close();
    if (config->getValueString(ConfigKey("[Soundcard]","SoundApi"))=="None" || !player->open())
        QMessageBox::warning(0, "Configuration error","Audio device could not be opened");
    else*/
        slotUpdate();
}

void DlgPrefVinyl::ChannelsSlotApply()
{
	// Channels
	config->set(ConfigKey("[Soundcard]","strInputChannelsDeck1"), ConfigValue(ComboBoxChannelsDeck1->currentText()));
	config->set(ConfigKey("[Soundcard]","strInputChannelsDeck2"), ConfigValue(ComboBoxChannelsDeck2->currentText()));
}

void DlgPrefVinyl::EnableRIAASlotApply()
{
	// Input RIAA correction
	 if (EnableRIAA->isChecked())
        config->set(ConfigKey("[Soundcard]","bInputRIAACorrection"), ConfigValue(1));
    else
        config->set(ConfigKey("[Soundcard]","bInputRIAACorrection"), ConfigValue(0));
}

void DlgPrefVinyl::EnableRelativeModeSlotApply()
{
		// Relative vinyl mode
	 if (RelativeMode->isChecked())
        config->set(ConfigKey("[Soundcard]","bRelativeMode"), ConfigValue(1));
    else
        config->set(ConfigKey("[Soundcard]","bRelativeMode"), ConfigValue(0));
}
void DlgPrefVinyl::VinylTypeSlotApply()
{
	config->set(ConfigKey("[Soundcard]","strVinylType"), ConfigValue(ComboBoxVinylType->currentText()));
}

void DlgPrefVinyl::AutoCalibrationSlotApply()
{
	// Do the scratchlib calibration steps.
}

