/***************************************************************************
                          vinylcontrol.h -  description
                             -------------------
    begin                : Tue June 6 2006
    copyright            : (C) 2006 by Albert Santoni
    email                : 
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef VINYLCONTROL_H
#define VINYLCONTROL_H

#include <qsemaphore.h>
#include <qthread.h>
#include "dscratch.h"
#include "enginebuffer.h"

#define MIXXX_VINYLTYPE 0			//The type of timecoded vinyl used. (FinalScratch currently)
#define MIXXX_VINYL_LEADIN 25 		//Number of seconds of lead-in time on the timecoded vinyl
#define MIXXX_SOUNDDEVICE 0		 	//The index of the sound device that the turntable's hooked into.
#define MIXXX_ACTIVECHANNELS 2 		//The number of active channels on the soundcard input.
#define MIXXX_RIAA_CORRECTION true	//Whether or not to apply RIAA correction to the vinyl's signal.
#define MIXXX_CALIBRATION_VALUE 1.30 //The calibration value for scratchlib.

class VinylControl : public QThread
{
public:
    VinylControl();
	VinylControl(const char *_group, EngineBuffer* _buffer);
    ~VinylControl();
    void close();
    bool isNeedleInBounds();
	void syncPitch();
	bool syncPosition();
protected:
	virtual void run();  // main thread loop

private:
	DScratch *scratch;			//This is our main interface to scratchlib.
	EngineBuffer* buffer;		//A pointer to the EngineBuffer object we're manipulating.
	const char* group;			//The "group" number/ID that this corresponds to (ie. which engine buffer to manipulate)
	ControlObject *playButton;	//The ControlObject used to start/stop playback of the song.
	ControlObject *playPos;    	//The ControlObject used to change the playback position in the song.
	ControlObject *controlScratch; //The ControlObject used to seek when the record is spinning fast.
	ControlObject *rateSlider;     //The ControlObject used to change the speed/pitch of the song.
	double dFileLength; 	//The length (in samples) of the current song.
	double dVinylPitch; 	//The speed/pitch of the timecoded vinyl as read by scratchlib.
	double dVinylPosition; 	//The position of the needle on the record as read by scratchlib.
	double dOldPos;   		//The position read last time it was polled.
	double dOldDiff;  		//The old difference between the positions. (used to check if the needle's on the record...)
	bool bNeedleDown; 		//Is the needle on the record? (used for needle dropping)
	bool bSeeking; 			//Are we seeking through the record? (ie. is it moving really fast?)
	bool bQuit;				//Triggers the end of the vinylcontrol monitoring loop...
};

#endif
