/*
   mkvmerge -- utility for splicing together matroska files
   from component media subtypes

   Distributed under the GPL v2
   see the file COPYING for details
   or visit https://www.gnu.org/licenses/old-licenses/gpl-2.0.html

   ISO 639 language definitions, lookup functions

   Written by Moritz Bunkus <moritz@bunkus.org>.
*/

// -----------------------------------------------------------------------
// NOTE: this file is auto-generated by the "dev:iso639_list" rake target.
// -----------------------------------------------------------------------

#include "common/iso639_types.h"

using namespace std::string_literals;

namespace mtx::iso639 {

std::vector<language_t> g_languages;

void
init() {
  g_languages.reserve(7143);

  g_languages.emplace_back(u8"!Xóõ"s,                                                                             "nmn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"'Are'are"s,                                                                         "alu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"'Auhelawa"s,                                                                        "kud"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"//Ani"s,                                                                            "hnh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"//Gana"s,                                                                           "gnk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"/Gwi"s,                                                                             "gwj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"=/Hua"s,                                                                            "huc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"A'ou"s,                                                                             "aou"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"A-Pucikwar"s,                                                                       "apq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Aari"s,                                                                             "aiw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Aasáx"s,                                                                            "aas"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Abadi"s,                                                                            "kbt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Abaga"s,                                                                            "abg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Abai Sungai"s,                                                                      "abf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Abanyom"s,                                                                          "abm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Abar"s,                                                                             "mij"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Abau"s,                                                                             "aau"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Abaza"s,                                                                            "abq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Abellen Ayta"s,                                                                     "abp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Abidji"s,                                                                           "abi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Abinomn"s,                                                                          "bsa"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Abkhazian"s,                                                                        "abk"s,   "ab"s, ""s,    true );
  g_languages.emplace_back(u8"Abom"s,                                                                             "aob"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Abon"s,                                                                             "abo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Abron"s,                                                                            "abr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Abu"s,                                                                              "ado"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Abu' Arapesh"s,                                                                     "aah"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Abua"s,                                                                             "abn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Abui"s,                                                                             "abz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Abun"s,                                                                             "kgr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Abure"s,                                                                            "abu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Abureni"s,                                                                          "mgj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Abé"s,                                                                              "aba"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Acatepec Me'phaa"s,                                                                 "tpx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Achagua"s,                                                                          "aca"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Achang"s,                                                                           "acn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ache"s,                                                                             "yif"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Acheron"s,                                                                          "acz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Achi"s,                                                                             "acr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Achinese"s,                                                                         "ace"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Achterhoeks"s,                                                                      "act"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Achuar-Shiwiar"s,                                                                   "acu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Achumawi"s,                                                                         "acv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Aché"s,                                                                             "guq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Acoli"s,                                                                            "ach"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Adabe"s,                                                                            "adb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Adamawa Fulfulde"s,                                                                 "fub"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Adamorobe Sign Language"s,                                                          "ads"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Adang"s,                                                                            "adn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Adangbe"s,                                                                          "adq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Adangme"s,                                                                          "ada"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Adara"s,                                                                            "kad"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Adasen"s,                                                                           "tiu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Adele"s,                                                                            "ade"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Adhola"s,                                                                           "adh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Adi"s,                                                                              "adi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Adilabad Gondi"s,                                                                   "wsg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Adioukrou"s,                                                                        "adj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Adivasi Oriya"s,                                                                    "ort"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Adiwasi Garasia"s,                                                                  "gas"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Adnyamathanha"s,                                                                    "adt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Adonara"s,                                                                          "adr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Aduge"s,                                                                            "adu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Adyghe; Adygei"s,                                                                   "ady"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Adzera"s,                                                                           "adz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Aeka"s,                                                                             "aez"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Aekyom"s,                                                                           "awi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Aer"s,                                                                              "aeq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Afade"s,                                                                            "aal"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Afar"s,                                                                             "aar"s,   "aa"s, ""s,    true );
  g_languages.emplace_back(u8"Afghan Sign Language"s,                                                             "afg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Afitti"s,                                                                           "aft"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Afrihili"s,                                                                         "afh"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Afrikaans"s,                                                                        "afr"s,   "af"s, ""s,    true );
  g_languages.emplace_back(u8"Afro-Asiatic languages"s,                                                           "afa"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Afro-Seminole Creole"s,                                                             "afs"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Agarabi"s,                                                                          "agd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Agariya"s,                                                                          "agi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Agatu"s,                                                                            "agc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Aghem"s,                                                                            "agq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Aghu"s,                                                                             "ahh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Aghul"s,                                                                            "agx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Agi"s,                                                                              "aif"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Agob"s,                                                                             "kit"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Agoi"s,                                                                             "ibm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Aguacateco"s,                                                                       "agu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Aguaruna"s,                                                                         "agr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Aguna"s,                                                                            "aug"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Agusan Manobo"s,                                                                    "msm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Agutaynen"s,                                                                        "agn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Agwagwune"s,                                                                        "yay"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ahanta"s,                                                                           "aha"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Aheri Gondi"s,                                                                      "esg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Aheu"s,                                                                             "thm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ahirani"s,                                                                          "ahr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ahtena"s,                                                                           "aht"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ahwai"s,                                                                            "nfd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ai-Cham"s,                                                                          "aih"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Aighon"s,                                                                           "aix"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Aikanã"s,                                                                           "tba"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Aiklep"s,                                                                           "mwg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Aimaq"s,                                                                            "aiq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Aimele"s,                                                                           "ail"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Aimol"s,                                                                            "aim"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ainbai"s,                                                                           "aic"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ainu (China)"s,                                                                     "aib"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ainu"s,                                                                             "ain"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Aiome"s,                                                                            "aki"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Airoran"s,                                                                          "air"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Aiton"s,                                                                            "aio"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Aja (Benin)"s,                                                                      "ajg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Aja (Sudan)"s,                                                                      "aja"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ajië"s,                                                                             "aji"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ajumbu"s,                                                                           "muc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ajyíninka Apurucayali"s,                                                            "cpc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ak"s,                                                                               "akq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Aka"s,                                                                              "soh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Akan"s,                                                                             "aka"s,   "ak"s, ""s,    true );
  g_languages.emplace_back(u8"Akaselem"s,                                                                         "aks"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Akawaio"s,                                                                          "ake"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ake"s,                                                                              "aik"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Akebu"s,                                                                            "keu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Akei"s,                                                                             "tsr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Akeu"s,                                                                             "aeu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Akha"s,                                                                             "ahk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Akhvakh"s,                                                                          "akv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Akkadian"s,                                                                         "akk"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Aklanon"s,                                                                          "akl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Akolet"s,                                                                           "akt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Akoose"s,                                                                           "bss"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Akoye"s,                                                                            "miw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Akpa"s,                                                                             "akf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Akpes"s,                                                                            "ibe"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Akrukay"s,                                                                          "afi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Akukem"s,                                                                           "spm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Akuku"s,                                                                            "ayk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Akum"s,                                                                             "aku"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Akuntsu"s,                                                                          "aqz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Akurio"s,                                                                           "ako"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Akwa"s,                                                                             "akw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Akyaung Ari Naga"s,                                                                 "nqy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Al-Sayyid Bedouin Sign Language"s,                                                  "syy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Alaba-K’abeena"s,                                                                   "alw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Alabama"s,                                                                          "akz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Alabat Island Agta"s,                                                               "dul"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Alacatlatzala Mixtec"s,                                                             "mim"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Alago"s,                                                                            "ala"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Alagwa"s,                                                                           "wbj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Alak"s,                                                                             "alk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Alamblak"s,                                                                         "amp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Alangan"s,                                                                          "alj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Alawa"s,                                                                            "alh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Albanian Sign Language"s,                                                           "sqk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Albanian"s,                                                                         "alb"s,   "sq"s, "sqi"s, true );
  g_languages.emplace_back(u8"Alcozauca Mixtec"s,                                                                 "xta"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Alege"s,                                                                            "alf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Alekano"s,                                                                          "gah"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Aleut"s,                                                                            "ale"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Algerian Arabic"s,                                                                  "arq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Algerian Saharan Arabic"s,                                                          "aao"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Algerian Sign Language"s,                                                           "asp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Algonquian languages"s,                                                             "alg"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Algonquin"s,                                                                        "alq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ali"s,                                                                              "aiy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Alladian"s,                                                                         "ald"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Allar"s,                                                                            "all"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Alo Phola"s,                                                                        "ypo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Alor"s,                                                                             "aol"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Aloápam Zapotec"s,                                                                  "zaq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Altaic languages"s,                                                                 "tut"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Alu Kurumba"s,                                                                      "xua"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Alugu"s,                                                                            "aub"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Alumu-Tesu"s,                                                                       "aab"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Alune"s,                                                                            "alp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Aluo"s,                                                                             "yna"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Alur"s,                                                                             "alz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Alutor"s,                                                                           "alr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Alviri-Vidari"s,                                                                    "avd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Alyawarr"s,                                                                         "aly"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ama (Papua New Guinea)"s,                                                           "amm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ama (Sudan)"s,                                                                      "nyi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Amahai"s,                                                                           "amq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Amahuaca"s,                                                                         "amc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Amaimon"s,                                                                          "ali"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Amal"s,                                                                             "aad"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Amanab"s,                                                                           "amn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Amara"s,                                                                            "aie"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Amarakaeri"s,                                                                       "amr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Amarasi"s,                                                                          "aaz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Amatlán Zapotec"s,                                                                  "zpo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Amba (Solomon Islands)"s,                                                           "utp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Amba (Uganda)"s,                                                                    "rwm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ambai"s,                                                                            "amk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ambakich"s,                                                                         "aew"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ambala Ayta"s,                                                                      "abc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ambelau"s,                                                                          "amv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ambele"s,                                                                           "ael"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Amblong"s,                                                                          "alm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ambo"s,                                                                             "amb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ambo-Pasco Quechua"s,                                                               "qva"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ambonese Malay"s,                                                                   "abs"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ambrak"s,                                                                           "aag"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ambul"s,                                                                            "apo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ambulas"s,                                                                          "abt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Amdang"s,                                                                           "amj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Amdo Tibetan"s,                                                                     "adx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Amele"s,                                                                            "aey"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"American Sign Language"s,                                                           "ase"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Amganad Ifugao"s,                                                                   "ifa"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Amharic"s,                                                                          "amh"s,   "am"s, ""s,    true );
  g_languages.emplace_back(u8"Ami"s,                                                                              "amy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Amis"s,                                                                             "ami"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Amo"s,                                                                              "amo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Amol"s,                                                                             "alx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Amoltepec Mixtec"s,                                                                 "mbz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ampanang"s,                                                                         "apg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ampari Dogon"s,                                                                     "aqd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Amri Karbi"s,                                                                       "ajz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Amto"s,                                                                             "amt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Amundava"s,                                                                         "adw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Amurdak"s,                                                                          "amg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ana Tinga Dogon"s,                                                                  "dti"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Anaang"s,                                                                           "anw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Anakalangu"s,                                                                       "akg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Anal"s,                                                                             "anm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Anam"s,                                                                             "pda"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Anambé"s,                                                                           "aan"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Anamgura"s,                                                                         "imi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Anasi"s,                                                                            "bpo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Andaandi"s,                                                                         "dgl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Andai"s,                                                                            "afd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Andajin"s,                                                                          "ajn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Andaman Creole Hindi"s,                                                             "hca"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Andarum"s,                                                                          "aod"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Andegerebinha"s,                                                                    "adg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Andh"s,                                                                             "anr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Andi"s,                                                                             "ani"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Andio"s,                                                                            "bzb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Andoque"s,                                                                          "ano"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Andra-Hus"s,                                                                        "anx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Aneityum"s,                                                                         "aty"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Anem"s,                                                                             "anz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Aneme Wake"s,                                                                       "aby"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Anfillo"s,                                                                          "myo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Angaataha"s,                                                                        "agm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Angaité"s,                                                                          "aqt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Angal Enen"s,                                                                       "aoe"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Angal Heneng"s,                                                                     "akh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Angal"s,                                                                            "age"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Angami Naga"s,                                                                      "njm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Angguruk Yali"s,                                                                    "yli"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Angika"s,                                                                           "anp"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Angloromani"s,                                                                      "rme"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Angolar"s,                                                                          "aoa"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Angor"s,                                                                            "agg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Angoram"s,                                                                          "aog"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Angosturas Tunebo"s,                                                                "tnd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ani Phowa"s,                                                                        "ypn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Anii"s,                                                                             "blo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Animere"s,                                                                          "anf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Anindilyakwa"s,                                                                     "aoi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Anjam"s,                                                                            "boj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ankave"s,                                                                           "aak"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Anmatyerre"s,                                                                       "amx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Anong"s,                                                                            "nun"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Anor"s,                                                                             "anj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ansus"s,                                                                            "and"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Antakarinya"s,                                                                      "ant"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Antankarana Malagasy"s,                                                             "xmv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Antigua and Barbuda Creole English"s,                                               "aig"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Anu-Hkongso Chin"s,                                                                 "anl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Anuak"s,                                                                            "anu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Anufo"s,                                                                            "cko"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Anuki"s,                                                                            "aui"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Anus"s,                                                                             "auq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Anuta"s,                                                                            "aud"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Anyin Morofo"s,                                                                     "mtb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Anyin"s,                                                                            "any"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ao Naga"s,                                                                          "njo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Aoheng"s,                                                                           "pni"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ap Ma"s,                                                                            "kbx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Apache languages"s,                                                                 "apa"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Apalaí"s,                                                                           "apy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Apali"s,                                                                            "ena"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Apasco-Apoala Mixtec"s,                                                             "mip"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Apatani"s,                                                                          "apt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Apiaká"s,                                                                           "api"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Apinayé"s,                                                                          "apn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Apma"s,                                                                             "app"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Aproumu Aizi"s,                                                                     "ahp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Apurinã"s,                                                                          "apu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Aputai"s,                                                                           "apx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Arabela"s,                                                                          "arl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Arabic"s,                                                                           "ara"s,   "ar"s, ""s,    true );
  g_languages.emplace_back(u8"Aragonese"s,                                                                        "arg"s,   "an"s, ""s,    true );
  g_languages.emplace_back(u8"Araki"s,                                                                            "akr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Aralle-Tabulahan"s,                                                                 "atq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Arammba"s,                                                                          "stk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Aranadan"s,                                                                         "aaf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Arandai"s,                                                                          "jbj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Araona"s,                                                                           "aro"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Arapaho"s,                                                                          "arp"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Arawak"s,                                                                           "arw"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Araweté"s,                                                                          "awt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Arawum"s,                                                                           "awm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Arbore"s,                                                                           "arv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Arbëreshë Albanian"s,                                                               "aae"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Archi"s,                                                                            "aqc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Are"s,                                                                              "mwc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Arem"s,                                                                             "aem"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Arequipa-La Unión Quechua"s,                                                        "qxu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Argentine Sign Language"s,                                                          "aed"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Argobba"s,                                                                          "agj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Arguni"s,                                                                           "agf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Arhuaco"s,                                                                          "arh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Arhâ"s,                                                                             "aqr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Arhö"s,                                                                             "aok"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ari"s,                                                                              "aac"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Aribwaung"s,                                                                        "ylu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Arifama-Miniafia"s,                                                                 "aai"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Arigidi"s,                                                                          "aqg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Arikapú"s,                                                                          "ark"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Arikara"s,                                                                          "ari"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Aringa"s,                                                                           "luc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Armenian Sign Language"s,                                                           "aen"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Armenian"s,                                                                         "arm"s,   "hy"s, "hye"s, true );
  g_languages.emplace_back(u8"Aromanian; Arumanian; Macedo-Romanian"s,                                            "rup"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Arop-Lokep"s,                                                                       "apr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Arop-Sissano"s,                                                                     "aps"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Arosi"s,                                                                            "aia"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Arpitan"s,                                                                          "frp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Arta"s,                                                                             "atz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Artificial languages"s,                                                             "art"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Aruamu"s,                                                                           "msy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Aruek"s,                                                                            "aur"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Aruop"s,                                                                            "lsr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Arutani"s,                                                                          "atx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Aruá (Rodonia State)"s,                                                             "arx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Arvanitika Albanian"s,                                                              "aat"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"As"s,                                                                               "asz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Asaro'o"s,                                                                          "mtv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Asas"s,                                                                             "asd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ashe"s,                                                                             "ahs"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ashkun"s,                                                                           "ask"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Asho Chin"s,                                                                        "csh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ashtiani"s,                                                                         "atn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Asháninka"s,                                                                        "cni"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ashéninka Pajonal"s,                                                                "cjo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ashéninka Perené"s,                                                                 "prq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Asilulu"s,                                                                          "asl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Askopan"s,                                                                          "eiv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Asoa"s,                                                                             "asv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Assamese"s,                                                                         "asm"s,   "as"s, ""s,    true );
  g_languages.emplace_back(u8"Assangori"s,                                                                        "sjg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Assiniboine"s,                                                                      "asb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Assyrian Neo-Aramaic"s,                                                             "aii"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Asturian; Bable; Leonese; Asturleonese"s,                                           "ast"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Asu (Nigeria)"s,                                                                    "aum"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Asu (Tanzania)"s,                                                                   "asa"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Asue Awyu"s,                                                                        "psa"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Asumboa"s,                                                                          "aua"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Asunción Mixtepec Zapotec"s,                                                        "zoo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Asuri"s,                                                                            "asr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ata Manobo"s,                                                                       "atd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ata"s,                                                                              "atm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Atatláhuca Mixtec"s,                                                                "mib"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Atayal"s,                                                                           "tay"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Atemble"s,                                                                          "ate"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Athapascan languages"s,                                                             "ath"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Athpariya"s,                                                                        "aph"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ati"s,                                                                              "atk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Atikamekw"s,                                                                        "atj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Atohwaim"s,                                                                         "aqm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Atong (Cameroon)"s,                                                                 "ato"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Atong (India)"s,                                                                    "aot"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Atorada"s,                                                                          "aox"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Atsam"s,                                                                            "cch"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Atsugewi"s,                                                                         "atw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Attapady Kurumba"s,                                                                 "pkr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Attié"s,                                                                            "ati"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Atzingo Matlatzinca"s,                                                              "ocu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Au"s,                                                                               "avt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Aulua"s,                                                                            "aul"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Aushi"s,                                                                            "auh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Austral"s,                                                                          "aut"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Australian Aborigines Sign Language"s,                                              "asw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Australian Sign Language"s,                                                         "asf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Australian languages"s,                                                             "aus"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Austrian Sign Language"s,                                                           "asq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Austronesian languages"s,                                                           "map"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Auwe"s,                                                                             "smf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Auye"s,                                                                             "auu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Avaric"s,                                                                           "ava"s,   "av"s, ""s,    true );
  g_languages.emplace_back(u8"Avatime"s,                                                                          "avn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Avau"s,                                                                             "avb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Avestan"s,                                                                          "ave"s,   "ae"s, ""s,    true );
  g_languages.emplace_back(u8"Avikam"s,                                                                           "avi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Avokaya"s,                                                                          "avu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Avá-Canoeiro"s,                                                                     "avv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Awa (China)"s,                                                                      "vwa"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Awa (Papua New Guinea)"s,                                                           "awb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Awa-Cuaiquer"s,                                                                     "kwi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Awad Bing"s,                                                                        "bcu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Awadhi"s,                                                                           "awa"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Awak"s,                                                                             "awo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Awar"s,                                                                             "aya"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Awara"s,                                                                            "awx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Awbono"s,                                                                           "awh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Aweer"s,                                                                            "bob"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Awera"s,                                                                            "awr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Awetí"s,                                                                            "awe"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Awing"s,                                                                            "azo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Awiyaana"s,                                                                         "auy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Awjilah"s,                                                                          "auj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Awngi"s,                                                                            "awn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Awtuw"s,                                                                            "kmn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Awu"s,                                                                              "yiu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Awun"s,                                                                             "aww"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Awutu"s,                                                                            "afu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Awyi"s,                                                                             "auw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Axamb"s,                                                                            "ahb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Axi Yi"s,                                                                           "yix"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ayacucho Quechua"s,                                                                 "quy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ayautla Mazatec"s,                                                                  "vmy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ayere"s,                                                                            "aye"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ayi (Papua New Guinea)"s,                                                           "ayq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ayiwo"s,                                                                            "nfl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ayizi"s,                                                                            "yyz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ayizo Gbe"s,                                                                        "ayb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Aymara"s,                                                                           "aym"s,   "ay"s, ""s,    true );
  g_languages.emplace_back(u8"Ayoquesco Zapotec"s,                                                                "zaf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ayoreo"s,                                                                           "ayo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ayu"s,                                                                              "ayu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ayutla Mixtec"s,                                                                    "miy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Azerbaijani"s,                                                                      "aze"s,   "az"s, ""s,    true );
  g_languages.emplace_back(u8"Azha"s,                                                                             "aza"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Azhe"s,                                                                             "yiz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Azoyú Me'phaa"s,                                                                    "tpc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Baan"s,                                                                             "bvj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Baangi"s,                                                                           "bqx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Baatonum"s,                                                                         "bba"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Baba Malay"s,                                                                       "mbf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Baba"s,                                                                             "bbw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Babalia Creole Arabic"s,                                                            "bbz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Babango"s,                                                                          "bbm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Babanki"s,                                                                          "bbk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Babatana"s,                                                                         "baa"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Babine"s,                                                                           "bcr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Babuza"s,                                                                           "bzg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bacama"s,                                                                           "bcy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bacanese Malay"s,                                                                   "btj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bada (Indonesia)"s,                                                                 "bhz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bada (Nigeria)"s,                                                                   "bau"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Badaga"s,                                                                           "bfq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bade"s,                                                                             "bde"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Badeshi"s,                                                                          "bdz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Badimaya"s,                                                                         "bia"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Badui"s,                                                                            "bac"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Badyara"s,                                                                          "pbp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Baeggu"s,                                                                           "bvd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Baelelea"s,                                                                         "bvc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Baetora"s,                                                                          "btr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bafanji"s,                                                                          "bfj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bafaw-Balong"s,                                                                     "bwt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bafia"s,                                                                            "ksf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bafut"s,                                                                            "bfd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Baga Koga"s,                                                                        "bgo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Baga Manduri"s,                                                                     "bmd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Baga Pokur"s,                                                                       "bcg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Baga Sitemu"s,                                                                      "bsp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bagheli"s,                                                                          "bfy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bagirmi Fulfulde"s,                                                                 "fui"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bagirmi"s,                                                                          "bmi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bago-Kusuntu"s,                                                                     "bqg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bagri"s,                                                                            "bgq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bagupi"s,                                                                           "bpi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bagusa"s,                                                                           "bqb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bagvalal"s,                                                                         "kva"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Baha Buyang"s,                                                                      "yha"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Baham"s,                                                                            "bdw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bahamas Creole English"s,                                                           "bah"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Baharna Arabic"s,                                                                   "abv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bahau"s,                                                                            "bhv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bahinemo"s,                                                                         "bjh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bahing"s,                                                                           "bhj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bahnar"s,                                                                           "bdq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bahonsuai"s,                                                                        "bsu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bai"s,                                                                              "bdj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Baibai"s,                                                                           "bbf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Baikeno"s,                                                                          "bkx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Baima"s,                                                                            "bqh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Baimak"s,                                                                           "bmx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bainouk-Gunyaamolo"s,                                                               "bcz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bainouk-Gunyuño"s,                                                                  "bab"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bainouk-Samik"s,                                                                    "bcb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Baiso"s,                                                                            "bsw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Baissa Fali"s,                                                                      "fah"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bajan"s,                                                                            "bjs"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bajelani"s,                                                                         "bjm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Baka (Cameroon)"s,                                                                  "bkc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Baka (Sudan)"s,                                                                     "bdh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bakairí"s,                                                                          "bkq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bakaka"s,                                                                           "bqz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bakhtiari"s,                                                                        "bqi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Baki"s,                                                                             "bki"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bakoko"s,                                                                           "bkh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bakole"s,                                                                           "kme"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bakpinka"s,                                                                         "bbs"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bakumpai"s,                                                                         "bkr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bakwé"s,                                                                            "bjw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Balaesang"s,                                                                        "bls"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Balangao"s,                                                                         "blw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Balangingi"s,                                                                       "sse"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Balanta-Ganja"s,                                                                    "bjt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Balanta-Kentohe"s,                                                                  "ble"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Balantak"s,                                                                         "blz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Balau"s,                                                                            "blg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Baldemu"s,                                                                          "bdn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bali (Democratic Republic of Congo)"s,                                              "bcp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bali (Nigeria)"s,                                                                   "bcn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Balinese Malay"s,                                                                   "mhp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Balinese"s,                                                                         "ban"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Balkan Gagauz Turkish"s,                                                            "bgx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Balkan Romani"s,                                                                    "rmn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Balo"s,                                                                             "bqo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Baloi"s,                                                                            "biz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Balti"s,                                                                            "bft"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Baltic Romani"s,                                                                    "rml"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Baltic languages"s,                                                                 "bat"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Baluan-Pam"s,                                                                       "blq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Baluchi"s,                                                                          "bal"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Bamako Sign Language"s,                                                             "bog"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bamali"s,                                                                           "bbq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bambalang"s,                                                                        "bmo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bambam"s,                                                                           "ptu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bambara"s,                                                                          "bam"s,   "bm"s, ""s,    true );
  g_languages.emplace_back(u8"Bambassi"s,                                                                         "myf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bambili-Bambui"s,                                                                   "baw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bamenyam"s,                                                                         "bce"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bamileke languages"s,                                                               "bai"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Bamu"s,                                                                             "bcf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bamukumbit"s,                                                                       "bqt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bamun"s,                                                                            "bax"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bamunka"s,                                                                          "bvm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bamwe"s,                                                                            "bmg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ban Khor Sign Language"s,                                                           "bfk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bana"s,                                                                             "bcw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Banao Itneg"s,                                                                      "bjx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Banaro"s,                                                                           "byz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Banda (Indonesia)"s,                                                                "bnd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Banda Malay"s,                                                                      "bpq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Banda languages"s,                                                                  "bad"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Banda-Bambari"s,                                                                    "liy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Banda-Banda"s,                                                                      "bpd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Banda-Mbrès"s,                                                                      "bqk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Banda-Ndélé"s,                                                                      "bfl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Banda-Yangere"s,                                                                    "yaj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bandi"s,                                                                            "bza"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bandial"s,                                                                          "bqj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bandjalang"s,                                                                       "bdy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bangala"s,                                                                          "bxg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bangandu"s,                                                                         "bgf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bangba"s,                                                                           "bbe"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Banggai"s,                                                                          "bgz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bangi"s,                                                                            "bni"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bangime"s,                                                                          "dba"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bangka"s,                                                                           "mfb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bangolan"s,                                                                         "bgj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bangubangu"s,                                                                       "bnx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bangwinji"s,                                                                        "bsj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Baniwa"s,                                                                           "bwi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Banjar"s,                                                                           "bjn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bankagooma"s,                                                                       "bxw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bankal"s,                                                                           "jjr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bankan Tey Dogon"s,                                                                 "dbw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bankon"s,                                                                           "abb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bannoni"s,                                                                          "bcm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bantawa"s,                                                                          "bap"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bantayanon"s,                                                                       "bfx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bantik"s,                                                                           "bnq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bantoanon"s,                                                                        "bno"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bantu (Other)"s,                                                                    "bnt"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Baoulé"s,                                                                           "bci"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bara Malagasy"s,                                                                    "bhr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Baraamu"s,                                                                          "brd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Barai"s,                                                                            "bbb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Barakai"s,                                                                          "baj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Baram Kayan"s,                                                                      "kys"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Barama"s,                                                                           "bbg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Barambu"s,                                                                          "brm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Baramu"s,                                                                           "bmz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Barapasi"s,                                                                         "brp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Baras"s,                                                                            "brs"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Barasana-Eduria"s,                                                                  "bsn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Barclayville Grebo"s,                                                               "gry"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bardi"s,                                                                            "bcj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Barein"s,                                                                           "bva"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bargam"s,                                                                           "mlp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bari"s,                                                                             "bfa"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bariai"s,                                                                           "bch"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bariji"s,                                                                           "bjc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Barikanchi"s,                                                                       "bxo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Barikewa"s,                                                                         "jbk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Barok"s,                                                                            "bjk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Barombi"s,                                                                          "bbi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Barro Negro Tunebo"s,                                                               "tbn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Baruga"s,                                                                           "bjz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Baruya"s,                                                                           "byr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Barwe"s,                                                                            "bwg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Barzani Jewish Neo-Aramaic"s,                                                       "bjf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Barí"s,                                                                             "mot"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Basa (Nigeria)"s,                                                                   "bzw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Basa"s,                                                                             "bas"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Basa-Gurmana"s,                                                                     "buj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Basap"s,                                                                            "bdb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bashkardi"s,                                                                        "bsg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bashkir"s,                                                                          "bak"s,   "ba"s, ""s,    true );
  g_languages.emplace_back(u8"Basketo"s,                                                                          "bst"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Basque"s,                                                                           "baq"s,   "eu"s, "eus"s, true );
  g_languages.emplace_back(u8"Bassa"s,                                                                            "bsq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bassa-Kontagora"s,                                                                  "bsr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bassari"s,                                                                          "bsc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bassossi"s,                                                                         "bsi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bata"s,                                                                             "bta"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Batad Ifugao"s,                                                                     "ifb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Batak Alas-Kluet"s,                                                                 "btz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Batak Angkola"s,                                                                    "akb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Batak Dairi"s,                                                                      "btd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Batak Karo"s,                                                                       "btx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Batak Mandailing"s,                                                                 "btm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Batak Simalungun"s,                                                                 "bts"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Batak Toba"s,                                                                       "bbc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Batak languages"s,                                                                  "btk"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Batak"s,                                                                            "bya"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Batanga"s,                                                                          "bnm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Batek"s,                                                                            "btq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bateri"s,                                                                           "btv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bathari"s,                                                                          "bhm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bati (Cameroon)"s,                                                                  "btc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bati (Indonesia)"s,                                                                 "bvt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bats"s,                                                                             "bbl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Batu"s,                                                                             "btu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Batui"s,                                                                            "zbt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Batuley"s,                                                                          "bay"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Batyala"s,                                                                          "xby"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bau Bidayuh"s,                                                                      "sne"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bau"s,                                                                              "bbd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bauchi"s,                                                                           "bsf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Baure"s,                                                                            "brg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bauria"s,                                                                           "bge"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bauwaki"s,                                                                          "bwk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bauzi"s,                                                                            "bvz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bavarian"s,                                                                         "bar"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bawm Chin"s,                                                                        "bgr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Baybayanon"s,                                                                       "bvy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bayono"s,                                                                           "byl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bayot"s,                                                                            "bda"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bayungu"s,                                                                          "bxj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bazigar"s,                                                                          "bfr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Beami"s,                                                                            "beo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Beaver"s,                                                                           "bea"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Beba"s,                                                                             "bfp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bebele"s,                                                                           "beb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bebeli"s,                                                                           "bek"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bebil"s,                                                                            "bxp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bedjond"s,                                                                          "bjv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bedoanas"s,                                                                         "bed"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Beeke"s,                                                                            "bkf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Beele"s,                                                                            "bxq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Beembe"s,                                                                           "beq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Beezen"s,                                                                           "bnz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Befang"s,                                                                           "bby"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Beja; Bedawiyet"s,                                                                  "bej"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Bekati'"s,                                                                          "bei"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bekwarra"s,                                                                         "bkv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bekwel"s,                                                                           "bkw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Belait"s,                                                                           "beg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Belanda Bor"s,                                                                      "bxb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Belanda Viri"s,                                                                     "bvi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Belarusian"s,                                                                       "bel"s,   "be"s, ""s,    true );
  g_languages.emplace_back(u8"Belhariya"s,                                                                        "byw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Beli (Papua New Guinea)"s,                                                          "bey"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Beli (Sudan)"s,                                                                     "blm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Belize Kriol English"s,                                                             "bzj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bella Coola"s,                                                                      "blc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bellari"s,                                                                          "brw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bemba"s,                                                                            "bem"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Bembe"s,                                                                            "bmb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ben Tey Dogon"s,                                                                    "dbt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bena (Nigeria)"s,                                                                   "yun"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bena (Tanzania)"s,                                                                  "bez"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Benabena"s,                                                                         "bef"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bench"s,                                                                            "bcq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bende"s,                                                                            "bdp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bendi"s,                                                                            "bct"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Beng"s,                                                                             "nhb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Benga"s,                                                                            "bng"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bengali"s,                                                                          "ben"s,   "bn"s, ""s,    true );
  g_languages.emplace_back(u8"Benggoi"s,                                                                          "bgy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bengkala Sign Language"s,                                                           "bqy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bentong"s,                                                                          "bnu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Benyadu'"s,                                                                         "byd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bepour"s,                                                                           "bie"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bera"s,                                                                             "brf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Berakou"s,                                                                          "bxv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Berau Malay"s,                                                                      "bve"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Berber languages"s,                                                                 "ber"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Berik"s,                                                                            "bkl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Berinomo"s,                                                                         "bit"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Berom"s,                                                                            "bom"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Berta"s,                                                                            "wti"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Besisi"s,                                                                           "mhe"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Besme"s,                                                                            "bes"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Besoa"s,                                                                            "bep"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Betaf"s,                                                                            "bfe"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Betawi"s,                                                                           "bew"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bete"s,                                                                             "byf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bete-Bendi"s,                                                                       "btt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Beti (Côte d'Ivoire)"s,                                                             "eot"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Betta Kurumba"s,                                                                    "xub"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bezhta"s,                                                                           "kap"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bhadrawahi"s,                                                                       "bhd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bhalay"s,                                                                           "bhx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bharia"s,                                                                           "bha"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bhatri"s,                                                                           "bgw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bhattiyali"s,                                                                       "bht"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bhaya"s,                                                                            "bhe"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bhele"s,                                                                            "bhy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bhilali"s,                                                                          "bhi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bhili"s,                                                                            "bhb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bhojpuri"s,                                                                         "bho"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Bhoti Kinnauri"s,                                                                   "nes"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bhujel"s,                                                                           "byh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bhunjia"s,                                                                          "bhu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Biafada"s,                                                                          "bif"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Biage"s,                                                                            "bdf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Biak"s,                                                                             "bhw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Biali"s,                                                                            "beh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bian Marind"s,                                                                      "bpv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Biangai"s,                                                                          "big"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Biao Mon"s,                                                                         "bmt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Biao"s,                                                                             "byk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Biao-Jiao Mien"s,                                                                   "bje"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Biatah Bidayuh"s,                                                                   "bth"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bidiyo"s,                                                                           "bid"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bidyara"s,                                                                          "bym"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bidyogo"s,                                                                          "bjg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Biem"s,                                                                             "bmc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bierebo"s,                                                                          "bnk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bieria"s,                                                                           "brj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Biete"s,                                                                            "biu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Big Nambas"s,                                                                       "nmb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Biga"s,                                                                             "bhc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bihari languages"s,                                                                 "bih"s,   "bh"s, ""s,    true );
  g_languages.emplace_back(u8"Bijori"s,                                                                           "bix"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bikaru"s,                                                                           "bic"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bikol"s,                                                                            "bik"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Bikya"s,                                                                            "byb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bila"s,                                                                             "bip"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bilakura"s,                                                                         "bql"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bilaspuri"s,                                                                        "kfs"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bilba"s,                                                                            "bpz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bilbil"s,                                                                           "brz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bile"s,                                                                             "bil"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bilma Kanuri"s,                                                                     "bms"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bilua"s,                                                                            "blb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bilur"s,                                                                            "bxf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bima"s,                                                                             "bhp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bimin"s,                                                                            "bhl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bimoba"s,                                                                           "bim"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bina (Nigeria)"s,                                                                   "byj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Binahari"s,                                                                         "bxz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Binandere"s,                                                                        "bhg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bine"s,                                                                             "bon"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bini; Edo"s,                                                                        "bin"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Binji"s,                                                                            "bpj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Binongan Itneg"s,                                                                   "itb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bintauna"s,                                                                         "bne"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bintulu"s,                                                                          "bny"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Binukid"s,                                                                          "bkd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Binumarien"s,                                                                       "bjr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bipi"s,                                                                             "biq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Birale"s,                                                                           "bxe"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Birao"s,                                                                            "brr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Birgit"s,                                                                           "btf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Birhor"s,                                                                           "biy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Biritai"s,                                                                          "bqq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Birri"s,                                                                            "bvq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Birwa"s,                                                                            "brl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Biseni"s,                                                                           "ije"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bishnupriya"s,                                                                      "bpy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bishuo"s,                                                                           "bwh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bisis"s,                                                                            "bnw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bislama"s,                                                                          "bis"s,   "bi"s, ""s,    true );
  g_languages.emplace_back(u8"Bisorio"s,                                                                          "bir"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bissa"s,                                                                            "bib"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bisu"s,                                                                             "bzi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bit"s,                                                                              "bgk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bitare"s,                                                                           "brt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bitur"s,                                                                            "mcc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Biwat"s,                                                                            "bwm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Biyo"s,                                                                             "byo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Biyom"s,                                                                            "bpm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Blablanga"s,                                                                        "blp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Blafe"s,                                                                            "bfh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Blagar"s,                                                                           "beu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Blang"s,                                                                            "blr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Blin; Bilin"s,                                                                      "byn"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Blissymbols; Blissymbolics; Bliss"s,                                                "zbl"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Bo (Laos)"s,                                                                        "bgl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bo (Papua New Guinea)"s,                                                            "bpw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bo-Rukul"s,                                                                         "mae"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bo-Ung"s,                                                                           "mux"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Boano (Maluku)"s,                                                                   "bzn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Boano (Sulawesi)"s,                                                                 "bzl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bobongko"s,                                                                         "bgb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bobot"s,                                                                            "bty"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bodo (Central African Republic)"s,                                                  "boy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bodo (India)"s,                                                                     "brx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bodo Gadaba"s,                                                                      "gbj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bodo Parja"s,                                                                       "bdv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bofi"s,                                                                             "bff"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Boga"s,                                                                             "bvw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bogaya"s,                                                                           "boq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Boghom"s,                                                                           "bux"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Boguru"s,                                                                           "bqu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bohtan Neo-Aramaic"s,                                                               "bhn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Boikin"s,                                                                           "bzf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bokha"s,                                                                            "ybk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bokmål, Norwegian; Norwegian Bokmål"s,                                              "nob"s,   "nb"s, ""s,    true );
  g_languages.emplace_back(u8"Boko (Benin)"s,                                                                     "bqc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Boko (Democratic Republic of Congo)"s,                                              "bkp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bokobaru"s,                                                                         "bus"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bokoto"s,                                                                           "bdt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bokyi"s,                                                                            "bky"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bola"s,                                                                             "bnp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bolango"s,                                                                          "bld"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bole"s,                                                                             "bol"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bolgo"s,                                                                            "bvo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bolia"s,                                                                            "bli"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bolinao"s,                                                                          "smk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bolivian Sign Language"s,                                                           "bvl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bolo"s,                                                                             "blv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Boloki"s,                                                                           "bkt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bolon"s,                                                                            "bof"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bolondo"s,                                                                          "bzm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bolongan"s,                                                                         "blj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bolyu"s,                                                                            "ply"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bom"s,                                                                              "bmf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Boma"s,                                                                             "boh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bomboli"s,                                                                          "bml"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bomboma"s,                                                                          "bws"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bomitaba"s,                                                                         "zmx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bomu"s,                                                                             "bmq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bomwali"s,                                                                          "bmw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bon Gula"s,                                                                         "glc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bonan"s,                                                                            "peh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bondei"s,                                                                           "bou"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bondo"s,                                                                            "bfw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bondoukou Kulango"s,                                                                "kzc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bondum Dom Dogon"s,                                                                 "dbu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bonerate"s,                                                                         "bna"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bonerif"s,                                                                          "bnv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bonggi"s,                                                                           "bdg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bonggo"s,                                                                           "bpg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bongili"s,                                                                          "bui"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bongo"s,                                                                            "bot"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bongu"s,                                                                            "bpu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bonjo"s,                                                                            "bok"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bonkeng"s,                                                                          "bvg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bonkiman"s,                                                                         "bop"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bontok"s,                                                                           "bnc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bookan"s,                                                                           "bnb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Boon"s,                                                                             "bnl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Boor"s,                                                                             "bvf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bora"s,                                                                             "boa"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Borana-Arsi-Guji Oromo"s,                                                           "gax"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Border Kuna"s,                                                                      "kvn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Borei"s,                                                                            "gai"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Borgu Fulfulde"s,                                                                   "fue"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Boro (Ethiopia)"s,                                                                  "bwo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Borong"s,                                                                           "ksr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Boruca"s,                                                                           "brn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Borôro"s,                                                                           "bor"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Boselewa"s,                                                                         "bwf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bosngun"s,                                                                          "bqs"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bosnian"s,                                                                          "bos"s,   "bs"s, ""s,    true );
  g_languages.emplace_back(u8"Bote-Majhi"s,                                                                       "bmj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Botlikh"s,                                                                          "bph"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Botolan Sambal"s,                                                                   "sbl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bouna Kulango"s,                                                                    "nku"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bouyei"s,                                                                           "pcc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bozaba"s,                                                                           "bzo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bragat"s,                                                                           "aof"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Brahui"s,                                                                           "brh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Braj"s,                                                                             "bra"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Brazilian Sign Language"s,                                                          "bzs"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Brem"s,                                                                             "buq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Breri"s,                                                                            "brq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Breton"s,                                                                           "bre"s,   "br"s, ""s,    true );
  g_languages.emplace_back(u8"Bribri"s,                                                                           "bzd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"British Sign Language"s,                                                            "bfi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Brokkat"s,                                                                          "bro"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Brokpake"s,                                                                         "sgt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Brokskat"s,                                                                         "bkk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Brooke's Point Palawano"s,                                                          "plw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Broome Pearling Lugger Pidgin"s,                                                    "bpl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Brunei Bisaya"s,                                                                    "bsb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Brunei"s,                                                                           "kxd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bu"s,                                                                               "jid"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bu-Nao Bunu"s,                                                                      "bwx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bua"s,                                                                              "bub"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bualkhaw Chin"s,                                                                    "cbl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Buamu"s,                                                                            "box"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bube"s,                                                                             "bvb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bubi"s,                                                                             "buw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bubia"s,                                                                            "bbx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Budeh Stieng"s,                                                                     "stt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Budibud"s,                                                                          "btp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Budong-Budong"s,                                                                    "bdx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Budu"s,                                                                             "buu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Budukh"s,                                                                           "bdk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Buduma"s,                                                                           "bdm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Budza"s,                                                                            "bja"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bugan"s,                                                                            "bbh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bugawac"s,                                                                          "buk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bughotu"s,                                                                          "bgt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Buginese"s,                                                                         "bug"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Buglere"s,                                                                          "sab"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bugun"s,                                                                            "bgg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Buhi'non Bikol"s,                                                                   "ubl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Buhid"s,                                                                            "bku"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Buhutu"s,                                                                           "bxh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bukar-Sadung Bidayuh"s,                                                             "sdo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bukat"s,                                                                            "bvk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bukharic"s,                                                                         "bhh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bukit Malay"s,                                                                      "bvu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bukitan"s,                                                                          "bkn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bukiyip"s,                                                                          "ape"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Buksa"s,                                                                            "tkb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bukusu"s,                                                                           "bxk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bukwen"s,                                                                           "buz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bulgarian Sign Language"s,                                                          "bqn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bulgarian"s,                                                                        "bul"s,   "bg"s, ""s,    true );
  g_languages.emplace_back(u8"Bulgebi"s,                                                                          "bmp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Buli (Ghana)"s,                                                                     "bwu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Buli (Indonesia)"s,                                                                 "bzq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bullom So"s,                                                                        "buy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bulo Stieng"s,                                                                      "sti"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bulu (Cameroon)"s,                                                                  "bum"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bulu (Papua New Guinea)"s,                                                          "bjl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bum"s,                                                                              "bmv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bumaji"s,                                                                           "byp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bumang"s,                                                                           "bvp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bumbita Arapesh"s,                                                                  "aon"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bumthangkha"s,                                                                      "kjz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bun"s,                                                                              "buv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Buna"s,                                                                             "bvn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bunaba"s,                                                                           "bck"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bunak"s,                                                                            "bfn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bunama"s,                                                                           "bdd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bundeli"s,                                                                          "bns"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bung"s,                                                                             "bqd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bungain"s,                                                                          "but"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bungku"s,                                                                           "bkz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bungu"s,                                                                            "wun"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bunoge Dogon"s,                                                                     "dgb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bunun"s,                                                                            "bnn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Buol"s,                                                                             "blf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bura-Pabir"s,                                                                       "bwr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Burak"s,                                                                            "bys"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Buraka"s,                                                                           "bkg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Burarra"s,                                                                          "bvr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Burate"s,                                                                           "bti"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Burduna"s,                                                                          "bxn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bure"s,                                                                             "bvh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Buriat"s,                                                                           "bua"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Burji"s,                                                                            "bji"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Burmbar"s,                                                                          "vrt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Burmese"s,                                                                          "bur"s,   "my"s, "mya"s, true );
  g_languages.emplace_back(u8"Burmeso"s,                                                                          "bzu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Buru (Indonesia)"s,                                                                 "mhs"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Buru (Nigeria)"s,                                                                   "bqw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Burui"s,                                                                            "bry"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Burumakok"s,                                                                        "aip"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Burun"s,                                                                            "bdi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Burunge"s,                                                                          "bds"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Burushaski"s,                                                                       "bsk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Burusu"s,                                                                           "bqr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Buruwai"s,                                                                          "asi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Busa"s,                                                                             "bqp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Busam"s,                                                                            "bxs"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Busami"s,                                                                           "bsm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Busang Kayan"s,                                                                     "bfg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bushi"s,                                                                            "buc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bushoong"s,                                                                         "buf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Buso"s,                                                                             "bso"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Busoa"s,                                                                            "bup"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bussa"s,                                                                            "dox"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Busuu"s,                                                                            "bju"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Butbut Kalinga"s,                                                                   "kyb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Butmas-Tur"s,                                                                       "bnr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Butuanon"s,                                                                         "btw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Buwal"s,                                                                            "bhs"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Buyu"s,                                                                             "byi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Buyuan Jinuo"s,                                                                     "jiy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bwa"s,                                                                              "bww"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bwaidoka"s,                                                                         "bwd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bwanabwana"s,                                                                       "tte"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bwatoo"s,                                                                           "bwa"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bwe Karen"s,                                                                        "bwe"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bwela"s,                                                                            "bwl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bwile"s,                                                                            "bwc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bwisi"s,                                                                            "bwz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Byangsi"s,                                                                          "bee"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Byep"s,                                                                             "mkk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Bädi Kanum"s,                                                                       "khd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"C'lela"s,                                                                           "dri"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Caac"s,                                                                             "msq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Cabiyarí"s,                                                                         "cbb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Cabécar"s,                                                                          "cjp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Cacaloxtepec Mixtec"s,                                                              "miu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Cacgia Roglai"s,                                                                    "roc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Cacua"s,                                                                            "cbv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Caddo"s,                                                                            "cad"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Cafundo Creole"s,                                                                   "ccd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Cahuarano"s,                                                                        "cah"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Cahuilla"s,                                                                         "chl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Cajamarca Quechua"s,                                                                "qvc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Cajatambo North Lima Quechua"s,                                                     "qvl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Cajonos Zapotec"s,                                                                  "zad"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Cajun French"s,                                                                     "frc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Caka"s,                                                                             "ckx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Cakchiquel-Quiché Mixed Language"s,                                                 "ckz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Cakfem-Mushere"s,                                                                   "cky"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Calamian Tagbanwa"s,                                                                "tbk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Calderón Highland Quichua"s,                                                        "qud"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Callawalla"s,                                                                       "caw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Caluyanun"s,                                                                        "clu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Caló"s,                                                                             "rmq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Cameroon Mambila"s,                                                                 "mcu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Cameroon Pidgin"s,                                                                  "wes"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Camling"s,                                                                          "rab"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Campalagian"s,                                                                      "cml"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Campidanese Sardinian"s,                                                            "sro"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Camsá"s,                                                                            "kbh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Camtho"s,                                                                           "cmt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Candoshi-Shapra"s,                                                                  "cbu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Canela"s,                                                                           "ram"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Cao Lan"s,                                                                          "mlc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Cao Miao"s,                                                                         "cov"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Capanahua"s,                                                                        "kaq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Capiznon"s,                                                                         "cps"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Caquinte"s,                                                                         "cot"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Car Nicobarese"s,                                                                   "caq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Cara"s,                                                                             "cfd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Carabayo"s,                                                                         "cby"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Carapana"s,                                                                         "cbc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Caribbean Hindustani"s,                                                             "hns"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Caribbean Javanese"s,                                                               "jvn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Carijona"s,                                                                         "cbd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Carolinian"s,                                                                       "cal"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Carpathian Romani"s,                                                                "rmc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Carrier"s,                                                                          "crx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Cashibo-Cacataibo"s,                                                                "cbr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Cashinahua"s,                                                                       "cbs"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Casiguran Dumagat Agta"s,                                                           "dgc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Casuarina Coast Asmat"s,                                                            "asc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Catalan Sign Language"s,                                                            "csc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Catalan; Valencian"s,                                                               "cat"s,   "ca"s, ""s,    true );
  g_languages.emplace_back(u8"Caucasian languages"s,                                                              "cau"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Cavineña"s,                                                                         "cav"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Cayuga"s,                                                                           "cay"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Cañar Highland Quichua"s,                                                           "qxr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ca̱hungwa̱rya̱"s,                                                                   "nat"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Cebaara Senoufo"s,                                                                  "sef"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Cebuano"s,                                                                          "ceb"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Celtic languages"s,                                                                 "cel"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Cemuhî"s,                                                                           "cam"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Cen"s,                                                                              "cen"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Central American Indian languages"s,                                                "cai"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Central Asmat"s,                                                                    "cns"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Central Atlas Tamazight"s,                                                          "tzm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Central Awyu"s,                                                                     "awu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Central Aymara"s,                                                                   "ayr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Central Bai"s,                                                                      "bca"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Central Berawan"s,                                                                  "zbc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Central Bikol"s,                                                                    "bcl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Central Bontok"s,                                                                   "lbk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Central Cagayan Agta"s,                                                             "agt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Central Grebo"s,                                                                    "grv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Central Hongshuihe Zhuang"s,                                                        "zch"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Central Huasteca Nahuatl"s,                                                         "nch"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Central Huishui Hmong"s,                                                            "hmc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Central Kanuri"s,                                                                   "knc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Central Khmer"s,                                                                    "khm"s,   "km"s, ""s,    true );
  g_languages.emplace_back(u8"Central Kurdish"s,                                                                  "ckb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Central Maewo"s,                                                                    "mwo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Central Malay"s,                                                                    "pse"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Central Masela"s,                                                                   "mxz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Central Mashan Hmong"s,                                                             "hmm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Central Mazahua"s,                                                                  "maz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Central Melanau"s,                                                                  "mel"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Central Mnong"s,                                                                    "cmo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Central Nahuatl"s,                                                                  "nhn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Central Nicobarese"s,                                                               "ncb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Central Ojibwa"s,                                                                   "ojc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Central Okinawan"s,                                                                 "ryu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Central Palawano"s,                                                                 "plc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Central Pame"s,                                                                     "pbs"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Central Pashto"s,                                                                   "pst"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Central Pomo"s,                                                                     "poo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Central Puebla Nahuatl"s,                                                           "ncx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Central Sama"s,                                                                     "sml"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Central Siberian Yupik"s,                                                           "ess"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Central Sierra Miwok"s,                                                             "csm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Central Subanen"s,                                                                  "syb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Central Tagbanwa"s,                                                                 "tgt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Central Tarahumara"s,                                                               "tar"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Central Tunebo"s,                                                                   "tuf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Central Yupik"s,                                                                    "esu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Central-Eastern Niger Fulfulde"s,                                                   "fuq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Centúúm"s,                                                                          "cet"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Cerma"s,                                                                            "cme"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Chabu"s,                                                                            "sbf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Chachapoyas Quechua"s,                                                              "quk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Chachi"s,                                                                           "cbi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Chadian Arabic"s,                                                                   "shu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Chadian Sign Language"s,                                                            "cds"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Chadong"s,                                                                          "cdy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Chagatai"s,                                                                         "chg"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Chaima"s,                                                                           "ciy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Chak"s,                                                                             "ckh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Chakali"s,                                                                          "cli"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Chakma"s,                                                                           "ccp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Chala"s,                                                                            "cll"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Chaldean Neo-Aramaic"s,                                                             "cld"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Chalikha"s,                                                                         "tgf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Chamacoco"s,                                                                        "ceg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Chamalal"s,                                                                         "cji"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Chamari"s,                                                                          "cdg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Chambeali"s,                                                                        "cdh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Chambri"s,                                                                          "can"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Chamic languages"s,                                                                 "cmc"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Chamicuro"s,                                                                        "ccc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Chamorro"s,                                                                         "cha"s,   "ch"s, ""s,    true );
  g_languages.emplace_back(u8"Chang Naga"s,                                                                       "nbc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Changriwa"s,                                                                        "cga"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Changthang"s,                                                                       "cna"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Chantyal"s,                                                                         "chx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Chara"s,                                                                            "cra"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Chaudangsi"s,                                                                       "cdn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Chaura"s,                                                                           "crv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Chavacano"s,                                                                        "cbk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Chayahuita"s,                                                                       "cbt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Chayuco Mixtec"s,                                                                   "mih"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Chazumba Mixtec"s,                                                                  "xtb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Che"s,                                                                              "ruk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Chechen"s,                                                                          "che"s,   "ce"s, ""s,    true );
  g_languages.emplace_back(u8"Cheke Holo"s,                                                                       "mrn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Chenapian"s,                                                                        "cjn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Chenchu"s,                                                                          "cde"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Chenoua"s,                                                                          "cnu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Chepang"s,                                                                          "cdm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Chepya"s,                                                                           "ycp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Cherepon"s,                                                                         "cpn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Cherokee"s,                                                                         "chr"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Chesu"s,                                                                            "ych"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Chetco"s,                                                                           "ctc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Chewong"s,                                                                          "cwg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Cheyenne"s,                                                                         "chy"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Chhattisgarhi"s,                                                                    "hne"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Chhintange"s,                                                                       "ctn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Chhulung"s,                                                                         "cur"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Chiangmai Sign Language"s,                                                          "csd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Chiapanec"s,                                                                        "cip"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Chibcha"s,                                                                          "chb"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Chicahuaxtla Triqui"s,                                                              "trs"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Chichewa; Chewa; Nyanja"s,                                                          "nya"s,   "ny"s, ""s,    true );
  g_languages.emplace_back(u8"Chichicapan Zapotec"s,                                                              "zpv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Chichimeca-Jonaz"s,                                                                 "pei"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Chickasaw"s,                                                                        "cic"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Chiga"s,                                                                            "cgg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Chigmecatitlán Mixtec"s,                                                            "mii"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Chilcotin"s,                                                                        "clc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Chilean Sign Language"s,                                                            "csg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Chilisso"s,                                                                         "clh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Chiltepec Chinantec"s,                                                              "csa"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Chimalapa Zoque"s,                                                                  "zoh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Chimborazo Highland Quichua"s,                                                      "qug"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Chimila"s,                                                                          "cbg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"China Buriat"s,                                                                     "bxu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Chinali"s,                                                                          "cih"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Chinbon Chin"s,                                                                     "cnb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Chincha Quechua"s,                                                                  "qxc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Chinese Pidgin English"s,                                                           "cpi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Chinese Sign Language"s,                                                            "csl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Chinese"s,                                                                          "chi"s,   "zh"s, "zho"s, true );
  g_languages.emplace_back(u8"Chinook jargon"s,                                                                   "chn"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Chinook"s,                                                                          "chh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Chipaya"s,                                                                          "cap"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Chipewyan; Dene Suline"s,                                                           "chp"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Chippewa"s,                                                                         "ciw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Chiquihuitlán Mazatec"s,                                                            "maq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Chiquitano"s,                                                                       "cax"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Chiquián Ancash Quechua"s,                                                          "qxa"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Chiripá"s,                                                                          "nhd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Chiru"s,                                                                            "cdf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Chitkuli Kinnauri"s,                                                                "cik"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Chittagonian"s,                                                                     "ctg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Chitwania Tharu"s,                                                                  "the"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Choapan Zapotec"s,                                                                  "zpc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Chocangacakha"s,                                                                    "cgk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Chochotec"s,                                                                        "coz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Choctaw"s,                                                                          "cho"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Chodri"s,                                                                           "cdi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Chokri Naga"s,                                                                      "nri"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Chokwe"s,                                                                           "cjk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Chol"s,                                                                             "ctu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Chong"s,                                                                            "cog"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Choni"s,                                                                            "cda"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Chonyi-Dzihana-Kauma"s,                                                             "coh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Chopi"s,                                                                            "cce"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Chortí"s,                                                                           "caa"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Chothe Naga"s,                                                                      "nct"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Chrau"s,                                                                            "crw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Chru"s,                                                                             "cje"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Chuanqiandian Cluster Miao"s,                                                       "cqd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Chuave"s,                                                                           "cjv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Chug"s,                                                                             "cvg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Chuj"s,                                                                             "cac"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Chuka"s,                                                                            "cuh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Chukot"s,                                                                           "ckt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Chukwa"s,                                                                           "cuw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Chulym"s,                                                                           "clw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Chumburung"s,                                                                       "ncu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Churahi"s,                                                                          "cdj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Church Slavic; Old Slavonic; Church Slavonic; Old Bulgarian; Old Church Slavonic"s, "chu"s,   "cu"s, ""s,    true );
  g_languages.emplace_back(u8"Chut"s,                                                                             "scb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Chuukese"s,                                                                         "chk"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Chuvash"s,                                                                          "chv"s,   "cv"s, ""s,    true );
  g_languages.emplace_back(u8"Chuwabu"s,                                                                          "chw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Chácobo"s,                                                                          "cao"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ci Gbe"s,                                                                           "cib"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Cia-Cia"s,                                                                          "cia"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Cibak"s,                                                                            "ckl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Cicipu"s,                                                                           "awc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Cimbrian"s,                                                                         "cim"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Cinda-Regi-Tiyal"s,                                                                 "cdr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Cineni"s,                                                                           "cie"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Cinta Larga"s,                                                                      "cin"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Cishingini"s,                                                                       "asg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Citak"s,                                                                            "txt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ciwogai"s,                                                                          "tgd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Clallam"s,                                                                          "clm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Classical Newari; Old Newari; Classical Nepal Bhasa"s,                              "nwc"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Classical Syriac"s,                                                                 "syc"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Coastal Konjo"s,                                                                    "kjc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Coatecas Altas Zapotec"s,                                                           "zca"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Coatepec Nahuatl"s,                                                                 "naz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Coatlán Mixe"s,                                                                     "mco"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Coatlán Zapotec"s,                                                                  "zps"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Coatzospan Mixtec"s,                                                                "miz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Cocama-Cocamilla"s,                                                                 "cod"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Cocopa"s,                                                                           "coc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Cocos Islands Malay"s,                                                              "coa"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Coeur d'Alene"s,                                                                    "crd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Cofán"s,                                                                            "con"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Cogui"s,                                                                            "kog"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Col"s,                                                                              "liw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Colombian Sign Language"s,                                                          "csn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Colonia Tovar German"s,                                                             "gct"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Colorado"s,                                                                         "cof"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Columbia-Wenatchi"s,                                                                "col"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Comaltepec Chinantec"s,                                                             "cco"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Comanche"s,                                                                         "com"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Como Karim"s,                                                                       "cfg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Comox"s,                                                                            "coo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Con"s,                                                                              "cno"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Congo Swahili"s,                                                                    "swc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Coos"s,                                                                             "csz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Copainalá Zoque"s,                                                                  "zoc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Copala Triqui"s,                                                                    "trc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Coptic"s,                                                                           "cop"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Cori"s,                                                                             "cry"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Cornish"s,                                                                          "cor"s,   "kw"s, ""s,    true );
  g_languages.emplace_back(u8"Corongo Ancash Quechua"s,                                                           "qwa"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Corsican"s,                                                                         "cos"s,   "co"s, ""s,    true );
  g_languages.emplace_back(u8"Costa Rican Sign Language"s,                                                        "csr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Cotabato Manobo"s,                                                                  "mta"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Coyotepec Popoloca"s,                                                               "pbf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Coyutla Totonac"s,                                                                  "toc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Cree"s,                                                                             "cre"s,   "cr"s, ""s,    true );
  g_languages.emplace_back(u8"Creek"s,                                                                            "mus"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Creoles and pidgins"s,                                                              "crp"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Creoles and pidgins, English based"s,                                               "cpe"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Creoles and pidgins, French-based"s,                                                "cpf"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Creoles and pidgins, Portuguese-based"s,                                            "cpp"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Crimean Tatar; Crimean Turkish"s,                                                   "crh"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Croatia Sign Language"s,                                                            "csq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Croatian"s,                                                                         "hrv"s,   "hr"s, ""s,    true );
  g_languages.emplace_back(u8"Cross River Mbembe"s,                                                               "mfn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Crow"s,                                                                             "cro"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Cua"s,                                                                              "cua"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Cuba Sign Language"s,                                                               "csf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Cubeo"s,                                                                            "cub"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Cuiba"s,                                                                            "cui"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Culina"s,                                                                           "cul"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Cun"s,                                                                              "cuq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Cung"s,                                                                             "cug"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Curripaco"s,                                                                        "kpc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Cusco Quechua"s,                                                                    "quz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Cushitic languages"s,                                                               "cus"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Cutchi-Swahili"s,                                                                   "ccl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Cuvok"s,                                                                            "cuv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Cuyamecalco Mixtec"s,                                                               "xtu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Cuyonon"s,                                                                          "cyo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Cwi Bwamu"s,                                                                        "bwy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Cypriot Arabic"s,                                                                   "acy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Czech Sign Language"s,                                                              "cse"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Czech"s,                                                                            "cze"s,   "cs"s, "ces"s, true );
  g_languages.emplace_back(u8"Côông"s,                                                                            "cnc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Da'a Kaili"s,                                                                       "kzf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Daai Chin"s,                                                                        "dao"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Daakaka"s,                                                                          "bpa"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Daantanai'"s,                                                                       "lni"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Daasanach"s,                                                                        "dsh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Daatsʼíin"s,                                                                       "dtn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Daba"s,                                                                             "dbq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dabarre"s,                                                                          "dbr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dabe"s,                                                                             "dbe"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dadibi"s,                                                                           "mps"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dadiya"s,                                                                           "dbd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Daga"s,                                                                             "dgz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dagaari Dioula"s,                                                                   "dgd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dagba"s,                                                                            "dgk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dagbani"s,                                                                          "dag"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dagik"s,                                                                            "dec"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dahalik"s,                                                                          "dlk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dahalo"s,                                                                           "dal"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Daho-Doo"s,                                                                         "das"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dai Zhuang"s,                                                                       "zhd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dai"s,                                                                              "dij"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dair"s,                                                                             "drb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dakka"s,                                                                            "dkk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dakota"s,                                                                           "dak"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Dakpakha"s,                                                                         "dka"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dalabon"s,                                                                          "ngk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Daloa Bété"s,                                                                       "bev"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dama"s,                                                                             "dmm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Damakawa"s,                                                                         "dam"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Damal"s,                                                                            "uhn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dambi"s,                                                                            "dac"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dameli"s,                                                                           "dml"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dampelas"s,                                                                         "dms"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dan"s,                                                                              "dnj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Danaru"s,                                                                           "dnr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Danau"s,                                                                            "dnu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dandami Maria"s,                                                                    "daq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dangaléat"s,                                                                        "daa"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dangaura Tharu"s,                                                                   "thl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Danish Sign Language"s,                                                             "dsl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Danish"s,                                                                           "dan"s,   "da"s, ""s,    true );
  g_languages.emplace_back(u8"Dano"s,                                                                             "aso"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Danu"s,                                                                             "dnv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dao"s,                                                                              "daz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Daonda"s,                                                                           "dnd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dar Daju Daju"s,                                                                    "djc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dar Fur Daju"s,                                                                     "daj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dar Sila Daju"s,                                                                    "dau"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Darai"s,                                                                            "dry"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dargwa"s,                                                                           "dar"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Dari"s,                                                                             "prs"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Darkinyung"s,                                                                       "xda"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Darlong"s,                                                                          "dln"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Darmiya"s,                                                                          "drd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Daro-Matu Melanau"s,                                                                "dro"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dass"s,                                                                             "dot"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Datooga"s,                                                                          "tcc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Daur"s,                                                                             "dta"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Davawenyo"s,                                                                        "daw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dawawa"s,                                                                           "dww"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dawera-Daweloor"s,                                                                  "ddw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dawro"s,                                                                            "dwr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Day"s,                                                                              "dai"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dayi"s,                                                                             "dax"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dazaga"s,                                                                           "dzg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Deccan"s,                                                                           "dcc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dedua"s,                                                                            "ded"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Defaka"s,                                                                           "afn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Defi Gbe"s,                                                                         "gbh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Deg"s,                                                                              "mzw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Degaru"s,                                                                           "dgu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Degema"s,                                                                           "deg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Degenan"s,                                                                          "dge"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Degexit'an"s,                                                                       "ing"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dehu"s,                                                                             "dhv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dehwari"s,                                                                          "deh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dek"s,                                                                              "dek"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dela-Oenale"s,                                                                      "row"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Delaware"s,                                                                         "del"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Delo"s,                                                                             "ntr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dem"s,                                                                              "dem"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dema"s,                                                                             "dmx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Demisa"s,                                                                           "dei"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Demta"s,                                                                            "dmy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dendi (Benin)"s,                                                                    "ddn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dendi (Central African Republic)"s,                                                 "deq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dengese"s,                                                                          "dez"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dengka"s,                                                                           "dnk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Deno"s,                                                                             "dbb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Denya"s,                                                                            "anv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dení"s,                                                                             "dny"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Deori"s,                                                                            "der"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dera (Indonesia)"s,                                                                 "kbv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dera (Nigeria)"s,                                                                   "kna"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Desano"s,                                                                           "des"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Desiya"s,                                                                           "dso"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dewoin"s,                                                                           "dee"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dezfuli"s,                                                                          "def"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dghwede"s,                                                                          "dgh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dhaiso"s,                                                                           "dhs"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dhalandji"s,                                                                        "dhl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dhangu-Djangu"s,                                                                    "dhg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dhanki"s,                                                                           "dhn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dhanwar (Nepal)"s,                                                                  "dhw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dhao"s,                                                                             "nfa"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dhargari"s,                                                                         "dhr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dhatki"s,                                                                           "mki"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dhimal"s,                                                                           "dhi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dhodia"s,                                                                           "dho"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dhofari Arabic"s,                                                                   "adf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dhundari"s,                                                                         "dhd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dhungaloo"s,                                                                        "dhx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dhuwal"s,                                                                           "dwu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dhuwaya"s,                                                                          "dwy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dia"s,                                                                              "dia"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dibabawon Manobo"s,                                                                 "mbd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dibiyaso"s,                                                                         "dby"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dibo"s,                                                                             "dio"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dibole"s,                                                                           "bvx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Didinga"s,                                                                          "did"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dido"s,                                                                             "ddo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Digaro-Mishmi"s,                                                                    "mhu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Digo"s,                                                                             "dig"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dii"s,                                                                              "dur"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dijim-Bwilim"s,                                                                     "cfa"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dilling"s,                                                                          "dil"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dima"s,                                                                             "jma"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dimasa"s,                                                                           "dis"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dimbong"s,                                                                          "dii"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dime"s,                                                                             "dim"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dimli (individual language)"s,                                                      "diq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ding"s,                                                                             "diz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dinka"s,                                                                            "din"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Dirasha"s,                                                                          "gdl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Diri"s,                                                                             "dwa"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Diriku"s,                                                                           "diu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dirim"s,                                                                            "dir"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Disa"s,                                                                             "dsi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ditammari"s,                                                                        "tbz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ditidaht"s,                                                                         "dtd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Diuwe"s,                                                                            "diy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Diuxi-Tilantongo Mixtec"s,                                                          "xtd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Divehi; Dhivehi; Maldivian"s,                                                       "div"s,   "dv"s, ""s,    true );
  g_languages.emplace_back(u8"Dixon Reef"s,                                                                       "dix"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dizin"s,                                                                            "mdx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Djabwurrung"s,                                                                      "tjw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Djambarrpuyngu"s,                                                                   "djr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Djamindjung"s,                                                                      "djd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Djauan"s,                                                                           "djn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Djeebbana"s,                                                                        "djj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Djimini Senoufo"s,                                                                  "dyi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Djinang"s,                                                                          "dji"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Djinba"s,                                                                           "djb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Djingili"s,                                                                         "jig"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dobel"s,                                                                            "kvo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dobu"s,                                                                             "dob"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Doe"s,                                                                              "doe"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Doga"s,                                                                             "dgg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Doghoro"s,                                                                          "dgx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dogoso"s,                                                                           "dgs"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dogosé"s,                                                                           "dos"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dogri (individual language)"s,                                                      "dgo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dogri"s,                                                                            "doi"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Dogrib"s,                                                                           "dgr"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Dogul Dom Dogon"s,                                                                  "dbg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Doka"s,                                                                             "dbi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Doko-Uyanga"s,                                                                      "uya"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dolgan"s,                                                                           "dlg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dolpo"s,                                                                            "dre"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dom"s,                                                                              "doa"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Domaaki"s,                                                                          "dmk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Domari"s,                                                                           "rmt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dombe"s,                                                                            "dov"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dominican Sign Language"s,                                                          "doq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dompo"s,                                                                            "doy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Domu"s,                                                                             "dof"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Domung"s,                                                                           "dev"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dondo"s,                                                                            "dok"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dong"s,                                                                             "doh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dongo"s,                                                                            "doo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dongotono"s,                                                                        "ddd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dongshanba Lalo"s,                                                                  "yik"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dongxiang"s,                                                                        "sce"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Donno So Dogon"s,                                                                   "dds"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Doondo"s,                                                                           "dde"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dori'o"s,                                                                           "dor"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Doromu-Koki"s,                                                                      "kqc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dorze"s,                                                                            "doz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Doso"s,                                                                             "dol"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dotyali"s,                                                                          "dty"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Doutai"s,                                                                           "tds"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Doyayo"s,                                                                           "dow"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dravidian languages"s,                                                              "dra"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Drents"s,                                                                           "drt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Drung"s,                                                                            "duu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Duala"s,                                                                            "dua"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Duano"s,                                                                            "dup"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Duau"s,                                                                             "dva"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dubli"s,                                                                            "dub"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dubu"s,                                                                             "dmu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dugun"s,                                                                            "ndu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Duguri"s,                                                                           "dbm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dugwor"s,                                                                           "dme"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Duhwa"s,                                                                            "kbz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Duke"s,                                                                             "nke"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dulbu"s,                                                                            "dbo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Duma"s,                                                                             "dma"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dumbea"s,                                                                           "duf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dumi"s,                                                                             "dus"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dumpas"s,                                                                           "dmv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dumun"s,                                                                            "dui"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Duna"s,                                                                             "duc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dungan"s,                                                                           "dng"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dungmali"s,                                                                         "raa"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dungra Bhil"s,                                                                      "duh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dungu"s,                                                                            "dbv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dupaninan Agta"s,                                                                   "duo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Duri"s,                                                                             "mvp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Duriankere"s,                                                                       "dbn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Duruma"s,                                                                           "dug"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Duruwa"s,                                                                           "pci"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dusner"s,                                                                           "dsn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dusun Deyah"s,                                                                      "dun"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dusun Malang"s,                                                                     "duq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dusun Witu"s,                                                                       "duw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dutch Sign Language"s,                                                              "dse"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dutch, Middle (ca. 1050-1350)"s,                                                    "dum"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Dutch; Flemish"s,                                                                   "dut"s,   "nl"s, "nld"s, true );
  g_languages.emplace_back(u8"Duungooma"s,                                                                        "dux"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Duupa"s,                                                                            "dae"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Duvle"s,                                                                            "duv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Duwai"s,                                                                            "dbp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Duwet"s,                                                                            "gve"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dũya"s,                                                                            "ldb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dwang"s,                                                                            "nnu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dyaabugay"s,                                                                        "dyy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dyan"s,                                                                             "dya"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dyangadi"s,                                                                         "dyn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dyirbal"s,                                                                          "dbl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dyula"s,                                                                            "dyu"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Dza"s,                                                                              "jen"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dzalakha"s,                                                                         "dzl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dzando"s,                                                                           "dzn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dzao Min"s,                                                                         "bpn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dzodinka"s,                                                                         "add"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dzongkha"s,                                                                         "dzo"s,   "dz"s, ""s,    true );
  g_languages.emplace_back(u8"Dzùùngoo"s,                                                                         "dnn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Dâw"s,                                                                              "kwa"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"E"s,                                                                                "eee"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"E'ma Buyang"s,                                                                      "yzg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"E'ñapa Woromaipu"s,                                                                 "pbh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"East Ambae"s,                                                                       "omb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"East Berawan"s,                                                                     "zbe"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"East Damar"s,                                                                       "dmr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"East Futuna"s,                                                                      "fud"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"East Kewa"s,                                                                        "kjs"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"East Limba"s,                                                                       "lma"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"East Makian"s,                                                                      "mky"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"East Masela"s,                                                                      "vme"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"East Nyala"s,                                                                       "nle"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"East Tarangan"s,                                                                    "tre"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"East Yugur"s,                                                                       "yuy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Eastern Acipa"s,                                                                    "acp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Eastern Apurímac Quechua"s,                                                         "qve"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Eastern Arrernte"s,                                                                 "aer"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Eastern Balochi"s,                                                                  "bgp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Eastern Bolivian Guaraní"s,                                                         "gui"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Eastern Bontok"s,                                                                   "ebk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Eastern Bru"s,                                                                      "bru"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Eastern Canadian Inuktitut"s,                                                       "ike"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Eastern Cham"s,                                                                     "cjm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Eastern Durango Nahuatl"s,                                                          "azd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Eastern Egyptian Bedawi Arabic"s,                                                   "avl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Eastern Frisian"s,                                                                  "frs"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Eastern Gorkha Tamang"s,                                                            "tge"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Eastern Highland Chatino"s,                                                         "cly"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Eastern Highland Otomi"s,                                                           "otm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Eastern Hongshuihe Zhuang"s,                                                        "zeh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Eastern Huasteca Nahuatl"s,                                                         "nhe"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Eastern Huishui Hmong"s,                                                            "hme"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Eastern Karaboro"s,                                                                 "xrb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Eastern Katu"s,                                                                     "ktv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Eastern Kayah"s,                                                                    "eky"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Eastern Keres"s,                                                                    "kee"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Eastern Khumi Chin"s,                                                               "cek"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Eastern Krahn"s,                                                                    "kqo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Eastern Lalu"s,                                                                     "yit"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Eastern Lawa"s,                                                                     "lwl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Eastern Magar"s,                                                                    "mgp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Eastern Maninkakan"s,                                                               "emk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Eastern Mari"s,                                                                     "mhr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Eastern Maroon Creole"s,                                                            "djk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Eastern Meohang"s,                                                                  "emg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Eastern Mnong"s,                                                                    "mng"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Eastern Muria"s,                                                                    "emu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Eastern Ngad'a"s,                                                                   "nea"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Eastern Nisu"s,                                                                     "nos"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Eastern Ojibwa"s,                                                                   "ojg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Eastern Oromo"s,                                                                    "hae"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Eastern Parbate Kham"s,                                                             "kif"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Eastern Penan"s,                                                                    "pez"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Eastern Qiandong Miao"s,                                                            "hmq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Eastern Subanen"s,                                                                  "sfe"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Eastern Tamang"s,                                                                   "taj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Eastern Tawbuid"s,                                                                  "bnj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Eastern Xiangxi Miao"s,                                                             "muq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Eastern Xwla Gbe"s,                                                                 "gbx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Eastern Yiddish"s,                                                                  "ydd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ebira"s,                                                                            "igb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ebrié"s,                                                                            "ebr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ebughu"s,                                                                           "ebg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ecuadorian Sign Language"s,                                                         "ecs"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ede Cabe"s,                                                                         "cbj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ede Ica"s,                                                                          "ica"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ede Idaca"s,                                                                        "idd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ede Ije"s,                                                                          "ijj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Edera Awyu"s,                                                                       "awy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Edolo"s,                                                                            "etr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Edopi"s,                                                                            "dbf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Efai"s,                                                                             "efa"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Efe"s,                                                                              "efe"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Efik"s,                                                                             "efi"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Efutop"s,                                                                           "ofu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ega"s,                                                                              "ega"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Eggon"s,                                                                            "ego"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Egypt Sign Language"s,                                                              "esl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Egyptian (Ancient)"s,                                                               "egy"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Egyptian Arabic"s,                                                                  "arz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ehueun"s,                                                                           "ehu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Eipomek"s,                                                                          "eip"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Eitiep"s,                                                                           "eit"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ejagham"s,                                                                          "etu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ejamat"s,                                                                           "eja"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ekajuk"s,                                                                           "eka"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Ekari"s,                                                                            "ekg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Eki"s,                                                                              "eki"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ekit"s,                                                                             "eke"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ekpeye"s,                                                                           "ekp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"El Alto Zapotec"s,                                                                  "zpp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"El Hugeirat"s,                                                                      "elh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"El Molo"s,                                                                          "elo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"El Nayar Cora"s,                                                                    "crn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Elamite"s,                                                                          "elx"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Eleme"s,                                                                            "elm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Elepi"s,                                                                            "ele"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Elip"s,                                                                             "ekm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Elkei"s,                                                                            "elk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Elotepec Zapotec"s,                                                                 "zte"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Eloyi"s,                                                                            "afo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Elseng"s,                                                                           "mrf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Elu"s,                                                                              "elu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Emae"s,                                                                             "mmw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Emai-Iuleha-Ora"s,                                                                  "ema"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Eman"s,                                                                             "emn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Embaloh"s,                                                                          "emb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Emberá-Baudó"s,                                                                     "bdc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Emberá-Catío"s,                                                                     "cto"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Emberá-Chamí"s,                                                                     "cmi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Emberá-Tadó"s,                                                                      "tdc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Embu"s,                                                                             "ebu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Emerillon"s,                                                                        "eme"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Emilian"s,                                                                          "egl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Emplawas"s,                                                                         "emw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Emumu"s,                                                                            "enr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"En"s,                                                                               "enc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Enawené-Nawé"s,                                                                     "unk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ende"s,                                                                             "end"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Enga"s,                                                                             "enq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Engdewu"s,                                                                          "ngr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Engenni"s,                                                                          "enn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Enggano"s,                                                                          "eno"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"English"s,                                                                          "eng"s,   "en"s, ""s,    true );
  g_languages.emplace_back(u8"English, Middle (1100-1500)"s,                                                      "enm"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"English, Old (ca. 450-1100)"s,                                                      "ang"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Enlhet"s,                                                                           "enl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Enrekang"s,                                                                         "ptt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Enu"s,                                                                              "enu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Enwan (Akwa Ibom State)"s,                                                          "enw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Enwan (Edu State)"s,                                                                "env"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Enxet"s,                                                                            "enx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Enya"s,                                                                             "gey"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Epena"s,                                                                            "sja"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Epie"s,                                                                             "epi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Eravallan"s,                                                                        "era"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Erave"s,                                                                            "kjy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ere"s,                                                                              "twp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Eritai"s,                                                                           "ert"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Erokwanas"s,                                                                        "erw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Erromintxela"s,                                                                     "emx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ersu"s,                                                                             "ers"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Eruwa"s,                                                                            "erh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Erzya"s,                                                                            "myv"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Esan"s,                                                                             "ish"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ese Ejja"s,                                                                         "ese"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ese"s,                                                                              "mcq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Eshtehardi"s,                                                                       "esh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Esimbi"s,                                                                           "ags"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Eskayan"s,                                                                          "esy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Esperanto"s,                                                                        "epo"s,   "eo"s, ""s,    true );
  g_languages.emplace_back(u8"Estado de México Otomi"s,                                                           "ots"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Estonian Sign Language"s,                                                           "eso"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Estonian"s,                                                                         "est"s,   "et"s, ""s,    true );
  g_languages.emplace_back(u8"Etebi"s,                                                                            "etb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Eten"s,                                                                             "etx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ethiopian Sign Language"s,                                                          "eth"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Etkywan"s,                                                                          "ich"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Eton (Cameroon)"s,                                                                  "eto"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Eton (Vanuatu)"s,                                                                   "etn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Etulo"s,                                                                            "utr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Evant"s,                                                                            "bzz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Even"s,                                                                             "eve"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Evenki"s,                                                                           "evn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Eviya"s,                                                                            "gev"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ewage-Notu"s,                                                                       "nou"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ewe"s,                                                                              "ewe"s,   "ee"s, ""s,    true );
  g_languages.emplace_back(u8"Ewondo"s,                                                                           "ewo"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Extremaduran"s,                                                                     "ext"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ezaa"s,                                                                             "eza"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Fa d'Ambu"s,                                                                        "fab"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Fagani"s,                                                                           "faf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Faire Atta"s,                                                                       "azt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Faita"s,                                                                            "faj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Faiwol"s,                                                                           "fai"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Fala"s,                                                                             "fax"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Falam Chin"s,                                                                       "cfm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Fali"s,                                                                             "fli"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Fam"s,                                                                              "fam"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Fanagalo"s,                                                                         "fng"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Fanamaket"s,                                                                        "bjp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Fanbak"s,                                                                           "fnb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Fang (Cameroon)"s,                                                                  "fak"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Fang"s,                                                                             "fan"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Fania"s,                                                                            "fni"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Fanti"s,                                                                            "fat"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Far Western Muria"s,                                                                "fmu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Farefare"s,                                                                         "gur"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Faroese"s,                                                                          "fao"s,   "fo"s, ""s,    true );
  g_languages.emplace_back(u8"Fas"s,                                                                              "fqs"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Fasu"s,                                                                             "faa"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Fataleka"s,                                                                         "far"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Fataluku"s,                                                                         "ddg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Fayu"s,                                                                             "fau"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Fe'fe'"s,                                                                           "fmp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Fembe"s,                                                                            "agl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Fernando Po Creole English"s,                                                       "fpe"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Feroge"s,                                                                           "fer"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Fiji Hindi"s,                                                                       "hif"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Fijian"s,                                                                           "fij"s,   "fj"s, ""s,    true );
  g_languages.emplace_back(u8"Filipino; Pilipino"s,                                                               "fil"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Filomena Mata-Coahuitlán Totonac"s,                                                 "tlp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Finland-Swedish Sign Language"s,                                                    "fss"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Finnish Sign Language"s,                                                            "fse"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Finnish"s,                                                                          "fin"s,   "fi"s, ""s,    true );
  g_languages.emplace_back(u8"Finno-Ugrian languages"s,                                                           "fiu"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Finongan"s,                                                                         "fag"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Fipa"s,                                                                             "fip"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Firan"s,                                                                            "fir"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Fiwaga"s,                                                                           "fiw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Flaaitaal"s,                                                                        "fly"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Foau"s,                                                                             "flh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Foi"s,                                                                              "foi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Foia Foia"s,                                                                        "ffi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Folopa"s,                                                                           "ppo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Foma"s,                                                                             "fom"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Fon"s,                                                                              "fon"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Fongoro"s,                                                                          "fgr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Foodo"s,                                                                            "fod"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Forak"s,                                                                            "frq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Fordata"s,                                                                          "frd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Fore"s,                                                                             "for"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Forest Enets"s,                                                                     "enf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Fortsenal"s,                                                                        "frt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Francisco León Zoque"s,                                                             "zos"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"French Sign Language"s,                                                             "fsl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"French"s,                                                                           "fre"s,   "fr"s, "fra"s, true );
  g_languages.emplace_back(u8"French, Middle (ca. 1400-1600)"s,                                                   "frm"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"French, Old (842-ca. 1400)"s,                                                       "fro"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Friulian"s,                                                                         "fur"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Fulah"s,                                                                            "ful"s,   "ff"s, ""s,    true );
  g_languages.emplace_back(u8"Fuliiru"s,                                                                          "flr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Fulniô"s,                                                                           "fun"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Fum"s,                                                                              "fum"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Fungwa"s,                                                                           "ula"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Fur"s,                                                                              "fvr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Furu"s,                                                                             "fuu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Futuna-Aniwa"s,                                                                     "fut"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Fuyug"s,                                                                            "fuy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Fwe"s,                                                                              "fwe"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Fwâi"s,                                                                             "fwa"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Fyam"s,                                                                             "pym"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Fyer"s,                                                                             "fie"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ga"s,                                                                               "gaa"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Ga'anda"s,                                                                          "gqa"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ga'dang"s,                                                                          "gdg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gaa"s,                                                                              "ttb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gaam"s,                                                                             "tbi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gabi-Gabi"s,                                                                        "gbw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gabri"s,                                                                            "gab"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gadang"s,                                                                           "gdk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gaddang"s,                                                                          "gad"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gaddi"s,                                                                            "gbk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gade Lohar"s,                                                                       "gda"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gade"s,                                                                             "ged"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gadjerawang"s,                                                                      "gdh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gadsup"s,                                                                           "gaj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gaelic; Scottish Gaelic"s,                                                          "gla"s,   "gd"s, ""s,    true );
  g_languages.emplace_back(u8"Gagadu"s,                                                                           "gbu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gagauz"s,                                                                           "gag"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gagnoa Bété"s,                                                                      "btg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gagu"s,                                                                             "ggu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gahri"s,                                                                            "bfu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gaikundi"s,                                                                         "gbf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gail"s,                                                                             "gic"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gaina"s,                                                                            "gcn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gal"s,                                                                              "gap"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Galambu"s,                                                                          "glo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Galela"s,                                                                           "gbi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Galeya"s,                                                                           "gar"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Galibi Carib"s,                                                                     "car"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Galician"s,                                                                         "glg"s,   "gl"s, ""s,    true );
  g_languages.emplace_back(u8"Gallurese Sardinian"s,                                                              "sdn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Galo"s,                                                                             "adl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Galolen"s,                                                                          "gal"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gamale Kham"s,                                                                      "kgj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gambian Wolof"s,                                                                    "wof"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gamilaraay"s,                                                                       "kld"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gamit"s,                                                                            "gbl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gamkonora"s,                                                                        "gak"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gamo"s,                                                                             "gmv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gan Chinese"s,                                                                      "gan"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gana"s,                                                                             "gnq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ganang"s,                                                                           "gne"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ganda"s,                                                                            "lug"s,   "lg"s, ""s,    true );
  g_languages.emplace_back(u8"Gane"s,                                                                             "gzn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ganglau"s,                                                                          "ggl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gangte"s,                                                                           "gnb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gants"s,                                                                            "gao"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ganza"s,                                                                            "gza"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ganzi"s,                                                                            "gnz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gao"s,                                                                              "gga"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gapapaiwa"s,                                                                        "pwg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Garhwali"s,                                                                         "gbm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Garifuna"s,                                                                         "cab"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Garo"s,                                                                             "grt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Garre"s,                                                                            "gex"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Garrwa"s,                                                                           "wrk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Garus"s,                                                                            "gyb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gata'"s,                                                                            "gaq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gavak"s,                                                                            "dmc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gavar"s,                                                                            "gou"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gavião Do Jiparaná"s,                                                               "gvo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gawar-Bati"s,                                                                       "gwt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gawwada"s,                                                                          "gwd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gayil"s,                                                                            "gyl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gayo"s,                                                                             "gay"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Gazi"s,                                                                             "gzi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gbagyi"s,                                                                           "gbr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gbanu"s,                                                                            "gbv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gbanziri"s,                                                                         "gbg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gbari"s,                                                                            "gby"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gbaya (Sudan)"s,                                                                    "krs"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gbaya"s,                                                                            "gba"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Gbaya-Bossangoa"s,                                                                  "gbp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gbaya-Bozoum"s,                                                                     "gbq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gbaya-Mbodomo"s,                                                                    "gmm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gbayi"s,                                                                            "gyg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gbesi Gbe"s,                                                                        "gbs"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gbii"s,                                                                             "ggb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gbiri-Niragu"s,                                                                     "grh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gboloo Grebo"s,                                                                     "gec"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ge"s,                                                                               "hmj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Geba Karen"s,                                                                       "kvq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gebe"s,                                                                             "gei"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gedaged"s,                                                                          "gdd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gedeo"s,                                                                            "drs"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Geez"s,                                                                             "gez"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Geji"s,                                                                             "gji"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Geko Karen"s,                                                                       "ghk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gela"s,                                                                             "nlg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Geme"s,                                                                             "geq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gen"s,                                                                              "gej"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gende"s,                                                                            "gaf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gengle"s,                                                                           "geg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Georgian"s,                                                                         "geo"s,   "ka"s, "kat"s, true );
  g_languages.emplace_back(u8"Gepo"s,                                                                             "ygp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gera"s,                                                                             "gew"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"German Sign Language"s,                                                             "gsg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"German"s,                                                                           "ger"s,   "de"s, "deu"s, true );
  g_languages.emplace_back(u8"German, Middle High (ca. 1050-1500)"s,                                              "gmh"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"German, Old High (ca. 750-1050)"s,                                                  "goh"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Germanic languages"s,                                                               "gem"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Geruma"s,                                                                           "gea"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Geser-Gorom"s,                                                                      "ges"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ghadamès"s,                                                                         "gha"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ghanaian Pidgin English"s,                                                          "gpe"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ghanaian Sign Language"s,                                                           "gse"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ghandruk Sign Language"s,                                                           "gds"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ghanongga"s,                                                                        "ghn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ghari"s,                                                                            "gri"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ghayavi"s,                                                                          "bmk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gheg Albanian"s,                                                                    "aln"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ghera"s,                                                                            "ghr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ghodoberi"s,                                                                        "gdo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ghomálá'"s,                                                                         "bbj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ghotuo"s,                                                                           "aaa"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ghulfan"s,                                                                          "ghl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Giangan"s,                                                                          "bgi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gibanawa"s,                                                                         "gib"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gidar"s,                                                                            "gid"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Giiwo"s,                                                                            "kks"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gikyode"s,                                                                          "acd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gilaki"s,                                                                           "glk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gilbertese"s,                                                                       "gil"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Gilima"s,                                                                           "gix"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gilyak"s,                                                                           "niv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gimi (Eastern Highlands)"s,                                                         "gim"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gimi (West New Britain)"s,                                                          "gip"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gimme"s,                                                                            "kmp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gimnime"s,                                                                          "gmn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ginuman"s,                                                                          "gnm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ginyanga"s,                                                                         "ayg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Girawa"s,                                                                           "bbr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Giryama"s,                                                                          "nyf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Githabul"s,                                                                         "gih"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gitonga"s,                                                                          "toh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gitua"s,                                                                            "ggt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gitxsan"s,                                                                          "git"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Giyug"s,                                                                            "giy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gizrra"s,                                                                           "tof"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Glaro-Twabo"s,                                                                      "glr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Glavda"s,                                                                           "glw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Glio-Oubi"s,                                                                        "oub"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gnau"s,                                                                             "gnu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Goan Konkani"s,                                                                     "gom"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Goaria"s,                                                                           "gig"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gobasi"s,                                                                           "goi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gobu"s,                                                                             "gox"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Godié"s,                                                                            "god"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Godwari"s,                                                                          "gdx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Goemai"s,                                                                           "ank"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gofa"s,                                                                             "gof"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gogo"s,                                                                             "gog"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gogodala"s,                                                                         "ggw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gokana"s,                                                                           "gkn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gola"s,                                                                             "gol"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Golin"s,                                                                            "gvf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gondi"s,                                                                            "gon"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Gone Dau"s,                                                                         "goo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gongduk"s,                                                                          "goe"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gonja"s,                                                                            "gjn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gooniyandi"s,                                                                       "gni"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gor"s,                                                                              "gqr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gorakor"s,                                                                          "goc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gorap"s,                                                                            "goq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gorontalo"s,                                                                        "gor"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Gorovu"s,                                                                           "grq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gorowa"s,                                                                           "gow"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gothic"s,                                                                           "got"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Goundo"s,                                                                           "goy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gourmanchéma"s,                                                                     "gux"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gowlan"s,                                                                           "goj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gowli"s,                                                                            "gok"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gowro"s,                                                                            "gwf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gozarkhani"s,                                                                       "goz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Grangali"s,                                                                         "nli"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Grass Koiari"s,                                                                     "kbk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Grebo"s,                                                                            "grb"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Greek Sign Language"s,                                                              "gss"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Greek, Ancient (to 1453)"s,                                                         "grc"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Greek, Modern (1453-)"s,                                                            "gre"s,   "el"s, "ell"s, true );
  g_languages.emplace_back(u8"Green Gelao"s,                                                                      "giq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Grenadian Creole English"s,                                                         "gcl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gresi"s,                                                                            "grs"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Groma"s,                                                                            "gro"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gronings"s,                                                                         "gos"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gros Ventre"s,                                                                      "ats"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gua"s,                                                                              "gwx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Guadeloupean Creole French"s,                                                       "gcf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Guahibo"s,                                                                          "guh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Guajajára"s,                                                                        "gub"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Guajá"s,                                                                            "gvj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Guambiano"s,                                                                        "gum"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Guana (Paraguay)"s,                                                                 "gva"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Guanano"s,                                                                          "gvc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Guanyinqiao"s,                                                                      "jiq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Guarani"s,                                                                          "grn"s,   "gn"s, ""s,    true );
  g_languages.emplace_back(u8"Guarayu"s,                                                                          "gyr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Guarequena"s,                                                                       "gae"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Guatemalan Sign Language"s,                                                         "gsm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Guató"s,                                                                            "gta"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Guayabero"s,                                                                        "guo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gudanji"s,                                                                          "nji"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gude"s,                                                                             "gde"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gudu"s,                                                                             "gdu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Guduf-Gava"s,                                                                       "gdf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Guerrero Amuzgo"s,                                                                  "amu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Guerrero Nahuatl"s,                                                                 "ngu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Guevea De Humboldt Zapotec"s,                                                       "zpg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gugubera"s,                                                                         "kkp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Guguyimidjir"s,                                                                     "kky"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Guhu-Samane"s,                                                                      "ghs"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Guianese Creole French"s,                                                           "gcr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Guibei Zhuang"s,                                                                    "zgb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Guiberoua Béte"s,                                                                   "bet"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Guibian Zhuang"s,                                                                   "zgn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Guinea Kpelle"s,                                                                    "gkp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Guinean Sign Language"s,                                                            "gus"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Guiqiong"s,                                                                         "gqi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gujarati"s,                                                                         "guj"s,   "gu"s, ""s,    true );
  g_languages.emplace_back(u8"Gujari"s,                                                                           "gju"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gula (Central African Republic)"s,                                                  "kcm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gula (Chad)"s,                                                                      "glu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gula Iro"s,                                                                         "glj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gula'alaa"s,                                                                        "gmb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gulay"s,                                                                            "gvl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gulf Arabic"s,                                                                      "afb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gumalu"s,                                                                           "gmu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gumatj"s,                                                                           "gnn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gumawana"s,                                                                         "gvs"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gumuz"s,                                                                            "guk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gun"s,                                                                              "guw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gundi"s,                                                                            "gdi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gungu"s,                                                                            "rub"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Guntai"s,                                                                           "gnt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gunwinggu"s,                                                                        "gup"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gupa-Abawa"s,                                                                       "gpa"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gupapuyngu"s,                                                                       "guf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Guragone"s,                                                                         "gge"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Guramalum"s,                                                                        "grz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gurani"s,                                                                           "hac"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gurdjar"s,                                                                          "gdj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gurgula"s,                                                                          "ggg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Guriaso"s,                                                                          "grx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gurindji Kriol"s,                                                                   "gjr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gurinji"s,                                                                          "gue"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gurmana"s,                                                                          "gvm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Guro"s,                                                                             "goa"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gurung"s,                                                                           "gvr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Guruntum-Mbaaru"s,                                                                  "grd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gusii"s,                                                                            "guz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gusilay"s,                                                                          "gsl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Guya"s,                                                                             "gka"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Guyanese Creole English"s,                                                          "gyn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gvoko"s,                                                                            "ngs"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gwa"s,                                                                              "gwb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gwahatike"s,                                                                        "dah"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gwak"s,                                                                             "jgk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gwamhi-Wuri"s,                                                                      "bga"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gwandara"s,                                                                         "gwn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gweda"s,                                                                            "grw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gweno"s,                                                                            "gwe"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gwere"s,                                                                            "gwr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gwich'in"s,                                                                         "gwi"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Gyele"s,                                                                            "gyi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Gyem"s,                                                                             "gye"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Güilá Zapotec"s,                                                                    "ztu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ha"s,                                                                               "haq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Habu"s,                                                                             "hbu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Hadiyya"s,                                                                          "hdy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Hadothi"s,                                                                          "hoj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Hadrami Arabic"s,                                                                   "ayh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Hadza"s,                                                                            "hts"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Haeke"s,                                                                            "aek"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Hahon"s,                                                                            "hah"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Hai//om"s,                                                                          "hgm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Haida"s,                                                                            "hai"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Haigwai"s,                                                                          "hgw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Haiphong Sign Language"s,                                                           "haf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Haisla"s,                                                                           "has"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Haitian Vodoun Culture Language"s,                                                  "hvc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Haitian; Haitian Creole"s,                                                          "hat"s,   "ht"s, ""s,    true );
  g_languages.emplace_back(u8"Haji"s,                                                                             "hji"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Hajong"s,                                                                           "haj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Hakha Chin"s,                                                                       "cnh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Hakka Chinese"s,                                                                    "hak"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Hakö"s,                                                                             "hao"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Halang Doan"s,                                                                      "hld"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Halang"s,                                                                           "hal"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Halbi"s,                                                                            "hlb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Halh Mongolian"s,                                                                   "khk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Halia"s,                                                                            "hla"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Halkomelem"s,                                                                       "hur"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Hamap"s,                                                                            "hmu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Hamba"s,                                                                            "hba"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Hamer-Banna"s,                                                                      "amf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Hamtai"s,                                                                           "hmt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Han"s,                                                                              "haa"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Hanga Hundi"s,                                                                      "wos"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Hanga"s,                                                                            "hag"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Hangaza"s,                                                                          "han"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Hani"s,                                                                             "hni"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Hano"s,                                                                             "lml"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Hanoi Sign Language"s,                                                              "hab"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Hanunoo"s,                                                                          "hnn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Harari"s,                                                                           "har"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Harijan Kinnauri"s,                                                                 "kjo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Haroi"s,                                                                            "hro"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Harsusi"s,                                                                          "hss"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Haruai"s,                                                                           "tmd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Haruku"s,                                                                           "hrk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Haryanvi"s,                                                                         "bgc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Harzani"s,                                                                          "hrz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Hasha"s,                                                                            "ybj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Hassaniyya"s,                                                                       "mey"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Hatam"s,                                                                            "had"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Hausa Sign Language"s,                                                              "hsl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Hausa"s,                                                                            "hau"s,   "ha"s, ""s,    true );
  g_languages.emplace_back(u8"Havasupai-Walapai-Yavapai"s,                                                        "yuf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Haveke"s,                                                                           "hvk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Havu"s,                                                                             "hav"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Hawai'i Creole English"s,                                                           "hwc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Hawai'i Sign Language (HSL)"s,                                                      "hps"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Hawaiian"s,                                                                         "haw"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Haya"s,                                                                             "hay"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Hazaragi"s,                                                                         "haz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Hdi"s,                                                                              "xed"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Hebrew"s,                                                                           "heb"s,   "he"s, ""s,    true );
  g_languages.emplace_back(u8"Hehe"s,                                                                             "heh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Heiban"s,                                                                           "hbn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Heiltsuk"s,                                                                         "hei"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Helambu Sherpa"s,                                                                   "scp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Helong"s,                                                                           "heg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Hema"s,                                                                             "nix"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Hemba"s,                                                                            "hem"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Herdé"s,                                                                            "hed"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Herero"s,                                                                           "her"s,   "hz"s, ""s,    true );
  g_languages.emplace_back(u8"Hewa"s,                                                                             "ham"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Heyo"s,                                                                             "auk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Hidatsa"s,                                                                          "hid"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Higaonon"s,                                                                         "mba"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Highland Konjo"s,                                                                   "kjk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Highland Oaxaca Chontal"s,                                                          "chd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Highland Popoluca"s,                                                                "poi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Highland Puebla Nahuatl"s,                                                          "azz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Highland Totonac"s,                                                                 "tos"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Hijazi Arabic"s,                                                                    "acw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Hijuk"s,                                                                            "hij"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Hiligaynon"s,                                                                       "hil"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Himachali languages; Western Pahari languages"s,                                    "him"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Himarimã"s,                                                                         "hir"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Hindi"s,                                                                            "hin"s,   "hi"s, ""s,    true );
  g_languages.emplace_back(u8"Hinduri"s,                                                                          "hii"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Hinukh"s,                                                                           "gin"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Hiri Motu"s,                                                                        "hmo"s,   "ho"s, ""s,    true );
  g_languages.emplace_back(u8"Hittite"s,                                                                          "hit"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Hitu"s,                                                                             "htu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Hiw"s,                                                                              "hiw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Hixkaryána"s,                                                                       "hix"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Hlai"s,                                                                             "lic"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Hlepho Phowa"s,                                                                     "yhl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Hlersu"s,                                                                           "hle"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Hmar"s,                                                                             "hmr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Hmong Daw"s,                                                                        "mww"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Hmong Don"s,                                                                        "hmf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Hmong Dô"s,                                                                         "hmv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Hmong Njua"s,                                                                       "hnj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Hmong Shua"s,                                                                       "hmz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Hmong; Mong"s,                                                                      "hmn"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Hmwaveke"s,                                                                         "mrk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ho Chi Minh City Sign Language"s,                                                   "hos"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ho"s,                                                                               "hoc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ho-Chunk"s,                                                                         "win"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Hoava"s,                                                                            "hoa"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Hobyót"s,                                                                           "hoh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Hoia Hoia"s,                                                                        "hhi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Holikachuk"s,                                                                       "hoi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Holiya"s,                                                                           "hoy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Holoholo"s,                                                                         "hoo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Holu"s,                                                                             "hol"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Honduras Sign Language"s,                                                           "hds"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Hong Kong Sign Language"s,                                                          "hks"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Honi"s,                                                                             "how"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Hopi"s,                                                                             "hop"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Horned Miao"s,                                                                      "hrm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Horom"s,                                                                            "hoe"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Horpa"s,                                                                            "ero"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Hote"s,                                                                             "hot"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Hoti"s,                                                                             "hti"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Hovongan"s,                                                                         "hov"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Hoyahoya"s,                                                                         "hhy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Hozo"s,                                                                             "hoz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Hpon"s,                                                                             "hpo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Hrangkhol"s,                                                                        "hra"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Hre"s,                                                                              "hre"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Hruso"s,                                                                            "hru"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Hu"s,                                                                               "huo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Huachipaeri"s,                                                                      "hug"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Huallaga Huánuco Quechua"s,                                                         "qub"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Huamalíes-Dos de Mayo Huánuco Quechua"s,                                            "qvh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Huambisa"s,                                                                         "hub"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Huarijio"s,                                                                         "var"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Huastec"s,                                                                          "hus"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Huaulu"s,                                                                           "hud"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Huautla Mazatec"s,                                                                  "mau"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Huaxcaleca Nahuatl"s,                                                               "nhq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Huaylas Ancash Quechua"s,                                                           "qwh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Huaylla Wanca Quechua"s,                                                            "qvw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Huba"s,                                                                             "hbb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Huehuetla Tepehua"s,                                                                "tee"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Huichol"s,                                                                          "hch"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Huilliche"s,                                                                        "huh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Huitepec Mixtec"s,                                                                  "mxs"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Huizhou Chinese"s,                                                                  "czh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Hula"s,                                                                             "hul"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Hulaulá"s,                                                                          "huy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Huli"s,                                                                             "hui"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Hulung"s,                                                                           "huk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Humburi Senni Songhay"s,                                                            "hmb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Humene"s,                                                                           "huf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Humla"s,                                                                            "hut"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Hun-Saare"s,                                                                        "dud"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Hunde"s,                                                                            "hke"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Hung"s,                                                                             "hnu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Hungana"s,                                                                          "hum"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Hungarian Sign Language"s,                                                          "hsh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Hungarian"s,                                                                        "hun"s,   "hu"s, ""s,    true );
  g_languages.emplace_back(u8"Hunjara-Kaina Ke"s,                                                                 "hkk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Hunsrik"s,                                                                          "hrx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Hunzib"s,                                                                           "huz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Hupa"s,                                                                             "hup"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Hupdë"s,                                                                            "jup"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Hupla"s,                                                                            "hap"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Hutterite German"s,                                                                 "geh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Hwana"s,                                                                            "hwo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Hya"s,                                                                              "hya"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Hyam"s,                                                                             "jab"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Hértevin"s,                                                                         "hrt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Hõne"s,                                                                             "juh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"I-Wak"s,                                                                            "iwk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Iaai"s,                                                                             "iai"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Iamalele"s,                                                                         "yml"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Iatmul"s,                                                                           "ian"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Iau"s,                                                                              "tmu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ibali Teke"s,                                                                       "tek"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ibaloi"s,                                                                           "ibl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Iban"s,                                                                             "iba"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Ibanag"s,                                                                           "ibg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ibani"s,                                                                            "iby"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ibatan"s,                                                                           "ivb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ibibio"s,                                                                           "ibb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ibino"s,                                                                            "ibn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ibu"s,                                                                              "ibu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ibuoro"s,                                                                           "ibr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Icelandic Sign Language"s,                                                          "icl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Icelandic"s,                                                                        "ice"s,   "is"s, "isl"s, true );
  g_languages.emplace_back(u8"Iceve-Maci"s,                                                                       "bec"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ida'an"s,                                                                           "dbj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Idakho-Isukha-Tiriki"s,                                                             "ida"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Idaté"s,                                                                            "idt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Idere"s,                                                                            "ide"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Idesa"s,                                                                            "ids"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Idi"s,                                                                              "idi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ido"s,                                                                              "ido"s,   "io"s, ""s,    true );
  g_languages.emplace_back(u8"Idoma"s,                                                                            "idu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Idon"s,                                                                             "idc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Idu-Mishmi"s,                                                                       "clk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Iduna"s,                                                                            "viv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ifè"s,                                                                              "ife"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Igala"s,                                                                            "igl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Igana"s,                                                                            "igg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Igbo"s,                                                                             "ibo"s,   "ig"s, ""s,    true );
  g_languages.emplace_back(u8"Igede"s,                                                                            "ige"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ignaciano"s,                                                                        "ign"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Igo"s,                                                                              "ahl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Iguta"s,                                                                            "nar"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Igwe"s,                                                                             "igw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Iha Based Pidgin"s,                                                                 "ihb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Iha"s,                                                                              "ihp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ihievbe"s,                                                                          "ihi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ija-Zuba"s,                                                                         "vki"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ijo languages"s,                                                                    "ijo"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Ik"s,                                                                               "ikx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ika"s,                                                                              "ikk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ikizu"s,                                                                            "ikz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Iko"s,                                                                              "iki"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ikobi"s,                                                                            "meb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ikoma-Nata-Isenye"s,                                                                "ntk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ikpeng"s,                                                                           "txi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ikpeshi"s,                                                                          "ikp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ikposo"s,                                                                           "kpo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Iku-Gora-Ankwa"s,                                                                   "ikv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ikulu"s,                                                                            "ikl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ikwere"s,                                                                           "ikw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ikwo"s,                                                                             "iqw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ila"s,                                                                              "ilb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ile Ape"s,                                                                          "ila"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ili Turki"s,                                                                        "ili"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ili'uun"s,                                                                          "ilu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ilianen Manobo"s,                                                                   "mbi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Iloko"s,                                                                            "ilo"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Ilongot"s,                                                                          "ilk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ilue"s,                                                                             "ilv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ilwana"s,                                                                           "mlk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Imbabura Highland Quichua"s,                                                        "qvi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Imbongu"s,                                                                          "imo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Imonda"s,                                                                           "imn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Imroing"s,                                                                          "imr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Inabaknon"s,                                                                        "abx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Inapang"s,                                                                          "mzu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Inari Sami"s,                                                                       "smn"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Indian Sign Language"s,                                                             "ins"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Indic languages"s,                                                                  "inc"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Indo-European languages"s,                                                          "ine"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Indo-Portuguese"s,                                                                  "idb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Indonesian Bajau"s,                                                                 "bdl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Indonesian Sign Language"s,                                                         "inl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Indonesian"s,                                                                       "ind"s,   "id"s, ""s,    true );
  g_languages.emplace_back(u8"Indri"s,                                                                            "idr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Indus Kohistani"s,                                                                  "mvy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Inebu One"s,                                                                        "oin"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Inga"s,                                                                             "inb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ingrian"s,                                                                          "izh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ingush"s,                                                                           "inh"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Inlaod Itneg"s,                                                                     "iti"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Inoke-Yate"s,                                                                       "ino"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Inonhan"s,                                                                          "loc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Inor"s,                                                                             "ior"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Inpui Naga"s,                                                                       "nkf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Interlingua (International Auxiliary Language Association)"s,                       "ina"s,   "ia"s, ""s,    true );
  g_languages.emplace_back(u8"Interlingue; Occidental"s,                                                          "ile"s,   "ie"s, ""s,    true );
  g_languages.emplace_back(u8"International Sign"s,                                                               "ils"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Intha"s,                                                                            "int"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Inuinnaqtun"s,                                                                      "ikt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Inuit Sign Language"s,                                                              "iks"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Inuktitut"s,                                                                        "iku"s,   "iu"s, ""s,    true );
  g_languages.emplace_back(u8"Inupiaq"s,                                                                          "ipk"s,   "ik"s, ""s,    true );
  g_languages.emplace_back(u8"Ipalapa Amuzgo"s,                                                                   "azm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ipiko"s,                                                                            "ipo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ipili"s,                                                                            "ipi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ipulo"s,                                                                            "ass"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Iquito"s,                                                                           "iqu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ir"s,                                                                               "irr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Iranian Persian"s,                                                                  "pes"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Iranian languages"s,                                                                "ira"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Iranun (Malaysia)"s,                                                                "ilm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Iranun (Philippines)"s,                                                             "ilp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Iraqw"s,                                                                            "irk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Irarutu"s,                                                                          "irh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Iraya"s,                                                                            "iry"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Iresim"s,                                                                           "ire"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Irigwe"s,                                                                           "iri"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Irish Sign Language"s,                                                              "isg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Irish"s,                                                                            "gle"s,   "ga"s, ""s,    true );
  g_languages.emplace_back(u8"Irish, Middle (900-1200)"s,                                                         "mga"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Irish, Old (to 900)"s,                                                              "sga"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Iroquoian languages"s,                                                              "iro"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Irula"s,                                                                            "iru"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Irántxe"s,                                                                          "irn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Isabi"s,                                                                            "isa"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Isanzu"s,                                                                           "isn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Isarog Agta"s,                                                                      "agk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Isconahua"s,                                                                        "isc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Isebe"s,                                                                            "igo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Isekiri"s,                                                                          "its"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ishkashimi"s,                                                                       "isk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Isinai"s,                                                                           "inn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Isirawa"s,                                                                          "srl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Islander Creole English"s,                                                          "icr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Isnag"s,                                                                            "isd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Isoko"s,                                                                            "iso"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Israeli Sign Language"s,                                                            "isr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Isthmus Mixe"s,                                                                     "mir"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Isthmus Zapotec"s,                                                                  "zai"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Isthmus-Cosoleacaque Nahuatl"s,                                                     "nhk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Isthmus-Mecayapan Nahuatl"s,                                                        "nhx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Isthmus-Pajapan Nahuatl"s,                                                          "nhp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Istriot"s,                                                                          "ist"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Istro Romanian"s,                                                                   "ruo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Isu (Fako Division)"s,                                                              "szv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Isu (Menchum Division)"s,                                                           "isu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Italian Sign Language"s,                                                            "ise"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Italian"s,                                                                          "ita"s,   "it"s, ""s,    true );
  g_languages.emplace_back(u8"Itawit"s,                                                                           "itv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Itelmen"s,                                                                          "itl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Iteri"s,                                                                            "itr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Itik"s,                                                                             "itx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ito"s,                                                                              "itw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Itonama"s,                                                                          "ito"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Itu Mbon Uzo"s,                                                                     "itm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Itundujia Mixtec"s,                                                                 "mce"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Itzá"s,                                                                             "itz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Iu Mien"s,                                                                          "ium"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ivatan"s,                                                                           "ivv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ivbie North-Okpela-Arhe"s,                                                          "atg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Iwaidja"s,                                                                          "ibd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Iwal"s,                                                                             "kbm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Iwam"s,                                                                             "iwm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Iwur"s,                                                                             "iwo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ixcatec"s,                                                                          "ixc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ixcatlán Mazatec"s,                                                                 "mzi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ixil"s,                                                                             "ixl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ixtayutla Mixtec"s,                                                                 "vmj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ixtenco Otomi"s,                                                                    "otz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Iyayu"s,                                                                            "iya"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Iyive"s,                                                                            "uiv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Iyo"s,                                                                              "nca"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Iyo'wujwa Chorote"s,                                                                "crq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Iyojwa'ja Chorote"s,                                                                "crt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Izere"s,                                                                            "izr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Izii"s,                                                                             "izz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Izon"s,                                                                             "ijc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Izora"s,                                                                            "cbo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Iñapari"s,                                                                          "inp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Jabutí"s,                                                                           "jbt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Jad"s,                                                                              "jda"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Jadgali"s,                                                                          "jdg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Jah Hut"s,                                                                          "jah"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Jahanka"s,                                                                          "jad"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Jair Awyu"s,                                                                        "awv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Jakati"s,                                                                           "jat"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Jakun"s,                                                                            "jak"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Jalapa De Díaz Mazatec"s,                                                           "maj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Jalkunan"s,                                                                         "bxl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Jamaican Country Sign Language"s,                                                   "jcs"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Jamaican Creole English"s,                                                          "jam"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Jamaican Sign Language"s,                                                           "jls"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Jamamadí"s,                                                                         "jaa"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Jambi Malay"s,                                                                      "jax"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Jamiltepec Mixtec"s,                                                                "mxt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Jamsay Dogon"s,                                                                     "djm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Jandavra"s,                                                                         "jnd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Jangkang"s,                                                                         "djo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Jangshung"s,                                                                        "jna"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Janji"s,                                                                            "jni"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Japanese Sign Language"s,                                                           "jsl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Japanese"s,                                                                         "jpn"s,   "ja"s, ""s,    true );
  g_languages.emplace_back(u8"Japrería"s,                                                                         "jru"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Jaqaru"s,                                                                           "jqr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Jara"s,                                                                             "jaf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Jarai"s,                                                                            "jra"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Jarawa (India)"s,                                                                   "anq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Jaru"s,                                                                             "ddj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Jauja Wanca Quechua"s,                                                              "qxw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Jaunsari"s,                                                                         "jns"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Javanese"s,                                                                         "jav"s,   "jv"s, ""s,    true );
  g_languages.emplace_back(u8"Jawe"s,                                                                             "jaz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Jaya"s,                                                                             "jyy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Jebero"s,                                                                           "jeb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Jeh"s,                                                                              "jeh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Jehai"s,                                                                            "jhi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Jejueo"s,                                                                           "jje"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Jemez"s,                                                                            "tow"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Jenaama Bozo"s,                                                                     "bze"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Jeng"s,                                                                             "jeg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Jennu Kurumba"s,                                                                    "xuj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Jere"s,                                                                             "jer"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Jeri Kuo"s,                                                                         "jek"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Jerung"s,                                                                           "jee"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Jhankot Sign Language"s,                                                            "jhs"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Jiamao"s,                                                                           "jio"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Jiarong"s,                                                                          "jya"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Jiba"s,                                                                             "juo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Jibu"s,                                                                             "jib"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Jicarilla Apache"s,                                                                 "apj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Jiiddu"s,                                                                           "jii"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Jilbe"s,                                                                            "jie"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Jilim"s,                                                                            "jil"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Jimi (Cameroon)"s,                                                                  "jim"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Jimi (Nigeria)"s,                                                                   "jmi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Jina"s,                                                                             "jia"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Jinyu Chinese"s,                                                                    "cjy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Jiongnai Bunu"s,                                                                    "pnu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Jirel"s,                                                                            "jul"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Jiru"s,                                                                             "jrr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Jita"s,                                                                             "jit"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Jju"s,                                                                              "kaj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Joba"s,                                                                             "job"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Jofotek-Bromnya"s,                                                                  "jbr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Jogi"s,                                                                             "jog"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Jola-Fonyi"s,                                                                       "dyo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Jola-Kasa"s,                                                                        "csk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Jonkor Bourmataguil"s,                                                              "jeu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Jordanian Sign Language"s,                                                          "jos"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Jorto"s,                                                                            "jrt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Jowulu"s,                                                                           "jow"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ju"s,                                                                               "juu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ju/'hoan"s,                                                                         "ktz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Juang"s,                                                                            "jun"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Judeo-Arabic"s,                                                                     "jrb"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Judeo-Berber"s,                                                                     "jbe"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Judeo-Georgian"s,                                                                   "jge"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Judeo-Iraqi Arabic"s,                                                               "yhd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Judeo-Italian"s,                                                                    "itk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Judeo-Moroccan Arabic"s,                                                            "aju"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Judeo-Persian"s,                                                                    "jpr"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Judeo-Tat"s,                                                                        "jdt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Judeo-Tripolitanian Arabic"s,                                                       "yud"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Judeo-Tunisian Arabic"s,                                                            "ajt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Judeo-Yemeni Arabic"s,                                                              "jye"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Jukun Takum"s,                                                                      "jbu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Jumjum"s,                                                                           "jum"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Jumla Sign Language"s,                                                              "jus"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Jumli"s,                                                                            "jml"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Jungle Inga"s,                                                                      "inj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Juquila Mixe"s,                                                                     "mxq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Jur Modo"s,                                                                         "bex"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Juray"s,                                                                            "juy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Jurúna"s,                                                                           "jur"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Juwal"s,                                                                            "mwb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Juxtlahuaca Mixtec"s,                                                               "vmc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Jwira-Pepesa"s,                                                                     "jwi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Jèrriais"s,                                                                         "nrf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Júma"s,                                                                             "jua"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"K'iche'"s,                                                                          "quc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kaamba"s,                                                                           "xku"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kaan"s,                                                                             "ldl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kaang Chin"s,                                                                       "ckn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kaansa"s,                                                                           "gna"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kaba"s,                                                                             "ksp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kabalai"s,                                                                          "kvf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kabardian"s,                                                                        "kbd"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Kabatei"s,                                                                          "xkp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kabiyè"s,                                                                           "kbp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kabola"s,                                                                           "klz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kabore One"s,                                                                       "onk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kabras"s,                                                                           "lkb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kaburi"s,                                                                           "uka"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kabutra"s,                                                                          "kbu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kabuverdianu"s,                                                                     "kea"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kabwa"s,                                                                            "cwa"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kabwari"s,                                                                          "kcw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kabyle"s,                                                                           "kab"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Kachama-Ganjule"s,                                                                  "kcx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kachari"s,                                                                          "xac"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kachhi"s,                                                                           "kfr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kachi Koli"s,                                                                       "gjk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kachin; Jingpho"s,                                                                  "kac"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Kacipo-Balesi"s,                                                                    "koe"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kaco'"s,                                                                            "xkk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kadai"s,                                                                            "kzd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kadar"s,                                                                            "kej"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kadaru"s,                                                                           "kdu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kadazan Dusun"s,                                                                    "dtp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kadiwéu"s,                                                                          "kbc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kadu"s,                                                                             "zkd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kaduo"s,                                                                            "ktp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kaera"s,                                                                            "jka"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kafa"s,                                                                             "kbr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kafoa"s,                                                                            "kpu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kagan Kalagan"s,                                                                    "kll"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kagate"s,                                                                           "syw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kagayanen"s,                                                                        "cgc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kagoma"s,                                                                           "kdm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kagoro"s,                                                                           "xkg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kagulu"s,                                                                           "kki"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kahe"s,                                                                             "hka"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kahua"s,                                                                            "agw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kaian"s,                                                                            "kct"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kaibobo"s,                                                                          "kzb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kaidipang"s,                                                                        "kzp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kaiep"s,                                                                            "kbw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kaikadi"s,                                                                          "kep"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kaike"s,                                                                            "kzq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kaiku"s,                                                                            "kkq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kaimbulawa"s,                                                                       "zka"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kaingang"s,                                                                         "kgp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kairak"s,                                                                           "ckr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kairiru"s,                                                                          "kxa"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kairui-Midiki"s,                                                                    "krd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kais"s,                                                                             "kzm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kaivi"s,                                                                            "kce"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kaiwá"s,                                                                            "kgk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kaiy"s,                                                                             "tcq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kajakse"s,                                                                          "ckq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kajali"s,                                                                           "xkj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kajaman"s,                                                                          "kag"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kakabai"s,                                                                          "kqf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kakabe"s,                                                                           "kke"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kakanda"s,                                                                          "kka"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kaki Ae"s,                                                                          "tbd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kako"s,                                                                             "kkj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kakwa"s,                                                                            "keo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kala Lagaw Ya"s,                                                                    "mwp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kalaallisut; Greenlandic"s,                                                         "kal"s,   "kl"s, ""s,    true );
  g_languages.emplace_back(u8"Kalabakan"s,                                                                        "kve"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kalabari"s,                                                                         "ijn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kalabra"s,                                                                          "kzz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kalagan"s,                                                                          "kqe"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kalaktang Monpa"s,                                                                  "kkf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kalam"s,                                                                            "kmh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kalami"s,                                                                           "gwc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kalamsé"s,                                                                          "knz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kalanadi"s,                                                                         "wkl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kalanga"s,                                                                          "kck"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kalanguya"s,                                                                        "kak"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kalao"s,                                                                            "kly"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kalapuya"s,                                                                         "kyl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kalasha"s,                                                                          "kls"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kalenjin"s,                                                                         "kln"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kalispel-Pend d'Oreille"s,                                                          "fla"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kalkoti"s,                                                                          "xka"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kalmyk; Oirat"s,                                                                    "xal"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Kalo Finnish Romani"s,                                                              "rmf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kalou"s,                                                                            "ywa"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kaluli"s,                                                                           "bco"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kalumpang"s,                                                                        "kli"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kam"s,                                                                              "kdx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kamang"s,                                                                           "woi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kamano"s,                                                                           "kbq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kamantan"s,                                                                         "kci"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kamar"s,                                                                            "keq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kamara"s,                                                                           "jmr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kamarian"s,                                                                         "kzx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kamaru"s,                                                                           "kgx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kamasa"s,                                                                           "klp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kamasau"s,                                                                          "kms"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kamayo"s,                                                                           "kyk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kamayurá"s,                                                                         "kay"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kamba"s,                                                                            "kam"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Kambaata"s,                                                                         "ktb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kambaira"s,                                                                         "kyy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kambera"s,                                                                          "xbr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kamberau"s,                                                                         "irx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kami (Nigeria)"s,                                                                   "kmi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kami (Tanzania)"s,                                                                  "kcu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kamo"s,                                                                             "kcq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kamoro"s,                                                                           "kgq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kamula"s,                                                                           "xla"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kamviri"s,                                                                          "xvi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kamwe"s,                                                                            "hig"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kanakanabu"s,                                                                       "xnb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kanamarí"s,                                                                         "knm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kanan"s,                                                                            "zkn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kanashi"s,                                                                          "xns"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kanasi"s,                                                                           "soq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kanauji"s,                                                                          "bjj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kandas"s,                                                                           "kqw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kandawo"s,                                                                          "gam"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kande"s,                                                                            "kbs"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kanembu"s,                                                                          "kbl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kang"s,                                                                             "kyp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kanga"s,                                                                            "kcp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kangean"s,                                                                          "kkv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kanggape"s,                                                                         "igm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kangjia"s,                                                                          "kxs"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kango (Bas-Uélé District)"s,                                                        "kty"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kango (Tshopo District)"s,                                                          "kzy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kangri"s,                                                                           "xnr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kanikkaran"s,                                                                       "kev"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kaningdon-Nindem"s,                                                                 "kdp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kaningi"s,                                                                          "kzo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kaningra"s,                                                                         "knr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kaninuwa"s,                                                                         "wat"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kanite"s,                                                                           "kmu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kanjari"s,                                                                          "kft"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kanju"s,                                                                            "kbe"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kankanaey"s,                                                                        "kne"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kannada Kurumba"s,                                                                  "kfi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kannada"s,                                                                          "kan"s,   "kn"s, ""s,    true );
  g_languages.emplace_back(u8"Kanowit-Tanjong Melanau"s,                                                          "kxn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kansa"s,                                                                            "ksk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kantosi"s,                                                                          "xkt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kanu"s,                                                                             "khx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kanufi"s,                                                                           "kni"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kanuri"s,                                                                           "kau"s,   "kr"s, ""s,    true );
  g_languages.emplace_back(u8"Kanyok"s,                                                                           "kny"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kao"s,                                                                              "kax"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kaonde"s,                                                                           "kqn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kap"s,                                                                              "ykm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kapin"s,                                                                            "tbx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kapingamarangi"s,                                                                   "kpg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kapori"s,                                                                           "khp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kapriman"s,                                                                         "dju"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kaptiau"s,                                                                          "kbi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kapya"s,                                                                            "klo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kaqchikel"s,                                                                        "cak"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kara (Central African Republic)"s,                                                  "kah"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kara (Papua New Guinea)"s,                                                          "leu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kara (Tanzania)"s,                                                                  "reg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kara-Kalpak"s,                                                                      "kaa"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Karachay-Balkar"s,                                                                  "krc"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Karadjeri"s,                                                                        "gbd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Karagas"s,                                                                          "kim"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Karaim"s,                                                                           "kdr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Karajá"s,                                                                           "kpj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Karamojong"s,                                                                       "kdj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Karang"s,                                                                           "kzr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Karanga"s,                                                                          "kth"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Karao"s,                                                                            "kyj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Karas"s,                                                                            "kgv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Karata"s,                                                                           "kpt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Karawa"s,                                                                           "xrw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Karbi"s,                                                                            "mjw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kare (Central African Republic)"s,                                                  "kbn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kare (Papua New Guinea)"s,                                                          "kmf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Karekare"s,                                                                         "kai"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Karelian"s,                                                                         "krl"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Karen languages"s,                                                                  "kar"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Karey"s,                                                                            "kyd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kari"s,                                                                             "kbj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Karingani"s,                                                                        "kgn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Karipuna"s,                                                                         "kuq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Karipúna Creole French"s,                                                           "kmv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Karitiâna"s,                                                                        "ktn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kariya"s,                                                                           "kil"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Karkar-Yuri"s,                                                                      "yuj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Karko"s,                                                                            "kko"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Karnai"s,                                                                           "bbv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Karo (Brazil)"s,                                                                    "arr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Karo (Ethiopia)"s,                                                                  "kxh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Karok"s,                                                                            "kyh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Karon Dori"s,                                                                       "kgw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Karon"s,                                                                            "krx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Karore"s,                                                                           "xkx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kasanga"s,                                                                          "ccj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kasem"s,                                                                            "xsm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kashaya"s,                                                                          "kju"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kashmiri"s,                                                                         "kas"s,   "ks"s, ""s,    true );
  g_languages.emplace_back(u8"Kashubian"s,                                                                        "csb"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Kasiguranin"s,                                                                      "ksn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kaska"s,                                                                            "kkz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kasua"s,                                                                            "khs"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kataang"s,                                                                          "kgd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Katawixi"s,                                                                         "xat"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Katbol"s,                                                                           "tmb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Katcha-Kadugli-Miri"s,                                                              "xtc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kathoriya Tharu"s,                                                                  "tkt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kathu"s,                                                                            "ykt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kati"s,                                                                             "bsh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Katkari"s,                                                                          "kfu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Katla"s,                                                                            "kcr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Katso"s,                                                                            "kaf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Katua"s,                                                                            "kta"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Katukína"s,                                                                         "kav"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kaulong"s,                                                                          "pss"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kaur"s,                                                                             "vkk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kaure"s,                                                                            "bpp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kauwera"s,                                                                          "xau"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kavalan"s,                                                                          "ckv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kavet"s,                                                                            "krv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kawacha"s,                                                                          "kcb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kawaiisu"s,                                                                         "xaw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kawe"s,                                                                             "kgb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kawi"s,                                                                             "kaw"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Kaxararí"s,                                                                         "ktx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kayabí"s,                                                                           "kyz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kayagar"s,                                                                          "kyt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kayan Mahakam"s,                                                                    "xay"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kayan River Kayan"s,                                                                "xkn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kayan"s,                                                                            "pdu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kayapó"s,                                                                           "txu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kayardild"s,                                                                        "gyd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kayaw"s,                                                                            "kvl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kayeli"s,                                                                           "kzl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kayong"s,                                                                           "kxy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kayort"s,                                                                           "kyv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kaytetye"s,                                                                         "gbb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kayupulau"s,                                                                        "kzu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kazakh"s,                                                                           "kaz"s,   "kk"s, ""s,    true );
  g_languages.emplace_back(u8"Ke'o"s,                                                                             "xxk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Keak"s,                                                                             "keh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Keapara"s,                                                                          "khz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kedah Malay"s,                                                                      "meo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kedang"s,                                                                           "ksx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Keder"s,                                                                            "kdy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kehu"s,                                                                             "khh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kei"s,                                                                              "kei"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Keiga"s,                                                                            "kec"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kein"s,                                                                             "bmh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Keiyo"s,                                                                            "eyo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kekchí"s,                                                                           "kek"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kela (Democratic Republic of Congo)"s,                                              "kel"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kela (Papua New Guinea)"s,                                                          "kcl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kelabit"s,                                                                          "kzi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kele (Democratic Republic of Congo)"s,                                              "khy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kele (Papua New Guinea)"s,                                                          "sbc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Keley-I Kallahan"s,                                                                 "ify"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Keliko"s,                                                                           "kbo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kelo"s,                                                                             "xel"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kelon"s,                                                                            "kyo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kemak"s,                                                                            "kem"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kembayan"s,                                                                         "xem"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kemberano"s,                                                                        "bzp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kembra"s,                                                                           "xkw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kemedzung"s,                                                                        "dmo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kemiehua"s,                                                                         "kfj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kemtuik"s,                                                                          "kmt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kenati"s,                                                                           "gat"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kendayan"s,                                                                         "knx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kendeje"s,                                                                          "klf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kendem"s,                                                                           "kvm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kenga"s,                                                                            "kyq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Keningau Murut"s,                                                                   "kxi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Keninjal"s,                                                                         "knl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kensiu"s,                                                                           "kns"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kenswei Nsei"s,                                                                     "ndb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kenyan Sign Language"s,                                                             "xki"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kenyang"s,                                                                          "ken"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kenyi"s,                                                                            "lke"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kenzi"s,                                                                            "xnz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Keoru-Ahia"s,                                                                       "xeu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kepo'"s,                                                                            "kuk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kera"s,                                                                             "ker"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kerak"s,                                                                            "hhr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kereho"s,                                                                           "xke"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kerewe"s,                                                                           "ked"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kerewo"s,                                                                           "kxz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kerinci"s,                                                                          "kvr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kesawai"s,                                                                          "xes"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ket"s,                                                                              "ket"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kete"s,                                                                             "kcv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ketengban"s,                                                                        "xte"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ketum"s,                                                                            "ktt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Keyagana"s,                                                                         "kyg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kgalagadi"s,                                                                        "xkv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Khakas"s,                                                                           "kjh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Khalaj"s,                                                                           "kjf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Khaling"s,                                                                          "klr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Khamba"s,                                                                           "kbg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Khams Tibetan"s,                                                                    "khg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Khamti"s,                                                                           "kht"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Khamyang"s,                                                                         "ksu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Khana"s,                                                                            "ogo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Khandesi"s,                                                                         "khn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Khanty"s,                                                                           "kca"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Khao"s,                                                                             "xao"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kharam Naga"s,                                                                      "kfw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kharia Thar"s,                                                                      "ksy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kharia"s,                                                                           "khr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Khasi"s,                                                                            "kha"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Khayo"s,                                                                            "lko"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Khe"s,                                                                              "kqg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Khehek"s,                                                                           "tlx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Khengkha"s,                                                                         "xkf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Khetrani"s,                                                                         "xhe"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Khezha Naga"s,                                                                      "nkh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Khiamniungan Naga"s,                                                                "kix"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Khinalugh"s,                                                                        "kjj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Khirwar"s,                                                                          "kwx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Khisa"s,                                                                            "kqm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Khlor"s,                                                                            "llo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Khlula"s,                                                                           "ykl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Khmu"s,                                                                             "kjg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kho'ini"s,                                                                          "xkc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Khoekhoe"s,                                                                         "naq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Khoibu Naga"s,                                                                      "nkb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Khoisan languages"s,                                                                "khi"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Kholok"s,                                                                           "ktc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Khorasani Turkish"s,                                                                "kmz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Khotanese; Sakan"s,                                                                 "kho"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Khowar"s,                                                                           "khw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Khua"s,                                                                             "xhv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Khuen"s,                                                                            "khf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Khumi Chin"s,                                                                       "cnk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Khunsari"s,                                                                         "kfm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Khvarshi"s,                                                                         "khv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kháng"s,                                                                            "kjm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Khün"s,                                                                             "kkh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kibet"s,                                                                            "kie"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kibiri"s,                                                                           "prm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kickapoo"s,                                                                         "kic"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kikai"s,                                                                            "kzg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kikuyu; Gikuyu"s,                                                                   "kik"s,   "ki"s, ""s,    true );
  g_languages.emplace_back(u8"Kildin Sami"s,                                                                      "sjd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kilivila"s,                                                                         "kij"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kiliwa"s,                                                                           "klb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kilmeri"s,                                                                          "kih"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kim Mun"s,                                                                          "mji"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kim"s,                                                                              "kia"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kimaama"s,                                                                          "kig"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kimaragang"s,                                                                       "kqr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kimbu"s,                                                                            "kiv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kimbundu"s,                                                                         "kmb"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Kimki"s,                                                                            "sbt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kimré"s,                                                                            "kqp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kinabalian"s,                                                                       "cbw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kinalakna"s,                                                                        "kco"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kinamiging Manobo"s,                                                                "mkx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kinaray-A"s,                                                                        "krj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kinga"s,                                                                            "zga"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kinnauri"s,                                                                         "kfk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kintaq"s,                                                                           "knq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kinuku"s,                                                                           "kkd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kinyarwanda"s,                                                                      "kin"s,   "rw"s, ""s,    true );
  g_languages.emplace_back(u8"Kioko"s,                                                                            "ues"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kiong"s,                                                                            "kkm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kiorr"s,                                                                            "xko"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kiowa Apache"s,                                                                     "apk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kiowa"s,                                                                            "kio"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kipsigis"s,                                                                         "sgc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kiput"s,                                                                            "kyi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kir-Balar"s,                                                                        "kkr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kire"s,                                                                             "geb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kirghiz; Kyrgyz"s,                                                                  "kir"s,   "ky"s, ""s,    true );
  g_languages.emplace_back(u8"Kirike"s,                                                                           "okr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kirikiri"s,                                                                         "kiy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kirmanjki (individual language)"s,                                                  "kiu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kirya-Konzəl"s,                                                                     "fkk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kis"s,                                                                              "kis"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kisa"s,                                                                             "lks"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kisan"s,                                                                            "xis"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kisankasa"s,                                                                        "kqh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kisar"s,                                                                            "kje"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kisi"s,                                                                             "kiz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kistane"s,                                                                          "gru"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kita Maninkakan"s,                                                                  "mwk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kitja"s,                                                                            "gia"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kituba (Congo)"s,                                                                   "mkw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kituba (Democratic Republic of Congo)"s,                                            "ktu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kiunum"s,                                                                           "wei"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kla-Dan"s,                                                                          "lda"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Klao"s,                                                                             "klu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Klias River Kadazan"s,                                                              "kqt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Klingon; tlhIngan-Hol"s,                                                            "tlh"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Ko"s,                                                                               "fuj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Koalib"s,                                                                           "kib"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Koasati"s,                                                                          "cku"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Koba"s,                                                                             "kpd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kobiana"s,                                                                          "kcj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kobol"s,                                                                            "kgu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kobon"s,                                                                            "kpw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Koch"s,                                                                             "kdq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kochila Tharu"s,                                                                    "thq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Koda"s,                                                                             "cdz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kodaku"s,                                                                           "ksz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kodava"s,                                                                           "kfa"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kodeoha"s,                                                                          "vko"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kodi"s,                                                                             "kod"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kodia"s,                                                                            "kwp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Koenoem"s,                                                                          "kcs"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kofa"s,                                                                             "kso"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kofei"s,                                                                            "kpi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kofyar"s,                                                                           "kwl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kohin"s,                                                                            "kkx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kohistani Shina"s,                                                                  "plk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Koho"s,                                                                             "kpm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kohumono"s,                                                                         "bcs"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Koi"s,                                                                              "kkt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Koireng"s,                                                                          "nkd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Koitabu"s,                                                                          "kqi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Koiwat"s,                                                                           "kxt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kok Borok"s,                                                                        "trp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kokata"s,                                                                           "ktd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Koke"s,                                                                             "kou"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Koki Naga"s,                                                                        "nxk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kokoda"s,                                                                           "xod"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kokola"s,                                                                           "kzn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kokota"s,                                                                           "kkk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kol (Bangladesh)"s,                                                                 "ekl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kol (Cameroon)"s,                                                                   "biw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kol (Papua New Guinea)"s,                                                           "kol"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kola"s,                                                                             "kvv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kolbila"s,                                                                          "klc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kolibugan Subanon"s,                                                                "skn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Koluwawa"s,                                                                         "klx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kom (Cameroon)"s,                                                                   "bkm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kom (India)"s,                                                                      "kmm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Koma"s,                                                                             "kmy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Komba"s,                                                                            "kpf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kombai"s,                                                                           "tyn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kombio"s,                                                                           "xbi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Komering"s,                                                                         "kge"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Komi"s,                                                                             "kom"s,   "kv"s, ""s,    true );
  g_languages.emplace_back(u8"Komi-Permyak"s,                                                                     "koi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Komi-Zyrian"s,                                                                      "kpv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kominimung"s,                                                                       "xoi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Komo (Democratic Republic of Congo)"s,                                              "kmw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Komo (Sudan)"s,                                                                     "xom"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Komodo"s,                                                                           "kvh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kompane"s,                                                                          "kvp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Komyandaret"s,                                                                      "kzv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kon Keu"s,                                                                          "kkn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Konai"s,                                                                            "kxw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Konda"s,                                                                            "knd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Konda-Dora"s,                                                                       "kfc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Koneraw"s,                                                                          "kdw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kongo"s,                                                                            "kon"s,   "kg"s, ""s,    true );
  g_languages.emplace_back(u8"Konkani (individual language)"s,                                                    "knn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Konkani"s,                                                                          "kok"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Konkomba"s,                                                                         "xon"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Konni"s,                                                                            "kma"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kono (Guinea)"s,                                                                    "knu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kono (Nigeria)"s,                                                                   "klk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kono (Sierra Leone)"s,                                                              "kno"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Konomala"s,                                                                         "koa"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Konongo"s,                                                                          "kcz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Konso"s,                                                                            "kxc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Konyak Naga"s,                                                                      "nbe"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Konyanka Maninka"s,                                                                 "mku"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Konzo"s,                                                                            "koo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Koongo"s,                                                                           "kng"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Koonzime"s,                                                                         "ozm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Koorete"s,                                                                          "kqy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kopar"s,                                                                            "xop"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kopkaka"s,                                                                          "opk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Korafe-Yegha"s,                                                                     "kpr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Korak"s,                                                                            "koz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Korandje"s,                                                                         "kcy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Korean Sign Language"s,                                                             "kvk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Korean"s,                                                                           "kor"s,   "ko"s, ""s,    true );
  g_languages.emplace_back(u8"Koreguaje"s,                                                                        "coe"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Koresh-e Rostam"s,                                                                  "okh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Korku"s,                                                                            "kfq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Korlai Creole Portuguese"s,                                                         "vkp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Koro (Côte d'Ivoire)"s,                                                             "kfo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Koro (India)"s,                                                                     "jkr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Koro (Papua New Guinea)"s,                                                          "kxr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Koro (Vanuatu)"s,                                                                   "krf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Koro Wachi"s,                                                                       "bqv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Koromfé"s,                                                                          "kfz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Koromira"s,                                                                         "kqj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Koronadal Blaan"s,                                                                  "bpr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Koroni"s,                                                                           "xkq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Korop"s,                                                                            "krp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Koroshi"s,                                                                          "ktl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Korowai"s,                                                                          "khe"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Korra Koraga"s,                                                                     "kfd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Korubo"s,                                                                           "xor"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Korupun-Sela"s,                                                                     "kpq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Korwa"s,                                                                            "kfp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Koryak"s,                                                                           "kpy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kosadle"s,                                                                          "kiq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kosarek Yale"s,                                                                     "kkl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kosena"s,                                                                           "kze"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Koshin"s,                                                                           "kid"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kosraean"s,                                                                         "kos"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Kota (Gabon)"s,                                                                     "koq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kota (India)"s,                                                                     "kfe"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kota Bangun Kutai Malay"s,                                                          "mqg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kota Marudu Talantang"s,                                                            "grm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kotafon Gbe"s,                                                                      "kqk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Koti"s,                                                                             "eko"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kouya"s,                                                                            "kyf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kovai"s,                                                                            "kqb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kove"s,                                                                             "kvc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kowaki"s,                                                                           "xow"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kowiai"s,                                                                           "kwh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Koy Sanjaq Surat"s,                                                                 "kqd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Koya"s,                                                                             "kff"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Koyaga"s,                                                                           "kga"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Koyo"s,                                                                             "koh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Koyra Chiini Songhay"s,                                                             "khq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Koyraboro Senni Songhai"s,                                                          "ses"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Koyukon"s,                                                                          "koy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kpagua"s,                                                                           "kuw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kpala"s,                                                                            "kpl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kpan"s,                                                                             "kpk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kpasam"s,                                                                           "pbn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kpatili"s,                                                                          "kym"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kpeego"s,                                                                           "cpo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kpelle"s,                                                                           "kpe"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Kpessi"s,                                                                           "kef"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kplang"s,                                                                           "kph"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Krache"s,                                                                           "kye"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Krahô"s,                                                                            "xra"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kraol"s,                                                                            "rka"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Krenak"s,                                                                           "kqq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kreye"s,                                                                            "xre"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Krikati-Timbira"s,                                                                  "xri"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Krim"s,                                                                             "krm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Krio"s,                                                                             "kri"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kriol"s,                                                                            "rop"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Krisa"s,                                                                            "ksi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Krobu"s,                                                                            "kxb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Krongo"s,                                                                           "kgo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kru languages"s,                                                                    "kro"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Kru'ng 2"s,                                                                         "krr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Krymchak"s,                                                                         "jct"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kryts"s,                                                                            "kry"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kua"s,                                                                              "tyu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kua-nsi"s,                                                                          "ykn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kuamasi"s,                                                                          "yku"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kuan"s,                                                                             "uan"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kuanhua"s,                                                                          "xnh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kuanua"s,                                                                           "ksd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kuanyama; Kwanyama"s,                                                               "kua"s,   "kj"s, ""s,    true );
  g_languages.emplace_back(u8"Kube"s,                                                                             "kgf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kubo"s,                                                                             "jko"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kubu"s,                                                                             "kvb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kucong"s,                                                                           "lkc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kudiya"s,                                                                           "kfg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kudmali"s,                                                                          "kyw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kudu-Camo"s,                                                                        "kov"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kugama"s,                                                                           "kow"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kugbo"s,                                                                            "kes"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kui (India)"s,                                                                      "kxu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kui (Indonesia)"s,                                                                  "kvd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kuijau"s,                                                                           "dkr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kuikúro-Kalapálo"s,                                                                 "kui"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kujarge"s,                                                                          "vkj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kuk"s,                                                                              "kfn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kukatja"s,                                                                          "kux"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kuke"s,                                                                             "ght"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kukele"s,                                                                           "kez"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kukna"s,                                                                            "kex"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kuku-Muminh"s,                                                                      "xmh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kuku-Uwanh"s,                                                                       "uwa"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kuku-Yalanji"s,                                                                     "gvn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kula"s,                                                                             "tpg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kulere"s,                                                                           "kul"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kulfa"s,                                                                            "kxj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kulina Pano"s,                                                                      "xpk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kulisusu"s,                                                                         "vkl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kullu Pahari"s,                                                                     "kfx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kulon-Pazeh"s,                                                                      "uun"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kulung (Nepal)"s,                                                                   "kle"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kulung (Nigeria)"s,                                                                 "bbu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kumalu"s,                                                                           "ksl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kumam"s,                                                                            "kdi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kuman (Papua New Guinea)"s,                                                         "kue"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kumaoni"s,                                                                          "kfy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kumarbhag Paharia"s,                                                                "kmj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kumba"s,                                                                            "ksm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kumbainggar"s,                                                                      "kgs"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kumbaran"s,                                                                         "wkb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kumbewaha"s,                                                                        "xks"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kumhali"s,                                                                          "kra"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kumiai"s,                                                                           "dih"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kumukio"s,                                                                          "kuo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kumyk"s,                                                                            "kum"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Kumzari"s,                                                                          "zum"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kunama"s,                                                                           "kun"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kunbarlang"s,                                                                       "wlg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kunda"s,                                                                            "kdn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kundal Shahi"s,                                                                     "shd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kunduvadi"s,                                                                        "wku"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kung"s,                                                                             "kfl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kung-Ekoka"s,                                                                       "knw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kuni"s,                                                                             "kse"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kuni-Boazi"s,                                                                       "kvg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kunigami"s,                                                                         "xug"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kunimaipa"s,                                                                        "kup"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kunja"s,                                                                            "pep"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kunjen"s,                                                                           "kjn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kunyi"s,                                                                            "njx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kuo"s,                                                                              "xuo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kuot"s,                                                                             "kto"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kupa"s,                                                                             "kug"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kupang Malay"s,                                                                     "mkn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kupia"s,                                                                            "key"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kupsabiny"s,                                                                        "kpz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kur"s,                                                                              "kuv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kura Ede Nago"s,                                                                    "nqk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kurama"s,                                                                           "krh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kuranko"s,                                                                          "knk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kurdish"s,                                                                          "kur"s,   "ku"s, ""s,    true );
  g_languages.emplace_back(u8"Kuri"s,                                                                             "nbn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kuria"s,                                                                            "kuj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kurichiya"s,                                                                        "kfh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kurmukar"s,                                                                         "kfv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kurnai"s,                                                                           "unn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kurrama"s,                                                                          "vku"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kurti"s,                                                                            "ktm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kurtokha"s,                                                                         "xkz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kurudu"s,                                                                           "kjr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kurukh"s,                                                                           "kru"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Kuruáya"s,                                                                          "kyr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kusaal"s,                                                                           "kus"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kusaghe"s,                                                                          "ksg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kushi"s,                                                                            "kuh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kusu"s,                                                                             "ksv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kusunda"s,                                                                          "kgg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kutenai"s,                                                                          "kut"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Kutep"s,                                                                            "kub"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kutong"s,                                                                           "skm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kutto"s,                                                                            "kpa"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kutu"s,                                                                             "kdc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kuturmi"s,                                                                          "khj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kuuku-Ya'u"s,                                                                       "kuy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kuvale"s,                                                                           "olu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kuvi"s,                                                                             "kxv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kuwaa"s,                                                                            "blh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kuwaataay"s,                                                                        "cwt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kuy"s,                                                                              "kdt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kven Finnish"s,                                                                     "fkv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kwa"s,                                                                              "kwb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kwa'"s,                                                                             "bko"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kwaami"s,                                                                           "ksq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kwaio"s,                                                                            "kwd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kwaja"s,                                                                            "kdz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kwakiutl"s,                                                                         "kwk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kwakum"s,                                                                           "kwu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kwama"s,                                                                            "kmq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kwambi"s,                                                                           "kwm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kwamera"s,                                                                          "tnk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kwami"s,                                                                            "ktf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kwamtim One"s,                                                                      "okk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kwang"s,                                                                            "kvi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kwanga"s,                                                                           "kwj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kwangali"s,                                                                         "kwn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kwanja"s,                                                                           "knp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kwara'ae"s,                                                                         "kwf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kwasio"s,                                                                           "nmg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kwaya"s,                                                                            "kya"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kwaza"s,                                                                            "xwa"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kwegu"s,                                                                            "xwg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kwer"s,                                                                             "kwr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kwerba Mamberamo"s,                                                                 "xwr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kwerba"s,                                                                           "kwe"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kwere"s,                                                                            "cwe"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kwerisa"s,                                                                          "kkb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kwese"s,                                                                            "kws"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kwesten"s,                                                                          "kwt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kwini"s,                                                                            "gww"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kwinsu"s,                                                                           "kuc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kwinti"s,                                                                           "kww"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kwoma"s,                                                                            "kmo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kwomtari"s,                                                                         "kwo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kxoe"s,                                                                             "xuu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kyak"s,                                                                             "bka"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kyaka"s,                                                                            "kyc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kyan-Karyaw Naga"s,                                                                 "nqq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kyanga"s,                                                                           "tye"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kyenele"s,                                                                          "kql"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kyerung"s,                                                                          "kgy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kâte"s,                                                                             "kmg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kélé"s,                                                                             "keb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kölsch"s,                                                                           "ksh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Kɛlɛngaxo Bozo"s,                                                                   "bzx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"La'bi"s,                                                                            "lbi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Laal"s,                                                                             "gdm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Laari"s,                                                                            "ldi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Laba"s,                                                                             "lau"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Label"s,                                                                            "lbb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Labir"s,                                                                            "jku"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Labo Phowa"s,                                                                       "ypb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Labo"s,                                                                             "mwi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Labu"s,                                                                             "lbu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Labuk-Kinabatangan Kadazan"s,                                                       "dtb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lacandon"s,                                                                         "lac"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lachi"s,                                                                            "lbt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lachiguiri Zapotec"s,                                                               "zpa"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lachixío Zapotec"s,                                                                 "zpl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ladakhi"s,                                                                          "lbj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ladin"s,                                                                            "lld"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ladino"s,                                                                           "lad"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Laeko-Libuat"s,                                                                     "lkl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lafofa"s,                                                                           "laf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Laghu"s,                                                                            "lgb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Laghuu"s,                                                                           "lgh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lagwan"s,                                                                           "kot"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Laha (Indonesia)"s,                                                                 "lhh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Laha (Viet Nam)"s,                                                                  "lha"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lahanan"s,                                                                          "lhn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lahnda"s,                                                                           "lah"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Lahta Karen"s,                                                                      "kvt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lahu Shi"s,                                                                         "lhi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lahu"s,                                                                             "lhu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lahul Lohar"s,                                                                      "lhl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Laimbue"s,                                                                          "lmx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Laitu Chin"s,                                                                       "clj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Laiyolo"s,                                                                          "lji"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lak"s,                                                                              "lbe"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Laka (Chad)"s,                                                                      "lap"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Laka (Nigeria)"s,                                                                   "lak"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lakalei"s,                                                                          "lka"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lake Miwok"s,                                                                       "lmw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lakha"s,                                                                            "lkh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Laki"s,                                                                             "lki"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lakkia"s,                                                                           "lbc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lakon"s,                                                                            "lkn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lakondê"s,                                                                          "lkd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lakota Dida"s,                                                                      "dic"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lakota"s,                                                                           "lkt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lala"s,                                                                             "nrz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lala-Bisa"s,                                                                        "leb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lala-Roba"s,                                                                        "lla"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lalana Chinantec"s,                                                                 "cnl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lalia"s,                                                                            "lal"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lama (Togo)"s,                                                                      "las"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lama Bai"s,                                                                         "lay"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lamaholot"s,                                                                        "slp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lamalera"s,                                                                         "lmr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lamang"s,                                                                           "hia"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lamatuka"s,                                                                         "lmq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lamba"s,                                                                            "lam"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Lambadi"s,                                                                          "lmn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lambayeque Quechua"s,                                                               "quf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lambichhong"s,                                                                      "lmh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lamboya"s,                                                                          "lmy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lambya"s,                                                                           "lai"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lame"s,                                                                             "bma"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lamenu"s,                                                                           "lmu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lamet"s,                                                                            "lbn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lamja-Dengsa-Tola"s,                                                                "ldh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lamkang"s,                                                                          "lmk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lamma"s,                                                                            "lev"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lamnso'"s,                                                                          "lns"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lamogai"s,                                                                          "lmg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lampung Api"s,                                                                      "ljp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lampung Nyo"s,                                                                      "abl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lamu"s,                                                                             "llh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lanas Lobu"s,                                                                       "ruu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Land Dayak languages"s,                                                             "day"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Landoma"s,                                                                          "ldm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lang'e"s,                                                                           "yne"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Langam"s,                                                                           "lnm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Langbashe"s,                                                                        "lna"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Langi"s,                                                                            "lag"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Langnian Buyang"s,                                                                  "yln"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lango (Sudan)"s,                                                                    "lno"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lango (Uganda)"s,                                                                   "laj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Langue des signes de Belgique Francophone"s,                                        "sfb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lanoh"s,                                                                            "lnh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lao Naga"s,                                                                         "nlq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lao"s,                                                                              "lao"s,   "lo"s, ""s,    true );
  g_languages.emplace_back(u8"Laomian"s,                                                                          "lwm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Laopang"s,                                                                          "lbg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Laos Sign Language"s,                                                               "lso"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lapaguía-Guivini Zapotec"s,                                                         "ztl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Larantuka Malay"s,                                                                  "lrt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lardil"s,                                                                           "lbz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Larevat"s,                                                                          "lrv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Large Flowery Miao"s,                                                               "hmd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lari"s,                                                                             "lrl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Larike-Wakasihu"s,                                                                  "alo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Laro"s,                                                                             "lro"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Larteh"s,                                                                           "lar"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Laru"s,                                                                             "lan"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lasalimu"s,                                                                         "llm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lasgerdi"s,                                                                         "lsa"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lashi"s,                                                                            "lsi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lasi"s,                                                                             "lss"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Latgalian"s,                                                                        "ltg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Latin"s,                                                                            "lat"s,   "la"s, ""s,    true );
  g_languages.emplace_back(u8"Latu"s,                                                                             "ltu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Latundê"s,                                                                          "ltn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Latvian Sign Language"s,                                                            "lsl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Latvian"s,                                                                          "lav"s,   "lv"s, ""s,    true );
  g_languages.emplace_back(u8"Lau"s,                                                                              "llu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Laua"s,                                                                             "luf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lauan"s,                                                                            "llx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lauje"s,                                                                            "law"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Laura"s,                                                                            "lur"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lautu Chin"s,                                                                       "clt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lavatbura-Lamusong"s,                                                               "lbv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lave"s,                                                                             "brb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Laven"s,                                                                            "lbo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lavukaleve"s,                                                                       "lvk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lawangan"s,                                                                         "lbx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lawu"s,                                                                             "lwu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lawunuia"s,                                                                         "tgi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Layakha"s,                                                                          "lya"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Laz"s,                                                                              "lzz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lealao Chinantec"s,                                                                 "cle"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Leco"s,                                                                             "lec"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ledo Kaili"s,                                                                       "lew"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Leelau"s,                                                                           "ldk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lefa"s,                                                                             "lfa"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lega-Mwenga"s,                                                                      "lgm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lega-Shabunda"s,                                                                    "lea"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Legbo"s,                                                                            "agb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Legenyem"s,                                                                         "lcc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lehali"s,                                                                           "tql"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lehalurup"s,                                                                        "urr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lehar"s,                                                                            "cae"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Leinong Naga"s,                                                                     "lzn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Leipon"s,                                                                           "lek"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lele (Chad)"s,                                                                      "lln"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lele (Democratic Republic of Congo)"s,                                              "lel"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lele (Guinea)"s,                                                                    "llc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lele (Papua New Guinea)"s,                                                          "lle"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lelemi"s,                                                                           "lef"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lelepa"s,                                                                           "lpa"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lembena"s,                                                                          "leq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lemerig"s,                                                                          "lrz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lemio"s,                                                                            "lei"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lemolang"s,                                                                         "ley"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lemoro"s,                                                                           "ldj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lenakel"s,                                                                          "tnl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lendu"s,                                                                            "led"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lengilu"s,                                                                          "lgi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lengo"s,                                                                            "lgr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lengola"s,                                                                          "lej"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lenje"s,                                                                            "leh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lenkau"s,                                                                           "ler"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lenyima"s,                                                                          "ldg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lepcha"s,                                                                           "lep"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lepki"s,                                                                            "lpe"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lere"s,                                                                             "gnh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lese"s,                                                                             "les"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lesing-Gelimi"s,                                                                    "let"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Letemboi"s,                                                                         "nms"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Leti (Cameroon)"s,                                                                  "leo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Leti (Indonesia)"s,                                                                 "lti"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Levuka"s,                                                                           "lvu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lewo Eleng"s,                                                                       "lwe"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lewo"s,                                                                             "lww"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lewotobi"s,                                                                         "lwt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Leyigha"s,                                                                          "ayi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lezghian"s,                                                                         "lez"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Lhokpu"s,                                                                           "lhp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lhomi"s,                                                                            "lhm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Li'o"s,                                                                             "ljl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Liabuku"s,                                                                          "lix"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Liana-Seti"s,                                                                       "ste"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Liangmai Naga"s,                                                                    "njn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lianshan Zhuang"s,                                                                  "zln"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Liberia Kpelle"s,                                                                   "xpe"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Liberian English"s,                                                                 "lir"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Libido"s,                                                                           "liq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Libinza"s,                                                                          "liz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Libon Bikol"s,                                                                      "lbl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Libyan Arabic"s,                                                                    "ayl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Libyan Sign Language"s,                                                             "lbs"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ligbi"s,                                                                            "lig"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ligenza"s,                                                                          "lgz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ligurian"s,                                                                         "lij"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lihir"s,                                                                            "lih"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lijili"s,                                                                           "mgi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lika"s,                                                                             "lik"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Liki"s,                                                                             "lio"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Likila"s,                                                                           "lie"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Likuba"s,                                                                           "kxx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Likum"s,                                                                            "lib"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Likwala"s,                                                                          "kwc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lilau"s,                                                                            "lll"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lillooet"s,                                                                         "lil"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Limassa"s,                                                                          "bme"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Limbu"s,                                                                            "lif"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Limbum"s,                                                                           "lmp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Limburgan; Limburger; Limburgish"s,                                                 "lim"s,   "li"s, ""s,    true );
  g_languages.emplace_back(u8"Limi"s,                                                                             "ylm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Limos Kalinga"s,                                                                    "kmk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lindu"s,                                                                            "klw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lingala"s,                                                                          "lin"s,   "ln"s, ""s,    true );
  g_languages.emplace_back(u8"Lingao"s,                                                                           "onb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lingarak"s,                                                                         "lgk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lipan Apache"s,                                                                     "apl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lipo"s,                                                                             "lpo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lisabata-Nuniali"s,                                                                 "lcs"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lisela"s,                                                                           "lcl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lish"s,                                                                             "lsh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lishana Deni"s,                                                                     "lsd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lishanid Noshan"s,                                                                  "aij"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lishán Didán"s,                                                                     "trg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lisu"s,                                                                             "lis"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lithuanian Sign Language"s,                                                         "lls"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lithuanian"s,                                                                       "lit"s,   "lt"s, ""s,    true );
  g_languages.emplace_back(u8"Litzlitz"s,                                                                         "lzl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Liujiang Zhuang"s,                                                                  "zlj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Liuqian Zhuang"s,                                                                   "zlq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Liv"s,                                                                              "liv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Livvi"s,                                                                            "olo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lo-Toga"s,                                                                          "lht"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Loarki"s,                                                                           "lrk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lobala"s,                                                                           "loq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lobi"s,                                                                             "lob"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lodhi"s,                                                                            "lbm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Logba"s,                                                                            "lgq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Logo"s,                                                                             "log"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Logol"s,                                                                            "lof"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Logooli"s,                                                                          "rag"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Logorik"s,                                                                          "liu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Logudorese Sardinian"s,                                                             "src"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lohorung"s,                                                                         "lbr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Loja Highland Quichua"s,                                                            "qvj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lojban"s,                                                                           "jbo"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Lokaa"s,                                                                            "yaz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Loke"s,                                                                             "loy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Loko"s,                                                                             "lok"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lokoya"s,                                                                           "lky"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lola"s,                                                                             "lcd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lolak"s,                                                                            "llq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lole"s,                                                                             "llg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lolo"s,                                                                             "llb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Loloda"s,                                                                           "loa"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lolopo"s,                                                                           "ycl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Loma (Côte d'Ivoire)"s,                                                             "loi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Loma (Liberia)"s,                                                                   "lom"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lomaiviti"s,                                                                        "lmv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lomavren"s,                                                                         "rmi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lombard"s,                                                                          "lmo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lombi"s,                                                                            "lmi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lombo"s,                                                                            "loo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lomwe"s,                                                                            "ngl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Loncong"s,                                                                          "lce"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Long Phuri Naga"s,                                                                  "lpn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Long Wat"s,                                                                         "ttw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Longgu"s,                                                                           "lgu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Longto"s,                                                                           "wok"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Longuda"s,                                                                          "lnu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Loniu"s,                                                                            "los"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lonwolwol"s,                                                                        "crc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lonzo"s,                                                                            "lnz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Loo"s,                                                                              "ldo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lopa"s,                                                                             "lop"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lopi"s,                                                                             "lov"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lopit"s,                                                                            "lpx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lorang"s,                                                                           "lrn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lorediakarkar"s,                                                                    "lnn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Loreto-Ucayali Spanish"s,                                                           "spq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lote"s,                                                                             "uvl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lotha Naga"s,                                                                       "njh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lotud"s,                                                                            "dtr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lou"s,                                                                              "loj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Louisiana Creole"s,                                                                 "lou"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Loun"s,                                                                             "lox"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Low German; Low Saxon; German, Low; Saxon, Low"s,                                   "nds"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Lower Grand Valley Dani"s,                                                          "dni"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lower Silesian"s,                                                                   "sli"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lower Sorbian"s,                                                                    "dsb"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Lower Ta'oih"s,                                                                     "tto"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lower Tanana"s,                                                                     "taa"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lowland Oaxaca Chontal"s,                                                           "clo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lowland Tarahumara"s,                                                               "tac"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Loxicha Zapotec"s,                                                                  "ztp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lozi"s,                                                                             "loz"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Lua'"s,                                                                             "prb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Luang"s,                                                                            "lex"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Luba-Katanga"s,                                                                     "lub"s,   "lu"s, ""s,    true );
  g_languages.emplace_back(u8"Luba-Lulua"s,                                                                       "lua"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Lubila"s,                                                                           "kcc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lubu"s,                                                                             "lcf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lubuagan Kalinga"s,                                                                 "knb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Luchazi"s,                                                                          "lch"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lucumi"s,                                                                           "luq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ludian"s,                                                                           "lud"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lufu"s,                                                                             "ldq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lugbara"s,                                                                          "lgg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Luguru"s,                                                                           "ruf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Luhu"s,                                                                             "lcq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Luimbi"s,                                                                           "lum"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Luiseno"s,                                                                          "lui"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Lukpa"s,                                                                            "dop"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lule Sami"s,                                                                        "smj"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Lumba-Yakkha"s,                                                                     "luu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lumbu"s,                                                                            "lup"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lumun"s,                                                                            "lmd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Luna"s,                                                                             "luj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lunanakha"s,                                                                        "luk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lunda"s,                                                                            "lun"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Lundayeh"s,                                                                         "lnd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lungalunga"s,                                                                       "vmg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lungga"s,                                                                           "lga"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Luo (Cameroon)"s,                                                                   "luw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Luo (Kenya and Tanzania)"s,                                                         "luo"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Luopohe Hmong"s,                                                                    "hml"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Luri"s,                                                                             "ldd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lusengo"s,                                                                          "lse"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lushai"s,                                                                           "lus"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Lushootseed"s,                                                                      "lut"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lusi"s,                                                                             "khl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lutos"s,                                                                            "ndy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Luvale"s,                                                                           "lue"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Luwati"s,                                                                           "luv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Luwo"s,                                                                             "lwo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Luxembourgish; Letzeburgesch"s,                                                     "ltz"s,   "lb"s, ""s,    true );
  g_languages.emplace_back(u8"Luyana"s,                                                                           "lyn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Luyia"s,                                                                            "luy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lwalu"s,                                                                            "lwa"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lyngngam"s,                                                                         "lyg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lyons Sign Language"s,                                                              "lsg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lyélé"s,                                                                            "lee"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Láá Láá Bwamu"s,                                                                    "bwj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Lü"s,                                                                               "khb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ma (Democratic Republic of Congo)"s,                                                "msj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ma (Papua New Guinea)"s,                                                            "mjn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ma Manda"s,                                                                         "skc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ma'anyan"s,                                                                         "mhy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ma'di"s,                                                                            "mhi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ma'ya"s,                                                                            "slz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Maa"s,                                                                              "cma"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Maaka"s,                                                                            "mew"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Maasina Fulfulde"s,                                                                 "ffm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Maay"s,                                                                             "ymm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Maba (Chad)"s,                                                                      "mde"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Maba (Indonesia)"s,                                                                 "mqa"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mabaale"s,                                                                          "mmz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mabaan"s,                                                                           "mfz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mabaka Valley Kalinga"s,                                                            "kkg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mabire"s,                                                                           "muj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Maca"s,                                                                             "mca"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Macaguán"s,                                                                         "mbn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Macanese"s,                                                                         "mzs"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Macedonian"s,                                                                       "mac"s,   "mk"s, "mkd"s, true );
  g_languages.emplace_back(u8"Machame"s,                                                                          "jmc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Machiguenga"s,                                                                      "mcb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Machinere"s,                                                                        "mpd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Machinga"s,                                                                         "mvw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Maco"s,                                                                             "wpc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Macuna"s,                                                                           "myy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Macushi"s,                                                                          "mbc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mada (Cameroon)"s,                                                                  "mxu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mada (Nigeria)"s,                                                                   "mda"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Madagascar Sign Language"s,                                                         "mzc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Madak"s,                                                                            "mmx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Maden"s,                                                                            "xmx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Madi"s,                                                                             "grg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Madngele"s,                                                                         "zml"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Madurese"s,                                                                         "mad"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Mae"s,                                                                              "mme"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Maeng Itneg"s,                                                                      "itt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mafa"s,                                                                             "maf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mafea"s,                                                                            "mkv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mag-Indi Ayta"s,                                                                    "blx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mag-antsi Ayta"s,                                                                   "sgb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Magahi"s,                                                                           "mag"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Magbukun Ayta"s,                                                                    "ayt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Magdalena Peñasco Mixtec"s,                                                         "xtm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Magoma"s,                                                                           "gmx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Magori"s,                                                                           "zgr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Maguindanaon"s,                                                                     "mdh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Magɨyi"s,                                                                           "gmg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mahali"s,                                                                           "mjx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mahasu Pahari"s,                                                                    "bfz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mahongwe"s,                                                                         "mhb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mahou"s,                                                                            "mxx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mai Brat"s,                                                                         "ayz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Maia"s,                                                                             "sks"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Maiadomu"s,                                                                         "mzz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Maiani"s,                                                                           "tnh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Maii"s,                                                                             "mmm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mailu"s,                                                                            "mgu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Maindo"s,                                                                           "cwb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mainfränkisch"s,                                                                    "vmf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mainstream Kenyah"s,                                                                "xkl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mairasi"s,                                                                          "zrs"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Maisin"s,                                                                           "mbq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Maithili"s,                                                                         "mai"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Maiwa (Indonesia)"s,                                                                "wmm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Maiwa (Papua New Guinea)"s,                                                         "mti"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Maiwala"s,                                                                          "mum"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Majang"s,                                                                           "mpe"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Majera"s,                                                                           "xmj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Majhi"s,                                                                            "mjz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Majhwar"s,                                                                          "mmj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Majukayang Kalinga"s,                                                               "kmd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mak (China)"s,                                                                      "mkg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mak (Nigeria)"s,                                                                    "pbl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Makaa"s,                                                                            "mcp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Makah"s,                                                                            "myh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Makalero"s,                                                                         "mjb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Makasae"s,                                                                          "mkz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Makasar"s,                                                                          "mak"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Makassar Malay"s,                                                                   "mfp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Makayam"s,                                                                          "aup"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Makhuwa"s,                                                                          "vmw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Makhuwa-Marrevone"s,                                                                "xmc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Makhuwa-Meetto"s,                                                                   "mgh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Makhuwa-Moniga"s,                                                                   "mhm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Makhuwa-Saka"s,                                                                     "xsq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Makhuwa-Shirima"s,                                                                  "vmk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Maklew"s,                                                                           "mgf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Makonde"s,                                                                          "kde"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Maku'a"s,                                                                           "lva"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Makuri Naga"s,                                                                      "jmn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Makuráp"s,                                                                          "mpu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Makwe"s,                                                                            "ymk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Makyan Naga"s,                                                                      "umn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mal Paharia"s,                                                                      "mkb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mal"s,                                                                              "mlf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mala (Nigeria)"s,                                                                   "ruy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mala (Papua New Guinea)"s,                                                          "ped"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mala Malasar"s,                                                                     "ima"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Malaccan Creole Malay"s,                                                            "ccm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Malaccan Creole Portuguese"s,                                                       "mcm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Malagasy"s,                                                                         "mlg"s,   "mg"s, ""s,    true );
  g_languages.emplace_back(u8"Malalamai"s,                                                                        "mmt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Malango"s,                                                                          "mln"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Malankuravan"s,                                                                     "mjo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Malapandaram"s,                                                                     "mjp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Malas"s,                                                                            "mkr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Malasar"s,                                                                          "ymr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Malavedan"s,                                                                        "mjr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Malawi Lomwe"s,                                                                     "lon"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Malawi Sena"s,                                                                      "swk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Malay (individual language)"s,                                                      "zlm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Malay"s,                                                                            "may"s,   "ms"s, "msa"s, true );
  g_languages.emplace_back(u8"Malayalam"s,                                                                        "mal"s,   "ml"s, ""s,    true );
  g_languages.emplace_back(u8"Malayic Dayak"s,                                                                    "xdy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Malaynon"s,                                                                         "mlz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Malayo"s,                                                                           "mbp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Malaysian Sign Language"s,                                                          "xml"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Malba Birifor"s,                                                                    "bfo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Male (Ethiopia)"s,                                                                  "mdy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Male (Papua New Guinea)"s,                                                          "mdc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Malecite-Passamaquoddy"s,                                                           "pqm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Maleng"s,                                                                           "pkt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Maleu-Kilenge"s,                                                                    "mgl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Malfaxal"s,                                                                         "mlx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Malgbe"s,                                                                           "mxf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mali"s,                                                                             "gcc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Malila"s,                                                                           "mgq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Malimba"s,                                                                          "mzd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Malimpung"s,                                                                        "mli"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Malinaltepec Me'phaa"s,                                                             "tcf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Malo"s,                                                                             "mla"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Malol"s,                                                                            "mbk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Maltese Sign Language"s,                                                            "mdl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Maltese"s,                                                                          "mlt"s,   "mt"s, ""s,    true );
  g_languages.emplace_back(u8"Malua Bay"s,                                                                        "mll"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Malvi"s,                                                                            "mup"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Maléku Jaíka"s,                                                                     "gut"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mam"s,                                                                              "mam"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mama"s,                                                                             "mma"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mamaa"s,                                                                            "mhf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mamaindé"s,                                                                         "wmd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mamanwa"s,                                                                          "mmn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mamara Senoufo"s,                                                                   "myk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mamasa"s,                                                                           "mqj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mambae"s,                                                                           "mgm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mambai"s,                                                                           "mcs"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mamboru"s,                                                                          "mvd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mambwe-Lungu"s,                                                                     "mgr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mampruli"s,                                                                         "maw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mamuju"s,                                                                           "mqx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mamusi"s,                                                                           "kdf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mamvu"s,                                                                            "mdi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Man Met"s,                                                                          "mml"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Manado Malay"s,                                                                     "xmm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Manam"s,                                                                            "mva"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Manambu"s,                                                                          "mle"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Manangba"s,                                                                         "nmm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Manchu"s,                                                                           "mnc"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Manda (Australia)"s,                                                                "zma"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Manda (India)"s,                                                                    "mha"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Manda (Tanzania)"s,                                                                 "mgs"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mandahuaca"s,                                                                       "mht"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mandaic"s,                                                                          "mid"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mandan"s,                                                                           "mhq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mandar"s,                                                                           "mdr"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Mandara"s,                                                                          "tbf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mandari"s,                                                                          "mqu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mandarin Chinese"s,                                                                 "cmn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mandaya"s,                                                                          "mry"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mandeali"s,                                                                         "mjl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mander"s,                                                                           "mqr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mandingo"s,                                                                         "man"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Mandinka"s,                                                                         "mnk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mandjak"s,                                                                          "mfv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mandobo Atas"s,                                                                     "aax"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mandobo Bawah"s,                                                                    "bwp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Manem"s,                                                                            "jet"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mang"s,                                                                             "zng"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Manga Kanuri"s,                                                                     "kby"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mangarayi"s,                                                                        "mpc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mangareva"s,                                                                        "mrv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mangas"s,                                                                           "zns"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mangayat"s,                                                                         "myj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mangbetu"s,                                                                         "mdj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mangbutu"s,                                                                         "mdk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mangga Buang"s,                                                                     "mmo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Manggarai"s,                                                                        "mqy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mango"s,                                                                            "mge"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mangole"s,                                                                          "mqc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mangseng"s,                                                                         "mbh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Manide"s,                                                                           "abd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Manikion"s,                                                                         "mnx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Manipa"s,                                                                           "mqp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Manipuri"s,                                                                         "mni"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Mankanya"s,                                                                         "knf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Manna-Dora"s,                                                                       "mju"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mannan"s,                                                                           "mjv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mano"s,                                                                             "mev"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Manobo languages"s,                                                                 "mno"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Manombai"s,                                                                         "woo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mansaka"s,                                                                          "msk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mansi"s,                                                                            "mns"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mansoanka"s,                                                                        "msw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Manta"s,                                                                            "myg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mantsi"s,                                                                           "nty"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Manumanaw Karen"s,                                                                  "kxf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Manx"s,                                                                             "glv"s,   "gv"s, ""s,    true );
  g_languages.emplace_back(u8"Manya"s,                                                                            "mzj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Manyawa"s,                                                                          "mny"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Manyika"s,                                                                          "mxc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Manza"s,                                                                            "mzv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mao Naga"s,                                                                         "nbi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Maonan"s,                                                                           "mmd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Maore Comorian"s,                                                                   "swb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Maori"s,                                                                            "mao"s,   "mi"s, "mri"s, true );
  g_languages.emplace_back(u8"Mape"s,                                                                             "mlh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mapena"s,                                                                           "mnm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mapia"s,                                                                            "mpy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mapidian"s,                                                                         "mpw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mapos Buang"s,                                                                      "bzh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mapoyo"s,                                                                           "mcg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mapudungun; Mapuche"s,                                                              "arn"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Mapun"s,                                                                            "sjm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Maquiritari"s,                                                                      "mch"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mara Chin"s,                                                                        "mrh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mara"s,                                                                             "mec"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Marachi"s,                                                                          "lri"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Maraghei"s,                                                                         "vmh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Maragus"s,                                                                          "mrs"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Maram Naga"s,                                                                       "nma"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Marama"s,                                                                           "lrm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Maramba"s,                                                                          "myd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Maranao"s,                                                                          "mrw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Maranunggu"s,                                                                       "zmr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mararit"s,                                                                          "mgb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Marathi"s,                                                                          "mar"s,   "mr"s, ""s,    true );
  g_languages.emplace_back(u8"Marau"s,                                                                            "mvr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Marba"s,                                                                            "mpg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Maremgi"s,                                                                          "mrx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Marenje"s,                                                                          "vmr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Marfa"s,                                                                            "mvu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Marghi Central"s,                                                                   "mrt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Marghi South"s,                                                                     "mfm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Margos-Yarowilca-Lauricocha Quechua"s,                                              "qvm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Margu"s,                                                                            "mhg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mari (East Sepik Province)"s,                                                       "mbx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mari (Madang Province)"s,                                                           "hob"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mari"s,                                                                             "chm"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Maria (India)"s,                                                                    "mrr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Maria (Papua New Guinea)"s,                                                         "mds"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Maricopa"s,                                                                         "mrc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Maridan"s,                                                                          "zmd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Maridjabin"s,                                                                       "zmj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Marik"s,                                                                            "dad"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Marimanindji"s,                                                                     "zmm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Marind"s,                                                                           "mrz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Maring Naga"s,                                                                      "nng"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Maring"s,                                                                           "mbw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Maringarr"s,                                                                        "zmt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Marino"s,                                                                           "mrb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mariri"s,                                                                           "mqi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Marithiel"s,                                                                        "mfr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Maritime Sign Language"s,                                                           "nsr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mariyedi"s,                                                                         "zmy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Marka"s,                                                                            "rkm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Markweeta"s,                                                                        "enb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Marma"s,                                                                            "rmz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Marovo"s,                                                                           "mvo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Marriammu"s,                                                                        "xru"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Marshallese"s,                                                                      "mah"s,   "mh"s, ""s,    true );
  g_languages.emplace_back(u8"Marti Ke"s,                                                                         "zmg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Martu Wangka"s,                                                                     "mpj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Martuyhunira"s,                                                                     "vma"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Maru"s,                                                                             "mhx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Marwari (India)"s,                                                                  "rwr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Marwari (Pakistan)"s,                                                               "mve"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Marwari"s,                                                                          "mwr"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Marúbo"s,                                                                           "mzr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Masaaba"s,                                                                          "myx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Masadiit Itneg"s,                                                                   "tis"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Masai"s,                                                                            "mas"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Masalit"s,                                                                          "mls"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Masana"s,                                                                           "mcn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Masbatenyo"s,                                                                       "msb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mashco Piro"s,                                                                      "cuj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mashi (Nigeria)"s,                                                                  "jms"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mashi (Zambia)"s,                                                                   "mho"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Masikoro Malagasy"s,                                                                "msh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Masimasi"s,                                                                         "ism"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Masiwang"s,                                                                         "bnf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Maskelynes"s,                                                                       "klv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Maslam"s,                                                                           "msv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Masmaje"s,                                                                          "mes"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Massalat"s,                                                                         "mdg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Massep"s,                                                                           "mvs"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Matal"s,                                                                            "mfh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Matbat"s,                                                                           "xmt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Matengo"s,                                                                          "mgv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Matepi"s,                                                                           "mqe"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Matigsalug Manobo"s,                                                                "mbt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mato"s,                                                                             "met"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Matsés"s,                                                                           "mcf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Matu Chin"s,                                                                        "hlt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Matukar"s,                                                                          "mjk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Matumbi"s,                                                                          "mgw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Matya Samo"s,                                                                       "stj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Matís"s,                                                                            "mpq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Maung"s,                                                                            "mph"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mauritian Sign Language"s,                                                          "lsy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mauwake"s,                                                                          "mhl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mawa (Chad)"s,                                                                      "mcw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mawak"s,                                                                            "mjj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mawan"s,                                                                            "mcz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mawayana"s,                                                                         "mzx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mawchi"s,                                                                           "mke"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mawes"s,                                                                            "mgk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Maxakalí"s,                                                                         "mbl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Maxi Gbe"s,                                                                         "mxl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Maya Samo"s,                                                                        "sym"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mayaguduna"s,                                                                       "xmy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mayan languages"s,                                                                  "myn"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Mayangna"s,                                                                         "yan"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mayeka"s,                                                                           "myc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mayo"s,                                                                             "mfy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mayogo"s,                                                                           "mdm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mayoyao Ifugao"s,                                                                   "ifu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mazagway"s,                                                                         "dkx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mazaltepec Zapotec"s,                                                               "zpy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mazanderani"s,                                                                      "mzn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mazatlán Mazatec"s,                                                                 "vmz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mazatlán Mixe"s,                                                                    "mzl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mba"s,                                                                              "mfc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mbala"s,                                                                            "mdp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mbalanhu"s,                                                                         "lnb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mbandja"s,                                                                          "zmz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mbangala"s,                                                                         "mxg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mbangi"s,                                                                           "mgn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mbangwe"s,                                                                          "zmn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mbara (Chad)"s,                                                                     "mpk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mbati"s,                                                                            "mdn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mbato"s,                                                                            "gwa"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mbay"s,                                                                             "myb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mbe"s,                                                                              "mfo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mbe'"s,                                                                             "mtk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mbelime"s,                                                                          "mql"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mbere"s,                                                                            "mdt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mbesa"s,                                                                            "zms"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mbo (Cameroon)"s,                                                                   "mbo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mbo (Democratic Republic of Congo)"s,                                               "zmw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mboi"s,                                                                             "moi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mboko"s,                                                                            "mdu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mbole"s,                                                                            "mdq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mbonga"s,                                                                           "xmb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mbongno"s,                                                                          "bgu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mbosi"s,                                                                            "mdw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mbowe"s,                                                                            "mxo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mbre"s,                                                                             "mka"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mbudum"s,                                                                           "xmd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mbugu"s,                                                                            "mhd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mbugwe"s,                                                                           "mgz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mbuko"s,                                                                            "mqb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mbukushu"s,                                                                         "mhw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mbula"s,                                                                            "mna"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mbula-Bwazza"s,                                                                     "mbu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mbule"s,                                                                            "mlb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mbulungish"s,                                                                       "mbv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mbum"s,                                                                             "mdd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mbunda"s,                                                                           "mck"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mbunga"s,                                                                           "mgy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mburku"s,                                                                           "bbt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mbwela"s,                                                                           "mfu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mbyá Guaraní"s,                                                                     "gun"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Me'en"s,                                                                            "mym"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Medebur"s,                                                                          "mjm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Media Lengua"s,                                                                     "mue"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mediak"s,                                                                           "mwx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mednyj Aleut"s,                                                                     "mud"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Medumba"s,                                                                          "byv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mefele"s,                                                                           "mfj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Megam"s,                                                                            "mef"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Megleno Romanian"s,                                                                 "ruq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mehek"s,                                                                            "nux"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mehináku"s,                                                                         "mmh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mehri"s,                                                                            "gdq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mekeo"s,                                                                            "mek"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mekmek"s,                                                                           "mvk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mekwei"s,                                                                           "msf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mele-Fila"s,                                                                        "mxe"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Melo"s,                                                                             "mfx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Melpa"s,                                                                            "med"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Memoni"s,                                                                           "mby"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mendalam Kayan"s,                                                                   "xkd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mendankwe-Nkwen"s,                                                                  "mfd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mende (Papua New Guinea)"s,                                                         "sim"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mende"s,                                                                            "men"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Mengaka"s,                                                                          "xmg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mengen"s,                                                                           "mee"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mengisa"s,                                                                          "mct"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Menka"s,                                                                            "mea"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Menominee"s,                                                                        "mez"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mentawai"s,                                                                         "mwv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Menya"s,                                                                            "mcr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Meoswar"s,                                                                          "mvx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mer"s,                                                                              "mnu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Meramera"s,                                                                         "mxm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Merei"s,                                                                            "lmb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Merey"s,                                                                            "meq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Meriam"s,                                                                           "ulk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Merlav"s,                                                                           "mrm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Meru"s,                                                                             "mer"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Merwari"s,                                                                          "wry"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mesaka"s,                                                                           "iyo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mescalero-Chiricahua Apache"s,                                                      "apm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mese"s,                                                                             "mci"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Meskwaki"s,                                                                         "sac"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mesme"s,                                                                            "zim"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mesopotamian Arabic"s,                                                              "acm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mesqan"s,                                                                           "mvz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Meta'"s,                                                                            "mgo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Metlatónoc Mixtec"s,                                                                "mxv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mewari"s,                                                                           "mtr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mewati"s,                                                                           "wtm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mexican Sign Language"s,                                                            "mfs"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Meyah"s,                                                                            "mej"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mezontla Popoloca"s,                                                                "pbe"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mezquital Otomi"s,                                                                  "ote"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mfinu"s,                                                                            "zmf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mfumte"s,                                                                           "nfu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mgbolizhia"s,                                                                       "gmz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mi'kmaq; Micmac"s,                                                                  "mic"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Miahuatlán Zapotec"s,                                                               "zam"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Miami"s,                                                                            "mia"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mian"s,                                                                             "mpt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Miani"s,                                                                            "pla"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Michif"s,                                                                           "crg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Michoacán Mazahua"s,                                                                "mmc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Michoacán Nahuatl"s,                                                                "ncl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mid Grand Valley Dani"s,                                                            "dnt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mid-Southern Banda"s,                                                               "bjo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Middle Watut"s,                                                                     "mpl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Midob"s,                                                                            "mei"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Migaama"s,                                                                          "mmy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Migabac"s,                                                                          "mpp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Migum"s,                                                                            "klm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Miju-Mishmi"s,                                                                      "mxj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mikasuki"s,                                                                         "mik"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mili"s,                                                                             "ymh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Miltu"s,                                                                            "mlj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Min Bei Chinese"s,                                                                  "mnp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Min Dong Chinese"s,                                                                 "cdo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Min Nan Chinese"s,                                                                  "nan"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Min Zhong Chinese"s,                                                                "czo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mina (Cameroon)"s,                                                                  "hna"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mina (India)"s,                                                                     "myi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Minangkabau"s,                                                                      "min"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Minanibai"s,                                                                        "mcv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Minaveha"s,                                                                         "mvn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Minderico"s,                                                                        "drc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mindiri"s,                                                                          "mpn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mingang Doso"s,                                                                     "mko"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mingrelian"s,                                                                       "xmf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Minica Huitoto"s,                                                                   "hto"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Minidien"s,                                                                         "wii"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Minokok"s,                                                                          "mqq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Minriq"s,                                                                           "mnq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mintil"s,                                                                           "mzt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Minz Zhuang"s,                                                                      "zgm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Miqie"s,                                                                            "yiq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mirandese"s,                                                                        "mwl"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Miraya Bikol"s,                                                                     "rbl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mirgan"s,                                                                           "zrg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Miriwoong Sign Language"s,                                                          "rsm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Miriwung"s,                                                                         "mep"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Miship"s,                                                                           "mjs"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Misima-Panaeati"s,                                                                  "mpx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mising"s,                                                                           "mrg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mitla Zapotec"s,                                                                    "zaw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mitlatongo Mixtec"s,                                                                "vmm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mituku"s,                                                                           "zmq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Miu"s,                                                                              "mpo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mixed Great Andamanese"s,                                                           "gac"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mixtepec Mixtec"s,                                                                  "mix"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mixtepec Zapotec"s,                                                                 "zpm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Miya"s,                                                                             "mkf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Miyako"s,                                                                           "mvi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Miyobe"s,                                                                           "soy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mlabri"s,                                                                           "mra"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mlap"s,                                                                             "kja"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mlomp"s,                                                                            "mlo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mmaala"s,                                                                           "mmu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mmen"s,                                                                             "bfm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mo'da"s,                                                                            "gbn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Moba"s,                                                                             "mfq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mobumrin Aizi"s,                                                                    "ahm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mobwa Karen"s,                                                                      "jkm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mochi"s,                                                                            "old"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mocho"s,                                                                            "mhc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mocoví"s,                                                                           "moc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Modang"s,                                                                           "mxd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Modole"s,                                                                           "mqo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Moere"s,                                                                            "mvq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mofu-Gudur"s,                                                                       "mif"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mogholi"s,                                                                          "mhj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mogofin"s,                                                                          "mfg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mogum"s,                                                                            "mou"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mohave"s,                                                                           "mov"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mohawk"s,                                                                           "moh"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Moi (Congo)"s,                                                                      "mow"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Moi (Indonesia)"s,                                                                  "mxn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Moikodi"s,                                                                          "mkp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Moingi"s,                                                                           "mwz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Moji"s,                                                                             "ymi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mok"s,                                                                              "mqt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Moken"s,                                                                            "mwt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mokerang"s,                                                                         "mft"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mokilese"s,                                                                         "mkj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Moklen"s,                                                                           "mkm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mokole"s,                                                                           "mkl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mokpwe"s,                                                                           "bri"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Moksha"s,                                                                           "mdf"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Molbog"s,                                                                           "pwm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Moldova Sign Language"s,                                                            "vsi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Molengue"s,                                                                         "bxc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Molima"s,                                                                           "mox"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Molmo One"s,                                                                        "aun"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Molo"s,                                                                             "zmo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Molof"s,                                                                            "msl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Moloko"s,                                                                           "mlw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mom Jango"s,                                                                        "ver"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Moma"s,                                                                             "myl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Momare"s,                                                                           "msz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mombo Dogon"s,                                                                      "dmb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mombum"s,                                                                           "mso"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Momina"s,                                                                           "mmb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Momuna"s,                                                                           "mqf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mon"s,                                                                              "mnw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mon-Khmer languages"s,                                                              "mkh"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Monastic Sign Language"s,                                                           "mzg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mondropolon"s,                                                                      "npn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mondé"s,                                                                            "mnd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mongo"s,                                                                            "lol"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Mongol"s,                                                                           "mgt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mongolia Buriat"s,                                                                  "bxm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mongolian Sign Language"s,                                                          "msr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mongolian"s,                                                                        "mon"s,   "mn"s, ""s,    true );
  g_languages.emplace_back(u8"Mongondow"s,                                                                        "mog"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Moni"s,                                                                             "mnz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mono (Cameroon)"s,                                                                  "mru"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mono (Democratic Republic of Congo)"s,                                              "mnh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mono (Solomon Islands)"s,                                                           "mte"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mono (USA)"s,                                                                       "mnr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Monom"s,                                                                            "moo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Monsang Naga"s,                                                                     "nmh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Montagnais"s,                                                                       "moe"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Montol"s,                                                                           "mtl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Monumbo"s,                                                                          "mxk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Monzombo"s,                                                                         "moj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Moo"s,                                                                              "gwg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Moose Cree"s,                                                                       "crm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mopán Maya"s,                                                                       "mop"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mor (Bomberai Peninsula)"s,                                                         "moq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mor (Mor Islands)"s,                                                                "mhz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Moraid"s,                                                                           "msg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Morawa"s,                                                                           "mze"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Morelos Nahuatl"s,                                                                  "nhm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Morerebi"s,                                                                         "xmo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Moresada"s,                                                                         "msx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mori Atas"s,                                                                        "mzq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mori Bawah"s,                                                                       "xmz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Morigi"s,                                                                           "mdb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Morisyen"s,                                                                         "mfe"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Moro"s,                                                                             "mor"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Moroccan Arabic"s,                                                                  "ary"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Moroccan Sign Language"s,                                                           "xms"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Morokodo"s,                                                                         "mgc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Morom"s,                                                                            "bdo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Moronene"s,                                                                         "mqn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Morori"s,                                                                           "mok"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Morouas"s,                                                                          "mrp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mortlockese"s,                                                                      "mrl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Moru"s,                                                                             "mgd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mosimo"s,                                                                           "mqv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mosiro"s,                                                                           "mwy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Moskona"s,                                                                          "mtj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mossi"s,                                                                            "mos"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Mota"s,                                                                             "mtt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Motlav"s,                                                                           "mlv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Motu"s,                                                                             "meu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mouk-Aria"s,                                                                        "mwh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mountain Koiali"s,                                                                  "kpx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mouwase"s,                                                                          "jmw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Movima"s,                                                                           "mzp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Moyadan Itneg"s,                                                                    "ity"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Moyon Naga"s,                                                                       "nmo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mozambican Sign Language"s,                                                         "mzy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mpade"s,                                                                            "mpi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mpi"s,                                                                              "mpz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mpiemo"s,                                                                           "mcx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mpoto"s,                                                                            "mpa"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mpotovoro"s,                                                                        "mvt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mpumpong"s,                                                                         "mgg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mpuono"s,                                                                           "zmp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mpur"s,                                                                             "akc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mro-Khimi Chin"s,                                                                   "cmr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mru"s,                                                                              "mro"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mser"s,                                                                             "kqx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mt. Iraya Agta"s,                                                                   "atl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mt. Iriga Agta"s,                                                                   "agz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mualang"s,                                                                          "mtd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mubami"s,                                                                           "tsx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mubi"s,                                                                             "mub"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Muda"s,                                                                             "ymd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mudburra"s,                                                                         "dmw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mudhili Gadaba"s,                                                                   "gau"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mudu Koraga"s,                                                                      "vmd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Muduga"s,                                                                           "udg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mufian"s,                                                                           "aoj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mugom"s,                                                                            "muk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Muinane"s,                                                                          "bmr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mukha-Dora"s,                                                                       "mmk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mukulu"s,                                                                           "moz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mulam"s,                                                                            "mlm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mulao"s,                                                                            "giu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mulgi"s,                                                                            "mvh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mullu Kurumba"s,                                                                    "kpb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mullukmulluk"s,                                                                     "mpb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Multiple languages"s,                                                               "mul"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Mum"s,                                                                              "kqa"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mumuye"s,                                                                           "mzm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Muna"s,                                                                             "mnb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Munda languages"s,                                                                  "mun"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Munda"s,                                                                            "unx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mundabli"s,                                                                         "boe"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mundang"s,                                                                          "mua"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mundani"s,                                                                          "mnf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mundari"s,                                                                          "unr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mundat"s,                                                                           "mmf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mundurukú"s,                                                                        "myu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mungaka"s,                                                                          "mhk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Munggui"s,                                                                          "mth"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mungkip"s,                                                                          "mpv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Muniche"s,                                                                          "myr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Munit"s,                                                                            "mtc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Munji"s,                                                                            "mnj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Munsee"s,                                                                           "umu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Muong"s,                                                                            "mtq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mur Pano"s,                                                                         "tkv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Muratayak"s,                                                                        "asx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Murik (Malaysia)"s,                                                                 "mxr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Murik (Papua New Guinea)"s,                                                         "mtf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Murkim"s,                                                                           "rmh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Murle"s,                                                                            "mur"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Murrinh-Patha"s,                                                                    "mwf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mursi"s,                                                                            "muz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Murui Huitoto"s,                                                                    "huu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Murupi"s,                                                                           "mqw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Musak"s,                                                                            "mmq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Musar"s,                                                                            "mmi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Musasa"s,                                                                           "smm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Musey"s,                                                                            "mse"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Musgu"s,                                                                            "mug"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mushungulu"s,                                                                       "xma"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Musi"s,                                                                             "mui"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Muslim Tat"s,                                                                       "ttt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Musom"s,                                                                            "msu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mussau-Emira"s,                                                                     "emi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Muthuvan"s,                                                                         "muv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mutu"s,                                                                             "tuc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Muya"s,                                                                             "mvm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Muyang"s,                                                                           "muy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Muyuw"s,                                                                            "myw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Muzi"s,                                                                             "ymz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mvanip"s,                                                                           "mcj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mvuba"s,                                                                            "mxh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mwaghavul"s,                                                                        "sur"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mwali Comorian"s,                                                                   "wlc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mwan"s,                                                                             "moa"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mwani"s,                                                                            "wmw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mwatebu"s,                                                                          "mwa"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mwera (Chimwera)"s,                                                                 "mwe"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mwera (Nyasa)"s,                                                                    "mjh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mwimbi-Muthambi"s,                                                                  "mws"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Myene"s,                                                                            "mye"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mzieme Naga"s,                                                                      "nme"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mághdì"s,                                                                           "gmd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ménik"s,                                                                            "tnr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mískito"s,                                                                          "miq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mócheno"s,                                                                          "mhn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mün Chin"s,                                                                         "mwq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Mündü"s,                                                                            "muh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"N'Ko"s,                                                                             "nqo"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"N/u"s,                                                                              "ngh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Na"s,                                                                               "nbt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Naaba"s,                                                                            "nao"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Naami"s,                                                                            "bzv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Naasioi"s,                                                                          "nas"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Naba"s,                                                                             "mne"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nabak"s,                                                                            "naf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nabi"s,                                                                             "mty"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nachering"s,                                                                        "ncd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nadëb"s,                                                                            "mbj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nafaanra"s,                                                                         "nfr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nafi"s,                                                                             "srf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nafri"s,                                                                            "nxx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nafusi"s,                                                                           "jbn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Naga Pidgin"s,                                                                      "nag"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nagarchal"s,                                                                        "nbg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nage"s,                                                                             "nxe"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nahali"s,                                                                           "nlx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nahari"s,                                                                           "nhh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nahuatl languages"s,                                                                "nah"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Nai"s,                                                                              "bio"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Najdi Arabic"s,                                                                     "ars"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Naka'ela"s,                                                                         "nae"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nakai"s,                                                                            "nkj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nakame"s,                                                                           "nib"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nakanai"s,                                                                          "nak"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nakara"s,                                                                           "nck"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nake"s,                                                                             "nbk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Naki"s,                                                                             "mff"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nakwi"s,                                                                            "nax"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nalca"s,                                                                            "nlc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nali"s,                                                                             "nss"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nalik"s,                                                                            "nal"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nalu"s,                                                                             "naj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Naluo Yi"s,                                                                         "ylo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nalögo"s,                                                                           "nlz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nama (Papua New Guinea)"s,                                                          "nmx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Namakura"s,                                                                         "nmk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Namat"s,                                                                            "nkm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nambo"s,                                                                            "ncm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nambya"s,                                                                           "nmq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Namia"s,                                                                            "nnm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Namiae"s,                                                                           "nvm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Namibian Sign Language"s,                                                           "nbs"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Namla"s,                                                                            "naa"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Namo"s,                                                                             "mxw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Namonuito"s,                                                                        "nmt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Namosi-Naitasiri-Serua"s,                                                           "bwb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Namuyi"s,                                                                           "nmy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nanai"s,                                                                            "gld"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nancere"s,                                                                          "nnc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nande"s,                                                                            "nnb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nandi"s,                                                                            "niq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nanerigé Sénoufo"s,                                                                 "sen"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nanga Dama Dogon"s,                                                                 "nzz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nankina"s,                                                                          "nnk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nanti"s,                                                                            "cox"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nanubae"s,                                                                          "afk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Napo Lowland Quechua"s,                                                             "qvo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Napu"s,                                                                             "npy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nar Phu"s,                                                                          "npa"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nara"s,                                                                             "nrb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Narak"s,                                                                            "nac"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Narango"s,                                                                          "nrg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Narim"s,                                                                            "loh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Naro"s,                                                                             "nhr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Narom"s,                                                                            "nrm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Narua"s,                                                                            "nru"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nasal"s,                                                                            "nsy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nasarian"s,                                                                         "nvh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Naskapi"s,                                                                          "nsk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Natanzi"s,                                                                          "ntz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nataoran Amis"s,                                                                    "ais"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nateni"s,                                                                           "ntm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nathembo"s,                                                                         "nte"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Natioro"s,                                                                          "nti"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Natügu"s,                                                                           "ntu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nauete"s,                                                                           "nxa"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Naukan Yupik"s,                                                                     "ynk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nauna"s,                                                                            "ncn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nauru"s,                                                                            "nau"s,   "na"s, ""s,    true );
  g_languages.emplace_back(u8"Navajo; Navaho"s,                                                                   "nav"s,   "nv"s, ""s,    true );
  g_languages.emplace_back(u8"Navut"s,                                                                            "nsw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nawaru"s,                                                                           "nwr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nawdm"s,                                                                            "nmz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nawuri"s,                                                                           "naw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Naxi"s,                                                                             "nxq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nayi"s,                                                                             "noz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nayini"s,                                                                           "nyq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ncane"s,                                                                            "ncr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nchumbulu"s,                                                                        "nlu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nda'nda'"s,                                                                         "nnz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ndai"s,                                                                             "gke"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ndaka"s,                                                                            "ndk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ndaktup"s,                                                                          "ncp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ndali"s,                                                                            "ndh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ndam"s,                                                                             "ndm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ndamba"s,                                                                           "ndj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ndambomo"s,                                                                         "nxo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ndasa"s,                                                                            "nda"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ndau"s,                                                                             "ndc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nde-Gbite"s,                                                                        "ned"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nde-Nsele-Nta"s,                                                                    "ndd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ndebele, North; North Ndebele"s,                                                    "nde"s,   "nd"s, ""s,    true );
  g_languages.emplace_back(u8"Ndebele, South; South Ndebele"s,                                                    "nbl"s,   "nr"s, ""s,    true );
  g_languages.emplace_back(u8"Ndemli"s,                                                                           "nml"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ndendeule"s,                                                                        "dne"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ndengereko"s,                                                                       "ndg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ndo"s,                                                                              "ndp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ndobo"s,                                                                            "ndw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ndoe"s,                                                                             "nbb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ndogo"s,                                                                            "ndz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ndolo"s,                                                                            "ndl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ndom"s,                                                                             "nqm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ndombe"s,                                                                           "ndq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ndonde Hamba"s,                                                                     "njd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ndonga"s,                                                                           "ndo"s,   "ng"s, ""s,    true );
  g_languages.emplace_back(u8"Ndoola"s,                                                                           "ndr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nduga"s,                                                                            "ndx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ndumu"s,                                                                            "nmd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ndunda"s,                                                                           "nuh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ndunga"s,                                                                           "ndt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ndut"s,                                                                             "ndv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ndyuka-Trio Pidgin"s,                                                               "njt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ndzwani Comorian"s,                                                                 "wni"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Neapolitan"s,                                                                       "nap"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Nedebang"s,                                                                         "nec"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nefamese"s,                                                                         "nef"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Negeri Sembilan Malay"s,                                                            "zmi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Negidal"s,                                                                          "neg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nehan"s,                                                                            "nsn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nek"s,                                                                              "nif"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nekgini"s,                                                                          "nkg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Neko"s,                                                                             "nej"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Neku"s,                                                                             "nek"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nema"s,                                                                             "gsn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Neme"s,                                                                             "nex"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nemi"s,                                                                             "nem"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nen"s,                                                                              "nqn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nend"s,                                                                             "anh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nenets"s,                                                                           "yrk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nengone"s,                                                                          "nen"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nepal Bhasa; Newari"s,                                                              "new"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Nepalese Sign Language"s,                                                           "nsp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nepali (individual language)"s,                                                     "npi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nepali Kurux"s,                                                                     "kxl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nepali"s,                                                                           "nep"s,   "ne"s, ""s,    true );
  g_languages.emplace_back(u8"Nete"s,                                                                             "net"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"New Caledonian Javanese"s,                                                          "jas"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"New Zealand Sign Language"s,                                                        "nzs"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Neyo"s,                                                                             "ney"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nez Perce"s,                                                                        "nez"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ngaanyatjarra"s,                                                                    "ntj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ngad'a"s,                                                                           "nxg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ngadjunmaya"s,                                                                      "nju"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ngaing"s,                                                                           "nnf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ngaju"s,                                                                            "nij"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ngala"s,                                                                            "nud"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ngalum"s,                                                                           "szb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ngam"s,                                                                             "nmc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ngamambo"s,                                                                         "nbv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ngambay"s,                                                                          "sba"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ngamo"s,                                                                            "nbh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ngan'gityemerri"s,                                                                  "nam"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nganasan"s,                                                                         "nio"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ngando (Central African Republic)"s,                                                "ngd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ngando (Democratic Republic of Congo)"s,                                            "nxd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ngandyera"s,                                                                        "nne"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ngangam"s,                                                                          "gng"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ngardi"s,                                                                           "rxd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ngarinman"s,                                                                        "nbj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ngarinyin"s,                                                                        "ung"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ngarla"s,                                                                           "nrk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ngarluma"s,                                                                         "nrl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ngas"s,                                                                             "anc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ngasa"s,                                                                            "nsg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ngatik Men's Creole"s,                                                              "ngm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ngawn Chin"s,                                                                       "cnw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ngazidja Comorian"s,                                                                "zdj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ngbaka Ma'bo"s,                                                                     "nbm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ngbaka Manza"s,                                                                     "ngg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ngbaka"s,                                                                           "nga"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ngbinda"s,                                                                          "nbd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ngbundu"s,                                                                          "nuu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ngelima"s,                                                                          "agh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ngemba"s,                                                                           "nge"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ngeq"s,                                                                             "ngt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ngete"s,                                                                            "nnn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nggem"s,                                                                            "nbq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nggwahyi"s,                                                                         "ngx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ngie"s,                                                                             "ngj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ngiemboon"s,                                                                        "nnh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ngile"s,                                                                            "jle"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ngindo"s,                                                                           "nnq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ngiti"s,                                                                            "niy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ngizim"s,                                                                           "ngi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ngkâlmpw Kanum"s,                                                                   "kcd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ngom"s,                                                                             "nra"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ngomba"s,                                                                           "jgo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ngombale"s,                                                                         "nla"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ngombe (Central African Republic)"s,                                                "nmj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ngombe (Democratic Republic of Congo)"s,                                            "ngc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ngongo"s,                                                                           "noq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ngoni"s,                                                                            "ngo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ngoshie"s,                                                                          "nsh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ngul"s,                                                                             "nlo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ngulu"s,                                                                            "ngp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nguluwan"s,                                                                         "nuw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ngumbi"s,                                                                           "nui"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ngundi"s,                                                                           "ndn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ngundu"s,                                                                           "nue"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ngungwel"s,                                                                         "ngz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ngurimi"s,                                                                          "ngq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nguôn"s,                                                                            "nuo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ngwaba"s,                                                                           "ngw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ngwe"s,                                                                             "nwe"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ngwo"s,                                                                             "ngn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ngäbere"s,                                                                          "gym"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nhanda"s,                                                                           "nha"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nhengatu"s,                                                                         "yrl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nhuwala"s,                                                                          "nhf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nias"s,                                                                             "nia"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Nicaragua Creole English"s,                                                         "bzk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nicaraguan Sign Language"s,                                                         "ncs"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Niellim"s,                                                                          "nie"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Niger-Kordofanian languages"s,                                                      "nic"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Nigeria Mambila"s,                                                                  "mzk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nigerian Fulfulde"s,                                                                "fuv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nigerian Pidgin"s,                                                                  "pcm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nigerian Sign Language"s,                                                           "nsi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nihali"s,                                                                           "nll"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nii"s,                                                                              "nii"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Niksek"s,                                                                           "gbe"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nila"s,                                                                             "nil"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nilamba"s,                                                                          "nim"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nilo-Saharan languages"s,                                                           "ssa"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Nimadi"s,                                                                           "noe"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nimboran"s,                                                                         "nir"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nimi"s,                                                                             "nis"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nimo"s,                                                                             "niw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nimoa"s,                                                                            "nmw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ninam"s,                                                                            "shb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nindi"s,                                                                            "nxi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ningera"s,                                                                          "nby"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ninggerum"s,                                                                        "nxr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ningil"s,                                                                           "niz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ningye"s,                                                                           "nns"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ninia Yali"s,                                                                       "nlk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ninzo"s,                                                                            "nin"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nipsan"s,                                                                           "nps"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nisa"s,                                                                             "njs"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nisenan"s,                                                                          "nsz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nisga'a"s,                                                                          "ncg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nisi (China)"s,                                                                     "yso"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Niuafo'ou"s,                                                                        "num"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Niuean"s,                                                                           "niu"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Nivaclé"s,                                                                          "cag"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Niwer Mil"s,                                                                        "hrc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Njalgulgule"s,                                                                      "njl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Njebi"s,                                                                            "nzb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Njen"s,                                                                             "njj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Njerep"s,                                                                           "njr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Njyem"s,                                                                            "njy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nkami"s,                                                                            "nkq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nkangala"s,                                                                         "nkn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nkari"s,                                                                            "nkz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nkem-Nkum"s,                                                                        "isi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nkhumbi"s,                                                                          "khu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nkongho"s,                                                                          "nkc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nkonya"s,                                                                           "nko"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nkoroo"s,                                                                           "nkx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nkoya"s,                                                                            "nka"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nkukoli"s,                                                                          "nbo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nkutu"s,                                                                            "nkw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nnam"s,                                                                             "nbp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"No linguistic content; Not applicable"s,                                            "zxx"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Nobiin"s,                                                                           "fia"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nobonob"s,                                                                          "gaw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nocte Naga"s,                                                                       "njb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nogai"s,                                                                            "nog"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Noiri"s,                                                                            "noi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nokuku"s,                                                                           "nkk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nomaande"s,                                                                         "lem"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nomane"s,                                                                           "nof"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nomatsiguenga"s,                                                                    "not"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nomu"s,                                                                             "noh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nong Zhuang"s,                                                                      "zhn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nonuya"s,                                                                           "noj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Noon"s,                                                                             "snf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Noone"s,                                                                            "nhu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nopala Chatino"s,                                                                   "cya"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Norse, Old"s,                                                                       "non"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"North Alaskan Inupiatun"s,                                                          "esi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"North Ambrym"s,                                                                     "mmg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"North American Indian languages"s,                                                  "nai"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"North Asmat"s,                                                                      "nks"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"North Awyu"s,                                                                       "yir"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"North Azerbaijani"s,                                                                "azj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"North Babar"s,                                                                      "bcd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"North Bolivian Quechua"s,                                                           "qul"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"North Central Mixe"s,                                                               "neq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"North Efate"s,                                                                      "llp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"North Fali"s,                                                                       "fll"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"North Giziga"s,                                                                     "gis"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"North Junín Quechua"s,                                                              "qvn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"North Levantine Arabic"s,                                                           "apc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"North Marquesan"s,                                                                  "mrq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"North Mesopotamian Arabic"s,                                                        "ayp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"North Mofu"s,                                                                       "mfk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"North Moluccan Malay"s,                                                             "max"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"North Muyu"s,                                                                       "kti"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"North Nuaulu"s,                                                                     "nni"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"North Slavey"s,                                                                     "scs"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"North Tairora"s,                                                                    "tbg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"North Tanna"s,                                                                      "tnn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"North Wahgi"s,                                                                      "whg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"North Watut"s,                                                                      "una"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Northeast Kiwai"s,                                                                  "kiw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Northeast Maidu"s,                                                                  "nmu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Northeast Pashai"s,                                                                 "aee"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Northeastern Dinka"s,                                                               "dip"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Northeastern Thai"s,                                                                "tts"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Northern Alta"s,                                                                    "aqn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Northern Altai"s,                                                                   "atv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Northern Amami-Oshima"s,                                                            "ryn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Northern Betsimisaraka Malagasy"s,                                                  "bmm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Northern Binukidnon"s,                                                              "kyn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Northern Bobo Madaré"s,                                                             "bbo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Northern Bontok"s,                                                                  "rbk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Northern Catanduanes Bikol"s,                                                       "cts"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Northern Conchucos Ancash Quechua"s,                                                "qxn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Northern Dagara"s,                                                                  "dgi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Northern Dong"s,                                                                    "doc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Northern East Cree"s,                                                               "crl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Northern Emberá"s,                                                                  "emp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Northern Frisian"s,                                                                 "frr"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Northern Ghale"s,                                                                   "ghh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Northern Gondi"s,                                                                   "gno"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Northern Grebo"s,                                                                   "gbo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Northern Guiyang Hmong"s,                                                           "huj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Northern Haida"s,                                                                   "hdn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Northern Hindko"s,                                                                  "hno"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Northern Huishui Hmong"s,                                                           "hmi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Northern Kankanay"s,                                                                "xnn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Northern Khmer"s,                                                                   "kxm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Northern Kissi"s,                                                                   "kqs"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Northern Kurdish"s,                                                                 "kmr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Northern Luri"s,                                                                    "lrc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Northern Mashan Hmong"s,                                                            "hmp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Northern Muji"s,                                                                    "ymx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Northern Nago"s,                                                                    "xkb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Northern Ngbandi"s,                                                                 "ngb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Northern Nisu"s,                                                                    "yiv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Northern Nuni"s,                                                                    "nuv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Northern Oaxaca Nahuatl"s,                                                          "nhy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Northern Ohlone"s,                                                                  "cst"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Northern One"s,                                                                     "onr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Northern Paiute"s,                                                                  "pao"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Northern Pame"s,                                                                    "pmq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Northern Pashto"s,                                                                  "pbu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Northern Pastaza Quichua"s,                                                         "qvz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Northern Puebla Nahuatl"s,                                                          "ncj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Northern Pumi"s,                                                                    "pmi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Northern Qiandong Miao"s,                                                           "hea"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Northern Qiang"s,                                                                   "cng"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Northern Rengma Naga"s,                                                             "nnl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Northern Roglai"s,                                                                  "rog"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Northern Sami"s,                                                                    "sme"s,   "se"s, ""s,    true );
  g_languages.emplace_back(u8"Northern Sierra Miwok"s,                                                            "nsq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Northern Sorsoganon"s,                                                              "bks"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Northern Subanen"s,                                                                 "stb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Northern Tarahumara"s,                                                              "thh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Northern Tepehuan"s,                                                                "ntp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Northern Thai"s,                                                                    "nod"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Northern Tidung"s,                                                                  "ntd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Northern Tiwa"s,                                                                    "twf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Northern Tlaxiaco Mixtec"s,                                                         "xtn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Northern Toussian"s,                                                                "tsp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Northern Tujia"s,                                                                   "tji"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Northern Tutchone"s,                                                                "ttm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Northern Uzbek"s,                                                                   "uzn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Northern Yukaghir"s,                                                                "ykg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Northwest Alaska Inupiatun"s,                                                       "esk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Northwest Gbaya"s,                                                                  "gya"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Northwest Maidu"s,                                                                  "mjd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Northwest Oaxaca Mixtec"s,                                                          "mxa"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Northwest Pashai"s,                                                                 "glh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Northwestern Dinka"s,                                                               "diw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Northwestern Fars"s,                                                                "faz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Northwestern Kolami"s,                                                              "kfb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Northwestern Nisu"s,                                                                "nsf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Northwestern Ojibwa"s,                                                              "ojb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Northwestern Tamang"s,                                                              "tmk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Norwegian Nynorsk; Nynorsk, Norwegian"s,                                            "nno"s,   "nn"s, ""s,    true );
  g_languages.emplace_back(u8"Norwegian Sign Language"s,                                                          "nsl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Norwegian"s,                                                                        "nor"s,   "no"s, ""s,    true );
  g_languages.emplace_back(u8"Notre"s,                                                                            "bly"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Notsi"s,                                                                            "ncf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Noy"s,                                                                              "noy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nsenga"s,                                                                           "nse"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nshi"s,                                                                             "nsc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nsongo"s,                                                                           "nsx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ntcham"s,                                                                           "bud"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ntomba"s,                                                                           "nto"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nubaca"s,                                                                           "baf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nubi"s,                                                                             "kcn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nubian languages"s,                                                                 "nub"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Nubri"s,                                                                            "kte"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nuer"s,                                                                             "nus"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nugunu (Cameroon)"s,                                                                "yas"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nuk"s,                                                                              "noc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nukak Makú"s,                                                                       "mbr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nukna"s,                                                                            "klt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nukumanu"s,                                                                         "nuq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nukuoro"s,                                                                          "nkr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nukuria"s,                                                                          "nur"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Numana-Nunku-Gbantu-Numbu"s,                                                        "nbr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Numanggang"s,                                                                       "nop"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Numbami"s,                                                                          "sij"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nume"s,                                                                             "tgs"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Numèè"s,                                                                            "kdk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nung (Viet Nam)"s,                                                                  "nut"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nunggubuyu"s,                                                                       "nuy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nungu"s,                                                                            "rin"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nupbikha"s,                                                                         "npb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nupe-Nupe-Tako"s,                                                                   "nup"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nusa Laut"s,                                                                        "nul"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nusu"s,                                                                             "nuf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nuu-chah-nulth"s,                                                                   "nuk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nyabwa"s,                                                                           "nwb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nyaheun"s,                                                                          "nev"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nyahkur"s,                                                                          "cbn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nyakyusa-Ngonde"s,                                                                  "nyy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nyali"s,                                                                            "nlj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nyam"s,                                                                             "nmi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nyamal"s,                                                                           "nly"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nyambo"s,                                                                           "now"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nyamusa-Molo"s,                                                                     "nwm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nyamwanga"s,                                                                        "mwn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nyamwezi"s,                                                                         "nym"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Nyaneka"s,                                                                          "nyk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nyanga"s,                                                                           "nyj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nyanga-li"s,                                                                        "nyc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nyangatom"s,                                                                        "nnj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nyangbo"s,                                                                          "nyb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nyangumarta"s,                                                                      "nna"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nyankole"s,                                                                         "nyn"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Nyankpa"s,                                                                          "yes"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nyarafolo Senoufo"s,                                                                "sev"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nyaturu"s,                                                                          "rim"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nyaw"s,                                                                             "nyw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nyemba"s,                                                                           "nba"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nyengo"s,                                                                           "nye"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nyenkha"s,                                                                          "neh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nyeu"s,                                                                             "nyl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nyigina"s,                                                                          "nyh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nyiha (Malawi)"s,                                                                   "nyr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nyiha (Tanzania)"s,                                                                 "nih"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nyika (Malawi and Zambia)"s,                                                        "nkv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nyika (Tanzania)"s,                                                                 "nkt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nyindrou"s,                                                                         "lid"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nyindu"s,                                                                           "nyg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nyishi"s,                                                                           "njz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nyiyaparli"s,                                                                       "xny"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nyokon"s,                                                                           "nvo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nyole"s,                                                                            "nuj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nyong"s,                                                                            "muo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nyore"s,                                                                            "nyd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nyoro"s,                                                                            "nyo"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Nyunga"s,                                                                           "nys"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nyungwe"s,                                                                          "nyu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nyâlayu"s,                                                                          "yly"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nzakambay"s,                                                                        "nzy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nzakara"s,                                                                          "nzk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nzanyi"s,                                                                           "nja"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nzima"s,                                                                            "nzi"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Ná-Meo"s,                                                                           "neo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nêlêmwa-Nixumwak"s,                                                                 "nee"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Nüpode Huitoto"s,                                                                   "hux"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"O'du"s,                                                                             "tyh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Obanliku"s,                                                                         "bzy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Oblo"s,                                                                             "obl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Obo Manobo"s,                                                                       "obo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Obokuitai"s,                                                                        "afz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Obolo"s,                                                                            "ann"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Obulom"s,                                                                           "obu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ocaina"s,                                                                           "oca"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Occitan (post 1500); Provençal"s,                                                   "oci"s,   "oc"s, ""s,    true );
  g_languages.emplace_back(u8"Ocotepec Mixtec"s,                                                                  "mie"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ocotlán Zapotec"s,                                                                  "zac"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Od"s,                                                                               "odk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Odia"s,                                                                             "ory"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Odiai"s,                                                                            "bhf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Odoodee"s,                                                                          "kkc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Odual"s,                                                                            "odu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Odut"s,                                                                             "oda"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ofayé"s,                                                                            "opy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Official Aramaic (700-300 BCE); Imperial Aramaic (700-300 BCE)"s,                   "arc"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Ogbah"s,                                                                            "ogc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ogbia"s,                                                                            "ogb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ogbogolo"s,                                                                         "ogg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ogbronuagum"s,                                                                      "ogu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ogea"s,                                                                             "eri"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Oirata"s,                                                                           "oia"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ojibwa"s,                                                                           "oji"s,   "oj"s, ""s,    true );
  g_languages.emplace_back(u8"Ojitlán Chinantec"s,                                                                "chj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Okanagan"s,                                                                         "oka"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Oki-No-Erabu"s,                                                                     "okn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Okiek"s,                                                                            "oki"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Oko-Eni-Osayen"s,                                                                   "oks"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Okobo"s,                                                                            "okb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Okodia"s,                                                                           "okd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Okolod"s,                                                                           "kqv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Okpamheri"s,                                                                        "opa"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Okpe (Northwestern Edo)"s,                                                          "okx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Okpe (Southwestern Edo)"s,                                                          "oke"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Oksapmin"s,                                                                         "opm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Oku"s,                                                                              "oku"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Olekha"s,                                                                           "ole"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Olo"s,                                                                              "ong"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Oloma"s,                                                                            "olm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Olrat"s,                                                                            "olr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Olu'bo"s,                                                                           "lul"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Olulumo-Ikom"s,                                                                     "iko"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Oluta Popoluca"s,                                                                   "plo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Omagua"s,                                                                           "omg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Omaha-Ponca"s,                                                                      "oma"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Omani Arabic"s,                                                                     "acx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ombamba"s,                                                                          "mbm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ombo"s,                                                                             "oml"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ometepec Nahuatl"s,                                                                 "nht"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Omi"s,                                                                              "omi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Omotik"s,                                                                           "omt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ona"s,                                                                              "ona"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Oneida"s,                                                                           "one"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ong"s,                                                                              "oog"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Onin Based Pidgin"s,                                                                "onx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Onin"s,                                                                             "oni"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Onjob"s,                                                                            "onj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ono"s,                                                                              "ons"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Onobasulu"s,                                                                        "onn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Onondaga"s,                                                                         "ono"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ontenu"s,                                                                           "ont"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ontong Java"s,                                                                      "ojv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Oorlams"s,                                                                          "oor"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Opao"s,                                                                             "opo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Opuuo"s,                                                                            "lgn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Orang Kanaq"s,                                                                      "orn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Orang Seletar"s,                                                                    "ors"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Oraon Sadri"s,                                                                      "sdr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Orejón"s,                                                                           "ore"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Oring"s,                                                                            "org"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Oriya"s,                                                                            "ori"s,   "or"s, ""s,    true );
  g_languages.emplace_back(u8"Orizaba Nahuatl"s,                                                                  "nlv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Orma"s,                                                                             "orc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ormu"s,                                                                             "orz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ormuri"s,                                                                           "oru"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Oro Win"s,                                                                          "orw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Oro"s,                                                                              "orx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Oroch"s,                                                                            "oac"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Oroha"s,                                                                            "ora"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Orok"s,                                                                             "oaa"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Orokaiva"s,                                                                         "okv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Oroko"s,                                                                            "bdu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Orokolo"s,                                                                          "oro"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Oromo"s,                                                                            "orm"s,   "om"s, ""s,    true );
  g_languages.emplace_back(u8"Oroqen"s,                                                                           "orh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Orowe"s,                                                                            "bpk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Oruma"s,                                                                            "orr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Orya"s,                                                                             "ury"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Osage"s,                                                                            "osa"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Osatu"s,                                                                            "ost"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Osing"s,                                                                            "osi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ososo"s,                                                                            "oso"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ossetian; Ossetic"s,                                                                "oss"s,   "os"s, ""s,    true );
  g_languages.emplace_back(u8"Ot Danum"s,                                                                         "otd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Otank"s,                                                                            "uta"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Otomian languages"s,                                                                "oto"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Otoro"s,                                                                            "otr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ottawa"s,                                                                           "otw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Otuho"s,                                                                            "lot"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Oune"s,                                                                             "oue"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Owa"s,                                                                              "stn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Owenia"s,                                                                           "wsr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Owiniga"s,                                                                          "owi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Oy"s,                                                                               "oyb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Oya'oya"s,                                                                          "oyy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Oyda"s,                                                                             "oyd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ozolotepec Zapotec"s,                                                               "zao"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ozumacín Chinantec"s,                                                               "chz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pa Di"s,                                                                            "pdi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pa'a"s,                                                                             "pqa"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pa'o Karen"s,                                                                       "blk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pa-Hng"s,                                                                           "pha"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Paakantyi"s,                                                                        "drl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Paama"s,                                                                            "pma"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Paasaal"s,                                                                          "sig"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pacahuara"s,                                                                        "pcp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pacaraos Quechua"s,                                                                 "qvp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pacific Gulf Yupik"s,                                                               "ems"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pacoh"s,                                                                            "pac"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Padoe"s,                                                                            "pdo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pagi"s,                                                                             "pgi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pagibete"s,                                                                         "pae"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pagu"s,                                                                             "pgu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pahanan Agta"s,                                                                     "apf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pahari-Potwari"s,                                                                   "phr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pahi"s,                                                                             "lgt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pahlavani"s,                                                                        "phv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pahlavi"s,                                                                          "pal"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Pai Tavytera"s,                                                                     "pta"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Paicî"s,                                                                            "pri"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Paipai"s,                                                                           "ppi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Paite Chin"s,                                                                       "pck"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Paiwan"s,                                                                           "pwn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pak-Tong"s,                                                                         "pkg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pakanha"s,                                                                          "pkn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pakaásnovos"s,                                                                      "pav"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pakistan Sign Language"s,                                                           "pks"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Paku Karen"s,                                                                       "jkp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Paku"s,                                                                             "pku"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pal"s,                                                                              "abw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Palaka Senoufo"s,                                                                   "plr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Palantla Chinantec"s,                                                               "cpa"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Palauan"s,                                                                          "pau"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Paleni"s,                                                                           "pnl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Palenquero"s,                                                                       "pln"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pali"s,                                                                             "pli"s,   "pi"s, ""s,    true );
  g_languages.emplace_back(u8"Palikúr"s,                                                                          "plu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Paliyan"s,                                                                          "pcf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Palor"s,                                                                            "fap"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Palpa"s,                                                                            "plp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Palu'e"s,                                                                           "ple"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Paluan"s,                                                                           "plz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Palya Bareli"s,                                                                     "bpx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pam"s,                                                                              "pmn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pambia"s,                                                                           "pmb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pamona"s,                                                                           "pmf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pamosu"s,                                                                           "hih"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pampanga; Kapampangan"s,                                                            "pam"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Pamplona Atta"s,                                                                    "att"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pana (Burkina Faso)"s,                                                              "pnq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pana (Central African Republic)"s,                                                  "pnz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Panamanian Sign Language"s,                                                         "lsp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Panamint"s,                                                                         "par"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Panao Huánuco Quechua"s,                                                            "qxh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Panará"s,                                                                           "kre"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Panasuan"s,                                                                         "psn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Panawa"s,                                                                           "pwb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pancana"s,                                                                          "pnp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Panchpargania"s,                                                                    "tdb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pande"s,                                                                            "bkj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pangasinan"s,                                                                       "pag"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Pangseng"s,                                                                         "pgs"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pangutaran Sama"s,                                                                  "slm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pangwa"s,                                                                           "pbr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pangwali"s,                                                                         "pgg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Panim"s,                                                                            "pnr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Paniya"s,                                                                           "pcg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Panjabi; Punjabi"s,                                                                 "pan"s,   "pa"s, ""s,    true );
  g_languages.emplace_back(u8"Pankhu"s,                                                                           "pkh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pannei"s,                                                                           "pnc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pano"s,                                                                             "mqz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Panoan Katukína"s,                                                                  "knt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Panyi Bai"s,                                                                        "bfc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Panytyima"s,                                                                        "pnw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Papantla Totonac"s,                                                                 "top"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Papapana"s,                                                                         "ppn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Papar"s,                                                                            "dpp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Papasena"s,                                                                         "pas"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Papel"s,                                                                            "pbo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Papi"s,                                                                             "ppe"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Papiamento"s,                                                                       "pap"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Papitalai"s,                                                                        "pat"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Papua New Guinean Sign Language"s,                                                  "pgz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Papuan Malay"s,                                                                     "pmy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Papuan languages"s,                                                                 "paa"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Papuma"s,                                                                           "ppm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Para Naga"s,                                                                        "pzn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Parachi"s,                                                                          "prc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Paraguayan Guaraní"s,                                                               "gug"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Paraguayan Sign Language"s,                                                         "pys"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Parakanã"s,                                                                         "pak"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Paranan"s,                                                                          "prf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Parauk"s,                                                                           "prk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Parawen"s,                                                                          "prw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pardhan"s,                                                                          "pch"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pardhi"s,                                                                           "pcl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pare"s,                                                                             "ppt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Parecís"s,                                                                          "pab"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Parenga"s,                                                                          "pcj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Parkari Koli"s,                                                                     "kvx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Parkwa"s,                                                                           "pbi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Parsi"s,                                                                            "prp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Parsi-Dari"s,                                                                       "prd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Parya"s,                                                                            "paq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pará Arára"s,                                                                       "aap"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pará Gavião"s,                                                                      "gvp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pasi"s,                                                                             "psq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pass Valley Yali"s,                                                                 "yac"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Patamona"s,                                                                         "pbc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Patani"s,                                                                           "ptn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Patep"s,                                                                            "ptp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pathiya"s,                                                                          "pty"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Patpatar"s,                                                                         "gfk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pattani Malay"s,                                                                    "mfa"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pattani"s,                                                                          "lae"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pattapu"s,                                                                          "ptq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Paulohi"s,                                                                          "plh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Paumarí"s,                                                                          "pad"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Paunaka"s,                                                                          "pnk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pauri Bareli"s,                                                                     "bfb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pawaia"s,                                                                           "pwa"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pawnee"s,                                                                           "paw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Paynamar"s,                                                                         "pmr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pe"s,                                                                               "pai"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pear"s,                                                                             "pcb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pech"s,                                                                             "pay"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pedi; Sepedi; Northern Sotho"s,                                                     "nso"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Peere"s,                                                                            "pfe"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pei"s,                                                                              "ppq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pekal"s,                                                                            "pel"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pela"s,                                                                             "bxd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pele-Ata"s,                                                                         "ata"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pelende"s,                                                                          "ppp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pemon"s,                                                                            "aoc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Penang Sign Language"s,                                                             "psg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Penchal"s,                                                                          "pek"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pendau"s,                                                                           "ums"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pengo"s,                                                                            "peg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pennsylvania German"s,                                                              "pdc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Penrhyn"s,                                                                          "pnh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Perai"s,                                                                            "wet"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Peranakan Indonesian"s,                                                             "pea"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Peripheral Mongolian"s,                                                             "mvf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pero"s,                                                                             "pip"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Persian Sign Language"s,                                                            "psc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Persian"s,                                                                          "per"s,   "fa"s, "fas"s, true );
  g_languages.emplace_back(u8"Persian, Old (ca. 600-400 B.C.)"s,                                                  "peo"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Peruvian Sign Language"s,                                                           "prl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Petapa Zapotec"s,                                                                   "zpe"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Petats"s,                                                                           "pex"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Petjo"s,                                                                            "pey"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Peñoles Mixtec"s,                                                                   "mil"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pfaelzisch"s,                                                                       "pfl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Phai"s,                                                                             "prt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Phake"s,                                                                            "phk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Phala"s,                                                                            "ypa"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Phalura"s,                                                                          "phl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Phana'"s,                                                                           "phq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Phangduwali"s,                                                                      "phw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Phende"s,                                                                           "pem"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Philippine Sign Language"s,                                                         "psp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Philippine languages"s,                                                             "phi"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Phimbi"s,                                                                           "phm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Phoenician"s,                                                                       "phn"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Phola"s,                                                                            "ypg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pholo"s,                                                                            "yip"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Phom Naga"s,                                                                        "nph"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Phong-Kniang"s,                                                                     "pnx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Phrae Pwo Karen"s,                                                                  "kjt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Phu Thai"s,                                                                         "pht"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Phuan"s,                                                                            "phu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Phudagi"s,                                                                          "phd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Phuie"s,                                                                            "pug"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Phukha"s,                                                                           "phh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Phuma"s,                                                                            "ypm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Phunoi"s,                                                                           "pho"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Phuong"s,                                                                           "phg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Phupa"s,                                                                            "ypp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Phupha"s,                                                                           "yph"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Phuza"s,                                                                            "ypz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Piamatsina"s,                                                                       "ptr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Piame"s,                                                                            "pin"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Piapoco"s,                                                                          "pio"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Piaroa"s,                                                                           "pid"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Picard"s,                                                                           "pcd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pichis Ashéninka"s,                                                                 "cpu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Piemontese"s,                                                                       "pms"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pije"s,                                                                             "piz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pijin"s,                                                                            "pis"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pilagá"s,                                                                           "plg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pileni"s,                                                                           "piv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pima Bajo"s,                                                                        "pia"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pimbwe"s,                                                                           "piw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pinai-Hagahai"s,                                                                    "pnn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pingelapese"s,                                                                      "pif"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pini"s,                                                                             "pii"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pinigura"s,                                                                         "pnv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pinji"s,                                                                            "pic"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pinotepa Nacional Mixtec"s,                                                         "mio"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pintiini"s,                                                                         "pti"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pintupi-Luritja"s,                                                                  "piu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pinyin"s,                                                                           "pny"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pipil"s,                                                                            "ppl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pirahã"s,                                                                           "myp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Piratapuyo"s,                                                                       "pir"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pisabo"s,                                                                           "pig"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pisaflores Tepehua"s,                                                               "tpp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pitcairn-Norfolk"s,                                                                 "pih"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pite Sami"s,                                                                        "sje"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Piti"s,                                                                             "pcn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pitjantjatjara"s,                                                                   "pjt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Piu"s,                                                                              "pix"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Piya-Kwonci"s,                                                                      "piy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Plains Cree"s,                                                                      "crk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Plains Indian Sign Language"s,                                                      "psd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Plains Miwok"s,                                                                     "pmw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Plapo Krumen"s,                                                                     "ktj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Plateau Malagasy"s,                                                                 "plt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Plautdietsch"s,                                                                     "pdt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Playero"s,                                                                          "gob"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pnar"s,                                                                             "pbv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pochuri Naga"s,                                                                     "npo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Podena"s,                                                                           "pdn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pogolo"s,                                                                           "poy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pohnpeian"s,                                                                        "pon"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Pokangá"s,                                                                          "pok"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Poke"s,                                                                             "pof"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pokomo"s,                                                                           "pkb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Polari"s,                                                                           "pld"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Polci"s,                                                                            "plj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Polish Sign Language"s,                                                             "pso"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Polish"s,                                                                           "pol"s,   "pl"s, ""s,    true );
  g_languages.emplace_back(u8"Polonombauk"s,                                                                      "plb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pom"s,                                                                              "pmo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pomo"s,                                                                             "pmm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ponam"s,                                                                            "ncc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pongu"s,                                                                            "png"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ponosakan"s,                                                                        "pns"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pontic"s,                                                                           "pnt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ponyo-Gongwang Naga"s,                                                              "npg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Popti'"s,                                                                           "jac"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Poqomam"s,                                                                          "poc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Poqomchi'"s,                                                                        "poh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Porohanon"s,                                                                        "prh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Port Sandwich"s,                                                                    "psw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Port Vato"s,                                                                        "ptv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Portuguese Sign Language"s,                                                         "psr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Portuguese"s,                                                                       "por"s,   "pt"s, ""s,    true );
  g_languages.emplace_back(u8"Potawatomi"s,                                                                       "pot"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pottangi Ollar Gadaba"s,                                                            "gdb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Poumei Naga"s,                                                                      "pmx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pouye"s,                                                                            "bye"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Powari"s,                                                                           "pwr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Poyanáwa"s,                                                                         "pyn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Prakrit languages"s,                                                                "pra"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Prasuni"s,                                                                          "prn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Principense"s,                                                                      "pre"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Provençal, Old (to 1500)"s,                                                         "pro"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Providencia Sign Language"s,                                                        "prz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Prussian"s,                                                                         "prg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Psikye"s,                                                                           "kvj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pu Ko"s,                                                                            "puk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pu-Xian Chinese"s,                                                                  "cpx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Puare"s,                                                                            "pux"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pudtol Atta"s,                                                                      "atp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Puerto Rican Sign Language"s,                                                       "psl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Puimei Naga"s,                                                                      "npu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Puinave"s,                                                                          "pui"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pukapuka"s,                                                                         "pkp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pulaar"s,                                                                           "fuc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pulabu"s,                                                                           "pup"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pular"s,                                                                            "fuf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Puluwatese"s,                                                                       "puw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Puma"s,                                                                             "pum"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pumé"s,                                                                             "yae"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Punan Aput"s,                                                                       "pud"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Punan Bah-Biau"s,                                                                   "pna"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Punan Batu 1"s,                                                                     "pnm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Punan Merah"s,                                                                      "puf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Punan Merap"s,                                                                      "puc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Punan Tubu"s,                                                                       "puj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Puno Quechua"s,                                                                     "qxp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Punu"s,                                                                             "puu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Puoc"s,                                                                             "puo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Puragi"s,                                                                           "pru"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Purari"s,                                                                           "iar"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Purepecha"s,                                                                        "tsz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Purik"s,                                                                            "prx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Puroik"s,                                                                           "suv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Puruborá"s,                                                                         "pur"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Purum"s,                                                                            "pub"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pushto; Pashto"s,                                                                   "pus"s,   "ps"s, ""s,    true );
  g_languages.emplace_back(u8"Putai"s,                                                                            "mfl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Putoh"s,                                                                            "put"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Putukwam"s,                                                                         "afe"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Puyuma"s,                                                                           "pyu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pwaamei"s,                                                                          "pme"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pwapwâ"s,                                                                           "pop"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pwo Eastern Karen"s,                                                                "kjp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pwo Northern Karen"s,                                                               "pww"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pwo Western Karen"s,                                                                "pwo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pyapun"s,                                                                           "pcw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pye Krumen"s,                                                                       "pye"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pyen"s,                                                                             "pyy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pyu (Papua New Guinea)"s,                                                           "pby"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Páez"s,                                                                             "pbb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pááfang"s,                                                                          "pfa"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Päri"s,                                                                             "lkr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pémono"s,                                                                           "pev"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pévé"s,                                                                             "lme"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Pökoot"s,                                                                           "pko"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Q'anjob'al"s,                                                                       "kjb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Qabiao"s,                                                                           "laq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Qaqet"s,                                                                            "byx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Qashqa'i"s,                                                                         "qxq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Qau"s,                                                                              "gqu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Qawasqar"s,                                                                         "alc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Qila Muji"s,                                                                        "ymq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Qimant"s,                                                                           "ahg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Qiubei Zhuang"s,                                                                    "zqe"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Quapaw"s,                                                                           "qua"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Quebec Sign Language"s,                                                             "fcs"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Quechan"s,                                                                          "yum"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Quechua"s,                                                                          "que"s,   "qu"s, ""s,    true );
  g_languages.emplace_back(u8"Querétaro Otomi"s,                                                                  "otq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Quetzaltepec Mixe"s,                                                                "pxm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Queyu"s,                                                                            "qvy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Quiavicuzas Zapotec"s,                                                              "zpj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Quileute"s,                                                                         "qui"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Quinqui"s,                                                                          "quq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Quioquitani-Quierí Zapotec"s,                                                       "ztq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Quiotepec Chinantec"s,                                                              "chq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Rabha"s,                                                                            "rah"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Rade"s,                                                                             "rad"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Rahambuu"s,                                                                         "raz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Rajah Kabunsuwan Manobo"s,                                                          "mqk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Rajasthani"s,                                                                       "raj"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Rajbanshi"s,                                                                        "rjs"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Raji"s,                                                                             "rji"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Rajong"s,                                                                           "rjg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Rajput Garasia"s,                                                                   "gra"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Rakahanga-Manihiki"s,                                                               "rkh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Rakhine"s,                                                                          "rki"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ralte"s,                                                                            "ral"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Rama"s,                                                                             "rma"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ramoaaina"s,                                                                        "rai"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ramopa"s,                                                                           "kjx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Rampi"s,                                                                            "lje"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Rana Tharu"s,                                                                       "thr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Rang"s,                                                                             "rax"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ranglong"s,                                                                         "rnl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Rangpuri"s,                                                                         "rkt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Rao"s,                                                                              "rao"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Rapa"s,                                                                             "ray"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Rapanui"s,                                                                          "rap"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Rapoisi"s,                                                                          "kyx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Rapting"s,                                                                          "rpt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Rara Bakati'"s,                                                                     "lra"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Rarotongan; Cook Islands Maori"s,                                                   "rar"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Rasawa"s,                                                                           "rac"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ratagnon"s,                                                                         "btn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ratahan"s,                                                                          "rth"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Rathawi"s,                                                                          "rtw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Rathwi Bareli"s,                                                                    "bgd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Raute"s,                                                                            "rau"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ravula"s,                                                                           "yea"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Rawa"s,                                                                             "rwo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Rawang"s,                                                                           "raw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Rawat"s,                                                                            "jnl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Rawngtu Chin"s,                                                                     "weu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Rawo"s,                                                                             "rwa"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Rayón Zoque"s,                                                                      "zor"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Razajerdi"s,                                                                        "rat"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Red Gelao"s,                                                                        "gir"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Reel"s,                                                                             "atu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Rejang Kayan"s,                                                                     "ree"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Rejang"s,                                                                           "rej"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Reli"s,                                                                             "rei"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Rembarunga"s,                                                                       "rmb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Rembong"s,                                                                          "reb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Remontado Dumagat"s,                                                                "agv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Rempi"s,                                                                            "rmp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Remun"s,                                                                            "lkj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Rendille"s,                                                                         "rel"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Rengao"s,                                                                           "ren"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Rennell-Bellona"s,                                                                  "mnv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Rennellese Sign Language"s,                                                         "rsi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Repanbitip"s,                                                                       "rpn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Rerau"s,                                                                            "rea"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Rerep"s,                                                                            "pgk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Reserved for local use: qaa"s,                                                      u8"qaa"s, ""s,   ""s,    true );
  g_languages.emplace_back(u8"Reserved for local use: qab"s,                                                      u8"qab"s, ""s,   ""s,    true );
  g_languages.emplace_back(u8"Reserved for local use: qac"s,                                                      u8"qac"s, ""s,   ""s,    true );
  g_languages.emplace_back(u8"Reserved for local use: qad"s,                                                      u8"qad"s, ""s,   ""s,    true );
  g_languages.emplace_back(u8"Reshe"s,                                                                            "res"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Resígaro"s,                                                                         "rgr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Retta"s,                                                                            "ret"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Reyesano"s,                                                                         "rey"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Riang (India)"s,                                                                    "ria"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Riang (Myanmar)"s,                                                                  "ril"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Riantana"s,                                                                         "ran"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ribun"s,                                                                            "rir"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Rien"s,                                                                             "rie"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Rikbaktsa"s,                                                                        "rkb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Rinconada Bikol"s,                                                                  "bto"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Rincón Zapotec"s,                                                                   "zar"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ringgou"s,                                                                          "rgu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ririo"s,                                                                            "rri"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ritarungo"s,                                                                        "rit"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Riung"s,                                                                            "riu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Riverain Sango"s,                                                                   "snj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Rogo"s,                                                                             "rod"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Rohingya"s,                                                                         "rhg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Roma"s,                                                                             "rmm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Romagnol"s,                                                                         "rgn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Romam"s,                                                                            "rmx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Romance languages"s,                                                                "roa"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Romanian Sign Language"s,                                                           "rms"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Romanian; Moldavian; Moldovan"s,                                                    "rum"s,   "ro"s, "ron"s, true );
  g_languages.emplace_back(u8"Romano-Greek"s,                                                                     "rge"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Romano-Serbian"s,                                                                   "rsb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Romansh"s,                                                                          "roh"s,   "rm"s, ""s,    true );
  g_languages.emplace_back(u8"Romany"s,                                                                           "rom"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Romblomanon"s,                                                                      "rol"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Rombo"s,                                                                            "rof"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Romkun"s,                                                                           "rmk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ron"s,                                                                              "cla"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ronga"s,                                                                            "rng"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Rongga"s,                                                                           "ror"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Rongmei Naga"s,                                                                     "nbu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Rongpo"s,                                                                           "rnp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ronji"s,                                                                            "roe"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Roon"s,                                                                             "rnn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Roria"s,                                                                            "rga"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Rotokas"s,                                                                          "roo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Rotuman"s,                                                                          "rtm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Roviana"s,                                                                          "rug"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ruching Palaung"s,                                                                  "pce"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Rudbari"s,                                                                          "rdb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Rufiji"s,                                                                           "rui"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ruga"s,                                                                             "ruh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Rukai"s,                                                                            "dru"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ruma"s,                                                                             "ruz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Rumai Palaung"s,                                                                    "rbb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Rumu"s,                                                                             "klq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Rundi"s,                                                                            "run"s,   "rn"s, ""s,    true );
  g_languages.emplace_back(u8"Runga"s,                                                                            "rou"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Rungtu Chin"s,                                                                      "rtc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Rungus"s,                                                                           "drg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Rungwa"s,                                                                           "rnw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Russia Buriat"s,                                                                    "bxr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Russian Sign Language"s,                                                            "rsl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Russian"s,                                                                          "rus"s,   "ru"s, ""s,    true );
  g_languages.emplace_back(u8"Rusyn"s,                                                                            "rue"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Rutul"s,                                                                            "rut"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ruuli"s,                                                                            "ruc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ruund"s,                                                                            "rnd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Rwa"s,                                                                              "rwk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Réunion Creole French"s,                                                            "rcf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Rāziḥī"s,                                                                           "rzh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"S'gaw Karen"s,                                                                      "ksw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sa"s,                                                                               "sax"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sa'a"s,                                                                             "apb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sa'ban"s,                                                                           "snv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sa'och"s,                                                                           "scq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Saafi-Saafi"s,                                                                      "sav"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Saam"s,                                                                             "raq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Saamia"s,                                                                           "lsm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Saaroa"s,                                                                           "sxr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Saba"s,                                                                             "saa"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sabah Bisaya"s,                                                                     "bsy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sabah Malay"s,                                                                      "msi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sabanê"s,                                                                           "sae"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sabaot"s,                                                                           "spy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sabu"s,                                                                             "hvn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sabüm"s,                                                                            "sbo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sacapulteco"s,                                                                      "quv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sadri"s,                                                                            "sck"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Saek"s,                                                                             "skb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Saep"s,                                                                             "spd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Safaliba"s,                                                                         "saf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Safeyoka"s,                                                                         "apz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Safwa"s,                                                                            "sbk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sagala"s,                                                                           "sbm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sagalla"s,                                                                          "tga"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Saho"s,                                                                             "ssy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sahu"s,                                                                             "saj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Saidi Arabic"s,                                                                     "aec"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Saint Lucian Creole French"s,                                                       "acf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Saisiyat"s,                                                                         "xsy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sajalong"s,                                                                         "sjl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sajau Basap"s,                                                                      "sjb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sakachep"s,                                                                         "sch"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sakalava Malagasy"s,                                                                "skg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sakao"s,                                                                            "sku"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sakata"s,                                                                           "skt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sake"s,                                                                             "sak"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sakirabiá"s,                                                                        "skf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sala"s,                                                                             "shq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Salampasu"s,                                                                        "slx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Salar"s,                                                                            "slr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Salas"s,                                                                            "sgu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Salasaca Highland Quichua"s,                                                        "qxl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Salchuq"s,                                                                          "slq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Saleman"s,                                                                          "sau"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Saliba"s,                                                                           "sbe"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Salishan languages"s,                                                               "sal"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Sallands"s,                                                                         "sdz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Salt-Yui"s,                                                                         "sll"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Saluan"s,                                                                           "loe"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Salumá"s,                                                                           "slj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Salvadoran Sign Language"s,                                                         "esn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sam"s,                                                                              "snx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sama"s,                                                                             "smd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Samaritan Aramaic"s,                                                                "sam"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Samarokena"s,                                                                       "tmj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Samatao"s,                                                                          "ysd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Samay"s,                                                                            "syx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Samba Daka"s,                                                                       "ccg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Samba Leko"s,                                                                       "ndi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Samba"s,                                                                            "smx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sambal"s,                                                                           "xsb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sambalpuri"s,                                                                       "spv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sambe"s,                                                                            "xab"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Samberigi"s,                                                                        "ssx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Samburu"s,                                                                          "saq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Samei"s,                                                                            "smh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sami languages"s,                                                                   "smi"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Samo"s,                                                                             "smq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Samoan"s,                                                                           "smo"s,   "sm"s, ""s,    true );
  g_languages.emplace_back(u8"Samogitian"s,                                                                       "sgs"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Samosa"s,                                                                           "swm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sampang"s,                                                                          "rav"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Samre"s,                                                                            "sxm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Samtao"s,                                                                           "stu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Samvedi"s,                                                                          "smv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"San Agustín Mixtepec Zapotec"s,                                                     "ztm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"San Baltazar Loxicha Zapotec"s,                                                     "zpx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"San Blas Kuna"s,                                                                    "cuk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"San Dionisio Del Mar Huave"s,                                                       "hve"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"San Felipe Otlaltepec Popoloca"s,                                                   "pow"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"San Francisco Del Mar Huave"s,                                                      "hue"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"San Francisco Matlatzinca"s,                                                        "mat"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"San Jerónimo Tecóatl Mazatec"s,                                                     "maa"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"San Juan Atzingo Popoloca"s,                                                        "poe"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"San Juan Colorado Mixtec"s,                                                         "mjc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"San Juan Teita Mixtec"s,                                                            "xtj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"San Luís Temalacayuca Popoloca"s,                                                   "pps"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"San Marcos Tlacoyalco Popoloca"s,                                                   "pls"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"San Martín Itunyoso Triqui"s,                                                       "trq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"San Martín Quechua"s,                                                               "qvs"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"San Mateo Del Mar Huave"s,                                                          "huv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"San Miguel Creole French"s,                                                         "scf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"San Miguel El Grande Mixtec"s,                                                      "mig"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"San Miguel Piedras Mixtec"s,                                                        "xtp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"San Pedro Amuzgos Amuzgo"s,                                                         "azg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"San Pedro Quiatoni Zapotec"s,                                                       "zpf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"San Salvador Kongo"s,                                                               "kwy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"San Vicente Coatlán Zapotec"s,                                                      "zpt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sanaani Arabic"s,                                                                   "ayn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sanapaná"s,                                                                         "spn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sandawe"s,                                                                          "sad"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Sanga (Democratic Republic of Congo)"s,                                             "sng"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sanga (Nigeria)"s,                                                                  "xsn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sanggau"s,                                                                          "scg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sangil"s,                                                                           "snl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sangir"s,                                                                           "sxn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sangisari"s,                                                                        "sgr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sangkong"s,                                                                         "sgk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sanglechi"s,                                                                        "sgy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sango"s,                                                                            "sag"s,   "sg"s, ""s,    true );
  g_languages.emplace_back(u8"Sangtam Naga"s,                                                                     "nsa"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sangu (Gabon)"s,                                                                    "snq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sangu (Tanzania)"s,                                                                 "sbp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sani"s,                                                                             "ysn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sanie"s,                                                                            "ysy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Saniyo-Hiyewe"s,                                                                    "sny"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sankaran Maninka"s,                                                                 "msc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sansi"s,                                                                            "ssi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sanskrit"s,                                                                         "san"s,   "sa"s, ""s,    true );
  g_languages.emplace_back(u8"Santa Ana de Tusi Pasco Quechua"s,                                                  "qxt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Santa Catarina Albarradas Zapotec"s,                                                "ztn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Santa Inés Ahuatempan Popoloca"s,                                                   "pca"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Santa Inés Yatzechi Zapotec"s,                                                      "zpn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Santa Lucía Monteverde Mixtec"s,                                                    "mdv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Santa María Del Mar Huave"s,                                                        "hvv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Santa María La Alta Nahuatl"s,                                                      "nhz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Santa María Quiegolani Zapotec"s,                                                   "zpi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Santa María Zacatepec Mixtec"s,                                                     "mza"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Santa Teresa Cora"s,                                                                "cok"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Santali"s,                                                                          "sat"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Santiago Xanica Zapotec"s,                                                          "zpr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Santiago del Estero Quichua"s,                                                      "qus"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Santo Domingo Albarradas Zapotec"s,                                                 "zas"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sanumá"s,                                                                           "xsu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Saparua"s,                                                                          "spr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sapo"s,                                                                             "krn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Saponi"s,                                                                           "spi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Saposa"s,                                                                           "sps"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sapuan"s,                                                                           "spu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sapé"s,                                                                             "spc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sar"s,                                                                              "mwm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sara Kaba Deme"s,                                                                   "kwg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sara Kaba Náà"s,                                                                    "kwv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sara Kaba"s,                                                                        "sbz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sara"s,                                                                             "sre"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Saraiki"s,                                                                          "skr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Saramaccan"s,                                                                       "srm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sarangani Blaan"s,                                                                  "bps"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sarangani Manobo"s,                                                                 "mbs"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sarasira"s,                                                                         "zsa"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sardinian"s,                                                                        "srd"s,   "sc"s, ""s,    true );
  g_languages.emplace_back(u8"Sari"s,                                                                             "asj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sarikoli"s,                                                                         "srh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sarli"s,                                                                            "sdf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sarsi"s,                                                                            "srs"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sartang"s,                                                                          "onp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sarua"s,                                                                            "swy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sarudu"s,                                                                           "sdu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Saruga"s,                                                                           "sra"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sasak"s,                                                                            "sas"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Sasaru"s,                                                                           "sxs"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sassarese Sardinian"s,                                                              "sdc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Satawalese"s,                                                                       "stw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Saterfriesisch"s,                                                                   "stq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sateré-Mawé"s,                                                                      "mav"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Saudi Arabian Sign Language"s,                                                      "sdl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Saurashtra"s,                                                                       "saz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sauri"s,                                                                            "srt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sauria Paharia"s,                                                                   "mjt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sause"s,                                                                            "sao"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sausi"s,                                                                            "ssj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Savi"s,                                                                             "sdg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Savosavo"s,                                                                         "svs"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sawai"s,                                                                            "szw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Saweru"s,                                                                           "swr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sawi"s,                                                                             "saw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sawila"s,                                                                           "swt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sawknah"s,                                                                          "swn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Saxwe Gbe"s,                                                                        "sxw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Saya"s,                                                                             "say"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sayula Popoluca"s,                                                                  "pos"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Scots"s,                                                                            "sco"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Sea Island Creole English"s,                                                        "gul"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Seba"s,                                                                             "kdg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sebat Bet Gurage"s,                                                                 "sgw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Seberuang"s,                                                                        "sbx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sebop"s,                                                                            "sib"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sebuyau"s,                                                                          "snb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sechelt"s,                                                                          "sec"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Secoya"s,                                                                           "sey"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sedang"s,                                                                           "sed"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sedoa"s,                                                                            "tvw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Seeku"s,                                                                            "sos"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Segai"s,                                                                            "sge"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Segeju"s,                                                                           "seg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Seget"s,                                                                            "sbg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sehwi"s,                                                                            "sfw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Seimat"s,                                                                           "ssg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Seit-Kaitetu"s,                                                                     "hik"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sekani"s,                                                                           "sek"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sekapan"s,                                                                          "skp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sekar"s,                                                                            "skz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Seke (Nepal)"s,                                                                     "skj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Seke (Vanuatu)"s,                                                                   "ske"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sekele"s,                                                                           "vaj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Seki"s,                                                                             "syi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Seko Padang"s,                                                                      "skx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Seko Tengah"s,                                                                      "sko"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sekpele"s,                                                                          "lip"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Selangor Sign Language"s,                                                           "kgi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Selaru"s,                                                                           "slu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Selayar"s,                                                                          "sly"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Selee"s,                                                                            "snw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Selepet"s,                                                                          "spl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Selkup"s,                                                                           "sel"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Selungai Murut"s,                                                                   "slg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Seluwasan"s,                                                                        "sws"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Semai"s,                                                                            "sea"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Semandang"s,                                                                        "sdm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Semaq Beri"s,                                                                       "szc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sembakung Murut"s,                                                                  "sbr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Semelai"s,                                                                          "sza"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Semimi"s,                                                                           "etz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Semitic languages"s,                                                                "sem"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Semnam"s,                                                                           "ssm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Semnani"s,                                                                          "smy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sempan"s,                                                                           "xse"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sena"s,                                                                             "seh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Senara Sénoufo"s,                                                                   "seq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Senaya"s,                                                                           "syn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sene"s,                                                                             "sej"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Seneca"s,                                                                           "see"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sengele"s,                                                                          "szg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Senggi"s,                                                                           "snu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sengo"s,                                                                            "spk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sengseng"s,                                                                         "ssz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sentani"s,                                                                          "set"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Senthang Chin"s,                                                                    "sez"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sentinel"s,                                                                         "std"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sepa (Indonesia)"s,                                                                 "spb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sepa (Papua New Guinea)"s,                                                          "spe"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sepik Iwam"s,                                                                       "iws"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sera"s,                                                                             "sry"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Serbian"s,                                                                          "srp"s,   "sr"s, ""s,    true );
  g_languages.emplace_back(u8"Serbo-Croatian"s,                                                                   "hbs"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sere"s,                                                                             "swf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Serer"s,                                                                            "srr"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Seri"s,                                                                             "sei"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Serili"s,                                                                           "sve"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Serrano"s,                                                                          "ser"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Serua"s,                                                                            "srw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Serudung Murut"s,                                                                   "srk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Serui-Laut"s,                                                                       "seu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Seselwa Creole French"s,                                                            "crs"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Seta"s,                                                                             "stf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Setaman"s,                                                                          "stm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Seti"s,                                                                             "sbi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Settla"s,                                                                           "sta"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Severn Ojibwa"s,                                                                    "ojs"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sewa Bay"s,                                                                         "sew"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Seze"s,                                                                             "sze"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sha"s,                                                                              "scw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Shabak"s,                                                                           "sdb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Shahmirzadi"s,                                                                      "srz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Shahrudi"s,                                                                         "shm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Shall-Zwall"s,                                                                      "sha"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Shama-Sambuga"s,                                                                    "sqa"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Shamang"s,                                                                          "xsh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Shambala"s,                                                                         "ksb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Shan"s,                                                                             "shn"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Shanenawa"s,                                                                        "swo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Shanga"s,                                                                           "sho"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sharanahua"s,                                                                       "mcd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Shark Bay"s,                                                                        "ssv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sharwa"s,                                                                           "swq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Shatt"s,                                                                            "shj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Shau"s,                                                                             "sqh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Shawnee"s,                                                                          "sjw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"She"s,                                                                              "shx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Shehri"s,                                                                           "shv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Shekhawati"s,                                                                       "swv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Shekkacho"s,                                                                        "moy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sheko"s,                                                                            "she"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Shelta"s,                                                                           "sth"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Shempire Senoufo"s,                                                                 "seb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Shendu"s,                                                                           "shl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sheni"s,                                                                            "scv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sherbro"s,                                                                          "bun"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sherdukpen"s,                                                                       "sdp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sherpa"s,                                                                           "xsr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sheshi Kham"s,                                                                      "kip"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Shi"s,                                                                              "shr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Shihhi Arabic"s,                                                                    "ssh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Shiki"s,                                                                            "gua"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Shilluk"s,                                                                          "shk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Shina"s,                                                                            "scl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Shipibo-Conibo"s,                                                                   "shp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Shixing"s,                                                                          "sxg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sholaga"s,                                                                          "sle"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Shom Peng"s,                                                                        "sii"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Shona"s,                                                                            "sna"s,   "sn"s, ""s,    true );
  g_languages.emplace_back(u8"Shoo-Minda-Nye"s,                                                                   "bcv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Shor"s,                                                                             "cjs"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Shoshoni"s,                                                                         "shh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Shua"s,                                                                             "shg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Shuar"s,                                                                            "jiv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Shubi"s,                                                                            "suj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Shughni"s,                                                                          "sgh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Shumashti"s,                                                                        "sts"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Shumcho"s,                                                                          "scu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Shuswap"s,                                                                          "shs"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Shuwa-Zamani"s,                                                                     "ksa"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Shwai"s,                                                                            "shw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Shwe Palaung"s,                                                                     "pll"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sialum"s,                                                                           "slw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Siamou"s,                                                                           "sif"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sian"s,                                                                             "spg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Siane"s,                                                                            "snp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Siang"s,                                                                            "sya"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Siar-Lak"s,                                                                         "sjr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Siawi"s,                                                                            "mmp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sibe"s,                                                                             "nco"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Siberian Tatar"s,                                                                   "sty"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sibu Melanau"s,                                                                     "sdx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sichuan Yi; Nuosu"s,                                                                "iii"s,   "ii"s, ""s,    true );
  g_languages.emplace_back(u8"Sicilian"s,                                                                         "scn"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Sidamo"s,                                                                           "sid"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Sie"s,                                                                              "erg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sierra Leone Sign Language"s,                                                       "sgx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sierra Negra Nahuatl"s,                                                             "nsu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sierra de Juárez Zapotec"s,                                                         "zaa"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sighu"s,                                                                            "sxe"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sign Languages"s,                                                                   "sgn"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Sihan"s,                                                                            "snr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sihuas Ancash Quechua"s,                                                            "qws"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sika"s,                                                                             "ski"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sikaiana"s,                                                                         "sky"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sikaritai"s,                                                                        "tty"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sikiana"s,                                                                          "sik"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sikkimese"s,                                                                        "sip"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Siksika"s,                                                                          "bla"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Sikule"s,                                                                           "skh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sila"s,                                                                             "slt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Silacayoapan Mixtec"s,                                                              "mks"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sileibi"s,                                                                          "sbq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Silesian"s,                                                                         "szl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Silimo"s,                                                                           "wul"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Siliput"s,                                                                          "mkc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Silopi"s,                                                                           "xsp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Silt'e"s,                                                                           "stv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Simaa"s,                                                                            "sie"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Simba"s,                                                                            "sbw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Simbali"s,                                                                          "smg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Simbari"s,                                                                          "smb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Simbo"s,                                                                            "sbb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Simeku"s,                                                                           "smz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Simeulue"s,                                                                         "smr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Simte"s,                                                                            "smt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sinagen"s,                                                                          "siu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sinasina"s,                                                                         "sst"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sinaugoro"s,                                                                        "snc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sindhi Bhil"s,                                                                      "sbn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sindhi"s,                                                                           "snd"s,   "sd"s, ""s,    true );
  g_languages.emplace_back(u8"Sindihui Mixtec"s,                                                                  "xts"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Singapore Sign Language"s,                                                          "sls"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Singpho"s,                                                                          "sgp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sinhala; Sinhalese"s,                                                               "sin"s,   "si"s, ""s,    true );
  g_languages.emplace_back(u8"Sinicahua Mixtec"s,                                                                 "xti"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sininkere"s,                                                                        "skq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sino-Tibetan languages"s,                                                           "sit"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Sinsauru"s,                                                                         "snz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sinte Romani"s,                                                                     "rmo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sinyar"s,                                                                           "sys"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sio"s,                                                                              "xsi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Siona"s,                                                                            "snn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Siouan languages"s,                                                                 "sio"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Sipacapense"s,                                                                      "qum"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sira"s,                                                                             "swj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Siri"s,                                                                             "sir"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Siriano"s,                                                                          "sri"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sirionó"s,                                                                          "srq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sirmauri"s,                                                                         "srx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Siroi"s,                                                                            "ssd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sissala"s,                                                                          "sld"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sissano"s,                                                                          "sso"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sivandi"s,                                                                          "siy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Siwai"s,                                                                            "siw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Siwi"s,                                                                             "siz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Siwu"s,                                                                             "akp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Siyin Chin"s,                                                                       "csy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Skagit"s,                                                                           "ska"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Skolt Sami"s,                                                                       "sms"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Skou"s,                                                                             "skv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Slave (Athapascan)"s,                                                               "den"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Slavic languages"s,                                                                 "sla"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Slavomolisano"s,                                                                    "svm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Slovak"s,                                                                           "slo"s,   "sk"s, "slk"s, true );
  g_languages.emplace_back(u8"Slovakian Sign Language"s,                                                          "svk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Slovenian"s,                                                                        "slv"s,   "sl"s, ""s,    true );
  g_languages.emplace_back(u8"Small Flowery Miao"s,                                                               "sfm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Smärky Kanum"s,                                                                     "kxq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Snohomish"s,                                                                        "sno"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"So (Democratic Republic of Congo)"s,                                                "soc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"So'a"s,                                                                             "ssq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sobei"s,                                                                            "sob"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sochiapam Chinantec"s,                                                              "cso"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Soga"s,                                                                             "xog"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sogdian"s,                                                                          "sog"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Soi"s,                                                                              "soj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sok"s,                                                                              "skk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sokoro"s,                                                                           "sok"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Soli"s,                                                                             "sby"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Solong"s,                                                                           "aaw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Solos"s,                                                                            "sol"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Somali"s,                                                                           "som"s,   "so"s, ""s,    true );
  g_languages.emplace_back(u8"Somba-Siawari"s,                                                                    "bmu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Somrai"s,                                                                           "sor"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Somyev"s,                                                                           "kgt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sonaga"s,                                                                           "ysg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sonde"s,                                                                            "shc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Songe"s,                                                                            "sop"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Songhai languages"s,                                                                "son"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Songlai Chin"s,                                                                     "csj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Songo"s,                                                                            "soo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Songomeno"s,                                                                        "soe"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Songoora"s,                                                                         "sod"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sonha"s,                                                                            "soi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sonia"s,                                                                            "siq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Soninke"s,                                                                          "snk"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Sonsorol"s,                                                                         "sov"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Soo"s,                                                                              "teu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sop"s,                                                                              "urw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Soqotri"s,                                                                          "sqt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sora"s,                                                                             "srb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sorbian languages"s,                                                                "wen"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Sori-Harengan"s,                                                                    "sbh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sorkhei"s,                                                                          "sqo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sorsogon Ayta"s,                                                                    "ays"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sos Kundi"s,                                                                        "sdk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sota Kanum"s,                                                                       "krz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sotho, Southern"s,                                                                  "sot"s,   "st"s, ""s,    true );
  g_languages.emplace_back(u8"Sou Nama"s,                                                                         "tlt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sou Upaa"s,                                                                         "wha"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sou"s,                                                                              "sqq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"South African Sign Language"s,                                                      "sfs"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"South American Indian (Other)"s,                                                    "sai"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"South Awyu"s,                                                                       "aws"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"South Azerbaijani"s,                                                                "azb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"South Bolivian Quechua"s,                                                           "quh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"South Central Banda"s,                                                              "lnl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"South Central Dinka"s,                                                              "dib"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"South Efate"s,                                                                      "erk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"South Fali"s,                                                                       "fal"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"South Giziga"s,                                                                     "giz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"South Lembata"s,                                                                    "lmf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"South Levantine Arabic"s,                                                           "ajp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"South Marquesan"s,                                                                  "mqm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"South Muyu"s,                                                                       "kts"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"South Nuaulu"s,                                                                     "nxl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"South Slavey"s,                                                                     "xsl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"South Tairora"s,                                                                    "omw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"South Ucayali Ashéninka"s,                                                          "cpy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"South Watut"s,                                                                      "mcy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"South West Bay"s,                                                                   "sns"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Southeast Ambrym"s,                                                                 "tvk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Southeast Babar"s,                                                                  "vbb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Southeast Ijo"s,                                                                    "ijs"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Southeast Pashai"s,                                                                 "psi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Southeastern Dinka"s,                                                               "dks"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Southeastern Ixtlán Zapotec"s,                                                      "zpd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Southeastern Kolami"s,                                                              "nit"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Southeastern Nochixtlán Mixtec"s,                                                   "mxy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Southeastern Pomo"s,                                                                "pom"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Southeastern Puebla Nahuatl"s,                                                      "npl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Southeastern Tarahumara"s,                                                          "tcu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Southeastern Tepehuan"s,                                                            "stp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Southern Alta"s,                                                                    "agy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Southern Altai"s,                                                                   "alt"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Southern Amami-Oshima"s,                                                            "ams"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Southern Aymara"s,                                                                  "ayc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Southern Bai"s,                                                                     "bfs"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Southern Balochi"s,                                                                 "bcc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Southern Betsimisaraka Malagasy"s,                                                  "bzc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Southern Binukidnon"s,                                                              "mtw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Southern Birifor"s,                                                                 "biv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Southern Bobo Madaré"s,                                                             "bwq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Southern Bontok"s,                                                                  "obk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Southern Carrier"s,                                                                 "caf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Southern Catanduanes Bikol"s,                                                       "bln"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Southern Conchucos Ancash Quechua"s,                                                "qxo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Southern Dagaare"s,                                                                 "dga"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Southern Dong"s,                                                                    "kmc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Southern East Cree"s,                                                               "crj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Southern Ghale"s,                                                                   "ghe"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Southern Grebo"s,                                                                   "grj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Southern Guiyang Hmong"s,                                                           "hmy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Southern Haida"s,                                                                   "hax"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Southern Hindko"s,                                                                  "hnd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Southern Kalinga"s,                                                                 "ksc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Southern Kisi"s,                                                                    "kss"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Southern Kiwai"s,                                                                   "kjd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Southern Kurdish"s,                                                                 "sdh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Southern Lolopo"s,                                                                  "ysp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Southern Luri"s,                                                                    "luz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Southern Ma'di"s,                                                                   "snm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Southern Mashan Hmong"s,                                                            "hma"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Southern Mnong"s,                                                                   "mnn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Southern Muji"s,                                                                    "ymc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Southern Nago"s,                                                                    "nqg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Southern Nambikuára"s,                                                              "nab"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Southern Ngbandi"s,                                                                 "nbw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Southern Nicobarese"s,                                                              "nik"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Southern Nisu"s,                                                                    "nsd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Southern Nuni"s,                                                                    "nnw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Southern One"s,                                                                     "osu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Southern Pashto"s,                                                                  "pbt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Southern Pastaza Quechua"s,                                                         "qup"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Southern Pomo"s,                                                                    "peq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Southern Puebla Mixtec"s,                                                           "mit"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Southern Puget Sound Salish"s,                                                      "slh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Southern Pumi"s,                                                                    "pmj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Southern Qiandong Miao"s,                                                           "hms"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Southern Qiang"s,                                                                   "qxs"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Southern Rengma Naga"s,                                                             "nre"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Southern Rincon Zapotec"s,                                                          "zsr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Southern Roglai"s,                                                                  "rgs"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Southern Sama"s,                                                                    "ssb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Southern Sami"s,                                                                    "sma"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Southern Samo"s,                                                                    "sbd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Southern Sierra Miwok"s,                                                            "skd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Southern Sorsoganon"s,                                                              "srv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Southern Subanen"s,                                                                 "laa"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Southern Thai"s,                                                                    "sou"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Southern Tidung"s,                                                                  "itd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Southern Tiwa"s,                                                                    "tix"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Southern Toussian"s,                                                                "wib"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Southern Tujia"s,                                                                   "tjs"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Southern Tutchone"s,                                                                "tce"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Southern Uzbek"s,                                                                   "uzs"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Southern Yamphu"s,                                                                  "lrr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Southern Yukaghir"s,                                                                "yux"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Southwest Gbaya"s,                                                                  "gso"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Southwest Palawano"s,                                                               "plv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Southwest Pashai"s,                                                                 "psh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Southwest Tanna"s,                                                                  "nwi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Southwestern Bontok"s,                                                              "vbk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Southwestern Dinka"s,                                                               "dik"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Southwestern Fars"s,                                                                "fay"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Southwestern Guiyang Hmong"s,                                                       "hmg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Southwestern Huishui Hmong"s,                                                       "hmh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Southwestern Nisu"s,                                                                "nsv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Southwestern Tarahumara"s,                                                          "twr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Southwestern Tepehuan"s,                                                            "tla"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Southwestern Tlaxiaco Mixtec"s,                                                     "meh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sowanda"s,                                                                          "sow"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Soyaltepec Mazatec"s,                                                               "vmp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Soyaltepec Mixtec"s,                                                                "vmq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Spanish Sign Language"s,                                                            "ssp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Spanish; Castilian"s,                                                               "spa"s,   "es"s, ""s,    true );
  g_languages.emplace_back(u8"Spiti Bhoti"s,                                                                      "spt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Spokane"s,                                                                          "spo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Squamish"s,                                                                         "squ"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sranan Tongo"s,                                                                     "srn"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Sri Lankan Creole Malay"s,                                                          "sci"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sri Lankan Sign Language"s,                                                         "sqs"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Standard Arabic"s,                                                                  "arb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Standard Estonian"s,                                                                "ekk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Standard Latvian"s,                                                                 "lvs"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Standard Malay"s,                                                                   "zsm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Standard Moroccan Tamazight"s,                                                      "zgh"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Stellingwerfs"s,                                                                    "stl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Stod Bhoti"s,                                                                       "sbu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Stoney"s,                                                                           "sto"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Straits Salish"s,                                                                   "str"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Suabo"s,                                                                            "szp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Suarmin"s,                                                                          "seo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Suau"s,                                                                             "swp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Suba"s,                                                                             "sxb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Suba-Simbiti"s,                                                                     "ssc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Subiya"s,                                                                           "sbs"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sudanese Arabic"s,                                                                  "apd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sudanese Creole Arabic"s,                                                           "pga"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sudest"s,                                                                           "tgo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Suena"s,                                                                            "sue"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Suga"s,                                                                             "sgi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Suganga"s,                                                                          "sug"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sugut Dusun"s,                                                                      "kzs"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sui"s,                                                                              "swi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Suki"s,                                                                             "sui"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Suku"s,                                                                             "sub"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sukuma"s,                                                                           "suk"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Sukur"s,                                                                            "syk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sukurum"s,                                                                          "zsu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sula"s,                                                                             "szn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sulka"s,                                                                            "sua"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sulod"s,                                                                            "srg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Suma"s,                                                                             "sqm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sumariup"s,                                                                         "siv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sumau"s,                                                                            "six"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sumbawa"s,                                                                          "smw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sumbwa"s,                                                                           "suw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sumerian"s,                                                                         "sux"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Sumi Naga"s,                                                                        "nsm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sumtu Chin"s,                                                                       "csv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sunam"s,                                                                            "ssk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sundanese"s,                                                                        "sun"s,   "su"s, ""s,    true );
  g_languages.emplace_back(u8"Sunwar"s,                                                                           "suz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Suoy"s,                                                                             "syo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Supyire Senoufo"s,                                                                  "spp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sur"s,                                                                              "tdl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Surbakhal"s,                                                                        "sbj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Surgujia"s,                                                                         "sgj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Suri"s,                                                                             "suq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Surigaonon"s,                                                                       "sgd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Surjapuri"s,                                                                        "sjp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sursurunga"s,                                                                       "sgz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Suruahá"s,                                                                          "swx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Surubu"s,                                                                           "sde"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Suruí Do Pará"s,                                                                    "mdz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Suruí"s,                                                                            "sru"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Susu"s,                                                                             "sus"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Susuami"s,                                                                          "ssu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Suundi"s,                                                                           "sdj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Suwawa"s,                                                                           "swu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Suyá"s,                                                                             "suy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Svan"s,                                                                             "sva"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Swabian"s,                                                                          "swg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Swahili (individual language)"s,                                                    "swh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Swahili"s,                                                                          "swa"s,   "sw"s, ""s,    true );
  g_languages.emplace_back(u8"Swampy Cree"s,                                                                      "csw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Swati"s,                                                                            "ssw"s,   "ss"s, ""s,    true );
  g_languages.emplace_back(u8"Swedish Sign Language"s,                                                            "swl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Swedish"s,                                                                          "swe"s,   "sv"s, ""s,    true );
  g_languages.emplace_back(u8"Swiss German; Alemannic; Alsatian"s,                                                "gsw"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Swiss-French Sign Language"s,                                                       "ssr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Swiss-German Sign Language"s,                                                       "sgg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Swiss-Italian Sign Language"s,                                                      "slf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Swo"s,                                                                              "sox"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Syenara Senoufo"s,                                                                  "shz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sylheti"s,                                                                          "syl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Syriac"s,                                                                           "syr"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Sáliba"s,                                                                           "slc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sãotomense"s,                                                                       "cri"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sìcìté Sénoufo"s,                                                                   "sep"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Sô"s,                                                                               "sss"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"T'en"s,                                                                             "tct"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ta'izzi-Adeni Arabic"s,                                                             "acq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Taabwa"s,                                                                           "tap"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tabaa Zapotec"s,                                                                    "zat"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tabaru"s,                                                                           "tby"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tabasco Chontal"s,                                                                  "chf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tabasco Zoque"s,                                                                    "zoq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tabassaran"s,                                                                       "tab"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tabla"s,                                                                            "tnm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tabo"s,                                                                             "knv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tabriak"s,                                                                          "tzx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tacahua Mixtec"s,                                                                   "xtt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tacana"s,                                                                           "tna"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tachawit"s,                                                                         "shy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tachelhit"s,                                                                        "shi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tachoni"s,                                                                          "lts"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tadaksahak"s,                                                                       "dsq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tadyawan"s,                                                                         "tdy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tae'"s,                                                                             "rob"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tafi"s,                                                                             "tcd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tagabawa"s,                                                                         "bgs"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tagakaulo"s,                                                                        "klg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tagal Murut"s,                                                                      "mvv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tagalog"s,                                                                          "tgl"s,   "tl"s, ""s,    true );
  g_languages.emplace_back(u8"Tagargrent"s,                                                                       "oua"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tagbanwa"s,                                                                         "tbw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tagbu"s,                                                                            "tbm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tagdal"s,                                                                           "tda"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tagin"s,                                                                            "tgj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tagish"s,                                                                           "tgx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tagoi"s,                                                                            "tag"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tagwana Senoufo"s,                                                                  "tgw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tahaggart Tamahaq"s,                                                                "thv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tahitian"s,                                                                         "tah"s,   "ty"s, ""s,    true );
  g_languages.emplace_back(u8"Tahltan"s,                                                                          "tht"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tai Daeng"s,                                                                        "tyr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tai Dam"s,                                                                          "blt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tai Do"s,                                                                           "tyj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tai Dón"s,                                                                          "twh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tai Hongjin"s,                                                                      "tiz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tai Laing"s,                                                                        "tjl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tai Loi"s,                                                                          "tlq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tai Long"s,                                                                         "thi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tai Nüa"s,                                                                          "tdd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tai Pao"s,                                                                          "tpo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tai Thanh"s,                                                                        "tmm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tai Ya"s,                                                                           "cuu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tai languages"s,                                                                    "tai"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Tai"s,                                                                              "taw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Taiap"s,                                                                            "gpn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Taikat"s,                                                                           "aos"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tainae"s,                                                                           "ago"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tairaha"s,                                                                          "bxa"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tairuma"s,                                                                          "uar"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Taita"s,                                                                            "dav"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Taiwan Sign Language"s,                                                             "tss"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Taje"s,                                                                             "pee"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tajik"s,                                                                            "tgk"s,   "tg"s, ""s,    true );
  g_languages.emplace_back(u8"Tajiki Arabic"s,                                                                    "abh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tajio"s,                                                                            "tdj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tajuasohn"s,                                                                        "tja"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Takestani"s,                                                                        "tks"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Takia"s,                                                                            "tbc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Takua"s,                                                                            "tkz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Takuu"s,                                                                            "nho"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Takwane"s,                                                                          "tke"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tal"s,                                                                              "tal"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tala"s,                                                                             "tak"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Talaud"s,                                                                           "tld"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Taliabu"s,                                                                          "tlv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Talieng"s,                                                                          "tdf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Talinga-Bwisi"s,                                                                    "tlj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Talise"s,                                                                           "tlr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Talodi"s,                                                                           "tlo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Taloki"s,                                                                           "tlk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Talondo'"s,                                                                         "tln"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Talu"s,                                                                             "yta"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Talysh"s,                                                                           "tly"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tama (Chad)"s,                                                                      "tma"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tamagario"s,                                                                        "tcg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Taman (Indonesia)"s,                                                                "tmn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tamashek"s,                                                                         "tmh"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Tamasheq"s,                                                                         "taq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tamazola Mixtec"s,                                                                  "vmx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tambas"s,                                                                           "tdk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tambotalo"s,                                                                        "tls"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tami"s,                                                                             "tmy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tamil"s,                                                                            "tam"s,   "ta"s, ""s,    true );
  g_languages.emplace_back(u8"Tamki"s,                                                                            "tax"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tamnim Citak"s,                                                                     "tml"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tampias Lobu"s,                                                                     "low"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tampuan"s,                                                                          "tpu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tampulma"s,                                                                         "tpm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tanacross"s,                                                                        "tcb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tanahmerah"s,                                                                       "tcm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tanaina"s,                                                                          "tfn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tanapag"s,                                                                          "tpv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tandaganon"s,                                                                       "tgn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tandia"s,                                                                           "tni"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tandroy-Mahafaly Malagasy"s,                                                        "tdx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tanema"s,                                                                           "tnx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tangale"s,                                                                          "tan"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tangchangya"s,                                                                      "tnv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tanggu"s,                                                                           "tgu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tangkhul Naga (India)"s,                                                            "nmf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tangkhul Naga (Myanmar)"s,                                                          "ntx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tangko"s,                                                                           "tkx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tanglang"s,                                                                         "ytl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tangoa"s,                                                                           "tgp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tanguat"s,                                                                          "tbs"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tanimbili"s,                                                                        "tbe"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tanimuca-Retuarã"s,                                                                 "tnc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tanjijili"s,                                                                        "uji"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tanosy Malagasy"s,                                                                  "txy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tanudan Kalinga"s,                                                                  "kml"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tanzanian Sign Language"s,                                                          "tza"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tapei"s,                                                                            "afp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tapieté"s,                                                                          "tpj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tapirapé"s,                                                                         "taf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tarao Naga"s,                                                                       "tro"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tareng"s,                                                                           "tgr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tariana"s,                                                                          "tae"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tarifit"s,                                                                          "rif"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tarjumo"s,                                                                          "txj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tarok"s,                                                                            "yer"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Taroko"s,                                                                           "trv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tarpia"s,                                                                           "tpf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Taruma"s,                                                                           "tdm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tasawaq"s,                                                                          "twq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tase Naga"s,                                                                        "nst"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tasmate"s,                                                                          "tmt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tataltepec Chatino"s,                                                               "cta"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tatana"s,                                                                           "txx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tatar"s,                                                                            "tat"s,   "tt"s, ""s,    true );
  g_languages.emplace_back(u8"Tatuyo"s,                                                                           "tav"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tauade"s,                                                                           "ttd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Taulil"s,                                                                           "tuh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Taungyo"s,                                                                          "tco"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Taupota"s,                                                                          "tpa"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tause"s,                                                                            "tad"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Taushiro"s,                                                                         "trr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tausug"s,                                                                           "tsg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tauya"s,                                                                            "tya"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Taveta"s,                                                                           "tvs"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tavoyan"s,                                                                          "tvn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tavringer Romani"s,                                                                 "rmu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tawala"s,                                                                           "tbo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tawallammat Tamajaq"s,                                                              "ttq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tawandê"s,                                                                          "xtw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tawang Monpa"s,                                                                     "twm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tawara"s,                                                                           "twl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Taworta"s,                                                                          "tbp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tawoyan"s,                                                                          "twy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tawr Chin"s,                                                                        "tcp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tay Khang"s,                                                                        "tnu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tayart Tamajeq"s,                                                                   "thz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tayo"s,                                                                             "cks"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Taznatit"s,                                                                         "grr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tboli"s,                                                                            "tbl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tchitchege"s,                                                                       "tck"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tchumbuli"s,                                                                        "bqa"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Te'un"s,                                                                            "tve"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Teanu"s,                                                                            "tkw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tebul Sign Language"s,                                                              "tsy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tebul Ure Dogon"s,                                                                  "dtu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tecpatlán Totonac"s,                                                                "tcw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tedaga"s,                                                                           "tuq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tedim Chin"s,                                                                       "ctd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tee"s,                                                                              "tkq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tefaro"s,                                                                           "tfo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tegali"s,                                                                           "ras"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tehit"s,                                                                            "kps"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tehuelche"s,                                                                        "teh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tejalapan Zapotec"s,                                                                "ztt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Teke-Ebo"s,                                                                         "ebo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Teke-Fuumu"s,                                                                       "ifm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Teke-Kukuya"s,                                                                      "kkw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Teke-Laali"s,                                                                       "lli"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Teke-Nzikou"s,                                                                      "nzu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Teke-Tege"s,                                                                        "teg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Teke-Tsaayi"s,                                                                      "tyi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Teke-Tyee"s,                                                                        "tyx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tektiteko"s,                                                                        "ttc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tela-Masbuar"s,                                                                     "tvm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Telefol"s,                                                                          "tlf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Telugu"s,                                                                           "tel"s,   "te"s, ""s,    true );
  g_languages.emplace_back(u8"Tem"s,                                                                              "kdh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Temacine Tamazight"s,                                                               "tjo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Temascaltepec Nahuatl"s,                                                            "nhv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tembo (Kitembo)"s,                                                                  "tbt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tembo (Motembo)"s,                                                                  "tmv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tembé"s,                                                                            "tqb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Teme"s,                                                                             "tdo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Temein"s,                                                                           "teq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Temi"s,                                                                             "soz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Temiar"s,                                                                           "tea"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Temoaya Otomi"s,                                                                    "ott"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Temoq"s,                                                                            "tmo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Temuan"s,                                                                           "tmw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ten'edn"s,                                                                          "tnz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tena Lowland Quichua"s,                                                             "quw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tenango Otomi"s,                                                                    "otn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tene Kan Dogon"s,                                                                   "dtk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tenggarong Kutai Malay"s,                                                           "vkt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tengger"s,                                                                          "tes"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tenharim"s,                                                                         "pah"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tenino"s,                                                                           "tqn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tenis"s,                                                                            "tns"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tennet"s,                                                                           "tex"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Teop"s,                                                                             "tio"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Teor"s,                                                                             "tev"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tepetotutla Chinantec"s,                                                            "cnt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tepeuxila Cuicatec"s,                                                               "cux"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tepinapa Chinantec"s,                                                               "cte"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tepo Krumen"s,                                                                      "ted"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ter Sami"s,                                                                         "sjt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tera"s,                                                                             "ttr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Terebu"s,                                                                           "trb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Terei"s,                                                                            "buo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tereno"s,                                                                           "ter"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Teressa"s,                                                                          "tef"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tereweng"s,                                                                         "twg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Teribe"s,                                                                           "tfr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Terik"s,                                                                            "tec"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Termanu"s,                                                                          "twu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ternate"s,                                                                          "tft"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tesaka Malagasy"s,                                                                  "tkg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tese"s,                                                                             "keg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Teso"s,                                                                             "teo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tetela"s,                                                                           "tll"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tetelcingo Nahuatl"s,                                                               "nhg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tetum"s,                                                                            "tet"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Tetun Dili"s,                                                                       "tdt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Teutila Cuicatec"s,                                                                 "cut"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tewa (Indonesia)"s,                                                                 "twe"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tewa (USA)"s,                                                                       "tew"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tewe"s,                                                                             "twx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Texcatepec Otomi"s,                                                                 "otx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Texistepec Popoluca"s,                                                              "poq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Texmelucan Zapotec"s,                                                               "zpz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tezoatlán Mixtec"s,                                                                 "mxb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tha"s,                                                                              "thy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Thachanadan"s,                                                                      "thn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Thado Chin"s,                                                                       "tcz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Thai Sign Language"s,                                                               "tsq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Thai Song"s,                                                                        "soa"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Thai"s,                                                                             "tha"s,   "th"s, ""s,    true );
  g_languages.emplace_back(u8"Thaiphum Chin"s,                                                                    "cth"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Thakali"s,                                                                          "ths"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Thangal Naga"s,                                                                     "nki"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Thangmi"s,                                                                          "thf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Thao"s,                                                                             "ssf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tharaka"s,                                                                          "thk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Thayore"s,                                                                          "thd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tho"s,                                                                              "tou"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Thompson"s,                                                                         "thp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Thopho"s,                                                                           "ytp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Thu Lao"s,                                                                          "tyl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Thudam"s,                                                                           "thw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Thulung"s,                                                                          "tdh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Thuri"s,                                                                            "thu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tiagbamrin Aizi"s,                                                                  "ahi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tiale"s,                                                                            "mnl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tiang"s,                                                                            "tbj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tibea"s,                                                                            "ngy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tibetan"s,                                                                          "tib"s,   "bo"s, "bod"s, true );
  g_languages.emplace_back(u8"Tichurong"s,                                                                        "tcn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ticuna"s,                                                                           "tca"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tidaá Mixtec"s,                                                                     "mtx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tidikelt Tamazight"s,                                                               "tia"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tidore"s,                                                                           "tvo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tiemacèwè Bozo"s,                                                                   "boo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tiene"s,                                                                            "tii"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tifal"s,                                                                            "tif"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tigak"s,                                                                            "tgc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tigon Mbembe"s,                                                                     "nza"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tigre"s,                                                                            "tig"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Tigrinya"s,                                                                         "tir"s,   "ti"s, ""s,    true );
  g_languages.emplace_back(u8"Tii"s,                                                                              "txq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tijaltepec Mixtec"s,                                                                "xtl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tikar"s,                                                                            "tik"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tikopia"s,                                                                          "tkp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tilapa Otomi"s,                                                                     "otl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tilquiapan Zapotec"s,                                                               "zts"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tilung"s,                                                                           "tij"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tima"s,                                                                             "tms"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Timbe"s,                                                                            "tim"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Timne"s,                                                                            "tem"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Timugon Murut"s,                                                                    "tih"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tinani"s,                                                                           "lbf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tindi"s,                                                                            "tin"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tinigua"s,                                                                          "tit"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tinoc Kallahan"s,                                                                   "tne"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tinputz"s,                                                                          "tpz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tippera"s,                                                                          "tpe"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tira"s,                                                                             "tic"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tirahi"s,                                                                           "tra"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tiranige Diga Dogon"s,                                                              "tde"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tiri"s,                                                                             "cir"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tiruray"s,                                                                          "tiy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tita"s,                                                                             "tdq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Titan"s,                                                                            "ttv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tiv"s,                                                                              "tiv"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Tiwa"s,                                                                             "lax"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tiwi"s,                                                                             "tiw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tiéfo"s,                                                                            "tiq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tiéyaxo Bozo"s,                                                                     "boz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tlachichilco Tepehua"s,                                                             "tpt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tlacoapa Me'phaa"s,                                                                 "tpl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tlacoatzintepec Chinantec"s,                                                        "ctl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tlacolulita Zapotec"s,                                                              "zpk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tlahuitoltepec Mixe"s,                                                              "mxp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tlamacazapa Nahuatl"s,                                                              "nuz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tlazoyaltepec Mixtec"s,                                                             "mqh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tlingit"s,                                                                          "tli"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"To"s,                                                                               "toz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"To'abaita"s,                                                                        "mlu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Toaripi"s,                                                                          "tqo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Toba"s,                                                                             "tob"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Toba-Maskoy"s,                                                                      "tmf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tobagonian Creole English"s,                                                        "tgh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tobanga"s,                                                                          "tng"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tobati"s,                                                                           "tti"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tobelo"s,                                                                           "tlb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tobian"s,                                                                           "tox"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tobilung"s,                                                                         "tgb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tobo"s,                                                                             "tbv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tocantins Asurini"s,                                                                "asu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tocho"s,                                                                            "taz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Toda"s,                                                                             "tcx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Todrah"s,                                                                           "tdr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tofanma"s,                                                                          "tlg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tofin Gbe"s,                                                                        "tfi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Togbo-Vara Banda"s,                                                                 "tor"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tohono O'odham"s,                                                                   "ood"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tojolabal"s,                                                                        "toj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tok Pisin"s,                                                                        "tpi"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Tokano"s,                                                                           "zuh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tokelau"s,                                                                          "tkl"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Toku-No-Shima"s,                                                                    "tkn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tol"s,                                                                              "jic"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tolaki"s,                                                                           "lbw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tolomako"s,                                                                         "tlm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tolowa"s,                                                                           "tol"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Toma"s,                                                                             "tod"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tomadino"s,                                                                         "tdi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tombelala"s,                                                                        "ttp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tombonuo"s,                                                                         "txa"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tombulu"s,                                                                          "tom"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tomini"s,                                                                           "txm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tommo So Dogon"s,                                                                   "dto"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tomo Kan Dogon"s,                                                                   "dtm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tomoip"s,                                                                           "tqp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tondano"s,                                                                          "tdn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tondi Songway Kiini"s,                                                              "tst"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tonga (Nyasa)"s,                                                                    "tog"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Tonga (Tonga Islands)"s,                                                            "ton"s,   "to"s, ""s,    true );
  g_languages.emplace_back(u8"Tonga (Zambia)"s,                                                                   "toi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tongwe"s,                                                                           "tny"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tonsawang"s,                                                                        "tnw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tonsea"s,                                                                           "txs"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tontemboan"s,                                                                       "tnt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tooro"s,                                                                            "ttj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Topoiyo"s,                                                                          "toy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Toposa"s,                                                                           "toq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Toraja-Sa'dan"s,                                                                    "sda"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Toram"s,                                                                            "trj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Torau"s,                                                                            "ttu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tornedalen Finnish"s,                                                               "fit"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Toro So Dogon"s,                                                                    "dts"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Toro Tegu Dogon"s,                                                                  "dtt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Toro"s,                                                                             "tdv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Toromono"s,                                                                         "tno"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Torres Strait Creole"s,                                                             "tcs"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Torricelli"s,                                                                       "tei"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Torwali"s,                                                                          "trw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tosk Albanian"s,                                                                    "als"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Totela"s,                                                                           "ttl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Toto"s,                                                                             "txo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Totoli"s,                                                                           "txe"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Totomachapan Zapotec"s,                                                             "zph"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Totontepec Mixe"s,                                                                  "mto"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Totoro"s,                                                                           "ttk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Touo"s,                                                                             "tqu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Toura (Côte d'Ivoire)"s,                                                            "neb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Toura (Papua New Guinea)"s,                                                         "don"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Towei"s,                                                                            "ttn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Traveller Norwegian"s,                                                              "rmg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Traveller Scottish"s,                                                               "trl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tregami"s,                                                                          "trm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Trieng"s,                                                                           "stg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Trimuris"s,                                                                         "tip"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tring"s,                                                                            "tgq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tringgus-Sembaan Bidayuh"s,                                                         "trx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Trinidad and Tobago Sign Language"s,                                                "lst"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Trinidadian Creole English"s,                                                       "trf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Trinitario"s,                                                                       "trn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Trió"s,                                                                             "tri"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Trumai"s,                                                                           "tpy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ts'ün-Lao"s,                                                                        "tsl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tsaangi"s,                                                                          "tsa"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tsakhur"s,                                                                          "tkr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tsakonian"s,                                                                        "tsd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tsakwambo"s,                                                                        "kvz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tsamai"s,                                                                           "tsb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tsat"s,                                                                             "huq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tseku"s,                                                                            "tsk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tshangla"s,                                                                         "tsj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tsikimba"s,                                                                         "kdl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tsimané"s,                                                                          "cas"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tsimihety Malagasy"s,                                                               "xmw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tsimshian"s,                                                                        "tsi"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Tsishingini"s,                                                                      "tsw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tso"s,                                                                              "ldp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tsoa"s,                                                                             "hio"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tsogo"s,                                                                            "tsv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tsonga"s,                                                                           "tso"s,   "ts"s, ""s,    true );
  g_languages.emplace_back(u8"Tsotso"s,                                                                           "lto"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tsou"s,                                                                             "tsu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tsucuba"s,                                                                          "cbq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tsum"s,                                                                             "ttz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tsuvadi"s,                                                                          "tvd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tsuvan"s,                                                                           "tsh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tswa"s,                                                                             "tsc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tswana"s,                                                                           "tsn"s,   "tn"s, ""s,    true );
  g_languages.emplace_back(u8"Tswapong"s,                                                                         "two"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tu"s,                                                                               "mjg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tuamotuan"s,                                                                        "pmt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tucano"s,                                                                           "tuo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tugen"s,                                                                            "tuy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tugun"s,                                                                            "tzn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tugutil"s,                                                                          "tuj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tukang Besi North"s,                                                                "khc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tukang Besi South"s,                                                                "bhq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tuki"s,                                                                             "bag"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tukpa"s,                                                                            "tpq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tukudede"s,                                                                         "tkd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tula"s,                                                                             "tul"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tulehu"s,                                                                           "tlu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tulishi"s,                                                                          "tey"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tulu"s,                                                                             "tcy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tulu-Bohuai"s,                                                                      "rak"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tuma-Irumu"s,                                                                       "iou"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tumak"s,                                                                            "tmc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tumari Kanuri"s,                                                                    "krt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tumbuka"s,                                                                          "tum"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Tumi"s,                                                                             "kku"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tumleo"s,                                                                           "tmq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tumtum"s,                                                                           "tbr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tumulung Sisaala"s,                                                                 "sil"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tumzabt"s,                                                                          "mzb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tundra Enets"s,                                                                     "enh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tunen"s,                                                                            "tvu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tungag"s,                                                                           "lcm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tunggare"s,                                                                         "trt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tunia"s,                                                                            "tug"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tunisian Arabic"s,                                                                  "aeb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tunisian Sign Language"s,                                                           "tse"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tunjung"s,                                                                          "tjg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tunni"s,                                                                            "tqq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tunzu"s,                                                                            "dza"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tuotomb"s,                                                                          "ttf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tuparí"s,                                                                           "tpr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tupi languages"s,                                                                   "tup"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Tupuri"s,                                                                           "tui"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Turaka"s,                                                                           "trh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Turi"s,                                                                             "trd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Turka"s,                                                                            "tuz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Turkana"s,                                                                          "tuv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Turkic Khalaj"s,                                                                    "klj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Turkish Sign Language"s,                                                            "tsm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Turkish"s,                                                                          "tur"s,   "tr"s, ""s,    true );
  g_languages.emplace_back(u8"Turkish, Ottoman (1500-1928)"s,                                                     "ota"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Turkmen"s,                                                                          "tuk"s,   "tk"s, ""s,    true );
  g_languages.emplace_back(u8"Turks And Caicos Creole English"s,                                                  "tch"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Turoyo"s,                                                                           "tru"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Turumsa"s,                                                                          "tqm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tuscarora"s,                                                                        "tus"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tutong"s,                                                                           "ttg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tutsa Naga"s,                                                                       "tvt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tutuba"s,                                                                           "tmi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tututepec Mixtec"s,                                                                 "mtu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tututni"s,                                                                          "tuu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tuvalu"s,                                                                           "tvl"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Tuvinian"s,                                                                         "tyv"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Tuwali Ifugao"s,                                                                    "ifk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tuwari"s,                                                                           "tww"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tuwuli"s,                                                                           "bov"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tuyuca"s,                                                                           "tue"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Twendi"s,                                                                           "twn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Twents"s,                                                                           "twd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Twi"s,                                                                              "twi"s,   "tw"s, ""s,    true );
  g_languages.emplace_back(u8"Tyap"s,                                                                             "kcg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tyaraity"s,                                                                         "woa"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tz'utujil"s,                                                                        "tzj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tzeltal"s,                                                                          "tzh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tzotzil"s,                                                                          "tzo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tày Sa Pa"s,                                                                        "tys"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tày Tac"s,                                                                          "tyt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tày"s,                                                                              "tyz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Téén"s,                                                                             "lor"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Tübatulabal"s,                                                                      "tub"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"U"s,                                                                                "uuu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Uab Meto"s,                                                                         "aoz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Uare"s,                                                                             "ksj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ubaghara"s,                                                                         "byc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ubang"s,                                                                            "uba"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ubi"s,                                                                              "ubi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ubir"s,                                                                             "ubr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ucayali-Yurúa Ashéninka"s,                                                          "cpb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Uda"s,                                                                              "uda"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Udi"s,                                                                              "udi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Udihe"s,                                                                            "ude"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Udmurt"s,                                                                           "udm"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Uduk"s,                                                                             "udu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ufim"s,                                                                             "ufi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ugandan Sign Language"s,                                                            "ugn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ugaritic"s,                                                                         "uga"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Ughele"s,                                                                           "uge"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ugong"s,                                                                            "ugo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Uhami"s,                                                                            "uha"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Uighur; Uyghur"s,                                                                   "uig"s,   "ug"s, ""s,    true );
  g_languages.emplace_back(u8"Uisai"s,                                                                            "uis"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ujir"s,                                                                             "udj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ukaan"s,                                                                            "kcf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ukhwejo"s,                                                                          "ukh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ukit"s,                                                                             "umi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ukpe-Bayobiri"s,                                                                    "ukp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ukpet-Ehom"s,                                                                       "akd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ukrainian Sign Language"s,                                                          "ukl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ukrainian"s,                                                                        "ukr"s,   "uk"s, ""s,    true );
  g_languages.emplace_back(u8"Ukue"s,                                                                             "uku"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ukuriguma"s,                                                                        "ukg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ukwa"s,                                                                             "ukq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ukwuani-Aboh-Ndoni"s,                                                               "ukw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ulau-Suain"s,                                                                       "svb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ulch"s,                                                                             "ulc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ulithian"s,                                                                         "uli"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ullatan"s,                                                                          "ull"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ulukwumi"s,                                                                         "ulb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ulumanda'"s,                                                                        "ulm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ulwa"s,                                                                             "ulw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Uma"s,                                                                              "ppk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Uma' Lasan"s,                                                                       "xky"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Uma' Lung"s,                                                                        "ulu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Umanakaina"s,                                                                       "gdn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Umatilla"s,                                                                         "uma"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Umbu-Ungu"s,                                                                        "ubu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Umbundu"s,                                                                          "umb"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Ume Sami"s,                                                                         "sju"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Umeda"s,                                                                            "upi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Umiray Dumaget Agta"s,                                                              "due"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Umon"s,                                                                             "umm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Umpila"s,                                                                           "ump"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Una"s,                                                                              "mtg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Uncoded languages"s,                                                                "mis"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Unde Kaili"s,                                                                       "unz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Undetermined"s,                                                                     "und"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Uneapa"s,                                                                           "bbn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Uneme"s,                                                                            "une"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Unggumi"s,                                                                          "xgu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Unserdeutsch"s,                                                                     "uln"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Unua"s,                                                                             "onu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Unubahe"s,                                                                          "unu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Upper Grand Valley Dani"s,                                                          "dna"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Upper Guinea Crioulo"s,                                                             "pov"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Upper Kinabatangan"s,                                                               "dmg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Upper Kuskokwim"s,                                                                  "kuu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Upper Necaxa Totonac"s,                                                             "tku"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Upper Saxon"s,                                                                      "sxu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Upper Sorbian"s,                                                                    "hsb"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Upper Ta'oih"s,                                                                     "tth"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Upper Tanana"s,                                                                     "tau"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Upper Taromi"s,                                                                     "tov"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ura (Papua New Guinea)"s,                                                           "uro"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ura (Vanuatu)"s,                                                                    "uur"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Urak Lawoi'"s,                                                                      "urk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Urali"s,                                                                            "url"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Urapmin"s,                                                                          "urm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Urarina"s,                                                                          "ura"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Urat"s,                                                                             "urt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Urdu"s,                                                                             "urd"s,   "ur"s, ""s,    true );
  g_languages.emplace_back(u8"Urhobo"s,                                                                           "urh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Uri"s,                                                                              "uvh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Urigina"s,                                                                          "urg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Urim"s,                                                                             "uri"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Urimo"s,                                                                            "urx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Uripiv-Wala-Rano-Atchin"s,                                                          "upv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Uru"s,                                                                              "ure"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Uru-Eu-Wau-Wau"s,                                                                   "urz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Uru-Pa-In"s,                                                                        "urp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Uruangnirin"s,                                                                      "urn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Urubú-Kaapor Sign Language"s,                                                       "uks"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Urubú-Kaapor"s,                                                                     "urb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Uruguayan Sign Language"s,                                                          "ugy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Urum"s,                                                                             "uum"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Usaghade"s,                                                                         "usk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Usan"s,                                                                             "wnu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Usarufa"s,                                                                          "usa"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ushojo"s,                                                                           "ush"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Usila Chinantec"s,                                                                  "cuc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Usku"s,                                                                             "ulf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Uspanteco"s,                                                                        "usp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Usui"s,                                                                             "usi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Utarmbung"s,                                                                        "omo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Ute-Southern Paiute"s,                                                              "ute"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Utu"s,                                                                              "utu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Uvbie"s,                                                                            "evh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Uya"s,                                                                              "usu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Uyajitaya"s,                                                                        "duk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Uzbek"s,                                                                            "uzb"s,   "uz"s, ""s,    true );
  g_languages.emplace_back(u8"Uzbeki Arabic"s,                                                                    "auz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Uzekwe"s,                                                                           "eze"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Vaagri Booli"s,                                                                     "vaa"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Vafsi"s,                                                                            "vaf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Vaghat-Ya-Bijim-Legeri"s,                                                           "bij"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Vaghri"s,                                                                           "vgr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Vaghua"s,                                                                           "tva"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Vagla"s,                                                                            "vag"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Vai"s,                                                                              "vai"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Vaiphei"s,                                                                          "vap"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Vale"s,                                                                             "vae"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Valencian Sign Language"s,                                                          "vsv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Valle Nacional Chinantec"s,                                                         "cvn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Valman"s,                                                                           "van"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Valpei"s,                                                                           "vlp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Vamale"s,                                                                           "mkt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Vame"s,                                                                             "mlr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Vangunu"s,                                                                          "mpr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Vanimo"s,                                                                           "vam"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Vano"s,                                                                             "vnk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Vanuma"s,                                                                           "vau"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Vao"s,                                                                              "vao"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Varhadi-Nagpuri"s,                                                                  "vah"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Varisi"s,                                                                           "vrs"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Varli"s,                                                                            "vav"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Vasavi"s,                                                                           "vas"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Veddah"s,                                                                           "ved"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Vehes"s,                                                                            "val"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Veluws"s,                                                                           "vel"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Vemgo-Mabas"s,                                                                      "vem"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Venda"s,                                                                            "ven"s,   "ve"s, ""s,    true );
  g_languages.emplace_back(u8"Venetian"s,                                                                         "vec"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Venezuelan Sign Language"s,                                                         "vsl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Vengo"s,                                                                            "bav"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Veps"s,                                                                             "vep"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Vera'a"s,                                                                           "vra"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Vidunda"s,                                                                          "vid"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Viemo"s,                                                                            "vig"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Vietnamese"s,                                                                       "vie"s,   "vi"s, ""s,    true );
  g_languages.emplace_back(u8"Vilela"s,                                                                           "vil"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Vili"s,                                                                             "vif"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Vincentian Creole English"s,                                                        "svc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Vinmavis"s,                                                                         "vnm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Vinza"s,                                                                            "vin"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Virgin Islands Creole English"s,                                                    "vic"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Vishavan"s,                                                                         "vis"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Viti"s,                                                                             "vit"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Vitou"s,                                                                            "vto"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Vitu"s,                                                                             "wiv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Vlaams"s,                                                                           "vls"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Vlaamse Gebarentaal"s,                                                              "vgt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Vlax Romani"s,                                                                      "rmy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Volapük"s,                                                                          "vol"s,   "vo"s, ""s,    true );
  g_languages.emplace_back(u8"Vono"s,                                                                             "kch"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Voro"s,                                                                             "vor"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Votic"s,                                                                            "vot"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Vumbu"s,                                                                            "vum"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Vunapu"s,                                                                           "vnp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Vunjo"s,                                                                            "vun"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Vurës"s,                                                                            "msn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Vute"s,                                                                             "vut"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Vwanji"s,                                                                           "wbi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Võro"s,                                                                             "vro"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Wa"s,                                                                               "wbm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Wa'ema"s,                                                                           "wag"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Waama"s,                                                                            "wwa"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Waata"s,                                                                            "ssn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Wab"s,                                                                              "wab"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Wabo"s,                                                                             "wbb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Waboda"s,                                                                           "kmx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Waci Gbe"s,                                                                         "wci"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Wadaginam"s,                                                                        "wdg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Waddar"s,                                                                           "wbq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Wadiyara Koli"s,                                                                    "kxp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Wadjiginy"s,                                                                        "wdj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Wae Rana"s,                                                                         "wrx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Waffa"s,                                                                            "waj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Wagawaga"s,                                                                         "wgb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Wagdi"s,                                                                            "wbr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Wageman"s,                                                                          "waq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Wagi"s,                                                                             "fad"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Wahau Kayan"s,                                                                      "whu"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Wahau Kenyah"s,                                                                     "whk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Wahgi"s,                                                                            "wgi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Waigali"s,                                                                          "wbk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Waigeo"s,                                                                           "wgo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Wailapa"s,                                                                          "wlr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Waima"s,                                                                            "rro"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Waima'a"s,                                                                          "wmh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Waimaha"s,                                                                          "bao"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Waimiri-Atroari"s,                                                                  "atr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Waioli"s,                                                                           "wli"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Waiwai"s,                                                                           "waw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Waja"s,                                                                             "wja"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Wajarri"s,                                                                          "wbv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Waka"s,                                                                             "wav"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Wakashan languages"s,                                                               "wak"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Wakde"s,                                                                            "wkd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Wakhi"s,                                                                            "wbl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Wala"s,                                                                             "lgl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Walak"s,                                                                            "wlw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Walamo"s,                                                                           "wal"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Wali (Ghana)"s,                                                                     "wlx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Wali (Sudan)"s,                                                                     "wll"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Walio"s,                                                                            "wla"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Walla Walla"s,                                                                      "waa"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Wallisian"s,                                                                        "wls"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Walloon"s,                                                                          "wln"s,   "wa"s, ""s,    true );
  g_languages.emplace_back(u8"Walmajarri"s,                                                                       "wmt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Walser"s,                                                                           "wae"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Walungge"s,                                                                         "ola"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Wamas"s,                                                                            "wmc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Wambaya"s,                                                                          "wmb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Wambon"s,                                                                           "wms"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Wambule"s,                                                                          "wme"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Wamey"s,                                                                            "cou"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Wampar"s,                                                                           "lbq"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Wampur"s,                                                                           "waz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Wan"s,                                                                              "wan"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Wanambre"s,                                                                         "wnb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Wanap"s,                                                                            "wnp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Wancho Naga"s,                                                                      "nnp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Wanda"s,                                                                            "wbh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Wandala"s,                                                                          "mfi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Wandamen"s,                                                                         "wad"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Wandji"s,                                                                           "wdd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Waneci"s,                                                                           "wne"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Wanga"s,                                                                            "lwg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Wangaaybuwan-Ngiyambaa"s,                                                           "wyb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Wanggom"s,                                                                          "wng"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Wanman"s,                                                                           "wbt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Wannu"s,                                                                            "jub"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Wano"s,                                                                             "wno"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Wantoat"s,                                                                          "wnc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Wanukaka"s,                                                                         "wnk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Wanyi"s,                                                                            "wny"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Wané"s,                                                                             "hwa"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Waorani"s,                                                                          "auc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Wapan"s,                                                                            "juk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Wapishana"s,                                                                        "wap"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"War-Jaintia"s,                                                                      "aml"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Wara"s,                                                                             "wbf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Warao"s,                                                                            "wba"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Warapu"s,                                                                           "wra"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Waray"s,                                                                            "war"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Wardaman"s,                                                                         "wrr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Warduji"s,                                                                          "wrd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Warembori"s,                                                                        "wsa"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Wares"s,                                                                            "wai"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Waris"s,                                                                            "wrs"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Waritai"s,                                                                          "wbe"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Warji"s,                                                                            "wji"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Warkay-Bipim"s,                                                                     "bgv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Warlmanpa"s,                                                                        "wrl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Warlpiri"s,                                                                         "wbp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Warnang"s,                                                                          "wrn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Waropen"s,                                                                          "wrp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Warrgamay"s,                                                                        "wgy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Waru"s,                                                                             "wru"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Warumungu"s,                                                                        "wrm"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Waruna"s,                                                                           "wrv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Warwar Feni"s,                                                                      "hrw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Wasa"s,                                                                             "wss"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Wasco-Wishram"s,                                                                    "wac"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Wasembo"s,                                                                          "gsp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Washo"s,                                                                            "was"s,   ""s,   ""s,    true );
  g_languages.emplace_back(u8"Waskia"s,                                                                           "wsk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Watakataui"s,                                                                       "wtk"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Watam"s,                                                                            "wax"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Watiwa"s,                                                                           "wtf"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Watubela"s,                                                                         "wah"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Waube"s,                                                                            "kop"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Waurá"s,                                                                            "wau"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Wauyai"s,                                                                           "wuy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Wawa"s,                                                                             "www"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Wawonii"s,                                                                          "wow"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Waxianghua"s,                                                                       "wxa"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Wayampi"s,                                                                          "oym"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Wayana"s,                                                                           "way"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Wayanad Chetti"s,                                                                   "ctt"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Wayoró"s,                                                                           "wyr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Wayu"s,                                                                             "vay"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Wayuu"s,                                                                            "guc"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Wedau"s,                                                                            "wed"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Weh"s,                                                                              "weh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Wejewa"s,                                                                           "wew"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Weliki"s,                                                                           "klh"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Welsh Romani"s,                                                                     "rmw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Welsh"s,                                                                            "wel"s,   "cy"s, "cym"s, true );
  g_languages.emplace_back(u8"Wemale"s,                                                                           "weo"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Weme Gbe"s,                                                                         "wem"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Wergaia"s,                                                                          "weg"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Weri"s,                                                                             "wer"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Wersing"s,                                                                          "kvw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"West Albay Bikol"s,                                                                 "fbl"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"West Ambae"s,                                                                       "nnd"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"West Berawan"s,                                                                     "zbw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"West Central Banda"s,                                                               "bbp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"West Central Oromo"s,                                                               "gaz"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"West Coast Bajau"s,                                                                 "bdr"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"West Damar"s,                                                                       "drn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"West Goodenough"s,                                                                  "ddi"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"West Kewa"s,                                                                        "kew"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"West Lembata"s,                                                                     "lmj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"West Makian"s,                                                                      "mqs"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"West Masela"s,                                                                      "mss"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"West Tarangan"s,                                                                    "txn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"West Uvean"s,                                                                       "uve"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"West Yugur"s,                                                                       "ybe"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"West-Central Limba"s,                                                               "lia"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Western Abnaki"s,                                                                   "abe"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Western Apache"s,                                                                   "apw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Western Arrarnta"s,                                                                 "are"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Western Balochi"s,                                                                  "bgn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Western Bolivian Guaraní"s,                                                         "gnw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Western Bru"s,                                                                      "brv"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Western Bukidnon Manobo"s,                                                          "mbb"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Western Cham"s,                                                                     "cja"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Western Dani"s,                                                                     "dnw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Western Durango Nahuatl"s,                                                          "azn"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Western Fijian"s,                                                                   "wyy"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Western Frisian"s,                                                                  "fry"s,   "fy"s, ""s,    true );
  g_languages.emplace_back(u8"Western Highland Chatino"s,                                                         "ctp"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Western Highland Purepecha"s,                                                       "pua"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Western Huasteca Nahuatl"s,                                                         "nhw"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Western Juxtlahuaca Mixtec"s,                                                       "jmx"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Western Kanjobal"s,                                                                 "knj"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Western Karaboro"s,                                                                 "kza"s,   ""s,   ""s,    false);
  g_languages.emplace_back(u8"Western Katu"s,                                                     