#ifndef MTX_MKVTOOLNIX_GUI_WATCH_JOBS_TOOL_H
#define MTX_MKVTOOLNIX_GUI_WATCH_JOBS_TOOL_H

#include "common/common_pch.h"

#include "mkvtoolnix-gui/main_window/tool_base.h"

class QMenu;

namespace mtx { namespace gui {

namespace Jobs {
class Job;
}

namespace WatchJobs {

namespace Ui {
class Tool;
}

class Tab;

class Tool : public ToolBase {
  Q_OBJECT;

protected:
  // UI stuff:
  std::unique_ptr<Ui::Tool> ui;
  Tab *m_currentJobTab{};
  QMenu *m_jobOutputMenu;

public:
  explicit Tool(QWidget *parent, QMenu *jobOutputMenu);
  ~Tool();

  Tab *currentJobTab();
  Tab *currentTab();

  void viewOutput(mtx::gui::Jobs::Job &job);

  int tabIndexForJobID(uint64_t id) const;

  virtual void retranslateUi() override;

public slots:
  virtual void toolShown() override;
  virtual void closeTab(int idx);
  virtual void closeCurrentTab();
  virtual void saveCurrentTabOutput();
  virtual void enableMenuActions();
  virtual void setupTabPositions();
};

}}}

#endif // MTX_MKVTOOLNIX_GUI_WATCH_JOBS_TOOL_H
