# Copyright 2006 Soeren Boll Overgaard <boll@fork.dk>
#
# This file is part of mlmmjadmd.
#
# mlmmjadmd is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# mlmmjadmd is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with mlmmjadmd; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import sys;
import logging;
from mlmmjadm.util import *;
import ConfigParser;


class Configuration:
    
    # These variables should be updated as class variables 
    # rather than instance variables. That way they are 
    # accessible by all instances of the class
    #
    # Mlmmj configuration parameters
    __mlmmjBinPrefix = "/usr/bin/";
    __mlmmjUnsub = __mlmmjBinPrefix+"/mlmmj-unsub";
    __mlmmjSub = __mlmmjBinPrefix+"/mlmmj-sub";
    __mlmmjList = __mlmmjBinPrefix+"/mlmmj-list";
    __mlmmjListBase = "/var/spool/mlmmj/";
    __mlmmjListTextsDir = "/usr/share/mlmmj/text.skel/";
    # The file containing users with access to mlmmjadmd
    __usersFile = "/var/spool/mlmmj/users";
    # The IP address to bind to
    __bindAddress = "127.0.0.1";
    # The TCP port to bind to
    __bindPort = 10000;
    # Should debugging output be generated
    __debug = False;
    # Where to write log entries
    __logFile = None;
    # Where to write the pid file
    __pidFile = "/var/run/mlmmjadmd.pid";
    # Where to find the configuration file
    __configFile = "/etc/mlmmjadmd/config";
    # Switch to run as this user
    __user = None;
    # Switch to run with this group as owner
    __group = None;

    
    def load(self, newConfigFile="/etc/mlmmjadmd/config"):
        self.setConfigFile(newConfigFile);
    
        if fileExists(Configuration.__configFile):
            fh = open(Configuration.__configFile, "r");
            parser = ConfigParser.SafeConfigParser();
            parser.readfp(fh);
            fh.close();
            if parser.has_section("Conf"):
                try:
                    if parser.get("Conf", "BinPrefix"):
                        self.setMlmmjBinPrefix(parser.get("Conf", "BinPrefix"));
                        logging.debug("Loaded mlmmjBinPrefix="+self.getMlmmjBinPrefix()+" from configuration file");
                except ConfigParser.NoOptionError, e:
                    logging.warn("Skipping option BinPrefix");
                
                try:
                    if parser.get("Conf", "ListBase"):
                        self.setListBase(parser.get("Conf", "ListBase"));
                        logging.debug("Loaded mlmmjListBase="+self.getListBase()+" from configuration file");
                except ConfigParser.NoOptionError, e:
                    logging.warn("Skipping option ListBase");
                
                try:
                    if parser.get("Conf", "UsersFile"):
                        self.setUsersFile(parser.get("Conf", "UsersFile"));
                        logging.debug("Loaded mlmmjAdmUsers="+self.getUsersFile()+" from configuration file");
                except ConfigParser.NoOptionError, e:
                    logging.warn("Skipping option UsersFile");
                        
                try:
                    if parser.get("Conf", "BindAddress"):
                        self.setBindAddress(parser.get("Conf", "BindAddress"));
                        logging.debug("Loaded mlmmjAdmBindAddress="+self.getBindAddress()+" from configuration file");
                except ConfigParser.NoOptionError, e:
                    logging.warn("Skipping option BindAddress");
                
                try:
                    if parser.get("Conf", "BindPort"):
                        self.setBindPort(parser.getint("Conf", "BindPort"));
                        logging.debug("Loaded mlmmjAdmBindPort="+str(self.getBindPort())+" from configuration file");
                except ConfigParser.NoOptionError, e:
                    logging.warn("Skipping option BindPort");
                
                try:
                    if parser.get("Conf", "LogFile"):
                        self.setLogFile(parser.get("Conf", "LogFile"));
                        logging.debug("Loaded mlmmjAdmLogFile="+self.getLogFile()+" from configuration file");
                except ConfigParser.NoOptionError, e:
                    logging.warn("Skipping option LogFile");
                        
                try:
                    if parser.get("Conf", "PidFile"):
                        self.setPidFile(parser.get("Conf", "PidFile"));
                        logging.debug("Loaded mlmmjAdmPidFile="+self.getPidFile()+" from configuration file");            
                except ConfigParser.NoOptionError, e:
                    logging.warn("Skipping option PidFile");
                    
                try:
                    if parser.get("Conf", "User"):
                        self.setUser(parser.get("Conf", "User"));
                        logging.debug("Loaded mlmmjAdmUser="+self.getUser()+" from configuration file");
                except ConfigParser.NoOptionError, e:
                    logging.warn("Skipping option User");
                    
                try:
                    if parser.get("Conf", "Group"):
                        self.setGroup(parser.get("Conf", "Group"));
                        logging.debug("Loaded mlmmjAdmGroup="+self.getGroup()+" from configuration file");
                except ConfigParser.NoOptionError, e:
                    logging.warn("Skipping option Group");
                    
                try:
                    if parser.get("Conf", "ListTextsDir"):
                        self.setMlmmjListTextsDir(parser.get("Conf", "ListTextsDir"));
                        logging.debug("Loaded mlmmjListTextsDir="+self.getMlmmjListTextsDir()+" from configuration file");
                except ConfigParser.NoOptionError, e:
                    logging.warn("Skipping option ListTextsDir");
                        
            else:
                logging.warning("Configuration file has no section 'conf'");
                return;
        else:
            logging.warning("Unable to load from configuration file "+Configuration.__configFile+": It does not appear to exist.");
            return;

    def checkConfiguration(self):
        logging.debug("Bin prefix: "+Configuration.__mlmmjBinPrefix);

        if not dirExists(Configuration.__mlmmjBinPrefix):
            logging.fatal("Directory supposed to contain mlmmj binaries does not exist. Exiting.");
            sys.exit(1);
    
        if not fileExists(Configuration.__mlmmjSub):
            logging.fatal("Unable to locate "+Configuration.__mlmmjSub+" binary. Exiting.");
            sys.exit(1);
        
        if not fileExists(Configuration.__mlmmjUnsub):
            logging.fatal("Unable to locate "+Configuration.__mlmmjUnsub+" binary. Exiting.");
            sys.exit(1);
    
        if not fileExists(Configuration.__mlmmjList):
            logging.fatal("Unable to locate "+Configuration.__mlmmjList+" binary. Exiting");
            sys.exit(1);
    
        if not dirExists(Configuration.__mlmmjListBase):
            logging.fatal(Configuration.__mlmmjListBase+" specified as mlmmj root directory does not exist. Exiting.");
            sys.exit(1);
            
        if not dirExists(Configuration.__mlmmjListTextsDir):
            logging.fatal(Configuration.__mlmmjListTextsDir + " which is supposed to hold list text files, does not exist. Exiting.");
            sys.exit(1);

    def setConfigFile(self, newConfigFile):
        Configuration.__configFile = newConfigFile;
    def getConfigFile(self):
        return Configuration.__configFile;

    def getUser(self):
        return Configuration.__user;
    def setUser(self, newUser):
        Configuration.__user = newUser;
    
    def getGroup(self):
        return Configuration.__group;
    def setGroup(self, newGroup):
        Configuration.__group = newGroup;

    def getUsersFile(self):
        return Configuration.__usersFile;
    def setUsersFile(self, newUsersFile):
        Configuration.__usersFile = newUsersFile;
    
    def getLogFile(self):
        return Configuration.__logFile;
    def setLogFile(self,newLogFile):
        Configuration.__logFile = newLogFile;

    def getDebug(self):
        return Configuration.__debug;
    def setDebug(self, newDebug):
        Configuration.__debug = newDebug;

    def getBindPort(self):
        return Configuration.__bindPort;
    def setBindPort(self, newBindPort):
        Configuration.__bindPort = newBindPort;

    def getBindAddress(self):
        return Configuration.__bindAddress;
    def setBindAddress(self, newBindAddress):
        Configuration.__bindAddress = newBindAddress;

    def getListBase(self):
        return Configuration.__mlmmjListBase;
    def setListBase(self, newListBase):
        Configuration.__mlmmjListBase = newListBase;

    def getMlmmjBinPrefix(self):
        return Configuration.__mlmmjBinPrefix;
    def getMlmmjUnsub(self):
        return Configuration.__mlmmjUnsub;
    def getMlmmjSub(self):
        return Configuration.__mlmmjSub;
    def getMlmmjList(self):
        return Configuration.__mlmmjList;
    def setMlmmjBinPrefix(self, newBinPrefix):
        Configuration.__mlmmjBinPrefix = newBinPrefix;
        Configuration.__mlmmjUnsub = Configuration.__mlmmjBinPrefix+"/mlmmj-unsub";
        Configuration.__mlmmjSub = Configuration.__mlmmjBinPrefix+"/mlmmj-sub";
        Configuration.__mlmmjList = Configuration.__mlmmjBinPrefix+"/mlmmj-list";
    
    def getPidFile(self):
        return Configuration.__pidFile;
    def setPidFile(self,newPidFile):
        Configuration.__pidFile = newPidFile;

    def getMlmmjListTextsDir(self):
        return Configuration.__mlmmjListTextsDir;
    def setMlmmjListTextsDir(self, newListTextsDir):
        Configuration.__mlmmjListTextsDir = newListTextsDir;