functor CLexFun(structure Tokens : C_TOKENS 
			 structure TokTable : TOKENTABLE 
			 sharing TokTable.Tokens = Tokens)=
   struct
    structure UserDeclarations =
      struct
(* Copyright (c) 1998 by Lucent Technologies *)

(*
 * The following replacement for c.lex should give correct (ANSI)
 * In particular, we don't allow
 * 
 * char *t = "abd
 * lkj";
 * 
 * GCC accepts this, but SGI cc does not. This program is not ANSI
 * compliant.
 *)

type svalue = Tokens.svalue
type pos = int
type lexresult = (svalue,pos) Tokens.token
type errWarn = {err: pos*pos*string->unit, warn: pos*pos*string->unit}
type lexarg =  {comLevel : int ref, 
                sourceMap : SourceMap.sourcemap,
		charlist : string list ref,
		stringstart : int ref,  (* start of current string or comment*)
	        errWarn: errWarn}

type arg = lexarg
type ('a,'b) token = ('a,'b) Tokens.token

fun ordof (s, i) = Char.ord (String.sub (s, i))
fun dec (iRef : int ref) = iRef := (!iRef) - 1
fun inc (iRef : int ref) = iRef := (!iRef) + 1
fun chr i = String.str(Char.chr i)
fun ord s = Char.ord(String.sub(s, 0))
fun explode s = CharVector.foldr (fn (c, l) => str c :: l) [] s
fun implode strList = String.concat strList
fun hd [] = (print "c.lex: hd of empty\n";
	     raise Empty)
  | hd (h :: l)	= h

val eof = fn ({comLevel,errWarn,sourceMap,stringstart,charlist}:lexarg) => 
	   let val pos = Int.max(!stringstart+2, SourceMap.currPos sourceMap)
	    in if !comLevel>0 then (#err errWarn) (!stringstart,pos, "unclosed comment" )
		  	      else ();
	       Tokens.EOF(pos,pos)
	   end	
fun addString (charlist,s:string) = charlist := s :: (!charlist)
fun makeString charlist = (implode(rev(!charlist)) before charlist := nil)

fun mkHexInt (s,a,b,errWarn:errWarn)=((case (StringCvt.scanString (LargeInt.scan StringCvt.HEX) s) of
		  SOME i => i
		| _ => ((#err errWarn)(a,b,"trouble in parsing int");Int.toLarge(0)))
			handle OverFlow => ((#err errWarn)(a,b,"large int const");Int.toLarge(0)))

fun mkHexChar (args as (s, a, b, errWarn:errWarn)) : int (* returns a character sized integer *) = 
	let val i = mkHexInt args
	in
	  if (i>255) then 
	    ((#warn errWarn) (a,b,"overflow in hexadecimal escape sequence");
	    IntInf.toInt(i mod 256))
	  else
       	    IntInf.toInt i
        end	

fun mkOctInt (s,a,b,errWarn:errWarn)
	= ((case (StringCvt.scanString (LargeInt.scan StringCvt.OCT) s) of
		  SOME i => i
		| _ => ((#err errWarn)(a,b,"trouble in parsing int");Int.toLarge(0)))
			handle OverFlow => ((#err errWarn)(a,b,"large int const");Int.toLarge(0)))


fun mkOctChar (args as (s, a, b, errWarn:errWarn)) (* returns a character sized integer *) = 
	let val i = mkOctInt args
	in
	  if (i>255) then 
	    ((#warn errWarn) (a,b,"overflow in octal escape sequence");
	    IntInf.toInt(i mod 256))
	  else
       	    IntInf.toInt i
        end	

fun mkInt (s,a,b,errWarn:errWarn) = ((case (StringCvt.scanString (LargeInt.scan StringCvt.DEC) s) of
		  SOME i => i
		| _ => ((#err errWarn)(a,b,"trouble in parsing int");Int.toLarge(0)))
			handle OverFlow => ((#err errWarn)(a,b,"large int const");Int.toLarge(0)))

fun mkRealNum (s,a,b,errWarn:errWarn) = ((case (StringCvt.scanString Real.scan s) of
		   SOME r => r
		 | _ => ((#err errWarn)(a,b,"trouble in parsing real");0.0))
			handle OverFlow => ((#err errWarn)(a,b,"large real const"); 0.0))

val backslasha = 7

fun special_char(c,fst,last,errWarn:errWarn) =
		(case c of
			"\\a" => 7
		      | "\\b" => 8
		      | "\\f" => 12
		      | "\\n" => 10
		      | "\\r" => 13
		      | "\\t" => 9
		      | "\\v" => 11
	              | _ => ordof(c,1)
	                      (* strictly speaking, should only handle
                                \?, \\, \", \', but it is common
                                to simply ignore slash, and just use next char *)
		)


(* Notes on lexer states:
   INITIAL -- predefined start state and the default token state
   S -- inside a string (entered from INTITAL with ")
   C -- inside a comment (entered from INITIAL with /* )
 *)


end (* end of user routines *)
exception LexError (* raised if illegal leaf action tried *)
structure Internal =
	struct

datatype yyfinstate = N of int
type statedata = {fin : yyfinstate list, trans: string}
(* transition & final state table *)
val tab = let
val s = [ 
 (0, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (1, 
"\007\007\007\007\007\007\007\007\007\095\097\007\095\007\007\007\
\\007\007\007\007\007\007\007\007\007\007\007\007\007\007\007\007\
\\095\093\092\007\007\090\087\073\072\071\069\066\065\061\057\054\
\\044\033\033\033\033\033\033\033\033\033\032\031\027\025\021\020\
\\007\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\
\\014\014\014\014\014\014\014\014\014\014\014\019\007\018\016\014\
\\007\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\
\\014\014\014\014\014\014\014\014\014\014\014\013\010\009\008\007\
\\007"
),
 (2, 
"\007\007\007\007\007\007\007\007\007\101\097\007\101\007\007\007\
\\007\007\007\007\007\007\007\007\007\007\007\007\007\007\007\007\
\\101\093\092\098\007\090\087\073\072\071\069\066\065\061\057\054\
\\044\033\033\033\033\033\033\033\033\033\032\031\027\025\021\020\
\\007\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\
\\014\014\014\014\014\014\014\014\014\014\014\019\007\018\016\014\
\\007\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\
\\014\014\014\014\014\014\014\014\014\014\014\013\010\009\008\007\
\\007"
),
 (3, 
"\103\103\103\103\103\103\103\103\103\106\097\103\106\103\103\103\
\\103\103\103\103\103\103\103\103\103\103\103\103\103\103\103\103\
\\106\103\103\103\103\103\103\103\103\103\104\103\103\103\103\103\
\\103\103\103\103\103\103\103\103\103\103\103\103\103\103\103\103\
\\103\103\103\103\103\103\103\103\103\103\103\103\103\103\103\103\
\\103\103\103\103\103\103\103\103\103\103\103\103\103\103\103\103\
\\103\103\103\103\103\103\103\103\103\103\103\103\103\103\103\103\
\\103\103\103\103\103\103\103\103\103\103\103\103\103\103\103\103\
\\103"
),
 (4, 
"\103\103\103\103\103\103\103\103\103\108\097\103\108\103\103\103\
\\103\103\103\103\103\103\103\103\103\103\103\103\103\103\103\103\
\\108\103\103\107\103\103\103\103\103\103\104\103\103\103\103\103\
\\103\103\103\103\103\103\103\103\103\103\103\103\103\103\103\103\
\\103\103\103\103\103\103\103\103\103\103\103\103\103\103\103\103\
\\103\103\103\103\103\103\103\103\103\103\103\103\103\103\103\103\
\\103\103\103\103\103\103\103\103\103\103\103\103\103\103\103\103\
\\103\103\103\103\103\103\103\103\103\103\103\103\103\103\103\103\
\\103"
),
 (5, 
"\109\109\109\109\109\109\109\109\109\109\122\109\109\109\109\109\
\\109\109\109\109\109\109\109\109\109\109\109\109\109\109\109\109\
\\109\109\121\109\109\109\109\109\109\109\109\109\109\109\109\109\
\\109\109\109\109\109\109\109\109\109\109\109\109\109\109\109\109\
\\109\109\109\109\109\109\109\109\109\109\109\109\109\109\109\109\
\\109\109\109\109\109\109\109\109\109\109\109\109\110\109\109\109\
\\109\109\109\109\109\109\109\109\109\109\109\109\109\109\109\109\
\\109\109\109\109\109\109\109\109\109\109\109\109\109\109\109\109\
\\109"
),
 (10, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\012\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\011\000\000\000\
\\000"
),
 (14, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\015\015\015\015\015\015\015\015\015\015\000\000\000\000\000\000\
\\000\015\015\015\015\015\015\015\015\015\015\015\015\015\015\015\
\\015\015\015\015\015\015\015\015\015\015\015\000\000\000\000\015\
\\000\015\015\015\015\015\015\015\015\015\015\015\015\015\015\015\
\\015\015\015\015\015\015\015\015\015\015\015\000\000\000\000\000\
\\000"
),
 (16, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\017\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (21, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\024\022\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (22, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\023\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (25, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\026\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (27, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\029\028\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (29, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\030\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (33, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\042\000\
\\041\041\041\041\041\041\041\041\041\041\000\000\000\000\000\000\
\\000\000\000\000\000\037\000\000\000\000\000\000\036\000\000\000\
\\000\000\000\000\000\034\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\037\000\000\000\000\000\000\036\000\000\000\
\\000\000\000\000\000\034\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (34, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\035\000\000\000\
\\000\000\000\000\000\035\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\035\000\000\000\
\\000\000\000\000\000\035\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (37, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\040\000\040\000\000\
\\038\038\038\038\038\038\038\038\038\038\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (38, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\038\038\038\038\038\038\038\038\038\038\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\039\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\039\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (40, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\038\038\038\038\038\038\038\038\038\038\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (42, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\043\043\043\043\043\043\043\043\043\043\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (43, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\043\043\043\043\043\043\043\043\043\043\000\000\000\000\000\000\
\\000\000\000\000\000\037\000\000\000\000\000\000\039\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\037\000\000\000\000\000\000\039\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (44, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\042\000\
\\050\050\050\050\050\050\050\050\049\049\000\000\000\000\000\000\
\\000\000\000\000\000\037\000\000\000\000\000\000\036\000\000\000\
\\000\000\000\000\000\034\000\000\045\000\000\000\000\000\000\000\
\\000\000\000\000\000\037\000\000\000\000\000\000\036\000\000\000\
\\000\000\000\000\000\034\000\000\045\000\000\000\000\000\000\000\
\\000"
),
 (45, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\046\046\046\046\046\046\046\046\046\046\000\000\000\000\000\000\
\\000\046\046\046\046\046\046\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\046\046\046\046\046\046\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (46, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\046\046\046\046\046\046\046\046\046\046\000\000\000\000\000\000\
\\000\046\046\046\046\046\046\000\000\000\000\000\047\000\000\000\
\\000\000\000\000\000\047\000\000\000\000\000\000\000\000\000\000\
\\000\046\046\046\046\046\046\000\000\000\000\000\047\000\000\000\
\\000\000\000\000\000\047\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (47, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\048\000\000\000\
\\000\000\000\000\000\048\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\048\000\000\000\
\\000\000\000\000\000\048\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (49, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\042\000\
\\049\049\049\049\049\049\049\049\049\049\000\000\000\000\000\000\
\\000\000\000\000\000\037\000\000\000\000\000\000\039\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\037\000\000\000\000\000\000\039\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (50, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\042\000\
\\050\050\050\050\050\050\050\050\049\049\000\000\000\000\000\000\
\\000\000\000\000\000\037\000\000\000\000\000\000\053\000\000\000\
\\000\000\000\000\000\051\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\037\000\000\000\000\000\000\053\000\000\000\
\\000\000\000\000\000\051\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (51, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\052\000\000\000\
\\000\000\000\000\000\052\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\052\000\000\000\
\\000\000\000\000\000\052\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (54, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\056\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\055\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (57, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\059\000\
\\058\058\058\058\058\058\058\058\058\058\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (58, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\058\058\058\058\058\058\058\058\058\058\000\000\000\000\000\000\
\\000\000\000\000\000\037\000\000\000\000\000\000\039\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\037\000\000\000\000\000\000\039\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (59, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\060\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (61, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\064\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\063\062\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (66, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\068\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\067\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (69, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\070\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (73, 
"\074\074\074\074\074\074\074\074\074\074\000\074\074\074\074\074\
\\074\074\074\074\074\074\074\074\074\074\074\074\074\074\074\074\
\\074\074\074\074\074\074\074\074\074\074\074\074\074\074\074\074\
\\074\074\074\074\074\074\074\074\074\074\074\074\074\074\074\074\
\\074\074\074\074\074\074\074\074\074\074\074\074\074\074\074\074\
\\074\074\074\074\074\074\074\074\074\074\074\074\076\074\074\074\
\\074\074\074\074\074\074\074\074\074\074\074\074\074\074\074\074\
\\074\074\074\074\074\074\074\074\074\074\074\074\074\074\074\074\
\\074"
),
 (74, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\075\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (76, 
"\077\077\077\077\077\077\077\077\077\077\000\077\077\077\077\077\
\\077\077\077\077\077\077\077\077\077\077\077\077\077\077\077\077\
\\077\077\077\077\077\077\077\077\077\077\077\077\077\077\077\077\
\\082\082\082\082\082\082\082\082\077\077\077\077\077\077\077\077\
\\077\077\077\077\077\077\077\077\077\077\077\077\077\077\077\077\
\\077\077\077\077\077\077\077\077\077\077\077\077\077\077\077\077\
\\077\077\077\077\077\077\077\077\077\077\077\077\077\077\077\077\
\\077\077\077\077\077\077\077\077\079\077\077\077\077\077\077\077\
\\077"
),
 (77, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\078\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (79, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\078\000\000\000\000\000\000\000\000\
\\080\080\080\080\080\080\080\080\080\080\000\000\000\000\000\000\
\\000\080\080\080\080\080\080\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\080\080\080\080\080\080\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (80, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\081\000\000\000\000\000\000\000\000\
\\080\080\080\080\080\080\080\080\080\080\000\000\000\000\000\000\
\\000\080\080\080\080\080\080\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\080\080\080\080\080\080\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (82, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\086\000\000\000\000\000\000\000\000\
\\083\083\083\083\083\083\083\083\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (83, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\085\000\000\000\000\000\000\000\000\
\\084\084\084\084\084\084\084\084\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (84, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\085\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (87, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\089\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\088\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (90, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\091\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (93, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\094\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (95, 
"\000\000\000\000\000\000\000\000\000\096\000\000\096\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\096\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (98, 
"\099\099\099\099\099\099\099\099\099\099\100\099\099\099\099\099\
\\099\099\099\099\099\099\099\099\099\099\099\099\099\099\099\099\
\\099\099\099\099\099\099\099\099\099\099\099\099\099\099\099\099\
\\099\099\099\099\099\099\099\099\099\099\099\099\099\099\099\099\
\\099\099\099\099\099\099\099\099\099\099\099\099\099\099\099\099\
\\099\099\099\099\099\099\099\099\099\099\099\099\099\099\099\099\
\\099\099\099\099\099\099\099\099\099\099\099\099\099\099\099\099\
\\099\099\099\099\099\099\099\099\099\099\099\099\099\099\099\099\
\\099"
),
 (101, 
"\000\000\000\000\000\000\000\000\000\102\000\000\102\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\102\000\000\099\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (104, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\105\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (109, 
"\109\109\109\109\109\109\109\109\109\109\000\109\109\109\109\109\
\\109\109\109\109\109\109\109\109\109\109\109\109\109\109\109\109\
\\109\109\000\109\109\109\109\109\109\109\109\109\109\109\109\109\
\\109\109\109\109\109\109\109\109\109\109\109\109\109\109\109\109\
\\109\109\109\109\109\109\109\109\109\109\109\109\109\109\109\109\
\\109\109\109\109\109\109\109\109\109\109\109\109\000\109\109\109\
\\109\109\109\109\109\109\109\109\109\109\109\109\109\109\109\109\
\\109\109\109\109\109\109\109\109\109\109\109\109\109\109\109\109\
\\109"
),
 (110, 
"\111\111\111\111\111\111\111\111\111\111\120\111\111\111\111\111\
\\111\111\111\111\111\111\111\111\111\111\111\111\111\111\111\111\
\\111\111\111\111\111\111\111\111\111\111\111\111\111\111\111\111\
\\119\116\116\116\116\116\116\116\111\111\111\111\111\111\111\111\
\\111\111\111\111\111\111\111\111\111\111\111\111\111\111\111\111\
\\111\111\111\111\111\111\111\111\111\111\111\111\111\111\114\111\
\\111\111\111\111\111\111\111\111\111\111\111\111\111\111\111\111\
\\111\111\111\111\111\111\111\111\112\111\111\111\111\111\111\111\
\\111"
),
 (112, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\113\113\113\113\113\113\113\113\113\113\000\000\000\000\000\000\
\\000\113\113\113\113\113\113\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\113\113\113\113\113\113\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (114, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\115\115\115\115\115\115\115\115\115\115\115\115\115\115\115\115\
\\115\115\115\115\115\115\115\115\115\115\115\115\115\115\115\115\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (116, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\117\117\117\117\117\117\117\117\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (117, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\118\118\118\118\118\118\118\118\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
(0, "")]
fun f x = x 
val s = map f (rev (tl (rev s))) 
exception LexHackingError 
fun look ((j,x)::r, i: int) = if i = j then x else look(r, i) 
  | look ([], i) = raise LexHackingError
fun g {fin=x, trans=i} = {fin=x, trans=look(s,i)} 
in Vector.fromList(map g 
[{fin = [], trans = 0},
{fin = [(N 10)], trans = 1},
{fin = [(N 10)], trans = 2},
{fin = [(N 10)], trans = 3},
{fin = [(N 10)], trans = 4},
{fin = [(N 26)], trans = 5},
{fin = [(N 26)], trans = 5},
{fin = [(N 227)], trans = 0},
{fin = [(N 96),(N 227)], trans = 0},
{fin = [(N 65),(N 227)], trans = 0},
{fin = [(N 100),(N 227)], trans = 10},
{fin = [(N 157)], trans = 0},
{fin = [(N 136)], trans = 0},
{fin = [(N 63),(N 227)], trans = 0},
{fin = [(N 225),(N 227)], trans = 14},
{fin = [(N 225)], trans = 14},
{fin = [(N 79),(N 227)], trans = 16},
{fin = [(N 124)], trans = 0},
{fin = [(N 61),(N 227)], trans = 0},
{fin = [(N 59),(N 227)], trans = 0},
{fin = [(N 98),(N 227)], trans = 0},
{fin = [(N 151),(N 227)], trans = 21},
{fin = [(N 166)], trans = 22},
{fin = [(N 147)], trans = 0},
{fin = [(N 110)], trans = 0},
{fin = [(N 115),(N 227)], trans = 25},
{fin = [(N 113)], trans = 0},
{fin = [(N 149),(N 227)], trans = 27},
{fin = [(N 107)], trans = 0},
{fin = [(N 163)], trans = 29},
{fin = [(N 143)], trans = 0},
{fin = [(N 53),(N 227)], trans = 0},
{fin = [(N 51),(N 227)], trans = 0},
{fin = [(N 185),(N 199),(N 227)], trans = 33},
{fin = [(N 185)], trans = 34},
{fin = [(N 185)], trans = 0},
{fin = [(N 185),(N 199)], trans = 34},
{fin = [], trans = 37},
{fin = [(N 199)], trans = 38},
{fin = [(N 199)], trans = 0},
{fin = [], trans = 40},
{fin = [(N 185),(N 199)], trans = 33},
{fin = [], trans = 42},
{fin = [(N 199)], trans = 43},
{fin = [(N 185),(N 199),(N 227)], trans = 44},
{fin = [], trans = 45},
{fin = [(N 179)], trans = 46},
{fin = [(N 179)], trans = 47},
{fin = [(N 179)], trans = 0},
{fin = [(N 199)], trans = 49},
{fin = [(N 172),(N 199)], trans = 50},
{fin = [(N 172)], trans = 51},
{fin = [(N 172)], trans = 0},
{fin = [(N 172),(N 199)], trans = 51},
{fin = [(N 94),(N 227)], trans = 54},
{fin = [(N 133)], trans = 0},
{fin = [(N 13)], trans = 0},
{fin = [(N 67),(N 227)], trans = 57},
{fin = [(N 199)], trans = 58},
{fin = [], trans = 59},
{fin = [(N 71)], trans = 0},
{fin = [(N 83),(N 227)], trans = 61},
{fin = [(N 92)], trans = 0},
{fin = [(N 121)], trans = 0},
{fin = [(N 89)], trans = 0},
{fin = [(N 73),(N 227)], trans = 0},
{fin = [(N 81),(N 227)], trans = 66},
{fin = [(N 118)], trans = 0},
{fin = [(N 86)], trans = 0},
{fin = [(N 75),(N 227)], trans = 69},
{fin = [(N 130)], trans = 0},
{fin = [(N 57),(N 227)], trans = 0},
{fin = [(N 55),(N 227)], trans = 0},
{fin = [(N 227)], trans = 73},
{fin = [], trans = 74},
{fin = [(N 217)], trans = 0},
{fin = [], trans = 76},
{fin = [], trans = 77},
{fin = [(N 222)], trans = 0},
{fin = [], trans = 79},
{fin = [], trans = 80},
{fin = [(N 213)], trans = 0},
{fin = [], trans = 82},
{fin = [], trans = 83},
{fin = [], trans = 84},
{fin = [(N 206)], trans = 0},
{fin = [(N 206),(N 222)], trans = 0},
{fin = [(N 102),(N 227)], trans = 87},
{fin = [(N 139)], trans = 0},
{fin = [(N 160)], trans = 0},
{fin = [(N 104),(N 227)], trans = 90},
{fin = [(N 127)], trans = 0},
{fin = [(N 20),(N 227)], trans = 0},
{fin = [(N 77),(N 227)], trans = 93},
{fin = [(N 154)], trans = 0},
{fin = [(N 10),(N 227)], trans = 95},
{fin = [(N 10)], trans = 95},
{fin = [(N 7)], trans = 0},
{fin = [(N 227)], trans = 98},
{fin = [], trans = 98},
{fin = [(N 5)], trans = 0},
{fin = [(N 10),(N 227)], trans = 101},
{fin = [(N 10)], trans = 101},
{fin = [(N 18)], trans = 0},
{fin = [(N 18)], trans = 104},
{fin = [(N 16)], trans = 0},
{fin = [(N 10),(N 18)], trans = 95},
{fin = [(N 18)], trans = 98},
{fin = [(N 10),(N 18)], trans = 101},
{fin = [(N 26)], trans = 109},
{fin = [], trans = 110},
{fin = [(N 49)], trans = 0},
{fin = [(N 49)], trans = 112},
{fin = [(N 42)], trans = 112},
{fin = [(N 49)], trans = 114},
{fin = [(N 46)], trans = 0},
{fin = [(N 49)], trans = 116},
{fin = [], trans = 117},
{fin = [(N 37)], trans = 0},
{fin = [(N 32),(N 49)], trans = 116},
{fin = [(N 29)], trans = 0},
{fin = [(N 22)], trans = 0},
{fin = [(N 24)], trans = 0}])
end
structure StartStates =
	struct
	datatype yystartstate = STARTSTATE of int

(* start state definitions *)

val C = STARTSTATE 3;
val INITIAL = STARTSTATE 1;
val S = STARTSTATE 5;

end
type result = UserDeclarations.lexresult
	exception LexerError (* raised if illegal leaf action tried *)
end

fun makeLexer yyinput =
let	val yygone0=1
	val yyb = ref "\n" 		(* buffer *)
	val yybl = ref 1		(*buffer length *)
	val yybufpos = ref 1		(* location of next character to use *)
	val yygone = ref yygone0	(* position in file of beginning of buffer *)
	val yydone = ref false		(* eof found yet? *)
	val yybegin = ref 1		(*Current 'start state' for lexer *)

	val YYBEGIN = fn (Internal.StartStates.STARTSTATE x) =>
		 yybegin := x

fun lex (yyarg as ({comLevel,errWarn,sourceMap,charlist,stringstart})) =
let fun continue() : Internal.result = 
  let fun scan (s,AcceptingLeaves : Internal.yyfinstate list list,l,i0) =
	let fun action (i,nil) = raise LexError
	| action (i,nil::l) = action (i-1,l)
	| action (i,(node::acts)::l) =
		case node of
		    Internal.N yyk => 
			(let fun yymktext() = substring(!yyb,i0,i-i0)
			     val yypos = i0+ !yygone
			open UserDeclarations Internal.StartStates
 in (yybufpos := i; case yyk of 

			(* Application actions *)

  10 => (continue())
| 100 => (Tokens.BAR(yypos,yypos+1))
| 102 => (Tokens.AMP(yypos,yypos+1))
| 104 => (Tokens.PERCENT(yypos,yypos+1))
| 107 => (Tokens.LTE(yypos,yypos+2))
| 110 => (Tokens.GTE(yypos,yypos+2))
| 113 => (Tokens.EQ(yypos,yypos+2))
| 115 => (Tokens.EQUALS(yypos,yypos+1))
| 118 => (Tokens.PLUSEQUALS(yypos,yypos+2))
| 121 => (Tokens.MINUSEQUALS(yypos,yypos+2))
| 124 => (Tokens.XOREQUALS(yypos,yypos+2))
| 127 => (Tokens.MODEQUALS(yypos,yypos+2))
| 13 => (YYBEGIN C; continue())
| 130 => (Tokens.TIMESEQUALS(yypos,yypos+2))
| 133 => (Tokens.DIVEQUALS(yypos,yypos+2))
| 136 => (Tokens.OREQUALS(yypos,yypos+2))
| 139 => (Tokens.ANDEQUALS(yypos,yypos+2))
| 143 => (Tokens.LSHIFTEQUALS(yypos,yypos+3))
| 147 => (Tokens.RSHIFTEQUALS(yypos,yypos+3))
| 149 => (Tokens.LT(yypos,yypos+1))
| 151 => (Tokens.GT(yypos,yypos+1))
| 154 => (Tokens.NEQ(yypos,yypos+2))
| 157 => (Tokens.OR(yypos,yypos+2))
| 16 => (YYBEGIN INITIAL; continue())
| 160 => (Tokens.AND(yypos,yypos+2))
| 163 => (Tokens.LSHIFT(yypos,yypos+2))
| 166 => (Tokens.RSHIFT(yypos,yypos+2))
| 172 => let val yytext=yymktext() in Tokens.DECNUM(mkOctInt(yytext,yypos,yypos+size(yytext),errWarn),yypos, yypos+size(yytext)) end
| 179 => let val yytext=yymktext() in Tokens.DECNUM(mkHexInt(yytext,yypos,yypos+size(yytext),errWarn),yypos, yypos+size(yytext)) end
| 18 => (continue())
| 185 => let val yytext=yymktext() in Tokens.DECNUM(mkInt (yytext,yypos,yypos+size(yytext),errWarn), yypos,yypos+size(yytext)) end
| 199 => let val yytext=yymktext() in Tokens.REALNUM(mkRealNum(yytext,yypos,yypos+size(yytext),errWarn), yypos, yypos
+ size(yytext)) end
| 20 => (charlist := [""]; stringstart := yypos; YYBEGIN S; continue())
| 206 => let val yytext=yymktext() in let val s = substring(yytext, 2, size(yytext)-3)
				     in Tokens.CCONST(IntInf.fromInt (mkOctChar(s,yypos,yypos+size(yytext),errWarn)),
						      yypos,
					      yypos+size(yytext))
	                             end end
| 213 => let val yytext=yymktext() in let val s = substring(yytext, 3, size(yytext)-4)
				     in Tokens.CCONST(IntInf.fromInt (mkHexChar(s,yypos,yypos+size(yytext),errWarn)),
						      yypos,
						      yypos+size(yytext))
	                             end end
| 217 => let val yytext=yymktext() in let val cval = ordof(yytext,1)
	                            in Tokens.CCONST(Int.toLarge cval,yypos,yypos+size(yytext))
                                    end end
| 22 => (YYBEGIN INITIAL;Tokens.STRING(makeString charlist,!stringstart,yypos+1))
| 222 => let val yytext=yymktext() in Tokens.CCONST(IntInf.fromInt(special_char(substring(yytext,1,size(yytext)-2),yypos,yypos+size(yytext),errWarn)), yypos, yypos+size(yytext)) end
| 225 => let val yytext=yymktext() in TokTable.checkToken(yytext,yypos) end
| 227 => (continue())
| 24 => ((#err errWarn) (!stringstart,yypos,"unclosed string");
		    SourceMap.newline sourceMap yypos;
		    YYBEGIN INITIAL; Tokens.STRING(makeString charlist,!stringstart,yypos))
| 26 => let val yytext=yymktext() in addString(charlist,yytext); continue() end
| 29 => (SourceMap.newline sourceMap yypos; continue())
| 32 => (addString(charlist,chr 0);continue())
| 37 => let val yytext=yymktext() in addString(charlist, chr(mkOctChar(substring(yytext, 1, size(yytext)-1), yypos, yypos+size(yytext), errWarn))); continue() end
| 42 => let val yytext=yymktext() in addString(charlist, chr(mkHexChar(substring(yytext, 2, size(yytext)-2), yypos, yypos+size(yytext), errWarn))); continue() end
| 46 => let val yytext=yymktext() in addString(charlist,chr(ordof(yytext,2)-ord("@"))); continue() end
| 49 => let val yytext=yymktext() in addString(charlist, chr(special_char(yytext, yypos, yypos+size(yytext), errWarn))); continue() end
| 5 => let val yytext=yymktext() in SourceMap.parseDirective sourceMap 
                         (yypos,yytext); continue() end
| 51 => (Tokens.COLON(yypos,yypos+1))
| 53 => (Tokens.SEMICOLON(yypos,yypos+1))
| 55 => (Tokens.LPAREN(yypos,yypos+1))
| 57 => (Tokens.RPAREN(yypos,yypos+1))
| 59 => (Tokens.LBRACE(yypos,yypos+1))
| 61 => (Tokens.RBRACE(yypos,yypos+1))
| 63 => (Tokens.LCURLY(yypos,yypos+1))
| 65 => (Tokens.RCURLY(yypos,yypos+1))
| 67 => (Tokens.DOT(yypos,yypos+1))
| 7 => (SourceMap.newline sourceMap yypos; continue())
| 71 => (Tokens.ELIPSIS(yypos,yypos+3))
| 73 => (Tokens.COMMA(yypos,yypos+1))
| 75 => (Tokens.TIMES(yypos,yypos+1))
| 77 => (Tokens.BANG(yypos,yypos+1))
| 79 => (Tokens.HAT(yypos,yypos+1))
| 81 => (Tokens.PLUS(yypos,yypos+1))
| 83 => (Tokens.MINUS(yypos,yypos+1))
| 86 => (Tokens.INC(yypos,yypos+2))
| 89 => (Tokens.DEC(yypos,yypos+2))
| 92 => (Tokens.ARROW(yypos,yypos+1))
| 94 => (Tokens.DIVIDE(yypos,yypos+1))
| 96 => (Tokens.TILDE(yypos,yypos+1))
| 98 => (Tokens.QUESTION(yypos,yypos+1))
| _ => raise Internal.LexerError

		) end )

	val {fin,trans} = Unsafe.Vector.sub(Internal.tab, s)
	val NewAcceptingLeaves = fin::AcceptingLeaves
	in if l = !yybl then
	     if trans = #trans(Vector.sub(Internal.tab,0))
	       then action(l,NewAcceptingLeaves
) else	    let val newchars= if !yydone then "" else yyinput 1024
	    in if (size newchars)=0
		  then (yydone := true;
		        if (l=i0) then UserDeclarations.eof yyarg
		                  else action(l,NewAcceptingLeaves))
		  else (if i0=l then yyb := newchars
		     else yyb := substring(!yyb,i0,l-i0)^newchars;
		     yygone := !yygone+i0;
		     yybl := size (!yyb);
		     scan (s,AcceptingLeaves,l-i0,0))
	    end
	  else let val NewChar = Char.ord(Unsafe.CharVector.sub(!yyb,l))
		val NewChar = if NewChar<128 then NewChar else 128
		val NewState = Char.ord(Unsafe.CharVector.sub(trans,NewChar))
		in if NewState=0 then action(l,NewAcceptingLeaves)
		else scan(NewState,NewAcceptingLeaves,l+1,i0)
	end
	end
	val start= if substring(!yyb,!yybufpos-1,1)="\n"
then !yybegin+1 else !yybegin
	in scan(start,nil,!yybufpos,!yybufpos)
    end
in continue end
  in lex
  end
end
