(* Copyright (C) 1999-2005 Henry Cejtin, Matthew Fluet, Suresh
 *    Jagannathan, and Stephen Weeks.
 * Copyright (C) 1997-2000 NEC Research Institute.
 *
 * MLton is released under a BSD-style license.
 * See the file MLton-LICENSE for details.
 *)

functor UnsafeMonoArray (A: MONO_ARRAY_EXTRA): UNSAFE_MONO_ARRAY =
   struct
      open A

      val sub = unsafeSub
      val update = unsafeUpdate
      val create = fromPoly o Primitive.Array.array
   end

functor UnsafeMonoVector (V: MONO_VECTOR_EXTRA): UNSAFE_MONO_VECTOR =
   struct
      open V

      val sub = unsafeSub
   end

(* This is here so that the code generated by Lex and Yacc will work. *)
structure Unsafe: UNSAFE =
   struct
      structure Array =
         struct
            val sub = Array.unsafeSub
            val update = Array.unsafeUpdate
            val create = Array.array
         end
      structure CharArray = UnsafeMonoArray (CharArray)
      structure CharVector = UnsafeMonoVector (CharVector)
      structure Real64Array = UnsafeMonoArray (Real64Array)
      structure Vector =
         struct
            val sub = Vector.unsafeSub
         end
      structure Word8Array = UnsafeMonoArray (Word8Array)
      structure Word8Vector = UnsafeMonoVector (Word8Vector)
   end
