/* -*- Mode: C; indent-tabs-mode: nil; c-basic-offset: 8-*- */

/*
 *This file is part of MlView.
 *
 *MlView is free software; you can redistribute 
 *it and/or modify it under the terms of 
 *the GNU General Public License as published by the 
 *Free Software Foundation; either version 2, 
 *or (at your option) any later version.
 *
 *GNU MlView is distributed in the hope that it will 
 *be useful, but WITHOUT ANY WARRANTY; 
 *without even the implied warranty of 
 *MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *See the GNU General Public License for more details.
 *
 *You should have received a copy of the 
 *GNU General Public License along with MlView; 
 *see the file COPYING. 
 *If not, write to the Free Software Foundation, 
 *Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *See COPYRIGHT file copyright information.
 */

/**
 *@file
 *The place where MlView application is launched.
 *Here the command line is parsed, and mlview high level classes
 *are instanciated.
 *
 */

#include "mlview-app.h"
#include <stdio.h>
#include <locale.h>
#include <gnome.h>
#include <libxml/parser.h>
#include <libxml/catalog.h>


/**
 *MlView main entry point.
 */
int
main (int argc, char **argv)
{
        GnomeProgram *mlview_program = NULL;
        MlViewApp *mlview_application = NULL;

        gchar **args = NULL;
        poptContext popt_context = NULL;
        gboolean show_version = FALSE, show_info = FALSE;
        gchar* associated_dtd = NULL;

        struct poptOption cmd_options_table[] = {
                {
                 "version",
                 'v',
                 POPT_ARG_NONE,
                 &show_version,
                 0,
                 N_
                 ("Prints The version of gnome-mlview you are using"),
                 NULL},
                {
                 "about",
                 'a',
                 POPT_ARG_NONE,
                 &show_info,
                 0,
                 N_
                 ("Prints some information about gnome-mlview"),
                 NULL},
                {
                 "dtd",
                 'd',
                 POPT_ARG_STRING,
                 &associated_dtd,
                 0,
                 N_
                 ("Associates DTD with the XML documents on the commandline"),
                 NULL},
                {0}
        };
        /*init underlaying facilities */
        mlview_utils_init ();

        /*init gnome */
        mlview_program = gnome_program_init (PACKAGE, VERSION, 
                                             LIBGNOMEUI_MODULE,
                                             argc, argv,
                                             GNOME_PARAM_POPT_TABLE, cmd_options_table,
                                             GNOME_PARAM_APP_DATADIR, DATADIR, 
                                             GNOME_PARAM_NONE);


        gnome_program_parse_args (mlview_program);
        g_object_get (G_OBJECT (mlview_program),
                      GNOME_PARAM_POPT_CONTEXT,
                      &popt_context, 
                      NULL);
        g_return_val_if_fail (popt_context, -1) ;
        /*Then, parse the non option command arguments */
        args = (gchar **) poptGetArgs (popt_context);

        if (show_version == TRUE) {
                g_print ("%s\n", VERSION);
                poptFreeContext (popt_context);
                return 0;
        }

        if (show_info == TRUE) {
                g_print ("%s\n", _("No useful info yet"));
                poptFreeContext (popt_context);
                return 0;
        }

        if (associated_dtd != NULL)
        {
                g_print ("DTD: %s\n", associated_dtd);
        }

        /*instanciate an mlview application */
        mlview_application = mlview_app_new ((guchar*)PACKAGE);

        if (args) {
                /*
                 *they are some argument on the comment line. Treat them 
                 *like files to open
                 */
                MlViewEditor *mlview_editor =
                        mlview_app_get_editor
                        (mlview_application);

                if (mlview_editor) {
                        int i;

                        for (i = 0; args[i] != NULL; i++) {
                                mlview_editor_load_xml_file_with_dtd
                                        (mlview_editor,
                                         (gchar *) args[i],
                                         associated_dtd);
                        }
                }
        }

        poptFreeContext (popt_context);

        gtk_main ();
        mlview_utils_cleanup ();

        return 0;
}
