/*
  PrefsCategory :
 
  This file is part of MlView.
 
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "mlview-prefs-category.h"

namespace mlview
{
struct PrefsCategoryPriv
{
	Glib::ustring *m_id;
	PrefsStorageManager *m_storage_manager;
};

PrefsCategory::PrefsCategory (const Glib::ustring& category_id_,
                              PrefsStorageManager* mgr_)
{
	m_priv = new PrefsCategoryPriv ();
	m_priv->m_id = new Glib::ustring (category_id_);
	m_priv->m_storage_manager = mgr_;
}

PrefsCategory::~PrefsCategory ()
{
	if (m_priv != NULL)
		delete m_priv;
}

const Glib::ustring&
PrefsCategory::get_id ()
{
	return const_cast<Glib::ustring&>
	       (*(m_priv->m_id));
}

PrefsStorageManager*
PrefsCategory::get_storage_manager ()
{
	return m_priv->m_storage_manager;
}

} // namespace mlview
