"""
	MMAcommon.py
	
	These are a collection of miscellaneous routines used in various
	parts of mma. It is safe to load the whole works with:
	
		from MMAcommon import *
		
	without side effects (yeah, right).
"""

import sys
import random
import MMAglobals;  gbl = MMAglobals


def error(msg):
	""" Print an error message and exit.
	
	If the global line number is >=0 then print the line number
	as well.

	"""

	ln = "ERROR:"
	
	if gbl.lineno >=0:
		ln += "<Line %d>" % gbl.lineno

	if gbl.inpath:
		ln += "<File:%s>" % gbl.inpath.fname
	
	ln += " " + msg				

	print ln
	
	sys.exit()


def warning(msg):
	""" Print warning message and return. """
		

	if gbl.noWarn:
		return
		
	if gbl.lineno >=0:
		ln = "<Line %d>" % gbl.lineno
	else:
		ln = ''
		
	print "Warning:%s %s" % (ln, msg)

	

def getOffset(ticks, ran=0):
	""" Calculate a midi offset into a song."""

	
	p = gbl.tickOffset + ticks

	if ran:
		p += random.randrange(-ran,ran+1) 
		
	return int(p)
	


def stoi(s, errmsg):
	""" string to integer. """
	try:
		return int(s)
	
	except:
		error(errmsg)

def stof(s, errmsg):
	""" String to floating point. """
	
	try:
		return float(s)
	except:
		error(errmsg)





def keyLookup(d, v):
	""" Return a dict key for a value. """
	
	for a in d:
		if d[a] == v:
			return a
	return ''


_noteLenTable = {
	'0':	1,				# special 0==1 midi tick
	'1': gbl.BperQ * 4,		# whole note
	'2': gbl.BperQ * 2,		# 1/2
	'4': gbl.BperQ,			# 1/4
	'8': gbl.BperQ / 2,		# 1/8
	'16': gbl.BperQ / 4,	# 1/16
	'32': gbl.BperQ / 8,	# 1/32
	'64': gbl.BperQ / 16,	# 1/64
	'3': gbl.BperQ/3 }		# 1/8 triplet

def getNoteLen(n):	
	""" Convert a Note to a midi tick length. 
	
		Notes are 1==Whole, 4==Quarter, etc.
		Notes can be dotted or double dotted.
		Notes can be combined: 1+4 == 5 beats, 4. or 4+8 == dotted 1/4
	"""
	
	l = 0
	for a in str(n).split('+'):
		if a.endswith('..'):
			dot = 2
			a=a[:-2]
		elif a.endswith('.'):
			dot = 1
			a=a[:-1]
		else:
			dot = 0
			
		if not _noteLenTable.has_key(a):
			error("Unknown note duration %s" % n )
		i = _noteLenTable[a]
		if dot == 2:
			i += i/2 + i/4
		elif dot == 1:
			i += i/2
		l += i
		
	return l



def xgetNoteLen(n):	
	""" Convert a Note to a midi tick length. 
	
		Notes are 1==Whole, 4==Quarter, etc.
		Notes can be combined: 1+4 == 5 beats, 4+8 == dotted 1/4
	"""
	
	l = 0
	for a in str(n).split('+'):
		try:
			l += _noteLenTable[a]
		except:
			error("Unknown note duration %s" % n )
			
	return l


def printList(l):
	""" Print each item in a list. Works for numeric and string."""
	
	for a in l:
		print a,
	print



def pextract(s, open, close):
	""" Extract a parenthesized set of substrings.
	
		s     - original string
		open  - substring start tag
		close - substring end tab
		
		open/close can be mulitple char strings (ie. "<<" or "-->")
		
		returns ( original sans subs, [subs, ...] )
		
	eg: pextract("x{1}{2}y", '{', '}') -> ('xy', ['1', '2'])
	
	
	"""
		
	subs =[]
	
	while 1:	
		lstart=s.find(open)
		lend=s.find(close)
	
		if lstart>-1 and lstart < lend:
			subs.append( s[lstart+len(open):lend] )
			s = s[:lstart] + s[lend+len(close):]
		else:
			break


	return s, subs
	
