"""
	MMAdocs.py
	
	Routines to manage documenation.

"""

import MMAglobals;  gbl = MMAglobals
from MMAcommon import *
import MMAmidi
	

# These are storage for the data extracted from a lib file

fname=[]
author=[]
notes=[]
defs={}

	
def docDrumNames(order):
	""" Print latex table of drum names. """
	
	n = MMAmidi.drumNames
	
	if order == "a":
		n = n[:]
		n.sort()
		for a,v in n:
			print "\\insline{%s} {%s}" % (a, v)
			
	else:
		for a,v in n:
			print "\\insline{%s} {%s}" % (v, a)
		
def docInstNames(order):
	""" Print latex table of instrument names. """

	n = MMAmidi.voiceNames	
	if order == "a":
		n = n[:]
		n.sort()
		for a,v in n:
			a=a.replace('&', '\&')
			print "\\insline{%s} {%s}" % (a, v)
			
	else:
		for a,v in n:
			a=a.replace('&', '\&')
			print "\\insline{%s} {%s}" % (v, a)

def docAdd(ln):
	""" Add a doc line. 
	
		This is called from Process whenever a grooveDef or Doc is found.
		A line in the form "DEFINES xxx ", "AUTHOR xx", etc. is passed.
		The data is stored in this function header until a special ln is
		passed. If ln[0] is a -1 then the buffered data is flushed. This
		happens when Process finds an EOL.
		
	"""

	global fname, author, notes, defs
	
	# Print the latex stuff if the arg is a single -1
		
	if ln[0] == -1:
		if gbl.docs:
			if not len(fname):  fname=['']
			if not len(author): author=['']
			if not len(notes):  notes=['']
	
			print "\\filehead{%s}" % fname[0]
			print "{%s}" % ' '.join(notes) 
			print
			inx=defs.keys()
			inx.sort()
			for i in inx:
				l=defs[i]
				print "  \\instable{%s}{%s}{%s}{" % (l[0], l[2], l[1])
				for c,v in l[3:]:
					print "    \\insline{%s}{%s}" % (c.title(),v)
				print "  }"


		fname  = []
		author = []
		notes  = []
		defs   = {}
		
		return
	
	# We're not saving docs. Use the -Dx command line option to enable this.
	
	if not gbl.docs:
		return
	
	# All DOC lines have to have an arg
		
	if not len(ln):
		error("Use:  DOC <TYPE> <text>")
	
	# Grab the arg and data, save it
	
	tp = ln[0].upper()
	ln=ln[1:]

	if tp == 'FILE':
		if fname:
			error("Only one 'DOC FILE' directive permitted in a file")
		fname.append ( ' '.join(ln) )


		
	elif tp == 'AUTHOR':
		if len(author):
			error("Only one 'DOC AUTHOR' directive permitted in a file")
		author.append( ' '.join(ln) )
		
	elif tp == 'NOTE':
		notes.append( ' '.join(ln) )
		
	elif tp == 'DEFINES':
	
		""" We get here if we have a DOC DEFINE entry, or a DEFGROOVE with
			a doc argument.
			
			We start our list with the groove name 2x, 1st time in uppercase.
			This is just so we can sort the names easily, after
			sorting the uppercase name is ignored.
			
			The list ends up:
				[NAME-UPPERCASE, NAME, SEQSIZE, DESCRIPTION, [ [TRACK,INST]...]]

		"""
		
		l = [ln[0], gbl.seqSize,' '.join(ln[1:]) ]
		tks=gbl.tnames.keys()
		tks.sort()
		for a in tks:
			c=gbl.tnames[a]
			if c.sequence:
				if c.vtype=='DRUM':
					v=MMAmidi.valueToDrum(c.toneList[0])
				else:
					v=MMAmidi.valueToInst(c.voice[0])
				l.append( [c.name, v ] )
			
		defs[ln[0].upper()] = l
		
	elif tp == 'COMMENT':
		pass
				
	else:
		 error("Expecting DOC <FILE | AUTHOR | NOTE | DEFINES> <text>. %s is not valid" % tp)




		
	
