# -------------------------------------------------------------------------
#     This file is part of mMass - the spectrum analysis tool for MS.
#     Copyright (C) 2005-07 Martin Strohalm <mmass@biographics.cz>

#     This program is free software; you can redistribute it and/or modify
#     it under the terms of the GNU General Public License as published by
#     the Free Software Foundation; either version 2 of the License, or
#     (at your option) any later version.

#     This program is distributed in the hope that it will be useful,
#     but WITHOUT ANY WARRANTY; without even the implied warranty of
#     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#     GNU General Public License for more details.

#     Complete text of GNU GPL can be found in the file LICENSE in the
#     main directory of the program
# -------------------------------------------------------------------------

# Function: Modified wx objects.

# load libs
import wx
import wx.lib.mixins.listctrl as listmix


class ListCtrl(wx.ListCtrl, listmix.ListCtrlAutoWidthMixin):
    """ ListCtrl with autowidth. """

    def __init__(self, parent, ID, pos=wx.DefaultPosition, size=wx.DefaultSize, style=None):

        # set style
        if not style and wx.Platform == '__WXMAC__':
            style = wx.LC_REPORT|wx.LC_VRULES|wx.LC_HRULES|wx.SIMPLE_BORDER
        elif not style:
            style = wx.LC_REPORT|wx.LC_VRULES|wx.LC_HRULES

        # init object
        wx.ListCtrl.__init__(self, parent, ID, pos, size, style)

        # row height hack for MSW
        if wx.Platform == '__WXMSW__':
            self.il = wx.ImageList(1, 16)
            self.SetImageList(self.il, wx.IMAGE_LIST_SMALL)

        # set smaller font for Mac
        elif wx.Platform == '__WXMAC__':
            self.SetFont(wx.Font(10, wx.DEFAULT, wx.NORMAL, wx.NORMAL, 0))

        # init mixin
        listmix.ListCtrlAutoWidthMixin.__init__(self)

    def updateLastCol(self):

        # get last col width
        lastCol = self.GetColumnCount()
        width = self.GetColumnWidth(lastCol-1)

        # update size
        self.resizeLastColumn(width)


class GridBagSizer(wx.GridBagSizer):
    """ GridBagSizer with automatic margins. """

    def __init__(self):

        # set gaps
        if wx.Platform == '__WXMAC__':
            vgap = 8
            hgap = 2
        else:
            vgap = 4
            hgap = 2

        # init object
        wx.GridBagSizer.__init__(self, vgap, hgap)


class txtValidator(wx.PyValidator):
    """ Text controls validator. """

    def __init__(self, flag):
        wx.PyValidator.__init__(self)
        self.flag = flag
        self.Bind(wx.EVT_CHAR, self.OnChar)

    def Clone(self):
        return txtValidator(self.flag)

    def TransferToWindow(self):
        return True

    def TransferFromWindow(self):
        return True

    def OnChar(self, evt):
        textCtrl = self.GetWindow()
        value = textCtrl.GetValue()
        key = evt.KeyCode()

        # define navigation keys
        keyCodesNav = (wx.WXK_HOME, wx.WXK_LEFT, wx.WXK_UP,
                        wx.WXK_END, wx.WXK_RIGHT, wx.WXK_DOWN,
                        wx.WXK_NUMPAD_HOME, wx.WXK_NUMPAD_LEFT, wx.WXK_NUMPAD_UP,
                        wx.WXK_NUMPAD_END, wx.WXK_NUMPAD_RIGHT, wx.WXK_NUMPAD_DOWN)

        # navigation keys
        if key in keyCodesNav or key < wx.WXK_SPACE or key == wx.WXK_DELETE:
            evt.Skip()
            return

        # illegal characters
        if key > 255:
            return

        # alpha only
        if self.flag == 'alpha' and chr(key) in string.letters:
            evt.Skip()
            return

        # digits only
        if self.flag == 'digits' and chr(key) in '0123456789':
            evt.Skip()
            return

        # int only
        if self.flag == 'int' and chr(key) in '-0123456789':
            evt.Skip()
            return

        # floats only
        if self.flag == 'float' and (chr(key) in '0123456789.,'):
            if chr(key) not in '.,' or ('.' not in value and ',' not in value):
                evt.Skip()
                return

        # amino acids only
        if self.flag == 'amino' and chr(key) in 'ACDEFGHIKLMNPQRSTVWY':
            evt.Skip()
            return

        # amino acids only (IGNORE CASE)
        if self.flag == 'aminoICase' and chr(key) in 'ACDEFGHIKLMNPQRSTVWYacdefghiklmnpqrstvwy':
            evt.Skip()
            return

        # amino acids regular expression
        if self.flag == 'aminoReg' and chr(key) in 'ACDEFGHIKLMNPQRSTVWYacdefghiklmnpqrstvwy0123456789.^|*+?,()[]{}-=:':
            evt.Skip()
            return

        # formula
        if self.flag == 'formula' and chr(key) in 'ABCDEFGHIJKLMNOPQRSTUWXYZabcdefghijklmnopqrstuwxyz0123456789*+-':
            evt.Skip()
            return

        return


class FileDropTarget(wx.FileDropTarget):
    """ Generig drop target for files. """

    def __init__(self, parent):
        wx.FileDropTarget.__init__(self)
        self.parent = parent

    def OnDropFiles(self, x, y, filenames):
        eval('self.parent.' + self.onDropFce + '(filenames)')

    def SetDropFce(self, name):
        self.onDropFce = name


# ---------
# FUNCTIONS
# ---------


# ----
def getSelectedListItems(myList, reverse=False):
    """ Get indexes of selected list items. """

    # get indexes
    curIndex = -1
    selectedItems = []
    while True:
        curIndex = myList.GetNextItem(curIndex, wx.LIST_NEXT_ALL, wx.LIST_STATE_SELECTED)
        if curIndex is -1:
            break
        else:
            selectedItems.append(curIndex)

    # reverse indexes
    if reverse:
        selectedItems.sort()
        selectedItems.reverse()

    return selectedItems
# ----
