//  $Id: math_.h,v 1.4 2004/01/28 17:22:32 keb Exp $
//  =================================================================
//
//   CCP4 Coordinate Library: support of coordinate-related
//   functionality in protein crystallography applications.
//
//   Copyright (C) Eugene Krissinel 2004.
//
//   This library is free software and is distributed under the terms
//   and conditions of the CCP4 licence agreement as `Part 0' (Annex 2)
//   software, which is version 2.1 of the GNU Lesser General Public
//   Licence (LGPL) with the following additional clause:
//
//      `You may also combine or link a "work that uses the Library"
//      to produce a work containing portions of the Library, and
//      distribute that work under terms of your choice, provided that
//      you give prominent notice with each copy of the work that the
//      specified version of the Library is used in it, and that you
//      include or provide public access to the complete corresponding
//      machine-readable source code for the Library including whatever
//      changes were used in the work. (i.e. If you make changes to the
//      Library you must distribute those, but you do not need to
//      distribute source or object code to those portions of the work
//      not covered by this licence.)'
//
//   Note that this clause grants an additional right and does not
//   impose any additional restriction, and so does not affect
//   compatibility with the GNU General Public Licence (GPL). If you
//   wish to negotiate other terms, please contact the maintainer.
//
//   You can redistribute it and/or modify the library under the terms
//   of the GNU Lesser General Public License as published by the Free
//   Software Foundation; either version 2.1 of the License, or (at
//   your option) any later version.
//
//   This library is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Lesser General Public License for more details.
//
//   You should have received a copy of the CCP4 licence and/or GNU
//   Lesser General Public License along with this library; if not,
//   write to the CCP4 Secretary, Daresbury Laboratory, Warrington
//   WA4 4AD, UK. The GNU Lesser General Public can also be obtained
//   by writing to the Free Software Foundation, Inc., 59 Temple Place,
//   Suite 330, Boston, MA 02111-1307 USA
//
//  =================================================================
//
//    09.04.03   <--  Date of Last Modification.
//                   ~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//  -----------------------------------------------------------------
//
//  **** Module  :  Math_ <interface>
//       ~~~~~~~~~
//  **** Functions :   GetTorsion
//       ~~~~~~~~~~~   GetAngle
//
//  E. Krissinel 2002-2003
//
//  =================================================================
//


#ifndef  __Math__
#define  __Math__

#ifndef  __MatType__
#include "mattype_.h"
#endif


// ----------------------------------------------------------------------

#define  NO_TORSION  (-MaxReal)
//  U[0,1,2] = x,y,z
extern realtype GetTorsion   ( rvector U, rvector W, rvector V );
extern realtype GetAngle     ( rvector U, rvector V );

//  Calculates the binomial coefficient n choose m, 0<=n<=500, 0<=m<=n
extern realtype Combinations ( int n, int m );

//  Calculates precisely log(1-x) for x<1, including very small x
extern realtype log1mx  ( realtype x );

//  Calculates precisely 1 - exp(x) for any x including very small values
extern realtype expc    ( realtype x );

//  Calculates precisely 1-(1-x)**y including very small x and very large y
extern realtype expc1mx ( realtype x, realtype y );



#endif


