//  $Id: mmdb_manager.h,v 1.4 2005/12/19 16:51:28 keb Exp $
//  =================================================================
//
//   CCP4 Coordinate Library: support of coordinate-related
//   functionality in protein crystallography applications.
//
//   Copyright (C) Eugene Krissinel 2004.
//
//   This library is free software and is distributed under the terms
//   and conditions of the CCP4 licence agreement as `Part 0' (Annex 2)
//   software, which is version 2.1 of the GNU Lesser General Public
//   Licence (LGPL) with the following additional clause:
//
//      `You may also combine or link a "work that uses the Library"
//      to produce a work containing portions of the Library, and
//      distribute that work under terms of your choice, provided that
//      you give prominent notice with each copy of the work that the
//      specified version of the Library is used in it, and that you
//      include or provide public access to the complete corresponding
//      machine-readable source code for the Library including whatever
//      changes were used in the work. (i.e. If you make changes to the
//      Library you must distribute those, but you do not need to
//      distribute source or object code to those portions of the work
//      not covered by this licence.)'
//
//   Note that this clause grants an additional right and does not
//   impose any additional restriction, and so does not affect
//   compatibility with the GNU General Public Licence (GPL). If you
//   wish to negotiate other terms, please contact the maintainer.
//
//   You can redistribute it and/or modify the library under the terms
//   of the GNU Lesser General Public License as published by the Free
//   Software Foundation; either version 2.1 of the License, or (at
//   your option) any later version.
//
//   This library is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Lesser General Public License for more details.
//
//   You should have received a copy of the CCP4 licence and/or GNU
//   Lesser General Public License along with this library; if not,
//   write to the CCP4 Secretary, Daresbury Laboratory, Warrington
//   WA4 4AD, UK. The GNU Lesser General Public can also be obtained
//   by writing to the Free Software Foundation, Inc., 59 Temple Place,
//   Suite 330, Boston, MA 02111-1307 USA
//
//  =================================================================
//
//    31.10.02   <--  Date of Last Modification.
//                   ~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//  -----------------------------------------------------------------
//
//  **** Module  :  mmdb_manager <interface>
//       ~~~~~~~~~
//       Project :  MacroMolecular Data Base (MMDB)
//       ~~~~~~~~~
//  **** Classes :  CMMDBManager  ( MMDB file manager )
//       ~~~~~~~~~
//
//  E. Krissinel 2001-2002
//
//  =================================================================
//

#ifndef __MMDB_Manager__
#define __MMDB_Manager__

#ifndef  __MMDB_BondMngr__
#include "mmdb_bondmngr.h"
#endif


// =======================  CMMDBManager  ===========================


// copy masks
#define MMDBFCM_All            0xFFFFFFFF
#define MMDBFCM_Title          0x00000001
#define MMDBFCM_Cryst          0x00000002
#define MMDBFCM_Coord          0x00000004
#define MMDBFCM_SecStruct      0x00000008
#define MMDBFCM_HetInfo        0x00000010
#define MMDBFCM_SA             0x00000020
#define MMDBFCM_SB             0x00000040
#define MMDBFCM_SC             0x00000080
#define MMDBFCM_Footnotes      0x00000100
#define MMDBFCM_ChainAnnot     0x00000200
#define MMDBFCM_Flags          0x00000400
#define MMDBFCM_Buffer         0x80000000
#define MMDBFCM_Top            0xFFFFFFFB

DefineStreamFunctions(CMMDBManager)

class CMMDBManager : public CMMDBBondManager  {

  public :

    CMMDBManager ();
    CMMDBManager ( RPCStream Object );
    ~CMMDBManager();


    //  ---------------  Copying/Deleting  -----------------------

    //   Copy(..) will transfer different sort of information
    // between two MMDB's according to the copy mask given
    // (cf. MMDBFCM_XXXXX values). Note that the copying content
    // replaces the corresponding information (e.g. copying
    // coordinates will replace existing coordinates rather than
    // add to them).
    void  Copy   ( PCMMDBManager MMDB, word CopyMask );

    //   Delete(..) deletes different sort of information from
    // the MMDB according to the delete mask given.
    void  Delete ( word DelMask );  // DelMask is the same as CopyMask

    PCTitleContainer GetRemarks();

  protected :

    //  ---------------  Stream I/O  -----------------------------
    void  write  ( RCFile f );
    void  read   ( RCFile f );

};

#endif

